import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteFleetsRequest, DeleteFleetsResult } from "../models/models_2";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DeleteFleetsCommand}.
 */
export interface DeleteFleetsCommandInput extends DeleteFleetsRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteFleetsCommand}.
 */
export interface DeleteFleetsCommandOutput extends DeleteFleetsResult, __MetadataBearer {
}
declare const DeleteFleetsCommand_base: {
    new (input: DeleteFleetsCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteFleetsCommandInput, DeleteFleetsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: DeleteFleetsCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteFleetsCommandInput, DeleteFleetsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes the specified EC2 Fleets.</p>
 *          <p>After you delete an EC2 Fleet, it launches no new instances.</p>
 *          <p>You must also specify whether a deleted EC2 Fleet should terminate its instances. If you
 *          choose to terminate the instances, the EC2 Fleet enters the <code>deleted_terminating</code>
 *          state. Otherwise, the EC2 Fleet enters the <code>deleted_running</code> state, and the instances
 *          continue to run until they are interrupted or you terminate them manually.</p>
 *          <p>For <code>instant</code> fleets, EC2 Fleet must terminate the instances when the fleet is
 *          deleted. A deleted <code>instant</code> fleet with running instances is not
 *          supported.</p>
 *          <p class="title">
 *             <b>Restrictions</b>
 *          </p>
 *          <ul>
 *             <li>
 *                <p>You can delete up to 25 <code>instant</code> fleets in a single request. If you exceed this
 *                number, no <code>instant</code> fleets are deleted and an error is returned. There is no
 *                restriction on the number of fleets of type <code>maintain</code> or <code>request</code> that can be deleted
 *                in a single request.</p>
 *             </li>
 *             <li>
 *                <p>Up to 1000 instances can be terminated in a single request to delete
 *                <code>instant</code> fleets.</p>
 *             </li>
 *          </ul>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet">Delete an EC2
 *          Fleet</a> in the <i>Amazon EC2 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteFleetsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteFleetsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeleteFleetsRequest
 *   DryRun: true || false,
 *   FleetIds: [ // FleetIdSet // required
 *     "STRING_VALUE",
 *   ],
 *   TerminateInstances: true || false, // required
 * };
 * const command = new DeleteFleetsCommand(input);
 * const response = await client.send(command);
 * // { // DeleteFleetsResult
 * //   SuccessfulFleetDeletions: [ // DeleteFleetSuccessSet
 * //     { // DeleteFleetSuccessItem
 * //       CurrentFleetState: "submitted" || "active" || "deleted" || "failed" || "deleted_running" || "deleted_terminating" || "modifying",
 * //       PreviousFleetState: "submitted" || "active" || "deleted" || "failed" || "deleted_running" || "deleted_terminating" || "modifying",
 * //       FleetId: "STRING_VALUE",
 * //     },
 * //   ],
 * //   UnsuccessfulFleetDeletions: [ // DeleteFleetErrorSet
 * //     { // DeleteFleetErrorItem
 * //       Error: { // DeleteFleetError
 * //         Code: "fleetIdDoesNotExist" || "fleetIdMalformed" || "fleetNotInDeletableState" || "unexpectedError",
 * //         Message: "STRING_VALUE",
 * //       },
 * //       FleetId: "STRING_VALUE",
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param DeleteFleetsCommandInput - {@link DeleteFleetsCommandInput}
 * @returns {@link DeleteFleetsCommandOutput}
 * @see {@link DeleteFleetsCommandInput} for command's `input` shape.
 * @see {@link DeleteFleetsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class DeleteFleetsCommand extends DeleteFleetsCommand_base {
}
