import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteFpgaImageRequest, DeleteFpgaImageResult } from "../models/models_2";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DeleteFpgaImageCommand}.
 */
export interface DeleteFpgaImageCommandInput extends DeleteFpgaImageRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteFpgaImageCommand}.
 */
export interface DeleteFpgaImageCommandOutput extends DeleteFpgaImageResult, __MetadataBearer {
}
declare const DeleteFpgaImageCommand_base: {
    new (input: DeleteFpgaImageCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteFpgaImageCommandInput, DeleteFpgaImageCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: DeleteFpgaImageCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteFpgaImageCommandInput, DeleteFpgaImageCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes the specified Amazon FPGA Image (AFI).</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteFpgaImageCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteFpgaImageCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeleteFpgaImageRequest
 *   DryRun: true || false,
 *   FpgaImageId: "STRING_VALUE", // required
 * };
 * const command = new DeleteFpgaImageCommand(input);
 * const response = await client.send(command);
 * // { // DeleteFpgaImageResult
 * //   Return: true || false,
 * // };
 *
 * ```
 *
 * @param DeleteFpgaImageCommandInput - {@link DeleteFpgaImageCommandInput}
 * @returns {@link DeleteFpgaImageCommandOutput}
 * @see {@link DeleteFpgaImageCommandInput} for command's `input` shape.
 * @see {@link DeleteFpgaImageCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class DeleteFpgaImageCommand extends DeleteFpgaImageCommand_base {
}
