import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteInternetGatewayRequest } from "../models/models_2";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DeleteInternetGatewayCommand}.
 */
export interface DeleteInternetGatewayCommandInput extends DeleteInternetGatewayRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteInternetGatewayCommand}.
 */
export interface DeleteInternetGatewayCommandOutput extends __MetadataBearer {
}
declare const DeleteInternetGatewayCommand_base: {
    new (input: DeleteInternetGatewayCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteInternetGatewayCommandInput, DeleteInternetGatewayCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: DeleteInternetGatewayCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteInternetGatewayCommandInput, DeleteInternetGatewayCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes the specified internet gateway. You must detach the internet gateway from the
 * 			VPC before you can delete it.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteInternetGatewayCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteInternetGatewayCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeleteInternetGatewayRequest
 *   DryRun: true || false,
 *   InternetGatewayId: "STRING_VALUE", // required
 * };
 * const command = new DeleteInternetGatewayCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DeleteInternetGatewayCommandInput - {@link DeleteInternetGatewayCommandInput}
 * @returns {@link DeleteInternetGatewayCommandOutput}
 * @see {@link DeleteInternetGatewayCommandInput} for command's `input` shape.
 * @see {@link DeleteInternetGatewayCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 * @example To delete an Internet gateway
 * ```javascript
 * // This example deletes the specified Internet gateway.
 * const input = {
 *   "InternetGatewayId": "igw-c0a643a9"
 * };
 * const command = new DeleteInternetGatewayCommand(input);
 * await client.send(command);
 * // example id: ec2-delete-internet-gateway-1
 * ```
 *
 */
export declare class DeleteInternetGatewayCommand extends DeleteInternetGatewayCommand_base {
}
