import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteKeyPairRequest, DeleteKeyPairResult } from "../models/models_2";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DeleteKeyPairCommand}.
 */
export interface DeleteKeyPairCommandInput extends DeleteKeyPairRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteKeyPairCommand}.
 */
export interface DeleteKeyPairCommandOutput extends DeleteKeyPairResult, __MetadataBearer {
}
declare const DeleteKeyPairCommand_base: {
    new (input: DeleteKeyPairCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteKeyPairCommandInput, DeleteKeyPairCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DeleteKeyPairCommandInput]): import("@smithy/smithy-client").CommandImpl<DeleteKeyPairCommandInput, DeleteKeyPairCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes the specified key pair, by removing the public key from Amazon EC2.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteKeyPairCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteKeyPairCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeleteKeyPairRequest
 *   KeyName: "STRING_VALUE",
 *   KeyPairId: "STRING_VALUE",
 *   DryRun: true || false,
 * };
 * const command = new DeleteKeyPairCommand(input);
 * const response = await client.send(command);
 * // { // DeleteKeyPairResult
 * //   Return: true || false,
 * //   KeyPairId: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DeleteKeyPairCommandInput - {@link DeleteKeyPairCommandInput}
 * @returns {@link DeleteKeyPairCommandOutput}
 * @see {@link DeleteKeyPairCommandInput} for command's `input` shape.
 * @see {@link DeleteKeyPairCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 * @example To delete a key pair
 * ```javascript
 * // This example deletes the specified key pair.
 * const input = {
 *   "KeyName": "my-key-pair"
 * };
 * const command = new DeleteKeyPairCommand(input);
 * await client.send(command);
 * // example id: ec2-delete-key-pair-1
 * ```
 *
 */
export declare class DeleteKeyPairCommand extends DeleteKeyPairCommand_base {
}
