import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteNetworkAclRequest } from "../models/models_3";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DeleteNetworkAclCommand}.
 */
export interface DeleteNetworkAclCommandInput extends DeleteNetworkAclRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteNetworkAclCommand}.
 */
export interface DeleteNetworkAclCommandOutput extends __MetadataBearer {
}
declare const DeleteNetworkAclCommand_base: {
    new (input: DeleteNetworkAclCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteNetworkAclCommandInput, DeleteNetworkAclCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: DeleteNetworkAclCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteNetworkAclCommandInput, DeleteNetworkAclCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete the default network ACL.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteNetworkAclCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteNetworkAclCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeleteNetworkAclRequest
 *   DryRun: true || false,
 *   NetworkAclId: "STRING_VALUE", // required
 * };
 * const command = new DeleteNetworkAclCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DeleteNetworkAclCommandInput - {@link DeleteNetworkAclCommandInput}
 * @returns {@link DeleteNetworkAclCommandOutput}
 * @see {@link DeleteNetworkAclCommandInput} for command's `input` shape.
 * @see {@link DeleteNetworkAclCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 * @example To delete a network ACL
 * ```javascript
 * // This example deletes the specified network ACL.
 * const input = {
 *   "NetworkAclId": "acl-5fb85d36"
 * };
 * const command = new DeleteNetworkAclCommand(input);
 * await client.send(command);
 * // example id: ec2-delete-network-acl-1
 * ```
 *
 */
export declare class DeleteNetworkAclCommand extends DeleteNetworkAclCommand_base {
}
