import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteNetworkAclEntryRequest } from "../models/models_3";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DeleteNetworkAclEntryCommand}.
 */
export interface DeleteNetworkAclEntryCommandInput extends DeleteNetworkAclEntryRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteNetworkAclEntryCommand}.
 */
export interface DeleteNetworkAclEntryCommandOutput extends __MetadataBearer {
}
declare const DeleteNetworkAclEntryCommand_base: {
    new (input: DeleteNetworkAclEntryCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteNetworkAclEntryCommandInput, DeleteNetworkAclEntryCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: DeleteNetworkAclEntryCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteNetworkAclEntryCommandInput, DeleteNetworkAclEntryCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes the specified ingress or egress entry (rule) from the specified network ACL.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteNetworkAclEntryCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteNetworkAclEntryCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeleteNetworkAclEntryRequest
 *   DryRun: true || false,
 *   Egress: true || false, // required
 *   NetworkAclId: "STRING_VALUE", // required
 *   RuleNumber: Number("int"), // required
 * };
 * const command = new DeleteNetworkAclEntryCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DeleteNetworkAclEntryCommandInput - {@link DeleteNetworkAclEntryCommandInput}
 * @returns {@link DeleteNetworkAclEntryCommandOutput}
 * @see {@link DeleteNetworkAclEntryCommandInput} for command's `input` shape.
 * @see {@link DeleteNetworkAclEntryCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 * @example To delete a network ACL entry
 * ```javascript
 * // This example deletes ingress rule number 100 from the specified network ACL.
 * const input = {
 *   "Egress": true,
 *   "NetworkAclId": "acl-5fb85d36",
 *   "RuleNumber": 100
 * };
 * const command = new DeleteNetworkAclEntryCommand(input);
 * await client.send(command);
 * // example id: ec2-delete-network-acl-entry-1
 * ```
 *
 */
export declare class DeleteNetworkAclEntryCommand extends DeleteNetworkAclEntryCommand_base {
}
