import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteNetworkInsightsAccessScopeAnalysisRequest, DeleteNetworkInsightsAccessScopeAnalysisResult } from "../models/models_3";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DeleteNetworkInsightsAccessScopeAnalysisCommand}.
 */
export interface DeleteNetworkInsightsAccessScopeAnalysisCommandInput extends DeleteNetworkInsightsAccessScopeAnalysisRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteNetworkInsightsAccessScopeAnalysisCommand}.
 */
export interface DeleteNetworkInsightsAccessScopeAnalysisCommandOutput extends DeleteNetworkInsightsAccessScopeAnalysisResult, __MetadataBearer {
}
declare const DeleteNetworkInsightsAccessScopeAnalysisCommand_base: {
    new (input: DeleteNetworkInsightsAccessScopeAnalysisCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteNetworkInsightsAccessScopeAnalysisCommandInput, DeleteNetworkInsightsAccessScopeAnalysisCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: DeleteNetworkInsightsAccessScopeAnalysisCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteNetworkInsightsAccessScopeAnalysisCommandInput, DeleteNetworkInsightsAccessScopeAnalysisCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes the specified Network Access Scope analysis.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteNetworkInsightsAccessScopeAnalysisCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteNetworkInsightsAccessScopeAnalysisCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeleteNetworkInsightsAccessScopeAnalysisRequest
 *   NetworkInsightsAccessScopeAnalysisId: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new DeleteNetworkInsightsAccessScopeAnalysisCommand(input);
 * const response = await client.send(command);
 * // { // DeleteNetworkInsightsAccessScopeAnalysisResult
 * //   NetworkInsightsAccessScopeAnalysisId: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DeleteNetworkInsightsAccessScopeAnalysisCommandInput - {@link DeleteNetworkInsightsAccessScopeAnalysisCommandInput}
 * @returns {@link DeleteNetworkInsightsAccessScopeAnalysisCommandOutput}
 * @see {@link DeleteNetworkInsightsAccessScopeAnalysisCommandInput} for command's `input` shape.
 * @see {@link DeleteNetworkInsightsAccessScopeAnalysisCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class DeleteNetworkInsightsAccessScopeAnalysisCommand extends DeleteNetworkInsightsAccessScopeAnalysisCommand_base {
}
