import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteNetworkInterfaceRequest } from "../models/models_3";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DeleteNetworkInterfaceCommand}.
 */
export interface DeleteNetworkInterfaceCommandInput extends DeleteNetworkInterfaceRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteNetworkInterfaceCommand}.
 */
export interface DeleteNetworkInterfaceCommandOutput extends __MetadataBearer {
}
declare const DeleteNetworkInterfaceCommand_base: {
    new (input: DeleteNetworkInterfaceCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteNetworkInterfaceCommandInput, DeleteNetworkInterfaceCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: DeleteNetworkInterfaceCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteNetworkInterfaceCommandInput, DeleteNetworkInterfaceCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes the specified network interface. You must detach the network interface before you can delete it.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteNetworkInterfaceCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteNetworkInterfaceCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeleteNetworkInterfaceRequest
 *   DryRun: true || false,
 *   NetworkInterfaceId: "STRING_VALUE", // required
 * };
 * const command = new DeleteNetworkInterfaceCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DeleteNetworkInterfaceCommandInput - {@link DeleteNetworkInterfaceCommandInput}
 * @returns {@link DeleteNetworkInterfaceCommandOutput}
 * @see {@link DeleteNetworkInterfaceCommandInput} for command's `input` shape.
 * @see {@link DeleteNetworkInterfaceCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 * @example To delete a network interface
 * ```javascript
 * // This example deletes the specified network interface.
 * const input = {
 *   "NetworkInterfaceId": "eni-e5aa89a3"
 * };
 * const command = new DeleteNetworkInterfaceCommand(input);
 * await client.send(command);
 * // example id: ec2-delete-network-interface-1
 * ```
 *
 */
export declare class DeleteNetworkInterfaceCommand extends DeleteNetworkInterfaceCommand_base {
}
