import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteSpotDatafeedSubscriptionRequest } from "../models/models_3";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DeleteSpotDatafeedSubscriptionCommand}.
 */
export interface DeleteSpotDatafeedSubscriptionCommandInput extends DeleteSpotDatafeedSubscriptionRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteSpotDatafeedSubscriptionCommand}.
 */
export interface DeleteSpotDatafeedSubscriptionCommandOutput extends __MetadataBearer {
}
declare const DeleteSpotDatafeedSubscriptionCommand_base: {
    new (input: DeleteSpotDatafeedSubscriptionCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteSpotDatafeedSubscriptionCommandInput, DeleteSpotDatafeedSubscriptionCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DeleteSpotDatafeedSubscriptionCommandInput]): import("@smithy/smithy-client").CommandImpl<DeleteSpotDatafeedSubscriptionCommandInput, DeleteSpotDatafeedSubscriptionCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes the data feed for Spot Instances.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteSpotDatafeedSubscriptionCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteSpotDatafeedSubscriptionCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeleteSpotDatafeedSubscriptionRequest
 *   DryRun: true || false,
 * };
 * const command = new DeleteSpotDatafeedSubscriptionCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DeleteSpotDatafeedSubscriptionCommandInput - {@link DeleteSpotDatafeedSubscriptionCommandInput}
 * @returns {@link DeleteSpotDatafeedSubscriptionCommandOutput}
 * @see {@link DeleteSpotDatafeedSubscriptionCommandInput} for command's `input` shape.
 * @see {@link DeleteSpotDatafeedSubscriptionCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 * @example To cancel a Spot Instance data feed subscription
 * ```javascript
 * // This example deletes a Spot data feed subscription for the account.
 * const input = {};
 * const command = new DeleteSpotDatafeedSubscriptionCommand(input);
 * await client.send(command);
 * // example id: ec2-delete-spot-datafeed-subscription-1
 * ```
 *
 */
export declare class DeleteSpotDatafeedSubscriptionCommand extends DeleteSpotDatafeedSubscriptionCommand_base {
}
