import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteTransitGatewayPolicyTableRequest, DeleteTransitGatewayPolicyTableResult } from "../models/models_3";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DeleteTransitGatewayPolicyTableCommand}.
 */
export interface DeleteTransitGatewayPolicyTableCommandInput extends DeleteTransitGatewayPolicyTableRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteTransitGatewayPolicyTableCommand}.
 */
export interface DeleteTransitGatewayPolicyTableCommandOutput extends DeleteTransitGatewayPolicyTableResult, __MetadataBearer {
}
declare const DeleteTransitGatewayPolicyTableCommand_base: {
    new (input: DeleteTransitGatewayPolicyTableCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteTransitGatewayPolicyTableCommandInput, DeleteTransitGatewayPolicyTableCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: DeleteTransitGatewayPolicyTableCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteTransitGatewayPolicyTableCommandInput, DeleteTransitGatewayPolicyTableCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes the specified transit gateway policy table.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteTransitGatewayPolicyTableCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteTransitGatewayPolicyTableCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeleteTransitGatewayPolicyTableRequest
 *   TransitGatewayPolicyTableId: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new DeleteTransitGatewayPolicyTableCommand(input);
 * const response = await client.send(command);
 * // { // DeleteTransitGatewayPolicyTableResult
 * //   TransitGatewayPolicyTable: { // TransitGatewayPolicyTable
 * //     TransitGatewayPolicyTableId: "STRING_VALUE",
 * //     TransitGatewayId: "STRING_VALUE",
 * //     State: "pending" || "available" || "deleting" || "deleted",
 * //     CreationTime: new Date("TIMESTAMP"),
 * //     Tags: [ // TagList
 * //       { // Tag
 * //         Key: "STRING_VALUE",
 * //         Value: "STRING_VALUE",
 * //       },
 * //     ],
 * //   },
 * // };
 *
 * ```
 *
 * @param DeleteTransitGatewayPolicyTableCommandInput - {@link DeleteTransitGatewayPolicyTableCommandInput}
 * @returns {@link DeleteTransitGatewayPolicyTableCommandOutput}
 * @see {@link DeleteTransitGatewayPolicyTableCommandInput} for command's `input` shape.
 * @see {@link DeleteTransitGatewayPolicyTableCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class DeleteTransitGatewayPolicyTableCommand extends DeleteTransitGatewayPolicyTableCommand_base {
}
