import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteVpnConnectionRouteRequest } from "../models/models_3";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DeleteVpnConnectionRouteCommand}.
 */
export interface DeleteVpnConnectionRouteCommandInput extends DeleteVpnConnectionRouteRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteVpnConnectionRouteCommand}.
 */
export interface DeleteVpnConnectionRouteCommandOutput extends __MetadataBearer {
}
declare const DeleteVpnConnectionRouteCommand_base: {
    new (input: DeleteVpnConnectionRouteCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteVpnConnectionRouteCommandInput, DeleteVpnConnectionRouteCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: DeleteVpnConnectionRouteCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteVpnConnectionRouteCommandInput, DeleteVpnConnectionRouteCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes the specified static route associated with a VPN connection between an
 *             existing virtual private gateway and a VPN customer gateway. The static route allows
 *             traffic to be routed from the virtual private gateway to the VPN customer
 *             gateway.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteVpnConnectionRouteCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteVpnConnectionRouteCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DeleteVpnConnectionRouteRequest
 *   DestinationCidrBlock: "STRING_VALUE", // required
 *   VpnConnectionId: "STRING_VALUE", // required
 * };
 * const command = new DeleteVpnConnectionRouteCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DeleteVpnConnectionRouteCommandInput - {@link DeleteVpnConnectionRouteCommandInput}
 * @returns {@link DeleteVpnConnectionRouteCommandOutput}
 * @see {@link DeleteVpnConnectionRouteCommandInput} for command's `input` shape.
 * @see {@link DeleteVpnConnectionRouteCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class DeleteVpnConnectionRouteCommand extends DeleteVpnConnectionRouteCommand_base {
}
