import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeAddressesAttributeRequest, DescribeAddressesAttributeResult } from "../models/models_3";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DescribeAddressesAttributeCommand}.
 */
export interface DescribeAddressesAttributeCommandInput extends DescribeAddressesAttributeRequest {
}
/**
 * @public
 *
 * The output of {@link DescribeAddressesAttributeCommand}.
 */
export interface DescribeAddressesAttributeCommandOutput extends DescribeAddressesAttributeResult, __MetadataBearer {
}
declare const DescribeAddressesAttributeCommand_base: {
    new (input: DescribeAddressesAttributeCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeAddressesAttributeCommandInput, DescribeAddressesAttributeCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DescribeAddressesAttributeCommandInput]): import("@smithy/smithy-client").CommandImpl<DescribeAddressesAttributeCommandInput, DescribeAddressesAttributeCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes the attributes of the specified Elastic IP addresses. For requirements, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS">Using reverse DNS for email applications</a>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeAddressesAttributeCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeAddressesAttributeCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DescribeAddressesAttributeRequest
 *   AllocationIds: [ // AllocationIds
 *     "STRING_VALUE",
 *   ],
 *   Attribute: "domain-name",
 *   NextToken: "STRING_VALUE",
 *   MaxResults: Number("int"),
 *   DryRun: true || false,
 * };
 * const command = new DescribeAddressesAttributeCommand(input);
 * const response = await client.send(command);
 * // { // DescribeAddressesAttributeResult
 * //   Addresses: [ // AddressSet
 * //     { // AddressAttribute
 * //       PublicIp: "STRING_VALUE",
 * //       AllocationId: "STRING_VALUE",
 * //       PtrRecord: "STRING_VALUE",
 * //       PtrRecordUpdate: { // PtrUpdateStatus
 * //         Value: "STRING_VALUE",
 * //         Status: "STRING_VALUE",
 * //         Reason: "STRING_VALUE",
 * //       },
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DescribeAddressesAttributeCommandInput - {@link DescribeAddressesAttributeCommandInput}
 * @returns {@link DescribeAddressesAttributeCommandOutput}
 * @see {@link DescribeAddressesAttributeCommandInput} for command's `input` shape.
 * @see {@link DescribeAddressesAttributeCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class DescribeAddressesAttributeCommand extends DescribeAddressesAttributeCommand_base {
}
