import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeAwsNetworkPerformanceMetricSubscriptionsRequest, DescribeAwsNetworkPerformanceMetricSubscriptionsResult } from "../models/models_3";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DescribeAwsNetworkPerformanceMetricSubscriptionsCommand}.
 */
export interface DescribeAwsNetworkPerformanceMetricSubscriptionsCommandInput extends DescribeAwsNetworkPerformanceMetricSubscriptionsRequest {
}
/**
 * @public
 *
 * The output of {@link DescribeAwsNetworkPerformanceMetricSubscriptionsCommand}.
 */
export interface DescribeAwsNetworkPerformanceMetricSubscriptionsCommandOutput extends DescribeAwsNetworkPerformanceMetricSubscriptionsResult, __MetadataBearer {
}
declare const DescribeAwsNetworkPerformanceMetricSubscriptionsCommand_base: {
    new (input: DescribeAwsNetworkPerformanceMetricSubscriptionsCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeAwsNetworkPerformanceMetricSubscriptionsCommandInput, DescribeAwsNetworkPerformanceMetricSubscriptionsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DescribeAwsNetworkPerformanceMetricSubscriptionsCommandInput]): import("@smithy/smithy-client").CommandImpl<DescribeAwsNetworkPerformanceMetricSubscriptionsCommandInput, DescribeAwsNetworkPerformanceMetricSubscriptionsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes the current Infrastructure Performance metric subscriptions.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeAwsNetworkPerformanceMetricSubscriptionsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeAwsNetworkPerformanceMetricSubscriptionsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DescribeAwsNetworkPerformanceMetricSubscriptionsRequest
 *   MaxResults: Number("int"),
 *   NextToken: "STRING_VALUE",
 *   Filters: [ // FilterList
 *     { // Filter
 *       Name: "STRING_VALUE",
 *       Values: [ // ValueStringList
 *         "STRING_VALUE",
 *       ],
 *     },
 *   ],
 *   DryRun: true || false,
 * };
 * const command = new DescribeAwsNetworkPerformanceMetricSubscriptionsCommand(input);
 * const response = await client.send(command);
 * // { // DescribeAwsNetworkPerformanceMetricSubscriptionsResult
 * //   NextToken: "STRING_VALUE",
 * //   Subscriptions: [ // SubscriptionList
 * //     { // Subscription
 * //       Source: "STRING_VALUE",
 * //       Destination: "STRING_VALUE",
 * //       Metric: "aggregate-latency",
 * //       Statistic: "p50",
 * //       Period: "five-minutes" || "fifteen-minutes" || "one-hour" || "three-hours" || "one-day" || "one-week",
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param DescribeAwsNetworkPerformanceMetricSubscriptionsCommandInput - {@link DescribeAwsNetworkPerformanceMetricSubscriptionsCommandInput}
 * @returns {@link DescribeAwsNetworkPerformanceMetricSubscriptionsCommandOutput}
 * @see {@link DescribeAwsNetworkPerformanceMetricSubscriptionsCommandInput} for command's `input` shape.
 * @see {@link DescribeAwsNetworkPerformanceMetricSubscriptionsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class DescribeAwsNetworkPerformanceMetricSubscriptionsCommand extends DescribeAwsNetworkPerformanceMetricSubscriptionsCommand_base {
}
