import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeCapacityReservationsRequest, DescribeCapacityReservationsResult } from "../models/models_3";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DescribeCapacityReservationsCommand}.
 */
export interface DescribeCapacityReservationsCommandInput extends DescribeCapacityReservationsRequest {
}
/**
 * @public
 *
 * The output of {@link DescribeCapacityReservationsCommand}.
 */
export interface DescribeCapacityReservationsCommandOutput extends DescribeCapacityReservationsResult, __MetadataBearer {
}
declare const DescribeCapacityReservationsCommand_base: {
    new (input: DescribeCapacityReservationsCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeCapacityReservationsCommandInput, DescribeCapacityReservationsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DescribeCapacityReservationsCommandInput]): import("@smithy/smithy-client").CommandImpl<DescribeCapacityReservationsCommandInput, DescribeCapacityReservationsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the
 * 		    	Amazon Web Services Region that you're currently using.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeCapacityReservationsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeCapacityReservationsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DescribeCapacityReservationsRequest
 *   CapacityReservationIds: [ // CapacityReservationIdSet
 *     "STRING_VALUE",
 *   ],
 *   NextToken: "STRING_VALUE",
 *   MaxResults: Number("int"),
 *   Filters: [ // FilterList
 *     { // Filter
 *       Name: "STRING_VALUE",
 *       Values: [ // ValueStringList
 *         "STRING_VALUE",
 *       ],
 *     },
 *   ],
 *   DryRun: true || false,
 * };
 * const command = new DescribeCapacityReservationsCommand(input);
 * const response = await client.send(command);
 * // { // DescribeCapacityReservationsResult
 * //   NextToken: "STRING_VALUE",
 * //   CapacityReservations: [ // CapacityReservationSet
 * //     { // CapacityReservation
 * //       CapacityReservationId: "STRING_VALUE",
 * //       OwnerId: "STRING_VALUE",
 * //       CapacityReservationArn: "STRING_VALUE",
 * //       AvailabilityZoneId: "STRING_VALUE",
 * //       InstanceType: "STRING_VALUE",
 * //       InstancePlatform: "Linux/UNIX" || "Red Hat Enterprise Linux" || "SUSE Linux" || "Windows" || "Windows with SQL Server" || "Windows with SQL Server Enterprise" || "Windows with SQL Server Standard" || "Windows with SQL Server Web" || "Linux with SQL Server Standard" || "Linux with SQL Server Web" || "Linux with SQL Server Enterprise" || "RHEL with SQL Server Standard" || "RHEL with SQL Server Enterprise" || "RHEL with SQL Server Web" || "RHEL with HA" || "RHEL with HA and SQL Server Standard" || "RHEL with HA and SQL Server Enterprise" || "Ubuntu Pro",
 * //       AvailabilityZone: "STRING_VALUE",
 * //       Tenancy: "default" || "dedicated",
 * //       TotalInstanceCount: Number("int"),
 * //       AvailableInstanceCount: Number("int"),
 * //       EbsOptimized: true || false,
 * //       EphemeralStorage: true || false,
 * //       State: "active" || "expired" || "cancelled" || "pending" || "failed" || "scheduled" || "payment-pending" || "payment-failed",
 * //       StartDate: new Date("TIMESTAMP"),
 * //       EndDate: new Date("TIMESTAMP"),
 * //       EndDateType: "unlimited" || "limited",
 * //       InstanceMatchCriteria: "open" || "targeted",
 * //       CreateDate: new Date("TIMESTAMP"),
 * //       Tags: [ // TagList
 * //         { // Tag
 * //           Key: "STRING_VALUE",
 * //           Value: "STRING_VALUE",
 * //         },
 * //       ],
 * //       OutpostArn: "STRING_VALUE",
 * //       CapacityReservationFleetId: "STRING_VALUE",
 * //       PlacementGroupArn: "STRING_VALUE",
 * //       CapacityAllocations: [ // CapacityAllocations
 * //         { // CapacityAllocation
 * //           AllocationType: "used",
 * //           Count: Number("int"),
 * //         },
 * //       ],
 * //       ReservationType: "default" || "capacity-block",
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param DescribeCapacityReservationsCommandInput - {@link DescribeCapacityReservationsCommandInput}
 * @returns {@link DescribeCapacityReservationsCommandOutput}
 * @see {@link DescribeCapacityReservationsCommandInput} for command's `input` shape.
 * @see {@link DescribeCapacityReservationsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class DescribeCapacityReservationsCommand extends DescribeCapacityReservationsCommand_base {
}
