import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeElasticGpusRequest, DescribeElasticGpusResult } from "../models/models_3";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DescribeElasticGpusCommand}.
 */
export interface DescribeElasticGpusCommandInput extends DescribeElasticGpusRequest {
}
/**
 * @public
 *
 * The output of {@link DescribeElasticGpusCommand}.
 */
export interface DescribeElasticGpusCommandOutput extends DescribeElasticGpusResult, __MetadataBearer {
}
declare const DescribeElasticGpusCommand_base: {
    new (input: DescribeElasticGpusCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeElasticGpusCommandInput, DescribeElasticGpusCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DescribeElasticGpusCommandInput]): import("@smithy/smithy-client").CommandImpl<DescribeElasticGpusCommandInput, DescribeElasticGpusCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <note>
 *             <p>Amazon Elastic Graphics reached end of life on January 8, 2024. For
 *                 workloads that require graphics acceleration, we recommend that you use Amazon EC2 G4ad,
 *                 G4dn, or G5 instances.</p>
 *          </note>
 *          <p>Describes the Elastic Graphics accelerator associated with your instances. For more information
 *             about Elastic Graphics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon Elastic Graphics</a>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeElasticGpusCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeElasticGpusCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DescribeElasticGpusRequest
 *   ElasticGpuIds: [ // ElasticGpuIdSet
 *     "STRING_VALUE",
 *   ],
 *   DryRun: true || false,
 *   Filters: [ // FilterList
 *     { // Filter
 *       Name: "STRING_VALUE",
 *       Values: [ // ValueStringList
 *         "STRING_VALUE",
 *       ],
 *     },
 *   ],
 *   MaxResults: Number("int"),
 *   NextToken: "STRING_VALUE",
 * };
 * const command = new DescribeElasticGpusCommand(input);
 * const response = await client.send(command);
 * // { // DescribeElasticGpusResult
 * //   ElasticGpuSet: [ // ElasticGpuSet
 * //     { // ElasticGpus
 * //       ElasticGpuId: "STRING_VALUE",
 * //       AvailabilityZone: "STRING_VALUE",
 * //       ElasticGpuType: "STRING_VALUE",
 * //       ElasticGpuHealth: { // ElasticGpuHealth
 * //         Status: "OK" || "IMPAIRED",
 * //       },
 * //       ElasticGpuState: "ATTACHED",
 * //       InstanceId: "STRING_VALUE",
 * //       Tags: [ // TagList
 * //         { // Tag
 * //           Key: "STRING_VALUE",
 * //           Value: "STRING_VALUE",
 * //         },
 * //       ],
 * //     },
 * //   ],
 * //   MaxResults: Number("int"),
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DescribeElasticGpusCommandInput - {@link DescribeElasticGpusCommandInput}
 * @returns {@link DescribeElasticGpusCommandOutput}
 * @see {@link DescribeElasticGpusCommandInput} for command's `input` shape.
 * @see {@link DescribeElasticGpusCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class DescribeElasticGpusCommand extends DescribeElasticGpusCommand_base {
}
