import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeFleetInstancesRequest, DescribeFleetInstancesResult } from "../models/models_3";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DescribeFleetInstancesCommand}.
 */
export interface DescribeFleetInstancesCommandInput extends DescribeFleetInstancesRequest {
}
/**
 * @public
 *
 * The output of {@link DescribeFleetInstancesCommand}.
 */
export interface DescribeFleetInstancesCommandOutput extends DescribeFleetInstancesResult, __MetadataBearer {
}
declare const DescribeFleetInstancesCommand_base: {
    new (input: DescribeFleetInstancesCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeFleetInstancesCommandInput, DescribeFleetInstancesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: DescribeFleetInstancesCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeFleetInstancesCommandInput, DescribeFleetInstancesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes the running instances for the specified EC2 Fleet.</p>
 *          <note>
 *             <p>Currently, <code>DescribeFleetInstances</code> does not support fleets of type
 *                <code>instant</code>. Instead, use <code>DescribeFleets</code>, specifying the
 *                <code>instant</code> fleet ID in the request.</p>
 *          </note>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#monitor-ec2-fleet">Describe your
 *             EC2 Fleet</a> in the <i>Amazon EC2 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeFleetInstancesCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeFleetInstancesCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DescribeFleetInstancesRequest
 *   DryRun: true || false,
 *   MaxResults: Number("int"),
 *   NextToken: "STRING_VALUE",
 *   FleetId: "STRING_VALUE", // required
 *   Filters: [ // FilterList
 *     { // Filter
 *       Name: "STRING_VALUE",
 *       Values: [ // ValueStringList
 *         "STRING_VALUE",
 *       ],
 *     },
 *   ],
 * };
 * const command = new DescribeFleetInstancesCommand(input);
 * const response = await client.send(command);
 * // { // DescribeFleetInstancesResult
 * //   ActiveInstances: [ // ActiveInstanceSet
 * //     { // ActiveInstance
 * //       InstanceId: "STRING_VALUE",
 * //       InstanceType: "STRING_VALUE",
 * //       SpotInstanceRequestId: "STRING_VALUE",
 * //       InstanceHealth: "healthy" || "unhealthy",
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * //   FleetId: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DescribeFleetInstancesCommandInput - {@link DescribeFleetInstancesCommandInput}
 * @returns {@link DescribeFleetInstancesCommandOutput}
 * @see {@link DescribeFleetInstancesCommandInput} for command's `input` shape.
 * @see {@link DescribeFleetInstancesCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class DescribeFleetInstancesCommand extends DescribeFleetInstancesCommand_base {
}
