import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeLaunchTemplatesRequest, DescribeLaunchTemplatesResult } from "../models/models_4";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DescribeLaunchTemplatesCommand}.
 */
export interface DescribeLaunchTemplatesCommandInput extends DescribeLaunchTemplatesRequest {
}
/**
 * @public
 *
 * The output of {@link DescribeLaunchTemplatesCommand}.
 */
export interface DescribeLaunchTemplatesCommandOutput extends DescribeLaunchTemplatesResult, __MetadataBearer {
}
declare const DescribeLaunchTemplatesCommand_base: {
    new (input: DescribeLaunchTemplatesCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeLaunchTemplatesCommandInput, DescribeLaunchTemplatesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DescribeLaunchTemplatesCommandInput]): import("@smithy/smithy-client").CommandImpl<DescribeLaunchTemplatesCommandInput, DescribeLaunchTemplatesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes one or more launch templates.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeLaunchTemplatesCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeLaunchTemplatesCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DescribeLaunchTemplatesRequest
 *   DryRun: true || false,
 *   LaunchTemplateIds: [ // LaunchTemplateIdStringList
 *     "STRING_VALUE",
 *   ],
 *   LaunchTemplateNames: [ // LaunchTemplateNameStringList
 *     "STRING_VALUE",
 *   ],
 *   Filters: [ // FilterList
 *     { // Filter
 *       Name: "STRING_VALUE",
 *       Values: [ // ValueStringList
 *         "STRING_VALUE",
 *       ],
 *     },
 *   ],
 *   NextToken: "STRING_VALUE",
 *   MaxResults: Number("int"),
 * };
 * const command = new DescribeLaunchTemplatesCommand(input);
 * const response = await client.send(command);
 * // { // DescribeLaunchTemplatesResult
 * //   LaunchTemplates: [ // LaunchTemplateSet
 * //     { // LaunchTemplate
 * //       LaunchTemplateId: "STRING_VALUE",
 * //       LaunchTemplateName: "STRING_VALUE",
 * //       CreateTime: new Date("TIMESTAMP"),
 * //       CreatedBy: "STRING_VALUE",
 * //       DefaultVersionNumber: Number("long"),
 * //       LatestVersionNumber: Number("long"),
 * //       Tags: [ // TagList
 * //         { // Tag
 * //           Key: "STRING_VALUE",
 * //           Value: "STRING_VALUE",
 * //         },
 * //       ],
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DescribeLaunchTemplatesCommandInput - {@link DescribeLaunchTemplatesCommandInput}
 * @returns {@link DescribeLaunchTemplatesCommandOutput}
 * @see {@link DescribeLaunchTemplatesCommandInput} for command's `input` shape.
 * @see {@link DescribeLaunchTemplatesCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 * @example To describe a launch template
 * ```javascript
 * // This example describes the specified launch template.
 * const input = {
 *   "LaunchTemplateIds": [
 *     "lt-01238c059e3466abc"
 *   ]
 * };
 * const command = new DescribeLaunchTemplatesCommand(input);
 * const response = await client.send(command);
 * /* response ==
 * {
 *   "LaunchTemplates": [
 *     {
 *       "CreateTime": "2018-01-16T04:32:57.000Z",
 *       "CreatedBy": "arn:aws:iam::123456789012:root",
 *       "DefaultVersionNumber": 1,
 *       "LatestVersionNumber": 1,
 *       "LaunchTemplateId": "lt-01238c059e3466abc",
 *       "LaunchTemplateName": "my-template"
 *     }
 *   ]
 * }
 * *\/
 * // example id: to-describe-a-launch-template-1529344182862
 * ```
 *
 */
export declare class DescribeLaunchTemplatesCommand extends DescribeLaunchTemplatesCommand_base {
}
