import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribePlacementGroupsRequest, DescribePlacementGroupsResult } from "../models/models_4";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DescribePlacementGroupsCommand}.
 */
export interface DescribePlacementGroupsCommandInput extends DescribePlacementGroupsRequest {
}
/**
 * @public
 *
 * The output of {@link DescribePlacementGroupsCommand}.
 */
export interface DescribePlacementGroupsCommandOutput extends DescribePlacementGroupsResult, __MetadataBearer {
}
declare const DescribePlacementGroupsCommand_base: {
    new (input: DescribePlacementGroupsCommandInput): import("@smithy/smithy-client").CommandImpl<DescribePlacementGroupsCommandInput, DescribePlacementGroupsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DescribePlacementGroupsCommandInput]): import("@smithy/smithy-client").CommandImpl<DescribePlacementGroupsCommandInput, DescribePlacementGroupsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes the specified placement groups or all of your placement groups. For more
 *             information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
 *                 <i>Amazon EC2 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribePlacementGroupsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribePlacementGroupsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DescribePlacementGroupsRequest
 *   Filters: [ // FilterList
 *     { // Filter
 *       Name: "STRING_VALUE",
 *       Values: [ // ValueStringList
 *         "STRING_VALUE",
 *       ],
 *     },
 *   ],
 *   DryRun: true || false,
 *   GroupNames: [ // PlacementGroupStringList
 *     "STRING_VALUE",
 *   ],
 *   GroupIds: [ // PlacementGroupIdStringList
 *     "STRING_VALUE",
 *   ],
 * };
 * const command = new DescribePlacementGroupsCommand(input);
 * const response = await client.send(command);
 * // { // DescribePlacementGroupsResult
 * //   PlacementGroups: [ // PlacementGroupList
 * //     { // PlacementGroup
 * //       GroupName: "STRING_VALUE",
 * //       State: "pending" || "available" || "deleting" || "deleted",
 * //       Strategy: "cluster" || "spread" || "partition",
 * //       PartitionCount: Number("int"),
 * //       GroupId: "STRING_VALUE",
 * //       Tags: [ // TagList
 * //         { // Tag
 * //           Key: "STRING_VALUE",
 * //           Value: "STRING_VALUE",
 * //         },
 * //       ],
 * //       GroupArn: "STRING_VALUE",
 * //       SpreadLevel: "host" || "rack",
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param DescribePlacementGroupsCommandInput - {@link DescribePlacementGroupsCommandInput}
 * @returns {@link DescribePlacementGroupsCommandOutput}
 * @see {@link DescribePlacementGroupsCommandInput} for command's `input` shape.
 * @see {@link DescribePlacementGroupsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class DescribePlacementGroupsCommand extends DescribePlacementGroupsCommand_base {
}
