import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribePublicIpv4PoolsRequest, DescribePublicIpv4PoolsResult } from "../models/models_4";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DescribePublicIpv4PoolsCommand}.
 */
export interface DescribePublicIpv4PoolsCommandInput extends DescribePublicIpv4PoolsRequest {
}
/**
 * @public
 *
 * The output of {@link DescribePublicIpv4PoolsCommand}.
 */
export interface DescribePublicIpv4PoolsCommandOutput extends DescribePublicIpv4PoolsResult, __MetadataBearer {
}
declare const DescribePublicIpv4PoolsCommand_base: {
    new (input: DescribePublicIpv4PoolsCommandInput): import("@smithy/smithy-client").CommandImpl<DescribePublicIpv4PoolsCommandInput, DescribePublicIpv4PoolsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DescribePublicIpv4PoolsCommandInput]): import("@smithy/smithy-client").CommandImpl<DescribePublicIpv4PoolsCommandInput, DescribePublicIpv4PoolsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes the specified IPv4 address pools.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribePublicIpv4PoolsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribePublicIpv4PoolsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DescribePublicIpv4PoolsRequest
 *   PoolIds: [ // PublicIpv4PoolIdStringList
 *     "STRING_VALUE",
 *   ],
 *   NextToken: "STRING_VALUE",
 *   MaxResults: Number("int"),
 *   Filters: [ // FilterList
 *     { // Filter
 *       Name: "STRING_VALUE",
 *       Values: [ // ValueStringList
 *         "STRING_VALUE",
 *       ],
 *     },
 *   ],
 * };
 * const command = new DescribePublicIpv4PoolsCommand(input);
 * const response = await client.send(command);
 * // { // DescribePublicIpv4PoolsResult
 * //   PublicIpv4Pools: [ // PublicIpv4PoolSet
 * //     { // PublicIpv4Pool
 * //       PoolId: "STRING_VALUE",
 * //       Description: "STRING_VALUE",
 * //       PoolAddressRanges: [ // PublicIpv4PoolRangeSet
 * //         { // PublicIpv4PoolRange
 * //           FirstAddress: "STRING_VALUE",
 * //           LastAddress: "STRING_VALUE",
 * //           AddressCount: Number("int"),
 * //           AvailableAddressCount: Number("int"),
 * //         },
 * //       ],
 * //       TotalAddressCount: Number("int"),
 * //       TotalAvailableAddressCount: Number("int"),
 * //       NetworkBorderGroup: "STRING_VALUE",
 * //       Tags: [ // TagList
 * //         { // Tag
 * //           Key: "STRING_VALUE",
 * //           Value: "STRING_VALUE",
 * //         },
 * //       ],
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DescribePublicIpv4PoolsCommandInput - {@link DescribePublicIpv4PoolsCommandInput}
 * @returns {@link DescribePublicIpv4PoolsCommandOutput}
 * @see {@link DescribePublicIpv4PoolsCommandInput} for command's `input` shape.
 * @see {@link DescribePublicIpv4PoolsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class DescribePublicIpv4PoolsCommand extends DescribePublicIpv4PoolsCommand_base {
}
