import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeStaleSecurityGroupsRequest } from "../models/models_4";
import { DescribeStaleSecurityGroupsResult } from "../models/models_5";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DescribeStaleSecurityGroupsCommand}.
 */
export interface DescribeStaleSecurityGroupsCommandInput extends DescribeStaleSecurityGroupsRequest {
}
/**
 * @public
 *
 * The output of {@link DescribeStaleSecurityGroupsCommand}.
 */
export interface DescribeStaleSecurityGroupsCommandOutput extends DescribeStaleSecurityGroupsResult, __MetadataBearer {
}
declare const DescribeStaleSecurityGroupsCommand_base: {
    new (input: DescribeStaleSecurityGroupsCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeStaleSecurityGroupsCommandInput, DescribeStaleSecurityGroupsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: DescribeStaleSecurityGroupsCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeStaleSecurityGroupsCommandInput, DescribeStaleSecurityGroupsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes the stale security group rules for security groups in a specified VPC.
 *           Rules are stale when they reference a deleted security group in the same VPC or peered VPC. Rules can also be stale if they reference a security group in a peer VPC for which the VPC peering connection has
 *           been deleted.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeStaleSecurityGroupsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeStaleSecurityGroupsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DescribeStaleSecurityGroupsRequest
 *   DryRun: true || false,
 *   MaxResults: Number("int"),
 *   NextToken: "STRING_VALUE",
 *   VpcId: "STRING_VALUE", // required
 * };
 * const command = new DescribeStaleSecurityGroupsCommand(input);
 * const response = await client.send(command);
 * // { // DescribeStaleSecurityGroupsResult
 * //   NextToken: "STRING_VALUE",
 * //   StaleSecurityGroupSet: [ // StaleSecurityGroupSet
 * //     { // StaleSecurityGroup
 * //       Description: "STRING_VALUE",
 * //       GroupId: "STRING_VALUE",
 * //       GroupName: "STRING_VALUE",
 * //       StaleIpPermissions: [ // StaleIpPermissionSet
 * //         { // StaleIpPermission
 * //           FromPort: Number("int"),
 * //           IpProtocol: "STRING_VALUE",
 * //           IpRanges: [ // IpRanges
 * //             "STRING_VALUE",
 * //           ],
 * //           PrefixListIds: [ // PrefixListIdSet
 * //             "STRING_VALUE",
 * //           ],
 * //           ToPort: Number("int"),
 * //           UserIdGroupPairs: [ // UserIdGroupPairSet
 * //             { // UserIdGroupPair
 * //               Description: "STRING_VALUE",
 * //               GroupId: "STRING_VALUE",
 * //               GroupName: "STRING_VALUE",
 * //               PeeringStatus: "STRING_VALUE",
 * //               UserId: "STRING_VALUE",
 * //               VpcId: "STRING_VALUE",
 * //               VpcPeeringConnectionId: "STRING_VALUE",
 * //             },
 * //           ],
 * //         },
 * //       ],
 * //       StaleIpPermissionsEgress: [
 * //         {
 * //           FromPort: Number("int"),
 * //           IpProtocol: "STRING_VALUE",
 * //           IpRanges: [
 * //             "STRING_VALUE",
 * //           ],
 * //           PrefixListIds: [
 * //             "STRING_VALUE",
 * //           ],
 * //           ToPort: Number("int"),
 * //           UserIdGroupPairs: [
 * //             {
 * //               Description: "STRING_VALUE",
 * //               GroupId: "STRING_VALUE",
 * //               GroupName: "STRING_VALUE",
 * //               PeeringStatus: "STRING_VALUE",
 * //               UserId: "STRING_VALUE",
 * //               VpcId: "STRING_VALUE",
 * //               VpcPeeringConnectionId: "STRING_VALUE",
 * //             },
 * //           ],
 * //         },
 * //       ],
 * //       VpcId: "STRING_VALUE",
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param DescribeStaleSecurityGroupsCommandInput - {@link DescribeStaleSecurityGroupsCommandInput}
 * @returns {@link DescribeStaleSecurityGroupsCommandOutput}
 * @see {@link DescribeStaleSecurityGroupsCommandInput} for command's `input` shape.
 * @see {@link DescribeStaleSecurityGroupsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class DescribeStaleSecurityGroupsCommand extends DescribeStaleSecurityGroupsCommand_base {
}
