import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DetachNetworkInterfaceRequest } from "../models/models_5";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DetachNetworkInterfaceCommand}.
 */
export interface DetachNetworkInterfaceCommandInput extends DetachNetworkInterfaceRequest {
}
/**
 * @public
 *
 * The output of {@link DetachNetworkInterfaceCommand}.
 */
export interface DetachNetworkInterfaceCommandOutput extends __MetadataBearer {
}
declare const DetachNetworkInterfaceCommand_base: {
    new (input: DetachNetworkInterfaceCommandInput): import("@smithy/smithy-client").CommandImpl<DetachNetworkInterfaceCommandInput, DetachNetworkInterfaceCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: DetachNetworkInterfaceCommandInput): import("@smithy/smithy-client").CommandImpl<DetachNetworkInterfaceCommandInput, DetachNetworkInterfaceCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Detaches a network interface from an instance.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DetachNetworkInterfaceCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DetachNetworkInterfaceCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DetachNetworkInterfaceRequest
 *   AttachmentId: "STRING_VALUE", // required
 *   DryRun: true || false,
 *   Force: true || false,
 * };
 * const command = new DetachNetworkInterfaceCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DetachNetworkInterfaceCommandInput - {@link DetachNetworkInterfaceCommandInput}
 * @returns {@link DetachNetworkInterfaceCommandOutput}
 * @see {@link DetachNetworkInterfaceCommandInput} for command's `input` shape.
 * @see {@link DetachNetworkInterfaceCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 * @example To detach a network interface from an instance
 * ```javascript
 * // This example detaches the specified network interface from its attached instance.
 * const input = {
 *   "AttachmentId": "eni-attach-66c4350a"
 * };
 * const command = new DetachNetworkInterfaceCommand(input);
 * await client.send(command);
 * // example id: ec2-detach-network-interface-1
 * ```
 *
 */
export declare class DetachNetworkInterfaceCommand extends DetachNetworkInterfaceCommand_base {
}
