import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DisableVgwRoutePropagationRequest } from "../models/models_5";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DisableVgwRoutePropagationCommand}.
 */
export interface DisableVgwRoutePropagationCommandInput extends DisableVgwRoutePropagationRequest {
}
/**
 * @public
 *
 * The output of {@link DisableVgwRoutePropagationCommand}.
 */
export interface DisableVgwRoutePropagationCommandOutput extends __MetadataBearer {
}
declare const DisableVgwRoutePropagationCommand_base: {
    new (input: DisableVgwRoutePropagationCommandInput): import("@smithy/smithy-client").CommandImpl<DisableVgwRoutePropagationCommandInput, DisableVgwRoutePropagationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: DisableVgwRoutePropagationCommandInput): import("@smithy/smithy-client").CommandImpl<DisableVgwRoutePropagationCommandInput, DisableVgwRoutePropagationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Disables a virtual private gateway (VGW) from propagating routes to a specified route
 *             table of a VPC.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DisableVgwRoutePropagationCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DisableVgwRoutePropagationCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DisableVgwRoutePropagationRequest
 *   GatewayId: "STRING_VALUE", // required
 *   RouteTableId: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new DisableVgwRoutePropagationCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DisableVgwRoutePropagationCommandInput - {@link DisableVgwRoutePropagationCommandInput}
 * @returns {@link DisableVgwRoutePropagationCommandOutput}
 * @see {@link DisableVgwRoutePropagationCommandInput} for command's `input` shape.
 * @see {@link DisableVgwRoutePropagationCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 * @example To disable route propagation
 * ```javascript
 * // This example disables the specified virtual private gateway from propagating static routes to the specified route table.
 * const input = {
 *   "GatewayId": "vgw-9a4cacf3",
 *   "RouteTableId": "rtb-22574640"
 * };
 * const command = new DisableVgwRoutePropagationCommand(input);
 * await client.send(command);
 * // example id: ec2-disable-vgw-route-propagation-1
 * ```
 *
 */
export declare class DisableVgwRoutePropagationCommand extends DisableVgwRoutePropagationCommand_base {
}
