import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DisableVpcClassicLinkRequest, DisableVpcClassicLinkResult } from "../models/models_5";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DisableVpcClassicLinkCommand}.
 */
export interface DisableVpcClassicLinkCommandInput extends DisableVpcClassicLinkRequest {
}
/**
 * @public
 *
 * The output of {@link DisableVpcClassicLinkCommand}.
 */
export interface DisableVpcClassicLinkCommandOutput extends DisableVpcClassicLinkResult, __MetadataBearer {
}
declare const DisableVpcClassicLinkCommand_base: {
    new (input: DisableVpcClassicLinkCommandInput): import("@smithy/smithy-client").CommandImpl<DisableVpcClassicLinkCommandInput, DisableVpcClassicLinkCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: DisableVpcClassicLinkCommandInput): import("@smithy/smithy-client").CommandImpl<DisableVpcClassicLinkCommandInput, DisableVpcClassicLinkCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <note>
 *             <p>This action is deprecated.</p>
 *          </note>
 *          <p>Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC that has EC2-Classic instances
 *             linked to it.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DisableVpcClassicLinkCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DisableVpcClassicLinkCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DisableVpcClassicLinkRequest
 *   DryRun: true || false,
 *   VpcId: "STRING_VALUE", // required
 * };
 * const command = new DisableVpcClassicLinkCommand(input);
 * const response = await client.send(command);
 * // { // DisableVpcClassicLinkResult
 * //   Return: true || false,
 * // };
 *
 * ```
 *
 * @param DisableVpcClassicLinkCommandInput - {@link DisableVpcClassicLinkCommandInput}
 * @returns {@link DisableVpcClassicLinkCommandOutput}
 * @see {@link DisableVpcClassicLinkCommandInput} for command's `input` shape.
 * @see {@link DisableVpcClassicLinkCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class DisableVpcClassicLinkCommand extends DisableVpcClassicLinkCommand_base {
}
