import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { EnableImageRequest, EnableImageResult } from "../models/models_5";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link EnableImageCommand}.
 */
export interface EnableImageCommandInput extends EnableImageRequest {
}
/**
 * @public
 *
 * The output of {@link EnableImageCommand}.
 */
export interface EnableImageCommandOutput extends EnableImageResult, __MetadataBearer {
}
declare const EnableImageCommand_base: {
    new (input: EnableImageCommandInput): import("@smithy/smithy-client").CommandImpl<EnableImageCommandInput, EnableImageCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: EnableImageCommandInput): import("@smithy/smithy-client").CommandImpl<EnableImageCommandInput, EnableImageCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Re-enables a disabled AMI. The re-enabled AMI is marked as <code>available</code> and can
 *       be used for instance launches, appears in describe operations, and can be shared. Amazon Web Services
 *       accounts, organizations, and Organizational Units that lost access to the AMI when it was
 *       disabled do not regain access automatically. Once the AMI is available, it can be shared with
 *       them again.</p>
 *          <p>Only the AMI owner can re-enable a disabled AMI.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/disable-an-ami.html">Disable an AMI</a> in the
 *         <i>Amazon EC2 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, EnableImageCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, EnableImageCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // EnableImageRequest
 *   ImageId: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new EnableImageCommand(input);
 * const response = await client.send(command);
 * // { // EnableImageResult
 * //   Return: true || false,
 * // };
 *
 * ```
 *
 * @param EnableImageCommandInput - {@link EnableImageCommandInput}
 * @returns {@link EnableImageCommandOutput}
 * @see {@link EnableImageCommandInput} for command's `input` shape.
 * @see {@link EnableImageCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class EnableImageCommand extends EnableImageCommand_base {
}
