import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { EnableSnapshotBlockPublicAccessRequest, EnableSnapshotBlockPublicAccessResult } from "../models/models_5";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link EnableSnapshotBlockPublicAccessCommand}.
 */
export interface EnableSnapshotBlockPublicAccessCommandInput extends EnableSnapshotBlockPublicAccessRequest {
}
/**
 * @public
 *
 * The output of {@link EnableSnapshotBlockPublicAccessCommand}.
 */
export interface EnableSnapshotBlockPublicAccessCommandOutput extends EnableSnapshotBlockPublicAccessResult, __MetadataBearer {
}
declare const EnableSnapshotBlockPublicAccessCommand_base: {
    new (input: EnableSnapshotBlockPublicAccessCommandInput): import("@smithy/smithy-client").CommandImpl<EnableSnapshotBlockPublicAccessCommandInput, EnableSnapshotBlockPublicAccessCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: EnableSnapshotBlockPublicAccessCommandInput): import("@smithy/smithy-client").CommandImpl<EnableSnapshotBlockPublicAccessCommandInput, EnableSnapshotBlockPublicAccessCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Enables or modifies the <i>block public access for snapshots</i>
 *       setting at the account level for the specified Amazon Web Services Region. After you enable block
 *       public access for snapshots in a Region, users can no longer request public sharing
 *       for snapshots in that Region. Snapshots that are already publicly shared are either
 *       treated as private or they remain publicly shared, depending on the
 *       <b>State</b> that you specify.</p>
 *          <p>If block public access is enabled in <code>block-all-sharing</code> mode, and
 *       you change the mode to <code>block-new-sharing</code>, all snapshots that were
 *       previously publicly shared are no longer treated as private and they become publicly
 *       accessible again.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/block-public-access-snapshots.html">
 *       Block public access for snapshots</a> in the <i>Amazon EBS User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, EnableSnapshotBlockPublicAccessCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, EnableSnapshotBlockPublicAccessCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // EnableSnapshotBlockPublicAccessRequest
 *   State: "block-all-sharing" || "block-new-sharing" || "unblocked", // required
 *   DryRun: true || false,
 * };
 * const command = new EnableSnapshotBlockPublicAccessCommand(input);
 * const response = await client.send(command);
 * // { // EnableSnapshotBlockPublicAccessResult
 * //   State: "block-all-sharing" || "block-new-sharing" || "unblocked",
 * // };
 *
 * ```
 *
 * @param EnableSnapshotBlockPublicAccessCommandInput - {@link EnableSnapshotBlockPublicAccessCommandInput}
 * @returns {@link EnableSnapshotBlockPublicAccessCommandOutput}
 * @see {@link EnableSnapshotBlockPublicAccessCommandInput} for command's `input` shape.
 * @see {@link EnableSnapshotBlockPublicAccessCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class EnableSnapshotBlockPublicAccessCommand extends EnableSnapshotBlockPublicAccessCommand_base {
}
