import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { EnableTransitGatewayRouteTablePropagationRequest, EnableTransitGatewayRouteTablePropagationResult } from "../models/models_5";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link EnableTransitGatewayRouteTablePropagationCommand}.
 */
export interface EnableTransitGatewayRouteTablePropagationCommandInput extends EnableTransitGatewayRouteTablePropagationRequest {
}
/**
 * @public
 *
 * The output of {@link EnableTransitGatewayRouteTablePropagationCommand}.
 */
export interface EnableTransitGatewayRouteTablePropagationCommandOutput extends EnableTransitGatewayRouteTablePropagationResult, __MetadataBearer {
}
declare const EnableTransitGatewayRouteTablePropagationCommand_base: {
    new (input: EnableTransitGatewayRouteTablePropagationCommandInput): import("@smithy/smithy-client").CommandImpl<EnableTransitGatewayRouteTablePropagationCommandInput, EnableTransitGatewayRouteTablePropagationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: EnableTransitGatewayRouteTablePropagationCommandInput): import("@smithy/smithy-client").CommandImpl<EnableTransitGatewayRouteTablePropagationCommandInput, EnableTransitGatewayRouteTablePropagationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Enables the specified attachment to propagate routes to the specified
 *          propagation route table.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, EnableTransitGatewayRouteTablePropagationCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, EnableTransitGatewayRouteTablePropagationCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // EnableTransitGatewayRouteTablePropagationRequest
 *   TransitGatewayRouteTableId: "STRING_VALUE", // required
 *   TransitGatewayAttachmentId: "STRING_VALUE",
 *   DryRun: true || false,
 *   TransitGatewayRouteTableAnnouncementId: "STRING_VALUE",
 * };
 * const command = new EnableTransitGatewayRouteTablePropagationCommand(input);
 * const response = await client.send(command);
 * // { // EnableTransitGatewayRouteTablePropagationResult
 * //   Propagation: { // TransitGatewayPropagation
 * //     TransitGatewayAttachmentId: "STRING_VALUE",
 * //     ResourceId: "STRING_VALUE",
 * //     ResourceType: "vpc" || "vpn" || "direct-connect-gateway" || "connect" || "peering" || "tgw-peering",
 * //     TransitGatewayRouteTableId: "STRING_VALUE",
 * //     State: "enabling" || "enabled" || "disabling" || "disabled",
 * //     TransitGatewayRouteTableAnnouncementId: "STRING_VALUE",
 * //   },
 * // };
 *
 * ```
 *
 * @param EnableTransitGatewayRouteTablePropagationCommandInput - {@link EnableTransitGatewayRouteTablePropagationCommandInput}
 * @returns {@link EnableTransitGatewayRouteTablePropagationCommandOutput}
 * @see {@link EnableTransitGatewayRouteTablePropagationCommandInput} for command's `input` shape.
 * @see {@link EnableTransitGatewayRouteTablePropagationCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class EnableTransitGatewayRouteTablePropagationCommand extends EnableTransitGatewayRouteTablePropagationCommand_base {
}
