import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetAssociatedEnclaveCertificateIamRolesRequest, GetAssociatedEnclaveCertificateIamRolesResult } from "../models/models_5";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link GetAssociatedEnclaveCertificateIamRolesCommand}.
 */
export interface GetAssociatedEnclaveCertificateIamRolesCommandInput extends GetAssociatedEnclaveCertificateIamRolesRequest {
}
/**
 * @public
 *
 * The output of {@link GetAssociatedEnclaveCertificateIamRolesCommand}.
 */
export interface GetAssociatedEnclaveCertificateIamRolesCommandOutput extends GetAssociatedEnclaveCertificateIamRolesResult, __MetadataBearer {
}
declare const GetAssociatedEnclaveCertificateIamRolesCommand_base: {
    new (input: GetAssociatedEnclaveCertificateIamRolesCommandInput): import("@smithy/smithy-client").CommandImpl<GetAssociatedEnclaveCertificateIamRolesCommandInput, GetAssociatedEnclaveCertificateIamRolesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: GetAssociatedEnclaveCertificateIamRolesCommandInput): import("@smithy/smithy-client").CommandImpl<GetAssociatedEnclaveCertificateIamRolesCommandInput, GetAssociatedEnclaveCertificateIamRolesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Returns the IAM roles that are associated with the specified ACM (ACM) certificate.
 * 			It also returns the name of the Amazon S3 bucket and the Amazon S3 object key where the certificate,
 * 			certificate chain, and encrypted private key bundle are stored, and the ARN of the KMS key
 * 			that's used to encrypt the private key.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, GetAssociatedEnclaveCertificateIamRolesCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, GetAssociatedEnclaveCertificateIamRolesCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // GetAssociatedEnclaveCertificateIamRolesRequest
 *   CertificateArn: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new GetAssociatedEnclaveCertificateIamRolesCommand(input);
 * const response = await client.send(command);
 * // { // GetAssociatedEnclaveCertificateIamRolesResult
 * //   AssociatedRoles: [ // AssociatedRolesList
 * //     { // AssociatedRole
 * //       AssociatedRoleArn: "STRING_VALUE",
 * //       CertificateS3BucketName: "STRING_VALUE",
 * //       CertificateS3ObjectKey: "STRING_VALUE",
 * //       EncryptionKmsKeyId: "STRING_VALUE",
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param GetAssociatedEnclaveCertificateIamRolesCommandInput - {@link GetAssociatedEnclaveCertificateIamRolesCommandInput}
 * @returns {@link GetAssociatedEnclaveCertificateIamRolesCommandOutput}
 * @see {@link GetAssociatedEnclaveCertificateIamRolesCommandInput} for command's `input` shape.
 * @see {@link GetAssociatedEnclaveCertificateIamRolesCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class GetAssociatedEnclaveCertificateIamRolesCommand extends GetAssociatedEnclaveCertificateIamRolesCommand_base {
}
