import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetConsoleScreenshotRequest, GetConsoleScreenshotResult } from "../models/models_5";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link GetConsoleScreenshotCommand}.
 */
export interface GetConsoleScreenshotCommandInput extends GetConsoleScreenshotRequest {
}
/**
 * @public
 *
 * The output of {@link GetConsoleScreenshotCommand}.
 */
export interface GetConsoleScreenshotCommandOutput extends GetConsoleScreenshotResult, __MetadataBearer {
}
declare const GetConsoleScreenshotCommand_base: {
    new (input: GetConsoleScreenshotCommandInput): import("@smithy/smithy-client").CommandImpl<GetConsoleScreenshotCommandInput, GetConsoleScreenshotCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: GetConsoleScreenshotCommandInput): import("@smithy/smithy-client").CommandImpl<GetConsoleScreenshotCommandInput, GetConsoleScreenshotCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Retrieve a JPG-format screenshot of a running instance to help with
 *             troubleshooting.</p>
 *          <p>The returned content is Base64-encoded.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, GetConsoleScreenshotCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, GetConsoleScreenshotCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // GetConsoleScreenshotRequest
 *   DryRun: true || false,
 *   InstanceId: "STRING_VALUE", // required
 *   WakeUp: true || false,
 * };
 * const command = new GetConsoleScreenshotCommand(input);
 * const response = await client.send(command);
 * // { // GetConsoleScreenshotResult
 * //   ImageData: "STRING_VALUE",
 * //   InstanceId: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param GetConsoleScreenshotCommandInput - {@link GetConsoleScreenshotCommandInput}
 * @returns {@link GetConsoleScreenshotCommandOutput}
 * @see {@link GetConsoleScreenshotCommandInput} for command's `input` shape.
 * @see {@link GetConsoleScreenshotCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class GetConsoleScreenshotCommand extends GetConsoleScreenshotCommand_base {
}
