import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetIpamAddressHistoryRequest, GetIpamAddressHistoryResult } from "../models/models_5";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link GetIpamAddressHistoryCommand}.
 */
export interface GetIpamAddressHistoryCommandInput extends GetIpamAddressHistoryRequest {
}
/**
 * @public
 *
 * The output of {@link GetIpamAddressHistoryCommand}.
 */
export interface GetIpamAddressHistoryCommandOutput extends GetIpamAddressHistoryResult, __MetadataBearer {
}
declare const GetIpamAddressHistoryCommand_base: {
    new (input: GetIpamAddressHistoryCommandInput): import("@smithy/smithy-client").CommandImpl<GetIpamAddressHistoryCommandInput, GetIpamAddressHistoryCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: GetIpamAddressHistoryCommandInput): import("@smithy/smithy-client").CommandImpl<GetIpamAddressHistoryCommandInput, GetIpamAddressHistoryCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Retrieve historical information about a CIDR within an IPAM scope. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/view-history-cidr-ipam.html">View the history of IP addresses</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, GetIpamAddressHistoryCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, GetIpamAddressHistoryCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // GetIpamAddressHistoryRequest
 *   DryRun: true || false,
 *   Cidr: "STRING_VALUE", // required
 *   IpamScopeId: "STRING_VALUE", // required
 *   VpcId: "STRING_VALUE",
 *   StartTime: new Date("TIMESTAMP"),
 *   EndTime: new Date("TIMESTAMP"),
 *   MaxResults: Number("int"),
 *   NextToken: "STRING_VALUE",
 * };
 * const command = new GetIpamAddressHistoryCommand(input);
 * const response = await client.send(command);
 * // { // GetIpamAddressHistoryResult
 * //   HistoryRecords: [ // IpamAddressHistoryRecordSet
 * //     { // IpamAddressHistoryRecord
 * //       ResourceOwnerId: "STRING_VALUE",
 * //       ResourceRegion: "STRING_VALUE",
 * //       ResourceType: "eip" || "vpc" || "subnet" || "network-interface" || "instance",
 * //       ResourceId: "STRING_VALUE",
 * //       ResourceCidr: "STRING_VALUE",
 * //       ResourceName: "STRING_VALUE",
 * //       ResourceComplianceStatus: "compliant" || "noncompliant" || "unmanaged" || "ignored",
 * //       ResourceOverlapStatus: "overlapping" || "nonoverlapping" || "ignored",
 * //       VpcId: "STRING_VALUE",
 * //       SampledStartTime: new Date("TIMESTAMP"),
 * //       SampledEndTime: new Date("TIMESTAMP"),
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param GetIpamAddressHistoryCommandInput - {@link GetIpamAddressHistoryCommandInput}
 * @returns {@link GetIpamAddressHistoryCommandOutput}
 * @see {@link GetIpamAddressHistoryCommandInput} for command's `input` shape.
 * @see {@link GetIpamAddressHistoryCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class GetIpamAddressHistoryCommand extends GetIpamAddressHistoryCommand_base {
}
