import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetIpamDiscoveredAccountsRequest, GetIpamDiscoveredAccountsResult } from "../models/models_5";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link GetIpamDiscoveredAccountsCommand}.
 */
export interface GetIpamDiscoveredAccountsCommandInput extends GetIpamDiscoveredAccountsRequest {
}
/**
 * @public
 *
 * The output of {@link GetIpamDiscoveredAccountsCommand}.
 */
export interface GetIpamDiscoveredAccountsCommandOutput extends GetIpamDiscoveredAccountsResult, __MetadataBearer {
}
declare const GetIpamDiscoveredAccountsCommand_base: {
    new (input: GetIpamDiscoveredAccountsCommandInput): import("@smithy/smithy-client").CommandImpl<GetIpamDiscoveredAccountsCommandInput, GetIpamDiscoveredAccountsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: GetIpamDiscoveredAccountsCommandInput): import("@smithy/smithy-client").CommandImpl<GetIpamDiscoveredAccountsCommandInput, GetIpamDiscoveredAccountsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Gets IPAM discovered accounts. A discovered account is an Amazon Web Services account that is monitored under a resource discovery. If you have integrated IPAM with Amazon Web Services Organizations, all accounts in the organization are discovered accounts. Only the IPAM account can get all discovered accounts in the organization.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, GetIpamDiscoveredAccountsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, GetIpamDiscoveredAccountsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // GetIpamDiscoveredAccountsRequest
 *   DryRun: true || false,
 *   IpamResourceDiscoveryId: "STRING_VALUE", // required
 *   DiscoveryRegion: "STRING_VALUE", // required
 *   Filters: [ // FilterList
 *     { // Filter
 *       Name: "STRING_VALUE",
 *       Values: [ // ValueStringList
 *         "STRING_VALUE",
 *       ],
 *     },
 *   ],
 *   NextToken: "STRING_VALUE",
 *   MaxResults: Number("int"),
 * };
 * const command = new GetIpamDiscoveredAccountsCommand(input);
 * const response = await client.send(command);
 * // { // GetIpamDiscoveredAccountsResult
 * //   IpamDiscoveredAccounts: [ // IpamDiscoveredAccountSet
 * //     { // IpamDiscoveredAccount
 * //       AccountId: "STRING_VALUE",
 * //       DiscoveryRegion: "STRING_VALUE",
 * //       FailureReason: { // IpamDiscoveryFailureReason
 * //         Code: "assume-role-failure" || "throttling-failure" || "unauthorized-failure",
 * //         Message: "STRING_VALUE",
 * //       },
 * //       LastAttemptedDiscoveryTime: new Date("TIMESTAMP"),
 * //       LastSuccessfulDiscoveryTime: new Date("TIMESTAMP"),
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param GetIpamDiscoveredAccountsCommandInput - {@link GetIpamDiscoveredAccountsCommandInput}
 * @returns {@link GetIpamDiscoveredAccountsCommandOutput}
 * @see {@link GetIpamDiscoveredAccountsCommandInput} for command's `input` shape.
 * @see {@link GetIpamDiscoveredAccountsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class GetIpamDiscoveredAccountsCommand extends GetIpamDiscoveredAccountsCommand_base {
}
