import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetReservedInstancesExchangeQuoteRequest, GetReservedInstancesExchangeQuoteResult } from "../models/models_6";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link GetReservedInstancesExchangeQuoteCommand}.
 */
export interface GetReservedInstancesExchangeQuoteCommandInput extends GetReservedInstancesExchangeQuoteRequest {
}
/**
 * @public
 *
 * The output of {@link GetReservedInstancesExchangeQuoteCommand}.
 */
export interface GetReservedInstancesExchangeQuoteCommandOutput extends GetReservedInstancesExchangeQuoteResult, __MetadataBearer {
}
declare const GetReservedInstancesExchangeQuoteCommand_base: {
    new (input: GetReservedInstancesExchangeQuoteCommandInput): import("@smithy/smithy-client").CommandImpl<GetReservedInstancesExchangeQuoteCommandInput, GetReservedInstancesExchangeQuoteCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: GetReservedInstancesExchangeQuoteCommandInput): import("@smithy/smithy-client").CommandImpl<GetReservedInstancesExchangeQuoteCommandInput, GetReservedInstancesExchangeQuoteCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Returns a quote and exchange information for exchanging one or more specified
 *             Convertible Reserved Instances for a new Convertible Reserved Instance. If the exchange
 *             cannot be performed, the reason is returned in the response. Use <a>AcceptReservedInstancesExchangeQuote</a> to perform the exchange.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, GetReservedInstancesExchangeQuoteCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, GetReservedInstancesExchangeQuoteCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // GetReservedInstancesExchangeQuoteRequest
 *   DryRun: true || false,
 *   ReservedInstanceIds: [ // ReservedInstanceIdSet // required
 *     "STRING_VALUE",
 *   ],
 *   TargetConfigurations: [ // TargetConfigurationRequestSet
 *     { // TargetConfigurationRequest
 *       InstanceCount: Number("int"),
 *       OfferingId: "STRING_VALUE", // required
 *     },
 *   ],
 * };
 * const command = new GetReservedInstancesExchangeQuoteCommand(input);
 * const response = await client.send(command);
 * // { // GetReservedInstancesExchangeQuoteResult
 * //   CurrencyCode: "STRING_VALUE",
 * //   IsValidExchange: true || false,
 * //   OutputReservedInstancesWillExpireAt: new Date("TIMESTAMP"),
 * //   PaymentDue: "STRING_VALUE",
 * //   ReservedInstanceValueRollup: { // ReservationValue
 * //     HourlyPrice: "STRING_VALUE",
 * //     RemainingTotalValue: "STRING_VALUE",
 * //     RemainingUpfrontValue: "STRING_VALUE",
 * //   },
 * //   ReservedInstanceValueSet: [ // ReservedInstanceReservationValueSet
 * //     { // ReservedInstanceReservationValue
 * //       ReservationValue: {
 * //         HourlyPrice: "STRING_VALUE",
 * //         RemainingTotalValue: "STRING_VALUE",
 * //         RemainingUpfrontValue: "STRING_VALUE",
 * //       },
 * //       ReservedInstanceId: "STRING_VALUE",
 * //     },
 * //   ],
 * //   TargetConfigurationValueRollup: {
 * //     HourlyPrice: "STRING_VALUE",
 * //     RemainingTotalValue: "STRING_VALUE",
 * //     RemainingUpfrontValue: "STRING_VALUE",
 * //   },
 * //   TargetConfigurationValueSet: [ // TargetReservationValueSet
 * //     { // TargetReservationValue
 * //       ReservationValue: {
 * //         HourlyPrice: "STRING_VALUE",
 * //         RemainingTotalValue: "STRING_VALUE",
 * //         RemainingUpfrontValue: "STRING_VALUE",
 * //       },
 * //       TargetConfiguration: { // TargetConfiguration
 * //         InstanceCount: Number("int"),
 * //         OfferingId: "STRING_VALUE",
 * //       },
 * //     },
 * //   ],
 * //   ValidationFailureReason: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param GetReservedInstancesExchangeQuoteCommandInput - {@link GetReservedInstancesExchangeQuoteCommandInput}
 * @returns {@link GetReservedInstancesExchangeQuoteCommandOutput}
 * @see {@link GetReservedInstancesExchangeQuoteCommandInput} for command's `input` shape.
 * @see {@link GetReservedInstancesExchangeQuoteCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class GetReservedInstancesExchangeQuoteCommand extends GetReservedInstancesExchangeQuoteCommand_base {
}
