import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetVerifiedAccessGroupPolicyRequest, GetVerifiedAccessGroupPolicyResult } from "../models/models_6";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link GetVerifiedAccessGroupPolicyCommand}.
 */
export interface GetVerifiedAccessGroupPolicyCommandInput extends GetVerifiedAccessGroupPolicyRequest {
}
/**
 * @public
 *
 * The output of {@link GetVerifiedAccessGroupPolicyCommand}.
 */
export interface GetVerifiedAccessGroupPolicyCommandOutput extends GetVerifiedAccessGroupPolicyResult, __MetadataBearer {
}
declare const GetVerifiedAccessGroupPolicyCommand_base: {
    new (input: GetVerifiedAccessGroupPolicyCommandInput): import("@smithy/smithy-client").CommandImpl<GetVerifiedAccessGroupPolicyCommandInput, GetVerifiedAccessGroupPolicyCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: GetVerifiedAccessGroupPolicyCommandInput): import("@smithy/smithy-client").CommandImpl<GetVerifiedAccessGroupPolicyCommandInput, GetVerifiedAccessGroupPolicyCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Shows the contents of the Verified Access policy associated with the group.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, GetVerifiedAccessGroupPolicyCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, GetVerifiedAccessGroupPolicyCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // GetVerifiedAccessGroupPolicyRequest
 *   VerifiedAccessGroupId: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new GetVerifiedAccessGroupPolicyCommand(input);
 * const response = await client.send(command);
 * // { // GetVerifiedAccessGroupPolicyResult
 * //   PolicyEnabled: true || false,
 * //   PolicyDocument: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param GetVerifiedAccessGroupPolicyCommandInput - {@link GetVerifiedAccessGroupPolicyCommandInput}
 * @returns {@link GetVerifiedAccessGroupPolicyCommandOutput}
 * @see {@link GetVerifiedAccessGroupPolicyCommandInput} for command's `input` shape.
 * @see {@link GetVerifiedAccessGroupPolicyCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class GetVerifiedAccessGroupPolicyCommand extends GetVerifiedAccessGroupPolicyCommand_base {
}
