import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ImportClientVpnClientCertificateRevocationListRequest, ImportClientVpnClientCertificateRevocationListResult } from "../models/models_6";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link ImportClientVpnClientCertificateRevocationListCommand}.
 */
export interface ImportClientVpnClientCertificateRevocationListCommandInput extends ImportClientVpnClientCertificateRevocationListRequest {
}
/**
 * @public
 *
 * The output of {@link ImportClientVpnClientCertificateRevocationListCommand}.
 */
export interface ImportClientVpnClientCertificateRevocationListCommandOutput extends ImportClientVpnClientCertificateRevocationListResult, __MetadataBearer {
}
declare const ImportClientVpnClientCertificateRevocationListCommand_base: {
    new (input: ImportClientVpnClientCertificateRevocationListCommandInput): import("@smithy/smithy-client").CommandImpl<ImportClientVpnClientCertificateRevocationListCommandInput, ImportClientVpnClientCertificateRevocationListCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: ImportClientVpnClientCertificateRevocationListCommandInput): import("@smithy/smithy-client").CommandImpl<ImportClientVpnClientCertificateRevocationListCommandInput, ImportClientVpnClientCertificateRevocationListCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Uploads a client certificate revocation list to the specified Client VPN endpoint. Uploading a client certificate revocation list overwrites the existing client certificate revocation list.</p>
 *          <p>Uploading a client certificate revocation list resets existing client connections.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ImportClientVpnClientCertificateRevocationListCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ImportClientVpnClientCertificateRevocationListCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // ImportClientVpnClientCertificateRevocationListRequest
 *   ClientVpnEndpointId: "STRING_VALUE", // required
 *   CertificateRevocationList: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new ImportClientVpnClientCertificateRevocationListCommand(input);
 * const response = await client.send(command);
 * // { // ImportClientVpnClientCertificateRevocationListResult
 * //   Return: true || false,
 * // };
 *
 * ```
 *
 * @param ImportClientVpnClientCertificateRevocationListCommandInput - {@link ImportClientVpnClientCertificateRevocationListCommandInput}
 * @returns {@link ImportClientVpnClientCertificateRevocationListCommandOutput}
 * @see {@link ImportClientVpnClientCertificateRevocationListCommandInput} for command's `input` shape.
 * @see {@link ImportClientVpnClientCertificateRevocationListCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class ImportClientVpnClientCertificateRevocationListCommand extends ImportClientVpnClientCertificateRevocationListCommand_base {
}
