import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ImportVolumeRequest, ImportVolumeResult } from "../models/models_6";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link ImportVolumeCommand}.
 */
export interface ImportVolumeCommandInput extends ImportVolumeRequest {
}
/**
 * @public
 *
 * The output of {@link ImportVolumeCommand}.
 */
export interface ImportVolumeCommandOutput extends ImportVolumeResult, __MetadataBearer {
}
declare const ImportVolumeCommand_base: {
    new (input: ImportVolumeCommandInput): import("@smithy/smithy-client").CommandImpl<ImportVolumeCommandInput, ImportVolumeCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: ImportVolumeCommandInput): import("@smithy/smithy-client").CommandImpl<ImportVolumeCommandInput, ImportVolumeCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Creates an import volume task using metadata from the specified disk image.</p>
 *          <p>This API action supports only single-volume VMs. To import multi-volume VMs, use
 *    <a>ImportImage</a> instead. To import a disk to a snapshot, use
 *    <a>ImportSnapshot</a> instead.</p>
 *          <p>This API action is not supported by the Command Line Interface (CLI). For
 *    information about using the Amazon EC2 CLI, which is deprecated, see <a href="https://awsdocs.s3.amazonaws.com/EC2/ec2-clt.pdf#importing-your-volumes-into-amazon-ebs">Importing Disks to Amazon EBS</a> in the <i>Amazon EC2 CLI Reference</i> PDF file.</p>
 *          <p>For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ImportVolumeCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ImportVolumeCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // ImportVolumeRequest
 *   AvailabilityZone: "STRING_VALUE", // required
 *   Description: "STRING_VALUE",
 *   DryRun: true || false,
 *   Image: { // DiskImageDetail
 *     Bytes: Number("long"), // required
 *     Format: "VMDK" || "RAW" || "VHD", // required
 *     ImportManifestUrl: "STRING_VALUE", // required
 *   },
 *   Volume: { // VolumeDetail
 *     Size: Number("long"), // required
 *   },
 * };
 * const command = new ImportVolumeCommand(input);
 * const response = await client.send(command);
 * // { // ImportVolumeResult
 * //   ConversionTask: { // ConversionTask
 * //     ConversionTaskId: "STRING_VALUE",
 * //     ExpirationTime: "STRING_VALUE",
 * //     ImportInstance: { // ImportInstanceTaskDetails
 * //       Description: "STRING_VALUE",
 * //       InstanceId: "STRING_VALUE",
 * //       Platform: "Windows",
 * //       Volumes: [ // ImportInstanceVolumeDetailSet
 * //         { // ImportInstanceVolumeDetailItem
 * //           AvailabilityZone: "STRING_VALUE",
 * //           BytesConverted: Number("long"),
 * //           Description: "STRING_VALUE",
 * //           Image: { // DiskImageDescription
 * //             Checksum: "STRING_VALUE",
 * //             Format: "VMDK" || "RAW" || "VHD",
 * //             ImportManifestUrl: "STRING_VALUE",
 * //             Size: Number("long"),
 * //           },
 * //           Status: "STRING_VALUE",
 * //           StatusMessage: "STRING_VALUE",
 * //           Volume: { // DiskImageVolumeDescription
 * //             Id: "STRING_VALUE",
 * //             Size: Number("long"),
 * //           },
 * //         },
 * //       ],
 * //     },
 * //     ImportVolume: { // ImportVolumeTaskDetails
 * //       AvailabilityZone: "STRING_VALUE",
 * //       BytesConverted: Number("long"),
 * //       Description: "STRING_VALUE",
 * //       Image: {
 * //         Checksum: "STRING_VALUE",
 * //         Format: "VMDK" || "RAW" || "VHD",
 * //         ImportManifestUrl: "STRING_VALUE",
 * //         Size: Number("long"),
 * //       },
 * //       Volume: {
 * //         Id: "STRING_VALUE",
 * //         Size: Number("long"),
 * //       },
 * //     },
 * //     State: "active" || "cancelling" || "cancelled" || "completed",
 * //     StatusMessage: "STRING_VALUE",
 * //     Tags: [ // TagList
 * //       { // Tag
 * //         Key: "STRING_VALUE",
 * //         Value: "STRING_VALUE",
 * //       },
 * //     ],
 * //   },
 * // };
 *
 * ```
 *
 * @param ImportVolumeCommandInput - {@link ImportVolumeCommandInput}
 * @returns {@link ImportVolumeCommandOutput}
 * @see {@link ImportVolumeCommandInput} for command's `input` shape.
 * @see {@link ImportVolumeCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class ImportVolumeCommand extends ImportVolumeCommand_base {
}
