import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyDefaultCreditSpecificationRequest, ModifyDefaultCreditSpecificationResult } from "../models/models_6";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link ModifyDefaultCreditSpecificationCommand}.
 */
export interface ModifyDefaultCreditSpecificationCommandInput extends ModifyDefaultCreditSpecificationRequest {
}
/**
 * @public
 *
 * The output of {@link ModifyDefaultCreditSpecificationCommand}.
 */
export interface ModifyDefaultCreditSpecificationCommandOutput extends ModifyDefaultCreditSpecificationResult, __MetadataBearer {
}
declare const ModifyDefaultCreditSpecificationCommand_base: {
    new (input: ModifyDefaultCreditSpecificationCommandInput): import("@smithy/smithy-client").CommandImpl<ModifyDefaultCreditSpecificationCommandInput, ModifyDefaultCreditSpecificationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: ModifyDefaultCreditSpecificationCommandInput): import("@smithy/smithy-client").CommandImpl<ModifyDefaultCreditSpecificationCommandInput, ModifyDefaultCreditSpecificationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Modifies the default credit option for CPU usage of burstable performance instances.
 *             The default credit option is set at the account level per Amazon Web Services Region, and
 *             is specified per instance family. All new burstable performance instances in the account
 *             launch using the default credit option.</p>
 *          <p>
 *             <code>ModifyDefaultCreditSpecification</code> is an asynchronous operation, which
 *             works at an Amazon Web Services Region level and modifies the credit option for each
 *             Availability Zone. All zones in a Region are updated within five minutes. But if
 *             instances are launched during this operation, they might not get the new credit option
 *             until the zone is updated. To verify whether the update has occurred, you can call
 *                 <code>GetDefaultCreditSpecification</code> and check
 *                 <code>DefaultCreditSpecification</code> for updates.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
 *                 performance instances</a> in the <i>Amazon EC2 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifyDefaultCreditSpecificationCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifyDefaultCreditSpecificationCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // ModifyDefaultCreditSpecificationRequest
 *   DryRun: true || false,
 *   InstanceFamily: "t2" || "t3" || "t3a" || "t4g", // required
 *   CpuCredits: "STRING_VALUE", // required
 * };
 * const command = new ModifyDefaultCreditSpecificationCommand(input);
 * const response = await client.send(command);
 * // { // ModifyDefaultCreditSpecificationResult
 * //   InstanceFamilyCreditSpecification: { // InstanceFamilyCreditSpecification
 * //     InstanceFamily: "t2" || "t3" || "t3a" || "t4g",
 * //     CpuCredits: "STRING_VALUE",
 * //   },
 * // };
 *
 * ```
 *
 * @param ModifyDefaultCreditSpecificationCommandInput - {@link ModifyDefaultCreditSpecificationCommandInput}
 * @returns {@link ModifyDefaultCreditSpecificationCommandOutput}
 * @see {@link ModifyDefaultCreditSpecificationCommandInput} for command's `input` shape.
 * @see {@link ModifyDefaultCreditSpecificationCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class ModifyDefaultCreditSpecificationCommand extends ModifyDefaultCreditSpecificationCommand_base {
}
