import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyInstanceMaintenanceOptionsRequest, ModifyInstanceMaintenanceOptionsResult } from "../models/models_6";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link ModifyInstanceMaintenanceOptionsCommand}.
 */
export interface ModifyInstanceMaintenanceOptionsCommandInput extends ModifyInstanceMaintenanceOptionsRequest {
}
/**
 * @public
 *
 * The output of {@link ModifyInstanceMaintenanceOptionsCommand}.
 */
export interface ModifyInstanceMaintenanceOptionsCommandOutput extends ModifyInstanceMaintenanceOptionsResult, __MetadataBearer {
}
declare const ModifyInstanceMaintenanceOptionsCommand_base: {
    new (input: ModifyInstanceMaintenanceOptionsCommandInput): import("@smithy/smithy-client").CommandImpl<ModifyInstanceMaintenanceOptionsCommandInput, ModifyInstanceMaintenanceOptionsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: ModifyInstanceMaintenanceOptionsCommandInput): import("@smithy/smithy-client").CommandImpl<ModifyInstanceMaintenanceOptionsCommandInput, ModifyInstanceMaintenanceOptionsCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Modifies the recovery behavior of your instance to disable simplified automatic
 *             recovery or set the recovery behavior to default. The default configuration will not
 *             enable simplified automatic recovery for an unsupported instance type. For more
 *             information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html#instance-configuration-recovery">Simplified automatic recovery</a>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifyInstanceMaintenanceOptionsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifyInstanceMaintenanceOptionsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // ModifyInstanceMaintenanceOptionsRequest
 *   InstanceId: "STRING_VALUE", // required
 *   AutoRecovery: "disabled" || "default",
 *   DryRun: true || false,
 * };
 * const command = new ModifyInstanceMaintenanceOptionsCommand(input);
 * const response = await client.send(command);
 * // { // ModifyInstanceMaintenanceOptionsResult
 * //   InstanceId: "STRING_VALUE",
 * //   AutoRecovery: "disabled" || "default",
 * // };
 *
 * ```
 *
 * @param ModifyInstanceMaintenanceOptionsCommandInput - {@link ModifyInstanceMaintenanceOptionsCommandInput}
 * @returns {@link ModifyInstanceMaintenanceOptionsCommandOutput}
 * @see {@link ModifyInstanceMaintenanceOptionsCommandInput} for command's `input` shape.
 * @see {@link ModifyInstanceMaintenanceOptionsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class ModifyInstanceMaintenanceOptionsCommand extends ModifyInstanceMaintenanceOptionsCommand_base {
}
