import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ReplaceRouteRequest } from "../models/models_7";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link ReplaceRouteCommand}.
 */
export interface ReplaceRouteCommandInput extends ReplaceRouteRequest {
}
/**
 * @public
 *
 * The output of {@link ReplaceRouteCommand}.
 */
export interface ReplaceRouteCommandOutput extends __MetadataBearer {
}
declare const ReplaceRouteCommand_base: {
    new (input: ReplaceRouteCommandInput): import("@smithy/smithy-client").CommandImpl<ReplaceRouteCommandInput, ReplaceRouteCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: ReplaceRouteCommandInput): import("@smithy/smithy-client").CommandImpl<ReplaceRouteCommandInput, ReplaceRouteCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Replaces an existing route within a route table in a VPC.</p>
 *          <p>You must specify either a destination CIDR block or a prefix list ID. You must also specify
 *            exactly one of the resources from the parameter list, or reset the local route to its default
 *            target.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the
 *                 <i>Amazon VPC User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ReplaceRouteCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ReplaceRouteCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // ReplaceRouteRequest
 *   DestinationCidrBlock: "STRING_VALUE",
 *   DestinationIpv6CidrBlock: "STRING_VALUE",
 *   DestinationPrefixListId: "STRING_VALUE",
 *   DryRun: true || false,
 *   VpcEndpointId: "STRING_VALUE",
 *   EgressOnlyInternetGatewayId: "STRING_VALUE",
 *   GatewayId: "STRING_VALUE",
 *   InstanceId: "STRING_VALUE",
 *   LocalTarget: true || false,
 *   NatGatewayId: "STRING_VALUE",
 *   TransitGatewayId: "STRING_VALUE",
 *   LocalGatewayId: "STRING_VALUE",
 *   CarrierGatewayId: "STRING_VALUE",
 *   NetworkInterfaceId: "STRING_VALUE",
 *   RouteTableId: "STRING_VALUE", // required
 *   VpcPeeringConnectionId: "STRING_VALUE",
 *   CoreNetworkArn: "STRING_VALUE",
 * };
 * const command = new ReplaceRouteCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param ReplaceRouteCommandInput - {@link ReplaceRouteCommandInput}
 * @returns {@link ReplaceRouteCommandOutput}
 * @see {@link ReplaceRouteCommandInput} for command's `input` shape.
 * @see {@link ReplaceRouteCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 * @example To replace a route
 * ```javascript
 * // This example replaces the specified route in the specified table table. The new route matches the specified CIDR and sends the traffic to the specified virtual private gateway.
 * const input = {
 *   "DestinationCidrBlock": "10.0.0.0/16",
 *   "GatewayId": "vgw-9a4cacf3",
 *   "RouteTableId": "rtb-22574640"
 * };
 * const command = new ReplaceRouteCommand(input);
 * await client.send(command);
 * // example id: ec2-replace-route-1
 * ```
 *
 */
export declare class ReplaceRouteCommand extends ReplaceRouteCommand_base {
}
