import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { StartNetworkInsightsAccessScopeAnalysisRequest, StartNetworkInsightsAccessScopeAnalysisResult } from "../models/models_7";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link StartNetworkInsightsAccessScopeAnalysisCommand}.
 */
export interface StartNetworkInsightsAccessScopeAnalysisCommandInput extends StartNetworkInsightsAccessScopeAnalysisRequest {
}
/**
 * @public
 *
 * The output of {@link StartNetworkInsightsAccessScopeAnalysisCommand}.
 */
export interface StartNetworkInsightsAccessScopeAnalysisCommandOutput extends StartNetworkInsightsAccessScopeAnalysisResult, __MetadataBearer {
}
declare const StartNetworkInsightsAccessScopeAnalysisCommand_base: {
    new (input: StartNetworkInsightsAccessScopeAnalysisCommandInput): import("@smithy/smithy-client").CommandImpl<StartNetworkInsightsAccessScopeAnalysisCommandInput, StartNetworkInsightsAccessScopeAnalysisCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: StartNetworkInsightsAccessScopeAnalysisCommandInput): import("@smithy/smithy-client").CommandImpl<StartNetworkInsightsAccessScopeAnalysisCommandInput, StartNetworkInsightsAccessScopeAnalysisCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Starts analyzing the specified Network Access Scope.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, StartNetworkInsightsAccessScopeAnalysisCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, StartNetworkInsightsAccessScopeAnalysisCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // StartNetworkInsightsAccessScopeAnalysisRequest
 *   NetworkInsightsAccessScopeId: "STRING_VALUE", // required
 *   DryRun: true || false,
 *   TagSpecifications: [ // TagSpecificationList
 *     { // TagSpecification
 *       ResourceType: "capacity-reservation" || "client-vpn-endpoint" || "customer-gateway" || "carrier-gateway" || "coip-pool" || "dedicated-host" || "dhcp-options" || "egress-only-internet-gateway" || "elastic-ip" || "elastic-gpu" || "export-image-task" || "export-instance-task" || "fleet" || "fpga-image" || "host-reservation" || "image" || "import-image-task" || "import-snapshot-task" || "instance" || "instance-event-window" || "internet-gateway" || "ipam" || "ipam-pool" || "ipam-scope" || "ipv4pool-ec2" || "ipv6pool-ec2" || "key-pair" || "launch-template" || "local-gateway" || "local-gateway-route-table" || "local-gateway-virtual-interface" || "local-gateway-virtual-interface-group" || "local-gateway-route-table-vpc-association" || "local-gateway-route-table-virtual-interface-group-association" || "natgateway" || "network-acl" || "network-interface" || "network-insights-analysis" || "network-insights-path" || "network-insights-access-scope" || "network-insights-access-scope-analysis" || "placement-group" || "prefix-list" || "replace-root-volume-task" || "reserved-instances" || "route-table" || "security-group" || "security-group-rule" || "snapshot" || "spot-fleet-request" || "spot-instances-request" || "subnet" || "subnet-cidr-reservation" || "traffic-mirror-filter" || "traffic-mirror-session" || "traffic-mirror-target" || "transit-gateway" || "transit-gateway-attachment" || "transit-gateway-connect-peer" || "transit-gateway-multicast-domain" || "transit-gateway-policy-table" || "transit-gateway-route-table" || "transit-gateway-route-table-announcement" || "volume" || "vpc" || "vpc-endpoint" || "vpc-endpoint-connection" || "vpc-endpoint-service" || "vpc-endpoint-service-permission" || "vpc-peering-connection" || "vpn-connection" || "vpn-gateway" || "vpc-flow-log" || "capacity-reservation-fleet" || "traffic-mirror-filter-rule" || "vpc-endpoint-connection-device-type" || "verified-access-instance" || "verified-access-group" || "verified-access-endpoint" || "verified-access-policy" || "verified-access-trust-provider" || "vpn-connection-device-type" || "vpc-block-public-access-exclusion" || "ipam-resource-discovery" || "ipam-resource-discovery-association" || "instance-connect-endpoint",
 *       Tags: [ // TagList
 *         { // Tag
 *           Key: "STRING_VALUE",
 *           Value: "STRING_VALUE",
 *         },
 *       ],
 *     },
 *   ],
 *   ClientToken: "STRING_VALUE", // required
 * };
 * const command = new StartNetworkInsightsAccessScopeAnalysisCommand(input);
 * const response = await client.send(command);
 * // { // StartNetworkInsightsAccessScopeAnalysisResult
 * //   NetworkInsightsAccessScopeAnalysis: { // NetworkInsightsAccessScopeAnalysis
 * //     NetworkInsightsAccessScopeAnalysisId: "STRING_VALUE",
 * //     NetworkInsightsAccessScopeAnalysisArn: "STRING_VALUE",
 * //     NetworkInsightsAccessScopeId: "STRING_VALUE",
 * //     Status: "running" || "succeeded" || "failed",
 * //     StatusMessage: "STRING_VALUE",
 * //     WarningMessage: "STRING_VALUE",
 * //     StartDate: new Date("TIMESTAMP"),
 * //     EndDate: new Date("TIMESTAMP"),
 * //     FindingsFound: "true" || "false" || "unknown",
 * //     AnalyzedEniCount: Number("int"),
 * //     Tags: [ // TagList
 * //       { // Tag
 * //         Key: "STRING_VALUE",
 * //         Value: "STRING_VALUE",
 * //       },
 * //     ],
 * //   },
 * // };
 *
 * ```
 *
 * @param StartNetworkInsightsAccessScopeAnalysisCommandInput - {@link StartNetworkInsightsAccessScopeAnalysisCommandInput}
 * @returns {@link StartNetworkInsightsAccessScopeAnalysisCommandOutput}
 * @see {@link StartNetworkInsightsAccessScopeAnalysisCommandInput} for command's `input` shape.
 * @see {@link StartNetworkInsightsAccessScopeAnalysisCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class StartNetworkInsightsAccessScopeAnalysisCommand extends StartNetworkInsightsAccessScopeAnalysisCommand_base {
}
