import { _InstanceType, AccountAttribute, AccountAttributeName, ActiveInstance, Address, AddressAttribute, AddressAttributeName, AddressTransfer, AllocationState, AllowsMultipleInstanceTypes, AssociationStatus, AutoPlacement, BundleTask, ByoipCidr, CapacityReservation, CapacityReservationFleetState, CapacityReservationTenancy, ClientVpnAuthorizationRuleStatus, CurrencyCodeValues, FleetCapacityReservation, FleetCapacityReservationTenancy, FleetInstanceMatchCriteria, HostMaintenance, HostRecovery, IamInstanceProfileAssociation, Tag, TransitGatewayPeeringAttachment, TransitGatewayVpcAttachment, UnsuccessfulItem, VerifiedAccessInstance, VerifiedAccessTrustProvider } from "./models_0";
import { AttributeValue, BlockDeviceMapping, CarrierGateway, ClientVpnAuthenticationType, ClientVpnEndpointStatus, ClientVpnRouteStatus, CoipPool, CustomerGateway, DefaultTargetCapacityType, DestinationFileFormat, DhcpOptions, DiskImageFormat, EgressOnlyInternetGateway, ExportTask, FleetCapacityReservationUsageStrategy, FleetExcessCapacityTerminationPolicy, FleetLaunchTemplateOverrides, FleetLaunchTemplateSpecification, FleetOnDemandAllocationStrategy, FleetReplacementStrategy, FleetType, GroupIdentifier, InstanceLifecycle, LaunchTemplateAndOverridesResponse, LogDestinationType, PlatformValues, SpotAllocationStrategy, SpotInstanceInterruptionBehavior, StateReason, TargetCapacityUnitType, TrafficType, TransportProtocol } from "./models_1";
import { FleetStateCode, SubnetCidrReservation, TransitGateway, TransitGatewayConnect, TransitGatewayConnectPeer, TransitGatewayMulticastDomain, TransitGatewayPolicyTable, TransitGatewayPrefixListReference, TransitGatewayRoute, TransitGatewayRouteTable, TransitGatewayRouteTableAnnouncement, VerifiedAccessEndpoint, VerifiedAccessGroup } from "./models_2";
/**
 * @public
 */
export interface DeleteNatGatewayRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the NAT gateway.</p>
     * @public
     */
    NatGatewayId: string | undefined;
}
/**
 * @public
 */
export interface DeleteNatGatewayResult {
    /**
     * <p>The ID of the NAT gateway.</p>
     * @public
     */
    NatGatewayId?: string;
}
/**
 * @public
 */
export interface DeleteNetworkAclRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the network ACL.</p>
     * @public
     */
    NetworkAclId: string | undefined;
}
/**
 * @public
 */
export interface DeleteNetworkAclEntryRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>Indicates whether the rule is an egress rule.</p>
     * @public
     */
    Egress: boolean | undefined;
    /**
     * <p>The ID of the network ACL.</p>
     * @public
     */
    NetworkAclId: string | undefined;
    /**
     * <p>The rule number of the entry to delete.</p>
     * @public
     */
    RuleNumber: number | undefined;
}
/**
 * @public
 */
export interface DeleteNetworkInsightsAccessScopeRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the Network Access Scope.</p>
     * @public
     */
    NetworkInsightsAccessScopeId: string | undefined;
}
/**
 * @public
 */
export interface DeleteNetworkInsightsAccessScopeResult {
    /**
     * <p>The ID of the Network Access Scope.</p>
     * @public
     */
    NetworkInsightsAccessScopeId?: string;
}
/**
 * @public
 */
export interface DeleteNetworkInsightsAccessScopeAnalysisRequest {
    /**
     * <p>The ID of the Network Access Scope analysis.</p>
     * @public
     */
    NetworkInsightsAccessScopeAnalysisId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteNetworkInsightsAccessScopeAnalysisResult {
    /**
     * <p>The ID of the Network Access Scope analysis.</p>
     * @public
     */
    NetworkInsightsAccessScopeAnalysisId?: string;
}
/**
 * @public
 */
export interface DeleteNetworkInsightsAnalysisRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the network insights analysis.</p>
     * @public
     */
    NetworkInsightsAnalysisId: string | undefined;
}
/**
 * @public
 */
export interface DeleteNetworkInsightsAnalysisResult {
    /**
     * <p>The ID of the network insights analysis.</p>
     * @public
     */
    NetworkInsightsAnalysisId?: string;
}
/**
 * @public
 */
export interface DeleteNetworkInsightsPathRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the path.</p>
     * @public
     */
    NetworkInsightsPathId: string | undefined;
}
/**
 * @public
 */
export interface DeleteNetworkInsightsPathResult {
    /**
     * <p>The ID of the path.</p>
     * @public
     */
    NetworkInsightsPathId?: string;
}
/**
 * <p>Contains the parameters for DeleteNetworkInterface.</p>
 * @public
 */
export interface DeleteNetworkInterfaceRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *             and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *             Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the network interface.</p>
     * @public
     */
    NetworkInterfaceId: string | undefined;
}
/**
 * <p>Contains the parameters for DeleteNetworkInterfacePermission.</p>
 * @public
 */
export interface DeleteNetworkInterfacePermissionRequest {
    /**
     * <p>The ID of the network interface permission.</p>
     * @public
     */
    NetworkInterfacePermissionId: string | undefined;
    /**
     * <p>Specify <code>true</code> to remove the permission even if the network interface is
     * 			attached to an instance.</p>
     * @public
     */
    Force?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     * 			and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     * 			Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Contains the output for DeleteNetworkInterfacePermission.</p>
 * @public
 */
export interface DeleteNetworkInterfacePermissionResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds, otherwise returns an error.</p>
     * @public
     */
    Return?: boolean;
}
/**
 * @public
 */
export interface DeletePlacementGroupRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The name of the placement group.</p>
     * @public
     */
    GroupName: string | undefined;
}
/**
 * @public
 */
export interface DeletePublicIpv4PoolRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the public IPv4 pool you want to delete.</p>
     * @public
     */
    PoolId: string | undefined;
}
/**
 * @public
 */
export interface DeletePublicIpv4PoolResult {
    /**
     * <p>Information about the result of deleting the public IPv4 pool.</p>
     * @public
     */
    ReturnValue?: boolean;
}
/**
 * @public
 */
export interface DeleteQueuedReservedInstancesRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *       and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *       Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of the Reserved Instances.</p>
     * @public
     */
    ReservedInstancesIds: string[] | undefined;
}
/**
 * @public
 * @enum
 */
export declare const DeleteQueuedReservedInstancesErrorCode: {
    readonly RESERVED_INSTANCES_ID_INVALID: "reserved-instances-id-invalid";
    readonly RESERVED_INSTANCES_NOT_IN_QUEUED_STATE: "reserved-instances-not-in-queued-state";
    readonly UNEXPECTED_ERROR: "unexpected-error";
};
/**
 * @public
 */
export type DeleteQueuedReservedInstancesErrorCode = (typeof DeleteQueuedReservedInstancesErrorCode)[keyof typeof DeleteQueuedReservedInstancesErrorCode];
/**
 * <p>Describes the error for a Reserved Instance whose queued purchase could not be deleted.</p>
 * @public
 */
export interface DeleteQueuedReservedInstancesError {
    /**
     * <p>The error code.</p>
     * @public
     */
    Code?: DeleteQueuedReservedInstancesErrorCode;
    /**
     * <p>The error message.</p>
     * @public
     */
    Message?: string;
}
/**
 * <p>Describes a Reserved Instance whose queued purchase was not deleted.</p>
 * @public
 */
export interface FailedQueuedPurchaseDeletion {
    /**
     * <p>The error.</p>
     * @public
     */
    Error?: DeleteQueuedReservedInstancesError;
    /**
     * <p>The ID of the Reserved Instance.</p>
     * @public
     */
    ReservedInstancesId?: string;
}
/**
 * <p>Describes a Reserved Instance whose queued purchase was successfully deleted.</p>
 * @public
 */
export interface SuccessfulQueuedPurchaseDeletion {
    /**
     * <p>The ID of the Reserved Instance.</p>
     * @public
     */
    ReservedInstancesId?: string;
}
/**
 * @public
 */
export interface DeleteQueuedReservedInstancesResult {
    /**
     * <p>Information about the queued purchases that were successfully deleted.</p>
     * @public
     */
    SuccessfulQueuedPurchaseDeletions?: SuccessfulQueuedPurchaseDeletion[];
    /**
     * <p>Information about the queued purchases that could not be deleted.</p>
     * @public
     */
    FailedQueuedPurchaseDeletions?: FailedQueuedPurchaseDeletion[];
}
/**
 * @public
 */
export interface DeleteRouteRequest {
    /**
     * <p>The IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
     * @public
     */
    DestinationCidrBlock?: string;
    /**
     * <p>The IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
     * @public
     */
    DestinationIpv6CidrBlock?: string;
    /**
     * <p>The ID of the prefix list for the route.</p>
     * @public
     */
    DestinationPrefixListId?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the route table.</p>
     * @public
     */
    RouteTableId: string | undefined;
}
/**
 * @public
 */
export interface DeleteRouteTableRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the route table.</p>
     * @public
     */
    RouteTableId: string | undefined;
}
/**
 * @public
 */
export interface DeleteSecurityGroupRequest {
    /**
     * <p>The ID of the security group.</p>
     * @public
     */
    GroupId?: string;
    /**
     * <p>[Default VPC] The name of the security group. You can specify either the
     *             security group name or the security group ID. For security groups in a nondefault VPC,
     *             you must specify the security group ID.</p>
     * @public
     */
    GroupName?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteSnapshotRequest {
    /**
     * <p>The ID of the EBS snapshot.</p>
     * @public
     */
    SnapshotId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Contains the parameters for DeleteSpotDatafeedSubscription.</p>
 * @public
 */
export interface DeleteSpotDatafeedSubscriptionRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *             <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteSubnetRequest {
    /**
     * <p>The ID of the subnet.</p>
     * @public
     */
    SubnetId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteSubnetCidrReservationRequest {
    /**
     * <p>The ID of the subnet CIDR reservation.</p>
     * @public
     */
    SubnetCidrReservationId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteSubnetCidrReservationResult {
    /**
     * <p>Information about the deleted subnet CIDR reservation.</p>
     * @public
     */
    DeletedSubnetCidrReservation?: SubnetCidrReservation;
}
/**
 * @public
 */
export interface DeleteTagsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of the resources, separated by spaces.</p>
     *          <p>Constraints: Up to 1000 resource IDs. We recommend breaking up this request into smaller batches.</p>
     * @public
     */
    Resources: string[] | undefined;
    /**
     * <p>The tags to delete. Specify a tag key and an optional tag value to delete
     *             specific tags. If you specify a tag key without a tag value, we delete any tag with this
     *             key regardless of its value. If you specify a tag key with an empty string as the tag
     *             value, we delete the tag only if its value is an empty string.</p>
     *          <p>If you omit this parameter, we delete all user-defined tags for the specified
     *             resources. We do not delete Amazon Web Services-generated tags (tags that have the <code>aws:</code>
     *             prefix).</p>
     *          <p>Constraints: Up to 1000 tags.</p>
     * @public
     */
    Tags?: Tag[];
}
/**
 * @public
 */
export interface DeleteTrafficMirrorFilterRequest {
    /**
     * <p>The ID of the Traffic Mirror filter.</p>
     * @public
     */
    TrafficMirrorFilterId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteTrafficMirrorFilterResult {
    /**
     * <p>The ID of the Traffic Mirror filter.</p>
     * @public
     */
    TrafficMirrorFilterId?: string;
}
/**
 * @public
 */
export interface DeleteTrafficMirrorFilterRuleRequest {
    /**
     * <p>The ID of the Traffic Mirror rule.</p>
     * @public
     */
    TrafficMirrorFilterRuleId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteTrafficMirrorFilterRuleResult {
    /**
     * <p>The ID of the deleted Traffic Mirror rule.</p>
     * @public
     */
    TrafficMirrorFilterRuleId?: string;
}
/**
 * @public
 */
export interface DeleteTrafficMirrorSessionRequest {
    /**
     * <p>The ID of the Traffic Mirror session.</p>
     * @public
     */
    TrafficMirrorSessionId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteTrafficMirrorSessionResult {
    /**
     * <p>The ID of the deleted Traffic Mirror session.</p>
     * @public
     */
    TrafficMirrorSessionId?: string;
}
/**
 * @public
 */
export interface DeleteTrafficMirrorTargetRequest {
    /**
     * <p>The ID of the Traffic Mirror target.</p>
     * @public
     */
    TrafficMirrorTargetId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteTrafficMirrorTargetResult {
    /**
     * <p>The ID of the deleted Traffic Mirror target.</p>
     * @public
     */
    TrafficMirrorTargetId?: string;
}
/**
 * @public
 */
export interface DeleteTransitGatewayRequest {
    /**
     * <p>The ID of the transit gateway.</p>
     * @public
     */
    TransitGatewayId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteTransitGatewayResult {
    /**
     * <p>Information about the deleted transit gateway.</p>
     * @public
     */
    TransitGateway?: TransitGateway;
}
/**
 * @public
 */
export interface DeleteTransitGatewayConnectRequest {
    /**
     * <p>The ID of the Connect attachment.</p>
     * @public
     */
    TransitGatewayAttachmentId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteTransitGatewayConnectResult {
    /**
     * <p>Information about the deleted Connect attachment.</p>
     * @public
     */
    TransitGatewayConnect?: TransitGatewayConnect;
}
/**
 * @public
 */
export interface DeleteTransitGatewayConnectPeerRequest {
    /**
     * <p>The ID of the Connect peer.</p>
     * @public
     */
    TransitGatewayConnectPeerId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteTransitGatewayConnectPeerResult {
    /**
     * <p>Information about the deleted Connect peer.</p>
     * @public
     */
    TransitGatewayConnectPeer?: TransitGatewayConnectPeer;
}
/**
 * @public
 */
export interface DeleteTransitGatewayMulticastDomainRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     * @public
     */
    TransitGatewayMulticastDomainId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteTransitGatewayMulticastDomainResult {
    /**
     * <p>Information about the deleted transit gateway multicast domain.</p>
     * @public
     */
    TransitGatewayMulticastDomain?: TransitGatewayMulticastDomain;
}
/**
 * @public
 */
export interface DeleteTransitGatewayPeeringAttachmentRequest {
    /**
     * <p>The ID of the transit gateway peering attachment.</p>
     * @public
     */
    TransitGatewayAttachmentId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteTransitGatewayPeeringAttachmentResult {
    /**
     * <p>The transit gateway peering attachment.</p>
     * @public
     */
    TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
/**
 * @public
 */
export interface DeleteTransitGatewayPolicyTableRequest {
    /**
     * <p>The transit gateway policy table to delete.</p>
     * @public
     */
    TransitGatewayPolicyTableId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteTransitGatewayPolicyTableResult {
    /**
     * <p>Provides details about the deleted transit gateway policy table.</p>
     * @public
     */
    TransitGatewayPolicyTable?: TransitGatewayPolicyTable;
}
/**
 * @public
 */
export interface DeleteTransitGatewayPrefixListReferenceRequest {
    /**
     * <p>The ID of the route table.</p>
     * @public
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>The ID of the prefix list.</p>
     * @public
     */
    PrefixListId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteTransitGatewayPrefixListReferenceResult {
    /**
     * <p>Information about the deleted prefix list reference.</p>
     * @public
     */
    TransitGatewayPrefixListReference?: TransitGatewayPrefixListReference;
}
/**
 * @public
 */
export interface DeleteTransitGatewayRouteRequest {
    /**
     * <p>The ID of the transit gateway route table.</p>
     * @public
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>The CIDR range for the route. This must match the CIDR for the route exactly.</p>
     * @public
     */
    DestinationCidrBlock: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteTransitGatewayRouteResult {
    /**
     * <p>Information about the route.</p>
     * @public
     */
    Route?: TransitGatewayRoute;
}
/**
 * @public
 */
export interface DeleteTransitGatewayRouteTableRequest {
    /**
     * <p>The ID of the transit gateway route table.</p>
     * @public
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteTransitGatewayRouteTableResult {
    /**
     * <p>Information about the deleted transit gateway route table.</p>
     * @public
     */
    TransitGatewayRouteTable?: TransitGatewayRouteTable;
}
/**
 * @public
 */
export interface DeleteTransitGatewayRouteTableAnnouncementRequest {
    /**
     * <p>The transit gateway route table ID that's being deleted. </p>
     * @public
     */
    TransitGatewayRouteTableAnnouncementId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteTransitGatewayRouteTableAnnouncementResult {
    /**
     * <p>Provides details about a deleted transit gateway route table.</p>
     * @public
     */
    TransitGatewayRouteTableAnnouncement?: TransitGatewayRouteTableAnnouncement;
}
/**
 * @public
 */
export interface DeleteTransitGatewayVpcAttachmentRequest {
    /**
     * <p>The ID of the attachment.</p>
     * @public
     */
    TransitGatewayAttachmentId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteTransitGatewayVpcAttachmentResult {
    /**
     * <p>Information about the deleted VPC attachment.</p>
     * @public
     */
    TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
/**
 * @public
 */
export interface DeleteVerifiedAccessEndpointRequest {
    /**
     * <p>The ID of the Verified Access endpoint.</p>
     * @public
     */
    VerifiedAccessEndpointId: string | undefined;
    /**
     * <p>A unique, case-sensitive token that you provide to ensure idempotency of your
     *             modification request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
     * @public
     */
    ClientToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteVerifiedAccessEndpointResult {
    /**
     * <p>Details about the Verified Access endpoint.</p>
     * @public
     */
    VerifiedAccessEndpoint?: VerifiedAccessEndpoint;
}
/**
 * @public
 */
export interface DeleteVerifiedAccessGroupRequest {
    /**
     * <p>The ID of the Verified Access group.</p>
     * @public
     */
    VerifiedAccessGroupId: string | undefined;
    /**
     * <p>A unique, case-sensitive token that you provide to ensure idempotency of your
     *             modification request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
     * @public
     */
    ClientToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteVerifiedAccessGroupResult {
    /**
     * <p>Details about the Verified Access group.</p>
     * @public
     */
    VerifiedAccessGroup?: VerifiedAccessGroup;
}
/**
 * @public
 */
export interface DeleteVerifiedAccessInstanceRequest {
    /**
     * <p>The ID of the Verified Access instance.</p>
     * @public
     */
    VerifiedAccessInstanceId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>A unique, case-sensitive token that you provide to ensure idempotency of your
     *             modification request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
     * @public
     */
    ClientToken?: string;
}
/**
 * @public
 */
export interface DeleteVerifiedAccessInstanceResult {
    /**
     * <p>Details about the Verified Access instance.</p>
     * @public
     */
    VerifiedAccessInstance?: VerifiedAccessInstance;
}
/**
 * @public
 */
export interface DeleteVerifiedAccessTrustProviderRequest {
    /**
     * <p>The ID of the Verified Access trust provider.</p>
     * @public
     */
    VerifiedAccessTrustProviderId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>A unique, case-sensitive token that you provide to ensure idempotency of your
     *             modification request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
     * @public
     */
    ClientToken?: string;
}
/**
 * @public
 */
export interface DeleteVerifiedAccessTrustProviderResult {
    /**
     * <p>Details about the Verified Access trust provider.</p>
     * @public
     */
    VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider;
}
/**
 * @public
 */
export interface DeleteVolumeRequest {
    /**
     * <p>The ID of the volume.</p>
     * @public
     */
    VolumeId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteVpcRequest {
    /**
     * <p>The ID of the VPC.</p>
     * @public
     */
    VpcId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeleteVpcEndpointConnectionNotificationsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of the notifications.</p>
     * @public
     */
    ConnectionNotificationIds: string[] | undefined;
}
/**
 * @public
 */
export interface DeleteVpcEndpointConnectionNotificationsResult {
    /**
     * <p>Information about the notifications that could not be deleted
     *             successfully.</p>
     * @public
     */
    Unsuccessful?: UnsuccessfulItem[];
}
/**
 * @public
 */
export interface DeleteVpcEndpointsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of the VPC endpoints.</p>
     * @public
     */
    VpcEndpointIds: string[] | undefined;
}
/**
 * @public
 */
export interface DeleteVpcEndpointsResult {
    /**
     * <p>Information about the VPC endpoints that were not successfully deleted.</p>
     * @public
     */
    Unsuccessful?: UnsuccessfulItem[];
}
/**
 * @public
 */
export interface DeleteVpcEndpointServiceConfigurationsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of the services.</p>
     * @public
     */
    ServiceIds: string[] | undefined;
}
/**
 * @public
 */
export interface DeleteVpcEndpointServiceConfigurationsResult {
    /**
     * <p>Information about the service configurations that were not deleted, if
     *             applicable.</p>
     * @public
     */
    Unsuccessful?: UnsuccessfulItem[];
}
/**
 * @public
 */
export interface DeleteVpcPeeringConnectionRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the VPC peering connection.</p>
     * @public
     */
    VpcPeeringConnectionId: string | undefined;
}
/**
 * @public
 */
export interface DeleteVpcPeeringConnectionResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     * @public
     */
    Return?: boolean;
}
/**
 * <p>Contains the parameters for DeleteVpnConnection.</p>
 * @public
 */
export interface DeleteVpnConnectionRequest {
    /**
     * <p>The ID of the VPN connection.</p>
     * @public
     */
    VpnConnectionId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Contains the parameters for DeleteVpnConnectionRoute.</p>
 * @public
 */
export interface DeleteVpnConnectionRouteRequest {
    /**
     * <p>The CIDR block associated with the local subnet of the customer network.</p>
     * @public
     */
    DestinationCidrBlock: string | undefined;
    /**
     * <p>The ID of the VPN connection.</p>
     * @public
     */
    VpnConnectionId: string | undefined;
}
/**
 * <p>Contains the parameters for DeleteVpnGateway.</p>
 * @public
 */
export interface DeleteVpnGatewayRequest {
    /**
     * <p>The ID of the virtual private gateway.</p>
     * @public
     */
    VpnGatewayId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeprovisionByoipCidrRequest {
    /**
     * <p>The address range, in CIDR notation. The prefix must be the same prefix
     *          that you specified when you provisioned the address range.</p>
     * @public
     */
    Cidr: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DeprovisionByoipCidrResult {
    /**
     * <p>Information about the address range.</p>
     * @public
     */
    ByoipCidr?: ByoipCidr;
}
/**
 * @public
 */
export interface DeprovisionIpamByoasnRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The IPAM ID.</p>
     * @public
     */
    IpamId: string | undefined;
    /**
     * <p>An ASN.</p>
     * @public
     */
    Asn: string | undefined;
}
/**
 * @public
 * @enum
 */
export declare const AsnState: {
    readonly deprovisioned: "deprovisioned";
    readonly failed_deprovision: "failed-deprovision";
    readonly failed_provision: "failed-provision";
    readonly pending_deprovision: "pending-deprovision";
    readonly pending_provision: "pending-provision";
    readonly provisioned: "provisioned";
};
/**
 * @public
 */
export type AsnState = (typeof AsnState)[keyof typeof AsnState];
/**
 * <p>The Autonomous System Number (ASN) and BYOIP CIDR association.</p>
 * @public
 */
export interface Byoasn {
    /**
     * <p>A public 2-byte or 4-byte ASN.</p>
     * @public
     */
    Asn?: string;
    /**
     * <p>An IPAM ID.</p>
     * @public
     */
    IpamId?: string;
    /**
     * <p>The status message.</p>
     * @public
     */
    StatusMessage?: string;
    /**
     * <p>The provisioning state of the BYOASN.</p>
     * @public
     */
    State?: AsnState;
}
/**
 * @public
 */
export interface DeprovisionIpamByoasnResult {
    /**
     * <p>An ASN and BYOIP CIDR association.</p>
     * @public
     */
    Byoasn?: Byoasn;
}
/**
 * @public
 */
export interface DeprovisionIpamPoolCidrRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the pool that has the CIDR you want to deprovision.</p>
     * @public
     */
    IpamPoolId: string | undefined;
    /**
     * <p>The CIDR which you want to deprovision from the pool.</p>
     * @public
     */
    Cidr?: string;
}
/**
 * @public
 * @enum
 */
export declare const IpamPoolCidrFailureCode: {
    readonly cidr_not_available: "cidr-not-available";
    readonly limit_exceeded: "limit-exceeded";
};
/**
 * @public
 */
export type IpamPoolCidrFailureCode = (typeof IpamPoolCidrFailureCode)[keyof typeof IpamPoolCidrFailureCode];
/**
 * <p>Details related to why an IPAM pool CIDR failed to be provisioned.</p>
 * @public
 */
export interface IpamPoolCidrFailureReason {
    /**
     * <p>An error code related to why an IPAM pool CIDR failed to be provisioned.</p>
     * @public
     */
    Code?: IpamPoolCidrFailureCode;
    /**
     * <p>A message related to why an IPAM pool CIDR failed to be provisioned.</p>
     * @public
     */
    Message?: string;
}
/**
 * @public
 * @enum
 */
export declare const IpamPoolCidrState: {
    readonly deprovisioned: "deprovisioned";
    readonly failed_deprovision: "failed-deprovision";
    readonly failed_import: "failed-import";
    readonly failed_provision: "failed-provision";
    readonly pending_deprovision: "pending-deprovision";
    readonly pending_import: "pending-import";
    readonly pending_provision: "pending-provision";
    readonly provisioned: "provisioned";
};
/**
 * @public
 */
export type IpamPoolCidrState = (typeof IpamPoolCidrState)[keyof typeof IpamPoolCidrState];
/**
 * <p>A CIDR provisioned to an IPAM pool.</p>
 * @public
 */
export interface IpamPoolCidr {
    /**
     * <p>The CIDR provisioned to the IPAM pool. A CIDR is a representation of an IP address and its associated network mask (or netmask)
     *          and refers to a range of IP addresses. An IPv4 CIDR example is <code>10.24.34.0/23</code>. An IPv6 CIDR example is <code>2001:DB8::/32</code>.</p>
     * @public
     */
    Cidr?: string;
    /**
     * <p>The state of the CIDR.</p>
     * @public
     */
    State?: IpamPoolCidrState;
    /**
     * <p>Details related to why an IPAM pool CIDR failed to be provisioned.</p>
     * @public
     */
    FailureReason?: IpamPoolCidrFailureReason;
    /**
     * <p>The IPAM pool CIDR ID.</p>
     * @public
     */
    IpamPoolCidrId?: string;
    /**
     * <p>The netmask length of the CIDR you'd like to provision to a pool. Can be used for provisioning Amazon-provided IPv6 CIDRs to top-level pools and for provisioning CIDRs to pools with source pools. Cannot be used to provision BYOIP CIDRs to top-level pools. "NetmaskLength" or "Cidr" is required.</p>
     * @public
     */
    NetmaskLength?: number;
}
/**
 * @public
 */
export interface DeprovisionIpamPoolCidrResult {
    /**
     * <p>The deprovisioned pool CIDR.</p>
     * @public
     */
    IpamPoolCidr?: IpamPoolCidr;
}
/**
 * @public
 */
export interface DeprovisionPublicIpv4PoolCidrRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the pool that you want to deprovision the CIDR from.</p>
     * @public
     */
    PoolId: string | undefined;
    /**
     * <p>The CIDR you want to deprovision from the pool. Enter the CIDR you want to deprovision with a netmask of <code>/32</code>. You must rerun this command for each IP address in the CIDR range. If your CIDR is a <code>/24</code>, you will have to run this command to deprovision each of the 256 IP addresses in the <code>/24</code> CIDR.</p>
     * @public
     */
    Cidr: string | undefined;
}
/**
 * @public
 */
export interface DeprovisionPublicIpv4PoolCidrResult {
    /**
     * <p>The ID of the pool that you deprovisioned the CIDR from.</p>
     * @public
     */
    PoolId?: string;
    /**
     * <p>The deprovisioned CIDRs.</p>
     * @public
     */
    DeprovisionedAddresses?: string[];
}
/**
 * <p>Contains the parameters for DeregisterImage.</p>
 * @public
 */
export interface DeregisterImageRequest {
    /**
     * <p>The ID of the AMI.</p>
     * @public
     */
    ImageId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     * 			and provides an error response. If you have the required permissions, the error response is
     * 			<code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Information about the tag keys to deregister for the current Region. You can either specify
 *    		individual tag keys or deregister all tag keys in the current Region. You must specify either
 *    		<code>IncludeAllTagsOfInstance</code> or <code>InstanceTagKeys</code> in the request</p>
 * @public
 */
export interface DeregisterInstanceTagAttributeRequest {
    /**
     * <p>Indicates whether to deregister all tag keys in the current Region. Specify <code>false</code>
     *    		to deregister all tag keys.</p>
     * @public
     */
    IncludeAllTagsOfInstance?: boolean;
    /**
     * <p>Information about the tag keys to deregister.</p>
     * @public
     */
    InstanceTagKeys?: string[];
}
/**
 * @public
 */
export interface DeregisterInstanceEventNotificationAttributesRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>Information about the tag keys to deregister.</p>
     * @public
     */
    InstanceTagAttribute: DeregisterInstanceTagAttributeRequest | undefined;
}
/**
 * <p>Describes the registered tag keys for the current Region.</p>
 * @public
 */
export interface InstanceTagNotificationAttribute {
    /**
     * <p>The registered tag keys.</p>
     * @public
     */
    InstanceTagKeys?: string[];
    /**
     * <p>Indicates wheter all tag keys in the current Region are registered to appear in scheduled event notifications.
     *       	<code>true</code> indicates that all tag keys in the current Region are registered.</p>
     * @public
     */
    IncludeAllTagsOfInstance?: boolean;
}
/**
 * @public
 */
export interface DeregisterInstanceEventNotificationAttributesResult {
    /**
     * <p>The resulting set of tag keys.</p>
     * @public
     */
    InstanceTagAttribute?: InstanceTagNotificationAttribute;
}
/**
 * @public
 */
export interface DeregisterTransitGatewayMulticastGroupMembersRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     * @public
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     * @public
     */
    GroupIpAddress?: string;
    /**
     * <p>The IDs of the group members' network interfaces.</p>
     * @public
     */
    NetworkInterfaceIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Describes the deregistered  transit gateway multicast group members.</p>
 * @public
 */
export interface TransitGatewayMulticastDeregisteredGroupMembers {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     * @public
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The network interface IDs of the deregistered members.</p>
     * @public
     */
    DeregisteredNetworkInterfaceIds?: string[];
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     * @public
     */
    GroupIpAddress?: string;
}
/**
 * @public
 */
export interface DeregisterTransitGatewayMulticastGroupMembersResult {
    /**
     * <p>Information about the deregistered members.</p>
     * @public
     */
    DeregisteredMulticastGroupMembers?: TransitGatewayMulticastDeregisteredGroupMembers;
}
/**
 * @public
 */
export interface DeregisterTransitGatewayMulticastGroupSourcesRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     * @public
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     * @public
     */
    GroupIpAddress?: string;
    /**
     * <p>The IDs of the group sources' network interfaces.</p>
     * @public
     */
    NetworkInterfaceIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Describes the deregistered  transit gateway multicast group sources.</p>
 * @public
 */
export interface TransitGatewayMulticastDeregisteredGroupSources {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     * @public
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The network interface IDs of the non-registered members.</p>
     * @public
     */
    DeregisteredNetworkInterfaceIds?: string[];
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     * @public
     */
    GroupIpAddress?: string;
}
/**
 * @public
 */
export interface DeregisterTransitGatewayMulticastGroupSourcesResult {
    /**
     * <p>Information about the deregistered group sources.</p>
     * @public
     */
    DeregisteredMulticastGroupSources?: TransitGatewayMulticastDeregisteredGroupSources;
}
/**
 * @public
 */
export interface DescribeAccountAttributesRequest {
    /**
     * <p>The account attribute names.</p>
     * @public
     */
    AttributeNames?: AccountAttributeName[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *            and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *            Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DescribeAccountAttributesResult {
    /**
     * <p>Information about the account attributes.</p>
     * @public
     */
    AccountAttributes?: AccountAttribute[];
}
/**
 * <p>A filter name and value pair that is used to return a more specific list of results from a describe operation.
 *          Filters can be used to match a set of resources by specific criteria, such as tags, attributes, or IDs.</p>
 *          <p>If you specify multiple filters, the filters are joined with an <code>AND</code>, and the request returns only
 *            results that match all of the specified filters.</p>
 * @public
 */
export interface Filter {
    /**
     * <p>The name of the filter. Filter names are case-sensitive.</p>
     * @public
     */
    Name?: string;
    /**
     * <p>The filter values. Filter values are case-sensitive. If you specify multiple values for a
     *          filter, the values are joined with an <code>OR</code>, and the request returns all results
     *          that match any of the specified values.</p>
     * @public
     */
    Values?: string[];
}
/**
 * @public
 */
export interface DescribeAddressesRequest {
    /**
     * <p>One or more filters. Filter names and values are case-sensitive.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>allocation-id</code> - The allocation ID for the address.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>association-id</code> - The association ID for the address.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>instance-id</code> - The ID of the instance the address is associated with, if any.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>network-border-group</code> -  A unique set of Availability Zones, Local Zones,
     *            or Wavelength Zones from where Amazon Web Services advertises IP addresses. </p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>network-interface-id</code> - The ID of the network interface that the address is associated with, if any.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>network-interface-owner-id</code> - The Amazon Web Services account ID of the owner.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>private-ip-address</code> - The private IP address associated with the Elastic IP address.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>public-ip</code> - The Elastic IP address, or the carrier IP address.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>One or more Elastic IP addresses.</p>
     *          <p>Default: Describes all your Elastic IP addresses.</p>
     * @public
     */
    PublicIps?: string[];
    /**
     * <p>Information about the allocation IDs.</p>
     * @public
     */
    AllocationIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DescribeAddressesResult {
    /**
     * <p>Information about the Elastic IP addresses.</p>
     * @public
     */
    Addresses?: Address[];
}
/**
 * @public
 */
export interface DescribeAddressesAttributeRequest {
    /**
     * <p>[EC2-VPC] The allocation IDs.</p>
     * @public
     */
    AllocationIds?: string[];
    /**
     * <p>The attribute of the IP address.</p>
     * @public
     */
    Attribute?: AddressAttributeName;
    /**
     * <p>The token for the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DescribeAddressesAttributeResult {
    /**
     * <p>Information about the IP addresses.</p>
     * @public
     */
    Addresses?: AddressAttribute[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeAddressTransfersRequest {
    /**
     * <p>The allocation IDs of Elastic IP addresses.</p>
     * @public
     */
    AllocationIds?: string[];
    /**
     * <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>The maximum number of address transfers to return in one page of results.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DescribeAddressTransfersResult {
    /**
     * <p>The Elastic IP address transfer.</p>
     * @public
     */
    AddressTransfers?: AddressTransfer[];
    /**
     * <p>Specify the pagination token from a previous request to retrieve the next page of results.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeAggregateIdFormatRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Describes the ID format for a resource.</p>
 * @public
 */
export interface IdFormat {
    /**
     * <p>The date in UTC at which you are permanently switched over to using longer IDs. If a deadline is not yet available for this resource type, this field is not returned.</p>
     * @public
     */
    Deadline?: Date;
    /**
     * <p>The type of resource.</p>
     * @public
     */
    Resource?: string;
    /**
     * <p>Indicates whether longer IDs (17-character IDs) are enabled for the resource.</p>
     * @public
     */
    UseLongIds?: boolean;
}
/**
 * @public
 */
export interface DescribeAggregateIdFormatResult {
    /**
     * <p>Indicates whether all resource types in the Region are configured to use longer IDs.
     *             This value is only <code>true</code> if all users are configured to use longer IDs for
     *             all resources types in the Region.</p>
     * @public
     */
    UseLongIdsAggregated?: boolean;
    /**
     * <p>Information about each resource's ID format.</p>
     * @public
     */
    Statuses?: IdFormat[];
}
/**
 * @public
 */
export interface DescribeAvailabilityZonesRequest {
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>group-name</code> - For Availability Zones, use the Region name. For Local
     *           Zones, use the name of the group associated with the Local Zone (for example,
     *             <code>us-west-2-lax-1</code>) For Wavelength Zones, use the name of the group associated
     *           with the Wavelength Zone (for example, <code>us-east-1-wl1</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>message</code> - The Zone message.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>opt-in-status</code> - The opt-in status (<code>opted-in</code> |
     *             <code>not-opted-in</code> | <code>opt-in-not-required</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>parent-zone-id</code> - The ID of the zone that handles some of the Local Zone
     *           and Wavelength Zone control plane operations, such as API calls.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>parent-zone-name</code> - The ID of the zone that handles some of the Local Zone
     *           and Wavelength Zone control plane operations, such as API calls.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>region-name</code> - The name of the Region for the Zone (for example,
     *             <code>us-east-1</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the Availability Zone, the Local Zone, or the
     *           Wavelength Zone (<code>available</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>zone-id</code> - The ID of the Availability Zone (for example,
     *             <code>use1-az1</code>), the Local Zone (for example, <code>usw2-lax1-az1</code>), or the
     *           Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>zone-name</code> - The name of the Availability Zone (for example,
     *             <code>us-east-1a</code>), the Local Zone (for example, <code>us-west-2-lax-1a</code>), or
     *           the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>zone-type</code> - The type of zone (<code>availability-zone</code> |
     *           <code>local-zone</code> | <code>wavelength-zone</code>).</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The names of the Availability Zones, Local Zones, and Wavelength Zones.</p>
     * @public
     */
    ZoneNames?: string[];
    /**
     * <p>The IDs of the Availability Zones, Local Zones, and Wavelength Zones.</p>
     * @public
     */
    ZoneIds?: string[];
    /**
     * <p>Include all Availability Zones, Local Zones, and Wavelength Zones regardless of your
     *       opt-in status.</p>
     *          <p>If you do not use this parameter, the results include only the zones for the Regions where you have chosen the option to opt in.</p>
     * @public
     */
    AllAvailabilityZones?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Describes a message about an Availability Zone, Local Zone, or Wavelength Zone.</p>
 * @public
 */
export interface AvailabilityZoneMessage {
    /**
     * <p>The message about the Availability Zone, Local Zone, or Wavelength Zone.</p>
     * @public
     */
    Message?: string;
}
/**
 * @public
 * @enum
 */
export declare const AvailabilityZoneOptInStatus: {
    readonly not_opted_in: "not-opted-in";
    readonly opt_in_not_required: "opt-in-not-required";
    readonly opted_in: "opted-in";
};
/**
 * @public
 */
export type AvailabilityZoneOptInStatus = (typeof AvailabilityZoneOptInStatus)[keyof typeof AvailabilityZoneOptInStatus];
/**
 * @public
 * @enum
 */
export declare const AvailabilityZoneState: {
    readonly available: "available";
    readonly constrained: "constrained";
    readonly impaired: "impaired";
    readonly information: "information";
    readonly unavailable: "unavailable";
};
/**
 * @public
 */
export type AvailabilityZoneState = (typeof AvailabilityZoneState)[keyof typeof AvailabilityZoneState];
/**
 * <p>Describes Availability Zones, Local Zones, and Wavelength Zones.</p>
 * @public
 */
export interface AvailabilityZone {
    /**
     * <p>The state of the Availability Zone, Local Zone, or Wavelength Zone. This value is always
     *         <code>available</code>.</p>
     * @public
     */
    State?: AvailabilityZoneState;
    /**
     * <p>For Availability Zones, this parameter always has the value of
     *         <code>opt-in-not-required</code>.</p>
     *          <p>For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible
     *       values are <code>opted-in</code>, and <code>not-opted-in</code>.</p>
     * @public
     */
    OptInStatus?: AvailabilityZoneOptInStatus;
    /**
     * <p>Any messages about the Availability Zone, Local Zone, or Wavelength Zone.</p>
     * @public
     */
    Messages?: AvailabilityZoneMessage[];
    /**
     * <p>The name of the Region.</p>
     * @public
     */
    RegionName?: string;
    /**
     * <p>The name of the Availability Zone, Local Zone, or Wavelength Zone.</p>
     * @public
     */
    ZoneName?: string;
    /**
     * <p>The ID of the Availability Zone, Local Zone, or Wavelength Zone.</p>
     * @public
     */
    ZoneId?: string;
    /**
     * <p> For Availability Zones, this parameter has the same value as the Region name.</p>
     *          <p>For Local Zones, the name of the associated group, for example
     *         <code>us-west-2-lax-1</code>.</p>
     *          <p>For Wavelength Zones, the name of the associated group, for example
     *         <code>us-east-1-wl1-bos-wlz-1</code>.</p>
     * @public
     */
    GroupName?: string;
    /**
     * <p>The name of the network border group.</p>
     * @public
     */
    NetworkBorderGroup?: string;
    /**
     * <p>The type of zone. The valid values are <code>availability-zone</code>,
     *         <code>local-zone</code>, and <code>wavelength-zone</code>.</p>
     * @public
     */
    ZoneType?: string;
    /**
     * <p>The name of the zone that handles some of the Local Zone or Wavelength Zone control plane
     *       operations, such as API calls.</p>
     * @public
     */
    ParentZoneName?: string;
    /**
     * <p>The ID of the zone that handles some of the Local Zone or Wavelength Zone control plane
     *       operations, such as API calls.</p>
     * @public
     */
    ParentZoneId?: string;
}
/**
 * @public
 */
export interface DescribeAvailabilityZonesResult {
    /**
     * <p>Information about the Availability Zones, Local Zones, and Wavelength Zones.</p>
     * @public
     */
    AvailabilityZones?: AvailabilityZone[];
}
/**
 * @public
 */
export interface DescribeAwsNetworkPerformanceMetricSubscriptionsRequest {
    /**
     * <p>The maximum number of results to return with a single call.
     *    To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>One or more filters.</p>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 * @enum
 */
export declare const MetricType: {
    readonly aggregate_latency: "aggregate-latency";
};
/**
 * @public
 */
export type MetricType = (typeof MetricType)[keyof typeof MetricType];
/**
 * @public
 * @enum
 */
export declare const PeriodType: {
    readonly fifteen_minutes: "fifteen-minutes";
    readonly five_minutes: "five-minutes";
    readonly one_day: "one-day";
    readonly one_hour: "one-hour";
    readonly one_week: "one-week";
    readonly three_hours: "three-hours";
};
/**
 * @public
 */
export type PeriodType = (typeof PeriodType)[keyof typeof PeriodType];
/**
 * @public
 * @enum
 */
export declare const StatisticType: {
    readonly p50: "p50";
};
/**
 * @public
 */
export type StatisticType = (typeof StatisticType)[keyof typeof StatisticType];
/**
 * <p>Describes an Infrastructure Performance subscription.</p>
 * @public
 */
export interface Subscription {
    /**
     * <p>The Region or Availability Zone that's the source for the subscription. For example, <code>us-east-1</code>.</p>
     * @public
     */
    Source?: string;
    /**
     * <p>The Region or Availability Zone that's the target for the subscription. For example, <code>eu-west-1</code>.</p>
     * @public
     */
    Destination?: string;
    /**
     * <p>The metric used for the subscription.</p>
     * @public
     */
    Metric?: MetricType;
    /**
     * <p>The statistic used for the subscription.</p>
     * @public
     */
    Statistic?: StatisticType;
    /**
     * <p>The data aggregation time for the subscription.</p>
     * @public
     */
    Period?: PeriodType;
}
/**
 * @public
 */
export interface DescribeAwsNetworkPerformanceMetricSubscriptionsResult {
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>Describes the current Infrastructure Performance subscriptions.</p>
     * @public
     */
    Subscriptions?: Subscription[];
}
/**
 * @public
 */
export interface DescribeBundleTasksRequest {
    /**
     * <p>The bundle task IDs.</p>
     *          <p>Default: Describes all your bundle tasks.</p>
     * @public
     */
    BundleIds?: string[];
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>bundle-id</code> - The ID of the bundle task.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>error-code</code> - If the task failed, the error code returned.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>error-message</code> - If the task failed, the error message returned.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>instance-id</code> - The ID of the instance.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>progress</code> - The level of task completion, as a percentage (for example, 20%).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>s3-prefix</code> - The beginning of the AMI name.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> | <code>bundling</code> |
     *            <code>storing</code> | <code>cancelling</code> | <code>complete</code> | <code>failed</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>update-time</code> - The time of the most recent update for the task.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     * 			and provides an error response. If you have the required permissions, the error response is
     * 			<code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DescribeBundleTasksResult {
    /**
     * <p>Information about the bundle tasks.</p>
     * @public
     */
    BundleTasks?: BundleTask[];
}
/**
 * @public
 */
export interface DescribeByoipCidrsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     * @public
     */
    MaxResults: number | undefined;
    /**
     * <p>The token for the next page of results.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeByoipCidrsResult {
    /**
     * <p>Information about your address ranges.</p>
     * @public
     */
    ByoipCidrs?: ByoipCidr[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeCapacityBlockOfferingsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The type of instance for which the Capacity Block offering reserves capacity.</p>
     * @public
     */
    InstanceType: string | undefined;
    /**
     * <p>The number of instances for which to reserve capacity.</p>
     * @public
     */
    InstanceCount: number | undefined;
    /**
     * <p>The earliest start date for the Capacity Block offering.</p>
     * @public
     */
    StartDateRange?: Date;
    /**
     * <p>The latest end date for the Capacity Block offering.</p>
     * @public
     */
    EndDateRange?: Date;
    /**
     * <p>The number of hours for which to reserve Capacity Block.</p>
     * @public
     */
    CapacityDurationHours: number | undefined;
    /**
     * <p>The token to use to retrieve the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information,
     *     see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>
     * @public
     */
    MaxResults?: number;
}
/**
 * <p>The recommended Capacity Block that fits your search requirements.</p>
 * @public
 */
export interface CapacityBlockOffering {
    /**
     * <p>The ID of the Capacity Block offering.</p>
     * @public
     */
    CapacityBlockOfferingId?: string;
    /**
     * <p>The instance type of the Capacity Block offering.</p>
     * @public
     */
    InstanceType?: string;
    /**
     * <p>The Availability Zone of the Capacity Block offering.</p>
     * @public
     */
    AvailabilityZone?: string;
    /**
     * <p>The number of instances in the Capacity Block offering.</p>
     * @public
     */
    InstanceCount?: number;
    /**
     * <p>The start date of the Capacity Block offering.</p>
     * @public
     */
    StartDate?: Date;
    /**
     * <p>The end date of the Capacity Block offering.</p>
     * @public
     */
    EndDate?: Date;
    /**
     * <p>The amount of time of the Capacity Block reservation in hours.</p>
     * @public
     */
    CapacityBlockDurationHours?: number;
    /**
     * <p>The total price to be paid up front.</p>
     * @public
     */
    UpfrontFee?: string;
    /**
     * <p>The currency of the payment for the Capacity Block.</p>
     * @public
     */
    CurrencyCode?: string;
    /**
     * <p>The tenancy of the Capacity Block.</p>
     * @public
     */
    Tenancy?: CapacityReservationTenancy;
}
/**
 * @public
 */
export interface DescribeCapacityBlockOfferingsResult {
    /**
     * <p>The recommended Capacity Block offering for the dates specified.</p>
     * @public
     */
    CapacityBlockOfferings?: CapacityBlockOffering[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeCapacityReservationFleetsRequest {
    /**
     * <p>The IDs of the Capacity Reservation Fleets to describe.</p>
     * @public
     */
    CapacityReservationFleetIds?: string[];
    /**
     * <p>The token to use to retrieve the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information,
     *     see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>One or more filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the Fleet (<code>submitted</code> | <code>modifying</code> | <code>active</code> |
     * 					<code>partially_fulfilled</code> | <code>expiring</code> | <code>expired</code> | <code>cancelling</code> |
     * 					<code>cancelled</code> | <code>failed</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>instance-match-criteria</code> - The instance matching criteria for the Fleet. Only <code>open</code> is supported.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tenancy</code> - The tenancy of the Fleet (<code>default</code> | <code>dedicated</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>allocation-strategy</code> - The allocation strategy used by the Fleet. Only <code>prioritized</code> is supported.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Information about a Capacity Reservation Fleet.</p>
 * @public
 */
export interface CapacityReservationFleet {
    /**
     * <p>The ID of the Capacity Reservation Fleet.</p>
     * @public
     */
    CapacityReservationFleetId?: string;
    /**
     * <p>The ARN of the Capacity Reservation Fleet.</p>
     * @public
     */
    CapacityReservationFleetArn?: string;
    /**
     * <p>The state of the Capacity Reservation Fleet. Possible states include:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>submitted</code> - The Capacity Reservation Fleet request has been submitted
     * 					and Amazon Elastic Compute Cloud is preparing to create the Capacity Reservations.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>modifying</code> - The Capacity Reservation Fleet is being modified. The Fleet
     * 					remains in this state until the modification is complete.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>active</code> - The Capacity Reservation Fleet has fulfilled its total target
     * 					capacity and it is attempting to maintain this capacity. The Fleet remains in this
     * 					state until it is modified or deleted.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>partially_fulfilled</code> - The Capacity Reservation Fleet has partially
     * 					fulfilled its total target capacity. There is insufficient Amazon EC2 to
     * 					fulfill the total target capacity. The Fleet is attempting to asynchronously fulfill
     * 					its total target capacity.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>expiring</code> - The Capacity Reservation Fleet has reach its end date and it
     * 					is in the process of expiring. One or more of its Capacity reservations might still
     * 					be active.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>expired</code> - The Capacity Reservation Fleet has reach its end date. The Fleet
     * 					and its Capacity Reservations are expired. The Fleet can't create new Capacity
     * 					Reservations.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>cancelling</code> - The Capacity Reservation Fleet is in the process of being
     * 					cancelled. One or more of its Capacity reservations might still be active.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>cancelled</code> - The Capacity Reservation Fleet has been manually cancelled.
     * 					The Fleet and its Capacity Reservations are cancelled and the Fleet can't create new
     * 					Capacity Reservations.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>failed</code> - The Capacity Reservation Fleet failed to reserve capacity for
     * 					the specified instance types.</p>
     *             </li>
     *          </ul>
     * @public
     */
    State?: CapacityReservationFleetState;
    /**
     * <p>The total number of capacity units for which the Capacity Reservation Fleet reserves capacity.
     * 			For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity</a>
     * 			in the Amazon EC2 User Guide.</p>
     * @public
     */
    TotalTargetCapacity?: number;
    /**
     * <p>The capacity units that have been fulfilled.</p>
     * @public
     */
    TotalFulfilledCapacity?: number;
    /**
     * <p>The tenancy of the Capacity Reservation Fleet. Tenancies include:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>default</code> - The Capacity Reservation Fleet is created on hardware that is
     * 					shared with other Amazon Web Services accounts.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>dedicated</code> - The Capacity Reservation Fleet is created on single-tenant
     * 					hardware that is dedicated to a single Amazon Web Services account.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Tenancy?: FleetCapacityReservationTenancy;
    /**
     * <p>The date and time at which the Capacity Reservation Fleet expires.</p>
     * @public
     */
    EndDate?: Date;
    /**
     * <p>The date and time at which the Capacity Reservation Fleet was created.</p>
     * @public
     */
    CreateTime?: Date;
    /**
     * <p>Indicates the type of instance launches that the Capacity Reservation Fleet accepts. All
     * 			Capacity Reservations in the Fleet inherit this instance matching criteria.</p>
     *          <p>Currently, Capacity Reservation Fleets support <code>open</code> instance matching criteria
     * 			only. This means that instances that have matching attributes (instance type, platform, and
     * 			Availability Zone) run in the Capacity Reservations automatically. Instances do not need to
     * 			explicitly target a Capacity Reservation Fleet to use its reserved capacity.</p>
     * @public
     */
    InstanceMatchCriteria?: FleetInstanceMatchCriteria;
    /**
     * <p>The strategy used by the Capacity Reservation Fleet to determine which of the specified
     * 			instance types to use. For more information, see For more information, see
     * 			<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy">
     * 				Allocation strategy</a> in the Amazon EC2 User Guide.</p>
     * @public
     */
    AllocationStrategy?: string;
    /**
     * <p>Information about the instance types for which to reserve the capacity.</p>
     * @public
     */
    InstanceTypeSpecifications?: FleetCapacityReservation[];
    /**
     * <p>The tags assigned to the Capacity Reservation Fleet.</p>
     * @public
     */
    Tags?: Tag[];
}
/**
 * @public
 */
export interface DescribeCapacityReservationFleetsResult {
    /**
     * <p>Information about the Capacity Reservation Fleets.</p>
     * @public
     */
    CapacityReservationFleets?: CapacityReservationFleet[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeCapacityReservationsRequest {
    /**
     * <p>The ID of the Capacity Reservation.</p>
     * @public
     */
    CapacityReservationIds?: string[];
    /**
     * <p>The token to use to retrieve the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>The maximum number of items to return for this request. To get the next page of items, make another request with the token returned in the output. For more information,
     *     see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>One or more filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>instance-type</code> - The type of instance for which the Capacity Reservation reserves capacity.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>owner-id</code> - The ID of the Amazon Web Services account that owns the Capacity Reservation.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>instance-platform</code> - The type of operating system for which the Capacity Reservation reserves capacity.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>availability-zone</code> - The Availability Zone of the Capacity Reservation.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tenancy</code> - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the
     * 	  			following tenancy settings:</p>
     *                <ul>
     *                   <li>
     *                      <p>
     *                         <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.</p>
     *                   </li>
     *                   <li>
     *                      <p>
     *                         <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p>
     *                   </li>
     *                </ul>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:</p>
     *                <ul>
     *                   <li>
     *                      <p>
     *                         <code>active</code>- The Capacity Reservation is active and the capacity is available for your use.</p>
     *                   </li>
     *                   <li>
     *                      <p>
     *                         <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your request.
     * 	  				The reserved capacity is no longer available for your use.</p>
     *                   </li>
     *                   <li>
     *                      <p>
     *                         <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.</p>
     *                   </li>
     *                   <li>
     *                      <p>
     *                         <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still pending.</p>
     *                   </li>
     *                   <li>
     *                      <p>
     *                         <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request parameters,
     * 	  				capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.</p>
     *                   </li>
     *                </ul>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>start-date</code> - The date and time at which the Capacity Reservation was started.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>end-date</code> - The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is
     * 	  			released and you can no longer launch instances into it. The Capacity Reservation's state changes to expired when it reaches its end date and time.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>end-date-type</code> - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p>
     *                <ul>
     *                   <li>
     *                      <p>
     *                         <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.</p>
     *                   </li>
     *                   <li>
     *                      <p>
     *                         <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.</p>
     *                   </li>
     *                </ul>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>instance-match-criteria</code> - Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p>
     *                <ul>
     *                   <li>
     *                      <p>
     *                         <code>open</code> - The Capacity Reservation accepts all instances that have matching
     * 							attributes (instance type, platform, and Availability Zone). Instances
     * 							that have matching attributes launch into the Capacity Reservation
     * 							automatically without specifying any additional parameters.</p>
     *                   </li>
     *                   <li>
     *                      <p>
     *                         <code>targeted</code> - The Capacity Reservation only accepts instances that have matching
     * 							attributes (instance type, platform, and Availability Zone), and
     * 							explicitly target the Capacity Reservation. This ensures that only
     * 							permitted instances can use the reserved capacity.</p>
     *                   </li>
     *                </ul>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>placement-group-arn</code> - The ARN of the cluster placement group in which the Capacity Reservation was created.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DescribeCapacityReservationsResult {
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>Information about the Capacity Reservations.</p>
     * @public
     */
    CapacityReservations?: CapacityReservation[];
}
/**
 * @public
 */
export interface DescribeCarrierGatewaysRequest {
    /**
     * <p>One or more carrier gateway IDs.</p>
     * @public
     */
    CarrierGatewayIds?: string[];
    /**
     * <p>One or more filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>carrier-gateway-id</code> - The ID of the carrier gateway.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the carrier gateway (<code>pending</code> |
     *                     <code>failed</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>owner-id</code> - The Amazon Web Services account ID of the owner of the carrier gateway.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>vpc-id</code> - The ID of the VPC associated with the carrier gateway.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DescribeCarrierGatewaysResult {
    /**
     * <p>Information about the carrier gateway.</p>
     * @public
     */
    CarrierGateways?: CarrierGateway[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeClassicLinkInstancesRequest {
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>group-id</code> - The ID of a VPC security group that's associated with the instance.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>instance-id</code> - The ID of the instance.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>vpc-id</code> - The ID of the VPC to which the instance is linked.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The instance IDs. Must be instances linked to a VPC through ClassicLink.</p>
     * @public
     */
    InstanceIds?: string[];
    /**
     * <p>The maximum number of items to return for this request.
     * 	To get the next page of items, make another request with the token returned in the output.
     * 	For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>
     *          <p>Constraint: If the value is greater than 1000, we return only 1000 items.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token returned from a previous paginated request. Pagination continues from the end of the items returned by the previous request.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * <note>
 *             <p>Deprecated.</p>
 *          </note>
 *          <p>Describes a linked EC2-Classic instance.</p>
 * @public
 */
export interface ClassicLinkInstance {
    /**
     * <p>The security groups.</p>
     * @public
     */
    Groups?: GroupIdentifier[];
    /**
     * <p>The ID of the instance.</p>
     * @public
     */
    InstanceId?: string;
    /**
     * <p>Any tags assigned to the instance.</p>
     * @public
     */
    Tags?: Tag[];
    /**
     * <p>The ID of the VPC.</p>
     * @public
     */
    VpcId?: string;
}
/**
 * @public
 */
export interface DescribeClassicLinkInstancesResult {
    /**
     * <p>Information about one or more linked EC2-Classic instances.</p>
     * @public
     */
    Instances?: ClassicLinkInstance[];
    /**
     * <p>The token to include in another request to get the next page of items. This value is <code>null</code> when there are no more items to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeClientVpnAuthorizationRulesRequest {
    /**
     * <p>The ID of the Client VPN endpoint.</p>
     * @public
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The token to retrieve the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>One or more filters. Filter names and values are case-sensitive.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>description</code> - The description of the authorization rule.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>destination-cidr</code> - The CIDR of the network to which the authorization rule
     *                     applies.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>group-id</code> - The ID of the Active Directory group to which the authorization rule grants access.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
     * @public
     */
    MaxResults?: number;
}
/**
 * <p>Information about an authorization rule.</p>
 * @public
 */
export interface AuthorizationRule {
    /**
     * <p>The ID of the Client VPN endpoint with which the authorization rule is associated.</p>
     * @public
     */
    ClientVpnEndpointId?: string;
    /**
     * <p>A brief description of the authorization rule.</p>
     * @public
     */
    Description?: string;
    /**
     * <p>The ID of the Active Directory group to which the authorization rule grants access.</p>
     * @public
     */
    GroupId?: string;
    /**
     * <p>Indicates whether the authorization rule grants access to all clients.</p>
     * @public
     */
    AccessAll?: boolean;
    /**
     * <p>The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.</p>
     * @public
     */
    DestinationCidr?: string;
    /**
     * <p>The current state of the authorization rule.</p>
     * @public
     */
    Status?: ClientVpnAuthorizationRuleStatus;
}
/**
 * @public
 */
export interface DescribeClientVpnAuthorizationRulesResult {
    /**
     * <p>Information about the authorization rules.</p>
     * @public
     */
    AuthorizationRules?: AuthorizationRule[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeClientVpnConnectionsRequest {
    /**
     * <p>The ID of the Client VPN endpoint.</p>
     * @public
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>One or more filters. Filter names and values are case-sensitive.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>connection-id</code> - The ID of the connection.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>username</code> - For Active Directory client authentication, the user name of the
     *                     client who established the client connection.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The token to retrieve the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 * @enum
 */
export declare const ClientVpnConnectionStatusCode: {
    readonly active: "active";
    readonly failed_to_terminate: "failed-to-terminate";
    readonly terminated: "terminated";
    readonly terminating: "terminating";
};
/**
 * @public
 */
export type ClientVpnConnectionStatusCode = (typeof ClientVpnConnectionStatusCode)[keyof typeof ClientVpnConnectionStatusCode];
/**
 * <p>Describes the status of a client connection.</p>
 * @public
 */
export interface ClientVpnConnectionStatus {
    /**
     * <p>The state of the client connection.</p>
     * @public
     */
    Code?: ClientVpnConnectionStatusCode;
    /**
     * <p>A message about the status of the client connection, if applicable.</p>
     * @public
     */
    Message?: string;
}
/**
 * <p>Describes a client connection.</p>
 * @public
 */
export interface ClientVpnConnection {
    /**
     * <p>The ID of the Client VPN endpoint to which the client is connected.</p>
     * @public
     */
    ClientVpnEndpointId?: string;
    /**
     * <p>The current date and time.</p>
     * @public
     */
    Timestamp?: string;
    /**
     * <p>The ID of the client connection.</p>
     * @public
     */
    ConnectionId?: string;
    /**
     * <p>The username of the client who established the client connection. This information is only provided
     * 			if Active Directory client authentication is used.</p>
     * @public
     */
    Username?: string;
    /**
     * <p>The date and time the client connection was established.</p>
     * @public
     */
    ConnectionEstablishedTime?: string;
    /**
     * <p>The number of bytes sent by the client.</p>
     * @public
     */
    IngressBytes?: string;
    /**
     * <p>The number of bytes received by the client.</p>
     * @public
     */
    EgressBytes?: string;
    /**
     * <p>The number of packets sent by the client.</p>
     * @public
     */
    IngressPackets?: string;
    /**
     * <p>The number of packets received by the client.</p>
     * @public
     */
    EgressPackets?: string;
    /**
     * <p>The IP address of the client.</p>
     * @public
     */
    ClientIp?: string;
    /**
     * <p>The common name associated with the client. This is either the name of the client certificate,
     * 			or the Active Directory user name.</p>
     * @public
     */
    CommonName?: string;
    /**
     * <p>The current state of the client connection.</p>
     * @public
     */
    Status?: ClientVpnConnectionStatus;
    /**
     * <p>The date and time the client connection was terminated.</p>
     * @public
     */
    ConnectionEndTime?: string;
    /**
     * <p>The statuses returned by the client connect handler for posture compliance, if applicable.</p>
     * @public
     */
    PostureComplianceStatuses?: string[];
}
/**
 * @public
 */
export interface DescribeClientVpnConnectionsResult {
    /**
     * <p>Information about the active and terminated client connections.</p>
     * @public
     */
    Connections?: ClientVpnConnection[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeClientVpnEndpointsRequest {
    /**
     * <p>The ID of the Client VPN endpoint.</p>
     * @public
     */
    ClientVpnEndpointIds?: string[];
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token to retrieve the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>One or more filters. Filter names and values are case-sensitive.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>endpoint-id</code> - The ID of the Client VPN endpoint.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transport-protocol</code> - The transport protocol (<code>tcp</code> |
     *                     <code>udp</code>).</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 * @enum
 */
export declare const AssociatedNetworkType: {
    readonly vpc: "vpc";
};
/**
 * @public
 */
export type AssociatedNetworkType = (typeof AssociatedNetworkType)[keyof typeof AssociatedNetworkType];
/**
 * <p>Describes a target network that is associated with a Client VPN endpoint. A target network is a subnet in a VPC.</p>
 * @public
 */
export interface AssociatedTargetNetwork {
    /**
     * <p>The ID of the subnet.</p>
     * @public
     */
    NetworkId?: string;
    /**
     * <p>The target network type.</p>
     * @public
     */
    NetworkType?: AssociatedNetworkType;
}
/**
 * <p>Describes an Active Directory.</p>
 * @public
 */
export interface DirectoryServiceAuthentication {
    /**
     * <p>The ID of the Active Directory used for authentication.</p>
     * @public
     */
    DirectoryId?: string;
}
/**
 * <p>Describes the IAM SAML identity providers used for federated authentication.</p>
 * @public
 */
export interface FederatedAuthentication {
    /**
     * <p>The Amazon Resource Name (ARN) of the IAM SAML identity provider.</p>
     * @public
     */
    SamlProviderArn?: string;
    /**
     * <p>The Amazon Resource Name (ARN) of the IAM SAML identity provider for the self-service portal.</p>
     * @public
     */
    SelfServiceSamlProviderArn?: string;
}
/**
 * <p>Information about the client certificate used for authentication.</p>
 * @public
 */
export interface CertificateAuthentication {
    /**
     * <p>The ARN of the client certificate. </p>
     * @public
     */
    ClientRootCertificateChain?: string;
}
/**
 * <p>Describes the authentication methods used by a Client VPN endpoint. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/client-authentication.html">Authentication</a>
 * 			in the <i>Client VPN Administrator Guide</i>.</p>
 * @public
 */
export interface ClientVpnAuthentication {
    /**
     * <p>The authentication type used.</p>
     * @public
     */
    Type?: ClientVpnAuthenticationType;
    /**
     * <p>Information about the Active Directory, if applicable.</p>
     * @public
     */
    ActiveDirectory?: DirectoryServiceAuthentication;
    /**
     * <p>Information about the authentication certificates, if applicable.</p>
     * @public
     */
    MutualAuthentication?: CertificateAuthentication;
    /**
     * <p>Information about the IAM SAML identity provider, if applicable.</p>
     * @public
     */
    FederatedAuthentication?: FederatedAuthentication;
}
/**
 * @public
 * @enum
 */
export declare const ClientVpnEndpointAttributeStatusCode: {
    readonly applied: "applied";
    readonly applying: "applying";
};
/**
 * @public
 */
export type ClientVpnEndpointAttributeStatusCode = (typeof ClientVpnEndpointAttributeStatusCode)[keyof typeof ClientVpnEndpointAttributeStatusCode];
/**
 * <p>Describes the status of the Client VPN endpoint attribute.</p>
 * @public
 */
export interface ClientVpnEndpointAttributeStatus {
    /**
     * <p>The status code.</p>
     * @public
     */
    Code?: ClientVpnEndpointAttributeStatusCode;
    /**
     * <p>The status message.</p>
     * @public
     */
    Message?: string;
}
/**
 * <p>The options for managing connection authorization for new client connections.</p>
 * @public
 */
export interface ClientConnectResponseOptions {
    /**
     * <p>Indicates whether client connect options are enabled.</p>
     * @public
     */
    Enabled?: boolean;
    /**
     * <p>The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.</p>
     * @public
     */
    LambdaFunctionArn?: string;
    /**
     * <p>The status of any updates to the client connect options.</p>
     * @public
     */
    Status?: ClientVpnEndpointAttributeStatus;
}
/**
 * <p>Current state of options for customizable text banner that will be displayed on
 * 			Amazon Web Services provided clients when a VPN session is established.</p>
 * @public
 */
export interface ClientLoginBannerResponseOptions {
    /**
     * <p>Current state of text banner feature.</p>
     *          <p>Valid values: <code>true | false</code>
     *          </p>
     * @public
     */
    Enabled?: boolean;
    /**
     * <p>Customizable text that will be displayed in a banner on Amazon Web Services provided
     * 			clients when a VPN session is established. UTF-8 encoded
     * 			characters only. Maximum of 1400 characters.</p>
     * @public
     */
    BannerText?: string;
}
/**
 * <p>Information about the client connection logging options for a Client VPN endpoint.</p>
 * @public
 */
export interface ConnectionLogResponseOptions {
    /**
     * <p>Indicates whether client connection logging is enabled for the Client VPN endpoint.</p>
     * @public
     */
    Enabled?: boolean;
    /**
     * <p>The name of the Amazon CloudWatch Logs log group to which connection logging data is published.</p>
     * @public
     */
    CloudwatchLogGroup?: string;
    /**
     * <p>The name of the Amazon CloudWatch Logs log stream to which connection logging data is published.</p>
     * @public
     */
    CloudwatchLogStream?: string;
}
/**
 * @public
 * @enum
 */
export declare const VpnProtocol: {
    readonly openvpn: "openvpn";
};
/**
 * @public
 */
export type VpnProtocol = (typeof VpnProtocol)[keyof typeof VpnProtocol];
/**
 * <p>Describes a Client VPN endpoint.</p>
 * @public
 */
export interface ClientVpnEndpoint {
    /**
     * <p>The ID of the Client VPN endpoint.</p>
     * @public
     */
    ClientVpnEndpointId?: string;
    /**
     * <p>A brief description of the endpoint.</p>
     * @public
     */
    Description?: string;
    /**
     * <p>The current state of the Client VPN endpoint.</p>
     * @public
     */
    Status?: ClientVpnEndpointStatus;
    /**
     * <p>The date and time the Client VPN endpoint was created.</p>
     * @public
     */
    CreationTime?: string;
    /**
     * <p>The date and time the Client VPN endpoint was deleted, if applicable.</p>
     * @public
     */
    DeletionTime?: string;
    /**
     * <p>The DNS name to be used by clients when connecting to the Client VPN endpoint.</p>
     * @public
     */
    DnsName?: string;
    /**
     * <p>The IPv4 address range, in CIDR notation, from which client IP addresses are assigned.</p>
     * @public
     */
    ClientCidrBlock?: string;
    /**
     * <p>Information about the DNS servers to be used for DNS resolution. </p>
     * @public
     */
    DnsServers?: string[];
    /**
     * <p>Indicates whether split-tunnel is enabled in the Client VPN endpoint.</p>
     *          <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-Tunnel Client VPN endpoint</a>
     * 			in the <i>Client VPN Administrator Guide</i>.</p>
     * @public
     */
    SplitTunnel?: boolean;
    /**
     * <p>The protocol used by the VPN session.</p>
     * @public
     */
    VpnProtocol?: VpnProtocol;
    /**
     * <p>The transport protocol used by the Client VPN endpoint.</p>
     * @public
     */
    TransportProtocol?: TransportProtocol;
    /**
     * <p>The port number for the  Client VPN endpoint.</p>
     * @public
     */
    VpnPort?: number;
    /**
     * @deprecated
     *
     * <p>Information about the associated target networks. A target network is a subnet in a VPC.</p>
     * @public
     */
    AssociatedTargetNetworks?: AssociatedTargetNetwork[];
    /**
     * <p>The ARN of the server certificate.</p>
     * @public
     */
    ServerCertificateArn?: string;
    /**
     * <p>Information about the authentication method used by the Client VPN endpoint.</p>
     * @public
     */
    AuthenticationOptions?: ClientVpnAuthentication[];
    /**
     * <p>Information about the client connection logging options for the Client VPN endpoint.</p>
     * @public
     */
    ConnectionLogOptions?: ConnectionLogResponseOptions;
    /**
     * <p>Any tags assigned to the Client VPN endpoint.</p>
     * @public
     */
    Tags?: Tag[];
    /**
     * <p>The IDs of the security groups for the target network.</p>
     * @public
     */
    SecurityGroupIds?: string[];
    /**
     * <p>The ID of the VPC.</p>
     * @public
     */
    VpcId?: string;
    /**
     * <p>The URL of the self-service portal.</p>
     * @public
     */
    SelfServicePortalUrl?: string;
    /**
     * <p>The options for managing connection authorization for new client connections.</p>
     * @public
     */
    ClientConnectOptions?: ClientConnectResponseOptions;
    /**
     * <p>The maximum VPN session duration time in hours.</p>
     *          <p>Valid values: <code>8 | 10 | 12 | 24</code>
     *          </p>
     *          <p>Default value: <code>24</code>
     *          </p>
     * @public
     */
    SessionTimeoutHours?: number;
    /**
     * <p>Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients when a VPN session is
     * 			established.</p>
     * @public
     */
    ClientLoginBannerOptions?: ClientLoginBannerResponseOptions;
}
/**
 * @public
 */
export interface DescribeClientVpnEndpointsResult {
    /**
     * <p>Information about the Client VPN endpoints.</p>
     * @public
     */
    ClientVpnEndpoints?: ClientVpnEndpoint[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeClientVpnRoutesRequest {
    /**
     * <p>The ID of the Client VPN endpoint.</p>
     * @public
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>One or more filters. Filter names and values are case-sensitive.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>destination-cidr</code> - The CIDR of the route destination.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>origin</code> - How the route was associated with the Client VPN endpoint (<code>associate</code> | <code>add-route</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>target-subnet</code> - The ID of the subnet through which traffic is routed.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token to retrieve the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Information about a Client VPN endpoint route.</p>
 * @public
 */
export interface ClientVpnRoute {
    /**
     * <p>The ID of the Client VPN endpoint with which the route is associated.</p>
     * @public
     */
    ClientVpnEndpointId?: string;
    /**
     * <p>The IPv4 address range, in CIDR notation, of the route destination.</p>
     * @public
     */
    DestinationCidr?: string;
    /**
     * <p>The ID of the subnet through which traffic is routed.</p>
     * @public
     */
    TargetSubnet?: string;
    /**
     * <p>The route type.</p>
     * @public
     */
    Type?: string;
    /**
     * <p>Indicates how the route was associated with the Client VPN endpoint.
     * 			<code>associate</code> indicates that the route was automatically added when the target network
     * 			was associated with the Client VPN endpoint. <code>add-route</code> indicates that the route
     * 			was manually added using the <b>CreateClientVpnRoute</b> action.</p>
     * @public
     */
    Origin?: string;
    /**
     * <p>The current state of the route.</p>
     * @public
     */
    Status?: ClientVpnRouteStatus;
    /**
     * <p>A brief description of the route.</p>
     * @public
     */
    Description?: string;
}
/**
 * @public
 */
export interface DescribeClientVpnRoutesResult {
    /**
     * <p>Information about the Client VPN endpoint routes.</p>
     * @public
     */
    Routes?: ClientVpnRoute[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeClientVpnTargetNetworksRequest {
    /**
     * <p>The ID of the Client VPN endpoint.</p>
     * @public
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>The IDs of the target network associations.</p>
     * @public
     */
    AssociationIds?: string[];
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token to retrieve the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>One or more filters. Filter names and values are case-sensitive.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>association-id</code> - The ID of the association.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>target-network-id</code> - The ID of the subnet specified as the target network.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>vpc-id</code> - The ID of the VPC in which the target network is located.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Describes a target network associated with a Client VPN endpoint.</p>
 * @public
 */
export interface TargetNetwork {
    /**
     * <p>The ID of the association.</p>
     * @public
     */
    AssociationId?: string;
    /**
     * <p>The ID of the VPC in which the target network (subnet) is located.</p>
     * @public
     */
    VpcId?: string;
    /**
     * <p>The ID of the subnet specified as the target network.</p>
     * @public
     */
    TargetNetworkId?: string;
    /**
     * <p>The ID of the Client VPN endpoint with which the target network is associated.</p>
     * @public
     */
    ClientVpnEndpointId?: string;
    /**
     * <p>The current state of the target network association.</p>
     * @public
     */
    Status?: AssociationStatus;
    /**
     * <p>The IDs of the security groups applied to the target network association.</p>
     * @public
     */
    SecurityGroups?: string[];
}
/**
 * @public
 */
export interface DescribeClientVpnTargetNetworksResult {
    /**
     * <p>Information about the associated target networks.</p>
     * @public
     */
    ClientVpnTargetNetworks?: TargetNetwork[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeCoipPoolsRequest {
    /**
     * <p>The IDs of the address pools.</p>
     * @public
     */
    PoolIds?: string[];
    /**
     * <p>One or more filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>coip-pool.local-gateway-route-table-id</code> - The ID of the local gateway route table.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>coip-pool.pool-id</code> - The ID of the address pool.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface DescribeCoipPoolsResult {
    /**
     * <p>Information about the address pools.</p>
     * @public
     */
    CoipPools?: CoipPool[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeConversionTasksRequest {
    /**
     * <p>The conversion task IDs.</p>
     * @public
     */
    ConversionTaskIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Describes a disk image.</p>
 * @public
 */
export interface DiskImageDescription {
    /**
     * <p>The checksum computed for the disk image.</p>
     * @public
     */
    Checksum?: string;
    /**
     * <p>The disk image format.</p>
     * @public
     */
    Format?: DiskImageFormat;
    /**
     * <p>A presigned URL for the import manifest stored in Amazon S3. For information about creating a presigned URL for
     *    an Amazon S3 object, read the "Query String Request Authentication Alternative" section of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST Requests</a> topic in
     *    the <i>Amazon Simple Storage Service Developer Guide</i>.</p>
     *          <p>For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.</p>
     * @public
     */
    ImportManifestUrl?: string;
    /**
     * <p>The size of the disk image, in GiB.</p>
     * @public
     */
    Size?: number;
}
/**
 * <p>Describes a disk image volume.</p>
 * @public
 */
export interface DiskImageVolumeDescription {
    /**
     * <p>The volume identifier.</p>
     * @public
     */
    Id?: string;
    /**
     * <p>The size of the volume, in GiB.</p>
     * @public
     */
    Size?: number;
}
/**
 * <p>Describes an import volume task.</p>
 * @public
 */
export interface ImportInstanceVolumeDetailItem {
    /**
     * <p>The Availability Zone where the resulting instance will reside.</p>
     * @public
     */
    AvailabilityZone?: string;
    /**
     * <p>The number of bytes converted so far.</p>
     * @public
     */
    BytesConverted?: number;
    /**
     * <p>A description of the task.</p>
     * @public
     */
    Description?: string;
    /**
     * <p>The image.</p>
     * @public
     */
    Image?: DiskImageDescription;
    /**
     * <p>The status of the import of this particular disk image.</p>
     * @public
     */
    Status?: string;
    /**
     * <p>The status information or errors related to the disk image.</p>
     * @public
     */
    StatusMessage?: string;
    /**
     * <p>The volume.</p>
     * @public
     */
    Volume?: DiskImageVolumeDescription;
}
/**
 * <p>Describes an import instance task.</p>
 * @public
 */
export interface ImportInstanceTaskDetails {
    /**
     * <p>A description of the task.</p>
     * @public
     */
    Description?: string;
    /**
     * <p>The ID of the instance.</p>
     * @public
     */
    InstanceId?: string;
    /**
     * <p>The instance operating system.</p>
     * @public
     */
    Platform?: PlatformValues;
    /**
     * <p>The volumes.</p>
     * @public
     */
    Volumes?: ImportInstanceVolumeDetailItem[];
}
/**
 * <p>Describes an import volume task.</p>
 * @public
 */
export interface ImportVolumeTaskDetails {
    /**
     * <p>The Availability Zone where the resulting volume will reside.</p>
     * @public
     */
    AvailabilityZone?: string;
    /**
     * <p>The number of bytes converted so far.</p>
     * @public
     */
    BytesConverted?: number;
    /**
     * <p>The description you provided when starting the import volume task.</p>
     * @public
     */
    Description?: string;
    /**
     * <p>The image.</p>
     * @public
     */
    Image?: DiskImageDescription;
    /**
     * <p>The volume.</p>
     * @public
     */
    Volume?: DiskImageVolumeDescription;
}
/**
 * @public
 * @enum
 */
export declare const ConversionTaskState: {
    readonly active: "active";
    readonly cancelled: "cancelled";
    readonly cancelling: "cancelling";
    readonly completed: "completed";
};
/**
 * @public
 */
export type ConversionTaskState = (typeof ConversionTaskState)[keyof typeof ConversionTaskState];
/**
 * <p>Describes a conversion task.</p>
 * @public
 */
export interface ConversionTask {
    /**
     * <p>The ID of the conversion task.</p>
     * @public
     */
    ConversionTaskId?: string;
    /**
     * <p>The time when the task expires. If the upload isn't complete before the expiration time, we automatically cancel
     *    the task.</p>
     * @public
     */
    ExpirationTime?: string;
    /**
     * <p>If the task is for importing an instance, this contains information about the import instance task.</p>
     * @public
     */
    ImportInstance?: ImportInstanceTaskDetails;
    /**
     * <p>If the task is for importing a volume, this contains information about the import volume task.</p>
     * @public
     */
    ImportVolume?: ImportVolumeTaskDetails;
    /**
     * <p>The state of the conversion task.</p>
     * @public
     */
    State?: ConversionTaskState;
    /**
     * <p>The status message related to the conversion task.</p>
     * @public
     */
    StatusMessage?: string;
    /**
     * <p>Any tags assigned to the task.</p>
     * @public
     */
    Tags?: Tag[];
}
/**
 * @public
 */
export interface DescribeConversionTasksResult {
    /**
     * <p>Information about the conversion tasks.</p>
     * @public
     */
    ConversionTasks?: ConversionTask[];
}
/**
 * <p>Contains the parameters for DescribeCustomerGateways.</p>
 * @public
 */
export interface DescribeCustomerGatewaysRequest {
    /**
     * <p>One or more customer gateway IDs.</p>
     *          <p>Default: Describes all your customer gateways.</p>
     * @public
     */
    CustomerGatewayIds?: string[];
    /**
     * <p>One or more filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>bgp-asn</code> - The customer gateway's Border Gateway Protocol (BGP)
     *                     Autonomous System Number (ASN).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>customer-gateway-id</code> - The ID of the customer gateway.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>ip-address</code> - The IP address of the customer gateway
     *                     device's external interface.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the customer gateway (<code>pending</code> |
     *                         <code>available</code> | <code>deleting</code> |
     *                     <code>deleted</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>type</code> - The type of customer gateway. Currently, the only
     *                     supported type is <code>ipsec.1</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Contains the output of DescribeCustomerGateways.</p>
 * @public
 */
export interface DescribeCustomerGatewaysResult {
    /**
     * <p>Information about one or more customer gateways.</p>
     * @public
     */
    CustomerGateways?: CustomerGateway[];
}
/**
 * @public
 */
export interface DescribeDhcpOptionsRequest {
    /**
     * <p>The IDs of one or more DHCP options sets.</p>
     *          <p>Default: Describes all your DHCP options sets.</p>
     * @public
     */
    DhcpOptionsIds?: string[];
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>dhcp-options-id</code> - The ID of a DHCP options set.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>key</code> - The key for one of the options (for example, <code>domain-name</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>value</code> - The value for one of the options.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>owner-id</code> - The ID of the Amazon Web Services account that owns the DHCP options set.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The token returned from a previous paginated request. Pagination continues from the end of the items returned by the previous request.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>The maximum number of items to return for this request.
     * 	To get the next page of items, make another request with the token returned in the output.
     * 	For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>
     * @public
     */
    MaxResults?: number;
}
/**
 * @public
 */
export interface DescribeDhcpOptionsResult {
    /**
     * <p>Information about one or more DHCP options sets.</p>
     * @public
     */
    DhcpOptions?: DhcpOptions[];
    /**
     * <p>The token to include in another request to get the next page of items. This value is <code>null</code> when there are no more items to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeEgressOnlyInternetGatewaysRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of the egress-only internet gateways.</p>
     * @public
     */
    EgressOnlyInternetGatewayIds?: string[];
    /**
     * <p>The maximum number of items to return for this request.
     * 	To get the next page of items, make another request with the token returned in the output.
     * 	For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token returned from a previous paginated request. Pagination continues from the end of the items returned by the previous request.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
}
/**
 * @public
 */
export interface DescribeEgressOnlyInternetGatewaysResult {
    /**
     * <p>Information about the egress-only internet gateways.</p>
     * @public
     */
    EgressOnlyInternetGateways?: EgressOnlyInternetGateway[];
    /**
     * <p>The token to include in another request to get the next page of items. This value is <code>null</code> when there are no more items to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeElasticGpusRequest {
    /**
     * <p>The Elastic Graphics accelerator IDs.</p>
     * @public
     */
    ElasticGpuIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>availability-zone</code> - The Availability Zone in which the
     *                     Elastic Graphics accelerator resides.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator
     *                         (<code>OK</code> | <code>IMPAIRED</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator
     *                         (<code>ATTACHED</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example,
     *                         <code>eg1.medium</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>instance-id</code> - The ID of the instance to which the
     *                     Elastic Graphics accelerator is associated.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return in a single call. To retrieve the remaining
     *             results, make another call with the returned <code>NextToken</code> value. This value
     *             can be between 5 and 1000.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token to request the next page of results.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 * @enum
 */
export declare const ElasticGpuStatus: {
    readonly Impaired: "IMPAIRED";
    readonly Ok: "OK";
};
/**
 * @public
 */
export type ElasticGpuStatus = (typeof ElasticGpuStatus)[keyof typeof ElasticGpuStatus];
/**
 * <note>
 *             <p>Amazon Elastic Graphics reached end of life on January 8, 2024. For
 *                 workloads that require graphics acceleration, we recommend that you use Amazon EC2 G4ad,
 *                 G4dn, or G5 instances.</p>
 *          </note>
 *          <p>Describes the status of an Elastic Graphics accelerator.</p>
 * @public
 */
export interface ElasticGpuHealth {
    /**
     * <p>The health status.</p>
     * @public
     */
    Status?: ElasticGpuStatus;
}
/**
 * @public
 * @enum
 */
export declare const ElasticGpuState: {
    readonly Attached: "ATTACHED";
};
/**
 * @public
 */
export type ElasticGpuState = (typeof ElasticGpuState)[keyof typeof ElasticGpuState];
/**
 * <note>
 *             <p>Amazon Elastic Graphics reached end of life on January 8, 2024. For
 *                 workloads that require graphics acceleration, we recommend that you use Amazon EC2 G4ad,
 *                 G4dn, or G5 instances.</p>
 *          </note>
 *          <p>Describes an Elastic Graphics accelerator.</p>
 * @public
 */
export interface ElasticGpus {
    /**
     * <p>The ID of the Elastic Graphics accelerator.</p>
     * @public
     */
    ElasticGpuId?: string;
    /**
     * <p>The Availability Zone in the which the Elastic Graphics accelerator resides.</p>
     * @public
     */
    AvailabilityZone?: string;
    /**
     * <p>The type of Elastic Graphics accelerator.</p>
     * @public
     */
    ElasticGpuType?: string;
    /**
     * <p>The status of the Elastic Graphics accelerator.</p>
     * @public
     */
    ElasticGpuHealth?: ElasticGpuHealth;
    /**
     * <p>The state of the Elastic Graphics accelerator.</p>
     * @public
     */
    ElasticGpuState?: ElasticGpuState;
    /**
     * <p>The ID of the instance to which the Elastic Graphics accelerator is attached.</p>
     * @public
     */
    InstanceId?: string;
    /**
     * <p>The tags assigned to the Elastic Graphics accelerator.</p>
     * @public
     */
    Tags?: Tag[];
}
/**
 * @public
 */
export interface DescribeElasticGpusResult {
    /**
     * <p>Information about the Elastic Graphics accelerators.</p>
     * @public
     */
    ElasticGpuSet?: ElasticGpus[];
    /**
     * <p>The total number of items to return. If the total number of items available is more
     *             than the value specified in max-items then a Next-Token will be provided in the output
     *             that you can use to resume pagination.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token to use to retrieve the next page of results. This value is
     *                 <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeExportImageTasksRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>Filter tasks using the <code>task-state</code> filter and one of the following values: <code>active</code>,
     *     <code>completed</code>, <code>deleting</code>, or <code>deleted</code>.</p>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The IDs of the export image tasks.</p>
     * @public
     */
    ExportImageTaskIds?: string[];
    /**
     * <p>The maximum number of results to return in a single call.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>A token that indicates the next page of results.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * <p>Describes the destination for an export image task.</p>
 * @public
 */
export interface ExportTaskS3Location {
    /**
     * <p>The destination Amazon S3 bucket.</p>
     * @public
     */
    S3Bucket?: string;
    /**
     * <p>The prefix (logical hierarchy) in the bucket.</p>
     * @public
     */
    S3Prefix?: string;
}
/**
 * <p>Describes an export image task.</p>
 * @public
 */
export interface ExportImageTask {
    /**
     * <p>A description of the image being exported.</p>
     * @public
     */
    Description?: string;
    /**
     * <p>The ID of the export image task.</p>
     * @public
     */
    ExportImageTaskId?: string;
    /**
     * <p>The ID of the image.</p>
     * @public
     */
    ImageId?: string;
    /**
     * <p>The percent complete of the export image task.</p>
     * @public
     */
    Progress?: string;
    /**
     * <p>Information about the destination Amazon S3 bucket.</p>
     * @public
     */
    S3ExportLocation?: ExportTaskS3Location;
    /**
     * <p>The status of the export image task. The possible values are <code>active</code>, <code>completed</code>,
     *     <code>deleting</code>, and <code>deleted</code>.</p>
     * @public
     */
    Status?: string;
    /**
     * <p>The status message for the export image task.</p>
     * @public
     */
    StatusMessage?: string;
    /**
     * <p>Any tags assigned to the export image task.</p>
     * @public
     */
    Tags?: Tag[];
}
/**
 * @public
 */
export interface DescribeExportImageTasksResult {
    /**
     * <p>Information about the export image tasks.</p>
     * @public
     */
    ExportImageTasks?: ExportImageTask[];
    /**
     * <p>The token to use to get the next page of results. This value is <code>null</code> when there are no more results
     *    to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeExportTasksRequest {
    /**
     * <p>The export task IDs.</p>
     * @public
     */
    ExportTaskIds?: string[];
    /**
     * <p>the filters for the export tasks.</p>
     * @public
     */
    Filters?: Filter[];
}
/**
 * @public
 */
export interface DescribeExportTasksResult {
    /**
     * <p>Information about the export tasks.</p>
     * @public
     */
    ExportTasks?: ExportTask[];
}
/**
 * @public
 */
export interface DescribeFastLaunchImagesRequest {
    /**
     * <p>Specify one or more Windows AMI image IDs for the request.</p>
     * @public
     */
    ImageIds?: string[];
    /**
     * <p>Use the following filters to streamline results.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>resource-type</code> - The resource type for pre-provisioning.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>owner-id</code> - The owner ID for the pre-provisioning resource.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The current state of fast launching for the Windows AMI.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of items to return for this request.
     *          To get the next page of items, make another request with the token returned in the output.
     * 	        For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token returned from a previous paginated request. Pagination continues from the end of the items returned by the previous request.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     * 			and provides an error response. If you have the required permissions, the error response is
     * 			<code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Identifies the launch template that the AMI uses for Windows fast launch.</p>
 * @public
 */
export interface FastLaunchLaunchTemplateSpecificationResponse {
    /**
     * <p>The ID of the launch template that the AMI uses for Windows fast launch.</p>
     * @public
     */
    LaunchTemplateId?: string;
    /**
     * <p>The name of the launch template that the AMI uses for Windows fast launch.</p>
     * @public
     */
    LaunchTemplateName?: string;
    /**
     * <p>The version of the launch template that the AMI uses for Windows fast launch.</p>
     * @public
     */
    Version?: string;
}
/**
 * @public
 * @enum
 */
export declare const FastLaunchResourceType: {
    readonly SNAPSHOT: "snapshot";
};
/**
 * @public
 */
export type FastLaunchResourceType = (typeof FastLaunchResourceType)[keyof typeof FastLaunchResourceType];
/**
 * <p>Configuration settings for creating and managing pre-provisioned snapshots for a Windows fast launch
 * 			enabled Windows AMI.</p>
 * @public
 */
export interface FastLaunchSnapshotConfigurationResponse {
    /**
     * <p>The number of pre-provisioned snapshots requested to keep on hand for a Windows fast launch
     * 			enabled AMI.</p>
     * @public
     */
    TargetResourceCount?: number;
}
/**
 * @public
 * @enum
 */
export declare const FastLaunchStateCode: {
    readonly disabling: "disabling";
    readonly disabling_failed: "disabling-failed";
    readonly enabled: "enabled";
    readonly enabled_failed: "enabled-failed";
    readonly enabling: "enabling";
    readonly enabling_failed: "enabling-failed";
};
/**
 * @public
 */
export type FastLaunchStateCode = (typeof FastLaunchStateCode)[keyof typeof FastLaunchStateCode];
/**
 * <p>Describe details about a Windows image with Windows fast launch enabled that meets the requested
 * 			criteria. Criteria are defined by the <code>DescribeFastLaunchImages</code> action filters.</p>
 * @public
 */
export interface DescribeFastLaunchImagesSuccessItem {
    /**
     * <p>The image ID that identifies the Windows fast launch enabled image.</p>
     * @public
     */
    ImageId?: string;
    /**
     * <p>The resource type that Amazon EC2 uses for pre-provisioning the Windows AMI. Supported values
     * 			include: <code>snapshot</code>.</p>
     * @public
     */
    ResourceType?: FastLaunchResourceType;
    /**
     * <p>A group of parameters that are used for pre-provisioning the associated
     * 			Windows AMI using snapshots.</p>
     * @public
     */
    SnapshotConfiguration?: FastLaunchSnapshotConfigurationResponse;
    /**
     * <p>The launch template that the Windows fast launch enabled AMI uses when it launches
     * 			Windows instances from pre-provisioned snapshots.</p>
     * @public
     */
    LaunchTemplate?: FastLaunchLaunchTemplateSpecificationResponse;
    /**
     * <p>The maximum number of instances that Amazon EC2 can launch at the same time to create
     * 			pre-provisioned snapshots for Windows fast launch.</p>
     * @public
     */
    MaxParallelLaunches?: number;
    /**
     * <p>The owner ID for the Windows fast launch enabled AMI.</p>
     * @public
     */
    OwnerId?: string;
    /**
     * <p>The current state of Windows fast launch for the specified Windows AMI.</p>
     * @public
     */
    State?: FastLaunchStateCode;
    /**
     * <p>The reason that Windows fast launch for the AMI changed to the current state.</p>
     * @public
     */
    StateTransitionReason?: string;
    /**
     * <p>The time that Windows fast launch for the AMI changed to the current state.</p>
     * @public
     */
    StateTransitionTime?: Date;
}
/**
 * @public
 */
export interface DescribeFastLaunchImagesResult {
    /**
     * <p>A collection of details about the fast-launch enabled Windows images that meet
     * 			the requested criteria.</p>
     * @public
     */
    FastLaunchImages?: DescribeFastLaunchImagesSuccessItem[];
    /**
     * <p>The token to include in another request to get the next page of items. This value is <code>null</code> when there
     *          are no more items to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeFastSnapshotRestoresRequest {
    /**
     * <p>The filters. The possible values are:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>availability-zone</code>: The Availability Zone of the snapshot.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>owner-id</code>: The ID of the Amazon Web Services account that enabled fast snapshot restore on the snapshot.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>snapshot-id</code>: The ID of the snapshot.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code>: The state of fast snapshot restores for the snapshot
     *          (<code>enabling</code> |
     *           <code>optimizing</code> |
     *           <code>enabled</code> |
     *           <code>disabling</code> |
     *           <code>disabled</code>).</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of items to return for this request.
     * 	To get the next page of items, make another request with the token returned in the output.
     * 	For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token returned from a previous paginated request.
     *   Pagination continues from the end of the items returned by the previous request.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 * @enum
 */
export declare const FastSnapshotRestoreStateCode: {
    readonly disabled: "disabled";
    readonly disabling: "disabling";
    readonly enabled: "enabled";
    readonly enabling: "enabling";
    readonly optimizing: "optimizing";
};
/**
 * @public
 */
export type FastSnapshotRestoreStateCode = (typeof FastSnapshotRestoreStateCode)[keyof typeof FastSnapshotRestoreStateCode];
/**
 * <p>Describes fast snapshot restores for a snapshot.</p>
 * @public
 */
export interface DescribeFastSnapshotRestoreSuccessItem {
    /**
     * <p>The ID of the snapshot.</p>
     * @public
     */
    SnapshotId?: string;
    /**
     * <p>The Availability Zone.</p>
     * @public
     */
    AvailabilityZone?: string;
    /**
     * <p>The state of fast snapshot restores.</p>
     * @public
     */
    State?: FastSnapshotRestoreStateCode;
    /**
     * <p>The reason for the state transition. The possible values are as follows:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>Client.UserInitiated</code> - The state successfully transitioned to <code>enabling</code> or
     *           <code>disabling</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>Client.UserInitiated - Lifecycle state transition</code> - The state successfully transitioned
     *           to <code>optimizing</code>, <code>enabled</code>, or <code>disabled</code>.</p>
     *             </li>
     *          </ul>
     * @public
     */
    StateTransitionReason?: string;
    /**
     * <p>The ID of the Amazon Web Services account that enabled fast snapshot restores on the snapshot.</p>
     * @public
     */
    OwnerId?: string;
    /**
     * <p>The Amazon Web Services owner alias that enabled fast snapshot restores on the snapshot. This is intended for future use.</p>
     * @public
     */
    OwnerAlias?: string;
    /**
     * <p>The time at which fast snapshot restores entered the <code>enabling</code> state.</p>
     * @public
     */
    EnablingTime?: Date;
    /**
     * <p>The time at which fast snapshot restores entered the <code>optimizing</code> state.</p>
     * @public
     */
    OptimizingTime?: Date;
    /**
     * <p>The time at which fast snapshot restores entered the <code>enabled</code> state.</p>
     * @public
     */
    EnabledTime?: Date;
    /**
     * <p>The time at which fast snapshot restores entered the <code>disabling</code> state.</p>
     * @public
     */
    DisablingTime?: Date;
    /**
     * <p>The time at which fast snapshot restores entered the <code>disabled</code> state.</p>
     * @public
     */
    DisabledTime?: Date;
}
/**
 * @public
 */
export interface DescribeFastSnapshotRestoresResult {
    /**
     * <p>Information about the state of fast snapshot restores.</p>
     * @public
     */
    FastSnapshotRestores?: DescribeFastSnapshotRestoreSuccessItem[];
    /**
     * <p>The token to include in another request to get the next page of items.
     *   This value is <code>null</code> when there are no more items to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 * @enum
 */
export declare const FleetEventType: {
    readonly FLEET_CHANGE: "fleet-change";
    readonly INSTANCE_CHANGE: "instance-change";
    readonly SERVICE_ERROR: "service-error";
};
/**
 * @public
 */
export type FleetEventType = (typeof FleetEventType)[keyof typeof FleetEventType];
/**
 * @public
 */
export interface DescribeFleetHistoryRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The type of events to describe. By default, all events are described.</p>
     * @public
     */
    EventType?: FleetEventType;
    /**
     * <p>The maximum number of items to return for this request.
     *          To get the next page of items, make another request with the token returned in the output.
     * 	        For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token returned from a previous paginated request. Pagination continues from the end of the items returned by the previous request.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>The ID of the EC2 Fleet.</p>
     * @public
     */
    FleetId: string | undefined;
    /**
     * <p>The start date and time for the events, in UTC format (for example,
     *             <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
     * @public
     */
    StartTime: Date | undefined;
}
/**
 * <p>Describes an EC2 Fleet or Spot Fleet event.</p>
 * @public
 */
export interface EventInformation {
    /**
     * <p>The description of the event.</p>
     * @public
     */
    EventDescription?: string;
    /**
     * <p>The event.</p>
     *          <p>
     *             <code>error</code> events:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>iamFleetRoleInvalid</code> - The EC2 Fleet or Spot Fleet does not have the required
     *                permissions either to launch or terminate an instance.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>allLaunchSpecsTemporarilyBlacklisted</code> - None of the configurations
     *                are valid, and several attempts to launch instances have failed. For more
     *                information, see the description of the event.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>spotInstanceCountLimitExceeded</code> - You've reached the limit on the
     *                number of Spot Instances that you can launch.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>spotFleetRequestConfigurationInvalid</code> - The configuration is not
     *                valid. For more information, see the description of the event.</p>
     *             </li>
     *          </ul>
     *          <p>
     *             <code>fleetRequestChange</code> events:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>active</code> - The EC2 Fleet or Spot Fleet request has been validated and Amazon EC2 is
     *                attempting to maintain the target number of running instances.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>deleted</code> (EC2 Fleet) / <code>cancelled</code> (Spot Fleet) - The EC2 Fleet is deleted or the Spot Fleet request is canceled and has no running
     *                instances. The EC2 Fleet or Spot Fleet will be deleted two days after its instances are
     *                terminated.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>deleted_running</code> (EC2 Fleet) / <code>cancelled_running</code> (Spot Fleet) - The EC2 Fleet is deleted or the Spot Fleet request is canceled and does
     *                not launch additional instances. Its existing instances continue to run until
     *                they are interrupted or terminated. The request remains in this state until all
     *                instances are interrupted or terminated.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>deleted_terminating</code> (EC2 Fleet) / <code>cancelled_terminating</code> (Spot Fleet) - The EC2 Fleet is deleted or the Spot Fleet request is canceled and
     *                its instances are terminating. The request remains in this state until all
     *                instances are terminated.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>expired</code> - The EC2 Fleet or Spot Fleet request has expired. If the request was
     *                created with <code>TerminateInstancesWithExpiration</code> set, a subsequent
     *                <code>terminated</code> event indicates that the instances are
     *                terminated.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>modify_in_progress</code> - The EC2 Fleet or Spot Fleet request is being modified.
     *                The request remains in this state until the modification is fully
     *                processed.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>modify_succeeded</code> - The EC2 Fleet or Spot Fleet request was modified.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>submitted</code> - The EC2 Fleet or Spot Fleet request is being evaluated and Amazon EC2
     *                is preparing to launch the target number of instances.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>progress</code> - The EC2 Fleet or Spot Fleet request is in the process of being fulfilled.</p>
     *             </li>
     *          </ul>
     *          <p>
     *             <code>instanceChange</code> events:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>launched</code> - A new instance was launched.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>terminated</code> - An instance was terminated by the user.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>termination_notified</code> - An instance termination notification was
     *                sent when a Spot Instance was terminated by Amazon EC2 during scale-down, when the target
     *                capacity of the fleet was modified down, for example, from a target capacity of
     *                4 to a target capacity of 3.</p>
     *             </li>
     *          </ul>
     *          <p>
     *             <code>Information</code> events:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>fleetProgressHalted</code> - The price in every launch specification is
     *                not valid because it is below the Spot price (all the launch specifications have
     *                produced <code>launchSpecUnusable</code> events). A launch specification might
     *                become valid if the Spot price changes.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>launchSpecTemporarilyBlacklisted</code> - The configuration is not valid
     *                and several attempts to launch instances have failed. For more information, see
     *                the description of the event.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>launchSpecUnusable</code> - The price in a launch specification is not
     *                valid because it is below the Spot price.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>registerWithLoadBalancersFailed</code> - An attempt to register
     *                instances with load balancers failed. For more information, see the description
     *                of the event.</p>
     *             </li>
     *          </ul>
     * @public
     */
    EventSubType?: string;
    /**
     * <p>The ID of the instance. This information is available only for
     *          <code>instanceChange</code> events.</p>
     * @public
     */
    InstanceId?: string;
}
/**
 * <p>Describes an event in the history of an EC2 Fleet.</p>
 * @public
 */
export interface HistoryRecordEntry {
    /**
     * <p>Information about the event.</p>
     * @public
     */
    EventInformation?: EventInformation;
    /**
     * <p>The event type.</p>
     * @public
     */
    EventType?: FleetEventType;
    /**
     * <p>The date and time of the event, in UTC format (for example,
     *             <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
     * @public
     */
    Timestamp?: Date;
}
/**
 * @public
 */
export interface DescribeFleetHistoryResult {
    /**
     * <p>Information about the events in the history of the EC2 Fleet.</p>
     * @public
     */
    HistoryRecords?: HistoryRecordEntry[];
    /**
     * <p>The last date and time for the events, in UTC format (for example,
     *             <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     *          All records up to this time were retrieved.</p>
     *          <p>If <code>nextToken</code> indicates that there are more items, this value is not
     *          present.</p>
     * @public
     */
    LastEvaluatedTime?: Date;
    /**
     * <p>The token to include in another request to get the next page of items. This value is <code>null</code> when there
     *          are no more items to return.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>The ID of the EC Fleet.</p>
     * @public
     */
    FleetId?: string;
    /**
     * <p>The start date and time for the events, in UTC format (for example,
     *             <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
     * @public
     */
    StartTime?: Date;
}
/**
 * @public
 */
export interface DescribeFleetInstancesRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The maximum number of items to return for this request.
     *          To get the next page of items, make another request with the token returned in the output.
     * 	        For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token returned from a previous paginated request. Pagination continues from the end of the items returned by the previous request.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>The ID of the EC2 Fleet.</p>
     * @public
     */
    FleetId: string | undefined;
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>instance-type</code> - The instance type.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
}
/**
 * @public
 */
export interface DescribeFleetInstancesResult {
    /**
     * <p>The running instances. This list is refreshed periodically and might be out of
     *          date.</p>
     * @public
     */
    ActiveInstances?: ActiveInstance[];
    /**
     * <p>The token to include in another request to get the next page of items. This value is <code>null</code> when there
     *          are no more items to return.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>The ID of the EC2 Fleet.</p>
     * @public
     */
    FleetId?: string;
}
/**
 * @public
 */
export interface DescribeFleetsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The maximum number of items to return for this request.
     *          To get the next page of items, make another request with the token returned in the output.
     * 	        For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token returned from a previous paginated request. Pagination continues from the end of the items returned by the previous request.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>The IDs of the EC2 Fleets.</p>
     *          <note>
     *             <p>If a fleet is of type <code>instant</code>, you must specify the fleet ID, otherwise
     *             it does not appear in the response.</p>
     *          </note>
     * @public
     */
    FleetIds?: string[];
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> |
     *                   <code>pending-fulfillment</code> | <code>pending-termination</code> |
     *                   <code>fulfilled</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>excess-capacity-termination-policy</code> - Indicates whether to terminate
     *                running instances if the target capacity is decreased below the current EC2 Fleet size
     *                   (<code>true</code> | <code>false</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> |
     *                   <code>active</code> | <code>deleted</code> | <code>failed</code> |
     *                   <code>deleted-running</code> | <code>deleted-terminating</code> |
     *                   <code>modifying</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace
     *                unhealthy instances (<code>true</code> | <code>false</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>type</code> - The type of request (<code>instant</code> |
     *                   <code>request</code> | <code>maintain</code>).</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
}
/**
 * @public
 * @enum
 */
export declare const FleetActivityStatus: {
    readonly ERROR: "error";
    readonly FULFILLED: "fulfilled";
    readonly PENDING_FULFILLMENT: "pending_fulfillment";
    readonly PENDING_TERMINATION: "pending_termination";
};
/**
 * @public
 */
export type FleetActivityStatus = (typeof FleetActivityStatus)[keyof typeof FleetActivityStatus];
/**
 * <p>Describes the instances that could not be launched by the fleet.</p>
 * @public
 */
export interface DescribeFleetError {
    /**
     * <p>The launch templates and overrides that were used for launching the instances. The
     *          values that you specify in the Overrides replace the values in the launch template.</p>
     * @public
     */
    LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
    /**
     * <p>Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.</p>
     * @public
     */
    Lifecycle?: InstanceLifecycle;
    /**
     * <p>The error code that indicates why the instance could not be launched. For more
     *          information about error codes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error codes</a>.</p>
     * @public
     */
    ErrorCode?: string;
    /**
     * <p>The error message that describes why the instance could not be launched. For more
     *          information about error messages, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html">Error codes</a>.</p>
     * @public
     */
    ErrorMessage?: string;
}
/**
 * <p>Describes the instances that were launched by the fleet.</p>
 * @public
 */
export interface DescribeFleetsInstances {
    /**
     * <p>The launch templates and overrides that were used for launching the instances. The
     *          values that you specify in the Overrides replace the values in the launch template.</p>
     * @public
     */
    LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
    /**
     * <p>Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.</p>
     * @public
     */
    Lifecycle?: InstanceLifecycle;
    /**
     * <p>The IDs of the instances.</p>
     * @public
     */
    InstanceIds?: string[];
    /**
     * <p>The instance type.</p>
     * @public
     */
    InstanceType?: _InstanceType;
    /**
     * <p>The value is <code>Windows</code> for Windows instances. Otherwise, the value is
     *          blank.</p>
     * @public
     */
    Platform?: PlatformValues;
}
/**
 * <p>Describes a launch template and overrides.</p>
 * @public
 */
export interface FleetLaunchTemplateConfig {
    /**
     * <p>The launch template.</p>
     * @public
     */
    LaunchTemplateSpecification?: FleetLaunchTemplateSpecification;
    /**
     * <p>Any parameters that you specify override the same parameters in the launch
     *          template.</p>
     * @public
     */
    Overrides?: FleetLaunchTemplateOverrides[];
}
/**
 * <p>Describes the strategy for using unused Capacity Reservations for fulfilling On-Demand
 *          capacity.</p>
 *          <note>
 *             <p>This strategy can only be used if the EC2 Fleet is of type
 *             <code>instant</code>.</p>
 *          </note>
 *          <p>For more information about Capacity Reservations, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">On-Demand Capacity
 *             Reservations</a> in the <i>Amazon EC2 User Guide</i>. For examples of using
 *          Capacity Reservations in an EC2 Fleet, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html">EC2 Fleet example
 *             configurations</a> in the <i>Amazon EC2 User Guide</i>.</p>
 * @public
 */
export interface CapacityReservationOptions {
    /**
     * <p>Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.</p>
     *          <p>If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused
     *          Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If
     *          multiple instance pools have unused Capacity Reservations, the On-Demand allocation
     *          strategy (<code>lowest-price</code> or <code>prioritized</code>) is applied. If the number
     *          of unused Capacity Reservations is less than the On-Demand target capacity, the remaining
     *          On-Demand target capacity is launched according to the On-Demand allocation strategy
     *             (<code>lowest-price</code> or <code>prioritized</code>).</p>
     *          <p>If you do not specify a value, the fleet fulfils the On-Demand capacity according to the
     *          chosen On-Demand allocation strategy.</p>
     * @public
     */
    UsageStrategy?: FleetCapacityReservationUsageStrategy;
}
/**
 * <p>Describes the configuration of On-Demand Instances in an EC2 Fleet.</p>
 * @public
 */
export interface OnDemandOptions {
    /**
     * <p>The strategy that determines the order of the launch template overrides to use in
     *          fulfilling On-Demand capacity.</p>
     *          <p>
     *             <code>lowest-price</code> - EC2 Fleet uses price to determine the order, launching the lowest
     *          price first.</p>
     *          <p>
     *             <code>prioritized</code> - EC2 Fleet uses the priority that you assigned to each launch
     *          template override, launching the highest priority first.</p>
     *          <p>Default: <code>lowest-price</code>
     *          </p>
     * @public
     */
    AllocationStrategy?: FleetOnDemandAllocationStrategy;
    /**
     * <p>The strategy for using unused Capacity Reservations for fulfilling On-Demand
     *          capacity.</p>
     *          <p>Supported only for fleets of type <code>instant</code>.</p>
     * @public
     */
    CapacityReservationOptions?: CapacityReservationOptions;
    /**
     * <p>Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the
     *          fleet.</p>
     *          <p>Supported only for fleets of type <code>instant</code>.</p>
     * @public
     */
    SingleInstanceType?: boolean;
    /**
     * <p>Indicates that the fleet launches all On-Demand Instances into a single Availability Zone.</p>
     *          <p>Supported only for fleets of type <code>instant</code>.</p>
     * @public
     */
    SingleAvailabilityZone?: boolean;
    /**
     * <p>The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is
     *          not reached, the fleet launches no instances.</p>
     *          <p>Supported only for fleets of type <code>instant</code>.</p>
     *          <p>At least one of the following must be specified: <code>SingleAvailabilityZone</code> |
     *          <code>SingleInstanceType</code>
     *          </p>
     * @public
     */
    MinTargetCapacity?: number;
    /**
     * <p>The maximum amount per hour for On-Demand Instances that you're willing to pay.</p>
     *          <note>
     *             <p>If your fleet includes T instances that are configured as <code>unlimited</code>,
     *             and if their average CPU usage exceeds the baseline utilization, you will incur a charge
     *             for surplus credits. The <code>maxTotalPrice</code> does not account for surplus
     *             credits, and, if you use surplus credits, your final cost might be higher than what you
     *             specified for <code>maxTotalPrice</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-unlimited-mode-concepts.html#unlimited-mode-surplus-credits">Surplus credits can incur charges</a> in the <i>EC2 User
     *                   Guide</i>.</p>
     *          </note>
     * @public
     */
    MaxTotalPrice?: string;
}
/**
 * <p>The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an
 *          elevated risk of being interrupted.</p>
 * @public
 */
export interface FleetSpotCapacityRebalance {
    /**
     * <p>The replacement strategy to use. Only available for fleets of type
     *          <code>maintain</code>.</p>
     *          <p>
     *             <code>launch</code> - EC2 Fleet launches a new replacement Spot Instance when a
     *          rebalance notification is emitted for an existing Spot Instance in the fleet. EC2 Fleet
     *          does not terminate the instances that receive a rebalance notification. You can terminate
     *          the old instances, or you can leave them running. You are charged for all instances while
     *          they are running. </p>
     *          <p>
     *             <code>launch-before-terminate</code> - EC2 Fleet launches a new replacement Spot
     *          Instance when a rebalance notification is emitted for an existing Spot Instance in the
     *          fleet, and then, after a delay that you specify (in <code>TerminationDelay</code>),
     *          terminates the instances that received a rebalance notification.</p>
     * @public
     */
    ReplacementStrategy?: FleetReplacementStrategy;
    /**
     * <p>The amount of time (in seconds) that Amazon EC2 waits before terminating the old Spot
     *          Instance after launching a new replacement Spot Instance.</p>
     *          <p>Required when <code>ReplacementStrategy</code> is set to <code>launch-before-terminate</code>.</p>
     *          <p>Not valid when <code>ReplacementStrategy</code> is set to <code>launch</code>.</p>
     *          <p>Valid values: Minimum value of <code>120</code> seconds. Maximum value of <code>7200</code> seconds.</p>
     * @public
     */
    TerminationDelay?: number;
}
/**
 * <p>The strategies for managing your Spot Instances that are at an elevated risk of being
 *          interrupted.</p>
 * @public
 */
export interface FleetSpotMaintenanceStrategies {
    /**
     * <p>The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an
     *          elevated risk of being interrupted.</p>
     * @public
     */
    CapacityRebalance?: FleetSpotCapacityRebalance;
}
/**
 * <p>Describes the configuration of Spot Instances in an EC2 Fleet.</p>
 * @public
 */
export interface SpotOptions {
    /**
     * <p>The strategy that determines how to allocate the target Spot Instance capacity across the Spot Instance
     *          pools specified by the EC2 Fleet launch configuration. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-allocation-strategy.html">Allocation strategies for Spot Instances</a> in the
     *          <i>Amazon EC2 User Guide</i>.</p>
     *          <dl>
     *             <dt>price-capacity-optimized (recommended)</dt>
     *             <dd>
     *                <p>EC2 Fleet identifies the pools with
     *                   the highest capacity availability for the number of instances that are launching. This means
     *                   that we will request Spot Instances from the pools that we believe have the lowest chance of interruption
     *                   in the near term. EC2 Fleet then requests Spot Instances from the lowest priced of these pools.</p>
     *             </dd>
     *             <dt>capacity-optimized</dt>
     *             <dd>
     *                <p>EC2 Fleet identifies the pools with
     *                   the highest capacity availability for the number of instances that are launching. This means
     *                   that we will request Spot Instances from the pools that we believe have the lowest chance of interruption
     *                   in the near term. To give certain
     *                   instance types a higher chance of launching first, use
     *                   <code>capacity-optimized-prioritized</code>. Set a priority for each instance type by
     *                   using the <code>Priority</code> parameter for <code>LaunchTemplateOverrides</code>. You can
     *                   assign the same priority to different <code>LaunchTemplateOverrides</code>. EC2 implements
     *                   the priorities on a best-effort basis, but optimizes for capacity first.
     *                   <code>capacity-optimized-prioritized</code> is supported only if your EC2 Fleet uses a
     *                   launch template. Note that if the On-Demand <code>AllocationStrategy</code> is set to
     *                   <code>prioritized</code>, the same priority is applied when fulfilling On-Demand
     *                   capacity.</p>
     *             </dd>
     *             <dt>diversified</dt>
     *             <dd>
     *                <p>EC2 Fleet requests instances from all of the Spot Instance pools that you
     *                   specify.</p>
     *             </dd>
     *             <dt>lowest-price</dt>
     *             <dd>
     *                <p>EC2 Fleet requests instances from the lowest priced Spot Instance pool that
     *                   has available capacity. If the lowest priced pool doesn't have available capacity, the Spot Instances
     *                   come from the next lowest priced pool that has available capacity. If a pool runs out of
     *                   capacity before fulfilling your desired capacity, EC2 Fleet will continue to fulfill your
     *                   request by drawing from the next lowest priced pool. To ensure that your desired capacity is
     *                   met, you might receive Spot Instances from several pools. Because this strategy only considers instance
     *                   price and not capacity availability, it might lead to high interruption rates.</p>
     *             </dd>
     *          </dl>
     *          <p>Default: <code>lowest-price</code>
     *          </p>
     * @public
     */
    AllocationStrategy?: SpotAllocationStrategy;
    /**
     * <p>The strategies for managing your workloads on your Spot Instances that will be
     *          interrupted. Currently only the capacity rebalance strategy is available.</p>
     * @public
     */
    MaintenanceStrategies?: FleetSpotMaintenanceStrategies;
    /**
     * <p>The behavior when a Spot Instance is interrupted.</p>
     *          <p>Default: <code>terminate</code>
     *          </p>
     * @public
     */
    InstanceInterruptionBehavior?: SpotInstanceInterruptionBehavior;
    /**
     * <p>The number of Spot pools across which to allocate your target Spot capacity. Supported
     *          only when <code>AllocationStrategy</code> is set to <code>lowest-price</code>. EC2 Fleet selects
     *          the cheapest Spot pools and evenly allocates your target Spot capacity across the number of
     *          Spot pools that you specify.</p>
     *          <p>Note that EC2 Fleet attempts to draw Spot Instances from the number of pools that you specify on a
     *          best effort basis. If a pool runs out of Spot capacity before fulfilling your target
     *          capacity, EC2 Fleet will continue to fulfill your request by drawing from the next cheapest
     *          pool. To ensure that your target capacity is met, you might receive Spot Instances from more than
     *          the number of pools that you specified. Similarly, if most of the pools have no Spot
     *          capacity, you might receive your full target capacity from fewer than the number of pools
     *          that you specified.</p>
     * @public
     */
    InstancePoolsToUseCount?: number;
    /**
     * <p>Indicates that the fleet uses a single instance type to launch all Spot Instances in the
     *          fleet.</p>
     *          <p>Supported only for fleets of type <code>instant</code>.</p>
     * @public
     */
    SingleInstanceType?: boolean;
    /**
     * <p>Indicates that the fleet launches all Spot Instances into a single Availability Zone.</p>
     *          <p>Supported only for fleets of type <code>instant</code>.</p>
     * @public
     */
    SingleAvailabilityZone?: boolean;
    /**
     * <p>The minimum target capacity for Spot Instances in the fleet. If the minimum target capacity is
     *          not reached, the fleet launches no instances.</p>
     *          <p>Supported only for fleets of type <code>instant</code>.</p>
     *          <p>At least one of the following must be specified: <code>SingleAvailabilityZone</code> |
     *             <code>SingleInstanceType</code>
     *          </p>
     * @public
     */
    MinTargetCapacity?: number;
    /**
     * <p>The maximum amount per hour for Spot Instances that you're willing to pay. We do not recommend
     *          using this parameter because it can lead to increased interruptions. If you do not specify
     *          this parameter, you will pay the current Spot price.</p>
     *          <important>
     *             <p>If you specify a maximum price, your Spot Instances will be interrupted more frequently than if you do not specify this parameter.</p>
     *          </important>
     *          <note>
     *             <p>If your fleet includes T instances that are configured as <code>unlimited</code>,
     *             and if their average CPU usage exceeds the baseline utilization, you will incur a charge
     *             for surplus credits. The <code>maxTotalPrice</code> does not account for surplus
     *             credits, and, if you use surplus credits, your final cost might be higher than what you
     *             specified for <code>maxTotalPrice</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-unlimited-mode-concepts.html#unlimited-mode-surplus-credits">Surplus credits can incur charges</a> in the <i>EC2 User
     *                   Guide</i>.</p>
     *          </note>
     * @public
     */
    MaxTotalPrice?: string;
}
/**
 * <p>The number of units to request. You can choose to set the target capacity in terms of
 *          instances or a performance characteristic that is important to your application workload,
 *          such as vCPUs, memory, or I/O. If the request type is <code>maintain</code>, you can
 *          specify a target capacity of 0 and add capacity later.</p>
 *          <p>You can use the On-Demand Instance <code>MaxTotalPrice</code> parameter, the Spot Instance
 *             <code>MaxTotalPrice</code>, or both to ensure that your fleet cost does not exceed your
 *          budget. If you set a maximum price per hour for the On-Demand Instances and Spot Instances in your request, EC2 Fleet
 *          will launch instances until it reaches the maximum amount that you're willing to pay. When
 *          the maximum amount you're willing to pay is reached, the fleet stops launching instances
 *          even if it hasn’t met the target capacity. The <code>MaxTotalPrice</code> parameters are
 *          located in <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_OnDemandOptions.html">OnDemandOptions</a>
 *          and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotOptions">SpotOptions</a>.</p>
 * @public
 */
export interface TargetCapacitySpecification {
    /**
     * <p>The number of units to request, filled the default target capacity type.</p>
     * @public
     */
    TotalTargetCapacity?: number;
    /**
     * <p>The number of On-Demand units to request. If you specify a target capacity for Spot units, you cannot specify a target capacity for On-Demand units.</p>
     * @public
     */
    OnDemandTargetCapacity?: number;
    /**
     * <p>The maximum number of Spot units to launch. If you specify a target capacity for On-Demand units, you cannot specify a target capacity for Spot units.</p>
     * @public
     */
    SpotTargetCapacity?: number;
    /**
     * <p>The default target capacity type.</p>
     * @public
     */
    DefaultTargetCapacityType?: DefaultTargetCapacityType;
    /**
     * <p>The unit for the target capacity.</p>
     * @public
     */
    TargetCapacityUnitType?: TargetCapacityUnitType;
}
/**
 * <p>Describes an EC2 Fleet.</p>
 * @public
 */
export interface FleetData {
    /**
     * <p>The progress of the EC2 Fleet. If there is an error, the status is <code>error</code>. After
     *          all requests are placed, the status is <code>pending_fulfillment</code>. If the size of the
     *          EC2 Fleet is equal to or greater than its target capacity, the status is <code>fulfilled</code>.
     *          If the size of the EC2 Fleet is decreased, the status is <code>pending_termination</code> while
     *          instances are terminating.</p>
     * @public
     */
    ActivityStatus?: FleetActivityStatus;
    /**
     * <p>The creation date and time of the EC2 Fleet.</p>
     * @public
     */
    CreateTime?: Date;
    /**
     * <p>The ID of the EC2 Fleet.</p>
     * @public
     */
    FleetId?: string;
    /**
     * <p>The state of the EC2 Fleet.</p>
     * @public
     */
    FleetState?: FleetStateCode;
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     *          request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *             idempotency</a>.</p>
     *          <p>Constraints: Maximum 64 ASCII characters</p>
     * @public
     */
    ClientToken?: string;
    /**
     * <p>Indicates whether running instances should be terminated if the target capacity of the
     *          EC2 Fleet is decreased below the current size of the EC2 Fleet.</p>
     *          <p>Supported only for fleets of type <code>maintain</code>.</p>
     * @public
     */
    ExcessCapacityTerminationPolicy?: FleetExcessCapacityTerminationPolicy;
    /**
     * <p>The number of units fulfilled by this request compared to the set target
     *          capacity.</p>
     * @public
     */
    FulfilledCapacity?: number;
    /**
     * <p>The number of units fulfilled by this request compared to the set target On-Demand
     *          capacity.</p>
     * @public
     */
    FulfilledOnDemandCapacity?: number;
    /**
     * <p>The launch template and overrides.</p>
     * @public
     */
    LaunchTemplateConfigs?: FleetLaunchTemplateConfig[];
    /**
     * <p>The number of units to request. You can choose to set the target capacity in terms of
     *          instances or a performance characteristic that is important to your application workload,
     *          such as vCPUs, memory, or I/O. If the request type is <code>maintain</code>, you can
     *          specify a target capacity of 0 and add capacity later.</p>
     * @public
     */
    TargetCapacitySpecification?: TargetCapacitySpecification;
    /**
     * <p>Indicates whether running instances should be terminated when the EC2 Fleet expires. </p>
     * @public
     */
    TerminateInstancesWithExpiration?: boolean;
    /**
     * <p>The type of request. Indicates whether the EC2 Fleet only <code>requests</code> the target
     *          capacity, or also attempts to <code>maintain</code> it. If you request a certain target
     *          capacity, EC2 Fleet only places the required requests; it does not attempt to replenish
     *          instances if capacity is diminished, and it does not submit requests in alternative
     *          capacity pools if capacity is unavailable. To maintain a certain target capacity, EC2 Fleet
     *          places the required requests to meet this target capacity. It also automatically
     *          replenishes any interrupted Spot Instances. Default: <code>maintain</code>.</p>
     * @public
     */
    Type?: FleetType;
    /**
     * <p>The start date and time of the request, in UTC format (for example,
     *             <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     *          The default is to start fulfilling the request immediately. </p>
     * @public
     */
    ValidFrom?: Date;
    /**
     * <p>The end date and time of the request, in UTC format (for example,
     *             <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     *          At this point, no new instance requests are placed or able to fulfill the request. The
     *          default end date is 7 days from the current date. </p>
     * @public
     */
    ValidUntil?: Date;
    /**
     * <p>Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for
     *          fleets of type <code>maintain</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet
     *             health checks</a> in the <i>Amazon EC2 User Guide</i>.</p>
     * @public
     */
    ReplaceUnhealthyInstances?: boolean;
    /**
     * <p>The configuration of Spot Instances in an EC2 Fleet.</p>
     * @public
     */
    SpotOptions?: SpotOptions;
    /**
     * <p>The allocation strategy of On-Demand Instances in an EC2 Fleet.</p>
     * @public
     */
    OnDemandOptions?: OnDemandOptions;
    /**
     * <p>The tags for an EC2 Fleet resource.</p>
     * @public
     */
    Tags?: Tag[];
    /**
     * <p>Information about the instances that could not be launched by the fleet. Valid only when
     *          <b>Type</b> is set to <code>instant</code>.</p>
     * @public
     */
    Errors?: DescribeFleetError[];
    /**
     * <p>Information about the instances that were launched by the fleet. Valid only when
     *          <b>Type</b> is set to <code>instant</code>.</p>
     * @public
     */
    Instances?: DescribeFleetsInstances[];
    /**
     * <p>Reserved.</p>
     * @public
     */
    Context?: string;
}
/**
 * @public
 */
export interface DescribeFleetsResult {
    /**
     * <p>The token to include in another request to get the next page of items. This value is <code>null</code> when there
     *          are no more items to return.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>Information about the EC2 Fleets.</p>
     * @public
     */
    Fleets?: FleetData[];
}
/**
 * @public
 */
export interface DescribeFlowLogsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>One or more filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> |
     *                     <code>FAILED</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>log-destination-type</code> - The type of destination for the flow log
     *                     data (<code>cloud-watch-logs</code> | <code>s3</code> |
     *                         <code>kinesis-data-firehose</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>flow-log-id</code> - The ID of the flow log.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>log-group-name</code> - The name of the log group.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>resource-id</code> - The ID of the VPC, subnet, or network interface.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> |
     *                     <code>REJECT</code> | <code>ALL</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filter?: Filter[];
    /**
     * <p>One or more flow log IDs.</p>
     *          <p>Constraint: Maximum of 1000 flow log IDs.</p>
     * @public
     */
    FlowLogIds?: string[];
    /**
     * <p>The maximum number of items to return for this request.
     * 	To get the next page of items, make another request with the token returned in the output.
     * 	For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token to request the next page of items. Pagination continues from the end of the items returned by the previous request.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * <p>Describes the destination options for a flow log.</p>
 * @public
 */
export interface DestinationOptionsResponse {
    /**
     * <p>The format for the flow log.</p>
     * @public
     */
    FileFormat?: DestinationFileFormat;
    /**
     * <p>Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3.</p>
     * @public
     */
    HiveCompatiblePartitions?: boolean;
    /**
     * <p>Indicates whether to partition the flow log per hour.</p>
     * @public
     */
    PerHourPartition?: boolean;
}
/**
 * <p>Describes a flow log.</p>
 * @public
 */
export interface FlowLog {
    /**
     * <p>The date and time the flow log was created.</p>
     * @public
     */
    CreationTime?: Date;
    /**
     * <p>Information about the error that occurred. <code>Rate limited</code> indicates that
     *             CloudWatch Logs throttling has been applied for one or more network interfaces, or that you've
     *             reached the limit on the number of log groups that you can create. <code>Access
     *                 error</code> indicates that the IAM role associated with the flow log does not have
     *             sufficient permissions to publish to CloudWatch Logs. <code>Unknown error</code> indicates an
     *             internal error.</p>
     * @public
     */
    DeliverLogsErrorMessage?: string;
    /**
     * <p>The ARN of the IAM role allows the service to publish logs to CloudWatch Logs.</p>
     * @public
     */
    DeliverLogsPermissionArn?: string;
    /**
     * <p>The ARN of the IAM role that allows the service to publish flow logs across accounts.</p>
     * @public
     */
    DeliverCrossAccountRole?: string;
    /**
     * <p>The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).</p>
     * @public
     */
    DeliverLogsStatus?: string;
    /**
     * <p>The ID of the flow log.</p>
     * @public
     */
    FlowLogId?: string;
    /**
     * <p>The status of the flow log (<code>ACTIVE</code>).</p>
     * @public
     */
    FlowLogStatus?: string;
    /**
     * <p>The name of the flow log group.</p>
     * @public
     */
    LogGroupName?: string;
    /**
     * <p>The ID of the resource being monitored.</p>
     * @public
     */
    ResourceId?: string;
    /**
     * <p>The type of traffic captured for the flow log.</p>
     * @public
     */
    TrafficType?: TrafficType;
    /**
     * <p>The type of destination for the flow log data.</p>
     * @public
     */
    LogDestinationType?: LogDestinationType;
    /**
     * <p>The Amazon Resource Name (ARN) of the destination for the flow log data.</p>
     * @public
     */
    LogDestination?: string;
    /**
     * <p>The format of the flow log record.</p>
     * @public
     */
    LogFormat?: string;
    /**
     * <p>The tags for the flow log.</p>
     * @public
     */
    Tags?: Tag[];
    /**
     * <p>The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into a flow log record.</p>
     *          <p>When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based
     *                 instance</a>, the aggregation interval is always 60 seconds (1 minute) or less,
     *             regardless of the specified value.</p>
     *          <p>Valid Values: <code>60</code> | <code>600</code>
     *          </p>
     * @public
     */
    MaxAggregationInterval?: number;
    /**
     * <p>The destination options.</p>
     * @public
     */
    DestinationOptions?: DestinationOptionsResponse;
}
/**
 * @public
 */
export interface DescribeFlowLogsResult {
    /**
     * <p>Information about the flow logs.</p>
     * @public
     */
    FlowLogs?: FlowLog[];
    /**
     * <p>The token to request the next page of items. This value is <code>null</code> when there are no more items to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 * @enum
 */
export declare const FpgaImageAttributeName: {
    readonly description: "description";
    readonly loadPermission: "loadPermission";
    readonly name: "name";
    readonly productCodes: "productCodes";
};
/**
 * @public
 */
export type FpgaImageAttributeName = (typeof FpgaImageAttributeName)[keyof typeof FpgaImageAttributeName];
/**
 * @public
 */
export interface DescribeFpgaImageAttributeRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the AFI.</p>
     * @public
     */
    FpgaImageId: string | undefined;
    /**
     * <p>The AFI attribute.</p>
     * @public
     */
    Attribute: FpgaImageAttributeName | undefined;
}
/**
 * @public
 * @enum
 */
export declare const PermissionGroup: {
    readonly all: "all";
};
/**
 * @public
 */
export type PermissionGroup = (typeof PermissionGroup)[keyof typeof PermissionGroup];
/**
 * <p>Describes a load permission.</p>
 * @public
 */
export interface LoadPermission {
    /**
     * <p>The Amazon Web Services account ID.</p>
     * @public
     */
    UserId?: string;
    /**
     * <p>The name of the group.</p>
     * @public
     */
    Group?: PermissionGroup;
}
/**
 * @public
 * @enum
 */
export declare const ProductCodeValues: {
    readonly devpay: "devpay";
    readonly marketplace: "marketplace";
};
/**
 * @public
 */
export type ProductCodeValues = (typeof ProductCodeValues)[keyof typeof ProductCodeValues];
/**
 * <p>Describes a product code.</p>
 * @public
 */
export interface ProductCode {
    /**
     * <p>The product code.</p>
     * @public
     */
    ProductCodeId?: string;
    /**
     * <p>The type of product code.</p>
     * @public
     */
    ProductCodeType?: ProductCodeValues;
}
/**
 * <p>Describes an Amazon FPGA image (AFI) attribute.</p>
 * @public
 */
export interface FpgaImageAttribute {
    /**
     * <p>The ID of the AFI.</p>
     * @public
     */
    FpgaImageId?: string;
    /**
     * <p>The name of the AFI.</p>
     * @public
     */
    Name?: string;
    /**
     * <p>The description of the AFI.</p>
     * @public
     */
    Description?: string;
    /**
     * <p>The load permissions.</p>
     * @public
     */
    LoadPermissions?: LoadPermission[];
    /**
     * <p>The product codes.</p>
     * @public
     */
    ProductCodes?: ProductCode[];
}
/**
 * @public
 */
export interface DescribeFpgaImageAttributeResult {
    /**
     * <p>Information about the attribute.</p>
     * @public
     */
    FpgaImageAttribute?: FpgaImageAttribute;
}
/**
 * @public
 */
export interface DescribeFpgaImagesRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The AFI IDs.</p>
     * @public
     */
    FpgaImageIds?: string[];
    /**
     * <p>Filters the AFI by owner. Specify an Amazon Web Services account ID, <code>self</code>
     * 			(owner is the sender of the request), or an Amazon Web Services owner alias (valid values are
     * 			<code>amazon</code> | <code>aws-marketplace</code>).</p>
     * @public
     */
    Owners?: string[];
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>create-time</code> - The creation time of the AFI.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>name</code> - The name of the AFI.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>owner-id</code> - The Amazon Web Services account ID of the AFI owner.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>product-code</code> - The product code.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>shell-version</code> - The version of the Amazon Web Services Shell that was used to create the bitstream.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> | <code>available</code> | <code>unavailable</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>update-time</code> - The time of the most recent update.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The token to retrieve the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return in a single call.</p>
     * @public
     */
    MaxResults?: number;
}
/**
 * <p>Describes the data that identifies an Amazon FPGA image (AFI) on the PCI bus.</p>
 * @public
 */
export interface PciId {
    /**
     * <p>The ID of the device.</p>
     * @public
     */
    DeviceId?: string;
    /**
     * <p>The ID of the vendor.</p>
     * @public
     */
    VendorId?: string;
    /**
     * <p>The ID of the subsystem.</p>
     * @public
     */
    SubsystemId?: string;
    /**
     * <p>The ID of the vendor for the subsystem.</p>
     * @public
     */
    SubsystemVendorId?: string;
}
/**
 * @public
 * @enum
 */
export declare const FpgaImageStateCode: {
    readonly available: "available";
    readonly failed: "failed";
    readonly pending: "pending";
    readonly unavailable: "unavailable";
};
/**
 * @public
 */
export type FpgaImageStateCode = (typeof FpgaImageStateCode)[keyof typeof FpgaImageStateCode];
/**
 * <p>Describes the state of the bitstream generation process for an Amazon FPGA image (AFI).</p>
 * @public
 */
export interface FpgaImageState {
    /**
     * <p>The state. The following are the possible values:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>pending</code> - AFI bitstream generation is in progress.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>available</code> - The AFI is available for use.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>failed</code> - AFI bitstream generation failed.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>unavailable</code> - The AFI is no longer available for use.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Code?: FpgaImageStateCode;
    /**
     * <p>If the state is <code>failed</code>, this is the error message.</p>
     * @public
     */
    Message?: string;
}
/**
 * <p>Describes an Amazon FPGA image (AFI).</p>
 * @public
 */
export interface FpgaImage {
    /**
     * <p>The FPGA image identifier (AFI ID).</p>
     * @public
     */
    FpgaImageId?: string;
    /**
     * <p>The global FPGA image identifier (AGFI ID).</p>
     * @public
     */
    FpgaImageGlobalId?: string;
    /**
     * <p>The name of the AFI.</p>
     * @public
     */
    Name?: string;
    /**
     * <p>The description of the AFI.</p>
     * @public
     */
    Description?: string;
    /**
     * <p>The version of the Amazon Web Services Shell that was used to create the bitstream.</p>
     * @public
     */
    ShellVersion?: string;
    /**
     * <p>Information about the PCI bus.</p>
     * @public
     */
    PciId?: PciId;
    /**
     * <p>Information about the state of the AFI.</p>
     * @public
     */
    State?: FpgaImageState;
    /**
     * <p>The date and time the AFI was created.</p>
     * @public
     */
    CreateTime?: Date;
    /**
     * <p>The time of the most recent update to the AFI.</p>
     * @public
     */
    UpdateTime?: Date;
    /**
     * <p>The ID of the Amazon Web Services account that owns the AFI.</p>
     * @public
     */
    OwnerId?: string;
    /**
     * <p>The alias of the AFI owner. Possible values include <code>self</code>, <code>amazon</code>, and <code>aws-marketplace</code>.</p>
     * @public
     */
    OwnerAlias?: string;
    /**
     * <p>The product codes for the AFI.</p>
     * @public
     */
    ProductCodes?: ProductCode[];
    /**
     * <p>Any tags assigned to the AFI.</p>
     * @public
     */
    Tags?: Tag[];
    /**
     * <p>Indicates whether the AFI is public.</p>
     * @public
     */
    Public?: boolean;
    /**
     * <p>Indicates whether data retention support is enabled for the AFI.</p>
     * @public
     */
    DataRetentionSupport?: boolean;
    /**
     * <p>The instance types supported by the AFI.</p>
     * @public
     */
    InstanceTypes?: string[];
}
/**
 * @public
 */
export interface DescribeFpgaImagesResult {
    /**
     * <p>Information about the FPGA images.</p>
     * @public
     */
    FpgaImages?: FpgaImage[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeHostReservationOfferingsRequest {
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>instance-family</code> - The instance family of the offering (for example,
     *                         <code>m4</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>payment-option</code> - The payment option (<code>NoUpfront</code> |
     *                         <code>PartialUpfront</code> | <code>AllUpfront</code>).</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filter?: Filter[];
    /**
     * <p>This is the maximum duration of the reservation to purchase, specified in seconds.
     *             Reservations are available in one-year and three-year terms. The number of seconds
     *             specified must be the number of seconds in a year (365x24x60x60) times one of the
     *             supported durations (1 or 3). For example, specify 94608000 for three years.</p>
     * @public
     */
    MaxDuration?: number;
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>This is the minimum duration of the reservation you'd like to purchase, specified in
     *             seconds. Reservations are available in one-year and three-year terms. The number of
     *             seconds specified must be the number of seconds in a year (365x24x60x60) times one of
     *             the supported durations (1 or 3). For example, specify 31536000 for one year.</p>
     * @public
     */
    MinDuration?: number;
    /**
     * <p>The token to use to retrieve the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>The ID of the reservation offering.</p>
     * @public
     */
    OfferingId?: string;
}
/**
 * @public
 * @enum
 */
export declare const PaymentOption: {
    readonly ALL_UPFRONT: "AllUpfront";
    readonly NO_UPFRONT: "NoUpfront";
    readonly PARTIAL_UPFRONT: "PartialUpfront";
};
/**
 * @public
 */
export type PaymentOption = (typeof PaymentOption)[keyof typeof PaymentOption];
/**
 * <p>Details about the Dedicated Host Reservation offering.</p>
 * @public
 */
export interface HostOffering {
    /**
     * <p>The currency of the offering.</p>
     * @public
     */
    CurrencyCode?: CurrencyCodeValues;
    /**
     * <p>The duration of the offering (in seconds).</p>
     * @public
     */
    Duration?: number;
    /**
     * <p>The hourly price of the offering.</p>
     * @public
     */
    HourlyPrice?: string;
    /**
     * <p>The instance family of the offering.</p>
     * @public
     */
    InstanceFamily?: string;
    /**
     * <p>The ID of the offering.</p>
     * @public
     */
    OfferingId?: string;
    /**
     * <p>The available payment option.</p>
     * @public
     */
    PaymentOption?: PaymentOption;
    /**
     * <p>The upfront price of the offering. Does not apply to No Upfront offerings.</p>
     * @public
     */
    UpfrontPrice?: string;
}
/**
 * @public
 */
export interface DescribeHostReservationOfferingsResult {
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>Information about the offerings.</p>
     * @public
     */
    OfferingSet?: HostOffering[];
}
/**
 * @public
 */
export interface DescribeHostReservationsRequest {
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>instance-family</code> - The instance family (for example,
     *                     <code>m4</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>payment-option</code> - The payment option (<code>NoUpfront</code> |
     *                         <code>PartialUpfront</code> | <code>AllUpfront</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the reservation (<code>payment-pending</code>
     *                     | <code>payment-failed</code> | <code>active</code> |
     *                     <code>retired</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag:<key></code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filter?: Filter[];
    /**
     * <p>The host reservation IDs.</p>
     * @public
     */
    HostReservationIdSet?: string[];
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token to use to retrieve the next page of results.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 * @enum
 */
export declare const ReservationState: {
    readonly ACTIVE: "active";
    readonly PAYMENT_FAILED: "payment-failed";
    readonly PAYMENT_PENDING: "payment-pending";
    readonly RETIRED: "retired";
};
/**
 * @public
 */
export type ReservationState = (typeof ReservationState)[keyof typeof ReservationState];
/**
 * <p>Details about the Dedicated Host Reservation and associated Dedicated Hosts.</p>
 * @public
 */
export interface HostReservation {
    /**
     * <p>The number of Dedicated Hosts the reservation is associated with.</p>
     * @public
     */
    Count?: number;
    /**
     * <p>The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code>
     *             amounts are specified. At this time, the only supported currency is
     *             <code>USD</code>.</p>
     * @public
     */
    CurrencyCode?: CurrencyCodeValues;
    /**
     * <p>The length of the reservation's term, specified in seconds. Can be <code>31536000 (1
     *                 year)</code> | <code>94608000 (3 years)</code>.</p>
     * @public
     */
    Duration?: number;
    /**
     * <p>The date and time that the reservation ends.</p>
     * @public
     */
    End?: Date;
    /**
     * <p>The IDs of the Dedicated Hosts associated with the reservation.</p>
     * @public
     */
    HostIdSet?: string[];
    /**
     * <p>The ID of the reservation that specifies the associated Dedicated Hosts.</p>
     * @public
     */
    HostReservationId?: string;
    /**
     * <p>The hourly price of the reservation.</p>
     * @public
     */
    HourlyPrice?: string;
    /**
     * <p>The instance family of the Dedicated Host Reservation. The instance family on the
     *             Dedicated Host must be the same in order for it to benefit from the reservation.</p>
     * @public
     */
    InstanceFamily?: string;
    /**
     * <p>The ID of the reservation. This remains the same regardless of which Dedicated Hosts
     *             are associated with it.</p>
     * @public
     */
    OfferingId?: string;
    /**
     * <p>The payment option selected for this reservation.</p>
     * @public
     */
    PaymentOption?: PaymentOption;
    /**
     * <p>The date and time that the reservation started.</p>
     * @public
     */
    Start?: Date;
    /**
     * <p>The state of the reservation.</p>
     * @public
     */
    State?: ReservationState;
    /**
     * <p>The upfront price of the reservation.</p>
     * @public
     */
    UpfrontPrice?: string;
    /**
     * <p>Any tags assigned to the Dedicated Host Reservation.</p>
     * @public
     */
    Tags?: Tag[];
}
/**
 * @public
 */
export interface DescribeHostReservationsResult {
    /**
     * <p>Details about the reservation's configuration.</p>
     * @public
     */
    HostReservationSet?: HostReservation[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeHostsRequest {
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>auto-placement</code> - Whether auto-placement is enabled or disabled
     *                         (<code>on</code> | <code>off</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>availability-zone</code> - The Availability Zone of the host.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>client-token</code> - The idempotency token that you provided when you
     *                     allocated the host.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>host-reservation-id</code> - The ID of the reservation assigned to this
     *                     host.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>instance-type</code> - The instance type size that the Dedicated Host is
     *                     configured to support.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The allocation state of the Dedicated Host
     *                         (<code>available</code> | <code>under-assessment</code> |
     *                         <code>permanent-failure</code> | <code>released</code> |
     *                         <code>released-permanent-failure</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filter?: Filter[];
    /**
     * <p>The IDs of the Dedicated Hosts. The IDs are used for targeted instance
     *             launches.</p>
     * @public
     */
    HostIds?: string[];
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>
     *          <p>You cannot specify this parameter and the host IDs parameter in the same
     *             request.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token to use to retrieve the next page of results.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * <p>Information about the number of instances that can be launched onto the Dedicated
 *             Host.</p>
 * @public
 */
export interface InstanceCapacity {
    /**
     * <p>The number of instances that can be launched onto the Dedicated Host based on the
     *             host's available capacity.</p>
     * @public
     */
    AvailableCapacity?: number;
    /**
     * <p>The instance type supported by the Dedicated Host.</p>
     * @public
     */
    InstanceType?: string;
    /**
     * <p>The total number of instances that can be launched onto the Dedicated Host if there
     *             are no instances running on it.</p>
     * @public
     */
    TotalCapacity?: number;
}
/**
 * <p>The capacity information for instances that can be launched onto the Dedicated Host.
 *         </p>
 * @public
 */
export interface AvailableCapacity {
    /**
     * <p>The number of instances that can be launched onto the Dedicated Host depending on the
     *             host's available capacity. For Dedicated Hosts that support multiple instance types,
     *             this parameter represents the number of instances for each instance size that is
     *             supported on the host.</p>
     * @public
     */
    AvailableInstanceCapacity?: InstanceCapacity[];
    /**
     * <p>The number of vCPUs available for launching instances onto the Dedicated Host.</p>
     * @public
     */
    AvailableVCpus?: number;
}
/**
 * <p>Describes the properties of a Dedicated Host.</p>
 * @public
 */
export interface HostProperties {
    /**
     * <p>The number of cores on the Dedicated Host.</p>
     * @public
     */
    Cores?: number;
    /**
     * <p>The instance type supported by the Dedicated Host. For example, <code>m5.large</code>.
     *             If the host supports multiple instance types, no <b>instanceType</b> is returned.</p>
     * @public
     */
    InstanceType?: string;
    /**
     * <p>The instance family supported by the Dedicated Host. For example,
     *             <code>m5</code>.</p>
     * @public
     */
    InstanceFamily?: string;
    /**
     * <p>The number of sockets on the Dedicated Host.</p>
     * @public
     */
    Sockets?: number;
    /**
     * <p>The total number of vCPUs on the Dedicated Host.</p>
     * @public
     */
    TotalVCpus?: number;
}
/**
 * <p>Describes an instance running on a Dedicated Host.</p>
 * @public
 */
export interface HostInstance {
    /**
     * <p>The ID of instance that is running on the Dedicated Host.</p>
     * @public
     */
    InstanceId?: string;
    /**
     * <p>The instance type (for example, <code>m3.medium</code>) of the running
     *             instance.</p>
     * @public
     */
    InstanceType?: string;
    /**
     * <p>The ID of the Amazon Web Services account that owns the instance.</p>
     * @public
     */
    OwnerId?: string;
}
/**
 * <p>Describes the properties of the Dedicated Host.</p>
 * @public
 */
export interface Host {
    /**
     * <p>Whether auto-placement is on or off.</p>
     * @public
     */
    AutoPlacement?: AutoPlacement;
    /**
     * <p>The Availability Zone of the Dedicated Host.</p>
     * @public
     */
    AvailabilityZone?: string;
    /**
     * <p>Information about the instances running on the Dedicated Host.</p>
     * @public
     */
    AvailableCapacity?: AvailableCapacity;
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
     * @public
     */
    ClientToken?: string;
    /**
     * <p>The ID of the Dedicated Host.</p>
     * @public
     */
    HostId?: string;
    /**
     * <p>The hardware specifications of the Dedicated Host.</p>
     * @public
     */
    HostProperties?: HostProperties;
    /**
     * <p>The reservation ID of the Dedicated Host. This returns a <code>null</code> response if
     *             the Dedicated Host doesn't have an associated reservation.</p>
     * @public
     */
    HostReservationId?: string;
    /**
     * <p>The IDs and instance type that are currently running on the Dedicated Host.</p>
     * @public
     */
    Instances?: HostInstance[];
    /**
     * <p>The Dedicated Host's state.</p>
     * @public
     */
    State?: AllocationState;
    /**
     * <p>The time that the Dedicated Host was allocated.</p>
     * @public
     */
    AllocationTime?: Date;
    /**
     * <p>The time that the Dedicated Host was released.</p>
     * @public
     */
    ReleaseTime?: Date;
    /**
     * <p>Any tags assigned to the Dedicated Host.</p>
     * @public
     */
    Tags?: Tag[];
    /**
     * <p>Indicates whether host recovery is enabled or disabled for the Dedicated Host.</p>
     * @public
     */
    HostRecovery?: HostRecovery;
    /**
     * <p>Indicates whether the Dedicated Host supports multiple instance types of the same
     *             instance family. If the value is <code>on</code>, the Dedicated Host supports multiple
     *             instance types in the instance family. If the value is <code>off</code>, the Dedicated
     *             Host supports a single instance type only.</p>
     * @public
     */
    AllowsMultipleInstanceTypes?: AllowsMultipleInstanceTypes;
    /**
     * <p>The ID of the Amazon Web Services account that owns the Dedicated Host.</p>
     * @public
     */
    OwnerId?: string;
    /**
     * <p>The ID of the Availability Zone in which the Dedicated Host is allocated.</p>
     * @public
     */
    AvailabilityZoneId?: string;
    /**
     * <p>Indicates whether the Dedicated Host is in a host resource group. If <b>memberOfServiceLinkedResourceGroup</b> is <code>true</code>, the
     *             host is in a host resource group; otherwise, it is not.</p>
     * @public
     */
    MemberOfServiceLinkedResourceGroup?: boolean;
    /**
     * <p>The Amazon Resource Name (ARN) of the Amazon Web Services Outpost on which the
     *             Dedicated Host is allocated.</p>
     * @public
     */
    OutpostArn?: string;
    /**
     * <p>Indicates whether host maintenance is enabled or disabled for the Dedicated
     *             Host.</p>
     * @public
     */
    HostMaintenance?: HostMaintenance;
    /**
     * <p>The ID of the Outpost hardware asset on which the Dedicated Host is allocated.</p>
     * @public
     */
    AssetId?: string;
}
/**
 * @public
 */
export interface DescribeHostsResult {
    /**
     * <p>Information about the Dedicated Hosts.</p>
     * @public
     */
    Hosts?: Host[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeIamInstanceProfileAssociationsRequest {
    /**
     * <p>The IAM instance profile associations.</p>
     * @public
     */
    AssociationIds?: string[];
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>instance-id</code> - The ID of the instance.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the association (<code>associating</code> |
     *                 <code>associated</code> | <code>disassociating</code>).</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of items to return for this request. To get the next page of
     *             items, make another request with the token returned in the output. For more information,
     *             see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token returned from a previous paginated request.
     *             Pagination continues from the end of the items returned by the previous request.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeIamInstanceProfileAssociationsResult {
    /**
     * <p>Information about the IAM instance profile associations.</p>
     * @public
     */
    IamInstanceProfileAssociations?: IamInstanceProfileAssociation[];
    /**
     * <p>The token to include in another request to get the next page of items.
     *             This value is <code>null</code> when there are no more items to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeIdentityIdFormatRequest {
    /**
     * <p>The ARN of the principal, which can be an IAM role, IAM user, or the root user.</p>
     * @public
     */
    PrincipalArn: string | undefined;
    /**
     * <p>The type of resource: <code>bundle</code> |
     *           <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> |
     *           <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> |
     *           <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     *           <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> |
     *           <code>network-acl</code> | <code>network-acl-association</code> |
     *           <code>network-interface</code> | <code>network-interface-attachment</code> |
     *           <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     *           <code>route-table-association</code> | <code>security-group</code> |
     *           <code>snapshot</code> | <code>subnet</code> |
     *           <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code>
     *           | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> |
     *           <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>
     *          </p>
     * @public
     */
    Resource?: string;
}
/**
 * @public
 */
export interface DescribeIdentityIdFormatResult {
    /**
     * <p>Information about the ID format for the resources.</p>
     * @public
     */
    Statuses?: IdFormat[];
}
/**
 * @public
 */
export interface DescribeIdFormatRequest {
    /**
     * <p>The type of resource: <code>bundle</code> |
     *            <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> |
     *            <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> |
     *            <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     *            <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> |
     *            <code>network-acl</code> | <code>network-acl-association</code> |
     *            <code>network-interface</code> | <code>network-interface-attachment</code> |
     *            <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     *            <code>route-table-association</code> | <code>security-group</code> |
     *            <code>snapshot</code> | <code>subnet</code> |
     *            <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code>
     *            | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> |
     *            <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>
     *          </p>
     * @public
     */
    Resource?: string;
}
/**
 * @public
 */
export interface DescribeIdFormatResult {
    /**
     * <p>Information about the ID format for the resource.</p>
     * @public
     */
    Statuses?: IdFormat[];
}
/**
 * @public
 * @enum
 */
export declare const ImageAttributeName: {
    readonly blockDeviceMapping: "blockDeviceMapping";
    readonly bootMode: "bootMode";
    readonly description: "description";
    readonly imdsSupport: "imdsSupport";
    readonly kernel: "kernel";
    readonly lastLaunchedTime: "lastLaunchedTime";
    readonly launchPermission: "launchPermission";
    readonly productCodes: "productCodes";
    readonly ramdisk: "ramdisk";
    readonly sriovNetSupport: "sriovNetSupport";
    readonly tpmSupport: "tpmSupport";
    readonly uefiData: "uefiData";
};
/**
 * @public
 */
export type ImageAttributeName = (typeof ImageAttributeName)[keyof typeof ImageAttributeName];
/**
 * <p>Contains the parameters for DescribeImageAttribute.</p>
 * @public
 */
export interface DescribeImageAttributeRequest {
    /**
     * <p>The AMI attribute.</p>
     *          <p>
     *             <b>Note</b>: The <code>blockDeviceMapping</code> attribute is deprecated.
     *    	    Using this attribute returns the <code>Client.AuthFailure</code> error. To get information about
     *    	    the block device mappings for an AMI, use the <a>DescribeImages</a> action.</p>
     * @public
     */
    Attribute: ImageAttributeName | undefined;
    /**
     * <p>The ID of the AMI.</p>
     * @public
     */
    ImageId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     * 			and provides an error response. If you have the required permissions, the error response is
     * 			<code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Describes a launch permission.</p>
 * @public
 */
export interface LaunchPermission {
    /**
     * <p>The name of the group.</p>
     * @public
     */
    Group?: PermissionGroup;
    /**
     * <p>The Amazon Web Services account ID.</p>
     *          <p>Constraints: Up to 10 000 account IDs can be specified in a single request.</p>
     * @public
     */
    UserId?: string;
    /**
     * <p>The Amazon Resource Name (ARN) of an organization.</p>
     * @public
     */
    OrganizationArn?: string;
    /**
     * <p>The Amazon Resource Name (ARN) of an organizational unit (OU).</p>
     * @public
     */
    OrganizationalUnitArn?: string;
}
/**
 * <p>Describes an image attribute.</p>
 * @public
 */
export interface ImageAttribute {
    /**
     * <p>The block device mapping entries.</p>
     * @public
     */
    BlockDeviceMappings?: BlockDeviceMapping[];
    /**
     * <p>The ID of the AMI.</p>
     * @public
     */
    ImageId?: string;
    /**
     * <p>The launch permissions.</p>
     * @public
     */
    LaunchPermissions?: LaunchPermission[];
    /**
     * <p>The product codes.</p>
     * @public
     */
    ProductCodes?: ProductCode[];
    /**
     * <p>A description for the AMI.</p>
     * @public
     */
    Description?: AttributeValue;
    /**
     * <p>The kernel ID.</p>
     * @public
     */
    KernelId?: AttributeValue;
    /**
     * <p>The RAM disk ID.</p>
     * @public
     */
    RamdiskId?: AttributeValue;
    /**
     * <p>Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>
     * @public
     */
    SriovNetSupport?: AttributeValue;
    /**
     * <p>The boot mode.</p>
     * @public
     */
    BootMode?: AttributeValue;
    /**
     * <p>If the image is configured for NitroTPM support, the value is <code>v2.0</code>.</p>
     * @public
     */
    TpmSupport?: AttributeValue;
    /**
     * <p>Base64 representation of the non-volatile UEFI variable store. To retrieve the UEFI data,
     *       use the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceUefiData">GetInstanceUefiData</a> command. You can inspect and modify the UEFI data by using the
     *       <a href="https://github.com/awslabs/python-uefivars">python-uefivars tool</a> on
     *       GitHub. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/uefi-secure-boot.html">UEFI Secure Boot</a> in the
     *       <i>Amazon EC2 User Guide</i>.</p>
     * @public
     */
    UefiData?: AttributeValue;
    /**
     * <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
     *         format</a>, when the AMI was last used to launch an EC2 instance. When the AMI is used
     *       to launch an instance, there is a 24-hour delay before that usage is reported.</p>
     *          <note>
     *             <p>
     *                <code>lastLaunchedTime</code> data is available starting April 2017.</p>
     *          </note>
     * @public
     */
    LastLaunchedTime?: AttributeValue;
    /**
     * <p>If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched
     *       from this AMI will have <code>HttpTokens</code> automatically set to <code>required</code> so
     *       that, by default, the instance requires that IMDSv2 is used when requesting instance metadata.
     *       In addition, <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more
     *       information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration">Configure
     *         the AMI</a> in the <i>Amazon EC2 User Guide</i>.</p>
     * @public
     */
    ImdsSupport?: AttributeValue;
}
/**
 * @public
 */
export interface DescribeImagesRequest {
    /**
     * <p>Scopes the images by users with explicit launch permissions.
     *        Specify an Amazon Web Services account ID, <code>self</code> (the sender of the request),
     * 				or <code>all</code> (public AMIs).</p>
     *          <ul>
     *             <li>
     *                <p>If you specify an Amazon Web Services account ID that is not your own, only AMIs
     *           shared with that specific Amazon Web Services account ID are returned. However, AMIs that
     *           are shared with the account’s organization or organizational unit (OU) are not
     *           returned.</p>
     *             </li>
     *             <li>
     *                <p>If you specify <code>self</code> or your own Amazon Web Services account ID, AMIs
     *           shared with your account are returned. In addition, AMIs that are shared with the
     *           organization or OU of which you are member are also returned. </p>
     *             </li>
     *             <li>
     *                <p>If you specify <code>all</code>, all public AMIs are returned.</p>
     *             </li>
     *          </ul>
     * @public
     */
    ExecutableUsers?: string[];
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code> |
     *           <code>arm64</code> | <code>x86_64_mac</code> | <code>arm64_mac</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates
     *         	whether the Amazon EBS volume is deleted on instance termination.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for
     *           example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the Amazon EBS
     *           volume.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>block-device-mapping.volume-size</code> - The volume size of the Amazon EBS volume, in GiB.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>block-device-mapping.volume-type</code> - The volume type of the Amazon EBS volume
     *             (<code>io1</code> | <code>io2</code> | <code>gp2</code> | <code>gp3</code> | <code>sc1
     *           </code>| <code>st1</code> | <code>standard</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>block-device-mapping.encrypted</code> - A Boolean that indicates whether the Amazon EBS volume is encrypted.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>creation-date</code> - The time when the image was created, in the ISO 8601
     *           format in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ), for example,
     *             <code>2021-09-29T11:04:43.305Z</code>. You can use a wildcard (<code>*</code>), for
     *           example, <code>2021-09-29T*</code>, which matches an entire day.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>description</code> - The description of the image (provided during image
     *           creation).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>ena-support</code> - A Boolean that indicates whether enhanced networking
     *           with ENA is enabled.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>hypervisor</code> - The hypervisor type (<code>ovm</code> |
     *           <code>xen</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>image-id</code> - The ID of the image.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> |
     *             <code>ramdisk</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>is-public</code> - A Boolean that indicates whether the image is public.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>kernel-id</code> - The kernel ID.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>manifest-location</code> - The location of the image manifest.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>name</code> - The name of the AMI (provided during image creation).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>owner-alias</code> - The owner alias (<code>amazon</code> | <code>aws-marketplace</code>).
     *           The valid aliases are defined in an Amazon-maintained list. This is not the Amazon Web Services account alias that can be
     *         	set using the IAM console. We recommend that you use the <b>Owner</b>
     *         	request parameter instead of this filter.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the
     *       		<b>Owner</b> request parameter instead of this filter.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>platform</code> - The platform. The only supported value is <code>windows</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>product-code</code> - The product code.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>product-code.type</code> - The type of the product code (<code>marketplace</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>ramdisk-id</code> - The RAM disk ID.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>root-device-name</code> - The device name of the root device volume (for example, <code>/dev/sda1</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
     *             <code>instance-store</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>source-instance-id</code> - The ID of the instance that the AMI was created from
     *           if the AMI was created using CreateImage. This filter is applicable only if the AMI was
     *           created using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateImage.html">CreateImage</a>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the image (<code>available</code> | <code>pending</code>
     *           | <code>failed</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state-reason-code</code> - The reason code for the state change.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state-reason-message</code> - The message for the state change.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>sriov-net-support</code> - A value of <code>simple</code> indicates
     *                     that enhanced networking with the Intel 82599 VF interface is enabled.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> |
     *             <code>hvm</code>).</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The image IDs.</p>
     *          <p>Default: Describes all images available to you.</p>
     * @public
     */
    ImageIds?: string[];
    /**
     * <p>Scopes the results to images with the specified owners. You can specify a combination of
     *       Amazon Web Services account IDs, <code>self</code>, <code>amazon</code>, and <code>aws-marketplace</code>.
     *       If you omit this parameter, the results include all images for which you have launch permissions,
     *       regardless of ownership.</p>
     * @public
     */
    Owners?: string[];
    /**
     * <p>Specifies whether to include deprecated AMIs.</p>
     *          <p>Default: No deprecated AMIs are included in the response.</p>
     *          <note>
     *             <p>If you are the AMI owner, all deprecated AMIs appear in the response regardless of what
     *         you specify for this parameter.</p>
     *          </note>
     * @public
     */
    IncludeDeprecated?: boolean;
    /**
     * <p>Specifies whether to include disabled AMIs.</p>
     *          <p>Default: No disabled AMIs are included in the response.</p>
     * @public
     */
    IncludeDisabled?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     * 			and provides an error response. If you have the required permissions, the error response is
     * 			<code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The maximum number of items to return for this request.
     *          To get the next page of items, make another request with the token returned in the output.
     * 	        For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token returned from a previous paginated request. Pagination continues from the end of the items returned by the previous request.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 * @enum
 */
export declare const ArchitectureValues: {
    readonly arm64: "arm64";
    readonly arm64_mac: "arm64_mac";
    readonly i386: "i386";
    readonly x86_64: "x86_64";
    readonly x86_64_mac: "x86_64_mac";
};
/**
 * @public
 */
export type ArchitectureValues = (typeof ArchitectureValues)[keyof typeof ArchitectureValues];
/**
 * @public
 * @enum
 */
export declare const BootModeValues: {
    readonly legacy_bios: "legacy-bios";
    readonly uefi: "uefi";
    readonly uefi_preferred: "uefi-preferred";
};
/**
 * @public
 */
export type BootModeValues = (typeof BootModeValues)[keyof typeof BootModeValues];
/**
 * @public
 * @enum
 */
export declare const HypervisorType: {
    readonly ovm: "ovm";
    readonly xen: "xen";
};
/**
 * @public
 */
export type HypervisorType = (typeof HypervisorType)[keyof typeof HypervisorType];
/**
 * @public
 * @enum
 */
export declare const ImageTypeValues: {
    readonly kernel: "kernel";
    readonly machine: "machine";
    readonly ramdisk: "ramdisk";
};
/**
 * @public
 */
export type ImageTypeValues = (typeof ImageTypeValues)[keyof typeof ImageTypeValues];
/**
 * @public
 * @enum
 */
export declare const ImdsSupportValues: {
    readonly v2_0: "v2.0";
};
/**
 * @public
 */
export type ImdsSupportValues = (typeof ImdsSupportValues)[keyof typeof ImdsSupportValues];
/**
 * @public
 * @enum
 */
export declare const DeviceType: {
    readonly ebs: "ebs";
    readonly instance_store: "instance-store";
};
/**
 * @public
 */
export type DeviceType = (typeof DeviceType)[keyof typeof DeviceType];
/**
 * @public
 * @enum
 */
export declare const ImageState: {
    readonly available: "available";
    readonly deregistered: "deregistered";
    readonly disabled: "disabled";
    readonly error: "error";
    readonly failed: "failed";
    readonly invalid: "invalid";
    readonly pending: "pending";
    readonly transient: "transient";
};
/**
 * @public
 */
export type ImageState = (typeof ImageState)[keyof typeof ImageState];
/**
 * @public
 * @enum
 */
export declare const TpmSupportValues: {
    readonly v2_0: "v2.0";
};
/**
 * @public
 */
export type TpmSupportValues = (typeof TpmSupportValues)[keyof typeof TpmSupportValues];
/**
 * @public
 * @enum
 */
export declare const VirtualizationType: {
    readonly hvm: "hvm";
    readonly paravirtual: "paravirtual";
};
/**
 * @public
 */
export type VirtualizationType = (typeof VirtualizationType)[keyof typeof VirtualizationType];
/**
 * <p>Describes an image.</p>
 * @public
 */
export interface Image {
    /**
     * <p>The architecture of the image.</p>
     * @public
     */
    Architecture?: ArchitectureValues;
    /**
     * <p>The date and time the image was created.</p>
     * @public
     */
    CreationDate?: string;
    /**
     * <p>The ID of the AMI.</p>
     * @public
     */
    ImageId?: string;
    /**
     * <p>The location of the AMI.</p>
     * @public
     */
    ImageLocation?: string;
    /**
     * <p>The type of image.</p>
     * @public
     */
    ImageType?: ImageTypeValues;
    /**
     * <p>Indicates whether the image has public launch permissions. The value is <code>true</code> if
     * 				this image has public launch permissions or <code>false</code>
     * 				if it has only implicit and explicit launch permissions.</p>
     * @public
     */
    Public?: boolean;
    /**
     * <p>The kernel associated with the image, if any. Only applicable for machine images.</p>
     * @public
     */
    KernelId?: string;
    /**
     * <p>The ID of the Amazon Web Services account that owns the image.</p>
     * @public
     */
    OwnerId?: string;
    /**
     * <p>This value is set to <code>windows</code> for Windows AMIs; otherwise, it is blank.</p>
     * @public
     */
    Platform?: PlatformValues;
    /**
     * <p>The platform details associated with the billing code of the AMI. For more information,
     *       see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html">Understand
     *         AMI billing information</a> in the <i>Amazon EC2 User Guide</i>.</p>
     * @public
     */
    PlatformDetails?: string;
    /**
     * <p>The operation of the Amazon EC2 instance and the billing code that is associated with the AMI.
     *         <code>usageOperation</code> corresponds to the <a href="https://docs.aws.amazon.com/cur/latest/userguide/Lineitem-columns.html#Lineitem-details-O-Operation">lineitem/Operation</a> column on your Amazon Web Services Cost and Usage Report and in the <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/price-changes.html">Amazon Web Services Price
     *         	List API</a>. You can view these fields on the <b>Instances</b> or
     *     	<b>AMIs</b> pages in the Amazon EC2 console, or in the responses that are
     *     	returned by the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html">DescribeImages</a>
     *     	command in the Amazon EC2 API, or the <a href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-images.html">describe-images</a>
     *     	command in the CLI.</p>
     * @public
     */
    UsageOperation?: string;
    /**
     * <p>Any product codes associated with the AMI.</p>
     * @public
     */
    ProductCodes?: ProductCode[];
    /**
     * <p>The RAM disk associated with the image, if any. Only applicable for machine images.</p>
     * @public
     */
    RamdiskId?: string;
    /**
     * <p>The current state of the AMI. If the state is <code>available</code>, the image is successfully registered and can be used to launch an instance.</p>
     * @public
     */
    State?: ImageState;
    /**
     * <p>Any block device mapping entries.</p>
     * @public
     */
    BlockDeviceMappings?: BlockDeviceMapping[];
    /**
     * <p>The description of the AMI that was provided during image creation.</p>
     * @public
     */
    Description?: string;
    /**
     * <p>Specifies whether enhanced networking with ENA is enabled.</p>
     * @public
     */
    EnaSupport?: boolean;
    /**
     * <p>The hypervisor type of the image. Only <code>xen</code> is supported. <code>ovm</code> is
     *       not supported.</p>
     * @public
     */
    Hypervisor?: HypervisorType;
    /**
     * <p>The Amazon Web Services account alias (for example, <code>amazon</code>, <code>self</code>) or
     *        the Amazon Web Services account ID of the AMI owner.</p>
     * @public
     */
    ImageOwnerAlias?: string;
    /**
     * <p>The name of the AMI that was provided during image creation.</p>
     * @public
     */
    Name?: string;
    /**
     * <p>The device name of the root device volume (for example, <code>/dev/sda1</code>).</p>
     * @public
     */
    RootDeviceName?: string;
    /**
     * <p>The type of root device used by the AMI. The AMI can use an Amazon EBS volume or an instance store volume.</p>
     * @public
     */
    RootDeviceType?: DeviceType;
    /**
     * <p>Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>
     * @public
     */
    SriovNetSupport?: string;
    /**
     * <p>The reason for the state change.</p>
     * @public
     */
    StateReason?: StateReason;
    /**
     * <p>Any tags assigned to the image.</p>
     * @public
     */
    Tags?: Tag[];
    /**
     * <p>The type of virtualization of the AMI.</p>
     * @public
     */
    VirtualizationType?: VirtualizationType;
    /**
     * <p>The boot mode of the image. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the
     *         <i>Amazon EC2 User Guide</i>.</p>
     * @public
     */
    BootMode?: BootModeValues;
    /**
     * <p>If the image is configured for NitroTPM support, the value is <code>v2.0</code>.
     *       For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html">NitroTPM</a> in the
     *       <i>Amazon EC2 User Guide</i>.</p>
     * @public
     */
    TpmSupport?: TpmSupportValues;
    /**
     * <p>The date and time to deprecate the AMI, in UTC, in the following format:
     *      <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z.
     *       If you specified a value for seconds, Amazon EC2 rounds the seconds to the
     *       nearest minute.</p>
     * @public
     */
    DeprecationTime?: string;
    /**
     * <p>If <code>v2.0</code>, it indicates that IMDSv2 is specified in the AMI. Instances launched
     *       from this AMI will have <code>HttpTokens</code> automatically set to <code>required</code> so
     *       that, by default, the instance requires that IMDSv2 is used when requesting instance metadata.
     *       In addition, <code>HttpPutResponseHopLimit</code> is set to <code>2</code>. For more
     *       information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration">Configure
     *         the AMI</a> in the <i>Amazon EC2 User Guide</i>.</p>
     * @public
     */
    ImdsSupport?: ImdsSupportValues;
    /**
     * <p>The ID of the instance that the AMI was created from if the AMI was created using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateImage.html">CreateImage</a>. This field only appears if the AMI was created using
     *       CreateImage.</p>
     * @public
     */
    SourceInstanceId?: string;
}
/**
 * @public
 */
export interface DescribeImagesResult {
    /**
     * <p>Information about the images.</p>
     * @public
     */
    Images?: Image[];
    /**
     * <p>The token to include in another request to get the next page of items. This value is <code>null</code> when there
     *          are no more items to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface DescribeImportImageTasksRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>Filter tasks using the <code>task-state</code> filter and one of the following values: <code>active</code>,
     *     <code>completed</code>, <code>deleting</code>, or <code>deleted</code>.</p>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The IDs of the import image tasks.</p>
     * @public
     */
    ImportTaskIds?: string[];
    /**
     * <p>The maximum number of results to return in a single call.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>A token that indicates the next page of results.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * <p> The response information for license configurations.</p>
 * @public
 */
export interface ImportImageLicenseConfigurationResponse {
    /**
     * <p>The ARN of a license configuration.</p>
     * @public
     */
    LicenseConfigurationArn?: string;
}
/**
 * <p>Describes the Amazon S3 bucket for the disk image.</p>
 * @public
 */
export interface UserBucketDetails {
    /**
     * <p>The Amazon S3 bucket from which the disk image was created.</p>
     * @public
     */
    S3Bucket?: string;
    /**
     * <p>The file name of the disk image.</p>
     * @public
     */
    S3Key?: string;
}
/**
 * <p>Describes the snapshot created from the imported disk.</p>
 * @public
 */
export interface SnapshotDetail {
    /**
     * <p>A description for the snapshot.</p>
     * @public
     */
    Description?: string;
    /**
     * <p>The block device mapping for the snapshot.</p>
     * @public
     */
    DeviceName?: string;
    /**
     * <p>The size of the disk in the snapshot, in GiB.</p>
     * @public
     */
    DiskImageSize?: number;
    /**
     * <p>The format of the disk image from which the snapshot is created.</p>
     * @public
     */
    Format?: string;
    /**
     * <p>The percentage of progress for the task.</p>
     * @public
     */
    Progress?: string;
    /**
     * <p>The snapshot ID of the disk being imported.</p>
     * @public
     */
    SnapshotId?: string;
    /**
     * <p>A brief status of the snapshot creation.</p>
     * @public
     */
    Status?: string;
    /**
     * <p>A detailed status message for the snapshot creation.</p>
     * @public
     */
    StatusMessage?: string;
    /**
     * <p>The URL used to access the disk image.</p>
     * @public
     */
    Url?: string;
    /**
     * <p>The Amazon S3 bucket for the disk image.</p>
     * @public
     */
    UserBucket?: UserBucketDetails;
}
/**
 * <p>Describes an import image task.</p>
 * @public
 */
export interface ImportImageTask {
    /**
     * <p>The architecture of the virtual machine.</p>
     *          <p>Valid values: <code>i386</code> | <code>x86_64</code> | <code>arm64</code>
     *          </p>
     * @public
     */
    Architecture?: string;
    /**
     * <p>A description of the import task.</p>
     * @public
     */
    Description?: string;
    /**
     * <p>Indicates whether the image is encrypted.</p>
     * @public
     */
    Encrypted?: boolean;
    /**
     * <p>The target hypervisor for the import task.</p>
     *          <p>Valid values: <code>xen</code>
     *          </p>
     * @public
     */
    Hypervisor?: string;
    /**
     * <p>The ID of the Amazon Machine Image (AMI) of the imported virtual machine.</p>
     * @public
     */
    ImageId?: string;
    /**
     * <p>The ID of the import image task.</p>
     * @public
     */
    ImportTaskId?: string;
    /**
     * <p>The identifier for the KMS key that was used to create the encrypted image.</p>
     * @public
     */
    KmsKeyId?: string;
    /**
     * <p>The license type of the virtual machine.</p>
     * @public
     */
    LicenseType?: string;
    /**
     * <p>The description string for the import image task.</p>
     * @public
     */
    Platform?: string;
    /**
     * <p>The percentage of progress of the import image task.</p>
     * @public
     */
    Progress?: string;
    /**
     * <p>Information about the snapshots.</p>
     * @public
     */
    SnapshotDetails?: SnapshotDetail[];
    /**
     * <p>A brief status for the import image task.</p>
     * @public
     */
    Status?: string;
    /**
     * <p>A descriptive status message for the import image task.</p>
     * @public
     */
    StatusMessage?: string;
    /**
     * <p>The tags for the import image task.</p>
     * @public
     */
    Tags?: Tag[];
    /**
     * <p>The ARNs of the license configurations that are associated with the import image task.</p>
     * @public
     */
    LicenseSpecifications?: ImportImageLicenseConfigurationResponse[];
    /**
     * <p>The usage operation value.</p>
     * @public
     */
    UsageOperation?: string;
    /**
     * <p>The boot mode of the virtual machine.</p>
     * @public
     */
    BootMode?: BootModeValues;
}
/**
 * @public
 */
export interface DescribeImportImageTasksResult {
    /**
     * <p>A list of zero or more import image tasks that are currently active or were completed or canceled in the
     *    previous 7 days.</p>
     * @public
     */
    ImportImageTasks?: ImportImageTask[];
    /**
     * <p>The token to use to get the next page of results. This value is <code>null</code> when there are no more results
     *    to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @internal
 */
export declare const DeleteVerifiedAccessTrustProviderResultFilterSensitiveLog: (obj: DeleteVerifiedAccessTrustProviderResult) => any;
/**
 * @internal
 */
export declare const DescribeBundleTasksResultFilterSensitiveLog: (obj: DescribeBundleTasksResult) => any;
/**
 * @internal
 */
export declare const DiskImageDescriptionFilterSensitiveLog: (obj: DiskImageDescription) => any;
/**
 * @internal
 */
export declare const ImportInstanceVolumeDetailItemFilterSensitiveLog: (obj: ImportInstanceVolumeDetailItem) => any;
/**
 * @internal
 */
export declare const ImportInstanceTaskDetailsFilterSensitiveLog: (obj: ImportInstanceTaskDetails) => any;
/**
 * @internal
 */
export declare const ImportVolumeTaskDetailsFilterSensitiveLog: (obj: ImportVolumeTaskDetails) => any;
/**
 * @internal
 */
export declare const ConversionTaskFilterSensitiveLog: (obj: ConversionTask) => any;
/**
 * @internal
 */
export declare const DescribeConversionTasksResultFilterSensitiveLog: (obj: DescribeConversionTasksResult) => any;
/**
 * @internal
 */
export declare const SnapshotDetailFilterSensitiveLog: (obj: SnapshotDetail) => any;
/**
 * @internal
 */
export declare const ImportImageTaskFilterSensitiveLog: (obj: ImportImageTask) => any;
/**
 * @internal
 */
export declare const DescribeImportImageTasksResultFilterSensitiveLog: (obj: DescribeImportImageTasksResult) => any;
