import { _InstanceType, AddressAttribute, AddressAttributeName, ByoipCidr, ClientVpnAuthorizationRuleStatus, IamInstanceProfileAssociation, IamInstanceProfileSpecification, IpPermission, NatGatewayAddress, PortRange, RouteTableAssociationState, TagSpecification, TransitGatewayAttachmentResourceType, TransitGatewayMulticastDomainAssociations, TransitGatewayPeeringAttachment, TransitGatewayVpcAttachment, UnsuccessfulItem } from "./models_0";
import { AmdSevSnpSpecification, BlockDeviceMapping, CreditSpecificationRequest, ElasticGpuSpecification, HostnameType, IcmpTypeCode, InstanceInterruptionBehavior, InstanceIpv6Address, LocalGatewayRoute, ManagedPrefixList, MarketType, Placement, RuleAction, ShutdownBehavior, SpotInstanceType } from "./models_1";
import { SnapshotState, SSEType, TransitGatewayRoute } from "./models_2";
import { ClientVpnConnectionStatus, Filter, InstanceTagNotificationAttribute } from "./models_3";
import { HttpTokensState, InstanceAttributeName, InstanceAutoRecoveryState, InstanceMetadataEndpointState, InstanceMetadataProtocolState, InstanceMetadataTagsState, InstanceNetworkInterfaceSpecification, InstanceState, NetworkInsightsAccessScopeAnalysis, NetworkInsightsAnalysis, RunInstancesMonitoringEnabled, SnapshotAttributeName, SpotFleetRequestConfigData, SpotInstanceRequest, SpotPlacement } from "./models_4";
import { CapacityReservationSpecification, InstanceMonitoring, RegisterInstanceTagAttributeRequest, Status } from "./models_6";
/**
 * @public
 */
export interface RegisterInstanceEventNotificationAttributesRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>Information about the tag keys to register.</p>
     * @public
     */
    InstanceTagAttribute: RegisterInstanceTagAttributeRequest | undefined;
}
/**
 * @public
 */
export interface RegisterInstanceEventNotificationAttributesResult {
    /**
     * <p>The resulting set of tag keys.</p>
     * @public
     */
    InstanceTagAttribute?: InstanceTagNotificationAttribute;
}
/**
 * @public
 */
export interface RegisterTransitGatewayMulticastGroupMembersRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     * @public
     */
    TransitGatewayMulticastDomainId: string | undefined;
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     * @public
     */
    GroupIpAddress?: string;
    /**
     * <p>The group members' network interface IDs to register with the  transit gateway multicast group.</p>
     * @public
     */
    NetworkInterfaceIds: string[] | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Describes the registered  transit gateway multicast group members.</p>
 * @public
 */
export interface TransitGatewayMulticastRegisteredGroupMembers {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     * @public
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The ID of the registered network interfaces.</p>
     * @public
     */
    RegisteredNetworkInterfaceIds?: string[];
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     * @public
     */
    GroupIpAddress?: string;
}
/**
 * @public
 */
export interface RegisterTransitGatewayMulticastGroupMembersResult {
    /**
     * <p>Information about the registered  transit gateway multicast group members.</p>
     * @public
     */
    RegisteredMulticastGroupMembers?: TransitGatewayMulticastRegisteredGroupMembers;
}
/**
 * @public
 */
export interface RegisterTransitGatewayMulticastGroupSourcesRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     * @public
     */
    TransitGatewayMulticastDomainId: string | undefined;
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     * @public
     */
    GroupIpAddress?: string;
    /**
     * <p>The group sources' network interface IDs to register with the  transit gateway multicast group.</p>
     * @public
     */
    NetworkInterfaceIds: string[] | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Describes the members registered with the  transit gateway multicast group.</p>
 * @public
 */
export interface TransitGatewayMulticastRegisteredGroupSources {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     * @public
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The IDs of the network interfaces members registered with the  transit gateway multicast group.</p>
     * @public
     */
    RegisteredNetworkInterfaceIds?: string[];
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     * @public
     */
    GroupIpAddress?: string;
}
/**
 * @public
 */
export interface RegisterTransitGatewayMulticastGroupSourcesResult {
    /**
     * <p>Information about the  transit gateway multicast group sources.</p>
     * @public
     */
    RegisteredMulticastGroupSources?: TransitGatewayMulticastRegisteredGroupSources;
}
/**
 * @public
 */
export interface RejectTransitGatewayMulticastDomainAssociationsRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     * @public
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The ID of the transit gateway attachment.</p>
     * @public
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>The IDs of the subnets to associate with the transit gateway multicast domain.</p>
     * @public
     */
    SubnetIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface RejectTransitGatewayMulticastDomainAssociationsResult {
    /**
     * <p>Information about the multicast domain associations.</p>
     * @public
     */
    Associations?: TransitGatewayMulticastDomainAssociations;
}
/**
 * @public
 */
export interface RejectTransitGatewayPeeringAttachmentRequest {
    /**
     * <p>The ID of the transit gateway peering attachment.</p>
     * @public
     */
    TransitGatewayAttachmentId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface RejectTransitGatewayPeeringAttachmentResult {
    /**
     * <p>The transit gateway peering attachment.</p>
     * @public
     */
    TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
/**
 * @public
 */
export interface RejectTransitGatewayVpcAttachmentRequest {
    /**
     * <p>The ID of the attachment.</p>
     * @public
     */
    TransitGatewayAttachmentId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface RejectTransitGatewayVpcAttachmentResult {
    /**
     * <p>Information about the attachment.</p>
     * @public
     */
    TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
/**
 * @public
 */
export interface RejectVpcEndpointConnectionsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the service.</p>
     * @public
     */
    ServiceId: string | undefined;
    /**
     * <p>The IDs of the VPC endpoints.</p>
     * @public
     */
    VpcEndpointIds: string[] | undefined;
}
/**
 * @public
 */
export interface RejectVpcEndpointConnectionsResult {
    /**
     * <p>Information about the endpoints that were not rejected, if applicable.</p>
     * @public
     */
    Unsuccessful?: UnsuccessfulItem[];
}
/**
 * @public
 */
export interface RejectVpcPeeringConnectionRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the VPC peering connection.</p>
     * @public
     */
    VpcPeeringConnectionId: string | undefined;
}
/**
 * @public
 */
export interface RejectVpcPeeringConnectionResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     * @public
     */
    Return?: boolean;
}
/**
 * @public
 */
export interface ReleaseAddressRequest {
    /**
     * <p>The allocation ID. This parameter is required.</p>
     * @public
     */
    AllocationId?: string;
    /**
     * <p>Deprecated.</p>
     * @public
     */
    PublicIp?: string;
    /**
     * <p>The set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises
     *       IP addresses.</p>
     *          <p>If you provide an incorrect network border group, you receive an <code>InvalidAddress.NotFound</code> error.</p>
     * @public
     */
    NetworkBorderGroup?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface ReleaseHostsRequest {
    /**
     * <p>The IDs of the Dedicated Hosts to release.</p>
     * @public
     */
    HostIds: string[] | undefined;
}
/**
 * @public
 */
export interface ReleaseHostsResult {
    /**
     * <p>The IDs of the Dedicated Hosts that were successfully released.</p>
     * @public
     */
    Successful?: string[];
    /**
     * <p>The IDs of the Dedicated Hosts that could not be released, including an error
     *             message.</p>
     * @public
     */
    Unsuccessful?: UnsuccessfulItem[];
}
/**
 * @public
 */
export interface ReleaseIpamPoolAllocationRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the IPAM pool which contains the allocation you want to release.</p>
     * @public
     */
    IpamPoolId: string | undefined;
    /**
     * <p>The CIDR of the allocation you want to release.</p>
     * @public
     */
    Cidr: string | undefined;
    /**
     * <p>The ID of the allocation.</p>
     * @public
     */
    IpamPoolAllocationId: string | undefined;
}
/**
 * @public
 */
export interface ReleaseIpamPoolAllocationResult {
    /**
     * <p>Indicates if the release was successful.</p>
     * @public
     */
    Success?: boolean;
}
/**
 * @public
 */
export interface ReplaceIamInstanceProfileAssociationRequest {
    /**
     * <p>The IAM instance profile.</p>
     * @public
     */
    IamInstanceProfile: IamInstanceProfileSpecification | undefined;
    /**
     * <p>The ID of the existing IAM instance profile association.</p>
     * @public
     */
    AssociationId: string | undefined;
}
/**
 * @public
 */
export interface ReplaceIamInstanceProfileAssociationResult {
    /**
     * <p>Information about the IAM instance profile association.</p>
     * @public
     */
    IamInstanceProfileAssociation?: IamInstanceProfileAssociation;
}
/**
 * @public
 */
export interface ReplaceNetworkAclAssociationRequest {
    /**
     * <p>The ID of the current association between the original network ACL and the subnet.</p>
     * @public
     */
    AssociationId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the new network ACL to associate with the subnet.</p>
     * @public
     */
    NetworkAclId: string | undefined;
}
/**
 * @public
 */
export interface ReplaceNetworkAclAssociationResult {
    /**
     * <p>The ID of the new association.</p>
     * @public
     */
    NewAssociationId?: string;
}
/**
 * @public
 */
export interface ReplaceNetworkAclEntryRequest {
    /**
     * <p>The IPv4 network range to allow or deny, in CIDR notation (for example
     *                 <code>172.16.0.0/24</code>).</p>
     * @public
     */
    CidrBlock?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>Indicates whether to replace the egress rule.</p>
     *          <p>Default: If no value is specified, we replace the ingress rule.</p>
     * @public
     */
    Egress: boolean | undefined;
    /**
     * <p>ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol
     * 		        1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.</p>
     * @public
     */
    IcmpTypeCode?: IcmpTypeCode;
    /**
     * <p>The IPv6 network range to allow or deny, in CIDR notation (for example
     *                 <code>2001:bd8:1234:1a00::/64</code>).</p>
     * @public
     */
    Ipv6CidrBlock?: string;
    /**
     * <p>The ID of the ACL.</p>
     * @public
     */
    NetworkAclId: string | undefined;
    /**
     * <p>TCP or UDP protocols: The range of ports the rule applies to.
     * 		        Required if specifying protocol 6 (TCP) or 17 (UDP).</p>
     * @public
     */
    PortRange?: PortRange;
    /**
     * <p>The protocol number. A value of "-1" means all protocols. If you specify "-1" or a
     *            protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is
     *            allowed, regardless of any ports or ICMP types or codes that you specify. If you specify
     *            protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and
     *            codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6)
     *            and specify an IPv6 CIDR block, you must specify an ICMP type and code.</p>
     * @public
     */
    Protocol: string | undefined;
    /**
     * <p>Indicates whether to allow or deny the traffic that matches the rule.</p>
     * @public
     */
    RuleAction: RuleAction | undefined;
    /**
     * <p>The rule number of the entry to replace.</p>
     * @public
     */
    RuleNumber: number | undefined;
}
/**
 * @public
 */
export interface ReplaceRouteRequest {
    /**
     * <p>The IPv4 CIDR address block used for the destination match. The value that you
     * 			provide must match the CIDR of an existing route in the table.</p>
     * @public
     */
    DestinationCidrBlock?: string;
    /**
     * <p>The IPv6 CIDR address block used for the destination match. The value that you
     * 			provide must match the CIDR of an existing route in the table.</p>
     * @public
     */
    DestinationIpv6CidrBlock?: string;
    /**
     * <p>The ID of the prefix list for the route.</p>
     * @public
     */
    DestinationPrefixListId?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.</p>
     * @public
     */
    VpcEndpointId?: string;
    /**
     * <p>[IPv6 traffic only] The ID of an egress-only internet gateway.</p>
     * @public
     */
    EgressOnlyInternetGatewayId?: string;
    /**
     * <p>The ID of an internet gateway or virtual private gateway.</p>
     * @public
     */
    GatewayId?: string;
    /**
     * <p>The ID of a NAT instance in your VPC.</p>
     * @public
     */
    InstanceId?: string;
    /**
     * <p>Specifies whether to reset the local route to its default target (<code>local</code>).</p>
     * @public
     */
    LocalTarget?: boolean;
    /**
     * <p>[IPv4 traffic only] The ID of a NAT gateway.</p>
     * @public
     */
    NatGatewayId?: string;
    /**
     * <p>The ID of a transit gateway.</p>
     * @public
     */
    TransitGatewayId?: string;
    /**
     * <p>The ID of the local gateway.</p>
     * @public
     */
    LocalGatewayId?: string;
    /**
     * <p>[IPv4 traffic only] The ID of a carrier gateway.</p>
     * @public
     */
    CarrierGatewayId?: string;
    /**
     * <p>The ID of a network interface.</p>
     * @public
     */
    NetworkInterfaceId?: string;
    /**
     * <p>The ID of the route table.</p>
     * @public
     */
    RouteTableId: string | undefined;
    /**
     * <p>The ID of a VPC peering connection.</p>
     * @public
     */
    VpcPeeringConnectionId?: string;
    /**
     * <p>The Amazon Resource Name (ARN) of the core network.</p>
     * @public
     */
    CoreNetworkArn?: string;
}
/**
 * @public
 */
export interface ReplaceRouteTableAssociationRequest {
    /**
     * <p>The association ID.</p>
     * @public
     */
    AssociationId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the new route table to associate with the subnet.</p>
     * @public
     */
    RouteTableId: string | undefined;
}
/**
 * @public
 */
export interface ReplaceRouteTableAssociationResult {
    /**
     * <p>The ID of the new association.</p>
     * @public
     */
    NewAssociationId?: string;
    /**
     * <p>The state of the association.</p>
     * @public
     */
    AssociationState?: RouteTableAssociationState;
}
/**
 * @public
 */
export interface ReplaceTransitGatewayRouteRequest {
    /**
     * <p>The CIDR range used for the destination match. Routing decisions are based on the most specific match.</p>
     * @public
     */
    DestinationCidrBlock: string | undefined;
    /**
     * <p>The ID of the route table.</p>
     * @public
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>The ID of the attachment.</p>
     * @public
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>Indicates whether traffic matching this route is to be dropped.</p>
     * @public
     */
    Blackhole?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface ReplaceTransitGatewayRouteResult {
    /**
     * <p>Information about the modified route.</p>
     * @public
     */
    Route?: TransitGatewayRoute;
}
/**
 * @public
 */
export interface ReplaceVpnTunnelRequest {
    /**
     * <p>The ID of the Site-to-Site VPN connection. </p>
     * @public
     */
    VpnConnectionId: string | undefined;
    /**
     * <p>The external IP address of the VPN tunnel.</p>
     * @public
     */
    VpnTunnelOutsideIpAddress: string | undefined;
    /**
     * <p>Trigger pending tunnel endpoint maintenance.</p>
     * @public
     */
    ApplyPendingMaintenance?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface ReplaceVpnTunnelResult {
    /**
     * <p>Confirmation of replace tunnel operation.</p>
     * @public
     */
    Return?: boolean;
}
/**
 * @public
 * @enum
 */
export declare const ReportInstanceReasonCodes: {
    readonly instance_stuck_in_state: "instance-stuck-in-state";
    readonly not_accepting_credentials: "not-accepting-credentials";
    readonly other: "other";
    readonly password_not_available: "password-not-available";
    readonly performance_ebs_volume: "performance-ebs-volume";
    readonly performance_instance_store: "performance-instance-store";
    readonly performance_network: "performance-network";
    readonly performance_other: "performance-other";
    readonly unresponsive: "unresponsive";
};
/**
 * @public
 */
export type ReportInstanceReasonCodes = (typeof ReportInstanceReasonCodes)[keyof typeof ReportInstanceReasonCodes];
/**
 * @public
 * @enum
 */
export declare const ReportStatusType: {
    readonly impaired: "impaired";
    readonly ok: "ok";
};
/**
 * @public
 */
export type ReportStatusType = (typeof ReportStatusType)[keyof typeof ReportStatusType];
/**
 * @public
 */
export interface ReportInstanceStatusRequest {
    /**
     * <p>Descriptive text about the health state of your instance.</p>
     * @public
     */
    Description?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The time at which the reported instance health state ended.</p>
     * @public
     */
    EndTime?: Date;
    /**
     * <p>The instances.</p>
     * @public
     */
    Instances: string[] | undefined;
    /**
     * <p>The reason codes that describe the health state of your instance.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>instance-stuck-in-state</code>: My instance is stuck in a state.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>unresponsive</code>: My instance is unresponsive.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>not-accepting-credentials</code>: My instance is not accepting my
     *                     credentials.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>password-not-available</code>: A password is not available for my
     *                     instance.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>performance-network</code>: My instance is experiencing performance
     *                     problems that I believe are network related.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>performance-instance-store</code>: My instance is experiencing performance
     *                     problems that I believe are related to the instance stores.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>performance-ebs-volume</code>: My instance is experiencing performance
     *                     problems that I believe are related to an EBS volume.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>performance-other</code>: My instance is experiencing performance
     *                     problems.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>other</code>: [explain using the description parameter]</p>
     *             </li>
     *          </ul>
     * @public
     */
    ReasonCodes: ReportInstanceReasonCodes[] | undefined;
    /**
     * <p>The time at which the reported instance health state began.</p>
     * @public
     */
    StartTime?: Date;
    /**
     * <p>The status of all instances listed.</p>
     * @public
     */
    Status: ReportStatusType | undefined;
}
/**
 * <p>Contains the parameters for RequestSpotFleet.</p>
 * @public
 */
export interface RequestSpotFleetRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The configuration for the Spot Fleet request.</p>
     * @public
     */
    SpotFleetRequestConfig: SpotFleetRequestConfigData | undefined;
}
/**
 * <p>Contains the output of RequestSpotFleet.</p>
 * @public
 */
export interface RequestSpotFleetResponse {
    /**
     * <p>The ID of the Spot Fleet request.</p>
     * @public
     */
    SpotFleetRequestId?: string;
}
/**
 * <p>Describes the launch specification for an instance.</p>
 * @public
 */
export interface RequestSpotLaunchSpecification {
    /**
     * <p>The IDs of the security groups.</p>
     * @public
     */
    SecurityGroupIds?: string[];
    /**
     * <p>Not supported.</p>
     * @public
     */
    SecurityGroups?: string[];
    /**
     * <p>Deprecated.</p>
     * @public
     */
    AddressingType?: string;
    /**
     * <p>The block device mapping entries. You can't specify both a snapshot ID and an encryption value.
     *            This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume,
     *            it is not blank and its encryption status is used for the volume encryption status.</p>
     * @public
     */
    BlockDeviceMappings?: BlockDeviceMapping[];
    /**
     * <p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>
     *          <p>Default: <code>false</code>
     *          </p>
     * @public
     */
    EbsOptimized?: boolean;
    /**
     * <p>The IAM instance profile.</p>
     * @public
     */
    IamInstanceProfile?: IamInstanceProfileSpecification;
    /**
     * <p>The ID of the AMI.</p>
     * @public
     */
    ImageId?: string;
    /**
     * <p>The instance type. Only one instance type can be specified.</p>
     * @public
     */
    InstanceType?: _InstanceType;
    /**
     * <p>The ID of the kernel.</p>
     * @public
     */
    KernelId?: string;
    /**
     * <p>The name of the key pair.</p>
     * @public
     */
    KeyName?: string;
    /**
     * <p>Indicates whether basic or detailed monitoring is enabled for the instance.</p>
     *          <p>Default: Disabled</p>
     * @public
     */
    Monitoring?: RunInstancesMonitoringEnabled;
    /**
     * <p>The network interfaces. If you specify a network interface, you must specify
     *            subnet IDs and security group IDs using the network interface.</p>
     * @public
     */
    NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
    /**
     * <p>The placement information for the instance.</p>
     * @public
     */
    Placement?: SpotPlacement;
    /**
     * <p>The ID of the RAM disk.</p>
     * @public
     */
    RamdiskId?: string;
    /**
     * <p>The ID of the subnet in which to launch the instance.</p>
     * @public
     */
    SubnetId?: string;
    /**
     * <p>The base64-encoded user data that instances use when starting up. User data is limited to 16 KB.</p>
     * @public
     */
    UserData?: string;
}
/**
 * <p>Contains the parameters for RequestSpotInstances.</p>
 * @public
 */
export interface RequestSpotInstancesRequest {
    /**
     * <p>The user-specified name for a logical grouping of requests.</p>
     *          <p>When you specify an Availability Zone group in a Spot Instance request, all Spot
     *             Instances in the request are launched in the same Availability Zone. Instance proximity
     *             is maintained with this parameter, but the choice of Availability Zone is not. The group
     *             applies only to requests for Spot Instances of the same instance type. Any additional
     *             Spot Instance requests that are specified with the same Availability Zone group name are
     *             launched in that same Availability Zone, as long as at least one instance from the group
     *             is still active.</p>
     *          <p>If there is no active instance running in the Availability Zone group that you specify
     *             for a new Spot Instance request (all instances are terminated, the request is expired,
     *             or the maximum price you specified falls below current Spot price), then Amazon EC2 launches
     *             the instance in any Availability Zone where the constraint can be met. Consequently, the
     *             subsequent set of Spot Instances could be placed in a different zone from the original
     *             request, even if you specified the same Availability Zone group.</p>
     *          <p>Default: Instances are launched in any available Availability Zone.</p>
     * @public
     */
    AvailabilityZoneGroup?: string;
    /**
     * <p>Deprecated.</p>
     * @public
     */
    BlockDurationMinutes?: number;
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     *             request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     *                 Idempotency</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
     * @public
     */
    ClientToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The maximum number of Spot Instances to launch.</p>
     *          <p>Default: 1</p>
     * @public
     */
    InstanceCount?: number;
    /**
     * <p>The instance launch group. Launch groups are Spot Instances that launch together and
     *             terminate together.</p>
     *          <p>Default: Instances are launched and terminated individually</p>
     * @public
     */
    LaunchGroup?: string;
    /**
     * <p>The launch specification.</p>
     * @public
     */
    LaunchSpecification?: RequestSpotLaunchSpecification;
    /**
     * <p>The maximum price per unit hour that you are willing to pay for a Spot Instance. We do not recommend
     *             using this parameter because it can lead to increased interruptions. If you do not specify this parameter, you will pay the current Spot price.</p>
     *          <important>
     *             <p>If you specify a maximum price, your instances will be interrupted more frequently than if you do not specify this parameter.</p>
     *          </important>
     * @public
     */
    SpotPrice?: string;
    /**
     * <p>The Spot Instance request type.</p>
     *          <p>Default: <code>one-time</code>
     *          </p>
     * @public
     */
    Type?: SpotInstanceType;
    /**
     * <p>The start date of the request. If this is a one-time request, the request becomes
     *             active at this date and time and remains active until all instances launch, the request
     *             expires, or the request is canceled. If the request is persistent, the request becomes
     *             active at this date and time and remains active until it expires or is canceled.</p>
     *          <p>The specified start date and time cannot be equal to the current date and time. You
     *             must specify a start date and time that occurs after the current date and time.</p>
     * @public
     */
    ValidFrom?: Date;
    /**
     * <p>The end date of the request, in UTC format
     *                 (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
     *          <ul>
     *             <li>
     *                <p>For a persistent request, the request remains active until the
     *                         <code>ValidUntil</code> date and time is reached. Otherwise, the request
     *                     remains active until you cancel it. </p>
     *             </li>
     *             <li>
     *                <p>For a one-time request, the request remains active until all instances launch,
     *                     the request is canceled, or the <code>ValidUntil</code> date and time is
     *                     reached. By default, the request is valid for 7 days from the date the request
     *                     was created.</p>
     *             </li>
     *          </ul>
     * @public
     */
    ValidUntil?: Date;
    /**
     * <p>The key-value pair for tagging the Spot Instance request on creation. The value for
     *             <code>ResourceType</code> must be <code>spot-instances-request</code>, otherwise the
     *             Spot Instance request fails. To tag the Spot Instance request after it has been created,
     *             see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>. </p>
     * @public
     */
    TagSpecifications?: TagSpecification[];
    /**
     * <p>The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.</p>
     * @public
     */
    InstanceInterruptionBehavior?: InstanceInterruptionBehavior;
}
/**
 * <p>Contains the output of RequestSpotInstances.</p>
 * @public
 */
export interface RequestSpotInstancesResult {
    /**
     * <p>The Spot Instance requests.</p>
     * @public
     */
    SpotInstanceRequests?: SpotInstanceRequest[];
}
/**
 * @public
 */
export interface ResetAddressAttributeRequest {
    /**
     * <p>[EC2-VPC] The allocation ID.</p>
     * @public
     */
    AllocationId: string | undefined;
    /**
     * <p>The attribute of the IP address.</p>
     * @public
     */
    Attribute: AddressAttributeName | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface ResetAddressAttributeResult {
    /**
     * <p>Information about the IP address.</p>
     * @public
     */
    Address?: AddressAttribute;
}
/**
 * @public
 */
export interface ResetEbsDefaultKmsKeyIdRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface ResetEbsDefaultKmsKeyIdResult {
    /**
     * <p>The Amazon Resource Name (ARN) of the default KMS key for EBS encryption by default.</p>
     * @public
     */
    KmsKeyId?: string;
}
/**
 * @public
 * @enum
 */
export declare const ResetFpgaImageAttributeName: {
    readonly loadPermission: "loadPermission";
};
/**
 * @public
 */
export type ResetFpgaImageAttributeName = (typeof ResetFpgaImageAttributeName)[keyof typeof ResetFpgaImageAttributeName];
/**
 * @public
 */
export interface ResetFpgaImageAttributeRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the AFI.</p>
     * @public
     */
    FpgaImageId: string | undefined;
    /**
     * <p>The attribute.</p>
     * @public
     */
    Attribute?: ResetFpgaImageAttributeName;
}
/**
 * @public
 */
export interface ResetFpgaImageAttributeResult {
    /**
     * <p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>
     * @public
     */
    Return?: boolean;
}
/**
 * @public
 * @enum
 */
export declare const ResetImageAttributeName: {
    readonly launchPermission: "launchPermission";
};
/**
 * @public
 */
export type ResetImageAttributeName = (typeof ResetImageAttributeName)[keyof typeof ResetImageAttributeName];
/**
 * <p>Contains the parameters for ResetImageAttribute.</p>
 * @public
 */
export interface ResetImageAttributeRequest {
    /**
     * <p>The attribute to reset (currently you can only reset the launch permission attribute).</p>
     * @public
     */
    Attribute: ResetImageAttributeName | undefined;
    /**
     * <p>The ID of the AMI.</p>
     * @public
     */
    ImageId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     * 			and provides an error response. If you have the required permissions, the error response is
     * 			<code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface ResetInstanceAttributeRequest {
    /**
     * <p>The attribute to reset.</p>
     *          <important>
     *             <p>You can only reset the following attributes: <code>kernel</code> |
     *                     <code>ramdisk</code> | <code>sourceDestCheck</code>.</p>
     *          </important>
     * @public
     */
    Attribute: InstanceAttributeName | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the instance.</p>
     * @public
     */
    InstanceId: string | undefined;
}
/**
 * <p>Contains the parameters for ResetNetworkInterfaceAttribute.</p>
 * @public
 */
export interface ResetNetworkInterfaceAttributeRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *             and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *             Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the network interface.</p>
     * @public
     */
    NetworkInterfaceId: string | undefined;
    /**
     * <p>The source/destination checking attribute. Resets the value to <code>true</code>.</p>
     * @public
     */
    SourceDestCheck?: string;
}
/**
 * @public
 */
export interface ResetSnapshotAttributeRequest {
    /**
     * <p>The attribute to reset. Currently, only the attribute for permission to create volumes can
     *       be reset.</p>
     * @public
     */
    Attribute: SnapshotAttributeName | undefined;
    /**
     * <p>The ID of the snapshot.</p>
     * @public
     */
    SnapshotId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface RestoreAddressToClassicRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The Elastic IP address.</p>
     * @public
     */
    PublicIp: string | undefined;
}
/**
 * @public
 */
export interface RestoreAddressToClassicResult {
    /**
     * <p>The Elastic IP address.</p>
     * @public
     */
    PublicIp?: string;
    /**
     * <p>The move status for the IP address.</p>
     * @public
     */
    Status?: Status;
}
/**
 * @public
 */
export interface RestoreImageFromRecycleBinRequest {
    /**
     * <p>The ID of the AMI to restore.</p>
     * @public
     */
    ImageId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     * 			and provides an error response. If you have the required permissions, the error response is
     * 			<code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface RestoreImageFromRecycleBinResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     * @public
     */
    Return?: boolean;
}
/**
 * @public
 */
export interface RestoreManagedPrefixListVersionRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the prefix list.</p>
     * @public
     */
    PrefixListId: string | undefined;
    /**
     * <p>The version to restore.</p>
     * @public
     */
    PreviousVersion: number | undefined;
    /**
     * <p>The current version number for the prefix list.</p>
     * @public
     */
    CurrentVersion: number | undefined;
}
/**
 * @public
 */
export interface RestoreManagedPrefixListVersionResult {
    /**
     * <p>Information about the prefix list.</p>
     * @public
     */
    PrefixList?: ManagedPrefixList;
}
/**
 * @public
 */
export interface RestoreSnapshotFromRecycleBinRequest {
    /**
     * <p>The ID of the snapshot to restore.</p>
     * @public
     */
    SnapshotId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface RestoreSnapshotFromRecycleBinResult {
    /**
     * <p>The ID of the snapshot.</p>
     * @public
     */
    SnapshotId?: string;
    /**
     * <p>The ARN of the Outpost on which the snapshot is stored. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html">Amazon EBS local snapshots on Outposts</a> in the
     *       <i>Amazon EBS User Guide</i>.</p>
     * @public
     */
    OutpostArn?: string;
    /**
     * <p>The description for the snapshot.</p>
     * @public
     */
    Description?: string;
    /**
     * <p>Indicates whether the snapshot is encrypted.</p>
     * @public
     */
    Encrypted?: boolean;
    /**
     * <p>The ID of the Amazon Web Services account that owns the EBS snapshot.</p>
     * @public
     */
    OwnerId?: string;
    /**
     * <p>The progress of the snapshot, as a percentage.</p>
     * @public
     */
    Progress?: string;
    /**
     * <p>The time stamp when the snapshot was initiated.</p>
     * @public
     */
    StartTime?: Date;
    /**
     * <p>The state of the snapshot.</p>
     * @public
     */
    State?: SnapshotState;
    /**
     * <p>The ID of the volume that was used to create the snapshot.</p>
     * @public
     */
    VolumeId?: string;
    /**
     * <p>The size of the volume, in GiB.</p>
     * @public
     */
    VolumeSize?: number;
    /**
     * <p>Reserved for future use.</p>
     * @public
     */
    SseType?: SSEType;
}
/**
 * @public
 */
export interface RestoreSnapshotTierRequest {
    /**
     * <p>The ID of the snapshot to restore.</p>
     * @public
     */
    SnapshotId: string | undefined;
    /**
     * <p>Specifies the number of days for which to temporarily restore an archived snapshot.
     *       Required for temporary restores only. The snapshot will be automatically re-archived
     *       after this period.</p>
     *          <p>To temporarily restore an archived snapshot, specify the number of days and omit
     *       the <b>PermanentRestore</b> parameter or set it to
     *       <code>false</code>.</p>
     * @public
     */
    TemporaryRestoreDays?: number;
    /**
     * <p>Indicates whether to permanently restore an archived snapshot. To permanently restore
     *       an archived snapshot, specify <code>true</code> and omit the
     *       <b>RestoreSnapshotTierRequest$TemporaryRestoreDays</b> parameter.</p>
     * @public
     */
    PermanentRestore?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface RestoreSnapshotTierResult {
    /**
     * <p>The ID of the snapshot.</p>
     * @public
     */
    SnapshotId?: string;
    /**
     * <p>The date and time when the snapshot restore process started.</p>
     * @public
     */
    RestoreStartTime?: Date;
    /**
     * <p>For temporary restores only. The number of days for which the archived snapshot
     *       is temporarily restored.</p>
     * @public
     */
    RestoreDuration?: number;
    /**
     * <p>Indicates whether the snapshot is permanently restored. <code>true</code> indicates a permanent
     *       restore. <code>false</code> indicates a temporary restore.</p>
     * @public
     */
    IsPermanentRestore?: boolean;
}
/**
 * @public
 */
export interface RevokeClientVpnIngressRequest {
    /**
     * <p>The ID of the Client VPN endpoint with which the authorization rule is associated.</p>
     * @public
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>The IPv4 address range, in CIDR notation, of the network for which access is being removed.</p>
     * @public
     */
    TargetNetworkCidr: string | undefined;
    /**
     * <p>The ID of the Active Directory group for which to revoke access. </p>
     * @public
     */
    AccessGroupId?: string;
    /**
     * <p>Indicates whether access should be revoked for all clients.</p>
     * @public
     */
    RevokeAllGroups?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface RevokeClientVpnIngressResult {
    /**
     * <p>The current state of the authorization rule.</p>
     * @public
     */
    Status?: ClientVpnAuthorizationRuleStatus;
}
/**
 * @public
 */
export interface RevokeSecurityGroupEgressRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the security group.</p>
     * @public
     */
    GroupId: string | undefined;
    /**
     * <p>The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the same set of permissions.</p>
     * @public
     */
    IpPermissions?: IpPermission[];
    /**
     * <p>The IDs of the security group rules.</p>
     * @public
     */
    SecurityGroupRuleIds?: string[];
    /**
     * <p>Not supported. Use a set of IP permissions to specify the CIDR.</p>
     * @public
     */
    CidrIp?: string;
    /**
     * <p>Not supported. Use a set of IP permissions to specify the port.</p>
     * @public
     */
    FromPort?: number;
    /**
     * <p>Not supported. Use a set of IP permissions to specify the protocol name or
     *             number.</p>
     * @public
     */
    IpProtocol?: string;
    /**
     * <p>Not supported. Use a set of IP permissions to specify the port.</p>
     * @public
     */
    ToPort?: number;
    /**
     * <p>Not supported. Use a set of IP permissions to specify a
     *            destination security group.</p>
     * @public
     */
    SourceSecurityGroupName?: string;
    /**
     * <p>Not supported. Use a set of IP permissions to specify a destination security
     *             group.</p>
     * @public
     */
    SourceSecurityGroupOwnerId?: string;
}
/**
 * @public
 */
export interface RevokeSecurityGroupEgressResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>
     * @public
     */
    Return?: boolean;
    /**
     * <p>The outbound rules that were unknown to the service. In some cases,
     *                 <code>unknownIpPermissionSet</code> might be in a different format from the request
     *             parameter. </p>
     * @public
     */
    UnknownIpPermissions?: IpPermission[];
}
/**
 * @public
 */
export interface RevokeSecurityGroupIngressRequest {
    /**
     * <p>The CIDR IP address range. You can't specify this parameter when specifying a source security group.</p>
     * @public
     */
    CidrIp?: string;
    /**
     * <p>If the protocol is TCP or UDP, this is the start of the port range.
     *            If the protocol is ICMP, this is the ICMP type or -1 (all ICMP types).</p>
     * @public
     */
    FromPort?: number;
    /**
     * <p>The ID of the security group.</p>
     * @public
     */
    GroupId?: string;
    /**
     * <p>[Default VPC] The name of the security group. You must specify either the
     *             security group ID or the security group name in the request. For security groups in a
     *             nondefault VPC, you must specify the security group ID.</p>
     * @public
     */
    GroupName?: string;
    /**
     * <p>The sets of IP permissions. You can't specify a source security group and a CIDR IP address range in the same set of permissions.</p>
     * @public
     */
    IpPermissions?: IpPermission[];
    /**
     * <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number
     *         (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
     *         Use <code>-1</code> to specify all.</p>
     * @public
     */
    IpProtocol?: string;
    /**
     * <p>[Default VPC] The name of the source security group. You can't specify this parameter
     *          in combination with the following parameters: the CIDR IP address range, the start of the port range,
     *          the IP protocol, and the end of the port range. The source security group must be in the same VPC.
     *          To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead.</p>
     * @public
     */
    SourceSecurityGroupName?: string;
    /**
     * <p>Not supported.</p>
     * @public
     */
    SourceSecurityGroupOwnerId?: string;
    /**
     * <p>If the protocol is TCP or UDP, this is the end of the port range.
     *          If the protocol is ICMP, this is the ICMP code or -1 (all ICMP codes).</p>
     * @public
     */
    ToPort?: number;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of the security group rules.</p>
     * @public
     */
    SecurityGroupRuleIds?: string[];
}
/**
 * @public
 */
export interface RevokeSecurityGroupIngressResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>
     * @public
     */
    Return?: boolean;
    /**
     * <p>The inbound rules that were unknown to the service. In some cases,
     *                 <code>unknownIpPermissionSet</code> might be in a different format from the request
     *             parameter. </p>
     * @public
     */
    UnknownIpPermissions?: IpPermission[];
}
/**
 * <p>The CPU options for the instance. Both the core count and threads per core must be
 *             specified in the request.</p>
 * @public
 */
export interface CpuOptionsRequest {
    /**
     * <p>The number of CPU cores for the instance.</p>
     * @public
     */
    CoreCount?: number;
    /**
     * <p>The number of threads per CPU core. To disable multithreading for the instance,
     *             specify a value of <code>1</code>. Otherwise, specify the default value of
     *                 <code>2</code>.</p>
     * @public
     */
    ThreadsPerCore?: number;
    /**
     * <p>Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported
     *             with M6a, R6a, and C6a instance types only. For more information, see
     *             <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sev-snp.html">AMD SEV-SNP</a>.</p>
     * @public
     */
    AmdSevSnp?: AmdSevSnpSpecification;
}
/**
 * <p>
 *            Describes an elastic inference accelerator.
 *         </p>
 * @public
 */
export interface ElasticInferenceAccelerator {
    /**
     * <p>
     *         	The type of elastic inference accelerator. The possible values are <code>eia1.medium</code>, <code>eia1.large</code>, <code>eia1.xlarge</code>, <code>eia2.medium</code>, <code>eia2.large</code>, and <code>eia2.xlarge</code>.
     *         </p>
     * @public
     */
    Type: string | undefined;
    /**
     * <p>
     *             The number of elastic inference accelerators to attach to the instance.
     *         </p>
     *          <p>Default: 1</p>
     * @public
     */
    Count?: number;
}
/**
 * <p>Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For
 *             more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html"> What is Amazon Web Services Nitro
 *                 Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User
 *                 Guide</i>.</p>
 * @public
 */
export interface EnclaveOptionsRequest {
    /**
     * <p>To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to
     *                 <code>true</code>.</p>
     * @public
     */
    Enabled?: boolean;
}
/**
 * <p>Indicates whether your instance is configured for hibernation. This parameter is valid
 *             only if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html">hibernation
 *                 prerequisites</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the
 *                 <i>Amazon EC2 User Guide</i>.</p>
 * @public
 */
export interface HibernationOptionsRequest {
    /**
     * <p>Set to <code>true</code> to enable your instance for hibernation.</p>
     *          <p>For Spot Instances, if you set <code>Configured</code> to <code>true</code>, either
     *             omit the <code>InstanceInterruptionBehavior</code> parameter (for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotMarketOptions.html">
     *                <code>SpotMarketOptions</code>
     *             </a>), or set it to
     *                 <code>hibernate</code>. When <code>Configured</code> is true:</p>
     *          <ul>
     *             <li>
     *                <p>If you omit <code>InstanceInterruptionBehavior</code>, it defaults to
     *                         <code>hibernate</code>.</p>
     *             </li>
     *             <li>
     *                <p>If you set <code>InstanceInterruptionBehavior</code> to a value other than
     *                         <code>hibernate</code>, you'll get an error.</p>
     *             </li>
     *          </ul>
     *          <p>Default: <code>false</code>
     *          </p>
     * @public
     */
    Configured?: boolean;
}
/**
 * <p>The options for Spot Instances.</p>
 * @public
 */
export interface SpotMarketOptions {
    /**
     * <p>The maximum hourly price that you're willing to pay for a Spot Instance. We do not
     *             recommend using this parameter because it can lead to increased interruptions. If you do
     *             not specify this parameter, you will pay the current Spot price.</p>
     *          <important>
     *             <p>If you specify a maximum price, your Spot Instances will be interrupted more
     *                 frequently than if you do not specify this parameter.</p>
     *          </important>
     * @public
     */
    MaxPrice?: string;
    /**
     * <p>The Spot Instance request type. For <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances</a>, persistent
     *             Spot Instance requests are only supported when the instance interruption behavior is
     *             either <code>hibernate</code> or <code>stop</code>.</p>
     * @public
     */
    SpotInstanceType?: SpotInstanceType;
    /**
     * <p>Deprecated.</p>
     * @public
     */
    BlockDurationMinutes?: number;
    /**
     * <p>The end date of the request, in UTC format
     *                 (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     *             Supported only for persistent requests.</p>
     *          <ul>
     *             <li>
     *                <p>For a persistent request, the request remains active until the
     *                         <code>ValidUntil</code> date and time is reached. Otherwise, the request
     *                     remains active until you cancel it.</p>
     *             </li>
     *             <li>
     *                <p>For a one-time request, <code>ValidUntil</code> is not supported. The request
     *                     remains active until all instances launch or you cancel the request.</p>
     *             </li>
     *          </ul>
     * @public
     */
    ValidUntil?: Date;
    /**
     * <p>The behavior when a Spot Instance is interrupted.</p>
     *          <p>If <code>Configured</code> (for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_HibernationOptionsRequest.html">
     *                <code>HibernationOptions</code>
     *             </a>) is set to <code>true</code>, the
     *                 <code>InstanceInterruptionBehavior</code> parameter is automatically set to
     *                 <code>hibernate</code>. If you set it to <code>stop</code> or
     *             <code>terminate</code>, you'll get an error.</p>
     *          <p>If <code>Configured</code> (for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_HibernationOptionsRequest.html">
     *                <code>HibernationOptions</code>
     *             </a>) is set to <code>false</code> or
     *                 <code>null</code>, the <code>InstanceInterruptionBehavior</code> parameter is
     *             automatically set to <code>terminate</code>. You can also set it to <code>stop</code> or
     *                 <code>hibernate</code>.</p>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/interruption-behavior.html">Interruption
     *                 behavior</a> in the <i>Amazon EC2 User Guide</i>.</p>
     * @public
     */
    InstanceInterruptionBehavior?: InstanceInterruptionBehavior;
}
/**
 * <p>Describes the market (purchasing) option for the instances.</p>
 * @public
 */
export interface InstanceMarketOptionsRequest {
    /**
     * <p>The market type.</p>
     * @public
     */
    MarketType?: MarketType;
    /**
     * <p>The options for Spot Instances.</p>
     * @public
     */
    SpotOptions?: SpotMarketOptions;
}
/**
 * <p>The launch template to use. You must specify either the launch template ID or launch
 *             template name in the request, but not both.</p>
 * @public
 */
export interface LaunchTemplateSpecification {
    /**
     * <p>The ID of the launch template.</p>
     *          <p>You must specify the <code>LaunchTemplateId</code> or the
     *                 <code>LaunchTemplateName</code>, but not both.</p>
     * @public
     */
    LaunchTemplateId?: string;
    /**
     * <p>The name of the launch template.</p>
     *          <p>You must specify the <code>LaunchTemplateName</code> or the
     *                 <code>LaunchTemplateId</code>, but not both.</p>
     * @public
     */
    LaunchTemplateName?: string;
    /**
     * <p>The launch template version number, <code>$Latest</code>, or
     *             <code>$Default</code>.</p>
     *          <p>If the value is <code>$Latest</code>, Amazon EC2 uses the latest version of the launch
     *             template.</p>
     *          <p>If the value is <code>$Default</code>, Amazon EC2 uses the default version of the
     *             launch template.</p>
     *          <p>Default: The default version of the launch template.</p>
     * @public
     */
    Version?: string;
}
/**
 * <p>Describes a license configuration.</p>
 * @public
 */
export interface LicenseConfigurationRequest {
    /**
     * <p>The Amazon Resource Name (ARN) of the license configuration.</p>
     * @public
     */
    LicenseConfigurationArn?: string;
}
/**
 * <p>The maintenance options for the instance.</p>
 * @public
 */
export interface InstanceMaintenanceOptionsRequest {
    /**
     * <p>Disables the automatic recovery behavior of your instance or sets it to default. For
     *             more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html#instance-configuration-recovery">Simplified automatic recovery</a>.</p>
     * @public
     */
    AutoRecovery?: InstanceAutoRecoveryState;
}
/**
 * <p>The metadata options for the instance.</p>
 * @public
 */
export interface InstanceMetadataOptionsRequest {
    /**
     * <p>Indicates whether IMDSv2 is required.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>optional</code> - IMDSv2 is optional. You can choose whether to send a
     *                     session token in your instance metadata retrieval requests. If you retrieve
     *                     IAM role credentials without a session token, you receive the IMDSv1 role
     *                     credentials. If you retrieve IAM role credentials using a valid session token,
     *                     you receive the IMDSv2 role credentials.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>required</code> - IMDSv2 is required. You must send a session token
     *                     in your instance metadata retrieval requests. With this option, retrieving the
     *                     IAM role credentials always returns IMDSv2 credentials; IMDSv1 credentials are
     *                     not available.</p>
     *             </li>
     *          </ul>
     *          <p>Default: If the value of <code>ImdsSupport</code> for the Amazon Machine Image (AMI)
     *             for your instance is <code>v2.0</code>, the default is <code>required</code>.</p>
     * @public
     */
    HttpTokens?: HttpTokensState;
    /**
     * <p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the
     *             number, the further instance metadata requests can travel.</p>
     *          <p>Default: 1</p>
     *          <p>Possible values: Integers from 1 to 64</p>
     * @public
     */
    HttpPutResponseHopLimit?: number;
    /**
     * <p>Enables or disables the HTTP metadata endpoint on your instances.</p>
     *          <p>If you specify a value of <code>disabled</code>, you cannot access your instance
     *             metadata.</p>
     *          <p>Default: <code>enabled</code>
     *          </p>
     * @public
     */
    HttpEndpoint?: InstanceMetadataEndpointState;
    /**
     * <p>Enables or disables the IPv6 endpoint for the instance metadata service.</p>
     *          <p>Default: <code>disabled</code>
     *          </p>
     * @public
     */
    HttpProtocolIpv6?: InstanceMetadataProtocolState;
    /**
     * <p>Set to <code>enabled</code> to allow access to instance tags from the instance
     *             metadata. Set to <code>disabled</code> to turn off access to instance tags from the
     *             instance metadata. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with
     *                 instance tags using the instance metadata</a>.</p>
     *          <p>Default: <code>disabled</code>
     *          </p>
     * @public
     */
    InstanceMetadataTags?: InstanceMetadataTagsState;
}
/**
 * <p>Describes the options for instance hostnames.</p>
 * @public
 */
export interface PrivateDnsNameOptionsRequest {
    /**
     * <p>The type of hostname for EC2 instances. For IPv4 only subnets, an instance DNS name
     *             must be based on the instance IPv4 address. For IPv6 only subnets, an instance DNS name
     *             must be based on the instance ID. For dual-stack subnets, you can specify whether DNS
     *             names use the instance IPv4 address or the instance ID.</p>
     * @public
     */
    HostnameType?: HostnameType;
    /**
     * <p>Indicates whether to respond to DNS queries for instance hostnames with DNS A
     *             records.</p>
     * @public
     */
    EnableResourceNameDnsARecord?: boolean;
    /**
     * <p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA
     *             records.</p>
     * @public
     */
    EnableResourceNameDnsAAAARecord?: boolean;
}
/**
 * @public
 */
export interface RunInstancesRequest {
    /**
     * <p>The block device mapping, which defines the EBS volumes and instance store volumes to
     *             attach to the instance at launch. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block device
     *                 mappings</a> in the <i>Amazon EC2 User Guide</i>.</p>
     * @public
     */
    BlockDeviceMappings?: BlockDeviceMapping[];
    /**
     * <p>The ID of the AMI. An AMI ID is required to launch an instance and must be specified
     *             here or in a launch template.</p>
     * @public
     */
    ImageId?: string;
    /**
     * <p>The instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     *                 <i>Amazon EC2 User Guide</i>.</p>
     * @public
     */
    InstanceType?: _InstanceType;
    /**
     * <p>The number of IPv6 addresses to associate with the primary network
     *             interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet. You
     *             cannot specify this option and the option to assign specific IPv6 addresses in the same
     *             request. You can specify this option if you've specified a minimum number of instances
     *             to launch.</p>
     *          <p>You cannot specify this option and the network interfaces option in the same
     *             request.</p>
     * @public
     */
    Ipv6AddressCount?: number;
    /**
     * <p>The IPv6 addresses from the range of the subnet to associate with the
     *             primary network interface. You cannot specify this option and the option to assign a
     *             number of IPv6 addresses in the same request. You cannot specify this option if you've
     *             specified a minimum number of instances to launch.</p>
     *          <p>You cannot specify this option and the network interfaces option in the same
     *             request.</p>
     * @public
     */
    Ipv6Addresses?: InstanceIpv6Address[];
    /**
     * <p>The ID of the kernel.</p>
     *          <important>
     *             <p>We recommend that you use PV-GRUB instead of kernels and RAM disks. For more
     *                 information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">PV-GRUB</a> in the
     *                     <i>Amazon EC2 User Guide</i>.</p>
     *          </important>
     * @public
     */
    KernelId?: string;
    /**
     * <p>The name of the key pair. You can create a key pair using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair</a> or
     *                 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair</a>.</p>
     *          <important>
     *             <p>If you do not specify a key pair, you can't connect to the instance unless you
     *                 choose an AMI that is configured to allow users another way to log in.</p>
     *          </important>
     * @public
     */
    KeyName?: string;
    /**
     * <p>The maximum number of instances to launch. If you specify more instances than Amazon
     *             EC2 can launch in the target Availability Zone, Amazon EC2 launches the largest possible
     *             number of instances above <code>MinCount</code>.</p>
     *          <p>Constraints: Between 1 and the maximum number you're allowed for the specified
     *             instance type. For more information about the default limits, and how to request an
     *             increase, see <a href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can I
     *                 run in Amazon EC2</a> in the Amazon EC2 FAQ.</p>
     * @public
     */
    MaxCount: number | undefined;
    /**
     * <p>The minimum number of instances to launch. If you specify a minimum that is more
     *             instances than Amazon EC2 can launch in the target Availability Zone, Amazon EC2
     *             launches no instances.</p>
     *          <p>Constraints: Between 1 and the maximum number you're allowed for the specified
     *             instance type. For more information about the default limits, and how to request an
     *             increase, see <a href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can I
     *                 run in Amazon EC2</a> in the Amazon EC2 General FAQ.</p>
     * @public
     */
    MinCount: number | undefined;
    /**
     * <p>Specifies whether detailed monitoring is enabled for the instance.</p>
     * @public
     */
    Monitoring?: RunInstancesMonitoringEnabled;
    /**
     * <p>The placement for the instance.</p>
     * @public
     */
    Placement?: Placement;
    /**
     * <p>The ID of the RAM disk to select. Some kernels require additional drivers at launch.
     *             Check the kernel requirements for information about whether you need to specify a RAM
     *             disk. To find kernel requirements, go to the Amazon Web Services Resource Center and
     *             search for the kernel ID.</p>
     *          <important>
     *             <p>We recommend that you use PV-GRUB instead of kernels and RAM disks. For more
     *                 information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">PV-GRUB</a> in the
     *                     <i>Amazon EC2 User Guide</i>.</p>
     *          </important>
     * @public
     */
    RamdiskId?: string;
    /**
     * <p>The IDs of the security groups. You can create a security group using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html">CreateSecurityGroup</a>.</p>
     *          <p>If you specify a network interface, you must specify any security groups as part of
     *             the network interface.</p>
     * @public
     */
    SecurityGroupIds?: string[];
    /**
     * <p>[Default VPC] The names of the security groups.</p>
     *          <p>If you specify a network interface, you must specify any security groups as part of
     *             the network interface.</p>
     *          <p>Default: Amazon EC2 uses the default security group.</p>
     * @public
     */
    SecurityGroups?: string[];
    /**
     * <p>The ID of the subnet to launch the instance into.</p>
     *          <p>If you specify a network interface, you must specify any subnets as part of the
     *             network interface.</p>
     * @public
     */
    SubnetId?: string;
    /**
     * <p>The user data script to make available to the instance. For more information, see
     *                 <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Run
     *                 commands on your Linux instance at launch</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-windows-user-data.html">Run commands on your
     *                 Windows instance at launch</a>. If you are using a command line tool,
     *             base64-encoding is performed for you, and you can load the text from a file. Otherwise,
     *             you must provide base64-encoded text. User data is limited to 16 KB.</p>
     * @public
     */
    UserData?: string;
    /**
     * <p>Reserved.</p>
     * @public
     */
    AdditionalInfo?: string;
    /**
     * <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the
     *             request. If you do not specify a client token, a randomly generated token is used for
     *             the request to ensure idempotency.</p>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *                 Idempotency</a>.</p>
     *          <p>Constraints: Maximum 64 ASCII characters</p>
     * @public
     */
    ClientToken?: string;
    /**
     * <p>If you set this parameter to <code>true</code>, you can't terminate the instance using
     *             the Amazon EC2 console, CLI, or API; otherwise, you can. To change this attribute after
     *             launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a>. Alternatively, if you set
     *                 <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code>, you can
     *             terminate the instance by running the shutdown command from the instance.</p>
     *          <p>Default: <code>false</code>
     *          </p>
     * @public
     */
    DisableApiTermination?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>Indicates whether the instance is optimized for Amazon EBS I/O. This optimization
     *             provides dedicated throughput to Amazon EBS and an optimized configuration stack to
     *             provide optimal Amazon EBS I/O performance. This optimization isn't available with all
     *             instance types. Additional usage charges apply when using an EBS-optimized
     *             instance.</p>
     *          <p>Default: <code>false</code>
     *          </p>
     * @public
     */
    EbsOptimized?: boolean;
    /**
     * <p>The name or Amazon Resource Name (ARN) of an IAM instance
     *             profile.</p>
     * @public
     */
    IamInstanceProfile?: IamInstanceProfileSpecification;
    /**
     * <p>Indicates whether an instance stops or terminates when you initiate shutdown from the
     *             instance (using the operating system command for system shutdown).</p>
     *          <p>Default: <code>stop</code>
     *          </p>
     * @public
     */
    InstanceInitiatedShutdownBehavior?: ShutdownBehavior;
    /**
     * <p>The network interfaces to associate with the instance. If you specify a network
     *             interface, you must specify any security groups and subnets as part of the network
     *             interface.</p>
     * @public
     */
    NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
    /**
     * <p>The primary IPv4 address. You must specify a value from the IPv4 address
     *             range of the subnet.</p>
     *          <p>Only one private IP address can be designated as primary. You can't specify this
     *             option if you've specified the option to designate a private IP address as the primary
     *             IP address in a network interface specification. You cannot specify this option if
     *             you're launching more than one instance in the request.</p>
     *          <p>You cannot specify this option and the network interfaces option in the same
     *             request.</p>
     * @public
     */
    PrivateIpAddress?: string;
    /**
     * <p>Deprecated.</p>
     *          <note>
     *             <p>Amazon Elastic Graphics reached end of life on January 8, 2024. For
     *                 workloads that require graphics acceleration, we recommend that you use Amazon EC2 G4ad,
     *                 G4dn, or G5 instances.</p>
     *          </note>
     * @public
     */
    ElasticGpuSpecification?: ElasticGpuSpecification[];
    /**
     * <p>An elastic inference accelerator to associate with the instance. Elastic inference
     *             accelerators are a resource you can attach to your Amazon EC2 instances to accelerate
     *             your Deep Learning (DL) inference workloads.</p>
     *          <p>You cannot specify accelerators from different generations in the same request.</p>
     *          <note>
     *             <p>Starting April 15, 2023, Amazon Web Services will not onboard new customers to Amazon
     *             Elastic Inference (EI), and will help current customers migrate their workloads to
     *             options that offer better price and performance. After April 15, 2023, new customers
     *             will not be able to launch instances with Amazon EI accelerators in Amazon SageMaker,
     *             Amazon ECS, or Amazon EC2. However, customers who have used Amazon EI at least once during
     *             the past 30-day period are considered current customers and will be able to continue
     *             using the service.</p>
     *          </note>
     * @public
     */
    ElasticInferenceAccelerators?: ElasticInferenceAccelerator[];
    /**
     * <p>The tags to apply to the resources that are created during instance launch.</p>
     *          <p>You can specify tags for the following resources only:</p>
     *          <ul>
     *             <li>
     *                <p>Instances</p>
     *             </li>
     *             <li>
     *                <p>Volumes</p>
     *             </li>
     *             <li>
     *                <p>Spot Instance requests</p>
     *             </li>
     *             <li>
     *                <p>Network interfaces</p>
     *             </li>
     *          </ul>
     *          <p>To tag a resource after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.</p>
     * @public
     */
    TagSpecifications?: TagSpecification[];
    /**
     * <p>The launch template to use to launch the instances. Any parameters that you specify in
     *                 <a>RunInstances</a> override the same parameters in the launch template.
     *             You can specify either the name or ID of a launch template, but not both.</p>
     * @public
     */
    LaunchTemplate?: LaunchTemplateSpecification;
    /**
     * <p>The market (purchasing) option for the instances.</p>
     *          <p>For <a>RunInstances</a>, persistent Spot Instance requests are
     *             only supported when <b>InstanceInterruptionBehavior</b> is set
     *             to either <code>hibernate</code> or <code>stop</code>.</p>
     * @public
     */
    InstanceMarketOptions?: InstanceMarketOptionsRequest;
    /**
     * <p>The credit option for CPU usage of the burstable performance instance. Valid values
     *             are <code>standard</code> and <code>unlimited</code>. To change this attribute after
     *             launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html">
     *                 ModifyInstanceCreditSpecification</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     *                 performance instances</a> in the <i>Amazon EC2 User Guide</i>.</p>
     *          <p>Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a/T4g
     *             instances)</p>
     *          <p>For T3 instances with <code>host</code> tenancy, only <code>standard</code> is
     *             supported.</p>
     * @public
     */
    CreditSpecification?: CreditSpecificationRequest;
    /**
     * <p>The CPU options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in the <i>Amazon EC2 User Guide</i>.</p>
     * @public
     */
    CpuOptions?: CpuOptionsRequest;
    /**
     * <p>Information about the Capacity Reservation targeting option. If you do not specify this parameter, the
     *             instance's Capacity Reservation preference defaults to <code>open</code>, which enables
     *             it to run in any open Capacity Reservation that has matching attributes (instance type,
     *             platform, Availability Zone).</p>
     * @public
     */
    CapacityReservationSpecification?: CapacityReservationSpecification;
    /**
     * <p>Indicates whether an instance is enabled for hibernation. This parameter is valid only
     *             if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html">hibernation
     *                 prerequisites</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the
     *                 <i>Amazon EC2 User Guide</i>.</p>
     *          <p>You can't enable hibernation and Amazon Web Services Nitro Enclaves on the same
     *             instance.</p>
     * @public
     */
    HibernationOptions?: HibernationOptionsRequest;
    /**
     * <p>The license configurations.</p>
     * @public
     */
    LicenseSpecifications?: LicenseConfigurationRequest[];
    /**
     * <p>The metadata options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a>.</p>
     * @public
     */
    MetadataOptions?: InstanceMetadataOptionsRequest;
    /**
     * <p>Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For
     *             more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html">What is Amazon Web Services Nitro
     *                 Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User
     *                 Guide</i>.</p>
     *          <p>You can't enable Amazon Web Services Nitro Enclaves and hibernation on the same
     *             instance.</p>
     * @public
     */
    EnclaveOptions?: EnclaveOptionsRequest;
    /**
     * <p>The options for the instance hostname.
     *             The default values are inherited from the subnet.
     *             Applies only if creating a network interface, not attaching an existing one.</p>
     * @public
     */
    PrivateDnsNameOptions?: PrivateDnsNameOptionsRequest;
    /**
     * <p>The maintenance and recovery options for the instance.</p>
     * @public
     */
    MaintenanceOptions?: InstanceMaintenanceOptionsRequest;
    /**
     * <p>Indicates whether an instance is enabled for stop protection. For more information,
     *             see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection">Stop
     *                 protection</a>. </p>
     * @public
     */
    DisableApiStop?: boolean;
    /**
     * <p>If you’re launching an instance into a dual-stack or IPv6-only subnet, you can enable
     *             assigning a primary IPv6 address. A primary IPv6 address is an IPv6 GUA address
     *             associated with an ENI that you have enabled to use a primary IPv6 address. Use this
     *             option if an instance relies on its IPv6 address not changing. When you launch the
     *             instance, Amazon Web Services will automatically assign an IPv6 address associated with
     *             the ENI attached to your instance to be the primary IPv6 address. Once you enable an
     *             IPv6 GUA address to be a primary IPv6, you cannot disable it. When you enable an IPv6
     *             GUA address to be a primary IPv6, the first IPv6 GUA will be made the primary IPv6
     *             address until the instance is terminated or the network interface is detached. If you
     *             have multiple IPv6 addresses associated with an ENI attached to your instance and you
     *             enable a primary IPv6 address, the first IPv6 GUA address associated with the ENI
     *             becomes the primary IPv6 address.</p>
     * @public
     */
    EnablePrimaryIpv6?: boolean;
}
/**
 * <p>Describes an EBS volume for a Scheduled Instance.</p>
 * @public
 */
export interface ScheduledInstancesEbs {
    /**
     * <p>Indicates whether the volume is deleted on instance termination.</p>
     * @public
     */
    DeleteOnTermination?: boolean;
    /**
     * <p>Indicates whether the volume is encrypted. You can attached encrypted volumes only to instances that
     *          support them.</p>
     * @public
     */
    Encrypted?: boolean;
    /**
     * <p>The number of I/O operations per second (IOPS) to provision for a <code>gp3</code>, <code>io1</code>, or <code>io2</code>
     *    	   volume.</p>
     * @public
     */
    Iops?: number;
    /**
     * <p>The ID of the snapshot.</p>
     * @public
     */
    SnapshotId?: string;
    /**
     * <p>The size of the volume, in GiB.</p>
     *          <p>Default: If you're creating the volume from a snapshot and don't specify a volume size, the default
     *          is the snapshot size.</p>
     * @public
     */
    VolumeSize?: number;
    /**
     * <p>The volume type.</p>
     *          <p>Default: <code>gp2</code>
     *          </p>
     * @public
     */
    VolumeType?: string;
}
/**
 * <p>Describes a block device mapping for a Scheduled Instance.</p>
 * @public
 */
export interface ScheduledInstancesBlockDeviceMapping {
    /**
     * <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
     * @public
     */
    DeviceName?: string;
    /**
     * <p>Parameters used to set up EBS volumes automatically when the instance is launched.</p>
     * @public
     */
    Ebs?: ScheduledInstancesEbs;
    /**
     * <p>To omit the device from the block device mapping, specify an empty string.</p>
     * @public
     */
    NoDevice?: string;
    /**
     * <p>The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered
     *          starting from 0. An instance type with two available instance store volumes can specify mappings
     *          for <code>ephemeral0</code> and <code>ephemeral1</code>. The number of available instance store
     *          volumes depends on the instance type. After you connect to the instance, you must mount the
     *          volume.</p>
     *          <p>Constraints: For M3 instances, you must specify instance store volumes in the block device
     *          mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes
     *          specified in the block device mapping for the AMI.</p>
     * @public
     */
    VirtualName?: string;
}
/**
 * <p>Describes an IAM instance profile for a Scheduled Instance.</p>
 * @public
 */
export interface ScheduledInstancesIamInstanceProfile {
    /**
     * <p>The Amazon Resource Name (ARN).</p>
     * @public
     */
    Arn?: string;
    /**
     * <p>The name.</p>
     * @public
     */
    Name?: string;
}
/**
 * <p>Describes whether monitoring is enabled for a Scheduled Instance.</p>
 * @public
 */
export interface ScheduledInstancesMonitoring {
    /**
     * <p>Indicates whether monitoring is enabled.</p>
     * @public
     */
    Enabled?: boolean;
}
/**
 * <p>Describes an IPv6 address.</p>
 * @public
 */
export interface ScheduledInstancesIpv6Address {
    /**
     * <p>The IPv6 address.</p>
     * @public
     */
    Ipv6Address?: string;
}
/**
 * <p>Describes a private IPv4 address for a Scheduled Instance.</p>
 * @public
 */
export interface ScheduledInstancesPrivateIpAddressConfig {
    /**
     * <p>Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary IPv4 address.</p>
     * @public
     */
    Primary?: boolean;
    /**
     * <p>The IPv4 address.</p>
     * @public
     */
    PrivateIpAddress?: string;
}
/**
 * <p>Describes a network interface for a Scheduled Instance.</p>
 * @public
 */
export interface ScheduledInstancesNetworkInterface {
    /**
     * <p>Indicates whether to assign a public IPv4 address to instances launched in a VPC. The
     *          public IPv4 address can only be assigned to a network interface for eth0, and can only be
     *          assigned to a new network interface, not an existing one. You cannot specify more than one
     *          network interface in the request. If launching into a default subnet, the default value is
     *          <code>true</code>.</p>
     *          <p>Amazon Web Services charges for all public IPv4 addresses, including public IPv4 addresses
     * associated with running instances and Elastic IP addresses. For more information, see the <i>Public IPv4 Address</i> tab on the <a href="http://aws.amazon.com/vpc/pricing/">Amazon VPC pricing page</a>.</p>
     * @public
     */
    AssociatePublicIpAddress?: boolean;
    /**
     * <p>Indicates whether to delete the interface when the instance is terminated.</p>
     * @public
     */
    DeleteOnTermination?: boolean;
    /**
     * <p>The description.</p>
     * @public
     */
    Description?: string;
    /**
     * <p>The index of the device for the network interface attachment.</p>
     * @public
     */
    DeviceIndex?: number;
    /**
     * <p>The IDs of the security groups.</p>
     * @public
     */
    Groups?: string[];
    /**
     * <p>The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically selected from the subnet range.</p>
     * @public
     */
    Ipv6AddressCount?: number;
    /**
     * <p>The specific IPv6 addresses from the subnet range.</p>
     * @public
     */
    Ipv6Addresses?: ScheduledInstancesIpv6Address[];
    /**
     * <p>The ID of the network interface.</p>
     * @public
     */
    NetworkInterfaceId?: string;
    /**
     * <p>The IPv4 address of the network interface within the subnet.</p>
     * @public
     */
    PrivateIpAddress?: string;
    /**
     * <p>The private IPv4 addresses.</p>
     * @public
     */
    PrivateIpAddressConfigs?: ScheduledInstancesPrivateIpAddressConfig[];
    /**
     * <p>The number of secondary private IPv4 addresses.</p>
     * @public
     */
    SecondaryPrivateIpAddressCount?: number;
    /**
     * <p>The ID of the subnet.</p>
     * @public
     */
    SubnetId?: string;
}
/**
 * <p>Describes the placement for a Scheduled Instance.</p>
 * @public
 */
export interface ScheduledInstancesPlacement {
    /**
     * <p>The Availability Zone.</p>
     * @public
     */
    AvailabilityZone?: string;
    /**
     * <p>The name of the placement group.</p>
     * @public
     */
    GroupName?: string;
}
/**
 * <p>Describes the launch specification for a Scheduled Instance.</p>
 *          <p>If you are launching the Scheduled Instance in EC2-VPC, you must specify the ID of the subnet.
 *           You can specify the subnet using either <code>SubnetId</code> or <code>NetworkInterface</code>.</p>
 * @public
 */
export interface ScheduledInstancesLaunchSpecification {
    /**
     * <p>The block device mapping entries.</p>
     * @public
     */
    BlockDeviceMappings?: ScheduledInstancesBlockDeviceMapping[];
    /**
     * <p>Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.</p>
     *          <p>Default: <code>false</code>
     *          </p>
     * @public
     */
    EbsOptimized?: boolean;
    /**
     * <p>The IAM instance profile.</p>
     * @public
     */
    IamInstanceProfile?: ScheduledInstancesIamInstanceProfile;
    /**
     * <p>The ID of the Amazon Machine Image (AMI).</p>
     * @public
     */
    ImageId: string | undefined;
    /**
     * <p>The instance type.</p>
     * @public
     */
    InstanceType?: string;
    /**
     * <p>The ID of the kernel.</p>
     * @public
     */
    KernelId?: string;
    /**
     * <p>The name of the key pair.</p>
     * @public
     */
    KeyName?: string;
    /**
     * <p>Enable or disable monitoring for the instances.</p>
     * @public
     */
    Monitoring?: ScheduledInstancesMonitoring;
    /**
     * <p>The network interfaces.</p>
     * @public
     */
    NetworkInterfaces?: ScheduledInstancesNetworkInterface[];
    /**
     * <p>The placement information.</p>
     * @public
     */
    Placement?: ScheduledInstancesPlacement;
    /**
     * <p>The ID of the RAM disk.</p>
     * @public
     */
    RamdiskId?: string;
    /**
     * <p>The IDs of the security groups.</p>
     * @public
     */
    SecurityGroupIds?: string[];
    /**
     * <p>The ID of the subnet in which to launch the instances.</p>
     * @public
     */
    SubnetId?: string;
    /**
     * <p>The base64-encoded MIME user data.</p>
     * @public
     */
    UserData?: string;
}
/**
 * <p>Contains the parameters for RunScheduledInstances.</p>
 * @public
 */
export interface RunScheduledInstancesRequest {
    /**
     * <p>Unique, case-sensitive identifier that ensures the idempotency of the request.
     *          For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
     * @public
     */
    ClientToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The number of instances.</p>
     *          <p>Default: 1</p>
     * @public
     */
    InstanceCount?: number;
    /**
     * <p>The launch specification. You must match the instance type, Availability Zone,
     *          network, and platform of the schedule that you purchased.</p>
     * @public
     */
    LaunchSpecification: ScheduledInstancesLaunchSpecification | undefined;
    /**
     * <p>The Scheduled Instance ID.</p>
     * @public
     */
    ScheduledInstanceId: string | undefined;
}
/**
 * <p>Contains the output of RunScheduledInstances.</p>
 * @public
 */
export interface RunScheduledInstancesResult {
    /**
     * <p>The IDs of the newly launched instances.</p>
     * @public
     */
    InstanceIdSet?: string[];
}
/**
 * @public
 */
export interface SearchLocalGatewayRoutesRequest {
    /**
     * <p>The ID of the local gateway route table.</p>
     * @public
     */
    LocalGatewayRouteTableId: string | undefined;
    /**
     * <p>One or more filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>prefix-list-id</code> - The ID of the prefix list.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>route-search.exact-match</code> - The exact match of the specified filter.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>route-search.longest-prefix-match</code> - The longest prefix that matches the route.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>route-search.subnet-of-match</code> - The routes with a subnet that match the specified CIDR filter.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>route-search.supernet-of-match</code> - The routes with a CIDR that encompass the CIDR filter.
     *                For example, if you have 10.0.1.0/29 and 10.0.1.0/31 routes in your route table and you specify <code>supernet-of-match</code>
     *                as 10.0.1.0/30, then the result returns 10.0.1.0/29.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the route.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>type</code> - The route type.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface SearchLocalGatewayRoutesResult {
    /**
     * <p>Information about the routes.</p>
     * @public
     */
    Routes?: LocalGatewayRoute[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface SearchTransitGatewayMulticastGroupsRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     * @public
     */
    TransitGatewayMulticastDomainId: string | undefined;
    /**
     * <p>One or more filters. The possible values are:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>group-ip-address</code> - The IP address of the  transit gateway multicast group.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>is-group-member</code> - The resource is a group member. Valid values are <code>true</code> | <code>false</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>is-group-source</code> - The resource is a group source. Valid values are <code>true</code> | <code>false</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>member-type</code> - The member type. Valid values are <code>igmp</code> | <code>static</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>resource-id</code> - The ID of the resource.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>resource-type</code> - The type of resource. Valid values are <code>vpc</code> | <code>vpn</code> | <code>direct-connect-gateway</code> | <code>tgw-peering</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>source-type</code> - The source type. Valid values are <code>igmp</code> | <code>static</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>subnet-id</code> - The ID of the subnet.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transit-gateway-attachment-id</code> - The id of the transit gateway attachment.</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     * @public
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 * @enum
 */
export declare const MembershipType: {
    readonly igmp: "igmp";
    readonly static: "static";
};
/**
 * @public
 */
export type MembershipType = (typeof MembershipType)[keyof typeof MembershipType];
/**
 * <p>Describes the  transit gateway multicast group resources.</p>
 * @public
 */
export interface TransitGatewayMulticastGroup {
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     * @public
     */
    GroupIpAddress?: string;
    /**
     * <p>The ID of the transit gateway attachment.</p>
     * @public
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>The ID of the subnet.</p>
     * @public
     */
    SubnetId?: string;
    /**
     * <p>The ID of the resource.</p>
     * @public
     */
    ResourceId?: string;
    /**
     * <p>The type of resource, for example a VPC attachment.</p>
     * @public
     */
    ResourceType?: TransitGatewayAttachmentResourceType;
    /**
     * <p> The ID of the Amazon Web Services account that owns the transit gateway multicast domain group resource.</p>
     * @public
     */
    ResourceOwnerId?: string;
    /**
     * <p>The ID of the transit gateway attachment.</p>
     * @public
     */
    NetworkInterfaceId?: string;
    /**
     * <p>Indicates that the resource is a  transit gateway multicast group member.</p>
     * @public
     */
    GroupMember?: boolean;
    /**
     * <p>Indicates that the resource is a  transit gateway multicast group member.</p>
     * @public
     */
    GroupSource?: boolean;
    /**
     * <p>The member type (for example, <code>static</code>).</p>
     * @public
     */
    MemberType?: MembershipType;
    /**
     * <p>The source type.</p>
     * @public
     */
    SourceType?: MembershipType;
}
/**
 * @public
 */
export interface SearchTransitGatewayMulticastGroupsResult {
    /**
     * <p>Information about the  transit gateway multicast group.</p>
     * @public
     */
    MulticastGroups?: TransitGatewayMulticastGroup[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     * @public
     */
    NextToken?: string;
}
/**
 * @public
 */
export interface SearchTransitGatewayRoutesRequest {
    /**
     * <p>The ID of the transit gateway route table.</p>
     * @public
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>One or more filters. The possible values are:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>attachment.transit-gateway-attachment-id</code>- The id of the transit gateway attachment.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>attachment.resource-id</code> - The resource id of the transit gateway attachment.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>attachment.resource-type</code> - The attachment resource type. Valid values
     *                     are <code>vpc</code> | <code>vpn</code> | <code>direct-connect-gateway</code> |
     *                         <code>peering</code> | <code>connect</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>prefix-list-id</code> - The ID of the prefix list.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>route-search.exact-match</code> - The exact match of the specified filter.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>route-search.longest-prefix-match</code> - The longest prefix that matches the route.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>route-search.subnet-of-match</code> - The routes with a subnet that match the specified CIDR filter.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>route-search.supernet-of-match</code> - The routes with a CIDR that encompass the CIDR filter. For example, if you have 10.0.1.0/29 and 10.0.1.0/31 routes in your route table and you specify supernet-of-match as 10.0.1.0/30, then the result returns 10.0.1.0/29.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the route (<code>active</code> | <code>blackhole</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>type</code> - The type of route (<code>propagated</code> |
     *                   <code>static</code>).</p>
     *             </li>
     *          </ul>
     * @public
     */
    Filters: Filter[] | undefined;
    /**
     * <p>The maximum number of routes to return.</p>
     * @public
     */
    MaxResults?: number;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface SearchTransitGatewayRoutesResult {
    /**
     * <p>Information about the routes.</p>
     * @public
     */
    Routes?: TransitGatewayRoute[];
    /**
     * <p>Indicates whether there are additional routes available.</p>
     * @public
     */
    AdditionalRoutesAvailable?: boolean;
}
/**
 * @public
 */
export interface SendDiagnosticInterruptRequest {
    /**
     * <p>The ID of the instance.</p>
     * @public
     */
    InstanceId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface StartInstancesRequest {
    /**
     * <p>The IDs of the instances.</p>
     * @public
     */
    InstanceIds: string[] | undefined;
    /**
     * <p>Reserved.</p>
     * @public
     */
    AdditionalInfo?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Describes an instance state change.</p>
 * @public
 */
export interface InstanceStateChange {
    /**
     * <p>The current state of the instance.</p>
     * @public
     */
    CurrentState?: InstanceState;
    /**
     * <p>The ID of the instance.</p>
     * @public
     */
    InstanceId?: string;
    /**
     * <p>The previous state of the instance.</p>
     * @public
     */
    PreviousState?: InstanceState;
}
/**
 * @public
 */
export interface StartInstancesResult {
    /**
     * <p>Information about the started instances.</p>
     * @public
     */
    StartingInstances?: InstanceStateChange[];
}
/**
 * @public
 */
export interface StartNetworkInsightsAccessScopeAnalysisRequest {
    /**
     * <p>The ID of the Network Access Scope.</p>
     * @public
     */
    NetworkInsightsAccessScopeId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The tags to apply.</p>
     * @public
     */
    TagSpecifications?: TagSpecification[];
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information,
     *    see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
     * @public
     */
    ClientToken?: string;
}
/**
 * @public
 */
export interface StartNetworkInsightsAccessScopeAnalysisResult {
    /**
     * <p>The Network Access Scope analysis.</p>
     * @public
     */
    NetworkInsightsAccessScopeAnalysis?: NetworkInsightsAccessScopeAnalysis;
}
/**
 * @public
 */
export interface StartNetworkInsightsAnalysisRequest {
    /**
     * <p>The ID of the path.</p>
     * @public
     */
    NetworkInsightsPathId: string | undefined;
    /**
     * <p>The member accounts that contain resources that the path can traverse.</p>
     * @public
     */
    AdditionalAccounts?: string[];
    /**
     * <p>The Amazon Resource Names (ARN) of the resources that the path must traverse.</p>
     * @public
     */
    FilterInArns?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The tags to apply.</p>
     * @public
     */
    TagSpecifications?: TagSpecification[];
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information,
     *    see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
     * @public
     */
    ClientToken?: string;
}
/**
 * @public
 */
export interface StartNetworkInsightsAnalysisResult {
    /**
     * <p>Information about the network insights analysis.</p>
     * @public
     */
    NetworkInsightsAnalysis?: NetworkInsightsAnalysis;
}
/**
 * @public
 */
export interface StartVpcEndpointServicePrivateDnsVerificationRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the endpoint service.</p>
     * @public
     */
    ServiceId: string | undefined;
}
/**
 * @public
 */
export interface StartVpcEndpointServicePrivateDnsVerificationResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     * @public
     */
    ReturnValue?: boolean;
}
/**
 * @public
 */
export interface StopInstancesRequest {
    /**
     * <p>The IDs of the instances.</p>
     * @public
     */
    InstanceIds: string[] | undefined;
    /**
     * <p>Hibernates the instance if the instance was enabled for hibernation at launch. If the
     *             instance cannot hibernate successfully, a normal shutdown occurs. For more information,
     *             see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate
     *                 your instance</a> in the <i>Amazon EC2 User Guide</i>.</p>
     *          <p> Default: <code>false</code>
     *          </p>
     * @public
     */
    Hibernate?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>Forces the instances to stop. The instances do not have an opportunity to flush file
     *             system caches or file system metadata. If you use this option, you must perform file
     *             system check and repair procedures. This option is not recommended for Windows
     *             instances.</p>
     *          <p>Default: <code>false</code>
     *          </p>
     * @public
     */
    Force?: boolean;
}
/**
 * @public
 */
export interface StopInstancesResult {
    /**
     * <p>Information about the stopped instances.</p>
     * @public
     */
    StoppingInstances?: InstanceStateChange[];
}
/**
 * @public
 */
export interface TerminateClientVpnConnectionsRequest {
    /**
     * <p>The ID of the Client VPN endpoint to which the client is connected.</p>
     * @public
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>The ID of the client connection to be terminated.</p>
     * @public
     */
    ConnectionId?: string;
    /**
     * <p>The name of the user who initiated the connection. Use this option to terminate all active connections for
     * 			the specified user. This option can only be used if the user has established up to five connections.</p>
     * @public
     */
    Username?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * <p>Information about a terminated Client VPN endpoint client connection.</p>
 * @public
 */
export interface TerminateConnectionStatus {
    /**
     * <p>The ID of the client connection.</p>
     * @public
     */
    ConnectionId?: string;
    /**
     * <p>The state of the client connection.</p>
     * @public
     */
    PreviousStatus?: ClientVpnConnectionStatus;
    /**
     * <p>A message about the status of the client connection, if applicable.</p>
     * @public
     */
    CurrentStatus?: ClientVpnConnectionStatus;
}
/**
 * @public
 */
export interface TerminateClientVpnConnectionsResult {
    /**
     * <p>The ID of the Client VPN endpoint.</p>
     * @public
     */
    ClientVpnEndpointId?: string;
    /**
     * <p>The user who established the terminated client connections.</p>
     * @public
     */
    Username?: string;
    /**
     * <p>The current state of the client connections.</p>
     * @public
     */
    ConnectionStatuses?: TerminateConnectionStatus[];
}
/**
 * @public
 */
export interface TerminateInstancesRequest {
    /**
     * <p>The IDs of the instances.</p>
     *          <p>Constraints: Up to 1000 instance IDs. We recommend breaking up this request into
     *             smaller batches.</p>
     * @public
     */
    InstanceIds: string[] | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface TerminateInstancesResult {
    /**
     * <p>Information about the terminated instances.</p>
     * @public
     */
    TerminatingInstances?: InstanceStateChange[];
}
/**
 * @public
 */
export interface UnassignIpv6AddressesRequest {
    /**
     * <p>The IPv6 addresses to unassign from the network interface.</p>
     * @public
     */
    Ipv6Addresses?: string[];
    /**
     * <p>The IPv6 prefixes to unassign from the network interface.</p>
     * @public
     */
    Ipv6Prefixes?: string[];
    /**
     * <p>The ID of the network interface.</p>
     * @public
     */
    NetworkInterfaceId: string | undefined;
}
/**
 * @public
 */
export interface UnassignIpv6AddressesResult {
    /**
     * <p>The ID of the network interface.</p>
     * @public
     */
    NetworkInterfaceId?: string;
    /**
     * <p>The IPv6 addresses that have been unassigned from the network interface.</p>
     * @public
     */
    UnassignedIpv6Addresses?: string[];
    /**
     * <p>The IPv4 prefixes that have been unassigned from  the network interface.</p>
     * @public
     */
    UnassignedIpv6Prefixes?: string[];
}
/**
 * <p>Contains the parameters for UnassignPrivateIpAddresses.</p>
 * @public
 */
export interface UnassignPrivateIpAddressesRequest {
    /**
     * <p>The ID of the network interface.</p>
     * @public
     */
    NetworkInterfaceId: string | undefined;
    /**
     * <p>The secondary private IP addresses to unassign from the network interface. You can specify this
     *         	option multiple times to unassign more than one IP address.</p>
     * @public
     */
    PrivateIpAddresses?: string[];
    /**
     * <p>The IPv4 prefixes to unassign from  the network interface.</p>
     * @public
     */
    Ipv4Prefixes?: string[];
}
/**
 * @public
 */
export interface UnassignPrivateNatGatewayAddressRequest {
    /**
     * <p>The ID of the NAT gateway.</p>
     * @public
     */
    NatGatewayId: string | undefined;
    /**
     * <p>The private IPv4 addresses you want to unassign.</p>
     * @public
     */
    PrivateIpAddresses: string[] | undefined;
    /**
     * <p>The maximum amount of time to wait (in seconds) before forcibly releasing the IP addresses if connections are still in progress. Default value is 350 seconds.</p>
     * @public
     */
    MaxDrainDurationSeconds?: number;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface UnassignPrivateNatGatewayAddressResult {
    /**
     * <p>The ID of the NAT gateway.</p>
     * @public
     */
    NatGatewayId?: string;
    /**
     * <p>Information about the NAT gateway IP addresses.</p>
     * @public
     */
    NatGatewayAddresses?: NatGatewayAddress[];
}
/**
 * @public
 */
export interface UnlockSnapshotRequest {
    /**
     * <p>The ID of the snapshot to unlock.</p>
     * @public
     */
    SnapshotId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface UnlockSnapshotResult {
    /**
     * <p>The ID of the snapshot.</p>
     * @public
     */
    SnapshotId?: string;
}
/**
 * @public
 */
export interface UnmonitorInstancesRequest {
    /**
     * <p>The IDs of the instances.</p>
     * @public
     */
    InstanceIds: string[] | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface UnmonitorInstancesResult {
    /**
     * <p>The monitoring information.</p>
     * @public
     */
    InstanceMonitorings?: InstanceMonitoring[];
}
/**
 * <p>Describes the description of a security group rule.</p>
 *          <p>You can use this when you want to update the security group rule description for either an inbound or outbound rule.</p>
 * @public
 */
export interface SecurityGroupRuleDescription {
    /**
     * <p>The ID of the security group rule.</p>
     * @public
     */
    SecurityGroupRuleId?: string;
    /**
     * <p>The description of the security group rule.</p>
     * @public
     */
    Description?: string;
}
/**
 * @public
 */
export interface UpdateSecurityGroupRuleDescriptionsEgressRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the security group. You must specify either the security group ID or the
     * 			security group name in the request. For security groups in a nondefault VPC, you must
     * 			specify the security group ID.</p>
     * @public
     */
    GroupId?: string;
    /**
     * <p>[Default VPC] The name of the security group. You must specify either the security group
     * 			ID or the security group name.</p>
     * @public
     */
    GroupName?: string;
    /**
     * <p>The IP permissions for the security group rule. You must specify either the IP permissions
     * 		    or the description.</p>
     * @public
     */
    IpPermissions?: IpPermission[];
    /**
     * <p>The description for the egress security group rules. You must specify either the
     *             description or the IP permissions.</p>
     * @public
     */
    SecurityGroupRuleDescriptions?: SecurityGroupRuleDescription[];
}
/**
 * @public
 */
export interface UpdateSecurityGroupRuleDescriptionsEgressResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>
     * @public
     */
    Return?: boolean;
}
/**
 * @public
 */
export interface UpdateSecurityGroupRuleDescriptionsIngressRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the security group. You must specify either the security group ID or the
     * 			security group name in the request. For security groups in a nondefault VPC, you must
     * 			specify the security group ID.</p>
     * @public
     */
    GroupId?: string;
    /**
     * <p>[Default VPC] The name of the security group. You must specify either the
     *             security group ID or the security group name. For security groups in a
     *             nondefault VPC, you must specify the security group ID.</p>
     * @public
     */
    GroupName?: string;
    /**
     * <p>The IP permissions for the security group rule. You must specify either IP permissions
     * 		    or a description.</p>
     * @public
     */
    IpPermissions?: IpPermission[];
    /**
     * <p>The description for the ingress security group rules. You must specify either
     *             a description or IP permissions.</p>
     * @public
     */
    SecurityGroupRuleDescriptions?: SecurityGroupRuleDescription[];
}
/**
 * @public
 */
export interface UpdateSecurityGroupRuleDescriptionsIngressResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>
     * @public
     */
    Return?: boolean;
}
/**
 * @public
 */
export interface WithdrawByoipCidrRequest {
    /**
     * <p>The address range, in CIDR notation.</p>
     * @public
     */
    Cidr: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     * @public
     */
    DryRun?: boolean;
}
/**
 * @public
 */
export interface WithdrawByoipCidrResult {
    /**
     * <p>Information about the address pool.</p>
     * @public
     */
    ByoipCidr?: ByoipCidr;
}
/**
 * @internal
 */
export declare const RequestSpotFleetRequestFilterSensitiveLog: (obj: RequestSpotFleetRequest) => any;
/**
 * @internal
 */
export declare const RequestSpotLaunchSpecificationFilterSensitiveLog: (obj: RequestSpotLaunchSpecification) => any;
/**
 * @internal
 */
export declare const RequestSpotInstancesRequestFilterSensitiveLog: (obj: RequestSpotInstancesRequest) => any;
/**
 * @internal
 */
export declare const RequestSpotInstancesResultFilterSensitiveLog: (obj: RequestSpotInstancesResult) => any;
/**
 * @internal
 */
export declare const RunInstancesRequestFilterSensitiveLog: (obj: RunInstancesRequest) => any;
/**
 * @internal
 */
export declare const ScheduledInstancesLaunchSpecificationFilterSensitiveLog: (obj: ScheduledInstancesLaunchSpecification) => any;
/**
 * @internal
 */
export declare const RunScheduledInstancesRequestFilterSensitiveLog: (obj: RunScheduledInstancesRequest) => any;
