export interface AcceleratorCount {
  Min?: number;
  Max?: number;
}
export interface AcceleratorCountRequest {
  Min?: number;
  Max?: number;
}
export declare const AcceleratorManufacturer: {
  readonly AMAZON_WEB_SERVICES: "amazon-web-services";
  readonly AMD: "amd";
  readonly HABANA: "habana";
  readonly NVIDIA: "nvidia";
  readonly XILINX: "xilinx";
};
export type AcceleratorManufacturer =
  (typeof AcceleratorManufacturer)[keyof typeof AcceleratorManufacturer];
export declare const AcceleratorName: {
  readonly A100: "a100";
  readonly A10G: "a10g";
  readonly H100: "h100";
  readonly INFERENTIA: "inferentia";
  readonly K520: "k520";
  readonly K80: "k80";
  readonly M60: "m60";
  readonly RADEON_PRO_V520: "radeon-pro-v520";
  readonly T4: "t4";
  readonly T4G: "t4g";
  readonly V100: "v100";
  readonly VU9P: "vu9p";
};
export type AcceleratorName =
  (typeof AcceleratorName)[keyof typeof AcceleratorName];
export interface AcceleratorTotalMemoryMiB {
  Min?: number;
  Max?: number;
}
export interface AcceleratorTotalMemoryMiBRequest {
  Min?: number;
  Max?: number;
}
export declare const AcceleratorType: {
  readonly FPGA: "fpga";
  readonly GPU: "gpu";
  readonly INFERENCE: "inference";
};
export type AcceleratorType =
  (typeof AcceleratorType)[keyof typeof AcceleratorType];
export declare const ResourceType: {
  readonly capacity_reservation: "capacity-reservation";
  readonly capacity_reservation_fleet: "capacity-reservation-fleet";
  readonly carrier_gateway: "carrier-gateway";
  readonly client_vpn_endpoint: "client-vpn-endpoint";
  readonly coip_pool: "coip-pool";
  readonly customer_gateway: "customer-gateway";
  readonly dedicated_host: "dedicated-host";
  readonly dhcp_options: "dhcp-options";
  readonly egress_only_internet_gateway: "egress-only-internet-gateway";
  readonly elastic_gpu: "elastic-gpu";
  readonly elastic_ip: "elastic-ip";
  readonly export_image_task: "export-image-task";
  readonly export_instance_task: "export-instance-task";
  readonly fleet: "fleet";
  readonly fpga_image: "fpga-image";
  readonly host_reservation: "host-reservation";
  readonly image: "image";
  readonly import_image_task: "import-image-task";
  readonly import_snapshot_task: "import-snapshot-task";
  readonly instance: "instance";
  readonly instance_connect_endpoint: "instance-connect-endpoint";
  readonly instance_event_window: "instance-event-window";
  readonly internet_gateway: "internet-gateway";
  readonly ipam: "ipam";
  readonly ipam_pool: "ipam-pool";
  readonly ipam_resource_discovery: "ipam-resource-discovery";
  readonly ipam_resource_discovery_association: "ipam-resource-discovery-association";
  readonly ipam_scope: "ipam-scope";
  readonly ipv4pool_ec2: "ipv4pool-ec2";
  readonly ipv6pool_ec2: "ipv6pool-ec2";
  readonly key_pair: "key-pair";
  readonly launch_template: "launch-template";
  readonly local_gateway: "local-gateway";
  readonly local_gateway_route_table: "local-gateway-route-table";
  readonly local_gateway_route_table_virtual_interface_group_association: "local-gateway-route-table-virtual-interface-group-association";
  readonly local_gateway_route_table_vpc_association: "local-gateway-route-table-vpc-association";
  readonly local_gateway_virtual_interface: "local-gateway-virtual-interface";
  readonly local_gateway_virtual_interface_group: "local-gateway-virtual-interface-group";
  readonly natgateway: "natgateway";
  readonly network_acl: "network-acl";
  readonly network_insights_access_scope: "network-insights-access-scope";
  readonly network_insights_access_scope_analysis: "network-insights-access-scope-analysis";
  readonly network_insights_analysis: "network-insights-analysis";
  readonly network_insights_path: "network-insights-path";
  readonly network_interface: "network-interface";
  readonly placement_group: "placement-group";
  readonly prefix_list: "prefix-list";
  readonly replace_root_volume_task: "replace-root-volume-task";
  readonly reserved_instances: "reserved-instances";
  readonly route_table: "route-table";
  readonly security_group: "security-group";
  readonly security_group_rule: "security-group-rule";
  readonly snapshot: "snapshot";
  readonly spot_fleet_request: "spot-fleet-request";
  readonly spot_instances_request: "spot-instances-request";
  readonly subnet: "subnet";
  readonly subnet_cidr_reservation: "subnet-cidr-reservation";
  readonly traffic_mirror_filter: "traffic-mirror-filter";
  readonly traffic_mirror_filter_rule: "traffic-mirror-filter-rule";
  readonly traffic_mirror_session: "traffic-mirror-session";
  readonly traffic_mirror_target: "traffic-mirror-target";
  readonly transit_gateway: "transit-gateway";
  readonly transit_gateway_attachment: "transit-gateway-attachment";
  readonly transit_gateway_connect_peer: "transit-gateway-connect-peer";
  readonly transit_gateway_multicast_domain: "transit-gateway-multicast-domain";
  readonly transit_gateway_policy_table: "transit-gateway-policy-table";
  readonly transit_gateway_route_table: "transit-gateway-route-table";
  readonly transit_gateway_route_table_announcement: "transit-gateway-route-table-announcement";
  readonly verified_access_endpoint: "verified-access-endpoint";
  readonly verified_access_group: "verified-access-group";
  readonly verified_access_instance: "verified-access-instance";
  readonly verified_access_policy: "verified-access-policy";
  readonly verified_access_trust_provider: "verified-access-trust-provider";
  readonly volume: "volume";
  readonly vpc: "vpc";
  readonly vpc_block_public_access_exclusion: "vpc-block-public-access-exclusion";
  readonly vpc_endpoint: "vpc-endpoint";
  readonly vpc_endpoint_connection: "vpc-endpoint-connection";
  readonly vpc_endpoint_connection_device_type: "vpc-endpoint-connection-device-type";
  readonly vpc_endpoint_service: "vpc-endpoint-service";
  readonly vpc_endpoint_service_permission: "vpc-endpoint-service-permission";
  readonly vpc_flow_log: "vpc-flow-log";
  readonly vpc_peering_connection: "vpc-peering-connection";
  readonly vpn_connection: "vpn-connection";
  readonly vpn_connection_device_type: "vpn-connection-device-type";
  readonly vpn_gateway: "vpn-gateway";
};
export type ResourceType = (typeof ResourceType)[keyof typeof ResourceType];
export interface Tag {
  Key?: string;
  Value?: string;
}
export interface TagSpecification {
  ResourceType?: ResourceType;
  Tags?: Tag[];
}
export interface AcceptAddressTransferRequest {
  Address: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export declare const AddressTransferStatus: {
  readonly accepted: "accepted";
  readonly disabled: "disabled";
  readonly pending: "pending";
};
export type AddressTransferStatus =
  (typeof AddressTransferStatus)[keyof typeof AddressTransferStatus];
export interface AddressTransfer {
  PublicIp?: string;
  AllocationId?: string;
  TransferAccountId?: string;
  TransferOfferExpirationTimestamp?: Date;
  TransferOfferAcceptedTimestamp?: Date;
  AddressTransferStatus?: AddressTransferStatus;
}
export interface AcceptAddressTransferResult {
  AddressTransfer?: AddressTransfer;
}
export interface TargetConfigurationRequest {
  InstanceCount?: number;
  OfferingId: string | undefined;
}
export interface AcceptReservedInstancesExchangeQuoteRequest {
  DryRun?: boolean;
  ReservedInstanceIds: string[] | undefined;
  TargetConfigurations?: TargetConfigurationRequest[];
}
export interface AcceptReservedInstancesExchangeQuoteResult {
  ExchangeId?: string;
}
export interface AcceptTransitGatewayMulticastDomainAssociationsRequest {
  TransitGatewayMulticastDomainId?: string;
  TransitGatewayAttachmentId?: string;
  SubnetIds?: string[];
  DryRun?: boolean;
}
export declare const TransitGatewayAttachmentResourceType: {
  readonly connect: "connect";
  readonly direct_connect_gateway: "direct-connect-gateway";
  readonly peering: "peering";
  readonly tgw_peering: "tgw-peering";
  readonly vpc: "vpc";
  readonly vpn: "vpn";
};
export type TransitGatewayAttachmentResourceType =
  (typeof TransitGatewayAttachmentResourceType)[keyof typeof TransitGatewayAttachmentResourceType];
export declare const TransitGatewayMulitcastDomainAssociationState: {
  readonly associated: "associated";
  readonly associating: "associating";
  readonly disassociated: "disassociated";
  readonly disassociating: "disassociating";
  readonly failed: "failed";
  readonly pendingAcceptance: "pendingAcceptance";
  readonly rejected: "rejected";
};
export type TransitGatewayMulitcastDomainAssociationState =
  (typeof TransitGatewayMulitcastDomainAssociationState)[keyof typeof TransitGatewayMulitcastDomainAssociationState];
export interface SubnetAssociation {
  SubnetId?: string;
  State?: TransitGatewayMulitcastDomainAssociationState;
}
export interface TransitGatewayMulticastDomainAssociations {
  TransitGatewayMulticastDomainId?: string;
  TransitGatewayAttachmentId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType;
  ResourceOwnerId?: string;
  Subnets?: SubnetAssociation[];
}
export interface AcceptTransitGatewayMulticastDomainAssociationsResult {
  Associations?: TransitGatewayMulticastDomainAssociations;
}
export interface AcceptTransitGatewayPeeringAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface PeeringTgwInfo {
  TransitGatewayId?: string;
  CoreNetworkId?: string;
  OwnerId?: string;
  Region?: string;
}
export declare const DynamicRoutingValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type DynamicRoutingValue =
  (typeof DynamicRoutingValue)[keyof typeof DynamicRoutingValue];
export interface TransitGatewayPeeringAttachmentOptions {
  DynamicRouting?: DynamicRoutingValue;
}
export declare const TransitGatewayAttachmentState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly failed: "failed";
  readonly failing: "failing";
  readonly initiating: "initiating";
  readonly initiatingRequest: "initiatingRequest";
  readonly modifying: "modifying";
  readonly pending: "pending";
  readonly pendingAcceptance: "pendingAcceptance";
  readonly rejected: "rejected";
  readonly rejecting: "rejecting";
  readonly rollingBack: "rollingBack";
};
export type TransitGatewayAttachmentState =
  (typeof TransitGatewayAttachmentState)[keyof typeof TransitGatewayAttachmentState];
export interface PeeringAttachmentStatus {
  Code?: string;
  Message?: string;
}
export interface TransitGatewayPeeringAttachment {
  TransitGatewayAttachmentId?: string;
  AccepterTransitGatewayAttachmentId?: string;
  RequesterTgwInfo?: PeeringTgwInfo;
  AccepterTgwInfo?: PeeringTgwInfo;
  Options?: TransitGatewayPeeringAttachmentOptions;
  Status?: PeeringAttachmentStatus;
  State?: TransitGatewayAttachmentState;
  CreationTime?: Date;
  Tags?: Tag[];
}
export interface AcceptTransitGatewayPeeringAttachmentResult {
  TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
export interface AcceptTransitGatewayVpcAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export declare const ApplianceModeSupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type ApplianceModeSupportValue =
  (typeof ApplianceModeSupportValue)[keyof typeof ApplianceModeSupportValue];
export declare const DnsSupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type DnsSupportValue =
  (typeof DnsSupportValue)[keyof typeof DnsSupportValue];
export declare const Ipv6SupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type Ipv6SupportValue =
  (typeof Ipv6SupportValue)[keyof typeof Ipv6SupportValue];
export declare const SecurityGroupReferencingSupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type SecurityGroupReferencingSupportValue =
  (typeof SecurityGroupReferencingSupportValue)[keyof typeof SecurityGroupReferencingSupportValue];
export interface TransitGatewayVpcAttachmentOptions {
  DnsSupport?: DnsSupportValue;
  SecurityGroupReferencingSupport?: SecurityGroupReferencingSupportValue;
  Ipv6Support?: Ipv6SupportValue;
  ApplianceModeSupport?: ApplianceModeSupportValue;
}
export interface TransitGatewayVpcAttachment {
  TransitGatewayAttachmentId?: string;
  TransitGatewayId?: string;
  VpcId?: string;
  VpcOwnerId?: string;
  State?: TransitGatewayAttachmentState;
  SubnetIds?: string[];
  CreationTime?: Date;
  Options?: TransitGatewayVpcAttachmentOptions;
  Tags?: Tag[];
}
export interface AcceptTransitGatewayVpcAttachmentResult {
  TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export interface AcceptVpcEndpointConnectionsRequest {
  DryRun?: boolean;
  ServiceId: string | undefined;
  VpcEndpointIds: string[] | undefined;
}
export interface UnsuccessfulItemError {
  Code?: string;
  Message?: string;
}
export interface UnsuccessfulItem {
  Error?: UnsuccessfulItemError;
  ResourceId?: string;
}
export interface AcceptVpcEndpointConnectionsResult {
  Unsuccessful?: UnsuccessfulItem[];
}
export interface AcceptVpcPeeringConnectionRequest {
  DryRun?: boolean;
  VpcPeeringConnectionId: string | undefined;
}
export interface CidrBlock {
  CidrBlock?: string;
}
export interface Ipv6CidrBlock {
  Ipv6CidrBlock?: string;
}
export interface VpcPeeringConnectionOptionsDescription {
  AllowDnsResolutionFromRemoteVpc?: boolean;
  AllowEgressFromLocalClassicLinkToRemoteVpc?: boolean;
  AllowEgressFromLocalVpcToRemoteClassicLink?: boolean;
}
export interface VpcPeeringConnectionVpcInfo {
  CidrBlock?: string;
  Ipv6CidrBlockSet?: Ipv6CidrBlock[];
  CidrBlockSet?: CidrBlock[];
  OwnerId?: string;
  PeeringOptions?: VpcPeeringConnectionOptionsDescription;
  VpcId?: string;
  Region?: string;
}
export declare const VpcPeeringConnectionStateReasonCode: {
  readonly active: "active";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly expired: "expired";
  readonly failed: "failed";
  readonly initiating_request: "initiating-request";
  readonly pending_acceptance: "pending-acceptance";
  readonly provisioning: "provisioning";
  readonly rejected: "rejected";
};
export type VpcPeeringConnectionStateReasonCode =
  (typeof VpcPeeringConnectionStateReasonCode)[keyof typeof VpcPeeringConnectionStateReasonCode];
export interface VpcPeeringConnectionStateReason {
  Code?: VpcPeeringConnectionStateReasonCode;
  Message?: string;
}
export interface VpcPeeringConnection {
  AccepterVpcInfo?: VpcPeeringConnectionVpcInfo;
  ExpirationTime?: Date;
  RequesterVpcInfo?: VpcPeeringConnectionVpcInfo;
  Status?: VpcPeeringConnectionStateReason;
  Tags?: Tag[];
  VpcPeeringConnectionId?: string;
}
export interface AcceptVpcPeeringConnectionResult {
  VpcPeeringConnection?: VpcPeeringConnection;
}
export interface PortRange {
  From?: number;
  To?: number;
}
export interface AnalysisAclRule {
  Cidr?: string;
  Egress?: boolean;
  PortRange?: PortRange;
  Protocol?: string;
  RuleAction?: string;
  RuleNumber?: number;
}
export interface AnalysisComponent {
  Id?: string;
  Arn?: string;
  Name?: string;
}
export interface RuleOption {
  Keyword?: string;
  Settings?: string[];
}
export interface RuleGroupRuleOptionsPair {
  RuleGroupArn?: string;
  RuleOptions?: RuleOption[];
}
export interface RuleGroupTypePair {
  RuleGroupArn?: string;
  RuleGroupType?: string;
}
export interface AdditionalDetail {
  AdditionalDetailType?: string;
  Component?: AnalysisComponent;
  VpcEndpointService?: AnalysisComponent;
  RuleOptions?: RuleOption[];
  RuleGroupTypePairs?: RuleGroupTypePair[];
  RuleGroupRuleOptionsPairs?: RuleGroupRuleOptionsPair[];
  ServiceName?: string;
  LoadBalancers?: AnalysisComponent[];
}
export interface AnalysisLoadBalancerListener {
  LoadBalancerPort?: number;
  InstancePort?: number;
}
export interface FirewallStatefulRule {
  RuleGroupArn?: string;
  Sources?: string[];
  Destinations?: string[];
  SourcePorts?: PortRange[];
  DestinationPorts?: PortRange[];
  Protocol?: string;
  RuleAction?: string;
  Direction?: string;
}
export interface FirewallStatelessRule {
  RuleGroupArn?: string;
  Sources?: string[];
  Destinations?: string[];
  SourcePorts?: PortRange[];
  DestinationPorts?: PortRange[];
  Protocols?: number[];
  RuleAction?: string;
  Priority?: number;
}
export interface AnalysisLoadBalancerTarget {
  Address?: string;
  AvailabilityZone?: string;
  Instance?: AnalysisComponent;
  Port?: number;
}
export interface AnalysisRouteTableRoute {
  DestinationCidr?: string;
  DestinationPrefixListId?: string;
  EgressOnlyInternetGatewayId?: string;
  GatewayId?: string;
  InstanceId?: string;
  NatGatewayId?: string;
  NetworkInterfaceId?: string;
  Origin?: string;
  TransitGatewayId?: string;
  VpcPeeringConnectionId?: string;
  State?: string;
  CarrierGatewayId?: string;
  CoreNetworkArn?: string;
  LocalGatewayId?: string;
}
export interface AnalysisSecurityGroupRule {
  Cidr?: string;
  Direction?: string;
  SecurityGroupId?: string;
  PortRange?: PortRange;
  PrefixListId?: string;
  Protocol?: string;
}
export interface TransitGatewayRouteTableRoute {
  DestinationCidr?: string;
  State?: string;
  RouteOrigin?: string;
  PrefixListId?: string;
  AttachmentId?: string;
  ResourceId?: string;
  ResourceType?: string;
}
export interface Explanation {
  Acl?: AnalysisComponent;
  AclRule?: AnalysisAclRule;
  Address?: string;
  Addresses?: string[];
  AttachedTo?: AnalysisComponent;
  AvailabilityZones?: string[];
  Cidrs?: string[];
  Component?: AnalysisComponent;
  CustomerGateway?: AnalysisComponent;
  Destination?: AnalysisComponent;
  DestinationVpc?: AnalysisComponent;
  Direction?: string;
  ExplanationCode?: string;
  IngressRouteTable?: AnalysisComponent;
  InternetGateway?: AnalysisComponent;
  LoadBalancerArn?: string;
  ClassicLoadBalancerListener?: AnalysisLoadBalancerListener;
  LoadBalancerListenerPort?: number;
  LoadBalancerTarget?: AnalysisLoadBalancerTarget;
  LoadBalancerTargetGroup?: AnalysisComponent;
  LoadBalancerTargetGroups?: AnalysisComponent[];
  LoadBalancerTargetPort?: number;
  ElasticLoadBalancerListener?: AnalysisComponent;
  MissingComponent?: string;
  NatGateway?: AnalysisComponent;
  NetworkInterface?: AnalysisComponent;
  PacketField?: string;
  VpcPeeringConnection?: AnalysisComponent;
  Port?: number;
  PortRanges?: PortRange[];
  PrefixList?: AnalysisComponent;
  Protocols?: string[];
  RouteTableRoute?: AnalysisRouteTableRoute;
  RouteTable?: AnalysisComponent;
  SecurityGroup?: AnalysisComponent;
  SecurityGroupRule?: AnalysisSecurityGroupRule;
  SecurityGroups?: AnalysisComponent[];
  SourceVpc?: AnalysisComponent;
  State?: string;
  Subnet?: AnalysisComponent;
  SubnetRouteTable?: AnalysisComponent;
  Vpc?: AnalysisComponent;
  VpcEndpoint?: AnalysisComponent;
  VpnConnection?: AnalysisComponent;
  VpnGateway?: AnalysisComponent;
  TransitGateway?: AnalysisComponent;
  TransitGatewayRouteTable?: AnalysisComponent;
  TransitGatewayRouteTableRoute?: TransitGatewayRouteTableRoute;
  TransitGatewayAttachment?: AnalysisComponent;
  ComponentAccount?: string;
  ComponentRegion?: string;
  FirewallStatelessRule?: FirewallStatelessRule;
  FirewallStatefulRule?: FirewallStatefulRule;
}
export interface AnalysisPacketHeader {
  DestinationAddresses?: string[];
  DestinationPortRanges?: PortRange[];
  Protocol?: string;
  SourceAddresses?: string[];
  SourcePortRanges?: PortRange[];
}
export interface PathComponent {
  SequenceNumber?: number;
  AclRule?: AnalysisAclRule;
  AttachedTo?: AnalysisComponent;
  Component?: AnalysisComponent;
  DestinationVpc?: AnalysisComponent;
  OutboundHeader?: AnalysisPacketHeader;
  InboundHeader?: AnalysisPacketHeader;
  RouteTableRoute?: AnalysisRouteTableRoute;
  SecurityGroupRule?: AnalysisSecurityGroupRule;
  SourceVpc?: AnalysisComponent;
  Subnet?: AnalysisComponent;
  Vpc?: AnalysisComponent;
  AdditionalDetails?: AdditionalDetail[];
  TransitGateway?: AnalysisComponent;
  TransitGatewayRouteTableRoute?: TransitGatewayRouteTableRoute;
  Explanations?: Explanation[];
  ElasticLoadBalancerListener?: AnalysisComponent;
  FirewallStatelessRule?: FirewallStatelessRule;
  FirewallStatefulRule?: FirewallStatefulRule;
  ServiceName?: string;
}
export interface AccessScopeAnalysisFinding {
  NetworkInsightsAccessScopeAnalysisId?: string;
  NetworkInsightsAccessScopeId?: string;
  FindingId?: string;
  FindingComponents?: PathComponent[];
}
export declare const Protocol: {
  readonly tcp: "tcp";
  readonly udp: "udp";
};
export type Protocol = (typeof Protocol)[keyof typeof Protocol];
export interface PacketHeaderStatement {
  SourceAddresses?: string[];
  DestinationAddresses?: string[];
  SourcePorts?: string[];
  DestinationPorts?: string[];
  SourcePrefixLists?: string[];
  DestinationPrefixLists?: string[];
  Protocols?: Protocol[];
}
export interface ResourceStatement {
  Resources?: string[];
  ResourceTypes?: string[];
}
export interface PathStatement {
  PacketHeaderStatement?: PacketHeaderStatement;
  ResourceStatement?: ResourceStatement;
}
export interface ThroughResourcesStatement {
  ResourceStatement?: ResourceStatement;
}
export interface AccessScopePath {
  Source?: PathStatement;
  Destination?: PathStatement;
  ThroughResources?: ThroughResourcesStatement[];
}
export interface PacketHeaderStatementRequest {
  SourceAddresses?: string[];
  DestinationAddresses?: string[];
  SourcePorts?: string[];
  DestinationPorts?: string[];
  SourcePrefixLists?: string[];
  DestinationPrefixLists?: string[];
  Protocols?: Protocol[];
}
export interface ResourceStatementRequest {
  Resources?: string[];
  ResourceTypes?: string[];
}
export interface PathStatementRequest {
  PacketHeaderStatement?: PacketHeaderStatementRequest;
  ResourceStatement?: ResourceStatementRequest;
}
export interface ThroughResourcesStatementRequest {
  ResourceStatement?: ResourceStatementRequest;
}
export interface AccessScopePathRequest {
  Source?: PathStatementRequest;
  Destination?: PathStatementRequest;
  ThroughResources?: ThroughResourcesStatementRequest[];
}
export interface AccountAttributeValue {
  AttributeValue?: string;
}
export interface AccountAttribute {
  AttributeName?: string;
  AttributeValues?: AccountAttributeValue[];
}
export declare const AccountAttributeName: {
  readonly default_vpc: "default-vpc";
  readonly supported_platforms: "supported-platforms";
};
export type AccountAttributeName =
  (typeof AccountAttributeName)[keyof typeof AccountAttributeName];
export declare const InstanceHealthStatus: {
  readonly HEALTHY_STATUS: "healthy";
  readonly UNHEALTHY_STATUS: "unhealthy";
};
export type InstanceHealthStatus =
  (typeof InstanceHealthStatus)[keyof typeof InstanceHealthStatus];
export interface ActiveInstance {
  InstanceId?: string;
  InstanceType?: string;
  SpotInstanceRequestId?: string;
  InstanceHealth?: InstanceHealthStatus;
}
export declare const ActivityStatus: {
  readonly ERROR: "error";
  readonly FULFILLED: "fulfilled";
  readonly PENDING_FULFILLMENT: "pending_fulfillment";
  readonly PENDING_TERMINATION: "pending_termination";
};
export type ActivityStatus =
  (typeof ActivityStatus)[keyof typeof ActivityStatus];
export declare const PrincipalType: {
  readonly Account: "Account";
  readonly All: "All";
  readonly OrganizationUnit: "OrganizationUnit";
  readonly Role: "Role";
  readonly Service: "Service";
  readonly User: "User";
};
export type PrincipalType = (typeof PrincipalType)[keyof typeof PrincipalType];
export interface AddedPrincipal {
  PrincipalType?: PrincipalType;
  Principal?: string;
  ServicePermissionId?: string;
  ServiceId?: string;
}
export interface AddIpamOperatingRegion {
  RegionName?: string;
}
export interface AddPrefixListEntry {
  Cidr: string | undefined;
  Description?: string;
}
export declare const DomainType: {
  readonly standard: "standard";
  readonly vpc: "vpc";
};
export type DomainType = (typeof DomainType)[keyof typeof DomainType];
export interface Address {
  InstanceId?: string;
  PublicIp?: string;
  AllocationId?: string;
  AssociationId?: string;
  Domain?: DomainType;
  NetworkInterfaceId?: string;
  NetworkInterfaceOwnerId?: string;
  PrivateIpAddress?: string;
  Tags?: Tag[];
  PublicIpv4Pool?: string;
  NetworkBorderGroup?: string;
  CustomerOwnedIp?: string;
  CustomerOwnedIpv4Pool?: string;
  CarrierIp?: string;
}
export interface PtrUpdateStatus {
  Value?: string;
  Status?: string;
  Reason?: string;
}
export interface AddressAttribute {
  PublicIp?: string;
  AllocationId?: string;
  PtrRecord?: string;
  PtrRecordUpdate?: PtrUpdateStatus;
}
export declare const AddressAttributeName: {
  readonly domain_name: "domain-name";
};
export type AddressAttributeName =
  (typeof AddressAttributeName)[keyof typeof AddressAttributeName];
export declare const AddressFamily: {
  readonly ipv4: "ipv4";
  readonly ipv6: "ipv6";
};
export type AddressFamily = (typeof AddressFamily)[keyof typeof AddressFamily];
export interface AdvertiseByoipCidrRequest {
  Cidr: string | undefined;
  Asn?: string;
  DryRun?: boolean;
  NetworkBorderGroup?: string;
}
export declare const AsnAssociationState: {
  readonly associated: "associated";
  readonly disassociated: "disassociated";
  readonly failed_association: "failed-association";
  readonly failed_disassociation: "failed-disassociation";
  readonly pending_association: "pending-association";
  readonly pending_disassociation: "pending-disassociation";
};
export type AsnAssociationState =
  (typeof AsnAssociationState)[keyof typeof AsnAssociationState];
export interface AsnAssociation {
  Asn?: string;
  Cidr?: string;
  StatusMessage?: string;
  State?: AsnAssociationState;
}
export declare const ByoipCidrState: {
  readonly advertised: "advertised";
  readonly deprovisioned: "deprovisioned";
  readonly failed_deprovision: "failed-deprovision";
  readonly failed_provision: "failed-provision";
  readonly pending_deprovision: "pending-deprovision";
  readonly pending_provision: "pending-provision";
  readonly provisioned: "provisioned";
  readonly provisioned_not_publicly_advertisable: "provisioned-not-publicly-advertisable";
};
export type ByoipCidrState =
  (typeof ByoipCidrState)[keyof typeof ByoipCidrState];
export interface ByoipCidr {
  Cidr?: string;
  Description?: string;
  AsnAssociations?: AsnAssociation[];
  StatusMessage?: string;
  State?: ByoipCidrState;
  NetworkBorderGroup?: string;
}
export interface AdvertiseByoipCidrResult {
  ByoipCidr?: ByoipCidr;
}
export declare const Affinity: {
  readonly default: "default";
  readonly host: "host";
};
export type Affinity = (typeof Affinity)[keyof typeof Affinity];
export interface AllocateAddressRequest {
  Domain?: DomainType;
  Address?: string;
  PublicIpv4Pool?: string;
  NetworkBorderGroup?: string;
  CustomerOwnedIpv4Pool?: string;
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
}
export interface AllocateAddressResult {
  PublicIp?: string;
  AllocationId?: string;
  PublicIpv4Pool?: string;
  NetworkBorderGroup?: string;
  Domain?: DomainType;
  CustomerOwnedIp?: string;
  CustomerOwnedIpv4Pool?: string;
  CarrierIp?: string;
}
export declare const AutoPlacement: {
  readonly off: "off";
  readonly on: "on";
};
export type AutoPlacement = (typeof AutoPlacement)[keyof typeof AutoPlacement];
export declare const HostMaintenance: {
  readonly off: "off";
  readonly on: "on";
};
export type HostMaintenance =
  (typeof HostMaintenance)[keyof typeof HostMaintenance];
export declare const HostRecovery: {
  readonly off: "off";
  readonly on: "on";
};
export type HostRecovery = (typeof HostRecovery)[keyof typeof HostRecovery];
export interface AllocateHostsRequest {
  AutoPlacement?: AutoPlacement;
  AvailabilityZone: string | undefined;
  ClientToken?: string;
  InstanceType?: string;
  InstanceFamily?: string;
  Quantity?: number;
  TagSpecifications?: TagSpecification[];
  HostRecovery?: HostRecovery;
  OutpostArn?: string;
  HostMaintenance?: HostMaintenance;
  AssetIds?: string[];
}
export interface AllocateHostsResult {
  HostIds?: string[];
}
export interface AllocateIpamPoolCidrRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  Cidr?: string;
  NetmaskLength?: number;
  ClientToken?: string;
  Description?: string;
  PreviewNextCidr?: boolean;
  AllowedCidrs?: string[];
  DisallowedCidrs?: string[];
}
export declare const IpamPoolAllocationResourceType: {
  readonly custom: "custom";
  readonly ec2_public_ipv4_pool: "ec2-public-ipv4-pool";
  readonly ipam_pool: "ipam-pool";
  readonly subnet: "subnet";
  readonly vpc: "vpc";
};
export type IpamPoolAllocationResourceType =
  (typeof IpamPoolAllocationResourceType)[keyof typeof IpamPoolAllocationResourceType];
export interface IpamPoolAllocation {
  Cidr?: string;
  IpamPoolAllocationId?: string;
  Description?: string;
  ResourceId?: string;
  ResourceType?: IpamPoolAllocationResourceType;
  ResourceRegion?: string;
  ResourceOwner?: string;
}
export interface AllocateIpamPoolCidrResult {
  IpamPoolAllocation?: IpamPoolAllocation;
}
export declare const AllocationState: {
  readonly available: "available";
  readonly pending: "pending";
  readonly permanent_failure: "permanent-failure";
  readonly released: "released";
  readonly released_permanent_failure: "released-permanent-failure";
  readonly under_assessment: "under-assessment";
};
export type AllocationState =
  (typeof AllocationState)[keyof typeof AllocationState];
export declare const AllocationStrategy: {
  readonly CAPACITY_OPTIMIZED: "capacityOptimized";
  readonly CAPACITY_OPTIMIZED_PRIORITIZED: "capacityOptimizedPrioritized";
  readonly DIVERSIFIED: "diversified";
  readonly LOWEST_PRICE: "lowestPrice";
  readonly PRICE_CAPACITY_OPTIMIZED: "priceCapacityOptimized";
};
export type AllocationStrategy =
  (typeof AllocationStrategy)[keyof typeof AllocationStrategy];
export declare const AllocationType: {
  readonly used: "used";
};
export type AllocationType =
  (typeof AllocationType)[keyof typeof AllocationType];
export interface AllowedPrincipal {
  PrincipalType?: PrincipalType;
  Principal?: string;
  ServicePermissionId?: string;
  Tags?: Tag[];
  ServiceId?: string;
}
export declare const AllowsMultipleInstanceTypes: {
  readonly off: "off";
  readonly on: "on";
};
export type AllowsMultipleInstanceTypes =
  (typeof AllowsMultipleInstanceTypes)[keyof typeof AllowsMultipleInstanceTypes];
export interface AlternatePathHint {
  ComponentId?: string;
  ComponentArn?: string;
}
export interface ApplySecurityGroupsToClientVpnTargetNetworkRequest {
  ClientVpnEndpointId: string | undefined;
  VpcId: string | undefined;
  SecurityGroupIds: string[] | undefined;
  DryRun?: boolean;
}
export interface ApplySecurityGroupsToClientVpnTargetNetworkResult {
  SecurityGroupIds?: string[];
}
export interface AssignIpv6AddressesRequest {
  Ipv6AddressCount?: number;
  Ipv6Addresses?: string[];
  Ipv6PrefixCount?: number;
  Ipv6Prefixes?: string[];
  NetworkInterfaceId: string | undefined;
}
export interface AssignIpv6AddressesResult {
  AssignedIpv6Addresses?: string[];
  AssignedIpv6Prefixes?: string[];
  NetworkInterfaceId?: string;
}
export interface AssignPrivateIpAddressesRequest {
  AllowReassignment?: boolean;
  NetworkInterfaceId: string | undefined;
  PrivateIpAddresses?: string[];
  SecondaryPrivateIpAddressCount?: number;
  Ipv4Prefixes?: string[];
  Ipv4PrefixCount?: number;
}
export interface Ipv4PrefixSpecification {
  Ipv4Prefix?: string;
}
export interface AssignedPrivateIpAddress {
  PrivateIpAddress?: string;
}
export interface AssignPrivateIpAddressesResult {
  NetworkInterfaceId?: string;
  AssignedPrivateIpAddresses?: AssignedPrivateIpAddress[];
  AssignedIpv4Prefixes?: Ipv4PrefixSpecification[];
}
export interface AssignPrivateNatGatewayAddressRequest {
  NatGatewayId: string | undefined;
  PrivateIpAddresses?: string[];
  PrivateIpAddressCount?: number;
  DryRun?: boolean;
}
export declare const NatGatewayAddressStatus: {
  readonly ASSIGNING: "assigning";
  readonly ASSOCIATING: "associating";
  readonly DISASSOCIATING: "disassociating";
  readonly FAILED: "failed";
  readonly SUCCEEDED: "succeeded";
  readonly UNASSIGNING: "unassigning";
};
export type NatGatewayAddressStatus =
  (typeof NatGatewayAddressStatus)[keyof typeof NatGatewayAddressStatus];
export interface NatGatewayAddress {
  AllocationId?: string;
  NetworkInterfaceId?: string;
  PrivateIp?: string;
  PublicIp?: string;
  AssociationId?: string;
  IsPrimary?: boolean;
  FailureMessage?: string;
  Status?: NatGatewayAddressStatus;
}
export interface AssignPrivateNatGatewayAddressResult {
  NatGatewayId?: string;
  NatGatewayAddresses?: NatGatewayAddress[];
}
export interface AssociateAddressRequest {
  AllocationId?: string;
  InstanceId?: string;
  PublicIp?: string;
  AllowReassociation?: boolean;
  DryRun?: boolean;
  NetworkInterfaceId?: string;
  PrivateIpAddress?: string;
}
export interface AssociateAddressResult {
  AssociationId?: string;
}
export interface AssociateClientVpnTargetNetworkRequest {
  ClientVpnEndpointId: string | undefined;
  SubnetId: string | undefined;
  ClientToken?: string;
  DryRun?: boolean;
}
export declare const AssociationStatusCode: {
  readonly associated: "associated";
  readonly associating: "associating";
  readonly association_failed: "association-failed";
  readonly disassociated: "disassociated";
  readonly disassociating: "disassociating";
};
export type AssociationStatusCode =
  (typeof AssociationStatusCode)[keyof typeof AssociationStatusCode];
export interface AssociationStatus {
  Code?: AssociationStatusCode;
  Message?: string;
}
export interface AssociateClientVpnTargetNetworkResult {
  AssociationId?: string;
  Status?: AssociationStatus;
}
export interface AssociateDhcpOptionsRequest {
  DhcpOptionsId: string | undefined;
  VpcId: string | undefined;
  DryRun?: boolean;
}
export interface AssociateEnclaveCertificateIamRoleRequest {
  CertificateArn: string | undefined;
  RoleArn: string | undefined;
  DryRun?: boolean;
}
export interface AssociateEnclaveCertificateIamRoleResult {
  CertificateS3BucketName?: string;
  CertificateS3ObjectKey?: string;
  EncryptionKmsKeyId?: string;
}
export interface IamInstanceProfileSpecification {
  Arn?: string;
  Name?: string;
}
export interface AssociateIamInstanceProfileRequest {
  IamInstanceProfile: IamInstanceProfileSpecification | undefined;
  InstanceId: string | undefined;
}
export interface IamInstanceProfile {
  Arn?: string;
  Id?: string;
}
export declare const IamInstanceProfileAssociationState: {
  readonly ASSOCIATED: "associated";
  readonly ASSOCIATING: "associating";
  readonly DISASSOCIATED: "disassociated";
  readonly DISASSOCIATING: "disassociating";
};
export type IamInstanceProfileAssociationState =
  (typeof IamInstanceProfileAssociationState)[keyof typeof IamInstanceProfileAssociationState];
export interface IamInstanceProfileAssociation {
  AssociationId?: string;
  InstanceId?: string;
  IamInstanceProfile?: IamInstanceProfile;
  State?: IamInstanceProfileAssociationState;
  Timestamp?: Date;
}
export interface AssociateIamInstanceProfileResult {
  IamInstanceProfileAssociation?: IamInstanceProfileAssociation;
}
export interface InstanceEventWindowAssociationRequest {
  InstanceIds?: string[];
  InstanceTags?: Tag[];
  DedicatedHostIds?: string[];
}
export interface AssociateInstanceEventWindowRequest {
  DryRun?: boolean;
  InstanceEventWindowId: string | undefined;
  AssociationTarget: InstanceEventWindowAssociationRequest | undefined;
}
export interface InstanceEventWindowAssociationTarget {
  InstanceIds?: string[];
  Tags?: Tag[];
  DedicatedHostIds?: string[];
}
export declare const InstanceEventWindowState: {
  readonly active: "active";
  readonly creating: "creating";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
};
export type InstanceEventWindowState =
  (typeof InstanceEventWindowState)[keyof typeof InstanceEventWindowState];
export declare const WeekDay: {
  readonly friday: "friday";
  readonly monday: "monday";
  readonly saturday: "saturday";
  readonly sunday: "sunday";
  readonly thursday: "thursday";
  readonly tuesday: "tuesday";
  readonly wednesday: "wednesday";
};
export type WeekDay = (typeof WeekDay)[keyof typeof WeekDay];
export interface InstanceEventWindowTimeRange {
  StartWeekDay?: WeekDay;
  StartHour?: number;
  EndWeekDay?: WeekDay;
  EndHour?: number;
}
export interface InstanceEventWindow {
  InstanceEventWindowId?: string;
  TimeRanges?: InstanceEventWindowTimeRange[];
  Name?: string;
  CronExpression?: string;
  AssociationTarget?: InstanceEventWindowAssociationTarget;
  State?: InstanceEventWindowState;
  Tags?: Tag[];
}
export interface AssociateInstanceEventWindowResult {
  InstanceEventWindow?: InstanceEventWindow;
}
export interface AssociateIpamByoasnRequest {
  DryRun?: boolean;
  Asn: string | undefined;
  Cidr: string | undefined;
}
export interface AssociateIpamByoasnResult {
  AsnAssociation?: AsnAssociation;
}
export interface AssociateIpamResourceDiscoveryRequest {
  DryRun?: boolean;
  IpamId: string | undefined;
  IpamResourceDiscoveryId: string | undefined;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
}
export declare const IpamAssociatedResourceDiscoveryStatus: {
  readonly ACTIVE: "active";
  readonly NOT_FOUND: "not-found";
};
export type IpamAssociatedResourceDiscoveryStatus =
  (typeof IpamAssociatedResourceDiscoveryStatus)[keyof typeof IpamAssociatedResourceDiscoveryStatus];
export declare const IpamResourceDiscoveryAssociationState: {
  readonly ASSOCIATE_COMPLETE: "associate-complete";
  readonly ASSOCIATE_FAILED: "associate-failed";
  readonly ASSOCIATE_IN_PROGRESS: "associate-in-progress";
  readonly DISASSOCIATE_COMPLETE: "disassociate-complete";
  readonly DISASSOCIATE_FAILED: "disassociate-failed";
  readonly DISASSOCIATE_IN_PROGRESS: "disassociate-in-progress";
  readonly ISOLATE_COMPLETE: "isolate-complete";
  readonly ISOLATE_IN_PROGRESS: "isolate-in-progress";
  readonly RESTORE_IN_PROGRESS: "restore-in-progress";
};
export type IpamResourceDiscoveryAssociationState =
  (typeof IpamResourceDiscoveryAssociationState)[keyof typeof IpamResourceDiscoveryAssociationState];
export interface IpamResourceDiscoveryAssociation {
  OwnerId?: string;
  IpamResourceDiscoveryAssociationId?: string;
  IpamResourceDiscoveryAssociationArn?: string;
  IpamResourceDiscoveryId?: string;
  IpamId?: string;
  IpamArn?: string;
  IpamRegion?: string;
  IsDefault?: boolean;
  ResourceDiscoveryStatus?: IpamAssociatedResourceDiscoveryStatus;
  State?: IpamResourceDiscoveryAssociationState;
  Tags?: Tag[];
}
export interface AssociateIpamResourceDiscoveryResult {
  IpamResourceDiscoveryAssociation?: IpamResourceDiscoveryAssociation;
}
export interface AssociateNatGatewayAddressRequest {
  NatGatewayId: string | undefined;
  AllocationIds: string[] | undefined;
  PrivateIpAddresses?: string[];
  DryRun?: boolean;
}
export interface AssociateNatGatewayAddressResult {
  NatGatewayId?: string;
  NatGatewayAddresses?: NatGatewayAddress[];
}
export interface AssociateRouteTableRequest {
  DryRun?: boolean;
  RouteTableId: string | undefined;
  SubnetId?: string;
  GatewayId?: string;
}
export declare const RouteTableAssociationStateCode: {
  readonly associated: "associated";
  readonly associating: "associating";
  readonly disassociated: "disassociated";
  readonly disassociating: "disassociating";
  readonly failed: "failed";
};
export type RouteTableAssociationStateCode =
  (typeof RouteTableAssociationStateCode)[keyof typeof RouteTableAssociationStateCode];
export interface RouteTableAssociationState {
  State?: RouteTableAssociationStateCode;
  StatusMessage?: string;
}
export interface AssociateRouteTableResult {
  AssociationId?: string;
  AssociationState?: RouteTableAssociationState;
}
export interface AssociateSubnetCidrBlockRequest {
  Ipv6CidrBlock?: string;
  SubnetId: string | undefined;
  Ipv6IpamPoolId?: string;
  Ipv6NetmaskLength?: number;
}
export declare const SubnetCidrBlockStateCode: {
  readonly associated: "associated";
  readonly associating: "associating";
  readonly disassociated: "disassociated";
  readonly disassociating: "disassociating";
  readonly failed: "failed";
  readonly failing: "failing";
};
export type SubnetCidrBlockStateCode =
  (typeof SubnetCidrBlockStateCode)[keyof typeof SubnetCidrBlockStateCode];
export interface SubnetCidrBlockState {
  State?: SubnetCidrBlockStateCode;
  StatusMessage?: string;
}
export interface SubnetIpv6CidrBlockAssociation {
  AssociationId?: string;
  Ipv6CidrBlock?: string;
  Ipv6CidrBlockState?: SubnetCidrBlockState;
}
export interface AssociateSubnetCidrBlockResult {
  Ipv6CidrBlockAssociation?: SubnetIpv6CidrBlockAssociation;
  SubnetId?: string;
}
export interface AssociateTransitGatewayMulticastDomainRequest {
  TransitGatewayMulticastDomainId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  SubnetIds: string[] | undefined;
  DryRun?: boolean;
}
export interface AssociateTransitGatewayMulticastDomainResult {
  Associations?: TransitGatewayMulticastDomainAssociations;
}
export interface AssociateTransitGatewayPolicyTableRequest {
  TransitGatewayPolicyTableId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export declare const TransitGatewayAssociationState: {
  readonly associated: "associated";
  readonly associating: "associating";
  readonly disassociated: "disassociated";
  readonly disassociating: "disassociating";
};
export type TransitGatewayAssociationState =
  (typeof TransitGatewayAssociationState)[keyof typeof TransitGatewayAssociationState];
export interface TransitGatewayPolicyTableAssociation {
  TransitGatewayPolicyTableId?: string;
  TransitGatewayAttachmentId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType;
  State?: TransitGatewayAssociationState;
}
export interface AssociateTransitGatewayPolicyTableResult {
  Association?: TransitGatewayPolicyTableAssociation;
}
export interface AssociateTransitGatewayRouteTableRequest {
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface TransitGatewayAssociation {
  TransitGatewayRouteTableId?: string;
  TransitGatewayAttachmentId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType;
  State?: TransitGatewayAssociationState;
}
export interface AssociateTransitGatewayRouteTableResult {
  Association?: TransitGatewayAssociation;
}
export interface AssociateTrunkInterfaceRequest {
  BranchInterfaceId: string | undefined;
  TrunkInterfaceId: string | undefined;
  VlanId?: number;
  GreKey?: number;
  ClientToken?: string;
  DryRun?: boolean;
}
export declare const InterfaceProtocolType: {
  readonly GRE: "GRE";
  readonly VLAN: "VLAN";
};
export type InterfaceProtocolType =
  (typeof InterfaceProtocolType)[keyof typeof InterfaceProtocolType];
export interface TrunkInterfaceAssociation {
  AssociationId?: string;
  BranchInterfaceId?: string;
  TrunkInterfaceId?: string;
  InterfaceProtocol?: InterfaceProtocolType;
  VlanId?: number;
  GreKey?: number;
  Tags?: Tag[];
}
export interface AssociateTrunkInterfaceResult {
  InterfaceAssociation?: TrunkInterfaceAssociation;
  ClientToken?: string;
}
export interface AssociateVpcCidrBlockRequest {
  AmazonProvidedIpv6CidrBlock?: boolean;
  CidrBlock?: string;
  VpcId: string | undefined;
  Ipv6CidrBlockNetworkBorderGroup?: string;
  Ipv6Pool?: string;
  Ipv6CidrBlock?: string;
  Ipv4IpamPoolId?: string;
  Ipv4NetmaskLength?: number;
  Ipv6IpamPoolId?: string;
  Ipv6NetmaskLength?: number;
}
export declare const VpcCidrBlockStateCode: {
  readonly associated: "associated";
  readonly associating: "associating";
  readonly disassociated: "disassociated";
  readonly disassociating: "disassociating";
  readonly failed: "failed";
  readonly failing: "failing";
};
export type VpcCidrBlockStateCode =
  (typeof VpcCidrBlockStateCode)[keyof typeof VpcCidrBlockStateCode];
export interface VpcCidrBlockState {
  State?: VpcCidrBlockStateCode;
  StatusMessage?: string;
}
export interface VpcCidrBlockAssociation {
  AssociationId?: string;
  CidrBlock?: string;
  CidrBlockState?: VpcCidrBlockState;
}
export interface VpcIpv6CidrBlockAssociation {
  AssociationId?: string;
  Ipv6CidrBlock?: string;
  Ipv6CidrBlockState?: VpcCidrBlockState;
  NetworkBorderGroup?: string;
  Ipv6Pool?: string;
}
export interface AssociateVpcCidrBlockResult {
  Ipv6CidrBlockAssociation?: VpcIpv6CidrBlockAssociation;
  CidrBlockAssociation?: VpcCidrBlockAssociation;
  VpcId?: string;
}
export interface AttachClassicLinkVpcRequest {
  DryRun?: boolean;
  Groups: string[] | undefined;
  InstanceId: string | undefined;
  VpcId: string | undefined;
}
export interface AttachClassicLinkVpcResult {
  Return?: boolean;
}
export interface AttachInternetGatewayRequest {
  DryRun?: boolean;
  InternetGatewayId: string | undefined;
  VpcId: string | undefined;
}
export interface EnaSrdUdpSpecification {
  EnaSrdUdpEnabled?: boolean;
}
export interface EnaSrdSpecification {
  EnaSrdEnabled?: boolean;
  EnaSrdUdpSpecification?: EnaSrdUdpSpecification;
}
export interface AttachNetworkInterfaceRequest {
  DeviceIndex: number | undefined;
  DryRun?: boolean;
  InstanceId: string | undefined;
  NetworkInterfaceId: string | undefined;
  NetworkCardIndex?: number;
  EnaSrdSpecification?: EnaSrdSpecification;
}
export interface AttachNetworkInterfaceResult {
  AttachmentId?: string;
  NetworkCardIndex?: number;
}
export interface AttachVerifiedAccessTrustProviderRequest {
  VerifiedAccessInstanceId: string | undefined;
  VerifiedAccessTrustProviderId: string | undefined;
  ClientToken?: string;
  DryRun?: boolean;
}
export declare const DeviceTrustProviderType: {
  readonly crowdstrike: "crowdstrike";
  readonly jamf: "jamf";
  readonly jumpcloud: "jumpcloud";
};
export type DeviceTrustProviderType =
  (typeof DeviceTrustProviderType)[keyof typeof DeviceTrustProviderType];
export declare const TrustProviderType: {
  readonly device: "device";
  readonly user: "user";
};
export type TrustProviderType =
  (typeof TrustProviderType)[keyof typeof TrustProviderType];
export declare const UserTrustProviderType: {
  readonly iam_identity_center: "iam-identity-center";
  readonly oidc: "oidc";
};
export type UserTrustProviderType =
  (typeof UserTrustProviderType)[keyof typeof UserTrustProviderType];
export interface VerifiedAccessTrustProviderCondensed {
  VerifiedAccessTrustProviderId?: string;
  Description?: string;
  TrustProviderType?: TrustProviderType;
  UserTrustProviderType?: UserTrustProviderType;
  DeviceTrustProviderType?: DeviceTrustProviderType;
}
export interface VerifiedAccessInstance {
  VerifiedAccessInstanceId?: string;
  Description?: string;
  VerifiedAccessTrustProviders?: VerifiedAccessTrustProviderCondensed[];
  CreationTime?: string;
  LastUpdatedTime?: string;
  Tags?: Tag[];
  FipsEnabled?: boolean;
}
export interface DeviceOptions {
  TenantId?: string;
  PublicSigningKeyUrl?: string;
}
export interface OidcOptions {
  Issuer?: string;
  AuthorizationEndpoint?: string;
  TokenEndpoint?: string;
  UserInfoEndpoint?: string;
  ClientId?: string;
  ClientSecret?: string;
  Scope?: string;
}
export interface VerifiedAccessSseSpecificationResponse {
  CustomerManagedKeyEnabled?: boolean;
  KmsKeyArn?: string;
}
export interface VerifiedAccessTrustProvider {
  VerifiedAccessTrustProviderId?: string;
  Description?: string;
  TrustProviderType?: TrustProviderType;
  UserTrustProviderType?: UserTrustProviderType;
  DeviceTrustProviderType?: DeviceTrustProviderType;
  OidcOptions?: OidcOptions;
  DeviceOptions?: DeviceOptions;
  PolicyReferenceName?: string;
  CreationTime?: string;
  LastUpdatedTime?: string;
  Tags?: Tag[];
  SseSpecification?: VerifiedAccessSseSpecificationResponse;
}
export interface AttachVerifiedAccessTrustProviderResult {
  VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider;
  VerifiedAccessInstance?: VerifiedAccessInstance;
}
export interface AttachVolumeRequest {
  Device: string | undefined;
  InstanceId: string | undefined;
  VolumeId: string | undefined;
  DryRun?: boolean;
}
export declare const VolumeAttachmentState: {
  readonly attached: "attached";
  readonly attaching: "attaching";
  readonly busy: "busy";
  readonly detached: "detached";
  readonly detaching: "detaching";
};
export type VolumeAttachmentState =
  (typeof VolumeAttachmentState)[keyof typeof VolumeAttachmentState];
export interface VolumeAttachment {
  AttachTime?: Date;
  Device?: string;
  InstanceId?: string;
  State?: VolumeAttachmentState;
  VolumeId?: string;
  DeleteOnTermination?: boolean;
  AssociatedResource?: string;
  InstanceOwningService?: string;
}
export interface AttachVpnGatewayRequest {
  VpcId: string | undefined;
  VpnGatewayId: string | undefined;
  DryRun?: boolean;
}
export declare const AttachmentStatus: {
  readonly attached: "attached";
  readonly attaching: "attaching";
  readonly detached: "detached";
  readonly detaching: "detaching";
};
export type AttachmentStatus =
  (typeof AttachmentStatus)[keyof typeof AttachmentStatus];
export interface VpcAttachment {
  State?: AttachmentStatus;
  VpcId?: string;
}
export interface AttachVpnGatewayResult {
  VpcAttachment?: VpcAttachment;
}
export interface AuthorizeClientVpnIngressRequest {
  ClientVpnEndpointId: string | undefined;
  TargetNetworkCidr: string | undefined;
  AccessGroupId?: string;
  AuthorizeAllGroups?: boolean;
  Description?: string;
  ClientToken?: string;
  DryRun?: boolean;
}
export declare const ClientVpnAuthorizationRuleStatusCode: {
  readonly active: "active";
  readonly authorizing: "authorizing";
  readonly failed: "failed";
  readonly revoking: "revoking";
};
export type ClientVpnAuthorizationRuleStatusCode =
  (typeof ClientVpnAuthorizationRuleStatusCode)[keyof typeof ClientVpnAuthorizationRuleStatusCode];
export interface ClientVpnAuthorizationRuleStatus {
  Code?: ClientVpnAuthorizationRuleStatusCode;
  Message?: string;
}
export interface AuthorizeClientVpnIngressResult {
  Status?: ClientVpnAuthorizationRuleStatus;
}
export interface IpRange {
  CidrIp?: string;
  Description?: string;
}
export interface Ipv6Range {
  CidrIpv6?: string;
  Description?: string;
}
export interface PrefixListId {
  Description?: string;
  PrefixListId?: string;
}
export interface UserIdGroupPair {
  Description?: string;
  GroupId?: string;
  GroupName?: string;
  PeeringStatus?: string;
  UserId?: string;
  VpcId?: string;
  VpcPeeringConnectionId?: string;
}
export interface IpPermission {
  FromPort?: number;
  IpProtocol?: string;
  IpRanges?: IpRange[];
  Ipv6Ranges?: Ipv6Range[];
  PrefixListIds?: PrefixListId[];
  ToPort?: number;
  UserIdGroupPairs?: UserIdGroupPair[];
}
export interface AuthorizeSecurityGroupEgressRequest {
  DryRun?: boolean;
  GroupId: string | undefined;
  IpPermissions?: IpPermission[];
  TagSpecifications?: TagSpecification[];
  CidrIp?: string;
  FromPort?: number;
  IpProtocol?: string;
  ToPort?: number;
  SourceSecurityGroupName?: string;
  SourceSecurityGroupOwnerId?: string;
}
export interface ReferencedSecurityGroup {
  GroupId?: string;
  PeeringStatus?: string;
  UserId?: string;
  VpcId?: string;
  VpcPeeringConnectionId?: string;
}
export interface SecurityGroupRule {
  SecurityGroupRuleId?: string;
  GroupId?: string;
  GroupOwnerId?: string;
  IsEgress?: boolean;
  IpProtocol?: string;
  FromPort?: number;
  ToPort?: number;
  CidrIpv4?: string;
  CidrIpv6?: string;
  PrefixListId?: string;
  ReferencedGroupInfo?: ReferencedSecurityGroup;
  Description?: string;
  Tags?: Tag[];
}
export interface AuthorizeSecurityGroupEgressResult {
  Return?: boolean;
  SecurityGroupRules?: SecurityGroupRule[];
}
export interface AuthorizeSecurityGroupIngressRequest {
  CidrIp?: string;
  FromPort?: number;
  GroupId?: string;
  GroupName?: string;
  IpPermissions?: IpPermission[];
  IpProtocol?: string;
  SourceSecurityGroupName?: string;
  SourceSecurityGroupOwnerId?: string;
  ToPort?: number;
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
}
export interface AuthorizeSecurityGroupIngressResult {
  Return?: boolean;
  SecurityGroupRules?: SecurityGroupRule[];
}
export interface S3Storage {
  AWSAccessKeyId?: string;
  Bucket?: string;
  Prefix?: string;
  UploadPolicy?: Uint8Array;
  UploadPolicySignature?: string;
}
export interface Storage {
  S3?: S3Storage;
}
export interface BundleInstanceRequest {
  InstanceId: string | undefined;
  Storage: Storage | undefined;
  DryRun?: boolean;
}
export interface BundleTaskError {
  Code?: string;
  Message?: string;
}
export declare const BundleTaskState: {
  readonly bundling: "bundling";
  readonly cancelling: "cancelling";
  readonly complete: "complete";
  readonly failed: "failed";
  readonly pending: "pending";
  readonly storing: "storing";
  readonly waiting_for_shutdown: "waiting-for-shutdown";
};
export type BundleTaskState =
  (typeof BundleTaskState)[keyof typeof BundleTaskState];
export interface BundleTask {
  BundleId?: string;
  BundleTaskError?: BundleTaskError;
  InstanceId?: string;
  Progress?: string;
  StartTime?: Date;
  State?: BundleTaskState;
  Storage?: Storage;
  UpdateTime?: Date;
}
export interface BundleInstanceResult {
  BundleTask?: BundleTask;
}
export interface CancelBundleTaskRequest {
  BundleId: string | undefined;
  DryRun?: boolean;
}
export interface CancelBundleTaskResult {
  BundleTask?: BundleTask;
}
export interface CancelCapacityReservationRequest {
  CapacityReservationId: string | undefined;
  DryRun?: boolean;
}
export interface CancelCapacityReservationResult {
  Return?: boolean;
}
export interface CancelCapacityReservationFleetsRequest {
  DryRun?: boolean;
  CapacityReservationFleetIds: string[] | undefined;
}
export interface CancelCapacityReservationFleetError {
  Code?: string;
  Message?: string;
}
export interface FailedCapacityReservationFleetCancellationResult {
  CapacityReservationFleetId?: string;
  CancelCapacityReservationFleetError?: CancelCapacityReservationFleetError;
}
export declare const CapacityReservationFleetState: {
  readonly ACTIVE: "active";
  readonly CANCELLED: "cancelled";
  readonly CANCELLING: "cancelling";
  readonly EXPIRED: "expired";
  readonly EXPIRING: "expiring";
  readonly FAILED: "failed";
  readonly MODIFYING: "modifying";
  readonly PARTIALLY_FULFILLED: "partially_fulfilled";
  readonly SUBMITTED: "submitted";
};
export type CapacityReservationFleetState =
  (typeof CapacityReservationFleetState)[keyof typeof CapacityReservationFleetState];
export interface CapacityReservationFleetCancellationState {
  CurrentFleetState?: CapacityReservationFleetState;
  PreviousFleetState?: CapacityReservationFleetState;
  CapacityReservationFleetId?: string;
}
export interface CancelCapacityReservationFleetsResult {
  SuccessfulFleetCancellations?: CapacityReservationFleetCancellationState[];
  FailedFleetCancellations?: FailedCapacityReservationFleetCancellationResult[];
}
export interface CancelConversionRequest {
  ConversionTaskId: string | undefined;
  DryRun?: boolean;
  ReasonMessage?: string;
}
export interface CancelExportTaskRequest {
  ExportTaskId: string | undefined;
}
export interface CancelImageLaunchPermissionRequest {
  ImageId: string | undefined;
  DryRun?: boolean;
}
export interface CancelImageLaunchPermissionResult {
  Return?: boolean;
}
export interface CancelImportTaskRequest {
  CancelReason?: string;
  DryRun?: boolean;
  ImportTaskId?: string;
}
export interface CancelImportTaskResult {
  ImportTaskId?: string;
  PreviousState?: string;
  State?: string;
}
export interface CancelReservedInstancesListingRequest {
  ReservedInstancesListingId: string | undefined;
}
export declare const ListingState: {
  readonly available: "available";
  readonly cancelled: "cancelled";
  readonly pending: "pending";
  readonly sold: "sold";
};
export type ListingState = (typeof ListingState)[keyof typeof ListingState];
export interface InstanceCount {
  InstanceCount?: number;
  State?: ListingState;
}
export declare const CurrencyCodeValues: {
  readonly USD: "USD";
};
export type CurrencyCodeValues =
  (typeof CurrencyCodeValues)[keyof typeof CurrencyCodeValues];
export interface PriceSchedule {
  Active?: boolean;
  CurrencyCode?: CurrencyCodeValues;
  Price?: number;
  Term?: number;
}
export declare const ListingStatus: {
  readonly active: "active";
  readonly cancelled: "cancelled";
  readonly closed: "closed";
  readonly pending: "pending";
};
export type ListingStatus = (typeof ListingStatus)[keyof typeof ListingStatus];
export interface ReservedInstancesListing {
  ClientToken?: string;
  CreateDate?: Date;
  InstanceCounts?: InstanceCount[];
  PriceSchedules?: PriceSchedule[];
  ReservedInstancesId?: string;
  ReservedInstancesListingId?: string;
  Status?: ListingStatus;
  StatusMessage?: string;
  Tags?: Tag[];
  UpdateDate?: Date;
}
export interface CancelReservedInstancesListingResult {
  ReservedInstancesListings?: ReservedInstancesListing[];
}
export interface CancelSpotFleetRequestsRequest {
  DryRun?: boolean;
  SpotFleetRequestIds: string[] | undefined;
  TerminateInstances: boolean | undefined;
}
export declare const BatchState: {
  readonly ACTIVE: "active";
  readonly CANCELLED: "cancelled";
  readonly CANCELLED_RUNNING: "cancelled_running";
  readonly CANCELLED_TERMINATING_INSTANCES: "cancelled_terminating";
  readonly FAILED: "failed";
  readonly MODIFYING: "modifying";
  readonly SUBMITTED: "submitted";
};
export type BatchState = (typeof BatchState)[keyof typeof BatchState];
export interface CancelSpotFleetRequestsSuccessItem {
  CurrentSpotFleetRequestState?: BatchState;
  PreviousSpotFleetRequestState?: BatchState;
  SpotFleetRequestId?: string;
}
export declare const CancelBatchErrorCode: {
  readonly FLEET_REQUEST_ID_DOES_NOT_EXIST: "fleetRequestIdDoesNotExist";
  readonly FLEET_REQUEST_ID_MALFORMED: "fleetRequestIdMalformed";
  readonly FLEET_REQUEST_NOT_IN_CANCELLABLE_STATE: "fleetRequestNotInCancellableState";
  readonly UNEXPECTED_ERROR: "unexpectedError";
};
export type CancelBatchErrorCode =
  (typeof CancelBatchErrorCode)[keyof typeof CancelBatchErrorCode];
export interface CancelSpotFleetRequestsError {
  Code?: CancelBatchErrorCode;
  Message?: string;
}
export interface CancelSpotFleetRequestsErrorItem {
  Error?: CancelSpotFleetRequestsError;
  SpotFleetRequestId?: string;
}
export interface CancelSpotFleetRequestsResponse {
  SuccessfulFleetRequests?: CancelSpotFleetRequestsSuccessItem[];
  UnsuccessfulFleetRequests?: CancelSpotFleetRequestsErrorItem[];
}
export interface CancelSpotInstanceRequestsRequest {
  DryRun?: boolean;
  SpotInstanceRequestIds: string[] | undefined;
}
export declare const CancelSpotInstanceRequestState: {
  readonly active: "active";
  readonly cancelled: "cancelled";
  readonly closed: "closed";
  readonly completed: "completed";
  readonly open: "open";
};
export type CancelSpotInstanceRequestState =
  (typeof CancelSpotInstanceRequestState)[keyof typeof CancelSpotInstanceRequestState];
export interface CancelledSpotInstanceRequest {
  SpotInstanceRequestId?: string;
  State?: CancelSpotInstanceRequestState;
}
export interface CancelSpotInstanceRequestsResult {
  CancelledSpotInstanceRequests?: CancelledSpotInstanceRequest[];
}
export interface ConfirmProductInstanceRequest {
  InstanceId: string | undefined;
  ProductCode: string | undefined;
  DryRun?: boolean;
}
export interface ConfirmProductInstanceResult {
  OwnerId?: string;
  Return?: boolean;
}
export interface CopyFpgaImageRequest {
  DryRun?: boolean;
  SourceFpgaImageId: string | undefined;
  Description?: string;
  Name?: string;
  SourceRegion: string | undefined;
  ClientToken?: string;
}
export interface CopyFpgaImageResult {
  FpgaImageId?: string;
}
export interface CopyImageRequest {
  ClientToken?: string;
  Description?: string;
  Encrypted?: boolean;
  KmsKeyId?: string;
  Name: string | undefined;
  SourceImageId: string | undefined;
  SourceRegion: string | undefined;
  DestinationOutpostArn?: string;
  DryRun?: boolean;
  CopyImageTags?: boolean;
  TagSpecifications?: TagSpecification[];
}
export interface CopyImageResult {
  ImageId?: string;
}
export interface CopySnapshotRequest {
  Description?: string;
  DestinationOutpostArn?: string;
  DestinationRegion?: string;
  Encrypted?: boolean;
  KmsKeyId?: string;
  PresignedUrl?: string;
  SourceRegion: string | undefined;
  SourceSnapshotId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface CopySnapshotResult {
  SnapshotId?: string;
  Tags?: Tag[];
}
export declare const EndDateType: {
  readonly limited: "limited";
  readonly unlimited: "unlimited";
};
export type EndDateType = (typeof EndDateType)[keyof typeof EndDateType];
export declare const InstanceMatchCriteria: {
  readonly open: "open";
  readonly targeted: "targeted";
};
export type InstanceMatchCriteria =
  (typeof InstanceMatchCriteria)[keyof typeof InstanceMatchCriteria];
export declare const CapacityReservationInstancePlatform: {
  readonly LINUX_UNIX: "Linux/UNIX";
  readonly LINUX_WITH_SQL_SERVER_ENTERPRISE: "Linux with SQL Server Enterprise";
  readonly LINUX_WITH_SQL_SERVER_STANDARD: "Linux with SQL Server Standard";
  readonly LINUX_WITH_SQL_SERVER_WEB: "Linux with SQL Server Web";
  readonly RED_HAT_ENTERPRISE_LINUX: "Red Hat Enterprise Linux";
  readonly RHEL_WITH_HA: "RHEL with HA";
  readonly RHEL_WITH_HA_AND_SQL_SERVER_ENTERPRISE: "RHEL with HA and SQL Server Enterprise";
  readonly RHEL_WITH_HA_AND_SQL_SERVER_STANDARD: "RHEL with HA and SQL Server Standard";
  readonly RHEL_WITH_SQL_SERVER_ENTERPRISE: "RHEL with SQL Server Enterprise";
  readonly RHEL_WITH_SQL_SERVER_STANDARD: "RHEL with SQL Server Standard";
  readonly RHEL_WITH_SQL_SERVER_WEB: "RHEL with SQL Server Web";
  readonly SUSE_LINUX: "SUSE Linux";
  readonly UBUNTU_PRO_LINUX: "Ubuntu Pro";
  readonly WINDOWS: "Windows";
  readonly WINDOWS_WITH_SQL_SERVER: "Windows with SQL Server";
  readonly WINDOWS_WITH_SQL_SERVER_ENTERPRISE: "Windows with SQL Server Enterprise";
  readonly WINDOWS_WITH_SQL_SERVER_STANDARD: "Windows with SQL Server Standard";
  readonly WINDOWS_WITH_SQL_SERVER_WEB: "Windows with SQL Server Web";
};
export type CapacityReservationInstancePlatform =
  (typeof CapacityReservationInstancePlatform)[keyof typeof CapacityReservationInstancePlatform];
export declare const CapacityReservationTenancy: {
  readonly dedicated: "dedicated";
  readonly default: "default";
};
export type CapacityReservationTenancy =
  (typeof CapacityReservationTenancy)[keyof typeof CapacityReservationTenancy];
export interface CreateCapacityReservationRequest {
  ClientToken?: string;
  InstanceType: string | undefined;
  InstancePlatform: CapacityReservationInstancePlatform | undefined;
  AvailabilityZone?: string;
  AvailabilityZoneId?: string;
  Tenancy?: CapacityReservationTenancy;
  InstanceCount: number | undefined;
  EbsOptimized?: boolean;
  EphemeralStorage?: boolean;
  EndDate?: Date;
  EndDateType?: EndDateType;
  InstanceMatchCriteria?: InstanceMatchCriteria;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
  OutpostArn?: string;
  PlacementGroupArn?: string;
}
export interface CapacityAllocation {
  AllocationType?: AllocationType;
  Count?: number;
}
export declare const CapacityReservationType: {
  readonly CAPACITY_BLOCK: "capacity-block";
  readonly DEFAULT: "default";
};
export type CapacityReservationType =
  (typeof CapacityReservationType)[keyof typeof CapacityReservationType];
export declare const CapacityReservationState: {
  readonly active: "active";
  readonly cancelled: "cancelled";
  readonly expired: "expired";
  readonly failed: "failed";
  readonly payment_failed: "payment-failed";
  readonly payment_pending: "payment-pending";
  readonly pending: "pending";
  readonly scheduled: "scheduled";
};
export type CapacityReservationState =
  (typeof CapacityReservationState)[keyof typeof CapacityReservationState];
export interface CapacityReservation {
  CapacityReservationId?: string;
  OwnerId?: string;
  CapacityReservationArn?: string;
  AvailabilityZoneId?: string;
  InstanceType?: string;
  InstancePlatform?: CapacityReservationInstancePlatform;
  AvailabilityZone?: string;
  Tenancy?: CapacityReservationTenancy;
  TotalInstanceCount?: number;
  AvailableInstanceCount?: number;
  EbsOptimized?: boolean;
  EphemeralStorage?: boolean;
  State?: CapacityReservationState;
  StartDate?: Date;
  EndDate?: Date;
  EndDateType?: EndDateType;
  InstanceMatchCriteria?: InstanceMatchCriteria;
  CreateDate?: Date;
  Tags?: Tag[];
  OutpostArn?: string;
  CapacityReservationFleetId?: string;
  PlacementGroupArn?: string;
  CapacityAllocations?: CapacityAllocation[];
  ReservationType?: CapacityReservationType;
}
export interface CreateCapacityReservationResult {
  CapacityReservation?: CapacityReservation;
}
export declare const FleetInstanceMatchCriteria: {
  readonly open: "open";
};
export type FleetInstanceMatchCriteria =
  (typeof FleetInstanceMatchCriteria)[keyof typeof FleetInstanceMatchCriteria];
export declare const _InstanceType: {
  readonly a1_2xlarge: "a1.2xlarge";
  readonly a1_4xlarge: "a1.4xlarge";
  readonly a1_large: "a1.large";
  readonly a1_medium: "a1.medium";
  readonly a1_metal: "a1.metal";
  readonly a1_xlarge: "a1.xlarge";
  readonly c1_medium: "c1.medium";
  readonly c1_xlarge: "c1.xlarge";
  readonly c3_2xlarge: "c3.2xlarge";
  readonly c3_4xlarge: "c3.4xlarge";
  readonly c3_8xlarge: "c3.8xlarge";
  readonly c3_large: "c3.large";
  readonly c3_xlarge: "c3.xlarge";
  readonly c4_2xlarge: "c4.2xlarge";
  readonly c4_4xlarge: "c4.4xlarge";
  readonly c4_8xlarge: "c4.8xlarge";
  readonly c4_large: "c4.large";
  readonly c4_xlarge: "c4.xlarge";
  readonly c5_12xlarge: "c5.12xlarge";
  readonly c5_18xlarge: "c5.18xlarge";
  readonly c5_24xlarge: "c5.24xlarge";
  readonly c5_2xlarge: "c5.2xlarge";
  readonly c5_4xlarge: "c5.4xlarge";
  readonly c5_9xlarge: "c5.9xlarge";
  readonly c5_large: "c5.large";
  readonly c5_metal: "c5.metal";
  readonly c5_xlarge: "c5.xlarge";
  readonly c5a_12xlarge: "c5a.12xlarge";
  readonly c5a_16xlarge: "c5a.16xlarge";
  readonly c5a_24xlarge: "c5a.24xlarge";
  readonly c5a_2xlarge: "c5a.2xlarge";
  readonly c5a_4xlarge: "c5a.4xlarge";
  readonly c5a_8xlarge: "c5a.8xlarge";
  readonly c5a_large: "c5a.large";
  readonly c5a_xlarge: "c5a.xlarge";
  readonly c5ad_12xlarge: "c5ad.12xlarge";
  readonly c5ad_16xlarge: "c5ad.16xlarge";
  readonly c5ad_24xlarge: "c5ad.24xlarge";
  readonly c5ad_2xlarge: "c5ad.2xlarge";
  readonly c5ad_4xlarge: "c5ad.4xlarge";
  readonly c5ad_8xlarge: "c5ad.8xlarge";
  readonly c5ad_large: "c5ad.large";
  readonly c5ad_xlarge: "c5ad.xlarge";
  readonly c5d_12xlarge: "c5d.12xlarge";
  readonly c5d_18xlarge: "c5d.18xlarge";
  readonly c5d_24xlarge: "c5d.24xlarge";
  readonly c5d_2xlarge: "c5d.2xlarge";
  readonly c5d_4xlarge: "c5d.4xlarge";
  readonly c5d_9xlarge: "c5d.9xlarge";
  readonly c5d_large: "c5d.large";
  readonly c5d_metal: "c5d.metal";
  readonly c5d_xlarge: "c5d.xlarge";
  readonly c5n_18xlarge: "c5n.18xlarge";
  readonly c5n_2xlarge: "c5n.2xlarge";
  readonly c5n_4xlarge: "c5n.4xlarge";
  readonly c5n_9xlarge: "c5n.9xlarge";
  readonly c5n_large: "c5n.large";
  readonly c5n_metal: "c5n.metal";
  readonly c5n_xlarge: "c5n.xlarge";
  readonly c6a_12xlarge: "c6a.12xlarge";
  readonly c6a_16xlarge: "c6a.16xlarge";
  readonly c6a_24xlarge: "c6a.24xlarge";
  readonly c6a_2xlarge: "c6a.2xlarge";
  readonly c6a_32xlarge: "c6a.32xlarge";
  readonly c6a_48xlarge: "c6a.48xlarge";
  readonly c6a_4xlarge: "c6a.4xlarge";
  readonly c6a_8xlarge: "c6a.8xlarge";
  readonly c6a_large: "c6a.large";
  readonly c6a_metal: "c6a.metal";
  readonly c6a_xlarge: "c6a.xlarge";
  readonly c6g_12xlarge: "c6g.12xlarge";
  readonly c6g_16xlarge: "c6g.16xlarge";
  readonly c6g_2xlarge: "c6g.2xlarge";
  readonly c6g_4xlarge: "c6g.4xlarge";
  readonly c6g_8xlarge: "c6g.8xlarge";
  readonly c6g_large: "c6g.large";
  readonly c6g_medium: "c6g.medium";
  readonly c6g_metal: "c6g.metal";
  readonly c6g_xlarge: "c6g.xlarge";
  readonly c6gd_12xlarge: "c6gd.12xlarge";
  readonly c6gd_16xlarge: "c6gd.16xlarge";
  readonly c6gd_2xlarge: "c6gd.2xlarge";
  readonly c6gd_4xlarge: "c6gd.4xlarge";
  readonly c6gd_8xlarge: "c6gd.8xlarge";
  readonly c6gd_large: "c6gd.large";
  readonly c6gd_medium: "c6gd.medium";
  readonly c6gd_metal: "c6gd.metal";
  readonly c6gd_xlarge: "c6gd.xlarge";
  readonly c6gn_12xlarge: "c6gn.12xlarge";
  readonly c6gn_16xlarge: "c6gn.16xlarge";
  readonly c6gn_2xlarge: "c6gn.2xlarge";
  readonly c6gn_4xlarge: "c6gn.4xlarge";
  readonly c6gn_8xlarge: "c6gn.8xlarge";
  readonly c6gn_large: "c6gn.large";
  readonly c6gn_medium: "c6gn.medium";
  readonly c6gn_xlarge: "c6gn.xlarge";
  readonly c6i_12xlarge: "c6i.12xlarge";
  readonly c6i_16xlarge: "c6i.16xlarge";
  readonly c6i_24xlarge: "c6i.24xlarge";
  readonly c6i_2xlarge: "c6i.2xlarge";
  readonly c6i_32xlarge: "c6i.32xlarge";
  readonly c6i_4xlarge: "c6i.4xlarge";
  readonly c6i_8xlarge: "c6i.8xlarge";
  readonly c6i_large: "c6i.large";
  readonly c6i_metal: "c6i.metal";
  readonly c6i_xlarge: "c6i.xlarge";
  readonly c6id_12xlarge: "c6id.12xlarge";
  readonly c6id_16xlarge: "c6id.16xlarge";
  readonly c6id_24xlarge: "c6id.24xlarge";
  readonly c6id_2xlarge: "c6id.2xlarge";
  readonly c6id_32xlarge: "c6id.32xlarge";
  readonly c6id_4xlarge: "c6id.4xlarge";
  readonly c6id_8xlarge: "c6id.8xlarge";
  readonly c6id_large: "c6id.large";
  readonly c6id_metal: "c6id.metal";
  readonly c6id_xlarge: "c6id.xlarge";
  readonly c6in_12xlarge: "c6in.12xlarge";
  readonly c6in_16xlarge: "c6in.16xlarge";
  readonly c6in_24xlarge: "c6in.24xlarge";
  readonly c6in_2xlarge: "c6in.2xlarge";
  readonly c6in_32xlarge: "c6in.32xlarge";
  readonly c6in_4xlarge: "c6in.4xlarge";
  readonly c6in_8xlarge: "c6in.8xlarge";
  readonly c6in_large: "c6in.large";
  readonly c6in_metal: "c6in.metal";
  readonly c6in_xlarge: "c6in.xlarge";
  readonly c7a_12xlarge: "c7a.12xlarge";
  readonly c7a_16xlarge: "c7a.16xlarge";
  readonly c7a_24xlarge: "c7a.24xlarge";
  readonly c7a_2xlarge: "c7a.2xlarge";
  readonly c7a_32xlarge: "c7a.32xlarge";
  readonly c7a_48xlarge: "c7a.48xlarge";
  readonly c7a_4xlarge: "c7a.4xlarge";
  readonly c7a_8xlarge: "c7a.8xlarge";
  readonly c7a_large: "c7a.large";
  readonly c7a_medium: "c7a.medium";
  readonly c7a_metal_48xl: "c7a.metal-48xl";
  readonly c7a_xlarge: "c7a.xlarge";
  readonly c7g_12xlarge: "c7g.12xlarge";
  readonly c7g_16xlarge: "c7g.16xlarge";
  readonly c7g_2xlarge: "c7g.2xlarge";
  readonly c7g_4xlarge: "c7g.4xlarge";
  readonly c7g_8xlarge: "c7g.8xlarge";
  readonly c7g_large: "c7g.large";
  readonly c7g_medium: "c7g.medium";
  readonly c7g_metal: "c7g.metal";
  readonly c7g_xlarge: "c7g.xlarge";
  readonly c7gd_12xlarge: "c7gd.12xlarge";
  readonly c7gd_16xlarge: "c7gd.16xlarge";
  readonly c7gd_2xlarge: "c7gd.2xlarge";
  readonly c7gd_4xlarge: "c7gd.4xlarge";
  readonly c7gd_8xlarge: "c7gd.8xlarge";
  readonly c7gd_large: "c7gd.large";
  readonly c7gd_medium: "c7gd.medium";
  readonly c7gd_xlarge: "c7gd.xlarge";
  readonly c7gn_12xlarge: "c7gn.12xlarge";
  readonly c7gn_16xlarge: "c7gn.16xlarge";
  readonly c7gn_2xlarge: "c7gn.2xlarge";
  readonly c7gn_4xlarge: "c7gn.4xlarge";
  readonly c7gn_8xlarge: "c7gn.8xlarge";
  readonly c7gn_large: "c7gn.large";
  readonly c7gn_medium: "c7gn.medium";
  readonly c7gn_xlarge: "c7gn.xlarge";
  readonly c7i_12xlarge: "c7i.12xlarge";
  readonly c7i_16xlarge: "c7i.16xlarge";
  readonly c7i_24xlarge: "c7i.24xlarge";
  readonly c7i_2xlarge: "c7i.2xlarge";
  readonly c7i_48xlarge: "c7i.48xlarge";
  readonly c7i_4xlarge: "c7i.4xlarge";
  readonly c7i_8xlarge: "c7i.8xlarge";
  readonly c7i_large: "c7i.large";
  readonly c7i_metal_24xl: "c7i.metal-24xl";
  readonly c7i_metal_48xl: "c7i.metal-48xl";
  readonly c7i_xlarge: "c7i.xlarge";
  readonly cc1_4xlarge: "cc1.4xlarge";
  readonly cc2_8xlarge: "cc2.8xlarge";
  readonly cg1_4xlarge: "cg1.4xlarge";
  readonly cr1_8xlarge: "cr1.8xlarge";
  readonly d2_2xlarge: "d2.2xlarge";
  readonly d2_4xlarge: "d2.4xlarge";
  readonly d2_8xlarge: "d2.8xlarge";
  readonly d2_xlarge: "d2.xlarge";
  readonly d3_2xlarge: "d3.2xlarge";
  readonly d3_4xlarge: "d3.4xlarge";
  readonly d3_8xlarge: "d3.8xlarge";
  readonly d3_xlarge: "d3.xlarge";
  readonly d3en_12xlarge: "d3en.12xlarge";
  readonly d3en_2xlarge: "d3en.2xlarge";
  readonly d3en_4xlarge: "d3en.4xlarge";
  readonly d3en_6xlarge: "d3en.6xlarge";
  readonly d3en_8xlarge: "d3en.8xlarge";
  readonly d3en_xlarge: "d3en.xlarge";
  readonly dl1_24xlarge: "dl1.24xlarge";
  readonly dl2q_24xlarge: "dl2q.24xlarge";
  readonly f1_16xlarge: "f1.16xlarge";
  readonly f1_2xlarge: "f1.2xlarge";
  readonly f1_4xlarge: "f1.4xlarge";
  readonly g2_2xlarge: "g2.2xlarge";
  readonly g2_8xlarge: "g2.8xlarge";
  readonly g3_16xlarge: "g3.16xlarge";
  readonly g3_4xlarge: "g3.4xlarge";
  readonly g3_8xlarge: "g3.8xlarge";
  readonly g3s_xlarge: "g3s.xlarge";
  readonly g4ad_16xlarge: "g4ad.16xlarge";
  readonly g4ad_2xlarge: "g4ad.2xlarge";
  readonly g4ad_4xlarge: "g4ad.4xlarge";
  readonly g4ad_8xlarge: "g4ad.8xlarge";
  readonly g4ad_xlarge: "g4ad.xlarge";
  readonly g4dn_12xlarge: "g4dn.12xlarge";
  readonly g4dn_16xlarge: "g4dn.16xlarge";
  readonly g4dn_2xlarge: "g4dn.2xlarge";
  readonly g4dn_4xlarge: "g4dn.4xlarge";
  readonly g4dn_8xlarge: "g4dn.8xlarge";
  readonly g4dn_metal: "g4dn.metal";
  readonly g4dn_xlarge: "g4dn.xlarge";
  readonly g5_12xlarge: "g5.12xlarge";
  readonly g5_16xlarge: "g5.16xlarge";
  readonly g5_24xlarge: "g5.24xlarge";
  readonly g5_2xlarge: "g5.2xlarge";
  readonly g5_48xlarge: "g5.48xlarge";
  readonly g5_4xlarge: "g5.4xlarge";
  readonly g5_8xlarge: "g5.8xlarge";
  readonly g5_xlarge: "g5.xlarge";
  readonly g5g_16xlarge: "g5g.16xlarge";
  readonly g5g_2xlarge: "g5g.2xlarge";
  readonly g5g_4xlarge: "g5g.4xlarge";
  readonly g5g_8xlarge: "g5g.8xlarge";
  readonly g5g_metal: "g5g.metal";
  readonly g5g_xlarge: "g5g.xlarge";
  readonly h1_16xlarge: "h1.16xlarge";
  readonly h1_2xlarge: "h1.2xlarge";
  readonly h1_4xlarge: "h1.4xlarge";
  readonly h1_8xlarge: "h1.8xlarge";
  readonly hi1_4xlarge: "hi1.4xlarge";
  readonly hpc6a_48xlarge: "hpc6a.48xlarge";
  readonly hpc6id_32xlarge: "hpc6id.32xlarge";
  readonly hpc7a_12xlarge: "hpc7a.12xlarge";
  readonly hpc7a_24xlarge: "hpc7a.24xlarge";
  readonly hpc7a_48xlarge: "hpc7a.48xlarge";
  readonly hpc7a_96xlarge: "hpc7a.96xlarge";
  readonly hpc7g_16xlarge: "hpc7g.16xlarge";
  readonly hpc7g_4xlarge: "hpc7g.4xlarge";
  readonly hpc7g_8xlarge: "hpc7g.8xlarge";
  readonly hs1_8xlarge: "hs1.8xlarge";
  readonly i2_2xlarge: "i2.2xlarge";
  readonly i2_4xlarge: "i2.4xlarge";
  readonly i2_8xlarge: "i2.8xlarge";
  readonly i2_xlarge: "i2.xlarge";
  readonly i3_16xlarge: "i3.16xlarge";
  readonly i3_2xlarge: "i3.2xlarge";
  readonly i3_4xlarge: "i3.4xlarge";
  readonly i3_8xlarge: "i3.8xlarge";
  readonly i3_large: "i3.large";
  readonly i3_metal: "i3.metal";
  readonly i3_xlarge: "i3.xlarge";
  readonly i3en_12xlarge: "i3en.12xlarge";
  readonly i3en_24xlarge: "i3en.24xlarge";
  readonly i3en_2xlarge: "i3en.2xlarge";
  readonly i3en_3xlarge: "i3en.3xlarge";
  readonly i3en_6xlarge: "i3en.6xlarge";
  readonly i3en_large: "i3en.large";
  readonly i3en_metal: "i3en.metal";
  readonly i3en_xlarge: "i3en.xlarge";
  readonly i4g_16xlarge: "i4g.16xlarge";
  readonly i4g_2xlarge: "i4g.2xlarge";
  readonly i4g_4xlarge: "i4g.4xlarge";
  readonly i4g_8xlarge: "i4g.8xlarge";
  readonly i4g_large: "i4g.large";
  readonly i4g_xlarge: "i4g.xlarge";
  readonly i4i_12xlarge: "i4i.12xlarge";
  readonly i4i_16xlarge: "i4i.16xlarge";
  readonly i4i_24xlarge: "i4i.24xlarge";
  readonly i4i_2xlarge: "i4i.2xlarge";
  readonly i4i_32xlarge: "i4i.32xlarge";
  readonly i4i_4xlarge: "i4i.4xlarge";
  readonly i4i_8xlarge: "i4i.8xlarge";
  readonly i4i_large: "i4i.large";
  readonly i4i_metal: "i4i.metal";
  readonly i4i_xlarge: "i4i.xlarge";
  readonly im4gn_16xlarge: "im4gn.16xlarge";
  readonly im4gn_2xlarge: "im4gn.2xlarge";
  readonly im4gn_4xlarge: "im4gn.4xlarge";
  readonly im4gn_8xlarge: "im4gn.8xlarge";
  readonly im4gn_large: "im4gn.large";
  readonly im4gn_xlarge: "im4gn.xlarge";
  readonly inf1_24xlarge: "inf1.24xlarge";
  readonly inf1_2xlarge: "inf1.2xlarge";
  readonly inf1_6xlarge: "inf1.6xlarge";
  readonly inf1_xlarge: "inf1.xlarge";
  readonly inf2_24xlarge: "inf2.24xlarge";
  readonly inf2_48xlarge: "inf2.48xlarge";
  readonly inf2_8xlarge: "inf2.8xlarge";
  readonly inf2_xlarge: "inf2.xlarge";
  readonly is4gen_2xlarge: "is4gen.2xlarge";
  readonly is4gen_4xlarge: "is4gen.4xlarge";
  readonly is4gen_8xlarge: "is4gen.8xlarge";
  readonly is4gen_large: "is4gen.large";
  readonly is4gen_medium: "is4gen.medium";
  readonly is4gen_xlarge: "is4gen.xlarge";
  readonly m1_large: "m1.large";
  readonly m1_medium: "m1.medium";
  readonly m1_small: "m1.small";
  readonly m1_xlarge: "m1.xlarge";
  readonly m2_2xlarge: "m2.2xlarge";
  readonly m2_4xlarge: "m2.4xlarge";
  readonly m2_xlarge: "m2.xlarge";
  readonly m3_2xlarge: "m3.2xlarge";
  readonly m3_large: "m3.large";
  readonly m3_medium: "m3.medium";
  readonly m3_xlarge: "m3.xlarge";
  readonly m4_10xlarge: "m4.10xlarge";
  readonly m4_16xlarge: "m4.16xlarge";
  readonly m4_2xlarge: "m4.2xlarge";
  readonly m4_4xlarge: "m4.4xlarge";
  readonly m4_large: "m4.large";
  readonly m4_xlarge: "m4.xlarge";
  readonly m5_12xlarge: "m5.12xlarge";
  readonly m5_16xlarge: "m5.16xlarge";
  readonly m5_24xlarge: "m5.24xlarge";
  readonly m5_2xlarge: "m5.2xlarge";
  readonly m5_4xlarge: "m5.4xlarge";
  readonly m5_8xlarge: "m5.8xlarge";
  readonly m5_large: "m5.large";
  readonly m5_metal: "m5.metal";
  readonly m5_xlarge: "m5.xlarge";
  readonly m5a_12xlarge: "m5a.12xlarge";
  readonly m5a_16xlarge: "m5a.16xlarge";
  readonly m5a_24xlarge: "m5a.24xlarge";
  readonly m5a_2xlarge: "m5a.2xlarge";
  readonly m5a_4xlarge: "m5a.4xlarge";
  readonly m5a_8xlarge: "m5a.8xlarge";
  readonly m5a_large: "m5a.large";
  readonly m5a_xlarge: "m5a.xlarge";
  readonly m5ad_12xlarge: "m5ad.12xlarge";
  readonly m5ad_16xlarge: "m5ad.16xlarge";
  readonly m5ad_24xlarge: "m5ad.24xlarge";
  readonly m5ad_2xlarge: "m5ad.2xlarge";
  readonly m5ad_4xlarge: "m5ad.4xlarge";
  readonly m5ad_8xlarge: "m5ad.8xlarge";
  readonly m5ad_large: "m5ad.large";
  readonly m5ad_xlarge: "m5ad.xlarge";
  readonly m5d_12xlarge: "m5d.12xlarge";
  readonly m5d_16xlarge: "m5d.16xlarge";
  readonly m5d_24xlarge: "m5d.24xlarge";
  readonly m5d_2xlarge: "m5d.2xlarge";
  readonly m5d_4xlarge: "m5d.4xlarge";
  readonly m5d_8xlarge: "m5d.8xlarge";
  readonly m5d_large: "m5d.large";
  readonly m5d_metal: "m5d.metal";
  readonly m5d_xlarge: "m5d.xlarge";
  readonly m5dn_12xlarge: "m5dn.12xlarge";
  readonly m5dn_16xlarge: "m5dn.16xlarge";
  readonly m5dn_24xlarge: "m5dn.24xlarge";
  readonly m5dn_2xlarge: "m5dn.2xlarge";
  readonly m5dn_4xlarge: "m5dn.4xlarge";
  readonly m5dn_8xlarge: "m5dn.8xlarge";
  readonly m5dn_large: "m5dn.large";
  readonly m5dn_metal: "m5dn.metal";
  readonly m5dn_xlarge: "m5dn.xlarge";
  readonly m5n_12xlarge: "m5n.12xlarge";
  readonly m5n_16xlarge: "m5n.16xlarge";
  readonly m5n_24xlarge: "m5n.24xlarge";
  readonly m5n_2xlarge: "m5n.2xlarge";
  readonly m5n_4xlarge: "m5n.4xlarge";
  readonly m5n_8xlarge: "m5n.8xlarge";
  readonly m5n_large: "m5n.large";
  readonly m5n_metal: "m5n.metal";
  readonly m5n_xlarge: "m5n.xlarge";
  readonly m5zn_12xlarge: "m5zn.12xlarge";
  readonly m5zn_2xlarge: "m5zn.2xlarge";
  readonly m5zn_3xlarge: "m5zn.3xlarge";
  readonly m5zn_6xlarge: "m5zn.6xlarge";
  readonly m5zn_large: "m5zn.large";
  readonly m5zn_metal: "m5zn.metal";
  readonly m5zn_xlarge: "m5zn.xlarge";
  readonly m6a_12xlarge: "m6a.12xlarge";
  readonly m6a_16xlarge: "m6a.16xlarge";
  readonly m6a_24xlarge: "m6a.24xlarge";
  readonly m6a_2xlarge: "m6a.2xlarge";
  readonly m6a_32xlarge: "m6a.32xlarge";
  readonly m6a_48xlarge: "m6a.48xlarge";
  readonly m6a_4xlarge: "m6a.4xlarge";
  readonly m6a_8xlarge: "m6a.8xlarge";
  readonly m6a_large: "m6a.large";
  readonly m6a_metal: "m6a.metal";
  readonly m6a_xlarge: "m6a.xlarge";
  readonly m6g_12xlarge: "m6g.12xlarge";
  readonly m6g_16xlarge: "m6g.16xlarge";
  readonly m6g_2xlarge: "m6g.2xlarge";
  readonly m6g_4xlarge: "m6g.4xlarge";
  readonly m6g_8xlarge: "m6g.8xlarge";
  readonly m6g_large: "m6g.large";
  readonly m6g_medium: "m6g.medium";
  readonly m6g_metal: "m6g.metal";
  readonly m6g_xlarge: "m6g.xlarge";
  readonly m6gd_12xlarge: "m6gd.12xlarge";
  readonly m6gd_16xlarge: "m6gd.16xlarge";
  readonly m6gd_2xlarge: "m6gd.2xlarge";
  readonly m6gd_4xlarge: "m6gd.4xlarge";
  readonly m6gd_8xlarge: "m6gd.8xlarge";
  readonly m6gd_large: "m6gd.large";
  readonly m6gd_medium: "m6gd.medium";
  readonly m6gd_metal: "m6gd.metal";
  readonly m6gd_xlarge: "m6gd.xlarge";
  readonly m6i_12xlarge: "m6i.12xlarge";
  readonly m6i_16xlarge: "m6i.16xlarge";
  readonly m6i_24xlarge: "m6i.24xlarge";
  readonly m6i_2xlarge: "m6i.2xlarge";
  readonly m6i_32xlarge: "m6i.32xlarge";
  readonly m6i_4xlarge: "m6i.4xlarge";
  readonly m6i_8xlarge: "m6i.8xlarge";
  readonly m6i_large: "m6i.large";
  readonly m6i_metal: "m6i.metal";
  readonly m6i_xlarge: "m6i.xlarge";
  readonly m6id_12xlarge: "m6id.12xlarge";
  readonly m6id_16xlarge: "m6id.16xlarge";
  readonly m6id_24xlarge: "m6id.24xlarge";
  readonly m6id_2xlarge: "m6id.2xlarge";
  readonly m6id_32xlarge: "m6id.32xlarge";
  readonly m6id_4xlarge: "m6id.4xlarge";
  readonly m6id_8xlarge: "m6id.8xlarge";
  readonly m6id_large: "m6id.large";
  readonly m6id_metal: "m6id.metal";
  readonly m6id_xlarge: "m6id.xlarge";
  readonly m6idn_12xlarge: "m6idn.12xlarge";
  readonly m6idn_16xlarge: "m6idn.16xlarge";
  readonly m6idn_24xlarge: "m6idn.24xlarge";
  readonly m6idn_2xlarge: "m6idn.2xlarge";
  readonly m6idn_32xlarge: "m6idn.32xlarge";
  readonly m6idn_4xlarge: "m6idn.4xlarge";
  readonly m6idn_8xlarge: "m6idn.8xlarge";
  readonly m6idn_large: "m6idn.large";
  readonly m6idn_metal: "m6idn.metal";
  readonly m6idn_xlarge: "m6idn.xlarge";
  readonly m6in_12xlarge: "m6in.12xlarge";
  readonly m6in_16xlarge: "m6in.16xlarge";
  readonly m6in_24xlarge: "m6in.24xlarge";
  readonly m6in_2xlarge: "m6in.2xlarge";
  readonly m6in_32xlarge: "m6in.32xlarge";
  readonly m6in_4xlarge: "m6in.4xlarge";
  readonly m6in_8xlarge: "m6in.8xlarge";
  readonly m6in_large: "m6in.large";
  readonly m6in_metal: "m6in.metal";
  readonly m6in_xlarge: "m6in.xlarge";
  readonly m7a_12xlarge: "m7a.12xlarge";
  readonly m7a_16xlarge: "m7a.16xlarge";
  readonly m7a_24xlarge: "m7a.24xlarge";
  readonly m7a_2xlarge: "m7a.2xlarge";
  readonly m7a_32xlarge: "m7a.32xlarge";
  readonly m7a_48xlarge: "m7a.48xlarge";
  readonly m7a_4xlarge: "m7a.4xlarge";
  readonly m7a_8xlarge: "m7a.8xlarge";
  readonly m7a_large: "m7a.large";
  readonly m7a_medium: "m7a.medium";
  readonly m7a_metal_48xl: "m7a.metal-48xl";
  readonly m7a_xlarge: "m7a.xlarge";
  readonly m7g_12xlarge: "m7g.12xlarge";
  readonly m7g_16xlarge: "m7g.16xlarge";
  readonly m7g_2xlarge: "m7g.2xlarge";
  readonly m7g_4xlarge: "m7g.4xlarge";
  readonly m7g_8xlarge: "m7g.8xlarge";
  readonly m7g_large: "m7g.large";
  readonly m7g_medium: "m7g.medium";
  readonly m7g_metal: "m7g.metal";
  readonly m7g_xlarge: "m7g.xlarge";
  readonly m7gd_12xlarge: "m7gd.12xlarge";
  readonly m7gd_16xlarge: "m7gd.16xlarge";
  readonly m7gd_2xlarge: "m7gd.2xlarge";
  readonly m7gd_4xlarge: "m7gd.4xlarge";
  readonly m7gd_8xlarge: "m7gd.8xlarge";
  readonly m7gd_large: "m7gd.large";
  readonly m7gd_medium: "m7gd.medium";
  readonly m7gd_xlarge: "m7gd.xlarge";
  readonly m7i_12xlarge: "m7i.12xlarge";
  readonly m7i_16xlarge: "m7i.16xlarge";
  readonly m7i_24xlarge: "m7i.24xlarge";
  readonly m7i_2xlarge: "m7i.2xlarge";
  readonly m7i_48xlarge: "m7i.48xlarge";
  readonly m7i_4xlarge: "m7i.4xlarge";
  readonly m7i_8xlarge: "m7i.8xlarge";
  readonly m7i_flex_2xlarge: "m7i-flex.2xlarge";
  readonly m7i_flex_4xlarge: "m7i-flex.4xlarge";
  readonly m7i_flex_8xlarge: "m7i-flex.8xlarge";
  readonly m7i_flex_large: "m7i-flex.large";
  readonly m7i_flex_xlarge: "m7i-flex.xlarge";
  readonly m7i_large: "m7i.large";
  readonly m7i_metal_24xl: "m7i.metal-24xl";
  readonly m7i_metal_48xl: "m7i.metal-48xl";
  readonly m7i_xlarge: "m7i.xlarge";
  readonly mac1_metal: "mac1.metal";
  readonly mac2_m2_metal: "mac2-m2.metal";
  readonly mac2_m2pro_metal: "mac2-m2pro.metal";
  readonly mac2_metal: "mac2.metal";
  readonly p2_16xlarge: "p2.16xlarge";
  readonly p2_8xlarge: "p2.8xlarge";
  readonly p2_xlarge: "p2.xlarge";
  readonly p3_16xlarge: "p3.16xlarge";
  readonly p3_2xlarge: "p3.2xlarge";
  readonly p3_8xlarge: "p3.8xlarge";
  readonly p3dn_24xlarge: "p3dn.24xlarge";
  readonly p4d_24xlarge: "p4d.24xlarge";
  readonly p4de_24xlarge: "p4de.24xlarge";
  readonly p5_48xlarge: "p5.48xlarge";
  readonly r3_2xlarge: "r3.2xlarge";
  readonly r3_4xlarge: "r3.4xlarge";
  readonly r3_8xlarge: "r3.8xlarge";
  readonly r3_large: "r3.large";
  readonly r3_xlarge: "r3.xlarge";
  readonly r4_16xlarge: "r4.16xlarge";
  readonly r4_2xlarge: "r4.2xlarge";
  readonly r4_4xlarge: "r4.4xlarge";
  readonly r4_8xlarge: "r4.8xlarge";
  readonly r4_large: "r4.large";
  readonly r4_xlarge: "r4.xlarge";
  readonly r5_12xlarge: "r5.12xlarge";
  readonly r5_16xlarge: "r5.16xlarge";
  readonly r5_24xlarge: "r5.24xlarge";
  readonly r5_2xlarge: "r5.2xlarge";
  readonly r5_4xlarge: "r5.4xlarge";
  readonly r5_8xlarge: "r5.8xlarge";
  readonly r5_large: "r5.large";
  readonly r5_metal: "r5.metal";
  readonly r5_xlarge: "r5.xlarge";
  readonly r5a_12xlarge: "r5a.12xlarge";
  readonly r5a_16xlarge: "r5a.16xlarge";
  readonly r5a_24xlarge: "r5a.24xlarge";
  readonly r5a_2xlarge: "r5a.2xlarge";
  readonly r5a_4xlarge: "r5a.4xlarge";
  readonly r5a_8xlarge: "r5a.8xlarge";
  readonly r5a_large: "r5a.large";
  readonly r5a_xlarge: "r5a.xlarge";
  readonly r5ad_12xlarge: "r5ad.12xlarge";
  readonly r5ad_16xlarge: "r5ad.16xlarge";
  readonly r5ad_24xlarge: "r5ad.24xlarge";
  readonly r5ad_2xlarge: "r5ad.2xlarge";
  readonly r5ad_4xlarge: "r5ad.4xlarge";
  readonly r5ad_8xlarge: "r5ad.8xlarge";
  readonly r5ad_large: "r5ad.large";
  readonly r5ad_xlarge: "r5ad.xlarge";
  readonly r5b_12xlarge: "r5b.12xlarge";
  readonly r5b_16xlarge: "r5b.16xlarge";
  readonly r5b_24xlarge: "r5b.24xlarge";
  readonly r5b_2xlarge: "r5b.2xlarge";
  readonly r5b_4xlarge: "r5b.4xlarge";
  readonly r5b_8xlarge: "r5b.8xlarge";
  readonly r5b_large: "r5b.large";
  readonly r5b_metal: "r5b.metal";
  readonly r5b_xlarge: "r5b.xlarge";
  readonly r5d_12xlarge: "r5d.12xlarge";
  readonly r5d_16xlarge: "r5d.16xlarge";
  readonly r5d_24xlarge: "r5d.24xlarge";
  readonly r5d_2xlarge: "r5d.2xlarge";
  readonly r5d_4xlarge: "r5d.4xlarge";
  readonly r5d_8xlarge: "r5d.8xlarge";
  readonly r5d_large: "r5d.large";
  readonly r5d_metal: "r5d.metal";
  readonly r5d_xlarge: "r5d.xlarge";
  readonly r5dn_12xlarge: "r5dn.12xlarge";
  readonly r5dn_16xlarge: "r5dn.16xlarge";
  readonly r5dn_24xlarge: "r5dn.24xlarge";
  readonly r5dn_2xlarge: "r5dn.2xlarge";
  readonly r5dn_4xlarge: "r5dn.4xlarge";
  readonly r5dn_8xlarge: "r5dn.8xlarge";
  readonly r5dn_large: "r5dn.large";
  readonly r5dn_metal: "r5dn.metal";
  readonly r5dn_xlarge: "r5dn.xlarge";
  readonly r5n_12xlarge: "r5n.12xlarge";
  readonly r5n_16xlarge: "r5n.16xlarge";
  readonly r5n_24xlarge: "r5n.24xlarge";
  readonly r5n_2xlarge: "r5n.2xlarge";
  readonly r5n_4xlarge: "r5n.4xlarge";
  readonly r5n_8xlarge: "r5n.8xlarge";
  readonly r5n_large: "r5n.large";
  readonly r5n_metal: "r5n.metal";
  readonly r5n_xlarge: "r5n.xlarge";
  readonly r6a_12xlarge: "r6a.12xlarge";
  readonly r6a_16xlarge: "r6a.16xlarge";
  readonly r6a_24xlarge: "r6a.24xlarge";
  readonly r6a_2xlarge: "r6a.2xlarge";
  readonly r6a_32xlarge: "r6a.32xlarge";
  readonly r6a_48xlarge: "r6a.48xlarge";
  readonly r6a_4xlarge: "r6a.4xlarge";
  readonly r6a_8xlarge: "r6a.8xlarge";
  readonly r6a_large: "r6a.large";
  readonly r6a_metal: "r6a.metal";
  readonly r6a_xlarge: "r6a.xlarge";
  readonly r6g_12xlarge: "r6g.12xlarge";
  readonly r6g_16xlarge: "r6g.16xlarge";
  readonly r6g_2xlarge: "r6g.2xlarge";
  readonly r6g_4xlarge: "r6g.4xlarge";
  readonly r6g_8xlarge: "r6g.8xlarge";
  readonly r6g_large: "r6g.large";
  readonly r6g_medium: "r6g.medium";
  readonly r6g_metal: "r6g.metal";
  readonly r6g_xlarge: "r6g.xlarge";
  readonly r6gd_12xlarge: "r6gd.12xlarge";
  readonly r6gd_16xlarge: "r6gd.16xlarge";
  readonly r6gd_2xlarge: "r6gd.2xlarge";
  readonly r6gd_4xlarge: "r6gd.4xlarge";
  readonly r6gd_8xlarge: "r6gd.8xlarge";
  readonly r6gd_large: "r6gd.large";
  readonly r6gd_medium: "r6gd.medium";
  readonly r6gd_metal: "r6gd.metal";
  readonly r6gd_xlarge: "r6gd.xlarge";
  readonly r6i_12xlarge: "r6i.12xlarge";
  readonly r6i_16xlarge: "r6i.16xlarge";
  readonly r6i_24xlarge: "r6i.24xlarge";
  readonly r6i_2xlarge: "r6i.2xlarge";
  readonly r6i_32xlarge: "r6i.32xlarge";
  readonly r6i_4xlarge: "r6i.4xlarge";
  readonly r6i_8xlarge: "r6i.8xlarge";
  readonly r6i_large: "r6i.large";
  readonly r6i_metal: "r6i.metal";
  readonly r6i_xlarge: "r6i.xlarge";
  readonly r6id_12xlarge: "r6id.12xlarge";
  readonly r6id_16xlarge: "r6id.16xlarge";
  readonly r6id_24xlarge: "r6id.24xlarge";
  readonly r6id_2xlarge: "r6id.2xlarge";
  readonly r6id_32xlarge: "r6id.32xlarge";
  readonly r6id_4xlarge: "r6id.4xlarge";
  readonly r6id_8xlarge: "r6id.8xlarge";
  readonly r6id_large: "r6id.large";
  readonly r6id_metal: "r6id.metal";
  readonly r6id_xlarge: "r6id.xlarge";
  readonly r6idn_12xlarge: "r6idn.12xlarge";
  readonly r6idn_16xlarge: "r6idn.16xlarge";
  readonly r6idn_24xlarge: "r6idn.24xlarge";
  readonly r6idn_2xlarge: "r6idn.2xlarge";
  readonly r6idn_32xlarge: "r6idn.32xlarge";
  readonly r6idn_4xlarge: "r6idn.4xlarge";
  readonly r6idn_8xlarge: "r6idn.8xlarge";
  readonly r6idn_large: "r6idn.large";
  readonly r6idn_metal: "r6idn.metal";
  readonly r6idn_xlarge: "r6idn.xlarge";
  readonly r6in_12xlarge: "r6in.12xlarge";
  readonly r6in_16xlarge: "r6in.16xlarge";
  readonly r6in_24xlarge: "r6in.24xlarge";
  readonly r6in_2xlarge: "r6in.2xlarge";
  readonly r6in_32xlarge: "r6in.32xlarge";
  readonly r6in_4xlarge: "r6in.4xlarge";
  readonly r6in_8xlarge: "r6in.8xlarge";
  readonly r6in_large: "r6in.large";
  readonly r6in_metal: "r6in.metal";
  readonly r6in_xlarge: "r6in.xlarge";
  readonly r7a_12xlarge: "r7a.12xlarge";
  readonly r7a_16xlarge: "r7a.16xlarge";
  readonly r7a_24xlarge: "r7a.24xlarge";
  readonly r7a_2xlarge: "r7a.2xlarge";
  readonly r7a_32xlarge: "r7a.32xlarge";
  readonly r7a_48xlarge: "r7a.48xlarge";
  readonly r7a_4xlarge: "r7a.4xlarge";
  readonly r7a_8xlarge: "r7a.8xlarge";
  readonly r7a_large: "r7a.large";
  readonly r7a_medium: "r7a.medium";
  readonly r7a_metal_48xl: "r7a.metal-48xl";
  readonly r7a_xlarge: "r7a.xlarge";
  readonly r7g_12xlarge: "r7g.12xlarge";
  readonly r7g_16xlarge: "r7g.16xlarge";
  readonly r7g_2xlarge: "r7g.2xlarge";
  readonly r7g_4xlarge: "r7g.4xlarge";
  readonly r7g_8xlarge: "r7g.8xlarge";
  readonly r7g_large: "r7g.large";
  readonly r7g_medium: "r7g.medium";
  readonly r7g_metal: "r7g.metal";
  readonly r7g_xlarge: "r7g.xlarge";
  readonly r7gd_12xlarge: "r7gd.12xlarge";
  readonly r7gd_16xlarge: "r7gd.16xlarge";
  readonly r7gd_2xlarge: "r7gd.2xlarge";
  readonly r7gd_4xlarge: "r7gd.4xlarge";
  readonly r7gd_8xlarge: "r7gd.8xlarge";
  readonly r7gd_large: "r7gd.large";
  readonly r7gd_medium: "r7gd.medium";
  readonly r7gd_xlarge: "r7gd.xlarge";
  readonly r7i_12xlarge: "r7i.12xlarge";
  readonly r7i_16xlarge: "r7i.16xlarge";
  readonly r7i_24xlarge: "r7i.24xlarge";
  readonly r7i_2xlarge: "r7i.2xlarge";
  readonly r7i_48xlarge: "r7i.48xlarge";
  readonly r7i_4xlarge: "r7i.4xlarge";
  readonly r7i_8xlarge: "r7i.8xlarge";
  readonly r7i_large: "r7i.large";
  readonly r7i_metal_24xl: "r7i.metal-24xl";
  readonly r7i_metal_48xl: "r7i.metal-48xl";
  readonly r7i_xlarge: "r7i.xlarge";
  readonly r7iz_12xlarge: "r7iz.12xlarge";
  readonly r7iz_16xlarge: "r7iz.16xlarge";
  readonly r7iz_2xlarge: "r7iz.2xlarge";
  readonly r7iz_32xlarge: "r7iz.32xlarge";
  readonly r7iz_4xlarge: "r7iz.4xlarge";
  readonly r7iz_8xlarge: "r7iz.8xlarge";
  readonly r7iz_large: "r7iz.large";
  readonly r7iz_metal_16xl: "r7iz.metal-16xl";
  readonly r7iz_metal_32xl: "r7iz.metal-32xl";
  readonly r7iz_xlarge: "r7iz.xlarge";
  readonly t1_micro: "t1.micro";
  readonly t2_2xlarge: "t2.2xlarge";
  readonly t2_large: "t2.large";
  readonly t2_medium: "t2.medium";
  readonly t2_micro: "t2.micro";
  readonly t2_nano: "t2.nano";
  readonly t2_small: "t2.small";
  readonly t2_xlarge: "t2.xlarge";
  readonly t3_2xlarge: "t3.2xlarge";
  readonly t3_large: "t3.large";
  readonly t3_medium: "t3.medium";
  readonly t3_micro: "t3.micro";
  readonly t3_nano: "t3.nano";
  readonly t3_small: "t3.small";
  readonly t3_xlarge: "t3.xlarge";
  readonly t3a_2xlarge: "t3a.2xlarge";
  readonly t3a_large: "t3a.large";
  readonly t3a_medium: "t3a.medium";
  readonly t3a_micro: "t3a.micro";
  readonly t3a_nano: "t3a.nano";
  readonly t3a_small: "t3a.small";
  readonly t3a_xlarge: "t3a.xlarge";
  readonly t4g_2xlarge: "t4g.2xlarge";
  readonly t4g_large: "t4g.large";
  readonly t4g_medium: "t4g.medium";
  readonly t4g_micro: "t4g.micro";
  readonly t4g_nano: "t4g.nano";
  readonly t4g_small: "t4g.small";
  readonly t4g_xlarge: "t4g.xlarge";
  readonly trn1_2xlarge: "trn1.2xlarge";
  readonly trn1_32xlarge: "trn1.32xlarge";
  readonly trn1n_32xlarge: "trn1n.32xlarge";
  readonly u_12tb1_112xlarge: "u-12tb1.112xlarge";
  readonly u_12tb1_metal: "u-12tb1.metal";
  readonly u_18tb1_112xlarge: "u-18tb1.112xlarge";
  readonly u_18tb1_metal: "u-18tb1.metal";
  readonly u_24tb1_112xlarge: "u-24tb1.112xlarge";
  readonly u_24tb1_metal: "u-24tb1.metal";
  readonly u_3tb1_56xlarge: "u-3tb1.56xlarge";
  readonly u_6tb1_112xlarge: "u-6tb1.112xlarge";
  readonly u_6tb1_56xlarge: "u-6tb1.56xlarge";
  readonly u_6tb1_metal: "u-6tb1.metal";
  readonly u_9tb1_112xlarge: "u-9tb1.112xlarge";
  readonly u_9tb1_metal: "u-9tb1.metal";
  readonly vt1_24xlarge: "vt1.24xlarge";
  readonly vt1_3xlarge: "vt1.3xlarge";
  readonly vt1_6xlarge: "vt1.6xlarge";
  readonly x1_16xlarge: "x1.16xlarge";
  readonly x1_32xlarge: "x1.32xlarge";
  readonly x1e_16xlarge: "x1e.16xlarge";
  readonly x1e_2xlarge: "x1e.2xlarge";
  readonly x1e_32xlarge: "x1e.32xlarge";
  readonly x1e_4xlarge: "x1e.4xlarge";
  readonly x1e_8xlarge: "x1e.8xlarge";
  readonly x1e_xlarge: "x1e.xlarge";
  readonly x2gd_12xlarge: "x2gd.12xlarge";
  readonly x2gd_16xlarge: "x2gd.16xlarge";
  readonly x2gd_2xlarge: "x2gd.2xlarge";
  readonly x2gd_4xlarge: "x2gd.4xlarge";
  readonly x2gd_8xlarge: "x2gd.8xlarge";
  readonly x2gd_large: "x2gd.large";
  readonly x2gd_medium: "x2gd.medium";
  readonly x2gd_metal: "x2gd.metal";
  readonly x2gd_xlarge: "x2gd.xlarge";
  readonly x2idn_16xlarge: "x2idn.16xlarge";
  readonly x2idn_24xlarge: "x2idn.24xlarge";
  readonly x2idn_32xlarge: "x2idn.32xlarge";
  readonly x2idn_metal: "x2idn.metal";
  readonly x2iedn_16xlarge: "x2iedn.16xlarge";
  readonly x2iedn_24xlarge: "x2iedn.24xlarge";
  readonly x2iedn_2xlarge: "x2iedn.2xlarge";
  readonly x2iedn_32xlarge: "x2iedn.32xlarge";
  readonly x2iedn_4xlarge: "x2iedn.4xlarge";
  readonly x2iedn_8xlarge: "x2iedn.8xlarge";
  readonly x2iedn_metal: "x2iedn.metal";
  readonly x2iedn_xlarge: "x2iedn.xlarge";
  readonly x2iezn_12xlarge: "x2iezn.12xlarge";
  readonly x2iezn_2xlarge: "x2iezn.2xlarge";
  readonly x2iezn_4xlarge: "x2iezn.4xlarge";
  readonly x2iezn_6xlarge: "x2iezn.6xlarge";
  readonly x2iezn_8xlarge: "x2iezn.8xlarge";
  readonly x2iezn_metal: "x2iezn.metal";
  readonly z1d_12xlarge: "z1d.12xlarge";
  readonly z1d_2xlarge: "z1d.2xlarge";
  readonly z1d_3xlarge: "z1d.3xlarge";
  readonly z1d_6xlarge: "z1d.6xlarge";
  readonly z1d_large: "z1d.large";
  readonly z1d_metal: "z1d.metal";
  readonly z1d_xlarge: "z1d.xlarge";
};
export type _InstanceType = (typeof _InstanceType)[keyof typeof _InstanceType];
export interface ReservationFleetInstanceSpecification {
  InstanceType?: _InstanceType;
  InstancePlatform?: CapacityReservationInstancePlatform;
  Weight?: number;
  AvailabilityZone?: string;
  AvailabilityZoneId?: string;
  EbsOptimized?: boolean;
  Priority?: number;
}
export declare const FleetCapacityReservationTenancy: {
  readonly default: "default";
};
export type FleetCapacityReservationTenancy =
  (typeof FleetCapacityReservationTenancy)[keyof typeof FleetCapacityReservationTenancy];
export interface CreateCapacityReservationFleetRequest {
  AllocationStrategy?: string;
  ClientToken?: string;
  InstanceTypeSpecifications:
    | ReservationFleetInstanceSpecification[]
    | undefined;
  Tenancy?: FleetCapacityReservationTenancy;
  TotalTargetCapacity: number | undefined;
  EndDate?: Date;
  InstanceMatchCriteria?: FleetInstanceMatchCriteria;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface FleetCapacityReservation {
  CapacityReservationId?: string;
  AvailabilityZoneId?: string;
  InstanceType?: _InstanceType;
  InstancePlatform?: CapacityReservationInstancePlatform;
  AvailabilityZone?: string;
  TotalInstanceCount?: number;
  FulfilledCapacity?: number;
  EbsOptimized?: boolean;
  CreateDate?: Date;
  Weight?: number;
  Priority?: number;
}
export interface CreateCapacityReservationFleetResult {
  CapacityReservationFleetId?: string;
  State?: CapacityReservationFleetState;
  TotalTargetCapacity?: number;
  TotalFulfilledCapacity?: number;
  InstanceMatchCriteria?: FleetInstanceMatchCriteria;
  AllocationStrategy?: string;
  CreateTime?: Date;
  EndDate?: Date;
  Tenancy?: FleetCapacityReservationTenancy;
  FleetCapacityReservations?: FleetCapacityReservation[];
  Tags?: Tag[];
}
export declare const OidcOptionsFilterSensitiveLog: (obj: OidcOptions) => any;
export declare const VerifiedAccessTrustProviderFilterSensitiveLog: (
  obj: VerifiedAccessTrustProvider
) => any;
export declare const AttachVerifiedAccessTrustProviderResultFilterSensitiveLog: (
  obj: AttachVerifiedAccessTrustProviderResult
) => any;
export declare const S3StorageFilterSensitiveLog: (obj: S3Storage) => any;
export declare const StorageFilterSensitiveLog: (obj: Storage) => any;
export declare const BundleInstanceRequestFilterSensitiveLog: (
  obj: BundleInstanceRequest
) => any;
export declare const BundleTaskFilterSensitiveLog: (obj: BundleTask) => any;
export declare const BundleInstanceResultFilterSensitiveLog: (
  obj: BundleInstanceResult
) => any;
export declare const CancelBundleTaskResultFilterSensitiveLog: (
  obj: CancelBundleTaskResult
) => any;
export declare const CopySnapshotRequestFilterSensitiveLog: (
  obj: CopySnapshotRequest
) => any;
