import {
  _InstanceType,
  AcceleratorCount,
  AcceleratorCountRequest,
  AcceleratorManufacturer,
  AcceleratorName,
  AcceleratorTotalMemoryMiB,
  AcceleratorTotalMemoryMiBRequest,
  AcceleratorType,
  AccessScopePath,
  AccessScopePathRequest,
  AddIpamOperatingRegion,
  AddPrefixListEntry,
  AddressFamily,
  AttachmentStatus,
  InstanceEventWindow,
  NatGatewayAddress,
  PortRange,
  Protocol,
  ResourceType,
  SubnetIpv6CidrBlockAssociation,
  Tag,
  TagSpecification,
  UnsuccessfulItem,
  VpcCidrBlockAssociation,
  VpcIpv6CidrBlockAssociation,
  WeekDay,
} from "./models_0";
export interface CreateCarrierGatewayRequest {
  VpcId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
  ClientToken?: string;
}
export declare const CarrierGatewayState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type CarrierGatewayState =
  (typeof CarrierGatewayState)[keyof typeof CarrierGatewayState];
export interface CarrierGateway {
  CarrierGatewayId?: string;
  VpcId?: string;
  State?: CarrierGatewayState;
  OwnerId?: string;
  Tags?: Tag[];
}
export interface CreateCarrierGatewayResult {
  CarrierGateway?: CarrierGateway;
}
export interface DirectoryServiceAuthenticationRequest {
  DirectoryId?: string;
}
export interface FederatedAuthenticationRequest {
  SAMLProviderArn?: string;
  SelfServiceSAMLProviderArn?: string;
}
export interface CertificateAuthenticationRequest {
  ClientRootCertificateChainArn?: string;
}
export declare const ClientVpnAuthenticationType: {
  readonly certificate_authentication: "certificate-authentication";
  readonly directory_service_authentication: "directory-service-authentication";
  readonly federated_authentication: "federated-authentication";
};
export type ClientVpnAuthenticationType =
  (typeof ClientVpnAuthenticationType)[keyof typeof ClientVpnAuthenticationType];
export interface ClientVpnAuthenticationRequest {
  Type?: ClientVpnAuthenticationType;
  ActiveDirectory?: DirectoryServiceAuthenticationRequest;
  MutualAuthentication?: CertificateAuthenticationRequest;
  FederatedAuthentication?: FederatedAuthenticationRequest;
}
export interface ClientConnectOptions {
  Enabled?: boolean;
  LambdaFunctionArn?: string;
}
export interface ClientLoginBannerOptions {
  Enabled?: boolean;
  BannerText?: string;
}
export interface ConnectionLogOptions {
  Enabled?: boolean;
  CloudwatchLogGroup?: string;
  CloudwatchLogStream?: string;
}
export declare const SelfServicePortal: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type SelfServicePortal =
  (typeof SelfServicePortal)[keyof typeof SelfServicePortal];
export declare const TransportProtocol: {
  readonly tcp: "tcp";
  readonly udp: "udp";
};
export type TransportProtocol =
  (typeof TransportProtocol)[keyof typeof TransportProtocol];
export interface CreateClientVpnEndpointRequest {
  ClientCidrBlock: string | undefined;
  ServerCertificateArn: string | undefined;
  AuthenticationOptions: ClientVpnAuthenticationRequest[] | undefined;
  ConnectionLogOptions: ConnectionLogOptions | undefined;
  DnsServers?: string[];
  TransportProtocol?: TransportProtocol;
  VpnPort?: number;
  Description?: string;
  SplitTunnel?: boolean;
  DryRun?: boolean;
  ClientToken?: string;
  TagSpecifications?: TagSpecification[];
  SecurityGroupIds?: string[];
  VpcId?: string;
  SelfServicePortal?: SelfServicePortal;
  ClientConnectOptions?: ClientConnectOptions;
  SessionTimeoutHours?: number;
  ClientLoginBannerOptions?: ClientLoginBannerOptions;
}
export declare const ClientVpnEndpointStatusCode: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending_associate: "pending-associate";
};
export type ClientVpnEndpointStatusCode =
  (typeof ClientVpnEndpointStatusCode)[keyof typeof ClientVpnEndpointStatusCode];
export interface ClientVpnEndpointStatus {
  Code?: ClientVpnEndpointStatusCode;
  Message?: string;
}
export interface CreateClientVpnEndpointResult {
  ClientVpnEndpointId?: string;
  Status?: ClientVpnEndpointStatus;
  DnsName?: string;
}
export interface CreateClientVpnRouteRequest {
  ClientVpnEndpointId: string | undefined;
  DestinationCidrBlock: string | undefined;
  TargetVpcSubnetId: string | undefined;
  Description?: string;
  ClientToken?: string;
  DryRun?: boolean;
}
export declare const ClientVpnRouteStatusCode: {
  readonly active: "active";
  readonly creating: "creating";
  readonly deleting: "deleting";
  readonly failed: "failed";
};
export type ClientVpnRouteStatusCode =
  (typeof ClientVpnRouteStatusCode)[keyof typeof ClientVpnRouteStatusCode];
export interface ClientVpnRouteStatus {
  Code?: ClientVpnRouteStatusCode;
  Message?: string;
}
export interface CreateClientVpnRouteResult {
  Status?: ClientVpnRouteStatus;
}
export interface CreateCoipCidrRequest {
  Cidr: string | undefined;
  CoipPoolId: string | undefined;
  DryRun?: boolean;
}
export interface CoipCidr {
  Cidr?: string;
  CoipPoolId?: string;
  LocalGatewayRouteTableId?: string;
}
export interface CreateCoipCidrResult {
  CoipCidr?: CoipCidr;
}
export interface CreateCoipPoolRequest {
  LocalGatewayRouteTableId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface CoipPool {
  PoolId?: string;
  PoolCidrs?: string[];
  LocalGatewayRouteTableId?: string;
  Tags?: Tag[];
  PoolArn?: string;
}
export interface CreateCoipPoolResult {
  CoipPool?: CoipPool;
}
export declare const GatewayType: {
  readonly ipsec_1: "ipsec.1";
};
export type GatewayType = (typeof GatewayType)[keyof typeof GatewayType];
export interface CreateCustomerGatewayRequest {
  BgpAsn?: number;
  PublicIp?: string;
  CertificateArn?: string;
  Type: GatewayType | undefined;
  TagSpecifications?: TagSpecification[];
  DeviceName?: string;
  IpAddress?: string;
  DryRun?: boolean;
}
export interface CustomerGateway {
  BgpAsn?: string;
  CustomerGatewayId?: string;
  IpAddress?: string;
  CertificateArn?: string;
  State?: string;
  Type?: string;
  DeviceName?: string;
  Tags?: Tag[];
}
export interface CreateCustomerGatewayResult {
  CustomerGateway?: CustomerGateway;
}
export interface CreateDefaultSubnetRequest {
  AvailabilityZone: string | undefined;
  DryRun?: boolean;
  Ipv6Native?: boolean;
}
export declare const HostnameType: {
  readonly ip_name: "ip-name";
  readonly resource_name: "resource-name";
};
export type HostnameType = (typeof HostnameType)[keyof typeof HostnameType];
export interface PrivateDnsNameOptionsOnLaunch {
  HostnameType?: HostnameType;
  EnableResourceNameDnsARecord?: boolean;
  EnableResourceNameDnsAAAARecord?: boolean;
}
export declare const SubnetState: {
  readonly available: "available";
  readonly pending: "pending";
  readonly unavailable: "unavailable";
};
export type SubnetState = (typeof SubnetState)[keyof typeof SubnetState];
export interface Subnet {
  AvailabilityZone?: string;
  AvailabilityZoneId?: string;
  AvailableIpAddressCount?: number;
  CidrBlock?: string;
  DefaultForAz?: boolean;
  EnableLniAtDeviceIndex?: number;
  MapPublicIpOnLaunch?: boolean;
  MapCustomerOwnedIpOnLaunch?: boolean;
  CustomerOwnedIpv4Pool?: string;
  State?: SubnetState;
  SubnetId?: string;
  VpcId?: string;
  OwnerId?: string;
  AssignIpv6AddressOnCreation?: boolean;
  Ipv6CidrBlockAssociationSet?: SubnetIpv6CidrBlockAssociation[];
  Tags?: Tag[];
  SubnetArn?: string;
  OutpostArn?: string;
  EnableDns64?: boolean;
  Ipv6Native?: boolean;
  PrivateDnsNameOptionsOnLaunch?: PrivateDnsNameOptionsOnLaunch;
}
export interface CreateDefaultSubnetResult {
  Subnet?: Subnet;
}
export interface CreateDefaultVpcRequest {
  DryRun?: boolean;
}
export declare const Tenancy: {
  readonly dedicated: "dedicated";
  readonly default: "default";
  readonly host: "host";
};
export type Tenancy = (typeof Tenancy)[keyof typeof Tenancy];
export declare const VpcState: {
  readonly available: "available";
  readonly pending: "pending";
};
export type VpcState = (typeof VpcState)[keyof typeof VpcState];
export interface Vpc {
  CidrBlock?: string;
  DhcpOptionsId?: string;
  State?: VpcState;
  VpcId?: string;
  OwnerId?: string;
  InstanceTenancy?: Tenancy;
  Ipv6CidrBlockAssociationSet?: VpcIpv6CidrBlockAssociation[];
  CidrBlockAssociationSet?: VpcCidrBlockAssociation[];
  IsDefault?: boolean;
  Tags?: Tag[];
}
export interface CreateDefaultVpcResult {
  Vpc?: Vpc;
}
export interface NewDhcpConfiguration {
  Key?: string;
  Values?: string[];
}
export interface CreateDhcpOptionsRequest {
  DhcpConfigurations: NewDhcpConfiguration[] | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface AttributeValue {
  Value?: string;
}
export interface DhcpConfiguration {
  Key?: string;
  Values?: AttributeValue[];
}
export interface DhcpOptions {
  DhcpConfigurations?: DhcpConfiguration[];
  DhcpOptionsId?: string;
  OwnerId?: string;
  Tags?: Tag[];
}
export interface CreateDhcpOptionsResult {
  DhcpOptions?: DhcpOptions;
}
export interface CreateEgressOnlyInternetGatewayRequest {
  ClientToken?: string;
  DryRun?: boolean;
  VpcId: string | undefined;
  TagSpecifications?: TagSpecification[];
}
export interface InternetGatewayAttachment {
  State?: AttachmentStatus;
  VpcId?: string;
}
export interface EgressOnlyInternetGateway {
  Attachments?: InternetGatewayAttachment[];
  EgressOnlyInternetGatewayId?: string;
  Tags?: Tag[];
}
export interface CreateEgressOnlyInternetGatewayResult {
  ClientToken?: string;
  EgressOnlyInternetGateway?: EgressOnlyInternetGateway;
}
export declare const FleetExcessCapacityTerminationPolicy: {
  readonly NO_TERMINATION: "no-termination";
  readonly TERMINATION: "termination";
};
export type FleetExcessCapacityTerminationPolicy =
  (typeof FleetExcessCapacityTerminationPolicy)[keyof typeof FleetExcessCapacityTerminationPolicy];
export interface FleetLaunchTemplateSpecificationRequest {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  Version?: string;
}
export declare const BareMetal: {
  readonly EXCLUDED: "excluded";
  readonly INCLUDED: "included";
  readonly REQUIRED: "required";
};
export type BareMetal = (typeof BareMetal)[keyof typeof BareMetal];
export interface BaselineEbsBandwidthMbpsRequest {
  Min?: number;
  Max?: number;
}
export declare const BurstablePerformance: {
  readonly EXCLUDED: "excluded";
  readonly INCLUDED: "included";
  readonly REQUIRED: "required";
};
export type BurstablePerformance =
  (typeof BurstablePerformance)[keyof typeof BurstablePerformance];
export declare const CpuManufacturer: {
  readonly AMAZON_WEB_SERVICES: "amazon-web-services";
  readonly AMD: "amd";
  readonly INTEL: "intel";
};
export type CpuManufacturer =
  (typeof CpuManufacturer)[keyof typeof CpuManufacturer];
export declare const InstanceGeneration: {
  readonly CURRENT: "current";
  readonly PREVIOUS: "previous";
};
export type InstanceGeneration =
  (typeof InstanceGeneration)[keyof typeof InstanceGeneration];
export declare const LocalStorage: {
  readonly EXCLUDED: "excluded";
  readonly INCLUDED: "included";
  readonly REQUIRED: "required";
};
export type LocalStorage = (typeof LocalStorage)[keyof typeof LocalStorage];
export declare const LocalStorageType: {
  readonly HDD: "hdd";
  readonly SSD: "ssd";
};
export type LocalStorageType =
  (typeof LocalStorageType)[keyof typeof LocalStorageType];
export interface MemoryGiBPerVCpuRequest {
  Min?: number;
  Max?: number;
}
export interface MemoryMiBRequest {
  Min: number | undefined;
  Max?: number;
}
export interface NetworkBandwidthGbpsRequest {
  Min?: number;
  Max?: number;
}
export interface NetworkInterfaceCountRequest {
  Min?: number;
  Max?: number;
}
export interface TotalLocalStorageGBRequest {
  Min?: number;
  Max?: number;
}
export interface VCpuCountRangeRequest {
  Min: number | undefined;
  Max?: number;
}
export interface InstanceRequirementsRequest {
  VCpuCount: VCpuCountRangeRequest | undefined;
  MemoryMiB: MemoryMiBRequest | undefined;
  CpuManufacturers?: CpuManufacturer[];
  MemoryGiBPerVCpu?: MemoryGiBPerVCpuRequest;
  ExcludedInstanceTypes?: string[];
  InstanceGenerations?: InstanceGeneration[];
  SpotMaxPricePercentageOverLowestPrice?: number;
  OnDemandMaxPricePercentageOverLowestPrice?: number;
  BareMetal?: BareMetal;
  BurstablePerformance?: BurstablePerformance;
  RequireHibernateSupport?: boolean;
  NetworkInterfaceCount?: NetworkInterfaceCountRequest;
  LocalStorage?: LocalStorage;
  LocalStorageTypes?: LocalStorageType[];
  TotalLocalStorageGB?: TotalLocalStorageGBRequest;
  BaselineEbsBandwidthMbps?: BaselineEbsBandwidthMbpsRequest;
  AcceleratorTypes?: AcceleratorType[];
  AcceleratorCount?: AcceleratorCountRequest;
  AcceleratorManufacturers?: AcceleratorManufacturer[];
  AcceleratorNames?: AcceleratorName[];
  AcceleratorTotalMemoryMiB?: AcceleratorTotalMemoryMiBRequest;
  NetworkBandwidthGbps?: NetworkBandwidthGbpsRequest;
  AllowedInstanceTypes?: string[];
  MaxSpotPriceAsPercentageOfOptimalOnDemandPrice?: number;
}
export interface Placement {
  AvailabilityZone?: string;
  Affinity?: string;
  GroupName?: string;
  PartitionNumber?: number;
  HostId?: string;
  Tenancy?: Tenancy;
  SpreadDomain?: string;
  HostResourceGroupArn?: string;
  GroupId?: string;
}
export interface FleetLaunchTemplateOverridesRequest {
  InstanceType?: _InstanceType;
  MaxPrice?: string;
  SubnetId?: string;
  AvailabilityZone?: string;
  WeightedCapacity?: number;
  Priority?: number;
  Placement?: Placement;
  InstanceRequirements?: InstanceRequirementsRequest;
  ImageId?: string;
}
export interface FleetLaunchTemplateConfigRequest {
  LaunchTemplateSpecification?: FleetLaunchTemplateSpecificationRequest;
  Overrides?: FleetLaunchTemplateOverridesRequest[];
}
export declare const FleetOnDemandAllocationStrategy: {
  readonly LOWEST_PRICE: "lowest-price";
  readonly PRIORITIZED: "prioritized";
};
export type FleetOnDemandAllocationStrategy =
  (typeof FleetOnDemandAllocationStrategy)[keyof typeof FleetOnDemandAllocationStrategy];
export declare const FleetCapacityReservationUsageStrategy: {
  readonly USE_CAPACITY_RESERVATIONS_FIRST: "use-capacity-reservations-first";
};
export type FleetCapacityReservationUsageStrategy =
  (typeof FleetCapacityReservationUsageStrategy)[keyof typeof FleetCapacityReservationUsageStrategy];
export interface CapacityReservationOptionsRequest {
  UsageStrategy?: FleetCapacityReservationUsageStrategy;
}
export interface OnDemandOptionsRequest {
  AllocationStrategy?: FleetOnDemandAllocationStrategy;
  CapacityReservationOptions?: CapacityReservationOptionsRequest;
  SingleInstanceType?: boolean;
  SingleAvailabilityZone?: boolean;
  MinTargetCapacity?: number;
  MaxTotalPrice?: string;
}
export declare const SpotAllocationStrategy: {
  readonly CAPACITY_OPTIMIZED: "capacity-optimized";
  readonly CAPACITY_OPTIMIZED_PRIORITIZED: "capacity-optimized-prioritized";
  readonly DIVERSIFIED: "diversified";
  readonly LOWEST_PRICE: "lowest-price";
  readonly PRICE_CAPACITY_OPTIMIZED: "price-capacity-optimized";
};
export type SpotAllocationStrategy =
  (typeof SpotAllocationStrategy)[keyof typeof SpotAllocationStrategy];
export declare const SpotInstanceInterruptionBehavior: {
  readonly hibernate: "hibernate";
  readonly stop: "stop";
  readonly terminate: "terminate";
};
export type SpotInstanceInterruptionBehavior =
  (typeof SpotInstanceInterruptionBehavior)[keyof typeof SpotInstanceInterruptionBehavior];
export declare const FleetReplacementStrategy: {
  readonly LAUNCH: "launch";
  readonly LAUNCH_BEFORE_TERMINATE: "launch-before-terminate";
};
export type FleetReplacementStrategy =
  (typeof FleetReplacementStrategy)[keyof typeof FleetReplacementStrategy];
export interface FleetSpotCapacityRebalanceRequest {
  ReplacementStrategy?: FleetReplacementStrategy;
  TerminationDelay?: number;
}
export interface FleetSpotMaintenanceStrategiesRequest {
  CapacityRebalance?: FleetSpotCapacityRebalanceRequest;
}
export interface SpotOptionsRequest {
  AllocationStrategy?: SpotAllocationStrategy;
  MaintenanceStrategies?: FleetSpotMaintenanceStrategiesRequest;
  InstanceInterruptionBehavior?: SpotInstanceInterruptionBehavior;
  InstancePoolsToUseCount?: number;
  SingleInstanceType?: boolean;
  SingleAvailabilityZone?: boolean;
  MinTargetCapacity?: number;
  MaxTotalPrice?: string;
}
export declare const DefaultTargetCapacityType: {
  readonly CAPACITY_BLOCK: "capacity-block";
  readonly ON_DEMAND: "on-demand";
  readonly SPOT: "spot";
};
export type DefaultTargetCapacityType =
  (typeof DefaultTargetCapacityType)[keyof typeof DefaultTargetCapacityType];
export declare const TargetCapacityUnitType: {
  readonly MEMORY_MIB: "memory-mib";
  readonly UNITS: "units";
  readonly VCPU: "vcpu";
};
export type TargetCapacityUnitType =
  (typeof TargetCapacityUnitType)[keyof typeof TargetCapacityUnitType];
export interface TargetCapacitySpecificationRequest {
  TotalTargetCapacity: number | undefined;
  OnDemandTargetCapacity?: number;
  SpotTargetCapacity?: number;
  DefaultTargetCapacityType?: DefaultTargetCapacityType;
  TargetCapacityUnitType?: TargetCapacityUnitType;
}
export declare const FleetType: {
  readonly INSTANT: "instant";
  readonly MAINTAIN: "maintain";
  readonly REQUEST: "request";
};
export type FleetType = (typeof FleetType)[keyof typeof FleetType];
export interface CreateFleetRequest {
  DryRun?: boolean;
  ClientToken?: string;
  SpotOptions?: SpotOptionsRequest;
  OnDemandOptions?: OnDemandOptionsRequest;
  ExcessCapacityTerminationPolicy?: FleetExcessCapacityTerminationPolicy;
  LaunchTemplateConfigs: FleetLaunchTemplateConfigRequest[] | undefined;
  TargetCapacitySpecification: TargetCapacitySpecificationRequest | undefined;
  TerminateInstancesWithExpiration?: boolean;
  Type?: FleetType;
  ValidFrom?: Date;
  ValidUntil?: Date;
  ReplaceUnhealthyInstances?: boolean;
  TagSpecifications?: TagSpecification[];
  Context?: string;
}
export interface FleetLaunchTemplateSpecification {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  Version?: string;
}
export interface BaselineEbsBandwidthMbps {
  Min?: number;
  Max?: number;
}
export interface MemoryGiBPerVCpu {
  Min?: number;
  Max?: number;
}
export interface MemoryMiB {
  Min?: number;
  Max?: number;
}
export interface NetworkBandwidthGbps {
  Min?: number;
  Max?: number;
}
export interface NetworkInterfaceCount {
  Min?: number;
  Max?: number;
}
export interface TotalLocalStorageGB {
  Min?: number;
  Max?: number;
}
export interface VCpuCountRange {
  Min?: number;
  Max?: number;
}
export interface InstanceRequirements {
  VCpuCount?: VCpuCountRange;
  MemoryMiB?: MemoryMiB;
  CpuManufacturers?: CpuManufacturer[];
  MemoryGiBPerVCpu?: MemoryGiBPerVCpu;
  ExcludedInstanceTypes?: string[];
  InstanceGenerations?: InstanceGeneration[];
  SpotMaxPricePercentageOverLowestPrice?: number;
  OnDemandMaxPricePercentageOverLowestPrice?: number;
  BareMetal?: BareMetal;
  BurstablePerformance?: BurstablePerformance;
  RequireHibernateSupport?: boolean;
  NetworkInterfaceCount?: NetworkInterfaceCount;
  LocalStorage?: LocalStorage;
  LocalStorageTypes?: LocalStorageType[];
  TotalLocalStorageGB?: TotalLocalStorageGB;
  BaselineEbsBandwidthMbps?: BaselineEbsBandwidthMbps;
  AcceleratorTypes?: AcceleratorType[];
  AcceleratorCount?: AcceleratorCount;
  AcceleratorManufacturers?: AcceleratorManufacturer[];
  AcceleratorNames?: AcceleratorName[];
  AcceleratorTotalMemoryMiB?: AcceleratorTotalMemoryMiB;
  NetworkBandwidthGbps?: NetworkBandwidthGbps;
  AllowedInstanceTypes?: string[];
  MaxSpotPriceAsPercentageOfOptimalOnDemandPrice?: number;
}
export interface PlacementResponse {
  GroupName?: string;
}
export interface FleetLaunchTemplateOverrides {
  InstanceType?: _InstanceType;
  MaxPrice?: string;
  SubnetId?: string;
  AvailabilityZone?: string;
  WeightedCapacity?: number;
  Priority?: number;
  Placement?: PlacementResponse;
  InstanceRequirements?: InstanceRequirements;
  ImageId?: string;
}
export interface LaunchTemplateAndOverridesResponse {
  LaunchTemplateSpecification?: FleetLaunchTemplateSpecification;
  Overrides?: FleetLaunchTemplateOverrides;
}
export declare const InstanceLifecycle: {
  readonly ON_DEMAND: "on-demand";
  readonly SPOT: "spot";
};
export type InstanceLifecycle =
  (typeof InstanceLifecycle)[keyof typeof InstanceLifecycle];
export interface CreateFleetError {
  LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
  Lifecycle?: InstanceLifecycle;
  ErrorCode?: string;
  ErrorMessage?: string;
}
export declare const PlatformValues: {
  readonly Windows: "Windows";
};
export type PlatformValues =
  (typeof PlatformValues)[keyof typeof PlatformValues];
export interface CreateFleetInstance {
  LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
  Lifecycle?: InstanceLifecycle;
  InstanceIds?: string[];
  InstanceType?: _InstanceType;
  Platform?: PlatformValues;
}
export interface CreateFleetResult {
  FleetId?: string;
  Errors?: CreateFleetError[];
  Instances?: CreateFleetInstance[];
}
export declare const DestinationFileFormat: {
  readonly parquet: "parquet";
  readonly plain_text: "plain-text";
};
export type DestinationFileFormat =
  (typeof DestinationFileFormat)[keyof typeof DestinationFileFormat];
export interface DestinationOptionsRequest {
  FileFormat?: DestinationFileFormat;
  HiveCompatiblePartitions?: boolean;
  PerHourPartition?: boolean;
}
export declare const LogDestinationType: {
  readonly cloud_watch_logs: "cloud-watch-logs";
  readonly kinesis_data_firehose: "kinesis-data-firehose";
  readonly s3: "s3";
};
export type LogDestinationType =
  (typeof LogDestinationType)[keyof typeof LogDestinationType];
export declare const FlowLogsResourceType: {
  readonly NetworkInterface: "NetworkInterface";
  readonly Subnet: "Subnet";
  readonly TransitGateway: "TransitGateway";
  readonly TransitGatewayAttachment: "TransitGatewayAttachment";
  readonly VPC: "VPC";
};
export type FlowLogsResourceType =
  (typeof FlowLogsResourceType)[keyof typeof FlowLogsResourceType];
export declare const TrafficType: {
  readonly ACCEPT: "ACCEPT";
  readonly ALL: "ALL";
  readonly REJECT: "REJECT";
};
export type TrafficType = (typeof TrafficType)[keyof typeof TrafficType];
export interface CreateFlowLogsRequest {
  DryRun?: boolean;
  ClientToken?: string;
  DeliverLogsPermissionArn?: string;
  DeliverCrossAccountRole?: string;
  LogGroupName?: string;
  ResourceIds: string[] | undefined;
  ResourceType: FlowLogsResourceType | undefined;
  TrafficType?: TrafficType;
  LogDestinationType?: LogDestinationType;
  LogDestination?: string;
  LogFormat?: string;
  TagSpecifications?: TagSpecification[];
  MaxAggregationInterval?: number;
  DestinationOptions?: DestinationOptionsRequest;
}
export interface CreateFlowLogsResult {
  ClientToken?: string;
  FlowLogIds?: string[];
  Unsuccessful?: UnsuccessfulItem[];
}
export interface StorageLocation {
  Bucket?: string;
  Key?: string;
}
export interface CreateFpgaImageRequest {
  DryRun?: boolean;
  InputStorageLocation: StorageLocation | undefined;
  LogsStorageLocation?: StorageLocation;
  Description?: string;
  Name?: string;
  ClientToken?: string;
  TagSpecifications?: TagSpecification[];
}
export interface CreateFpgaImageResult {
  FpgaImageId?: string;
  FpgaImageGlobalId?: string;
}
export declare const VolumeType: {
  readonly gp2: "gp2";
  readonly gp3: "gp3";
  readonly io1: "io1";
  readonly io2: "io2";
  readonly sc1: "sc1";
  readonly st1: "st1";
  readonly standard: "standard";
};
export type VolumeType = (typeof VolumeType)[keyof typeof VolumeType];
export interface EbsBlockDevice {
  DeleteOnTermination?: boolean;
  Iops?: number;
  SnapshotId?: string;
  VolumeSize?: number;
  VolumeType?: VolumeType;
  KmsKeyId?: string;
  Throughput?: number;
  OutpostArn?: string;
  Encrypted?: boolean;
}
export interface BlockDeviceMapping {
  DeviceName?: string;
  VirtualName?: string;
  Ebs?: EbsBlockDevice;
  NoDevice?: string;
}
export interface CreateImageRequest {
  BlockDeviceMappings?: BlockDeviceMapping[];
  Description?: string;
  DryRun?: boolean;
  InstanceId: string | undefined;
  Name: string | undefined;
  NoReboot?: boolean;
  TagSpecifications?: TagSpecification[];
}
export interface CreateImageResult {
  ImageId?: string;
}
export interface CreateInstanceConnectEndpointRequest {
  DryRun?: boolean;
  SubnetId: string | undefined;
  SecurityGroupIds?: string[];
  PreserveClientIp?: boolean;
  ClientToken?: string;
  TagSpecifications?: TagSpecification[];
}
export declare const Ec2InstanceConnectEndpointState: {
  readonly create_complete: "create-complete";
  readonly create_failed: "create-failed";
  readonly create_in_progress: "create-in-progress";
  readonly delete_complete: "delete-complete";
  readonly delete_failed: "delete-failed";
  readonly delete_in_progress: "delete-in-progress";
};
export type Ec2InstanceConnectEndpointState =
  (typeof Ec2InstanceConnectEndpointState)[keyof typeof Ec2InstanceConnectEndpointState];
export interface Ec2InstanceConnectEndpoint {
  OwnerId?: string;
  InstanceConnectEndpointId?: string;
  InstanceConnectEndpointArn?: string;
  State?: Ec2InstanceConnectEndpointState;
  StateMessage?: string;
  DnsName?: string;
  FipsDnsName?: string;
  NetworkInterfaceIds?: string[];
  VpcId?: string;
  AvailabilityZone?: string;
  CreatedAt?: Date;
  SubnetId?: string;
  PreserveClientIp?: boolean;
  SecurityGroupIds?: string[];
  Tags?: Tag[];
}
export interface CreateInstanceConnectEndpointResult {
  InstanceConnectEndpoint?: Ec2InstanceConnectEndpoint;
  ClientToken?: string;
}
export interface InstanceEventWindowTimeRangeRequest {
  StartWeekDay?: WeekDay;
  StartHour?: number;
  EndWeekDay?: WeekDay;
  EndHour?: number;
}
export interface CreateInstanceEventWindowRequest {
  DryRun?: boolean;
  Name?: string;
  TimeRanges?: InstanceEventWindowTimeRangeRequest[];
  CronExpression?: string;
  TagSpecifications?: TagSpecification[];
}
export interface CreateInstanceEventWindowResult {
  InstanceEventWindow?: InstanceEventWindow;
}
export declare const ContainerFormat: {
  readonly ova: "ova";
};
export type ContainerFormat =
  (typeof ContainerFormat)[keyof typeof ContainerFormat];
export declare const DiskImageFormat: {
  readonly RAW: "RAW";
  readonly VHD: "VHD";
  readonly VMDK: "VMDK";
};
export type DiskImageFormat =
  (typeof DiskImageFormat)[keyof typeof DiskImageFormat];
export interface ExportToS3TaskSpecification {
  ContainerFormat?: ContainerFormat;
  DiskImageFormat?: DiskImageFormat;
  S3Bucket?: string;
  S3Prefix?: string;
}
export declare const ExportEnvironment: {
  readonly citrix: "citrix";
  readonly microsoft: "microsoft";
  readonly vmware: "vmware";
};
export type ExportEnvironment =
  (typeof ExportEnvironment)[keyof typeof ExportEnvironment];
export interface CreateInstanceExportTaskRequest {
  Description?: string;
  ExportToS3Task: ExportToS3TaskSpecification | undefined;
  InstanceId: string | undefined;
  TargetEnvironment: ExportEnvironment | undefined;
  TagSpecifications?: TagSpecification[];
}
export interface ExportToS3Task {
  ContainerFormat?: ContainerFormat;
  DiskImageFormat?: DiskImageFormat;
  S3Bucket?: string;
  S3Key?: string;
}
export interface InstanceExportDetails {
  InstanceId?: string;
  TargetEnvironment?: ExportEnvironment;
}
export declare const ExportTaskState: {
  readonly active: "active";
  readonly cancelled: "cancelled";
  readonly cancelling: "cancelling";
  readonly completed: "completed";
};
export type ExportTaskState =
  (typeof ExportTaskState)[keyof typeof ExportTaskState];
export interface ExportTask {
  Description?: string;
  ExportTaskId?: string;
  ExportToS3Task?: ExportToS3Task;
  InstanceExportDetails?: InstanceExportDetails;
  State?: ExportTaskState;
  StatusMessage?: string;
  Tags?: Tag[];
}
export interface CreateInstanceExportTaskResult {
  ExportTask?: ExportTask;
}
export interface CreateInternetGatewayRequest {
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface InternetGateway {
  Attachments?: InternetGatewayAttachment[];
  InternetGatewayId?: string;
  OwnerId?: string;
  Tags?: Tag[];
}
export interface CreateInternetGatewayResult {
  InternetGateway?: InternetGateway;
}
export declare const IpamTier: {
  readonly advanced: "advanced";
  readonly free: "free";
};
export type IpamTier = (typeof IpamTier)[keyof typeof IpamTier];
export interface CreateIpamRequest {
  DryRun?: boolean;
  Description?: string;
  OperatingRegions?: AddIpamOperatingRegion[];
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
  Tier?: IpamTier;
}
export interface IpamOperatingRegion {
  RegionName?: string;
}
export declare const IpamState: {
  readonly create_complete: "create-complete";
  readonly create_failed: "create-failed";
  readonly create_in_progress: "create-in-progress";
  readonly delete_complete: "delete-complete";
  readonly delete_failed: "delete-failed";
  readonly delete_in_progress: "delete-in-progress";
  readonly isolate_complete: "isolate-complete";
  readonly isolate_in_progress: "isolate-in-progress";
  readonly modify_complete: "modify-complete";
  readonly modify_failed: "modify-failed";
  readonly modify_in_progress: "modify-in-progress";
  readonly restore_in_progress: "restore-in-progress";
};
export type IpamState = (typeof IpamState)[keyof typeof IpamState];
export interface Ipam {
  OwnerId?: string;
  IpamId?: string;
  IpamArn?: string;
  IpamRegion?: string;
  PublicDefaultScopeId?: string;
  PrivateDefaultScopeId?: string;
  ScopeCount?: number;
  Description?: string;
  OperatingRegions?: IpamOperatingRegion[];
  State?: IpamState;
  Tags?: Tag[];
  DefaultResourceDiscoveryId?: string;
  DefaultResourceDiscoveryAssociationId?: string;
  ResourceDiscoveryAssociationCount?: number;
  StateMessage?: string;
  Tier?: IpamTier;
}
export interface CreateIpamResult {
  Ipam?: Ipam;
}
export interface RequestIpamResourceTag {
  Key?: string;
  Value?: string;
}
export declare const IpamPoolAwsService: {
  readonly ec2: "ec2";
};
export type IpamPoolAwsService =
  (typeof IpamPoolAwsService)[keyof typeof IpamPoolAwsService];
export declare const IpamPoolPublicIpSource: {
  readonly amazon: "amazon";
  readonly byoip: "byoip";
};
export type IpamPoolPublicIpSource =
  (typeof IpamPoolPublicIpSource)[keyof typeof IpamPoolPublicIpSource];
export declare const IpamPoolSourceResourceType: {
  readonly vpc: "vpc";
};
export type IpamPoolSourceResourceType =
  (typeof IpamPoolSourceResourceType)[keyof typeof IpamPoolSourceResourceType];
export interface IpamPoolSourceResourceRequest {
  ResourceId?: string;
  ResourceType?: IpamPoolSourceResourceType;
  ResourceRegion?: string;
  ResourceOwner?: string;
}
export interface CreateIpamPoolRequest {
  DryRun?: boolean;
  IpamScopeId: string | undefined;
  Locale?: string;
  SourceIpamPoolId?: string;
  Description?: string;
  AddressFamily: AddressFamily | undefined;
  AutoImport?: boolean;
  PubliclyAdvertisable?: boolean;
  AllocationMinNetmaskLength?: number;
  AllocationMaxNetmaskLength?: number;
  AllocationDefaultNetmaskLength?: number;
  AllocationResourceTags?: RequestIpamResourceTag[];
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
  AwsService?: IpamPoolAwsService;
  PublicIpSource?: IpamPoolPublicIpSource;
  SourceResource?: IpamPoolSourceResourceRequest;
}
export interface IpamResourceTag {
  Key?: string;
  Value?: string;
}
export declare const IpamScopeType: {
  readonly private: "private";
  readonly public: "public";
};
export type IpamScopeType = (typeof IpamScopeType)[keyof typeof IpamScopeType];
export interface IpamPoolSourceResource {
  ResourceId?: string;
  ResourceType?: IpamPoolSourceResourceType;
  ResourceRegion?: string;
  ResourceOwner?: string;
}
export declare const IpamPoolState: {
  readonly create_complete: "create-complete";
  readonly create_failed: "create-failed";
  readonly create_in_progress: "create-in-progress";
  readonly delete_complete: "delete-complete";
  readonly delete_failed: "delete-failed";
  readonly delete_in_progress: "delete-in-progress";
  readonly isolate_complete: "isolate-complete";
  readonly isolate_in_progress: "isolate-in-progress";
  readonly modify_complete: "modify-complete";
  readonly modify_failed: "modify-failed";
  readonly modify_in_progress: "modify-in-progress";
  readonly restore_in_progress: "restore-in-progress";
};
export type IpamPoolState = (typeof IpamPoolState)[keyof typeof IpamPoolState];
export interface IpamPool {
  OwnerId?: string;
  IpamPoolId?: string;
  SourceIpamPoolId?: string;
  IpamPoolArn?: string;
  IpamScopeArn?: string;
  IpamScopeType?: IpamScopeType;
  IpamArn?: string;
  IpamRegion?: string;
  Locale?: string;
  PoolDepth?: number;
  State?: IpamPoolState;
  StateMessage?: string;
  Description?: string;
  AutoImport?: boolean;
  PubliclyAdvertisable?: boolean;
  AddressFamily?: AddressFamily;
  AllocationMinNetmaskLength?: number;
  AllocationMaxNetmaskLength?: number;
  AllocationDefaultNetmaskLength?: number;
  AllocationResourceTags?: IpamResourceTag[];
  Tags?: Tag[];
  AwsService?: IpamPoolAwsService;
  PublicIpSource?: IpamPoolPublicIpSource;
  SourceResource?: IpamPoolSourceResource;
}
export interface CreateIpamPoolResult {
  IpamPool?: IpamPool;
}
export interface CreateIpamResourceDiscoveryRequest {
  DryRun?: boolean;
  Description?: string;
  OperatingRegions?: AddIpamOperatingRegion[];
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
}
export declare const IpamResourceDiscoveryState: {
  readonly CREATE_COMPLETE: "create-complete";
  readonly CREATE_FAILED: "create-failed";
  readonly CREATE_IN_PROGRESS: "create-in-progress";
  readonly DELETE_COMPLETE: "delete-complete";
  readonly DELETE_FAILED: "delete-failed";
  readonly DELETE_IN_PROGRESS: "delete-in-progress";
  readonly ISOLATE_COMPLETE: "isolate-complete";
  readonly ISOLATE_IN_PROGRESS: "isolate-in-progress";
  readonly MODIFY_COMPLETE: "modify-complete";
  readonly MODIFY_FAILED: "modify-failed";
  readonly MODIFY_IN_PROGRESS: "modify-in-progress";
  readonly RESTORE_IN_PROGRESS: "restore-in-progress";
};
export type IpamResourceDiscoveryState =
  (typeof IpamResourceDiscoveryState)[keyof typeof IpamResourceDiscoveryState];
export interface IpamResourceDiscovery {
  OwnerId?: string;
  IpamResourceDiscoveryId?: string;
  IpamResourceDiscoveryArn?: string;
  IpamResourceDiscoveryRegion?: string;
  Description?: string;
  OperatingRegions?: IpamOperatingRegion[];
  IsDefault?: boolean;
  State?: IpamResourceDiscoveryState;
  Tags?: Tag[];
}
export interface CreateIpamResourceDiscoveryResult {
  IpamResourceDiscovery?: IpamResourceDiscovery;
}
export interface CreateIpamScopeRequest {
  DryRun?: boolean;
  IpamId: string | undefined;
  Description?: string;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
}
export declare const IpamScopeState: {
  readonly create_complete: "create-complete";
  readonly create_failed: "create-failed";
  readonly create_in_progress: "create-in-progress";
  readonly delete_complete: "delete-complete";
  readonly delete_failed: "delete-failed";
  readonly delete_in_progress: "delete-in-progress";
  readonly isolate_complete: "isolate-complete";
  readonly isolate_in_progress: "isolate-in-progress";
  readonly modify_complete: "modify-complete";
  readonly modify_failed: "modify-failed";
  readonly modify_in_progress: "modify-in-progress";
  readonly restore_in_progress: "restore-in-progress";
};
export type IpamScopeState =
  (typeof IpamScopeState)[keyof typeof IpamScopeState];
export interface IpamScope {
  OwnerId?: string;
  IpamScopeId?: string;
  IpamScopeArn?: string;
  IpamArn?: string;
  IpamRegion?: string;
  IpamScopeType?: IpamScopeType;
  IsDefault?: boolean;
  Description?: string;
  PoolCount?: number;
  State?: IpamScopeState;
  Tags?: Tag[];
}
export interface CreateIpamScopeResult {
  IpamScope?: IpamScope;
}
export declare const KeyFormat: {
  readonly pem: "pem";
  readonly ppk: "ppk";
};
export type KeyFormat = (typeof KeyFormat)[keyof typeof KeyFormat];
export declare const KeyType: {
  readonly ed25519: "ed25519";
  readonly rsa: "rsa";
};
export type KeyType = (typeof KeyType)[keyof typeof KeyType];
export interface CreateKeyPairRequest {
  KeyName: string | undefined;
  DryRun?: boolean;
  KeyType?: KeyType;
  TagSpecifications?: TagSpecification[];
  KeyFormat?: KeyFormat;
}
export interface KeyPair {
  KeyFingerprint?: string;
  KeyMaterial?: string;
  KeyName?: string;
  KeyPairId?: string;
  Tags?: Tag[];
}
export interface LaunchTemplateEbsBlockDeviceRequest {
  Encrypted?: boolean;
  DeleteOnTermination?: boolean;
  Iops?: number;
  KmsKeyId?: string;
  SnapshotId?: string;
  VolumeSize?: number;
  VolumeType?: VolumeType;
  Throughput?: number;
}
export interface LaunchTemplateBlockDeviceMappingRequest {
  DeviceName?: string;
  VirtualName?: string;
  Ebs?: LaunchTemplateEbsBlockDeviceRequest;
  NoDevice?: string;
}
export declare const CapacityReservationPreference: {
  readonly none: "none";
  readonly open: "open";
};
export type CapacityReservationPreference =
  (typeof CapacityReservationPreference)[keyof typeof CapacityReservationPreference];
export interface CapacityReservationTarget {
  CapacityReservationId?: string;
  CapacityReservationResourceGroupArn?: string;
}
export interface LaunchTemplateCapacityReservationSpecificationRequest {
  CapacityReservationPreference?: CapacityReservationPreference;
  CapacityReservationTarget?: CapacityReservationTarget;
}
export declare const AmdSevSnpSpecification: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type AmdSevSnpSpecification =
  (typeof AmdSevSnpSpecification)[keyof typeof AmdSevSnpSpecification];
export interface LaunchTemplateCpuOptionsRequest {
  CoreCount?: number;
  ThreadsPerCore?: number;
  AmdSevSnp?: AmdSevSnpSpecification;
}
export interface CreditSpecificationRequest {
  CpuCredits: string | undefined;
}
export interface ElasticGpuSpecification {
  Type: string | undefined;
}
export interface LaunchTemplateElasticInferenceAccelerator {
  Type: string | undefined;
  Count?: number;
}
export interface LaunchTemplateEnclaveOptionsRequest {
  Enabled?: boolean;
}
export interface LaunchTemplateHibernationOptionsRequest {
  Configured?: boolean;
}
export interface LaunchTemplateIamInstanceProfileSpecificationRequest {
  Arn?: string;
  Name?: string;
}
export declare const ShutdownBehavior: {
  readonly stop: "stop";
  readonly terminate: "terminate";
};
export type ShutdownBehavior =
  (typeof ShutdownBehavior)[keyof typeof ShutdownBehavior];
export declare const MarketType: {
  readonly capacity_block: "capacity-block";
  readonly spot: "spot";
};
export type MarketType = (typeof MarketType)[keyof typeof MarketType];
export declare const InstanceInterruptionBehavior: {
  readonly hibernate: "hibernate";
  readonly stop: "stop";
  readonly terminate: "terminate";
};
export type InstanceInterruptionBehavior =
  (typeof InstanceInterruptionBehavior)[keyof typeof InstanceInterruptionBehavior];
export declare const SpotInstanceType: {
  readonly one_time: "one-time";
  readonly persistent: "persistent";
};
export type SpotInstanceType =
  (typeof SpotInstanceType)[keyof typeof SpotInstanceType];
export interface LaunchTemplateSpotMarketOptionsRequest {
  MaxPrice?: string;
  SpotInstanceType?: SpotInstanceType;
  BlockDurationMinutes?: number;
  ValidUntil?: Date;
  InstanceInterruptionBehavior?: InstanceInterruptionBehavior;
}
export interface LaunchTemplateInstanceMarketOptionsRequest {
  MarketType?: MarketType;
  SpotOptions?: LaunchTemplateSpotMarketOptionsRequest;
}
export interface LaunchTemplateLicenseConfigurationRequest {
  LicenseConfigurationArn?: string;
}
export declare const LaunchTemplateAutoRecoveryState: {
  readonly default: "default";
  readonly disabled: "disabled";
};
export type LaunchTemplateAutoRecoveryState =
  (typeof LaunchTemplateAutoRecoveryState)[keyof typeof LaunchTemplateAutoRecoveryState];
export interface LaunchTemplateInstanceMaintenanceOptionsRequest {
  AutoRecovery?: LaunchTemplateAutoRecoveryState;
}
export declare const LaunchTemplateInstanceMetadataEndpointState: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type LaunchTemplateInstanceMetadataEndpointState =
  (typeof LaunchTemplateInstanceMetadataEndpointState)[keyof typeof LaunchTemplateInstanceMetadataEndpointState];
export declare const LaunchTemplateInstanceMetadataProtocolIpv6: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type LaunchTemplateInstanceMetadataProtocolIpv6 =
  (typeof LaunchTemplateInstanceMetadataProtocolIpv6)[keyof typeof LaunchTemplateInstanceMetadataProtocolIpv6];
export declare const LaunchTemplateHttpTokensState: {
  readonly optional: "optional";
  readonly required: "required";
};
export type LaunchTemplateHttpTokensState =
  (typeof LaunchTemplateHttpTokensState)[keyof typeof LaunchTemplateHttpTokensState];
export declare const LaunchTemplateInstanceMetadataTagsState: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type LaunchTemplateInstanceMetadataTagsState =
  (typeof LaunchTemplateInstanceMetadataTagsState)[keyof typeof LaunchTemplateInstanceMetadataTagsState];
export interface LaunchTemplateInstanceMetadataOptionsRequest {
  HttpTokens?: LaunchTemplateHttpTokensState;
  HttpPutResponseHopLimit?: number;
  HttpEndpoint?: LaunchTemplateInstanceMetadataEndpointState;
  HttpProtocolIpv6?: LaunchTemplateInstanceMetadataProtocolIpv6;
  InstanceMetadataTags?: LaunchTemplateInstanceMetadataTagsState;
}
export interface LaunchTemplatesMonitoringRequest {
  Enabled?: boolean;
}
export interface ConnectionTrackingSpecificationRequest {
  TcpEstablishedTimeout?: number;
  UdpStreamTimeout?: number;
  UdpTimeout?: number;
}
export interface EnaSrdUdpSpecificationRequest {
  EnaSrdUdpEnabled?: boolean;
}
export interface EnaSrdSpecificationRequest {
  EnaSrdEnabled?: boolean;
  EnaSrdUdpSpecification?: EnaSrdUdpSpecificationRequest;
}
export interface Ipv4PrefixSpecificationRequest {
  Ipv4Prefix?: string;
}
export interface InstanceIpv6AddressRequest {
  Ipv6Address?: string;
}
export interface Ipv6PrefixSpecificationRequest {
  Ipv6Prefix?: string;
}
export interface PrivateIpAddressSpecification {
  Primary?: boolean;
  PrivateIpAddress?: string;
}
export interface LaunchTemplateInstanceNetworkInterfaceSpecificationRequest {
  AssociateCarrierIpAddress?: boolean;
  AssociatePublicIpAddress?: boolean;
  DeleteOnTermination?: boolean;
  Description?: string;
  DeviceIndex?: number;
  Groups?: string[];
  InterfaceType?: string;
  Ipv6AddressCount?: number;
  Ipv6Addresses?: InstanceIpv6AddressRequest[];
  NetworkInterfaceId?: string;
  PrivateIpAddress?: string;
  PrivateIpAddresses?: PrivateIpAddressSpecification[];
  SecondaryPrivateIpAddressCount?: number;
  SubnetId?: string;
  NetworkCardIndex?: number;
  Ipv4Prefixes?: Ipv4PrefixSpecificationRequest[];
  Ipv4PrefixCount?: number;
  Ipv6Prefixes?: Ipv6PrefixSpecificationRequest[];
  Ipv6PrefixCount?: number;
  PrimaryIpv6?: boolean;
  EnaSrdSpecification?: EnaSrdSpecificationRequest;
  ConnectionTrackingSpecification?: ConnectionTrackingSpecificationRequest;
}
export interface LaunchTemplatePlacementRequest {
  AvailabilityZone?: string;
  Affinity?: string;
  GroupName?: string;
  HostId?: string;
  Tenancy?: Tenancy;
  SpreadDomain?: string;
  HostResourceGroupArn?: string;
  PartitionNumber?: number;
  GroupId?: string;
}
export interface LaunchTemplatePrivateDnsNameOptionsRequest {
  HostnameType?: HostnameType;
  EnableResourceNameDnsARecord?: boolean;
  EnableResourceNameDnsAAAARecord?: boolean;
}
export interface LaunchTemplateTagSpecificationRequest {
  ResourceType?: ResourceType;
  Tags?: Tag[];
}
export interface RequestLaunchTemplateData {
  KernelId?: string;
  EbsOptimized?: boolean;
  IamInstanceProfile?: LaunchTemplateIamInstanceProfileSpecificationRequest;
  BlockDeviceMappings?: LaunchTemplateBlockDeviceMappingRequest[];
  NetworkInterfaces?: LaunchTemplateInstanceNetworkInterfaceSpecificationRequest[];
  ImageId?: string;
  InstanceType?: _InstanceType;
  KeyName?: string;
  Monitoring?: LaunchTemplatesMonitoringRequest;
  Placement?: LaunchTemplatePlacementRequest;
  RamDiskId?: string;
  DisableApiTermination?: boolean;
  InstanceInitiatedShutdownBehavior?: ShutdownBehavior;
  UserData?: string;
  TagSpecifications?: LaunchTemplateTagSpecificationRequest[];
  ElasticGpuSpecifications?: ElasticGpuSpecification[];
  ElasticInferenceAccelerators?: LaunchTemplateElasticInferenceAccelerator[];
  SecurityGroupIds?: string[];
  SecurityGroups?: string[];
  InstanceMarketOptions?: LaunchTemplateInstanceMarketOptionsRequest;
  CreditSpecification?: CreditSpecificationRequest;
  CpuOptions?: LaunchTemplateCpuOptionsRequest;
  CapacityReservationSpecification?: LaunchTemplateCapacityReservationSpecificationRequest;
  LicenseSpecifications?: LaunchTemplateLicenseConfigurationRequest[];
  HibernationOptions?: LaunchTemplateHibernationOptionsRequest;
  MetadataOptions?: LaunchTemplateInstanceMetadataOptionsRequest;
  EnclaveOptions?: LaunchTemplateEnclaveOptionsRequest;
  InstanceRequirements?: InstanceRequirementsRequest;
  PrivateDnsNameOptions?: LaunchTemplatePrivateDnsNameOptionsRequest;
  MaintenanceOptions?: LaunchTemplateInstanceMaintenanceOptionsRequest;
  DisableApiStop?: boolean;
}
export interface CreateLaunchTemplateRequest {
  DryRun?: boolean;
  ClientToken?: string;
  LaunchTemplateName: string | undefined;
  VersionDescription?: string;
  LaunchTemplateData: RequestLaunchTemplateData | undefined;
  TagSpecifications?: TagSpecification[];
}
export interface LaunchTemplate {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  CreateTime?: Date;
  CreatedBy?: string;
  DefaultVersionNumber?: number;
  LatestVersionNumber?: number;
  Tags?: Tag[];
}
export interface ValidationError {
  Code?: string;
  Message?: string;
}
export interface ValidationWarning {
  Errors?: ValidationError[];
}
export interface CreateLaunchTemplateResult {
  LaunchTemplate?: LaunchTemplate;
  Warning?: ValidationWarning;
}
export interface CreateLaunchTemplateVersionRequest {
  DryRun?: boolean;
  ClientToken?: string;
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  SourceVersion?: string;
  VersionDescription?: string;
  LaunchTemplateData: RequestLaunchTemplateData | undefined;
  ResolveAlias?: boolean;
}
export interface LaunchTemplateEbsBlockDevice {
  Encrypted?: boolean;
  DeleteOnTermination?: boolean;
  Iops?: number;
  KmsKeyId?: string;
  SnapshotId?: string;
  VolumeSize?: number;
  VolumeType?: VolumeType;
  Throughput?: number;
}
export interface LaunchTemplateBlockDeviceMapping {
  DeviceName?: string;
  VirtualName?: string;
  Ebs?: LaunchTemplateEbsBlockDevice;
  NoDevice?: string;
}
export interface CapacityReservationTargetResponse {
  CapacityReservationId?: string;
  CapacityReservationResourceGroupArn?: string;
}
export interface LaunchTemplateCapacityReservationSpecificationResponse {
  CapacityReservationPreference?: CapacityReservationPreference;
  CapacityReservationTarget?: CapacityReservationTargetResponse;
}
export interface LaunchTemplateCpuOptions {
  CoreCount?: number;
  ThreadsPerCore?: number;
  AmdSevSnp?: AmdSevSnpSpecification;
}
export interface CreditSpecification {
  CpuCredits?: string;
}
export interface ElasticGpuSpecificationResponse {
  Type?: string;
}
export interface LaunchTemplateElasticInferenceAcceleratorResponse {
  Type?: string;
  Count?: number;
}
export interface LaunchTemplateEnclaveOptions {
  Enabled?: boolean;
}
export interface LaunchTemplateHibernationOptions {
  Configured?: boolean;
}
export interface LaunchTemplateIamInstanceProfileSpecification {
  Arn?: string;
  Name?: string;
}
export interface LaunchTemplateSpotMarketOptions {
  MaxPrice?: string;
  SpotInstanceType?: SpotInstanceType;
  BlockDurationMinutes?: number;
  ValidUntil?: Date;
  InstanceInterruptionBehavior?: InstanceInterruptionBehavior;
}
export interface LaunchTemplateInstanceMarketOptions {
  MarketType?: MarketType;
  SpotOptions?: LaunchTemplateSpotMarketOptions;
}
export interface LaunchTemplateLicenseConfiguration {
  LicenseConfigurationArn?: string;
}
export interface LaunchTemplateInstanceMaintenanceOptions {
  AutoRecovery?: LaunchTemplateAutoRecoveryState;
}
export declare const LaunchTemplateInstanceMetadataOptionsState: {
  readonly applied: "applied";
  readonly pending: "pending";
};
export type LaunchTemplateInstanceMetadataOptionsState =
  (typeof LaunchTemplateInstanceMetadataOptionsState)[keyof typeof LaunchTemplateInstanceMetadataOptionsState];
export interface LaunchTemplateInstanceMetadataOptions {
  State?: LaunchTemplateInstanceMetadataOptionsState;
  HttpTokens?: LaunchTemplateHttpTokensState;
  HttpPutResponseHopLimit?: number;
  HttpEndpoint?: LaunchTemplateInstanceMetadataEndpointState;
  HttpProtocolIpv6?: LaunchTemplateInstanceMetadataProtocolIpv6;
  InstanceMetadataTags?: LaunchTemplateInstanceMetadataTagsState;
}
export interface LaunchTemplatesMonitoring {
  Enabled?: boolean;
}
export interface ConnectionTrackingSpecification {
  TcpEstablishedTimeout?: number;
  UdpTimeout?: number;
  UdpStreamTimeout?: number;
}
export interface LaunchTemplateEnaSrdUdpSpecification {
  EnaSrdUdpEnabled?: boolean;
}
export interface LaunchTemplateEnaSrdSpecification {
  EnaSrdEnabled?: boolean;
  EnaSrdUdpSpecification?: LaunchTemplateEnaSrdUdpSpecification;
}
export interface Ipv4PrefixSpecificationResponse {
  Ipv4Prefix?: string;
}
export interface InstanceIpv6Address {
  Ipv6Address?: string;
  IsPrimaryIpv6?: boolean;
}
export interface Ipv6PrefixSpecificationResponse {
  Ipv6Prefix?: string;
}
export interface LaunchTemplateInstanceNetworkInterfaceSpecification {
  AssociateCarrierIpAddress?: boolean;
  AssociatePublicIpAddress?: boolean;
  DeleteOnTermination?: boolean;
  Description?: string;
  DeviceIndex?: number;
  Groups?: string[];
  InterfaceType?: string;
  Ipv6AddressCount?: number;
  Ipv6Addresses?: InstanceIpv6Address[];
  NetworkInterfaceId?: string;
  PrivateIpAddress?: string;
  PrivateIpAddresses?: PrivateIpAddressSpecification[];
  SecondaryPrivateIpAddressCount?: number;
  SubnetId?: string;
  NetworkCardIndex?: number;
  Ipv4Prefixes?: Ipv4PrefixSpecificationResponse[];
  Ipv4PrefixCount?: number;
  Ipv6Prefixes?: Ipv6PrefixSpecificationResponse[];
  Ipv6PrefixCount?: number;
  PrimaryIpv6?: boolean;
  EnaSrdSpecification?: LaunchTemplateEnaSrdSpecification;
  ConnectionTrackingSpecification?: ConnectionTrackingSpecification;
}
export interface LaunchTemplatePlacement {
  AvailabilityZone?: string;
  Affinity?: string;
  GroupName?: string;
  HostId?: string;
  Tenancy?: Tenancy;
  SpreadDomain?: string;
  HostResourceGroupArn?: string;
  PartitionNumber?: number;
  GroupId?: string;
}
export interface LaunchTemplatePrivateDnsNameOptions {
  HostnameType?: HostnameType;
  EnableResourceNameDnsARecord?: boolean;
  EnableResourceNameDnsAAAARecord?: boolean;
}
export interface LaunchTemplateTagSpecification {
  ResourceType?: ResourceType;
  Tags?: Tag[];
}
export interface ResponseLaunchTemplateData {
  KernelId?: string;
  EbsOptimized?: boolean;
  IamInstanceProfile?: LaunchTemplateIamInstanceProfileSpecification;
  BlockDeviceMappings?: LaunchTemplateBlockDeviceMapping[];
  NetworkInterfaces?: LaunchTemplateInstanceNetworkInterfaceSpecification[];
  ImageId?: string;
  InstanceType?: _InstanceType;
  KeyName?: string;
  Monitoring?: LaunchTemplatesMonitoring;
  Placement?: LaunchTemplatePlacement;
  RamDiskId?: string;
  DisableApiTermination?: boolean;
  InstanceInitiatedShutdownBehavior?: ShutdownBehavior;
  UserData?: string;
  TagSpecifications?: LaunchTemplateTagSpecification[];
  ElasticGpuSpecifications?: ElasticGpuSpecificationResponse[];
  ElasticInferenceAccelerators?: LaunchTemplateElasticInferenceAcceleratorResponse[];
  SecurityGroupIds?: string[];
  SecurityGroups?: string[];
  InstanceMarketOptions?: LaunchTemplateInstanceMarketOptions;
  CreditSpecification?: CreditSpecification;
  CpuOptions?: LaunchTemplateCpuOptions;
  CapacityReservationSpecification?: LaunchTemplateCapacityReservationSpecificationResponse;
  LicenseSpecifications?: LaunchTemplateLicenseConfiguration[];
  HibernationOptions?: LaunchTemplateHibernationOptions;
  MetadataOptions?: LaunchTemplateInstanceMetadataOptions;
  EnclaveOptions?: LaunchTemplateEnclaveOptions;
  InstanceRequirements?: InstanceRequirements;
  PrivateDnsNameOptions?: LaunchTemplatePrivateDnsNameOptions;
  MaintenanceOptions?: LaunchTemplateInstanceMaintenanceOptions;
  DisableApiStop?: boolean;
}
export interface LaunchTemplateVersion {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  VersionNumber?: number;
  VersionDescription?: string;
  CreateTime?: Date;
  CreatedBy?: string;
  DefaultVersion?: boolean;
  LaunchTemplateData?: ResponseLaunchTemplateData;
}
export interface CreateLaunchTemplateVersionResult {
  LaunchTemplateVersion?: LaunchTemplateVersion;
  Warning?: ValidationWarning;
}
export interface CreateLocalGatewayRouteRequest {
  DestinationCidrBlock?: string;
  LocalGatewayRouteTableId: string | undefined;
  LocalGatewayVirtualInterfaceGroupId?: string;
  DryRun?: boolean;
  NetworkInterfaceId?: string;
  DestinationPrefixListId?: string;
}
export declare const LocalGatewayRouteState: {
  readonly active: "active";
  readonly blackhole: "blackhole";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type LocalGatewayRouteState =
  (typeof LocalGatewayRouteState)[keyof typeof LocalGatewayRouteState];
export declare const LocalGatewayRouteType: {
  readonly propagated: "propagated";
  readonly static: "static";
};
export type LocalGatewayRouteType =
  (typeof LocalGatewayRouteType)[keyof typeof LocalGatewayRouteType];
export interface LocalGatewayRoute {
  DestinationCidrBlock?: string;
  LocalGatewayVirtualInterfaceGroupId?: string;
  Type?: LocalGatewayRouteType;
  State?: LocalGatewayRouteState;
  LocalGatewayRouteTableId?: string;
  LocalGatewayRouteTableArn?: string;
  OwnerId?: string;
  SubnetId?: string;
  CoipPoolId?: string;
  NetworkInterfaceId?: string;
  DestinationPrefixListId?: string;
}
export interface CreateLocalGatewayRouteResult {
  Route?: LocalGatewayRoute;
}
export declare const LocalGatewayRouteTableMode: {
  readonly coip: "coip";
  readonly direct_vpc_routing: "direct-vpc-routing";
};
export type LocalGatewayRouteTableMode =
  (typeof LocalGatewayRouteTableMode)[keyof typeof LocalGatewayRouteTableMode];
export interface CreateLocalGatewayRouteTableRequest {
  LocalGatewayId: string | undefined;
  Mode?: LocalGatewayRouteTableMode;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface StateReason {
  Code?: string;
  Message?: string;
}
export interface LocalGatewayRouteTable {
  LocalGatewayRouteTableId?: string;
  LocalGatewayRouteTableArn?: string;
  LocalGatewayId?: string;
  OutpostArn?: string;
  OwnerId?: string;
  State?: string;
  Tags?: Tag[];
  Mode?: LocalGatewayRouteTableMode;
  StateReason?: StateReason;
}
export interface CreateLocalGatewayRouteTableResult {
  LocalGatewayRouteTable?: LocalGatewayRouteTable;
}
export interface CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest {
  LocalGatewayRouteTableId: string | undefined;
  LocalGatewayVirtualInterfaceGroupId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface LocalGatewayRouteTableVirtualInterfaceGroupAssociation {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociationId?: string;
  LocalGatewayVirtualInterfaceGroupId?: string;
  LocalGatewayId?: string;
  LocalGatewayRouteTableId?: string;
  LocalGatewayRouteTableArn?: string;
  OwnerId?: string;
  State?: string;
  Tags?: Tag[];
}
export interface CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociation?: LocalGatewayRouteTableVirtualInterfaceGroupAssociation;
}
export interface CreateLocalGatewayRouteTableVpcAssociationRequest {
  LocalGatewayRouteTableId: string | undefined;
  VpcId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface LocalGatewayRouteTableVpcAssociation {
  LocalGatewayRouteTableVpcAssociationId?: string;
  LocalGatewayRouteTableId?: string;
  LocalGatewayRouteTableArn?: string;
  LocalGatewayId?: string;
  VpcId?: string;
  OwnerId?: string;
  State?: string;
  Tags?: Tag[];
}
export interface CreateLocalGatewayRouteTableVpcAssociationResult {
  LocalGatewayRouteTableVpcAssociation?: LocalGatewayRouteTableVpcAssociation;
}
export interface CreateManagedPrefixListRequest {
  DryRun?: boolean;
  PrefixListName: string | undefined;
  Entries?: AddPrefixListEntry[];
  MaxEntries: number | undefined;
  TagSpecifications?: TagSpecification[];
  AddressFamily: string | undefined;
  ClientToken?: string;
}
export declare const PrefixListState: {
  readonly create_complete: "create-complete";
  readonly create_failed: "create-failed";
  readonly create_in_progress: "create-in-progress";
  readonly delete_complete: "delete-complete";
  readonly delete_failed: "delete-failed";
  readonly delete_in_progress: "delete-in-progress";
  readonly modify_complete: "modify-complete";
  readonly modify_failed: "modify-failed";
  readonly modify_in_progress: "modify-in-progress";
  readonly restore_complete: "restore-complete";
  readonly restore_failed: "restore-failed";
  readonly restore_in_progress: "restore-in-progress";
};
export type PrefixListState =
  (typeof PrefixListState)[keyof typeof PrefixListState];
export interface ManagedPrefixList {
  PrefixListId?: string;
  AddressFamily?: string;
  State?: PrefixListState;
  StateMessage?: string;
  PrefixListArn?: string;
  PrefixListName?: string;
  MaxEntries?: number;
  Version?: number;
  Tags?: Tag[];
  OwnerId?: string;
}
export interface CreateManagedPrefixListResult {
  PrefixList?: ManagedPrefixList;
}
export declare const ConnectivityType: {
  readonly PRIVATE: "private";
  readonly PUBLIC: "public";
};
export type ConnectivityType =
  (typeof ConnectivityType)[keyof typeof ConnectivityType];
export interface CreateNatGatewayRequest {
  AllocationId?: string;
  ClientToken?: string;
  DryRun?: boolean;
  SubnetId: string | undefined;
  TagSpecifications?: TagSpecification[];
  ConnectivityType?: ConnectivityType;
  PrivateIpAddress?: string;
  SecondaryAllocationIds?: string[];
  SecondaryPrivateIpAddresses?: string[];
  SecondaryPrivateIpAddressCount?: number;
}
export interface ProvisionedBandwidth {
  ProvisionTime?: Date;
  Provisioned?: string;
  RequestTime?: Date;
  Requested?: string;
  Status?: string;
}
export declare const NatGatewayState: {
  readonly AVAILABLE: "available";
  readonly DELETED: "deleted";
  readonly DELETING: "deleting";
  readonly FAILED: "failed";
  readonly PENDING: "pending";
};
export type NatGatewayState =
  (typeof NatGatewayState)[keyof typeof NatGatewayState];
export interface NatGateway {
  CreateTime?: Date;
  DeleteTime?: Date;
  FailureCode?: string;
  FailureMessage?: string;
  NatGatewayAddresses?: NatGatewayAddress[];
  NatGatewayId?: string;
  ProvisionedBandwidth?: ProvisionedBandwidth;
  State?: NatGatewayState;
  SubnetId?: string;
  VpcId?: string;
  Tags?: Tag[];
  ConnectivityType?: ConnectivityType;
}
export interface CreateNatGatewayResult {
  ClientToken?: string;
  NatGateway?: NatGateway;
}
export interface CreateNetworkAclRequest {
  DryRun?: boolean;
  VpcId: string | undefined;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
}
export interface NetworkAclAssociation {
  NetworkAclAssociationId?: string;
  NetworkAclId?: string;
  SubnetId?: string;
}
export interface IcmpTypeCode {
  Code?: number;
  Type?: number;
}
export declare const RuleAction: {
  readonly allow: "allow";
  readonly deny: "deny";
};
export type RuleAction = (typeof RuleAction)[keyof typeof RuleAction];
export interface NetworkAclEntry {
  CidrBlock?: string;
  Egress?: boolean;
  IcmpTypeCode?: IcmpTypeCode;
  Ipv6CidrBlock?: string;
  PortRange?: PortRange;
  Protocol?: string;
  RuleAction?: RuleAction;
  RuleNumber?: number;
}
export interface NetworkAcl {
  Associations?: NetworkAclAssociation[];
  Entries?: NetworkAclEntry[];
  IsDefault?: boolean;
  NetworkAclId?: string;
  Tags?: Tag[];
  VpcId?: string;
  OwnerId?: string;
}
export interface CreateNetworkAclResult {
  NetworkAcl?: NetworkAcl;
  ClientToken?: string;
}
export interface CreateNetworkAclEntryRequest {
  CidrBlock?: string;
  DryRun?: boolean;
  Egress: boolean | undefined;
  IcmpTypeCode?: IcmpTypeCode;
  Ipv6CidrBlock?: string;
  NetworkAclId: string | undefined;
  PortRange?: PortRange;
  Protocol: string | undefined;
  RuleAction: RuleAction | undefined;
  RuleNumber: number | undefined;
}
export interface CreateNetworkInsightsAccessScopeRequest {
  MatchPaths?: AccessScopePathRequest[];
  ExcludePaths?: AccessScopePathRequest[];
  ClientToken?: string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface NetworkInsightsAccessScope {
  NetworkInsightsAccessScopeId?: string;
  NetworkInsightsAccessScopeArn?: string;
  CreatedDate?: Date;
  UpdatedDate?: Date;
  Tags?: Tag[];
}
export interface NetworkInsightsAccessScopeContent {
  NetworkInsightsAccessScopeId?: string;
  MatchPaths?: AccessScopePath[];
  ExcludePaths?: AccessScopePath[];
}
export interface CreateNetworkInsightsAccessScopeResult {
  NetworkInsightsAccessScope?: NetworkInsightsAccessScope;
  NetworkInsightsAccessScopeContent?: NetworkInsightsAccessScopeContent;
}
export interface RequestFilterPortRange {
  FromPort?: number;
  ToPort?: number;
}
export interface PathRequestFilter {
  SourceAddress?: string;
  SourcePortRange?: RequestFilterPortRange;
  DestinationAddress?: string;
  DestinationPortRange?: RequestFilterPortRange;
}
export interface CreateNetworkInsightsPathRequest {
  SourceIp?: string;
  DestinationIp?: string;
  Source: string | undefined;
  Destination?: string;
  Protocol: Protocol | undefined;
  DestinationPort?: number;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
  ClientToken?: string;
  FilterAtSource?: PathRequestFilter;
  FilterAtDestination?: PathRequestFilter;
}
export interface FilterPortRange {
  FromPort?: number;
  ToPort?: number;
}
export interface PathFilter {
  SourceAddress?: string;
  SourcePortRange?: FilterPortRange;
  DestinationAddress?: string;
  DestinationPortRange?: FilterPortRange;
}
export interface NetworkInsightsPath {
  NetworkInsightsPathId?: string;
  NetworkInsightsPathArn?: string;
  CreatedDate?: Date;
  Source?: string;
  Destination?: string;
  SourceArn?: string;
  DestinationArn?: string;
  SourceIp?: string;
  DestinationIp?: string;
  Protocol?: Protocol;
  DestinationPort?: number;
  Tags?: Tag[];
  FilterAtSource?: PathFilter;
  FilterAtDestination?: PathFilter;
}
export interface CreateNetworkInsightsPathResult {
  NetworkInsightsPath?: NetworkInsightsPath;
}
export declare const NetworkInterfaceCreationType: {
  readonly branch: "branch";
  readonly efa: "efa";
  readonly trunk: "trunk";
};
export type NetworkInterfaceCreationType =
  (typeof NetworkInterfaceCreationType)[keyof typeof NetworkInterfaceCreationType];
export interface CreateNetworkInterfaceRequest {
  Description?: string;
  DryRun?: boolean;
  Groups?: string[];
  Ipv6AddressCount?: number;
  Ipv6Addresses?: InstanceIpv6Address[];
  PrivateIpAddress?: string;
  PrivateIpAddresses?: PrivateIpAddressSpecification[];
  SecondaryPrivateIpAddressCount?: number;
  Ipv4Prefixes?: Ipv4PrefixSpecificationRequest[];
  Ipv4PrefixCount?: number;
  Ipv6Prefixes?: Ipv6PrefixSpecificationRequest[];
  Ipv6PrefixCount?: number;
  InterfaceType?: NetworkInterfaceCreationType;
  SubnetId: string | undefined;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
  EnablePrimaryIpv6?: boolean;
  ConnectionTrackingSpecification?: ConnectionTrackingSpecificationRequest;
}
export interface NetworkInterfaceAssociation {
  AllocationId?: string;
  AssociationId?: string;
  IpOwnerId?: string;
  PublicDnsName?: string;
  PublicIp?: string;
  CustomerOwnedIp?: string;
  CarrierIp?: string;
}
export interface AttachmentEnaSrdUdpSpecification {
  EnaSrdUdpEnabled?: boolean;
}
export interface AttachmentEnaSrdSpecification {
  EnaSrdEnabled?: boolean;
  EnaSrdUdpSpecification?: AttachmentEnaSrdUdpSpecification;
}
export interface NetworkInterfaceAttachment {
  AttachTime?: Date;
  AttachmentId?: string;
  DeleteOnTermination?: boolean;
  DeviceIndex?: number;
  NetworkCardIndex?: number;
  InstanceId?: string;
  InstanceOwnerId?: string;
  Status?: AttachmentStatus;
  EnaSrdSpecification?: AttachmentEnaSrdSpecification;
}
export interface ConnectionTrackingConfiguration {
  TcpEstablishedTimeout?: number;
  UdpStreamTimeout?: number;
  UdpTimeout?: number;
}
export interface GroupIdentifier {
  GroupName?: string;
  GroupId?: string;
}
export declare const NetworkInterfaceType: {
  readonly api_gateway_managed: "api_gateway_managed";
  readonly aws_codestar_connections_managed: "aws_codestar_connections_managed";
  readonly branch: "branch";
  readonly efa: "efa";
  readonly gateway_load_balancer: "gateway_load_balancer";
  readonly gateway_load_balancer_endpoint: "gateway_load_balancer_endpoint";
  readonly global_accelerator_managed: "global_accelerator_managed";
  readonly interface: "interface";
  readonly iot_rules_managed: "iot_rules_managed";
  readonly lambda: "lambda";
  readonly load_balancer: "load_balancer";
  readonly natGateway: "natGateway";
  readonly network_load_balancer: "network_load_balancer";
  readonly quicksight: "quicksight";
  readonly transit_gateway: "transit_gateway";
  readonly trunk: "trunk";
  readonly vpc_endpoint: "vpc_endpoint";
};
export type NetworkInterfaceType =
  (typeof NetworkInterfaceType)[keyof typeof NetworkInterfaceType];
export declare const KeyPairFilterSensitiveLog: (obj: KeyPair) => any;
export declare const RequestLaunchTemplateDataFilterSensitiveLog: (
  obj: RequestLaunchTemplateData
) => any;
export declare const CreateLaunchTemplateRequestFilterSensitiveLog: (
  obj: CreateLaunchTemplateRequest
) => any;
export declare const CreateLaunchTemplateVersionRequestFilterSensitiveLog: (
  obj: CreateLaunchTemplateVersionRequest
) => any;
export declare const ResponseLaunchTemplateDataFilterSensitiveLog: (
  obj: ResponseLaunchTemplateData
) => any;
export declare const LaunchTemplateVersionFilterSensitiveLog: (
  obj: LaunchTemplateVersion
) => any;
export declare const CreateLaunchTemplateVersionResultFilterSensitiveLog: (
  obj: CreateLaunchTemplateVersionResult
) => any;
