import {
  ApplianceModeSupportValue,
  CurrencyCodeValues,
  DeviceTrustProviderType,
  DnsSupportValue,
  DynamicRoutingValue,
  InstanceEventWindowState,
  Ipv4PrefixSpecification,
  Ipv6SupportValue,
  ReservedInstancesListing,
  RouteTableAssociationState,
  SecurityGroupReferencingSupportValue,
  Tag,
  TagSpecification,
  TransitGatewayAttachmentResourceType,
  TransitGatewayAttachmentState,
  TransitGatewayPeeringAttachment,
  TransitGatewayVpcAttachment,
  TrustProviderType,
  UnsuccessfulItem,
  UserTrustProviderType,
  VerifiedAccessInstance,
  VerifiedAccessSseSpecificationResponse,
  VerifiedAccessTrustProvider,
  VolumeAttachment,
  VpcAttachment,
  VpcPeeringConnection,
} from "./models_0";
import {
  CarrierGateway,
  ClientVpnEndpointStatus,
  ClientVpnRouteStatus,
  CoipCidr,
  CoipPool,
  ConnectionTrackingConfiguration,
  Ec2InstanceConnectEndpoint,
  GatewayType,
  GroupIdentifier,
  Ipam,
  IpamPool,
  IpamResourceDiscovery,
  IpamScope,
  LaunchTemplate,
  LocalGatewayRoute,
  LocalGatewayRouteTable,
  LocalGatewayRouteTableVirtualInterfaceGroupAssociation,
  LocalGatewayRouteTableVpcAssociation,
  ManagedPrefixList,
  NetworkInterfaceAssociation,
  NetworkInterfaceAttachment,
  NetworkInterfaceType,
  Subnet,
  Tenancy,
  VolumeType,
  Vpc,
} from "./models_1";
export interface NetworkInterfaceIpv6Address {
  Ipv6Address?: string;
  IsPrimaryIpv6?: boolean;
}
export interface Ipv6PrefixSpecification {
  Ipv6Prefix?: string;
}
export interface NetworkInterfacePrivateIpAddress {
  Association?: NetworkInterfaceAssociation;
  Primary?: boolean;
  PrivateDnsName?: string;
  PrivateIpAddress?: string;
}
export declare const NetworkInterfaceStatus: {
  readonly associated: "associated";
  readonly attaching: "attaching";
  readonly available: "available";
  readonly detaching: "detaching";
  readonly in_use: "in-use";
};
export type NetworkInterfaceStatus =
  (typeof NetworkInterfaceStatus)[keyof typeof NetworkInterfaceStatus];
export interface NetworkInterface {
  Association?: NetworkInterfaceAssociation;
  Attachment?: NetworkInterfaceAttachment;
  AvailabilityZone?: string;
  ConnectionTrackingConfiguration?: ConnectionTrackingConfiguration;
  Description?: string;
  Groups?: GroupIdentifier[];
  InterfaceType?: NetworkInterfaceType;
  Ipv6Addresses?: NetworkInterfaceIpv6Address[];
  MacAddress?: string;
  NetworkInterfaceId?: string;
  OutpostArn?: string;
  OwnerId?: string;
  PrivateDnsName?: string;
  PrivateIpAddress?: string;
  PrivateIpAddresses?: NetworkInterfacePrivateIpAddress[];
  Ipv4Prefixes?: Ipv4PrefixSpecification[];
  Ipv6Prefixes?: Ipv6PrefixSpecification[];
  RequesterId?: string;
  RequesterManaged?: boolean;
  SourceDestCheck?: boolean;
  Status?: NetworkInterfaceStatus;
  SubnetId?: string;
  TagSet?: Tag[];
  VpcId?: string;
  DenyAllIgwTraffic?: boolean;
  Ipv6Native?: boolean;
  Ipv6Address?: string;
}
export interface CreateNetworkInterfaceResult {
  NetworkInterface?: NetworkInterface;
  ClientToken?: string;
}
export declare const InterfacePermissionType: {
  readonly EIP_ASSOCIATE: "EIP-ASSOCIATE";
  readonly INSTANCE_ATTACH: "INSTANCE-ATTACH";
};
export type InterfacePermissionType =
  (typeof InterfacePermissionType)[keyof typeof InterfacePermissionType];
export interface CreateNetworkInterfacePermissionRequest {
  NetworkInterfaceId: string | undefined;
  AwsAccountId?: string;
  AwsService?: string;
  Permission: InterfacePermissionType | undefined;
  DryRun?: boolean;
}
export declare const NetworkInterfacePermissionStateCode: {
  readonly granted: "granted";
  readonly pending: "pending";
  readonly revoked: "revoked";
  readonly revoking: "revoking";
};
export type NetworkInterfacePermissionStateCode =
  (typeof NetworkInterfacePermissionStateCode)[keyof typeof NetworkInterfacePermissionStateCode];
export interface NetworkInterfacePermissionState {
  State?: NetworkInterfacePermissionStateCode;
  StatusMessage?: string;
}
export interface NetworkInterfacePermission {
  NetworkInterfacePermissionId?: string;
  NetworkInterfaceId?: string;
  AwsAccountId?: string;
  AwsService?: string;
  Permission?: InterfacePermissionType;
  PermissionState?: NetworkInterfacePermissionState;
}
export interface CreateNetworkInterfacePermissionResult {
  InterfacePermission?: NetworkInterfacePermission;
}
export declare const SpreadLevel: {
  readonly host: "host";
  readonly rack: "rack";
};
export type SpreadLevel = (typeof SpreadLevel)[keyof typeof SpreadLevel];
export declare const PlacementStrategy: {
  readonly cluster: "cluster";
  readonly partition: "partition";
  readonly spread: "spread";
};
export type PlacementStrategy =
  (typeof PlacementStrategy)[keyof typeof PlacementStrategy];
export interface CreatePlacementGroupRequest {
  DryRun?: boolean;
  GroupName?: string;
  Strategy?: PlacementStrategy;
  PartitionCount?: number;
  TagSpecifications?: TagSpecification[];
  SpreadLevel?: SpreadLevel;
}
export declare const PlacementGroupState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type PlacementGroupState =
  (typeof PlacementGroupState)[keyof typeof PlacementGroupState];
export interface PlacementGroup {
  GroupName?: string;
  State?: PlacementGroupState;
  Strategy?: PlacementStrategy;
  PartitionCount?: number;
  GroupId?: string;
  Tags?: Tag[];
  GroupArn?: string;
  SpreadLevel?: SpreadLevel;
}
export interface CreatePlacementGroupResult {
  PlacementGroup?: PlacementGroup;
}
export interface CreatePublicIpv4PoolRequest {
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
}
export interface CreatePublicIpv4PoolResult {
  PoolId?: string;
}
export interface CreateReplaceRootVolumeTaskRequest {
  InstanceId: string | undefined;
  SnapshotId?: string;
  ClientToken?: string;
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
  ImageId?: string;
  DeleteReplacedRootVolume?: boolean;
}
export declare const ReplaceRootVolumeTaskState: {
  readonly failed: "failed";
  readonly failed_detached: "failed-detached";
  readonly failing: "failing";
  readonly in_progress: "in-progress";
  readonly pending: "pending";
  readonly succeeded: "succeeded";
};
export type ReplaceRootVolumeTaskState =
  (typeof ReplaceRootVolumeTaskState)[keyof typeof ReplaceRootVolumeTaskState];
export interface ReplaceRootVolumeTask {
  ReplaceRootVolumeTaskId?: string;
  InstanceId?: string;
  TaskState?: ReplaceRootVolumeTaskState;
  StartTime?: string;
  CompleteTime?: string;
  Tags?: Tag[];
  ImageId?: string;
  SnapshotId?: string;
  DeleteReplacedRootVolume?: boolean;
}
export interface CreateReplaceRootVolumeTaskResult {
  ReplaceRootVolumeTask?: ReplaceRootVolumeTask;
}
export interface PriceScheduleSpecification {
  CurrencyCode?: CurrencyCodeValues;
  Price?: number;
  Term?: number;
}
export interface CreateReservedInstancesListingRequest {
  ClientToken: string | undefined;
  InstanceCount: number | undefined;
  PriceSchedules: PriceScheduleSpecification[] | undefined;
  ReservedInstancesId: string | undefined;
}
export interface CreateReservedInstancesListingResult {
  ReservedInstancesListings?: ReservedInstancesListing[];
}
export interface CreateRestoreImageTaskRequest {
  Bucket: string | undefined;
  ObjectKey: string | undefined;
  Name?: string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface CreateRestoreImageTaskResult {
  ImageId?: string;
}
export interface CreateRouteRequest {
  DestinationCidrBlock?: string;
  DestinationIpv6CidrBlock?: string;
  DestinationPrefixListId?: string;
  DryRun?: boolean;
  VpcEndpointId?: string;
  EgressOnlyInternetGatewayId?: string;
  GatewayId?: string;
  InstanceId?: string;
  NatGatewayId?: string;
  TransitGatewayId?: string;
  LocalGatewayId?: string;
  CarrierGatewayId?: string;
  NetworkInterfaceId?: string;
  RouteTableId: string | undefined;
  VpcPeeringConnectionId?: string;
  CoreNetworkArn?: string;
}
export interface CreateRouteResult {
  Return?: boolean;
}
export interface CreateRouteTableRequest {
  DryRun?: boolean;
  VpcId: string | undefined;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
}
export interface RouteTableAssociation {
  Main?: boolean;
  RouteTableAssociationId?: string;
  RouteTableId?: string;
  SubnetId?: string;
  GatewayId?: string;
  AssociationState?: RouteTableAssociationState;
}
export interface PropagatingVgw {
  GatewayId?: string;
}
export declare const RouteOrigin: {
  readonly CreateRoute: "CreateRoute";
  readonly CreateRouteTable: "CreateRouteTable";
  readonly EnableVgwRoutePropagation: "EnableVgwRoutePropagation";
};
export type RouteOrigin = (typeof RouteOrigin)[keyof typeof RouteOrigin];
export declare const RouteState: {
  readonly active: "active";
  readonly blackhole: "blackhole";
};
export type RouteState = (typeof RouteState)[keyof typeof RouteState];
export interface Route {
  DestinationCidrBlock?: string;
  DestinationIpv6CidrBlock?: string;
  DestinationPrefixListId?: string;
  EgressOnlyInternetGatewayId?: string;
  GatewayId?: string;
  InstanceId?: string;
  InstanceOwnerId?: string;
  NatGatewayId?: string;
  TransitGatewayId?: string;
  LocalGatewayId?: string;
  CarrierGatewayId?: string;
  NetworkInterfaceId?: string;
  Origin?: RouteOrigin;
  State?: RouteState;
  VpcPeeringConnectionId?: string;
  CoreNetworkArn?: string;
}
export interface RouteTable {
  Associations?: RouteTableAssociation[];
  PropagatingVgws?: PropagatingVgw[];
  RouteTableId?: string;
  Routes?: Route[];
  Tags?: Tag[];
  VpcId?: string;
  OwnerId?: string;
}
export interface CreateRouteTableResult {
  RouteTable?: RouteTable;
  ClientToken?: string;
}
export interface CreateSecurityGroupRequest {
  Description: string | undefined;
  GroupName: string | undefined;
  VpcId?: string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface CreateSecurityGroupResult {
  GroupId?: string;
  Tags?: Tag[];
}
export interface CreateSnapshotRequest {
  Description?: string;
  OutpostArn?: string;
  VolumeId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export declare const SSEType: {
  readonly none: "none";
  readonly sse_ebs: "sse-ebs";
  readonly sse_kms: "sse-kms";
};
export type SSEType = (typeof SSEType)[keyof typeof SSEType];
export declare const SnapshotState: {
  readonly completed: "completed";
  readonly error: "error";
  readonly pending: "pending";
  readonly recoverable: "recoverable";
  readonly recovering: "recovering";
};
export type SnapshotState = (typeof SnapshotState)[keyof typeof SnapshotState];
export declare const StorageTier: {
  readonly archive: "archive";
  readonly standard: "standard";
};
export type StorageTier = (typeof StorageTier)[keyof typeof StorageTier];
export interface Snapshot {
  DataEncryptionKeyId?: string;
  Description?: string;
  Encrypted?: boolean;
  KmsKeyId?: string;
  OwnerId?: string;
  Progress?: string;
  SnapshotId?: string;
  StartTime?: Date;
  State?: SnapshotState;
  StateMessage?: string;
  VolumeId?: string;
  VolumeSize?: number;
  OwnerAlias?: string;
  OutpostArn?: string;
  Tags?: Tag[];
  StorageTier?: StorageTier;
  RestoreExpiryTime?: Date;
  SseType?: SSEType;
}
export declare const CopyTagsFromSource: {
  readonly volume: "volume";
};
export type CopyTagsFromSource =
  (typeof CopyTagsFromSource)[keyof typeof CopyTagsFromSource];
export interface InstanceSpecification {
  InstanceId: string | undefined;
  ExcludeBootVolume?: boolean;
  ExcludeDataVolumeIds?: string[];
}
export interface CreateSnapshotsRequest {
  Description?: string;
  InstanceSpecification: InstanceSpecification | undefined;
  OutpostArn?: string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
  CopyTagsFromSource?: CopyTagsFromSource;
}
export interface SnapshotInfo {
  Description?: string;
  Tags?: Tag[];
  Encrypted?: boolean;
  VolumeId?: string;
  State?: SnapshotState;
  VolumeSize?: number;
  StartTime?: Date;
  Progress?: string;
  OwnerId?: string;
  SnapshotId?: string;
  OutpostArn?: string;
  SseType?: SSEType;
}
export interface CreateSnapshotsResult {
  Snapshots?: SnapshotInfo[];
}
export interface CreateSpotDatafeedSubscriptionRequest {
  Bucket: string | undefined;
  DryRun?: boolean;
  Prefix?: string;
}
export interface SpotInstanceStateFault {
  Code?: string;
  Message?: string;
}
export declare const DatafeedSubscriptionState: {
  readonly Active: "Active";
  readonly Inactive: "Inactive";
};
export type DatafeedSubscriptionState =
  (typeof DatafeedSubscriptionState)[keyof typeof DatafeedSubscriptionState];
export interface SpotDatafeedSubscription {
  Bucket?: string;
  Fault?: SpotInstanceStateFault;
  OwnerId?: string;
  Prefix?: string;
  State?: DatafeedSubscriptionState;
}
export interface CreateSpotDatafeedSubscriptionResult {
  SpotDatafeedSubscription?: SpotDatafeedSubscription;
}
export interface S3ObjectTag {
  Key?: string;
  Value?: string;
}
export interface CreateStoreImageTaskRequest {
  ImageId: string | undefined;
  Bucket: string | undefined;
  S3ObjectTags?: S3ObjectTag[];
  DryRun?: boolean;
}
export interface CreateStoreImageTaskResult {
  ObjectKey?: string;
}
export interface CreateSubnetRequest {
  TagSpecifications?: TagSpecification[];
  AvailabilityZone?: string;
  AvailabilityZoneId?: string;
  CidrBlock?: string;
  Ipv6CidrBlock?: string;
  OutpostArn?: string;
  VpcId: string | undefined;
  DryRun?: boolean;
  Ipv6Native?: boolean;
  Ipv4IpamPoolId?: string;
  Ipv4NetmaskLength?: number;
  Ipv6IpamPoolId?: string;
  Ipv6NetmaskLength?: number;
}
export interface CreateSubnetResult {
  Subnet?: Subnet;
}
export declare const SubnetCidrReservationType: {
  readonly explicit: "explicit";
  readonly prefix: "prefix";
};
export type SubnetCidrReservationType =
  (typeof SubnetCidrReservationType)[keyof typeof SubnetCidrReservationType];
export interface CreateSubnetCidrReservationRequest {
  SubnetId: string | undefined;
  Cidr: string | undefined;
  ReservationType: SubnetCidrReservationType | undefined;
  Description?: string;
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
}
export interface SubnetCidrReservation {
  SubnetCidrReservationId?: string;
  SubnetId?: string;
  Cidr?: string;
  ReservationType?: SubnetCidrReservationType;
  OwnerId?: string;
  Description?: string;
  Tags?: Tag[];
}
export interface CreateSubnetCidrReservationResult {
  SubnetCidrReservation?: SubnetCidrReservation;
}
export interface CreateTagsRequest {
  DryRun?: boolean;
  Resources: string[] | undefined;
  Tags: Tag[] | undefined;
}
export interface CreateTrafficMirrorFilterRequest {
  Description?: string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
  ClientToken?: string;
}
export interface TrafficMirrorPortRange {
  FromPort?: number;
  ToPort?: number;
}
export declare const TrafficMirrorRuleAction: {
  readonly accept: "accept";
  readonly reject: "reject";
};
export type TrafficMirrorRuleAction =
  (typeof TrafficMirrorRuleAction)[keyof typeof TrafficMirrorRuleAction];
export declare const TrafficDirection: {
  readonly egress: "egress";
  readonly ingress: "ingress";
};
export type TrafficDirection =
  (typeof TrafficDirection)[keyof typeof TrafficDirection];
export interface TrafficMirrorFilterRule {
  TrafficMirrorFilterRuleId?: string;
  TrafficMirrorFilterId?: string;
  TrafficDirection?: TrafficDirection;
  RuleNumber?: number;
  RuleAction?: TrafficMirrorRuleAction;
  Protocol?: number;
  DestinationPortRange?: TrafficMirrorPortRange;
  SourcePortRange?: TrafficMirrorPortRange;
  DestinationCidrBlock?: string;
  SourceCidrBlock?: string;
  Description?: string;
}
export declare const TrafficMirrorNetworkService: {
  readonly amazon_dns: "amazon-dns";
};
export type TrafficMirrorNetworkService =
  (typeof TrafficMirrorNetworkService)[keyof typeof TrafficMirrorNetworkService];
export interface TrafficMirrorFilter {
  TrafficMirrorFilterId?: string;
  IngressFilterRules?: TrafficMirrorFilterRule[];
  EgressFilterRules?: TrafficMirrorFilterRule[];
  NetworkServices?: TrafficMirrorNetworkService[];
  Description?: string;
  Tags?: Tag[];
}
export interface CreateTrafficMirrorFilterResult {
  TrafficMirrorFilter?: TrafficMirrorFilter;
  ClientToken?: string;
}
export interface TrafficMirrorPortRangeRequest {
  FromPort?: number;
  ToPort?: number;
}
export interface CreateTrafficMirrorFilterRuleRequest {
  TrafficMirrorFilterId: string | undefined;
  TrafficDirection: TrafficDirection | undefined;
  RuleNumber: number | undefined;
  RuleAction: TrafficMirrorRuleAction | undefined;
  DestinationPortRange?: TrafficMirrorPortRangeRequest;
  SourcePortRange?: TrafficMirrorPortRangeRequest;
  Protocol?: number;
  DestinationCidrBlock: string | undefined;
  SourceCidrBlock: string | undefined;
  Description?: string;
  DryRun?: boolean;
  ClientToken?: string;
}
export interface CreateTrafficMirrorFilterRuleResult {
  TrafficMirrorFilterRule?: TrafficMirrorFilterRule;
  ClientToken?: string;
}
export interface CreateTrafficMirrorSessionRequest {
  NetworkInterfaceId: string | undefined;
  TrafficMirrorTargetId: string | undefined;
  TrafficMirrorFilterId: string | undefined;
  PacketLength?: number;
  SessionNumber: number | undefined;
  VirtualNetworkId?: number;
  Description?: string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
  ClientToken?: string;
}
export interface TrafficMirrorSession {
  TrafficMirrorSessionId?: string;
  TrafficMirrorTargetId?: string;
  TrafficMirrorFilterId?: string;
  NetworkInterfaceId?: string;
  OwnerId?: string;
  PacketLength?: number;
  SessionNumber?: number;
  VirtualNetworkId?: number;
  Description?: string;
  Tags?: Tag[];
}
export interface CreateTrafficMirrorSessionResult {
  TrafficMirrorSession?: TrafficMirrorSession;
  ClientToken?: string;
}
export interface CreateTrafficMirrorTargetRequest {
  NetworkInterfaceId?: string;
  NetworkLoadBalancerArn?: string;
  Description?: string;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
  ClientToken?: string;
  GatewayLoadBalancerEndpointId?: string;
}
export declare const TrafficMirrorTargetType: {
  readonly gateway_load_balancer_endpoint: "gateway-load-balancer-endpoint";
  readonly network_interface: "network-interface";
  readonly network_load_balancer: "network-load-balancer";
};
export type TrafficMirrorTargetType =
  (typeof TrafficMirrorTargetType)[keyof typeof TrafficMirrorTargetType];
export interface TrafficMirrorTarget {
  TrafficMirrorTargetId?: string;
  NetworkInterfaceId?: string;
  NetworkLoadBalancerArn?: string;
  Type?: TrafficMirrorTargetType;
  Description?: string;
  OwnerId?: string;
  Tags?: Tag[];
  GatewayLoadBalancerEndpointId?: string;
}
export interface CreateTrafficMirrorTargetResult {
  TrafficMirrorTarget?: TrafficMirrorTarget;
  ClientToken?: string;
}
export declare const AutoAcceptSharedAttachmentsValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type AutoAcceptSharedAttachmentsValue =
  (typeof AutoAcceptSharedAttachmentsValue)[keyof typeof AutoAcceptSharedAttachmentsValue];
export declare const DefaultRouteTableAssociationValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type DefaultRouteTableAssociationValue =
  (typeof DefaultRouteTableAssociationValue)[keyof typeof DefaultRouteTableAssociationValue];
export declare const DefaultRouteTablePropagationValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type DefaultRouteTablePropagationValue =
  (typeof DefaultRouteTablePropagationValue)[keyof typeof DefaultRouteTablePropagationValue];
export declare const MulticastSupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type MulticastSupportValue =
  (typeof MulticastSupportValue)[keyof typeof MulticastSupportValue];
export declare const VpnEcmpSupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type VpnEcmpSupportValue =
  (typeof VpnEcmpSupportValue)[keyof typeof VpnEcmpSupportValue];
export interface TransitGatewayRequestOptions {
  AmazonSideAsn?: number;
  AutoAcceptSharedAttachments?: AutoAcceptSharedAttachmentsValue;
  DefaultRouteTableAssociation?: DefaultRouteTableAssociationValue;
  DefaultRouteTablePropagation?: DefaultRouteTablePropagationValue;
  VpnEcmpSupport?: VpnEcmpSupportValue;
  DnsSupport?: DnsSupportValue;
  SecurityGroupReferencingSupport?: SecurityGroupReferencingSupportValue;
  MulticastSupport?: MulticastSupportValue;
  TransitGatewayCidrBlocks?: string[];
}
export interface CreateTransitGatewayRequest {
  Description?: string;
  Options?: TransitGatewayRequestOptions;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface TransitGatewayOptions {
  AmazonSideAsn?: number;
  TransitGatewayCidrBlocks?: string[];
  AutoAcceptSharedAttachments?: AutoAcceptSharedAttachmentsValue;
  DefaultRouteTableAssociation?: DefaultRouteTableAssociationValue;
  AssociationDefaultRouteTableId?: string;
  DefaultRouteTablePropagation?: DefaultRouteTablePropagationValue;
  PropagationDefaultRouteTableId?: string;
  VpnEcmpSupport?: VpnEcmpSupportValue;
  DnsSupport?: DnsSupportValue;
  SecurityGroupReferencingSupport?: SecurityGroupReferencingSupportValue;
  MulticastSupport?: MulticastSupportValue;
}
export declare const TransitGatewayState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly modifying: "modifying";
  readonly pending: "pending";
};
export type TransitGatewayState =
  (typeof TransitGatewayState)[keyof typeof TransitGatewayState];
export interface TransitGateway {
  TransitGatewayId?: string;
  TransitGatewayArn?: string;
  State?: TransitGatewayState;
  OwnerId?: string;
  Description?: string;
  CreationTime?: Date;
  Options?: TransitGatewayOptions;
  Tags?: Tag[];
}
export interface CreateTransitGatewayResult {
  TransitGateway?: TransitGateway;
}
export declare const ProtocolValue: {
  readonly gre: "gre";
};
export type ProtocolValue = (typeof ProtocolValue)[keyof typeof ProtocolValue];
export interface CreateTransitGatewayConnectRequestOptions {
  Protocol: ProtocolValue | undefined;
}
export interface CreateTransitGatewayConnectRequest {
  TransportTransitGatewayAttachmentId: string | undefined;
  Options: CreateTransitGatewayConnectRequestOptions | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface TransitGatewayConnectOptions {
  Protocol?: ProtocolValue;
}
export interface TransitGatewayConnect {
  TransitGatewayAttachmentId?: string;
  TransportTransitGatewayAttachmentId?: string;
  TransitGatewayId?: string;
  State?: TransitGatewayAttachmentState;
  CreationTime?: Date;
  Options?: TransitGatewayConnectOptions;
  Tags?: Tag[];
}
export interface CreateTransitGatewayConnectResult {
  TransitGatewayConnect?: TransitGatewayConnect;
}
export interface TransitGatewayConnectRequestBgpOptions {
  PeerAsn?: number;
}
export interface CreateTransitGatewayConnectPeerRequest {
  TransitGatewayAttachmentId: string | undefined;
  TransitGatewayAddress?: string;
  PeerAddress: string | undefined;
  BgpOptions?: TransitGatewayConnectRequestBgpOptions;
  InsideCidrBlocks: string[] | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export declare const BgpStatus: {
  readonly down: "down";
  readonly up: "up";
};
export type BgpStatus = (typeof BgpStatus)[keyof typeof BgpStatus];
export interface TransitGatewayAttachmentBgpConfiguration {
  TransitGatewayAsn?: number;
  PeerAsn?: number;
  TransitGatewayAddress?: string;
  PeerAddress?: string;
  BgpStatus?: BgpStatus;
}
export interface TransitGatewayConnectPeerConfiguration {
  TransitGatewayAddress?: string;
  PeerAddress?: string;
  InsideCidrBlocks?: string[];
  Protocol?: ProtocolValue;
  BgpConfigurations?: TransitGatewayAttachmentBgpConfiguration[];
}
export declare const TransitGatewayConnectPeerState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type TransitGatewayConnectPeerState =
  (typeof TransitGatewayConnectPeerState)[keyof typeof TransitGatewayConnectPeerState];
export interface TransitGatewayConnectPeer {
  TransitGatewayAttachmentId?: string;
  TransitGatewayConnectPeerId?: string;
  State?: TransitGatewayConnectPeerState;
  CreationTime?: Date;
  ConnectPeerConfiguration?: TransitGatewayConnectPeerConfiguration;
  Tags?: Tag[];
}
export interface CreateTransitGatewayConnectPeerResult {
  TransitGatewayConnectPeer?: TransitGatewayConnectPeer;
}
export declare const AutoAcceptSharedAssociationsValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type AutoAcceptSharedAssociationsValue =
  (typeof AutoAcceptSharedAssociationsValue)[keyof typeof AutoAcceptSharedAssociationsValue];
export declare const Igmpv2SupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type Igmpv2SupportValue =
  (typeof Igmpv2SupportValue)[keyof typeof Igmpv2SupportValue];
export declare const StaticSourcesSupportValue: {
  readonly disable: "disable";
  readonly enable: "enable";
};
export type StaticSourcesSupportValue =
  (typeof StaticSourcesSupportValue)[keyof typeof StaticSourcesSupportValue];
export interface CreateTransitGatewayMulticastDomainRequestOptions {
  Igmpv2Support?: Igmpv2SupportValue;
  StaticSourcesSupport?: StaticSourcesSupportValue;
  AutoAcceptSharedAssociations?: AutoAcceptSharedAssociationsValue;
}
export interface CreateTransitGatewayMulticastDomainRequest {
  TransitGatewayId: string | undefined;
  Options?: CreateTransitGatewayMulticastDomainRequestOptions;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface TransitGatewayMulticastDomainOptions {
  Igmpv2Support?: Igmpv2SupportValue;
  StaticSourcesSupport?: StaticSourcesSupportValue;
  AutoAcceptSharedAssociations?: AutoAcceptSharedAssociationsValue;
}
export declare const TransitGatewayMulticastDomainState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type TransitGatewayMulticastDomainState =
  (typeof TransitGatewayMulticastDomainState)[keyof typeof TransitGatewayMulticastDomainState];
export interface TransitGatewayMulticastDomain {
  TransitGatewayMulticastDomainId?: string;
  TransitGatewayId?: string;
  TransitGatewayMulticastDomainArn?: string;
  OwnerId?: string;
  Options?: TransitGatewayMulticastDomainOptions;
  State?: TransitGatewayMulticastDomainState;
  CreationTime?: Date;
  Tags?: Tag[];
}
export interface CreateTransitGatewayMulticastDomainResult {
  TransitGatewayMulticastDomain?: TransitGatewayMulticastDomain;
}
export interface CreateTransitGatewayPeeringAttachmentRequestOptions {
  DynamicRouting?: DynamicRoutingValue;
}
export interface CreateTransitGatewayPeeringAttachmentRequest {
  TransitGatewayId: string | undefined;
  PeerTransitGatewayId: string | undefined;
  PeerAccountId: string | undefined;
  PeerRegion: string | undefined;
  Options?: CreateTransitGatewayPeeringAttachmentRequestOptions;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface CreateTransitGatewayPeeringAttachmentResult {
  TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
export interface CreateTransitGatewayPolicyTableRequest {
  TransitGatewayId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export declare const TransitGatewayPolicyTableState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type TransitGatewayPolicyTableState =
  (typeof TransitGatewayPolicyTableState)[keyof typeof TransitGatewayPolicyTableState];
export interface TransitGatewayPolicyTable {
  TransitGatewayPolicyTableId?: string;
  TransitGatewayId?: string;
  State?: TransitGatewayPolicyTableState;
  CreationTime?: Date;
  Tags?: Tag[];
}
export interface CreateTransitGatewayPolicyTableResult {
  TransitGatewayPolicyTable?: TransitGatewayPolicyTable;
}
export interface CreateTransitGatewayPrefixListReferenceRequest {
  TransitGatewayRouteTableId: string | undefined;
  PrefixListId: string | undefined;
  TransitGatewayAttachmentId?: string;
  Blackhole?: boolean;
  DryRun?: boolean;
}
export declare const TransitGatewayPrefixListReferenceState: {
  readonly available: "available";
  readonly deleting: "deleting";
  readonly modifying: "modifying";
  readonly pending: "pending";
};
export type TransitGatewayPrefixListReferenceState =
  (typeof TransitGatewayPrefixListReferenceState)[keyof typeof TransitGatewayPrefixListReferenceState];
export interface TransitGatewayPrefixListAttachment {
  TransitGatewayAttachmentId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType;
  ResourceId?: string;
}
export interface TransitGatewayPrefixListReference {
  TransitGatewayRouteTableId?: string;
  PrefixListId?: string;
  PrefixListOwnerId?: string;
  State?: TransitGatewayPrefixListReferenceState;
  Blackhole?: boolean;
  TransitGatewayAttachment?: TransitGatewayPrefixListAttachment;
}
export interface CreateTransitGatewayPrefixListReferenceResult {
  TransitGatewayPrefixListReference?: TransitGatewayPrefixListReference;
}
export interface CreateTransitGatewayRouteRequest {
  DestinationCidrBlock: string | undefined;
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId?: string;
  Blackhole?: boolean;
  DryRun?: boolean;
}
export declare const TransitGatewayRouteState: {
  readonly active: "active";
  readonly blackhole: "blackhole";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type TransitGatewayRouteState =
  (typeof TransitGatewayRouteState)[keyof typeof TransitGatewayRouteState];
export interface TransitGatewayRouteAttachment {
  ResourceId?: string;
  TransitGatewayAttachmentId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType;
}
export declare const TransitGatewayRouteType: {
  readonly propagated: "propagated";
  readonly static: "static";
};
export type TransitGatewayRouteType =
  (typeof TransitGatewayRouteType)[keyof typeof TransitGatewayRouteType];
export interface TransitGatewayRoute {
  DestinationCidrBlock?: string;
  PrefixListId?: string;
  TransitGatewayRouteTableAnnouncementId?: string;
  TransitGatewayAttachments?: TransitGatewayRouteAttachment[];
  Type?: TransitGatewayRouteType;
  State?: TransitGatewayRouteState;
}
export interface CreateTransitGatewayRouteResult {
  Route?: TransitGatewayRoute;
}
export interface CreateTransitGatewayRouteTableRequest {
  TransitGatewayId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export declare const TransitGatewayRouteTableState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type TransitGatewayRouteTableState =
  (typeof TransitGatewayRouteTableState)[keyof typeof TransitGatewayRouteTableState];
export interface TransitGatewayRouteTable {
  TransitGatewayRouteTableId?: string;
  TransitGatewayId?: string;
  State?: TransitGatewayRouteTableState;
  DefaultAssociationRouteTable?: boolean;
  DefaultPropagationRouteTable?: boolean;
  CreationTime?: Date;
  Tags?: Tag[];
}
export interface CreateTransitGatewayRouteTableResult {
  TransitGatewayRouteTable?: TransitGatewayRouteTable;
}
export interface CreateTransitGatewayRouteTableAnnouncementRequest {
  TransitGatewayRouteTableId: string | undefined;
  PeeringAttachmentId: string | undefined;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export declare const TransitGatewayRouteTableAnnouncementDirection: {
  readonly incoming: "incoming";
  readonly outgoing: "outgoing";
};
export type TransitGatewayRouteTableAnnouncementDirection =
  (typeof TransitGatewayRouteTableAnnouncementDirection)[keyof typeof TransitGatewayRouteTableAnnouncementDirection];
export declare const TransitGatewayRouteTableAnnouncementState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly failed: "failed";
  readonly failing: "failing";
  readonly pending: "pending";
};
export type TransitGatewayRouteTableAnnouncementState =
  (typeof TransitGatewayRouteTableAnnouncementState)[keyof typeof TransitGatewayRouteTableAnnouncementState];
export interface TransitGatewayRouteTableAnnouncement {
  TransitGatewayRouteTableAnnouncementId?: string;
  TransitGatewayId?: string;
  CoreNetworkId?: string;
  PeerTransitGatewayId?: string;
  PeerCoreNetworkId?: string;
  PeeringAttachmentId?: string;
  AnnouncementDirection?: TransitGatewayRouteTableAnnouncementDirection;
  TransitGatewayRouteTableId?: string;
  State?: TransitGatewayRouteTableAnnouncementState;
  CreationTime?: Date;
  Tags?: Tag[];
}
export interface CreateTransitGatewayRouteTableAnnouncementResult {
  TransitGatewayRouteTableAnnouncement?: TransitGatewayRouteTableAnnouncement;
}
export interface CreateTransitGatewayVpcAttachmentRequestOptions {
  DnsSupport?: DnsSupportValue;
  SecurityGroupReferencingSupport?: SecurityGroupReferencingSupportValue;
  Ipv6Support?: Ipv6SupportValue;
  ApplianceModeSupport?: ApplianceModeSupportValue;
}
export interface CreateTransitGatewayVpcAttachmentRequest {
  TransitGatewayId: string | undefined;
  VpcId: string | undefined;
  SubnetIds: string[] | undefined;
  Options?: CreateTransitGatewayVpcAttachmentRequestOptions;
  TagSpecifications?: TagSpecification[];
  DryRun?: boolean;
}
export interface CreateTransitGatewayVpcAttachmentResult {
  TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export declare const VerifiedAccessEndpointAttachmentType: {
  readonly vpc: "vpc";
};
export type VerifiedAccessEndpointAttachmentType =
  (typeof VerifiedAccessEndpointAttachmentType)[keyof typeof VerifiedAccessEndpointAttachmentType];
export declare const VerifiedAccessEndpointType: {
  readonly load_balancer: "load-balancer";
  readonly network_interface: "network-interface";
};
export type VerifiedAccessEndpointType =
  (typeof VerifiedAccessEndpointType)[keyof typeof VerifiedAccessEndpointType];
export declare const VerifiedAccessEndpointProtocol: {
  readonly http: "http";
  readonly https: "https";
};
export type VerifiedAccessEndpointProtocol =
  (typeof VerifiedAccessEndpointProtocol)[keyof typeof VerifiedAccessEndpointProtocol];
export interface CreateVerifiedAccessEndpointLoadBalancerOptions {
  Protocol?: VerifiedAccessEndpointProtocol;
  Port?: number;
  LoadBalancerArn?: string;
  SubnetIds?: string[];
}
export interface CreateVerifiedAccessEndpointEniOptions {
  NetworkInterfaceId?: string;
  Protocol?: VerifiedAccessEndpointProtocol;
  Port?: number;
}
export interface VerifiedAccessSseSpecificationRequest {
  CustomerManagedKeyEnabled?: boolean;
  KmsKeyArn?: string;
}
export interface CreateVerifiedAccessEndpointRequest {
  VerifiedAccessGroupId: string | undefined;
  EndpointType: VerifiedAccessEndpointType | undefined;
  AttachmentType: VerifiedAccessEndpointAttachmentType | undefined;
  DomainCertificateArn: string | undefined;
  ApplicationDomain: string | undefined;
  EndpointDomainPrefix: string | undefined;
  SecurityGroupIds?: string[];
  LoadBalancerOptions?: CreateVerifiedAccessEndpointLoadBalancerOptions;
  NetworkInterfaceOptions?: CreateVerifiedAccessEndpointEniOptions;
  Description?: string;
  PolicyDocument?: string;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
  DryRun?: boolean;
  SseSpecification?: VerifiedAccessSseSpecificationRequest;
}
export interface VerifiedAccessEndpointLoadBalancerOptions {
  Protocol?: VerifiedAccessEndpointProtocol;
  Port?: number;
  LoadBalancerArn?: string;
  SubnetIds?: string[];
}
export interface VerifiedAccessEndpointEniOptions {
  NetworkInterfaceId?: string;
  Protocol?: VerifiedAccessEndpointProtocol;
  Port?: number;
}
export declare const VerifiedAccessEndpointStatusCode: {
  readonly active: "active";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
  readonly updating: "updating";
};
export type VerifiedAccessEndpointStatusCode =
  (typeof VerifiedAccessEndpointStatusCode)[keyof typeof VerifiedAccessEndpointStatusCode];
export interface VerifiedAccessEndpointStatus {
  Code?: VerifiedAccessEndpointStatusCode;
  Message?: string;
}
export interface VerifiedAccessEndpoint {
  VerifiedAccessInstanceId?: string;
  VerifiedAccessGroupId?: string;
  VerifiedAccessEndpointId?: string;
  ApplicationDomain?: string;
  EndpointType?: VerifiedAccessEndpointType;
  AttachmentType?: VerifiedAccessEndpointAttachmentType;
  DomainCertificateArn?: string;
  EndpointDomain?: string;
  DeviceValidationDomain?: string;
  SecurityGroupIds?: string[];
  LoadBalancerOptions?: VerifiedAccessEndpointLoadBalancerOptions;
  NetworkInterfaceOptions?: VerifiedAccessEndpointEniOptions;
  Status?: VerifiedAccessEndpointStatus;
  Description?: string;
  CreationTime?: string;
  LastUpdatedTime?: string;
  DeletionTime?: string;
  Tags?: Tag[];
  SseSpecification?: VerifiedAccessSseSpecificationResponse;
}
export interface CreateVerifiedAccessEndpointResult {
  VerifiedAccessEndpoint?: VerifiedAccessEndpoint;
}
export interface CreateVerifiedAccessGroupRequest {
  VerifiedAccessInstanceId: string | undefined;
  Description?: string;
  PolicyDocument?: string;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
  DryRun?: boolean;
  SseSpecification?: VerifiedAccessSseSpecificationRequest;
}
export interface VerifiedAccessGroup {
  VerifiedAccessGroupId?: string;
  VerifiedAccessInstanceId?: string;
  Description?: string;
  Owner?: string;
  VerifiedAccessGroupArn?: string;
  CreationTime?: string;
  LastUpdatedTime?: string;
  DeletionTime?: string;
  Tags?: Tag[];
  SseSpecification?: VerifiedAccessSseSpecificationResponse;
}
export interface CreateVerifiedAccessGroupResult {
  VerifiedAccessGroup?: VerifiedAccessGroup;
}
export interface CreateVerifiedAccessInstanceRequest {
  Description?: string;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
  DryRun?: boolean;
  FIPSEnabled?: boolean;
}
export interface CreateVerifiedAccessInstanceResult {
  VerifiedAccessInstance?: VerifiedAccessInstance;
}
export interface CreateVerifiedAccessTrustProviderDeviceOptions {
  TenantId?: string;
  PublicSigningKeyUrl?: string;
}
export interface CreateVerifiedAccessTrustProviderOidcOptions {
  Issuer?: string;
  AuthorizationEndpoint?: string;
  TokenEndpoint?: string;
  UserInfoEndpoint?: string;
  ClientId?: string;
  ClientSecret?: string;
  Scope?: string;
}
export interface CreateVerifiedAccessTrustProviderRequest {
  TrustProviderType: TrustProviderType | undefined;
  UserTrustProviderType?: UserTrustProviderType;
  DeviceTrustProviderType?: DeviceTrustProviderType;
  OidcOptions?: CreateVerifiedAccessTrustProviderOidcOptions;
  DeviceOptions?: CreateVerifiedAccessTrustProviderDeviceOptions;
  PolicyReferenceName: string | undefined;
  Description?: string;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
  DryRun?: boolean;
  SseSpecification?: VerifiedAccessSseSpecificationRequest;
}
export interface CreateVerifiedAccessTrustProviderResult {
  VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider;
}
export interface CreateVolumeRequest {
  AvailabilityZone: string | undefined;
  Encrypted?: boolean;
  Iops?: number;
  KmsKeyId?: string;
  OutpostArn?: string;
  Size?: number;
  SnapshotId?: string;
  VolumeType?: VolumeType;
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
  MultiAttachEnabled?: boolean;
  Throughput?: number;
  ClientToken?: string;
}
export declare const VolumeState: {
  readonly available: "available";
  readonly creating: "creating";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly error: "error";
  readonly in_use: "in-use";
};
export type VolumeState = (typeof VolumeState)[keyof typeof VolumeState];
export interface Volume {
  Attachments?: VolumeAttachment[];
  AvailabilityZone?: string;
  CreateTime?: Date;
  Encrypted?: boolean;
  KmsKeyId?: string;
  OutpostArn?: string;
  Size?: number;
  SnapshotId?: string;
  State?: VolumeState;
  VolumeId?: string;
  Iops?: number;
  Tags?: Tag[];
  VolumeType?: VolumeType;
  FastRestored?: boolean;
  MultiAttachEnabled?: boolean;
  Throughput?: number;
  SseType?: SSEType;
}
export interface CreateVpcRequest {
  CidrBlock?: string;
  AmazonProvidedIpv6CidrBlock?: boolean;
  Ipv6Pool?: string;
  Ipv6CidrBlock?: string;
  Ipv4IpamPoolId?: string;
  Ipv4NetmaskLength?: number;
  Ipv6IpamPoolId?: string;
  Ipv6NetmaskLength?: number;
  DryRun?: boolean;
  InstanceTenancy?: Tenancy;
  Ipv6CidrBlockNetworkBorderGroup?: string;
  TagSpecifications?: TagSpecification[];
}
export interface CreateVpcResult {
  Vpc?: Vpc;
}
export declare const DnsRecordIpType: {
  readonly dualstack: "dualstack";
  readonly ipv4: "ipv4";
  readonly ipv6: "ipv6";
  readonly service_defined: "service-defined";
};
export type DnsRecordIpType =
  (typeof DnsRecordIpType)[keyof typeof DnsRecordIpType];
export interface DnsOptionsSpecification {
  DnsRecordIpType?: DnsRecordIpType;
  PrivateDnsOnlyForInboundResolverEndpoint?: boolean;
}
export declare const IpAddressType: {
  readonly dualstack: "dualstack";
  readonly ipv4: "ipv4";
  readonly ipv6: "ipv6";
};
export type IpAddressType = (typeof IpAddressType)[keyof typeof IpAddressType];
export interface SubnetConfiguration {
  SubnetId?: string;
  Ipv4?: string;
  Ipv6?: string;
}
export declare const VpcEndpointType: {
  readonly Gateway: "Gateway";
  readonly GatewayLoadBalancer: "GatewayLoadBalancer";
  readonly Interface: "Interface";
};
export type VpcEndpointType =
  (typeof VpcEndpointType)[keyof typeof VpcEndpointType];
export interface CreateVpcEndpointRequest {
  DryRun?: boolean;
  VpcEndpointType?: VpcEndpointType;
  VpcId: string | undefined;
  ServiceName: string | undefined;
  PolicyDocument?: string;
  RouteTableIds?: string[];
  SubnetIds?: string[];
  SecurityGroupIds?: string[];
  IpAddressType?: IpAddressType;
  DnsOptions?: DnsOptionsSpecification;
  ClientToken?: string;
  PrivateDnsEnabled?: boolean;
  TagSpecifications?: TagSpecification[];
  SubnetConfigurations?: SubnetConfiguration[];
}
export interface DnsEntry {
  DnsName?: string;
  HostedZoneId?: string;
}
export interface DnsOptions {
  DnsRecordIpType?: DnsRecordIpType;
  PrivateDnsOnlyForInboundResolverEndpoint?: boolean;
}
export interface SecurityGroupIdentifier {
  GroupId?: string;
  GroupName?: string;
}
export interface LastError {
  Message?: string;
  Code?: string;
}
export declare const State: {
  readonly Available: "Available";
  readonly Deleted: "Deleted";
  readonly Deleting: "Deleting";
  readonly Expired: "Expired";
  readonly Failed: "Failed";
  readonly Pending: "Pending";
  readonly PendingAcceptance: "PendingAcceptance";
  readonly Rejected: "Rejected";
};
export type State = (typeof State)[keyof typeof State];
export interface VpcEndpoint {
  VpcEndpointId?: string;
  VpcEndpointType?: VpcEndpointType;
  VpcId?: string;
  ServiceName?: string;
  State?: State;
  PolicyDocument?: string;
  RouteTableIds?: string[];
  SubnetIds?: string[];
  Groups?: SecurityGroupIdentifier[];
  IpAddressType?: IpAddressType;
  DnsOptions?: DnsOptions;
  PrivateDnsEnabled?: boolean;
  RequesterManaged?: boolean;
  NetworkInterfaceIds?: string[];
  DnsEntries?: DnsEntry[];
  CreationTimestamp?: Date;
  Tags?: Tag[];
  OwnerId?: string;
  LastError?: LastError;
}
export interface CreateVpcEndpointResult {
  VpcEndpoint?: VpcEndpoint;
  ClientToken?: string;
}
export interface CreateVpcEndpointConnectionNotificationRequest {
  DryRun?: boolean;
  ServiceId?: string;
  VpcEndpointId?: string;
  ConnectionNotificationArn: string | undefined;
  ConnectionEvents: string[] | undefined;
  ClientToken?: string;
}
export declare const ConnectionNotificationState: {
  readonly Disabled: "Disabled";
  readonly Enabled: "Enabled";
};
export type ConnectionNotificationState =
  (typeof ConnectionNotificationState)[keyof typeof ConnectionNotificationState];
export declare const ConnectionNotificationType: {
  readonly Topic: "Topic";
};
export type ConnectionNotificationType =
  (typeof ConnectionNotificationType)[keyof typeof ConnectionNotificationType];
export interface ConnectionNotification {
  ConnectionNotificationId?: string;
  ServiceId?: string;
  VpcEndpointId?: string;
  ConnectionNotificationType?: ConnectionNotificationType;
  ConnectionNotificationArn?: string;
  ConnectionEvents?: string[];
  ConnectionNotificationState?: ConnectionNotificationState;
}
export interface CreateVpcEndpointConnectionNotificationResult {
  ConnectionNotification?: ConnectionNotification;
  ClientToken?: string;
}
export interface CreateVpcEndpointServiceConfigurationRequest {
  DryRun?: boolean;
  AcceptanceRequired?: boolean;
  PrivateDnsName?: string;
  NetworkLoadBalancerArns?: string[];
  GatewayLoadBalancerArns?: string[];
  SupportedIpAddressTypes?: string[];
  ClientToken?: string;
  TagSpecifications?: TagSpecification[];
}
export declare const PayerResponsibility: {
  readonly ServiceOwner: "ServiceOwner";
};
export type PayerResponsibility =
  (typeof PayerResponsibility)[keyof typeof PayerResponsibility];
export declare const DnsNameState: {
  readonly Failed: "failed";
  readonly PendingVerification: "pendingVerification";
  readonly Verified: "verified";
};
export type DnsNameState = (typeof DnsNameState)[keyof typeof DnsNameState];
export interface PrivateDnsNameConfiguration {
  State?: DnsNameState;
  Type?: string;
  Value?: string;
  Name?: string;
}
export declare const ServiceState: {
  readonly Available: "Available";
  readonly Deleted: "Deleted";
  readonly Deleting: "Deleting";
  readonly Failed: "Failed";
  readonly Pending: "Pending";
};
export type ServiceState = (typeof ServiceState)[keyof typeof ServiceState];
export declare const ServiceType: {
  readonly Gateway: "Gateway";
  readonly GatewayLoadBalancer: "GatewayLoadBalancer";
  readonly Interface: "Interface";
};
export type ServiceType = (typeof ServiceType)[keyof typeof ServiceType];
export interface ServiceTypeDetail {
  ServiceType?: ServiceType;
}
export declare const ServiceConnectivityType: {
  readonly ipv4: "ipv4";
  readonly ipv6: "ipv6";
};
export type ServiceConnectivityType =
  (typeof ServiceConnectivityType)[keyof typeof ServiceConnectivityType];
export interface ServiceConfiguration {
  ServiceType?: ServiceTypeDetail[];
  ServiceId?: string;
  ServiceName?: string;
  ServiceState?: ServiceState;
  AvailabilityZones?: string[];
  AcceptanceRequired?: boolean;
  ManagesVpcEndpoints?: boolean;
  NetworkLoadBalancerArns?: string[];
  GatewayLoadBalancerArns?: string[];
  SupportedIpAddressTypes?: ServiceConnectivityType[];
  BaseEndpointDnsNames?: string[];
  PrivateDnsName?: string;
  PrivateDnsNameConfiguration?: PrivateDnsNameConfiguration;
  PayerResponsibility?: PayerResponsibility;
  Tags?: Tag[];
}
export interface CreateVpcEndpointServiceConfigurationResult {
  ServiceConfiguration?: ServiceConfiguration;
  ClientToken?: string;
}
export interface CreateVpcPeeringConnectionRequest {
  DryRun?: boolean;
  PeerOwnerId?: string;
  PeerVpcId?: string;
  VpcId: string | undefined;
  PeerRegion?: string;
  TagSpecifications?: TagSpecification[];
}
export interface CreateVpcPeeringConnectionResult {
  VpcPeeringConnection?: VpcPeeringConnection;
}
export declare const TunnelInsideIpVersion: {
  readonly ipv4: "ipv4";
  readonly ipv6: "ipv6";
};
export type TunnelInsideIpVersion =
  (typeof TunnelInsideIpVersion)[keyof typeof TunnelInsideIpVersion];
export interface IKEVersionsRequestListValue {
  Value?: string;
}
export interface CloudWatchLogOptionsSpecification {
  LogEnabled?: boolean;
  LogGroupArn?: string;
  LogOutputFormat?: string;
}
export interface VpnTunnelLogOptionsSpecification {
  CloudWatchLogOptions?: CloudWatchLogOptionsSpecification;
}
export interface Phase1DHGroupNumbersRequestListValue {
  Value?: number;
}
export interface Phase1EncryptionAlgorithmsRequestListValue {
  Value?: string;
}
export interface Phase1IntegrityAlgorithmsRequestListValue {
  Value?: string;
}
export interface Phase2DHGroupNumbersRequestListValue {
  Value?: number;
}
export interface Phase2EncryptionAlgorithmsRequestListValue {
  Value?: string;
}
export interface Phase2IntegrityAlgorithmsRequestListValue {
  Value?: string;
}
export interface VpnTunnelOptionsSpecification {
  TunnelInsideCidr?: string;
  TunnelInsideIpv6Cidr?: string;
  PreSharedKey?: string;
  Phase1LifetimeSeconds?: number;
  Phase2LifetimeSeconds?: number;
  RekeyMarginTimeSeconds?: number;
  RekeyFuzzPercentage?: number;
  ReplayWindowSize?: number;
  DPDTimeoutSeconds?: number;
  DPDTimeoutAction?: string;
  Phase1EncryptionAlgorithms?: Phase1EncryptionAlgorithmsRequestListValue[];
  Phase2EncryptionAlgorithms?: Phase2EncryptionAlgorithmsRequestListValue[];
  Phase1IntegrityAlgorithms?: Phase1IntegrityAlgorithmsRequestListValue[];
  Phase2IntegrityAlgorithms?: Phase2IntegrityAlgorithmsRequestListValue[];
  Phase1DHGroupNumbers?: Phase1DHGroupNumbersRequestListValue[];
  Phase2DHGroupNumbers?: Phase2DHGroupNumbersRequestListValue[];
  IKEVersions?: IKEVersionsRequestListValue[];
  StartupAction?: string;
  LogOptions?: VpnTunnelLogOptionsSpecification;
  EnableTunnelLifecycleControl?: boolean;
}
export interface VpnConnectionOptionsSpecification {
  EnableAcceleration?: boolean;
  StaticRoutesOnly?: boolean;
  TunnelInsideIpVersion?: TunnelInsideIpVersion;
  TunnelOptions?: VpnTunnelOptionsSpecification[];
  LocalIpv4NetworkCidr?: string;
  RemoteIpv4NetworkCidr?: string;
  LocalIpv6NetworkCidr?: string;
  RemoteIpv6NetworkCidr?: string;
  OutsideIpAddressType?: string;
  TransportTransitGatewayAttachmentId?: string;
}
export interface CreateVpnConnectionRequest {
  CustomerGatewayId: string | undefined;
  Type: string | undefined;
  VpnGatewayId?: string;
  TransitGatewayId?: string;
  DryRun?: boolean;
  Options?: VpnConnectionOptionsSpecification;
  TagSpecifications?: TagSpecification[];
}
export declare const GatewayAssociationState: {
  readonly associated: "associated";
  readonly associating: "associating";
  readonly disassociating: "disassociating";
  readonly not_associated: "not-associated";
};
export type GatewayAssociationState =
  (typeof GatewayAssociationState)[keyof typeof GatewayAssociationState];
export interface IKEVersionsListValue {
  Value?: string;
}
export interface CloudWatchLogOptions {
  LogEnabled?: boolean;
  LogGroupArn?: string;
  LogOutputFormat?: string;
}
export interface VpnTunnelLogOptions {
  CloudWatchLogOptions?: CloudWatchLogOptions;
}
export interface Phase1DHGroupNumbersListValue {
  Value?: number;
}
export interface Phase1EncryptionAlgorithmsListValue {
  Value?: string;
}
export interface Phase1IntegrityAlgorithmsListValue {
  Value?: string;
}
export interface Phase2DHGroupNumbersListValue {
  Value?: number;
}
export interface Phase2EncryptionAlgorithmsListValue {
  Value?: string;
}
export interface Phase2IntegrityAlgorithmsListValue {
  Value?: string;
}
export interface TunnelOption {
  OutsideIpAddress?: string;
  TunnelInsideCidr?: string;
  TunnelInsideIpv6Cidr?: string;
  PreSharedKey?: string;
  Phase1LifetimeSeconds?: number;
  Phase2LifetimeSeconds?: number;
  RekeyMarginTimeSeconds?: number;
  RekeyFuzzPercentage?: number;
  ReplayWindowSize?: number;
  DpdTimeoutSeconds?: number;
  DpdTimeoutAction?: string;
  Phase1EncryptionAlgorithms?: Phase1EncryptionAlgorithmsListValue[];
  Phase2EncryptionAlgorithms?: Phase2EncryptionAlgorithmsListValue[];
  Phase1IntegrityAlgorithms?: Phase1IntegrityAlgorithmsListValue[];
  Phase2IntegrityAlgorithms?: Phase2IntegrityAlgorithmsListValue[];
  Phase1DHGroupNumbers?: Phase1DHGroupNumbersListValue[];
  Phase2DHGroupNumbers?: Phase2DHGroupNumbersListValue[];
  IkeVersions?: IKEVersionsListValue[];
  StartupAction?: string;
  LogOptions?: VpnTunnelLogOptions;
  EnableTunnelLifecycleControl?: boolean;
}
export interface VpnConnectionOptions {
  EnableAcceleration?: boolean;
  StaticRoutesOnly?: boolean;
  LocalIpv4NetworkCidr?: string;
  RemoteIpv4NetworkCidr?: string;
  LocalIpv6NetworkCidr?: string;
  RemoteIpv6NetworkCidr?: string;
  OutsideIpAddressType?: string;
  TransportTransitGatewayAttachmentId?: string;
  TunnelInsideIpVersion?: TunnelInsideIpVersion;
  TunnelOptions?: TunnelOption[];
}
export declare const VpnStaticRouteSource: {
  readonly Static: "Static";
};
export type VpnStaticRouteSource =
  (typeof VpnStaticRouteSource)[keyof typeof VpnStaticRouteSource];
export declare const VpnState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type VpnState = (typeof VpnState)[keyof typeof VpnState];
export interface VpnStaticRoute {
  DestinationCidrBlock?: string;
  Source?: VpnStaticRouteSource;
  State?: VpnState;
}
export declare const TelemetryStatus: {
  readonly DOWN: "DOWN";
  readonly UP: "UP";
};
export type TelemetryStatus =
  (typeof TelemetryStatus)[keyof typeof TelemetryStatus];
export interface VgwTelemetry {
  AcceptedRouteCount?: number;
  LastStatusChange?: Date;
  OutsideIpAddress?: string;
  Status?: TelemetryStatus;
  StatusMessage?: string;
  CertificateArn?: string;
}
export interface VpnConnection {
  CustomerGatewayConfiguration?: string;
  CustomerGatewayId?: string;
  Category?: string;
  State?: VpnState;
  Type?: GatewayType;
  VpnConnectionId?: string;
  VpnGatewayId?: string;
  TransitGatewayId?: string;
  CoreNetworkArn?: string;
  CoreNetworkAttachmentArn?: string;
  GatewayAssociationState?: GatewayAssociationState;
  Options?: VpnConnectionOptions;
  Routes?: VpnStaticRoute[];
  Tags?: Tag[];
  VgwTelemetry?: VgwTelemetry[];
}
export interface CreateVpnConnectionResult {
  VpnConnection?: VpnConnection;
}
export interface CreateVpnConnectionRouteRequest {
  DestinationCidrBlock: string | undefined;
  VpnConnectionId: string | undefined;
}
export interface CreateVpnGatewayRequest {
  AvailabilityZone?: string;
  Type: GatewayType | undefined;
  TagSpecifications?: TagSpecification[];
  AmazonSideAsn?: number;
  DryRun?: boolean;
}
export interface VpnGateway {
  AvailabilityZone?: string;
  State?: VpnState;
  Type?: GatewayType;
  VpcAttachments?: VpcAttachment[];
  VpnGatewayId?: string;
  AmazonSideAsn?: number;
  Tags?: Tag[];
}
export interface CreateVpnGatewayResult {
  VpnGateway?: VpnGateway;
}
export interface DeleteCarrierGatewayRequest {
  CarrierGatewayId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteCarrierGatewayResult {
  CarrierGateway?: CarrierGateway;
}
export interface DeleteClientVpnEndpointRequest {
  ClientVpnEndpointId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteClientVpnEndpointResult {
  Status?: ClientVpnEndpointStatus;
}
export interface DeleteClientVpnRouteRequest {
  ClientVpnEndpointId: string | undefined;
  TargetVpcSubnetId?: string;
  DestinationCidrBlock: string | undefined;
  DryRun?: boolean;
}
export interface DeleteClientVpnRouteResult {
  Status?: ClientVpnRouteStatus;
}
export interface DeleteCoipCidrRequest {
  Cidr: string | undefined;
  CoipPoolId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteCoipCidrResult {
  CoipCidr?: CoipCidr;
}
export interface DeleteCoipPoolRequest {
  CoipPoolId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteCoipPoolResult {
  CoipPool?: CoipPool;
}
export interface DeleteCustomerGatewayRequest {
  CustomerGatewayId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteDhcpOptionsRequest {
  DhcpOptionsId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteEgressOnlyInternetGatewayRequest {
  DryRun?: boolean;
  EgressOnlyInternetGatewayId: string | undefined;
}
export interface DeleteEgressOnlyInternetGatewayResult {
  ReturnCode?: boolean;
}
export interface DeleteFleetsRequest {
  DryRun?: boolean;
  FleetIds: string[] | undefined;
  TerminateInstances: boolean | undefined;
}
export declare const FleetStateCode: {
  readonly ACTIVE: "active";
  readonly DELETED: "deleted";
  readonly DELETED_RUNNING: "deleted_running";
  readonly DELETED_TERMINATING_INSTANCES: "deleted_terminating";
  readonly FAILED: "failed";
  readonly MODIFYING: "modifying";
  readonly SUBMITTED: "submitted";
};
export type FleetStateCode =
  (typeof FleetStateCode)[keyof typeof FleetStateCode];
export interface DeleteFleetSuccessItem {
  CurrentFleetState?: FleetStateCode;
  PreviousFleetState?: FleetStateCode;
  FleetId?: string;
}
export declare const DeleteFleetErrorCode: {
  readonly FLEET_ID_DOES_NOT_EXIST: "fleetIdDoesNotExist";
  readonly FLEET_ID_MALFORMED: "fleetIdMalformed";
  readonly FLEET_NOT_IN_DELETABLE_STATE: "fleetNotInDeletableState";
  readonly UNEXPECTED_ERROR: "unexpectedError";
};
export type DeleteFleetErrorCode =
  (typeof DeleteFleetErrorCode)[keyof typeof DeleteFleetErrorCode];
export interface DeleteFleetError {
  Code?: DeleteFleetErrorCode;
  Message?: string;
}
export interface DeleteFleetErrorItem {
  Error?: DeleteFleetError;
  FleetId?: string;
}
export interface DeleteFleetsResult {
  SuccessfulFleetDeletions?: DeleteFleetSuccessItem[];
  UnsuccessfulFleetDeletions?: DeleteFleetErrorItem[];
}
export interface DeleteFlowLogsRequest {
  DryRun?: boolean;
  FlowLogIds: string[] | undefined;
}
export interface DeleteFlowLogsResult {
  Unsuccessful?: UnsuccessfulItem[];
}
export interface DeleteFpgaImageRequest {
  DryRun?: boolean;
  FpgaImageId: string | undefined;
}
export interface DeleteFpgaImageResult {
  Return?: boolean;
}
export interface DeleteInstanceConnectEndpointRequest {
  DryRun?: boolean;
  InstanceConnectEndpointId: string | undefined;
}
export interface DeleteInstanceConnectEndpointResult {
  InstanceConnectEndpoint?: Ec2InstanceConnectEndpoint;
}
export interface DeleteInstanceEventWindowRequest {
  DryRun?: boolean;
  ForceDelete?: boolean;
  InstanceEventWindowId: string | undefined;
}
export interface InstanceEventWindowStateChange {
  InstanceEventWindowId?: string;
  State?: InstanceEventWindowState;
}
export interface DeleteInstanceEventWindowResult {
  InstanceEventWindowState?: InstanceEventWindowStateChange;
}
export interface DeleteInternetGatewayRequest {
  DryRun?: boolean;
  InternetGatewayId: string | undefined;
}
export interface DeleteIpamRequest {
  DryRun?: boolean;
  IpamId: string | undefined;
  Cascade?: boolean;
}
export interface DeleteIpamResult {
  Ipam?: Ipam;
}
export interface DeleteIpamPoolRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  Cascade?: boolean;
}
export interface DeleteIpamPoolResult {
  IpamPool?: IpamPool;
}
export interface DeleteIpamResourceDiscoveryRequest {
  DryRun?: boolean;
  IpamResourceDiscoveryId: string | undefined;
}
export interface DeleteIpamResourceDiscoveryResult {
  IpamResourceDiscovery?: IpamResourceDiscovery;
}
export interface DeleteIpamScopeRequest {
  DryRun?: boolean;
  IpamScopeId: string | undefined;
}
export interface DeleteIpamScopeResult {
  IpamScope?: IpamScope;
}
export interface DeleteKeyPairRequest {
  KeyName?: string;
  KeyPairId?: string;
  DryRun?: boolean;
}
export interface DeleteKeyPairResult {
  Return?: boolean;
  KeyPairId?: string;
}
export interface DeleteLaunchTemplateRequest {
  DryRun?: boolean;
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
}
export interface DeleteLaunchTemplateResult {
  LaunchTemplate?: LaunchTemplate;
}
export interface DeleteLaunchTemplateVersionsRequest {
  DryRun?: boolean;
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  Versions: string[] | undefined;
}
export interface DeleteLaunchTemplateVersionsResponseSuccessItem {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  VersionNumber?: number;
}
export declare const LaunchTemplateErrorCode: {
  readonly LAUNCH_TEMPLATE_ID_DOES_NOT_EXIST: "launchTemplateIdDoesNotExist";
  readonly LAUNCH_TEMPLATE_ID_MALFORMED: "launchTemplateIdMalformed";
  readonly LAUNCH_TEMPLATE_NAME_DOES_NOT_EXIST: "launchTemplateNameDoesNotExist";
  readonly LAUNCH_TEMPLATE_NAME_MALFORMED: "launchTemplateNameMalformed";
  readonly LAUNCH_TEMPLATE_VERSION_DOES_NOT_EXIST: "launchTemplateVersionDoesNotExist";
  readonly UNEXPECTED_ERROR: "unexpectedError";
};
export type LaunchTemplateErrorCode =
  (typeof LaunchTemplateErrorCode)[keyof typeof LaunchTemplateErrorCode];
export interface ResponseError {
  Code?: LaunchTemplateErrorCode;
  Message?: string;
}
export interface DeleteLaunchTemplateVersionsResponseErrorItem {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  VersionNumber?: number;
  ResponseError?: ResponseError;
}
export interface DeleteLaunchTemplateVersionsResult {
  SuccessfullyDeletedLaunchTemplateVersions?: DeleteLaunchTemplateVersionsResponseSuccessItem[];
  UnsuccessfullyDeletedLaunchTemplateVersions?: DeleteLaunchTemplateVersionsResponseErrorItem[];
}
export interface DeleteLocalGatewayRouteRequest {
  DestinationCidrBlock?: string;
  LocalGatewayRouteTableId: string | undefined;
  DryRun?: boolean;
  DestinationPrefixListId?: string;
}
export interface DeleteLocalGatewayRouteResult {
  Route?: LocalGatewayRoute;
}
export interface DeleteLocalGatewayRouteTableRequest {
  LocalGatewayRouteTableId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteLocalGatewayRouteTableResult {
  LocalGatewayRouteTable?: LocalGatewayRouteTable;
}
export interface DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociationId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociation?: LocalGatewayRouteTableVirtualInterfaceGroupAssociation;
}
export interface DeleteLocalGatewayRouteTableVpcAssociationRequest {
  LocalGatewayRouteTableVpcAssociationId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteLocalGatewayRouteTableVpcAssociationResult {
  LocalGatewayRouteTableVpcAssociation?: LocalGatewayRouteTableVpcAssociation;
}
export interface DeleteManagedPrefixListRequest {
  DryRun?: boolean;
  PrefixListId: string | undefined;
}
export interface DeleteManagedPrefixListResult {
  PrefixList?: ManagedPrefixList;
}
export declare const CreateVerifiedAccessTrustProviderOidcOptionsFilterSensitiveLog: (
  obj: CreateVerifiedAccessTrustProviderOidcOptions
) => any;
export declare const CreateVerifiedAccessTrustProviderRequestFilterSensitiveLog: (
  obj: CreateVerifiedAccessTrustProviderRequest
) => any;
export declare const CreateVerifiedAccessTrustProviderResultFilterSensitiveLog: (
  obj: CreateVerifiedAccessTrustProviderResult
) => any;
export declare const VpnTunnelOptionsSpecificationFilterSensitiveLog: (
  obj: VpnTunnelOptionsSpecification
) => any;
export declare const VpnConnectionOptionsSpecificationFilterSensitiveLog: (
  obj: VpnConnectionOptionsSpecification
) => any;
export declare const CreateVpnConnectionRequestFilterSensitiveLog: (
  obj: CreateVpnConnectionRequest
) => any;
export declare const TunnelOptionFilterSensitiveLog: (obj: TunnelOption) => any;
export declare const VpnConnectionOptionsFilterSensitiveLog: (
  obj: VpnConnectionOptions
) => any;
export declare const VpnConnectionFilterSensitiveLog: (
  obj: VpnConnection
) => any;
export declare const CreateVpnConnectionResultFilterSensitiveLog: (
  obj: CreateVpnConnectionResult
) => any;
