import {
  _InstanceType,
  AccountAttribute,
  AccountAttributeName,
  ActiveInstance,
  Address,
  AddressAttribute,
  AddressAttributeName,
  AddressTransfer,
  AllocationState,
  AllowsMultipleInstanceTypes,
  AssociationStatus,
  AutoPlacement,
  BundleTask,
  ByoipCidr,
  CapacityReservation,
  CapacityReservationFleetState,
  CapacityReservationTenancy,
  ClientVpnAuthorizationRuleStatus,
  CurrencyCodeValues,
  FleetCapacityReservation,
  FleetCapacityReservationTenancy,
  FleetInstanceMatchCriteria,
  HostMaintenance,
  HostRecovery,
  IamInstanceProfileAssociation,
  Tag,
  TransitGatewayPeeringAttachment,
  TransitGatewayVpcAttachment,
  UnsuccessfulItem,
  VerifiedAccessInstance,
  VerifiedAccessTrustProvider,
} from "./models_0";
import {
  AttributeValue,
  BlockDeviceMapping,
  CarrierGateway,
  ClientVpnAuthenticationType,
  ClientVpnEndpointStatus,
  ClientVpnRouteStatus,
  CoipPool,
  CustomerGateway,
  DefaultTargetCapacityType,
  DestinationFileFormat,
  DhcpOptions,
  DiskImageFormat,
  EgressOnlyInternetGateway,
  ExportTask,
  FleetCapacityReservationUsageStrategy,
  FleetExcessCapacityTerminationPolicy,
  FleetLaunchTemplateOverrides,
  FleetLaunchTemplateSpecification,
  FleetOnDemandAllocationStrategy,
  FleetReplacementStrategy,
  FleetType,
  GroupIdentifier,
  InstanceLifecycle,
  LaunchTemplateAndOverridesResponse,
  LogDestinationType,
  PlatformValues,
  SpotAllocationStrategy,
  SpotInstanceInterruptionBehavior,
  StateReason,
  TargetCapacityUnitType,
  TrafficType,
  TransportProtocol,
} from "./models_1";
import {
  FleetStateCode,
  SubnetCidrReservation,
  TransitGateway,
  TransitGatewayConnect,
  TransitGatewayConnectPeer,
  TransitGatewayMulticastDomain,
  TransitGatewayPolicyTable,
  TransitGatewayPrefixListReference,
  TransitGatewayRoute,
  TransitGatewayRouteTable,
  TransitGatewayRouteTableAnnouncement,
  VerifiedAccessEndpoint,
  VerifiedAccessGroup,
} from "./models_2";
export interface DeleteNatGatewayRequest {
  DryRun?: boolean;
  NatGatewayId: string | undefined;
}
export interface DeleteNatGatewayResult {
  NatGatewayId?: string;
}
export interface DeleteNetworkAclRequest {
  DryRun?: boolean;
  NetworkAclId: string | undefined;
}
export interface DeleteNetworkAclEntryRequest {
  DryRun?: boolean;
  Egress: boolean | undefined;
  NetworkAclId: string | undefined;
  RuleNumber: number | undefined;
}
export interface DeleteNetworkInsightsAccessScopeRequest {
  DryRun?: boolean;
  NetworkInsightsAccessScopeId: string | undefined;
}
export interface DeleteNetworkInsightsAccessScopeResult {
  NetworkInsightsAccessScopeId?: string;
}
export interface DeleteNetworkInsightsAccessScopeAnalysisRequest {
  NetworkInsightsAccessScopeAnalysisId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteNetworkInsightsAccessScopeAnalysisResult {
  NetworkInsightsAccessScopeAnalysisId?: string;
}
export interface DeleteNetworkInsightsAnalysisRequest {
  DryRun?: boolean;
  NetworkInsightsAnalysisId: string | undefined;
}
export interface DeleteNetworkInsightsAnalysisResult {
  NetworkInsightsAnalysisId?: string;
}
export interface DeleteNetworkInsightsPathRequest {
  DryRun?: boolean;
  NetworkInsightsPathId: string | undefined;
}
export interface DeleteNetworkInsightsPathResult {
  NetworkInsightsPathId?: string;
}
export interface DeleteNetworkInterfaceRequest {
  DryRun?: boolean;
  NetworkInterfaceId: string | undefined;
}
export interface DeleteNetworkInterfacePermissionRequest {
  NetworkInterfacePermissionId: string | undefined;
  Force?: boolean;
  DryRun?: boolean;
}
export interface DeleteNetworkInterfacePermissionResult {
  Return?: boolean;
}
export interface DeletePlacementGroupRequest {
  DryRun?: boolean;
  GroupName: string | undefined;
}
export interface DeletePublicIpv4PoolRequest {
  DryRun?: boolean;
  PoolId: string | undefined;
}
export interface DeletePublicIpv4PoolResult {
  ReturnValue?: boolean;
}
export interface DeleteQueuedReservedInstancesRequest {
  DryRun?: boolean;
  ReservedInstancesIds: string[] | undefined;
}
export declare const DeleteQueuedReservedInstancesErrorCode: {
  readonly RESERVED_INSTANCES_ID_INVALID: "reserved-instances-id-invalid";
  readonly RESERVED_INSTANCES_NOT_IN_QUEUED_STATE: "reserved-instances-not-in-queued-state";
  readonly UNEXPECTED_ERROR: "unexpected-error";
};
export type DeleteQueuedReservedInstancesErrorCode =
  (typeof DeleteQueuedReservedInstancesErrorCode)[keyof typeof DeleteQueuedReservedInstancesErrorCode];
export interface DeleteQueuedReservedInstancesError {
  Code?: DeleteQueuedReservedInstancesErrorCode;
  Message?: string;
}
export interface FailedQueuedPurchaseDeletion {
  Error?: DeleteQueuedReservedInstancesError;
  ReservedInstancesId?: string;
}
export interface SuccessfulQueuedPurchaseDeletion {
  ReservedInstancesId?: string;
}
export interface DeleteQueuedReservedInstancesResult {
  SuccessfulQueuedPurchaseDeletions?: SuccessfulQueuedPurchaseDeletion[];
  FailedQueuedPurchaseDeletions?: FailedQueuedPurchaseDeletion[];
}
export interface DeleteRouteRequest {
  DestinationCidrBlock?: string;
  DestinationIpv6CidrBlock?: string;
  DestinationPrefixListId?: string;
  DryRun?: boolean;
  RouteTableId: string | undefined;
}
export interface DeleteRouteTableRequest {
  DryRun?: boolean;
  RouteTableId: string | undefined;
}
export interface DeleteSecurityGroupRequest {
  GroupId?: string;
  GroupName?: string;
  DryRun?: boolean;
}
export interface DeleteSnapshotRequest {
  SnapshotId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteSpotDatafeedSubscriptionRequest {
  DryRun?: boolean;
}
export interface DeleteSubnetRequest {
  SubnetId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteSubnetCidrReservationRequest {
  SubnetCidrReservationId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteSubnetCidrReservationResult {
  DeletedSubnetCidrReservation?: SubnetCidrReservation;
}
export interface DeleteTagsRequest {
  DryRun?: boolean;
  Resources: string[] | undefined;
  Tags?: Tag[];
}
export interface DeleteTrafficMirrorFilterRequest {
  TrafficMirrorFilterId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTrafficMirrorFilterResult {
  TrafficMirrorFilterId?: string;
}
export interface DeleteTrafficMirrorFilterRuleRequest {
  TrafficMirrorFilterRuleId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTrafficMirrorFilterRuleResult {
  TrafficMirrorFilterRuleId?: string;
}
export interface DeleteTrafficMirrorSessionRequest {
  TrafficMirrorSessionId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTrafficMirrorSessionResult {
  TrafficMirrorSessionId?: string;
}
export interface DeleteTrafficMirrorTargetRequest {
  TrafficMirrorTargetId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTrafficMirrorTargetResult {
  TrafficMirrorTargetId?: string;
}
export interface DeleteTransitGatewayRequest {
  TransitGatewayId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayResult {
  TransitGateway?: TransitGateway;
}
export interface DeleteTransitGatewayConnectRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayConnectResult {
  TransitGatewayConnect?: TransitGatewayConnect;
}
export interface DeleteTransitGatewayConnectPeerRequest {
  TransitGatewayConnectPeerId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayConnectPeerResult {
  TransitGatewayConnectPeer?: TransitGatewayConnectPeer;
}
export interface DeleteTransitGatewayMulticastDomainRequest {
  TransitGatewayMulticastDomainId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayMulticastDomainResult {
  TransitGatewayMulticastDomain?: TransitGatewayMulticastDomain;
}
export interface DeleteTransitGatewayPeeringAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayPeeringAttachmentResult {
  TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
export interface DeleteTransitGatewayPolicyTableRequest {
  TransitGatewayPolicyTableId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayPolicyTableResult {
  TransitGatewayPolicyTable?: TransitGatewayPolicyTable;
}
export interface DeleteTransitGatewayPrefixListReferenceRequest {
  TransitGatewayRouteTableId: string | undefined;
  PrefixListId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayPrefixListReferenceResult {
  TransitGatewayPrefixListReference?: TransitGatewayPrefixListReference;
}
export interface DeleteTransitGatewayRouteRequest {
  TransitGatewayRouteTableId: string | undefined;
  DestinationCidrBlock: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayRouteResult {
  Route?: TransitGatewayRoute;
}
export interface DeleteTransitGatewayRouteTableRequest {
  TransitGatewayRouteTableId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayRouteTableResult {
  TransitGatewayRouteTable?: TransitGatewayRouteTable;
}
export interface DeleteTransitGatewayRouteTableAnnouncementRequest {
  TransitGatewayRouteTableAnnouncementId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayRouteTableAnnouncementResult {
  TransitGatewayRouteTableAnnouncement?: TransitGatewayRouteTableAnnouncement;
}
export interface DeleteTransitGatewayVpcAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteTransitGatewayVpcAttachmentResult {
  TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export interface DeleteVerifiedAccessEndpointRequest {
  VerifiedAccessEndpointId: string | undefined;
  ClientToken?: string;
  DryRun?: boolean;
}
export interface DeleteVerifiedAccessEndpointResult {
  VerifiedAccessEndpoint?: VerifiedAccessEndpoint;
}
export interface DeleteVerifiedAccessGroupRequest {
  VerifiedAccessGroupId: string | undefined;
  ClientToken?: string;
  DryRun?: boolean;
}
export interface DeleteVerifiedAccessGroupResult {
  VerifiedAccessGroup?: VerifiedAccessGroup;
}
export interface DeleteVerifiedAccessInstanceRequest {
  VerifiedAccessInstanceId: string | undefined;
  DryRun?: boolean;
  ClientToken?: string;
}
export interface DeleteVerifiedAccessInstanceResult {
  VerifiedAccessInstance?: VerifiedAccessInstance;
}
export interface DeleteVerifiedAccessTrustProviderRequest {
  VerifiedAccessTrustProviderId: string | undefined;
  DryRun?: boolean;
  ClientToken?: string;
}
export interface DeleteVerifiedAccessTrustProviderResult {
  VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider;
}
export interface DeleteVolumeRequest {
  VolumeId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteVpcRequest {
  VpcId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteVpcEndpointConnectionNotificationsRequest {
  DryRun?: boolean;
  ConnectionNotificationIds: string[] | undefined;
}
export interface DeleteVpcEndpointConnectionNotificationsResult {
  Unsuccessful?: UnsuccessfulItem[];
}
export interface DeleteVpcEndpointsRequest {
  DryRun?: boolean;
  VpcEndpointIds: string[] | undefined;
}
export interface DeleteVpcEndpointsResult {
  Unsuccessful?: UnsuccessfulItem[];
}
export interface DeleteVpcEndpointServiceConfigurationsRequest {
  DryRun?: boolean;
  ServiceIds: string[] | undefined;
}
export interface DeleteVpcEndpointServiceConfigurationsResult {
  Unsuccessful?: UnsuccessfulItem[];
}
export interface DeleteVpcPeeringConnectionRequest {
  DryRun?: boolean;
  VpcPeeringConnectionId: string | undefined;
}
export interface DeleteVpcPeeringConnectionResult {
  Return?: boolean;
}
export interface DeleteVpnConnectionRequest {
  VpnConnectionId: string | undefined;
  DryRun?: boolean;
}
export interface DeleteVpnConnectionRouteRequest {
  DestinationCidrBlock: string | undefined;
  VpnConnectionId: string | undefined;
}
export interface DeleteVpnGatewayRequest {
  VpnGatewayId: string | undefined;
  DryRun?: boolean;
}
export interface DeprovisionByoipCidrRequest {
  Cidr: string | undefined;
  DryRun?: boolean;
}
export interface DeprovisionByoipCidrResult {
  ByoipCidr?: ByoipCidr;
}
export interface DeprovisionIpamByoasnRequest {
  DryRun?: boolean;
  IpamId: string | undefined;
  Asn: string | undefined;
}
export declare const AsnState: {
  readonly deprovisioned: "deprovisioned";
  readonly failed_deprovision: "failed-deprovision";
  readonly failed_provision: "failed-provision";
  readonly pending_deprovision: "pending-deprovision";
  readonly pending_provision: "pending-provision";
  readonly provisioned: "provisioned";
};
export type AsnState = (typeof AsnState)[keyof typeof AsnState];
export interface Byoasn {
  Asn?: string;
  IpamId?: string;
  StatusMessage?: string;
  State?: AsnState;
}
export interface DeprovisionIpamByoasnResult {
  Byoasn?: Byoasn;
}
export interface DeprovisionIpamPoolCidrRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  Cidr?: string;
}
export declare const IpamPoolCidrFailureCode: {
  readonly cidr_not_available: "cidr-not-available";
  readonly limit_exceeded: "limit-exceeded";
};
export type IpamPoolCidrFailureCode =
  (typeof IpamPoolCidrFailureCode)[keyof typeof IpamPoolCidrFailureCode];
export interface IpamPoolCidrFailureReason {
  Code?: IpamPoolCidrFailureCode;
  Message?: string;
}
export declare const IpamPoolCidrState: {
  readonly deprovisioned: "deprovisioned";
  readonly failed_deprovision: "failed-deprovision";
  readonly failed_import: "failed-import";
  readonly failed_provision: "failed-provision";
  readonly pending_deprovision: "pending-deprovision";
  readonly pending_import: "pending-import";
  readonly pending_provision: "pending-provision";
  readonly provisioned: "provisioned";
};
export type IpamPoolCidrState =
  (typeof IpamPoolCidrState)[keyof typeof IpamPoolCidrState];
export interface IpamPoolCidr {
  Cidr?: string;
  State?: IpamPoolCidrState;
  FailureReason?: IpamPoolCidrFailureReason;
  IpamPoolCidrId?: string;
  NetmaskLength?: number;
}
export interface DeprovisionIpamPoolCidrResult {
  IpamPoolCidr?: IpamPoolCidr;
}
export interface DeprovisionPublicIpv4PoolCidrRequest {
  DryRun?: boolean;
  PoolId: string | undefined;
  Cidr: string | undefined;
}
export interface DeprovisionPublicIpv4PoolCidrResult {
  PoolId?: string;
  DeprovisionedAddresses?: string[];
}
export interface DeregisterImageRequest {
  ImageId: string | undefined;
  DryRun?: boolean;
}
export interface DeregisterInstanceTagAttributeRequest {
  IncludeAllTagsOfInstance?: boolean;
  InstanceTagKeys?: string[];
}
export interface DeregisterInstanceEventNotificationAttributesRequest {
  DryRun?: boolean;
  InstanceTagAttribute: DeregisterInstanceTagAttributeRequest | undefined;
}
export interface InstanceTagNotificationAttribute {
  InstanceTagKeys?: string[];
  IncludeAllTagsOfInstance?: boolean;
}
export interface DeregisterInstanceEventNotificationAttributesResult {
  InstanceTagAttribute?: InstanceTagNotificationAttribute;
}
export interface DeregisterTransitGatewayMulticastGroupMembersRequest {
  TransitGatewayMulticastDomainId?: string;
  GroupIpAddress?: string;
  NetworkInterfaceIds?: string[];
  DryRun?: boolean;
}
export interface TransitGatewayMulticastDeregisteredGroupMembers {
  TransitGatewayMulticastDomainId?: string;
  DeregisteredNetworkInterfaceIds?: string[];
  GroupIpAddress?: string;
}
export interface DeregisterTransitGatewayMulticastGroupMembersResult {
  DeregisteredMulticastGroupMembers?: TransitGatewayMulticastDeregisteredGroupMembers;
}
export interface DeregisterTransitGatewayMulticastGroupSourcesRequest {
  TransitGatewayMulticastDomainId?: string;
  GroupIpAddress?: string;
  NetworkInterfaceIds?: string[];
  DryRun?: boolean;
}
export interface TransitGatewayMulticastDeregisteredGroupSources {
  TransitGatewayMulticastDomainId?: string;
  DeregisteredNetworkInterfaceIds?: string[];
  GroupIpAddress?: string;
}
export interface DeregisterTransitGatewayMulticastGroupSourcesResult {
  DeregisteredMulticastGroupSources?: TransitGatewayMulticastDeregisteredGroupSources;
}
export interface DescribeAccountAttributesRequest {
  AttributeNames?: AccountAttributeName[];
  DryRun?: boolean;
}
export interface DescribeAccountAttributesResult {
  AccountAttributes?: AccountAttribute[];
}
export interface Filter {
  Name?: string;
  Values?: string[];
}
export interface DescribeAddressesRequest {
  Filters?: Filter[];
  PublicIps?: string[];
  AllocationIds?: string[];
  DryRun?: boolean;
}
export interface DescribeAddressesResult {
  Addresses?: Address[];
}
export interface DescribeAddressesAttributeRequest {
  AllocationIds?: string[];
  Attribute?: AddressAttributeName;
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
}
export interface DescribeAddressesAttributeResult {
  Addresses?: AddressAttribute[];
  NextToken?: string;
}
export interface DescribeAddressTransfersRequest {
  AllocationIds?: string[];
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
}
export interface DescribeAddressTransfersResult {
  AddressTransfers?: AddressTransfer[];
  NextToken?: string;
}
export interface DescribeAggregateIdFormatRequest {
  DryRun?: boolean;
}
export interface IdFormat {
  Deadline?: Date;
  Resource?: string;
  UseLongIds?: boolean;
}
export interface DescribeAggregateIdFormatResult {
  UseLongIdsAggregated?: boolean;
  Statuses?: IdFormat[];
}
export interface DescribeAvailabilityZonesRequest {
  Filters?: Filter[];
  ZoneNames?: string[];
  ZoneIds?: string[];
  AllAvailabilityZones?: boolean;
  DryRun?: boolean;
}
export interface AvailabilityZoneMessage {
  Message?: string;
}
export declare const AvailabilityZoneOptInStatus: {
  readonly not_opted_in: "not-opted-in";
  readonly opt_in_not_required: "opt-in-not-required";
  readonly opted_in: "opted-in";
};
export type AvailabilityZoneOptInStatus =
  (typeof AvailabilityZoneOptInStatus)[keyof typeof AvailabilityZoneOptInStatus];
export declare const AvailabilityZoneState: {
  readonly available: "available";
  readonly constrained: "constrained";
  readonly impaired: "impaired";
  readonly information: "information";
  readonly unavailable: "unavailable";
};
export type AvailabilityZoneState =
  (typeof AvailabilityZoneState)[keyof typeof AvailabilityZoneState];
export interface AvailabilityZone {
  State?: AvailabilityZoneState;
  OptInStatus?: AvailabilityZoneOptInStatus;
  Messages?: AvailabilityZoneMessage[];
  RegionName?: string;
  ZoneName?: string;
  ZoneId?: string;
  GroupName?: string;
  NetworkBorderGroup?: string;
  ZoneType?: string;
  ParentZoneName?: string;
  ParentZoneId?: string;
}
export interface DescribeAvailabilityZonesResult {
  AvailabilityZones?: AvailabilityZone[];
}
export interface DescribeAwsNetworkPerformanceMetricSubscriptionsRequest {
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export declare const MetricType: {
  readonly aggregate_latency: "aggregate-latency";
};
export type MetricType = (typeof MetricType)[keyof typeof MetricType];
export declare const PeriodType: {
  readonly fifteen_minutes: "fifteen-minutes";
  readonly five_minutes: "five-minutes";
  readonly one_day: "one-day";
  readonly one_hour: "one-hour";
  readonly one_week: "one-week";
  readonly three_hours: "three-hours";
};
export type PeriodType = (typeof PeriodType)[keyof typeof PeriodType];
export declare const StatisticType: {
  readonly p50: "p50";
};
export type StatisticType = (typeof StatisticType)[keyof typeof StatisticType];
export interface Subscription {
  Source?: string;
  Destination?: string;
  Metric?: MetricType;
  Statistic?: StatisticType;
  Period?: PeriodType;
}
export interface DescribeAwsNetworkPerformanceMetricSubscriptionsResult {
  NextToken?: string;
  Subscriptions?: Subscription[];
}
export interface DescribeBundleTasksRequest {
  BundleIds?: string[];
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface DescribeBundleTasksResult {
  BundleTasks?: BundleTask[];
}
export interface DescribeByoipCidrsRequest {
  DryRun?: boolean;
  MaxResults: number | undefined;
  NextToken?: string;
}
export interface DescribeByoipCidrsResult {
  ByoipCidrs?: ByoipCidr[];
  NextToken?: string;
}
export interface DescribeCapacityBlockOfferingsRequest {
  DryRun?: boolean;
  InstanceType: string | undefined;
  InstanceCount: number | undefined;
  StartDateRange?: Date;
  EndDateRange?: Date;
  CapacityDurationHours: number | undefined;
  NextToken?: string;
  MaxResults?: number;
}
export interface CapacityBlockOffering {
  CapacityBlockOfferingId?: string;
  InstanceType?: string;
  AvailabilityZone?: string;
  InstanceCount?: number;
  StartDate?: Date;
  EndDate?: Date;
  CapacityBlockDurationHours?: number;
  UpfrontFee?: string;
  CurrencyCode?: string;
  Tenancy?: CapacityReservationTenancy;
}
export interface DescribeCapacityBlockOfferingsResult {
  CapacityBlockOfferings?: CapacityBlockOffering[];
  NextToken?: string;
}
export interface DescribeCapacityReservationFleetsRequest {
  CapacityReservationFleetIds?: string[];
  NextToken?: string;
  MaxResults?: number;
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface CapacityReservationFleet {
  CapacityReservationFleetId?: string;
  CapacityReservationFleetArn?: string;
  State?: CapacityReservationFleetState;
  TotalTargetCapacity?: number;
  TotalFulfilledCapacity?: number;
  Tenancy?: FleetCapacityReservationTenancy;
  EndDate?: Date;
  CreateTime?: Date;
  InstanceMatchCriteria?: FleetInstanceMatchCriteria;
  AllocationStrategy?: string;
  InstanceTypeSpecifications?: FleetCapacityReservation[];
  Tags?: Tag[];
}
export interface DescribeCapacityReservationFleetsResult {
  CapacityReservationFleets?: CapacityReservationFleet[];
  NextToken?: string;
}
export interface DescribeCapacityReservationsRequest {
  CapacityReservationIds?: string[];
  NextToken?: string;
  MaxResults?: number;
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface DescribeCapacityReservationsResult {
  NextToken?: string;
  CapacityReservations?: CapacityReservation[];
}
export interface DescribeCarrierGatewaysRequest {
  CarrierGatewayIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeCarrierGatewaysResult {
  CarrierGateways?: CarrierGateway[];
  NextToken?: string;
}
export interface DescribeClassicLinkInstancesRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  InstanceIds?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface ClassicLinkInstance {
  Groups?: GroupIdentifier[];
  InstanceId?: string;
  Tags?: Tag[];
  VpcId?: string;
}
export interface DescribeClassicLinkInstancesResult {
  Instances?: ClassicLinkInstance[];
  NextToken?: string;
}
export interface DescribeClientVpnAuthorizationRulesRequest {
  ClientVpnEndpointId: string | undefined;
  DryRun?: boolean;
  NextToken?: string;
  Filters?: Filter[];
  MaxResults?: number;
}
export interface AuthorizationRule {
  ClientVpnEndpointId?: string;
  Description?: string;
  GroupId?: string;
  AccessAll?: boolean;
  DestinationCidr?: string;
  Status?: ClientVpnAuthorizationRuleStatus;
}
export interface DescribeClientVpnAuthorizationRulesResult {
  AuthorizationRules?: AuthorizationRule[];
  NextToken?: string;
}
export interface DescribeClientVpnConnectionsRequest {
  ClientVpnEndpointId: string | undefined;
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
}
export declare const ClientVpnConnectionStatusCode: {
  readonly active: "active";
  readonly failed_to_terminate: "failed-to-terminate";
  readonly terminated: "terminated";
  readonly terminating: "terminating";
};
export type ClientVpnConnectionStatusCode =
  (typeof ClientVpnConnectionStatusCode)[keyof typeof ClientVpnConnectionStatusCode];
export interface ClientVpnConnectionStatus {
  Code?: ClientVpnConnectionStatusCode;
  Message?: string;
}
export interface ClientVpnConnection {
  ClientVpnEndpointId?: string;
  Timestamp?: string;
  ConnectionId?: string;
  Username?: string;
  ConnectionEstablishedTime?: string;
  IngressBytes?: string;
  EgressBytes?: string;
  IngressPackets?: string;
  EgressPackets?: string;
  ClientIp?: string;
  CommonName?: string;
  Status?: ClientVpnConnectionStatus;
  ConnectionEndTime?: string;
  PostureComplianceStatuses?: string[];
}
export interface DescribeClientVpnConnectionsResult {
  Connections?: ClientVpnConnection[];
  NextToken?: string;
}
export interface DescribeClientVpnEndpointsRequest {
  ClientVpnEndpointIds?: string[];
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export declare const AssociatedNetworkType: {
  readonly vpc: "vpc";
};
export type AssociatedNetworkType =
  (typeof AssociatedNetworkType)[keyof typeof AssociatedNetworkType];
export interface AssociatedTargetNetwork {
  NetworkId?: string;
  NetworkType?: AssociatedNetworkType;
}
export interface DirectoryServiceAuthentication {
  DirectoryId?: string;
}
export interface FederatedAuthentication {
  SamlProviderArn?: string;
  SelfServiceSamlProviderArn?: string;
}
export interface CertificateAuthentication {
  ClientRootCertificateChain?: string;
}
export interface ClientVpnAuthentication {
  Type?: ClientVpnAuthenticationType;
  ActiveDirectory?: DirectoryServiceAuthentication;
  MutualAuthentication?: CertificateAuthentication;
  FederatedAuthentication?: FederatedAuthentication;
}
export declare const ClientVpnEndpointAttributeStatusCode: {
  readonly applied: "applied";
  readonly applying: "applying";
};
export type ClientVpnEndpointAttributeStatusCode =
  (typeof ClientVpnEndpointAttributeStatusCode)[keyof typeof ClientVpnEndpointAttributeStatusCode];
export interface ClientVpnEndpointAttributeStatus {
  Code?: ClientVpnEndpointAttributeStatusCode;
  Message?: string;
}
export interface ClientConnectResponseOptions {
  Enabled?: boolean;
  LambdaFunctionArn?: string;
  Status?: ClientVpnEndpointAttributeStatus;
}
export interface ClientLoginBannerResponseOptions {
  Enabled?: boolean;
  BannerText?: string;
}
export interface ConnectionLogResponseOptions {
  Enabled?: boolean;
  CloudwatchLogGroup?: string;
  CloudwatchLogStream?: string;
}
export declare const VpnProtocol: {
  readonly openvpn: "openvpn";
};
export type VpnProtocol = (typeof VpnProtocol)[keyof typeof VpnProtocol];
export interface ClientVpnEndpoint {
  ClientVpnEndpointId?: string;
  Description?: string;
  Status?: ClientVpnEndpointStatus;
  CreationTime?: string;
  DeletionTime?: string;
  DnsName?: string;
  ClientCidrBlock?: string;
  DnsServers?: string[];
  SplitTunnel?: boolean;
  VpnProtocol?: VpnProtocol;
  TransportProtocol?: TransportProtocol;
  VpnPort?: number;
  AssociatedTargetNetworks?: AssociatedTargetNetwork[];
  ServerCertificateArn?: string;
  AuthenticationOptions?: ClientVpnAuthentication[];
  ConnectionLogOptions?: ConnectionLogResponseOptions;
  Tags?: Tag[];
  SecurityGroupIds?: string[];
  VpcId?: string;
  SelfServicePortalUrl?: string;
  ClientConnectOptions?: ClientConnectResponseOptions;
  SessionTimeoutHours?: number;
  ClientLoginBannerOptions?: ClientLoginBannerResponseOptions;
}
export interface DescribeClientVpnEndpointsResult {
  ClientVpnEndpoints?: ClientVpnEndpoint[];
  NextToken?: string;
}
export interface DescribeClientVpnRoutesRequest {
  ClientVpnEndpointId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface ClientVpnRoute {
  ClientVpnEndpointId?: string;
  DestinationCidr?: string;
  TargetSubnet?: string;
  Type?: string;
  Origin?: string;
  Status?: ClientVpnRouteStatus;
  Description?: string;
}
export interface DescribeClientVpnRoutesResult {
  Routes?: ClientVpnRoute[];
  NextToken?: string;
}
export interface DescribeClientVpnTargetNetworksRequest {
  ClientVpnEndpointId: string | undefined;
  AssociationIds?: string[];
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface TargetNetwork {
  AssociationId?: string;
  VpcId?: string;
  TargetNetworkId?: string;
  ClientVpnEndpointId?: string;
  Status?: AssociationStatus;
  SecurityGroups?: string[];
}
export interface DescribeClientVpnTargetNetworksResult {
  ClientVpnTargetNetworks?: TargetNetwork[];
  NextToken?: string;
}
export interface DescribeCoipPoolsRequest {
  PoolIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeCoipPoolsResult {
  CoipPools?: CoipPool[];
  NextToken?: string;
}
export interface DescribeConversionTasksRequest {
  ConversionTaskIds?: string[];
  DryRun?: boolean;
}
export interface DiskImageDescription {
  Checksum?: string;
  Format?: DiskImageFormat;
  ImportManifestUrl?: string;
  Size?: number;
}
export interface DiskImageVolumeDescription {
  Id?: string;
  Size?: number;
}
export interface ImportInstanceVolumeDetailItem {
  AvailabilityZone?: string;
  BytesConverted?: number;
  Description?: string;
  Image?: DiskImageDescription;
  Status?: string;
  StatusMessage?: string;
  Volume?: DiskImageVolumeDescription;
}
export interface ImportInstanceTaskDetails {
  Description?: string;
  InstanceId?: string;
  Platform?: PlatformValues;
  Volumes?: ImportInstanceVolumeDetailItem[];
}
export interface ImportVolumeTaskDetails {
  AvailabilityZone?: string;
  BytesConverted?: number;
  Description?: string;
  Image?: DiskImageDescription;
  Volume?: DiskImageVolumeDescription;
}
export declare const ConversionTaskState: {
  readonly active: "active";
  readonly cancelled: "cancelled";
  readonly cancelling: "cancelling";
  readonly completed: "completed";
};
export type ConversionTaskState =
  (typeof ConversionTaskState)[keyof typeof ConversionTaskState];
export interface ConversionTask {
  ConversionTaskId?: string;
  ExpirationTime?: string;
  ImportInstance?: ImportInstanceTaskDetails;
  ImportVolume?: ImportVolumeTaskDetails;
  State?: ConversionTaskState;
  StatusMessage?: string;
  Tags?: Tag[];
}
export interface DescribeConversionTasksResult {
  ConversionTasks?: ConversionTask[];
}
export interface DescribeCustomerGatewaysRequest {
  CustomerGatewayIds?: string[];
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface DescribeCustomerGatewaysResult {
  CustomerGateways?: CustomerGateway[];
}
export interface DescribeDhcpOptionsRequest {
  DhcpOptionsIds?: string[];
  Filters?: Filter[];
  DryRun?: boolean;
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeDhcpOptionsResult {
  DhcpOptions?: DhcpOptions[];
  NextToken?: string;
}
export interface DescribeEgressOnlyInternetGatewaysRequest {
  DryRun?: boolean;
  EgressOnlyInternetGatewayIds?: string[];
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
}
export interface DescribeEgressOnlyInternetGatewaysResult {
  EgressOnlyInternetGateways?: EgressOnlyInternetGateway[];
  NextToken?: string;
}
export interface DescribeElasticGpusRequest {
  ElasticGpuIds?: string[];
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export declare const ElasticGpuStatus: {
  readonly Impaired: "IMPAIRED";
  readonly Ok: "OK";
};
export type ElasticGpuStatus =
  (typeof ElasticGpuStatus)[keyof typeof ElasticGpuStatus];
export interface ElasticGpuHealth {
  Status?: ElasticGpuStatus;
}
export declare const ElasticGpuState: {
  readonly Attached: "ATTACHED";
};
export type ElasticGpuState =
  (typeof ElasticGpuState)[keyof typeof ElasticGpuState];
export interface ElasticGpus {
  ElasticGpuId?: string;
  AvailabilityZone?: string;
  ElasticGpuType?: string;
  ElasticGpuHealth?: ElasticGpuHealth;
  ElasticGpuState?: ElasticGpuState;
  InstanceId?: string;
  Tags?: Tag[];
}
export interface DescribeElasticGpusResult {
  ElasticGpuSet?: ElasticGpus[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeExportImageTasksRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  ExportImageTaskIds?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface ExportTaskS3Location {
  S3Bucket?: string;
  S3Prefix?: string;
}
export interface ExportImageTask {
  Description?: string;
  ExportImageTaskId?: string;
  ImageId?: string;
  Progress?: string;
  S3ExportLocation?: ExportTaskS3Location;
  Status?: string;
  StatusMessage?: string;
  Tags?: Tag[];
}
export interface DescribeExportImageTasksResult {
  ExportImageTasks?: ExportImageTask[];
  NextToken?: string;
}
export interface DescribeExportTasksRequest {
  ExportTaskIds?: string[];
  Filters?: Filter[];
}
export interface DescribeExportTasksResult {
  ExportTasks?: ExportTask[];
}
export interface DescribeFastLaunchImagesRequest {
  ImageIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface FastLaunchLaunchTemplateSpecificationResponse {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  Version?: string;
}
export declare const FastLaunchResourceType: {
  readonly SNAPSHOT: "snapshot";
};
export type FastLaunchResourceType =
  (typeof FastLaunchResourceType)[keyof typeof FastLaunchResourceType];
export interface FastLaunchSnapshotConfigurationResponse {
  TargetResourceCount?: number;
}
export declare const FastLaunchStateCode: {
  readonly disabling: "disabling";
  readonly disabling_failed: "disabling-failed";
  readonly enabled: "enabled";
  readonly enabled_failed: "enabled-failed";
  readonly enabling: "enabling";
  readonly enabling_failed: "enabling-failed";
};
export type FastLaunchStateCode =
  (typeof FastLaunchStateCode)[keyof typeof FastLaunchStateCode];
export interface DescribeFastLaunchImagesSuccessItem {
  ImageId?: string;
  ResourceType?: FastLaunchResourceType;
  SnapshotConfiguration?: FastLaunchSnapshotConfigurationResponse;
  LaunchTemplate?: FastLaunchLaunchTemplateSpecificationResponse;
  MaxParallelLaunches?: number;
  OwnerId?: string;
  State?: FastLaunchStateCode;
  StateTransitionReason?: string;
  StateTransitionTime?: Date;
}
export interface DescribeFastLaunchImagesResult {
  FastLaunchImages?: DescribeFastLaunchImagesSuccessItem[];
  NextToken?: string;
}
export interface DescribeFastSnapshotRestoresRequest {
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export declare const FastSnapshotRestoreStateCode: {
  readonly disabled: "disabled";
  readonly disabling: "disabling";
  readonly enabled: "enabled";
  readonly enabling: "enabling";
  readonly optimizing: "optimizing";
};
export type FastSnapshotRestoreStateCode =
  (typeof FastSnapshotRestoreStateCode)[keyof typeof FastSnapshotRestoreStateCode];
export interface DescribeFastSnapshotRestoreSuccessItem {
  SnapshotId?: string;
  AvailabilityZone?: string;
  State?: FastSnapshotRestoreStateCode;
  StateTransitionReason?: string;
  OwnerId?: string;
  OwnerAlias?: string;
  EnablingTime?: Date;
  OptimizingTime?: Date;
  EnabledTime?: Date;
  DisablingTime?: Date;
  DisabledTime?: Date;
}
export interface DescribeFastSnapshotRestoresResult {
  FastSnapshotRestores?: DescribeFastSnapshotRestoreSuccessItem[];
  NextToken?: string;
}
export declare const FleetEventType: {
  readonly FLEET_CHANGE: "fleet-change";
  readonly INSTANCE_CHANGE: "instance-change";
  readonly SERVICE_ERROR: "service-error";
};
export type FleetEventType =
  (typeof FleetEventType)[keyof typeof FleetEventType];
export interface DescribeFleetHistoryRequest {
  DryRun?: boolean;
  EventType?: FleetEventType;
  MaxResults?: number;
  NextToken?: string;
  FleetId: string | undefined;
  StartTime: Date | undefined;
}
export interface EventInformation {
  EventDescription?: string;
  EventSubType?: string;
  InstanceId?: string;
}
export interface HistoryRecordEntry {
  EventInformation?: EventInformation;
  EventType?: FleetEventType;
  Timestamp?: Date;
}
export interface DescribeFleetHistoryResult {
  HistoryRecords?: HistoryRecordEntry[];
  LastEvaluatedTime?: Date;
  NextToken?: string;
  FleetId?: string;
  StartTime?: Date;
}
export interface DescribeFleetInstancesRequest {
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
  FleetId: string | undefined;
  Filters?: Filter[];
}
export interface DescribeFleetInstancesResult {
  ActiveInstances?: ActiveInstance[];
  NextToken?: string;
  FleetId?: string;
}
export interface DescribeFleetsRequest {
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
  FleetIds?: string[];
  Filters?: Filter[];
}
export declare const FleetActivityStatus: {
  readonly ERROR: "error";
  readonly FULFILLED: "fulfilled";
  readonly PENDING_FULFILLMENT: "pending_fulfillment";
  readonly PENDING_TERMINATION: "pending_termination";
};
export type FleetActivityStatus =
  (typeof FleetActivityStatus)[keyof typeof FleetActivityStatus];
export interface DescribeFleetError {
  LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
  Lifecycle?: InstanceLifecycle;
  ErrorCode?: string;
  ErrorMessage?: string;
}
export interface DescribeFleetsInstances {
  LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse;
  Lifecycle?: InstanceLifecycle;
  InstanceIds?: string[];
  InstanceType?: _InstanceType;
  Platform?: PlatformValues;
}
export interface FleetLaunchTemplateConfig {
  LaunchTemplateSpecification?: FleetLaunchTemplateSpecification;
  Overrides?: FleetLaunchTemplateOverrides[];
}
export interface CapacityReservationOptions {
  UsageStrategy?: FleetCapacityReservationUsageStrategy;
}
export interface OnDemandOptions {
  AllocationStrategy?: FleetOnDemandAllocationStrategy;
  CapacityReservationOptions?: CapacityReservationOptions;
  SingleInstanceType?: boolean;
  SingleAvailabilityZone?: boolean;
  MinTargetCapacity?: number;
  MaxTotalPrice?: string;
}
export interface FleetSpotCapacityRebalance {
  ReplacementStrategy?: FleetReplacementStrategy;
  TerminationDelay?: number;
}
export interface FleetSpotMaintenanceStrategies {
  CapacityRebalance?: FleetSpotCapacityRebalance;
}
export interface SpotOptions {
  AllocationStrategy?: SpotAllocationStrategy;
  MaintenanceStrategies?: FleetSpotMaintenanceStrategies;
  InstanceInterruptionBehavior?: SpotInstanceInterruptionBehavior;
  InstancePoolsToUseCount?: number;
  SingleInstanceType?: boolean;
  SingleAvailabilityZone?: boolean;
  MinTargetCapacity?: number;
  MaxTotalPrice?: string;
}
export interface TargetCapacitySpecification {
  TotalTargetCapacity?: number;
  OnDemandTargetCapacity?: number;
  SpotTargetCapacity?: number;
  DefaultTargetCapacityType?: DefaultTargetCapacityType;
  TargetCapacityUnitType?: TargetCapacityUnitType;
}
export interface FleetData {
  ActivityStatus?: FleetActivityStatus;
  CreateTime?: Date;
  FleetId?: string;
  FleetState?: FleetStateCode;
  ClientToken?: string;
  ExcessCapacityTerminationPolicy?: FleetExcessCapacityTerminationPolicy;
  FulfilledCapacity?: number;
  FulfilledOnDemandCapacity?: number;
  LaunchTemplateConfigs?: FleetLaunchTemplateConfig[];
  TargetCapacitySpecification?: TargetCapacitySpecification;
  TerminateInstancesWithExpiration?: boolean;
  Type?: FleetType;
  ValidFrom?: Date;
  ValidUntil?: Date;
  ReplaceUnhealthyInstances?: boolean;
  SpotOptions?: SpotOptions;
  OnDemandOptions?: OnDemandOptions;
  Tags?: Tag[];
  Errors?: DescribeFleetError[];
  Instances?: DescribeFleetsInstances[];
  Context?: string;
}
export interface DescribeFleetsResult {
  NextToken?: string;
  Fleets?: FleetData[];
}
export interface DescribeFlowLogsRequest {
  DryRun?: boolean;
  Filter?: Filter[];
  FlowLogIds?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DestinationOptionsResponse {
  FileFormat?: DestinationFileFormat;
  HiveCompatiblePartitions?: boolean;
  PerHourPartition?: boolean;
}
export interface FlowLog {
  CreationTime?: Date;
  DeliverLogsErrorMessage?: string;
  DeliverLogsPermissionArn?: string;
  DeliverCrossAccountRole?: string;
  DeliverLogsStatus?: string;
  FlowLogId?: string;
  FlowLogStatus?: string;
  LogGroupName?: string;
  ResourceId?: string;
  TrafficType?: TrafficType;
  LogDestinationType?: LogDestinationType;
  LogDestination?: string;
  LogFormat?: string;
  Tags?: Tag[];
  MaxAggregationInterval?: number;
  DestinationOptions?: DestinationOptionsResponse;
}
export interface DescribeFlowLogsResult {
  FlowLogs?: FlowLog[];
  NextToken?: string;
}
export declare const FpgaImageAttributeName: {
  readonly description: "description";
  readonly loadPermission: "loadPermission";
  readonly name: "name";
  readonly productCodes: "productCodes";
};
export type FpgaImageAttributeName =
  (typeof FpgaImageAttributeName)[keyof typeof FpgaImageAttributeName];
export interface DescribeFpgaImageAttributeRequest {
  DryRun?: boolean;
  FpgaImageId: string | undefined;
  Attribute: FpgaImageAttributeName | undefined;
}
export declare const PermissionGroup: {
  readonly all: "all";
};
export type PermissionGroup =
  (typeof PermissionGroup)[keyof typeof PermissionGroup];
export interface LoadPermission {
  UserId?: string;
  Group?: PermissionGroup;
}
export declare const ProductCodeValues: {
  readonly devpay: "devpay";
  readonly marketplace: "marketplace";
};
export type ProductCodeValues =
  (typeof ProductCodeValues)[keyof typeof ProductCodeValues];
export interface ProductCode {
  ProductCodeId?: string;
  ProductCodeType?: ProductCodeValues;
}
export interface FpgaImageAttribute {
  FpgaImageId?: string;
  Name?: string;
  Description?: string;
  LoadPermissions?: LoadPermission[];
  ProductCodes?: ProductCode[];
}
export interface DescribeFpgaImageAttributeResult {
  FpgaImageAttribute?: FpgaImageAttribute;
}
export interface DescribeFpgaImagesRequest {
  DryRun?: boolean;
  FpgaImageIds?: string[];
  Owners?: string[];
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
}
export interface PciId {
  DeviceId?: string;
  VendorId?: string;
  SubsystemId?: string;
  SubsystemVendorId?: string;
}
export declare const FpgaImageStateCode: {
  readonly available: "available";
  readonly failed: "failed";
  readonly pending: "pending";
  readonly unavailable: "unavailable";
};
export type FpgaImageStateCode =
  (typeof FpgaImageStateCode)[keyof typeof FpgaImageStateCode];
export interface FpgaImageState {
  Code?: FpgaImageStateCode;
  Message?: string;
}
export interface FpgaImage {
  FpgaImageId?: string;
  FpgaImageGlobalId?: string;
  Name?: string;
  Description?: string;
  ShellVersion?: string;
  PciId?: PciId;
  State?: FpgaImageState;
  CreateTime?: Date;
  UpdateTime?: Date;
  OwnerId?: string;
  OwnerAlias?: string;
  ProductCodes?: ProductCode[];
  Tags?: Tag[];
  Public?: boolean;
  DataRetentionSupport?: boolean;
  InstanceTypes?: string[];
}
export interface DescribeFpgaImagesResult {
  FpgaImages?: FpgaImage[];
  NextToken?: string;
}
export interface DescribeHostReservationOfferingsRequest {
  Filter?: Filter[];
  MaxDuration?: number;
  MaxResults?: number;
  MinDuration?: number;
  NextToken?: string;
  OfferingId?: string;
}
export declare const PaymentOption: {
  readonly ALL_UPFRONT: "AllUpfront";
  readonly NO_UPFRONT: "NoUpfront";
  readonly PARTIAL_UPFRONT: "PartialUpfront";
};
export type PaymentOption = (typeof PaymentOption)[keyof typeof PaymentOption];
export interface HostOffering {
  CurrencyCode?: CurrencyCodeValues;
  Duration?: number;
  HourlyPrice?: string;
  InstanceFamily?: string;
  OfferingId?: string;
  PaymentOption?: PaymentOption;
  UpfrontPrice?: string;
}
export interface DescribeHostReservationOfferingsResult {
  NextToken?: string;
  OfferingSet?: HostOffering[];
}
export interface DescribeHostReservationsRequest {
  Filter?: Filter[];
  HostReservationIdSet?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export declare const ReservationState: {
  readonly ACTIVE: "active";
  readonly PAYMENT_FAILED: "payment-failed";
  readonly PAYMENT_PENDING: "payment-pending";
  readonly RETIRED: "retired";
};
export type ReservationState =
  (typeof ReservationState)[keyof typeof ReservationState];
export interface HostReservation {
  Count?: number;
  CurrencyCode?: CurrencyCodeValues;
  Duration?: number;
  End?: Date;
  HostIdSet?: string[];
  HostReservationId?: string;
  HourlyPrice?: string;
  InstanceFamily?: string;
  OfferingId?: string;
  PaymentOption?: PaymentOption;
  Start?: Date;
  State?: ReservationState;
  UpfrontPrice?: string;
  Tags?: Tag[];
}
export interface DescribeHostReservationsResult {
  HostReservationSet?: HostReservation[];
  NextToken?: string;
}
export interface DescribeHostsRequest {
  Filter?: Filter[];
  HostIds?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface InstanceCapacity {
  AvailableCapacity?: number;
  InstanceType?: string;
  TotalCapacity?: number;
}
export interface AvailableCapacity {
  AvailableInstanceCapacity?: InstanceCapacity[];
  AvailableVCpus?: number;
}
export interface HostProperties {
  Cores?: number;
  InstanceType?: string;
  InstanceFamily?: string;
  Sockets?: number;
  TotalVCpus?: number;
}
export interface HostInstance {
  InstanceId?: string;
  InstanceType?: string;
  OwnerId?: string;
}
export interface Host {
  AutoPlacement?: AutoPlacement;
  AvailabilityZone?: string;
  AvailableCapacity?: AvailableCapacity;
  ClientToken?: string;
  HostId?: string;
  HostProperties?: HostProperties;
  HostReservationId?: string;
  Instances?: HostInstance[];
  State?: AllocationState;
  AllocationTime?: Date;
  ReleaseTime?: Date;
  Tags?: Tag[];
  HostRecovery?: HostRecovery;
  AllowsMultipleInstanceTypes?: AllowsMultipleInstanceTypes;
  OwnerId?: string;
  AvailabilityZoneId?: string;
  MemberOfServiceLinkedResourceGroup?: boolean;
  OutpostArn?: string;
  HostMaintenance?: HostMaintenance;
  AssetId?: string;
}
export interface DescribeHostsResult {
  Hosts?: Host[];
  NextToken?: string;
}
export interface DescribeIamInstanceProfileAssociationsRequest {
  AssociationIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeIamInstanceProfileAssociationsResult {
  IamInstanceProfileAssociations?: IamInstanceProfileAssociation[];
  NextToken?: string;
}
export interface DescribeIdentityIdFormatRequest {
  PrincipalArn: string | undefined;
  Resource?: string;
}
export interface DescribeIdentityIdFormatResult {
  Statuses?: IdFormat[];
}
export interface DescribeIdFormatRequest {
  Resource?: string;
}
export interface DescribeIdFormatResult {
  Statuses?: IdFormat[];
}
export declare const ImageAttributeName: {
  readonly blockDeviceMapping: "blockDeviceMapping";
  readonly bootMode: "bootMode";
  readonly description: "description";
  readonly imdsSupport: "imdsSupport";
  readonly kernel: "kernel";
  readonly lastLaunchedTime: "lastLaunchedTime";
  readonly launchPermission: "launchPermission";
  readonly productCodes: "productCodes";
  readonly ramdisk: "ramdisk";
  readonly sriovNetSupport: "sriovNetSupport";
  readonly tpmSupport: "tpmSupport";
  readonly uefiData: "uefiData";
};
export type ImageAttributeName =
  (typeof ImageAttributeName)[keyof typeof ImageAttributeName];
export interface DescribeImageAttributeRequest {
  Attribute: ImageAttributeName | undefined;
  ImageId: string | undefined;
  DryRun?: boolean;
}
export interface LaunchPermission {
  Group?: PermissionGroup;
  UserId?: string;
  OrganizationArn?: string;
  OrganizationalUnitArn?: string;
}
export interface ImageAttribute {
  BlockDeviceMappings?: BlockDeviceMapping[];
  ImageId?: string;
  LaunchPermissions?: LaunchPermission[];
  ProductCodes?: ProductCode[];
  Description?: AttributeValue;
  KernelId?: AttributeValue;
  RamdiskId?: AttributeValue;
  SriovNetSupport?: AttributeValue;
  BootMode?: AttributeValue;
  TpmSupport?: AttributeValue;
  UefiData?: AttributeValue;
  LastLaunchedTime?: AttributeValue;
  ImdsSupport?: AttributeValue;
}
export interface DescribeImagesRequest {
  ExecutableUsers?: string[];
  Filters?: Filter[];
  ImageIds?: string[];
  Owners?: string[];
  IncludeDeprecated?: boolean;
  IncludeDisabled?: boolean;
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
}
export declare const ArchitectureValues: {
  readonly arm64: "arm64";
  readonly arm64_mac: "arm64_mac";
  readonly i386: "i386";
  readonly x86_64: "x86_64";
  readonly x86_64_mac: "x86_64_mac";
};
export type ArchitectureValues =
  (typeof ArchitectureValues)[keyof typeof ArchitectureValues];
export declare const BootModeValues: {
  readonly legacy_bios: "legacy-bios";
  readonly uefi: "uefi";
  readonly uefi_preferred: "uefi-preferred";
};
export type BootModeValues =
  (typeof BootModeValues)[keyof typeof BootModeValues];
export declare const HypervisorType: {
  readonly ovm: "ovm";
  readonly xen: "xen";
};
export type HypervisorType =
  (typeof HypervisorType)[keyof typeof HypervisorType];
export declare const ImageTypeValues: {
  readonly kernel: "kernel";
  readonly machine: "machine";
  readonly ramdisk: "ramdisk";
};
export type ImageTypeValues =
  (typeof ImageTypeValues)[keyof typeof ImageTypeValues];
export declare const ImdsSupportValues: {
  readonly v2_0: "v2.0";
};
export type ImdsSupportValues =
  (typeof ImdsSupportValues)[keyof typeof ImdsSupportValues];
export declare const DeviceType: {
  readonly ebs: "ebs";
  readonly instance_store: "instance-store";
};
export type DeviceType = (typeof DeviceType)[keyof typeof DeviceType];
export declare const ImageState: {
  readonly available: "available";
  readonly deregistered: "deregistered";
  readonly disabled: "disabled";
  readonly error: "error";
  readonly failed: "failed";
  readonly invalid: "invalid";
  readonly pending: "pending";
  readonly transient: "transient";
};
export type ImageState = (typeof ImageState)[keyof typeof ImageState];
export declare const TpmSupportValues: {
  readonly v2_0: "v2.0";
};
export type TpmSupportValues =
  (typeof TpmSupportValues)[keyof typeof TpmSupportValues];
export declare const VirtualizationType: {
  readonly hvm: "hvm";
  readonly paravirtual: "paravirtual";
};
export type VirtualizationType =
  (typeof VirtualizationType)[keyof typeof VirtualizationType];
export interface Image {
  Architecture?: ArchitectureValues;
  CreationDate?: string;
  ImageId?: string;
  ImageLocation?: string;
  ImageType?: ImageTypeValues;
  Public?: boolean;
  KernelId?: string;
  OwnerId?: string;
  Platform?: PlatformValues;
  PlatformDetails?: string;
  UsageOperation?: string;
  ProductCodes?: ProductCode[];
  RamdiskId?: string;
  State?: ImageState;
  BlockDeviceMappings?: BlockDeviceMapping[];
  Description?: string;
  EnaSupport?: boolean;
  Hypervisor?: HypervisorType;
  ImageOwnerAlias?: string;
  Name?: string;
  RootDeviceName?: string;
  RootDeviceType?: DeviceType;
  SriovNetSupport?: string;
  StateReason?: StateReason;
  Tags?: Tag[];
  VirtualizationType?: VirtualizationType;
  BootMode?: BootModeValues;
  TpmSupport?: TpmSupportValues;
  DeprecationTime?: string;
  ImdsSupport?: ImdsSupportValues;
  SourceInstanceId?: string;
}
export interface DescribeImagesResult {
  Images?: Image[];
  NextToken?: string;
}
export interface DescribeImportImageTasksRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  ImportTaskIds?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface ImportImageLicenseConfigurationResponse {
  LicenseConfigurationArn?: string;
}
export interface UserBucketDetails {
  S3Bucket?: string;
  S3Key?: string;
}
export interface SnapshotDetail {
  Description?: string;
  DeviceName?: string;
  DiskImageSize?: number;
  Format?: string;
  Progress?: string;
  SnapshotId?: string;
  Status?: string;
  StatusMessage?: string;
  Url?: string;
  UserBucket?: UserBucketDetails;
}
export interface ImportImageTask {
  Architecture?: string;
  Description?: string;
  Encrypted?: boolean;
  Hypervisor?: string;
  ImageId?: string;
  ImportTaskId?: string;
  KmsKeyId?: string;
  LicenseType?: string;
  Platform?: string;
  Progress?: string;
  SnapshotDetails?: SnapshotDetail[];
  Status?: string;
  StatusMessage?: string;
  Tags?: Tag[];
  LicenseSpecifications?: ImportImageLicenseConfigurationResponse[];
  UsageOperation?: string;
  BootMode?: BootModeValues;
}
export interface DescribeImportImageTasksResult {
  ImportImageTasks?: ImportImageTask[];
  NextToken?: string;
}
export declare const DeleteVerifiedAccessTrustProviderResultFilterSensitiveLog: (
  obj: DeleteVerifiedAccessTrustProviderResult
) => any;
export declare const DescribeBundleTasksResultFilterSensitiveLog: (
  obj: DescribeBundleTasksResult
) => any;
export declare const DiskImageDescriptionFilterSensitiveLog: (
  obj: DiskImageDescription
) => any;
export declare const ImportInstanceVolumeDetailItemFilterSensitiveLog: (
  obj: ImportInstanceVolumeDetailItem
) => any;
export declare const ImportInstanceTaskDetailsFilterSensitiveLog: (
  obj: ImportInstanceTaskDetails
) => any;
export declare const ImportVolumeTaskDetailsFilterSensitiveLog: (
  obj: ImportVolumeTaskDetails
) => any;
export declare const ConversionTaskFilterSensitiveLog: (
  obj: ConversionTask
) => any;
export declare const DescribeConversionTasksResultFilterSensitiveLog: (
  obj: DescribeConversionTasksResult
) => any;
export declare const SnapshotDetailFilterSensitiveLog: (
  obj: SnapshotDetail
) => any;
export declare const ImportImageTaskFilterSensitiveLog: (
  obj: ImportImageTask
) => any;
export declare const DescribeImportImageTasksResultFilterSensitiveLog: (
  obj: DescribeImportImageTasksResult
) => any;
