import {
  _InstanceType,
  ActiveInstance,
  ActivityStatus,
  AllocationStrategy,
  AlternatePathHint,
  AttachmentStatus,
  BatchState,
  CurrencyCodeValues,
  Explanation,
  IamInstanceProfile,
  IamInstanceProfileSpecification,
  InstanceEventWindow,
  IpamResourceDiscoveryAssociation,
  IpPermission,
  PathComponent,
  ReservedInstancesListing,
  ResourceType,
  SecurityGroupRule,
  Tag,
  TagSpecification,
} from "./models_0";
import {
  AmdSevSnpSpecification,
  AttributeValue,
  BlockDeviceMapping,
  CapacityReservationPreference,
  CapacityReservationTargetResponse,
  ConnectionTrackingSpecificationRequest,
  Ec2InstanceConnectEndpoint,
  EnaSrdSpecificationRequest,
  FleetLaunchTemplateSpecification,
  FleetType,
  GroupIdentifier,
  HostnameType,
  InstanceInterruptionBehavior,
  InstanceIpv6Address,
  InstanceRequirements,
  InternetGateway,
  Ipam,
  IpamPool,
  IpamResourceDiscovery,
  IpamScope,
  Ipv4PrefixSpecificationRequest,
  Ipv6PrefixSpecificationRequest,
  KeyType,
  LaunchTemplate,
  LaunchTemplateVersion,
  LocalGatewayRouteTable,
  LocalGatewayRouteTableVirtualInterfaceGroupAssociation,
  LocalGatewayRouteTableVpcAssociation,
  ManagedPrefixList,
  NatGateway,
  NetworkAcl,
  NetworkInsightsAccessScope,
  NetworkInsightsPath,
  NetworkInterfaceAttachment,
  Placement,
  PlatformValues,
  PrivateIpAddressSpecification,
  SpotInstanceType,
  StateReason,
  TargetCapacityUnitType,
  Tenancy,
} from "./models_1";
import {
  NetworkInterface,
  NetworkInterfacePermission,
  NetworkInterfaceStatus,
  PlacementGroup,
  ReplaceRootVolumeTask,
  RouteTable,
  Snapshot,
  SnapshotState,
  SpotDatafeedSubscription,
  SpotInstanceStateFault,
  StorageTier,
} from "./models_2";
import {
  ArchitectureValues,
  BootModeValues,
  Byoasn,
  DeviceType,
  EventInformation,
  Filter,
  HypervisorType,
  IdFormat,
  InstanceTagNotificationAttribute,
  PermissionGroup,
  ProductCode,
  UserBucketDetails,
  VirtualizationType,
} from "./models_3";
export interface DescribeImportSnapshotTasksRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  ImportTaskIds?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface SnapshotTaskDetail {
  Description?: string;
  DiskImageSize?: number;
  Encrypted?: boolean;
  Format?: string;
  KmsKeyId?: string;
  Progress?: string;
  SnapshotId?: string;
  Status?: string;
  StatusMessage?: string;
  Url?: string;
  UserBucket?: UserBucketDetails;
}
export interface ImportSnapshotTask {
  Description?: string;
  ImportTaskId?: string;
  SnapshotTaskDetail?: SnapshotTaskDetail;
  Tags?: Tag[];
}
export interface DescribeImportSnapshotTasksResult {
  ImportSnapshotTasks?: ImportSnapshotTask[];
  NextToken?: string;
}
export declare const InstanceAttributeName: {
  readonly blockDeviceMapping: "blockDeviceMapping";
  readonly disableApiStop: "disableApiStop";
  readonly disableApiTermination: "disableApiTermination";
  readonly ebsOptimized: "ebsOptimized";
  readonly enaSupport: "enaSupport";
  readonly enclaveOptions: "enclaveOptions";
  readonly groupSet: "groupSet";
  readonly instanceInitiatedShutdownBehavior: "instanceInitiatedShutdownBehavior";
  readonly instanceType: "instanceType";
  readonly kernel: "kernel";
  readonly productCodes: "productCodes";
  readonly ramdisk: "ramdisk";
  readonly rootDeviceName: "rootDeviceName";
  readonly sourceDestCheck: "sourceDestCheck";
  readonly sriovNetSupport: "sriovNetSupport";
  readonly userData: "userData";
};
export type InstanceAttributeName =
  (typeof InstanceAttributeName)[keyof typeof InstanceAttributeName];
export interface DescribeInstanceAttributeRequest {
  Attribute: InstanceAttributeName | undefined;
  DryRun?: boolean;
  InstanceId: string | undefined;
}
export interface EbsInstanceBlockDevice {
  AttachTime?: Date;
  DeleteOnTermination?: boolean;
  Status?: AttachmentStatus;
  VolumeId?: string;
  AssociatedResource?: string;
  VolumeOwnerId?: string;
}
export interface InstanceBlockDeviceMapping {
  DeviceName?: string;
  Ebs?: EbsInstanceBlockDevice;
}
export interface AttributeBooleanValue {
  Value?: boolean;
}
export interface EnclaveOptions {
  Enabled?: boolean;
}
export interface InstanceAttribute {
  Groups?: GroupIdentifier[];
  BlockDeviceMappings?: InstanceBlockDeviceMapping[];
  DisableApiTermination?: AttributeBooleanValue;
  EnaSupport?: AttributeBooleanValue;
  EnclaveOptions?: EnclaveOptions;
  EbsOptimized?: AttributeBooleanValue;
  InstanceId?: string;
  InstanceInitiatedShutdownBehavior?: AttributeValue;
  InstanceType?: AttributeValue;
  KernelId?: AttributeValue;
  ProductCodes?: ProductCode[];
  RamdiskId?: AttributeValue;
  RootDeviceName?: AttributeValue;
  SourceDestCheck?: AttributeBooleanValue;
  SriovNetSupport?: AttributeValue;
  UserData?: AttributeValue;
  DisableApiStop?: AttributeBooleanValue;
}
export interface DescribeInstanceConnectEndpointsRequest {
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  InstanceConnectEndpointIds?: string[];
}
export interface DescribeInstanceConnectEndpointsResult {
  InstanceConnectEndpoints?: Ec2InstanceConnectEndpoint[];
  NextToken?: string;
}
export interface DescribeInstanceCreditSpecificationsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  InstanceIds?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface InstanceCreditSpecification {
  InstanceId?: string;
  CpuCredits?: string;
}
export interface DescribeInstanceCreditSpecificationsResult {
  InstanceCreditSpecifications?: InstanceCreditSpecification[];
  NextToken?: string;
}
export interface DescribeInstanceEventNotificationAttributesRequest {
  DryRun?: boolean;
}
export interface DescribeInstanceEventNotificationAttributesResult {
  InstanceTagAttribute?: InstanceTagNotificationAttribute;
}
export interface DescribeInstanceEventWindowsRequest {
  DryRun?: boolean;
  InstanceEventWindowIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeInstanceEventWindowsResult {
  InstanceEventWindows?: InstanceEventWindow[];
  NextToken?: string;
}
export interface DescribeInstancesRequest {
  Filters?: Filter[];
  InstanceIds?: string[];
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
}
export interface CapacityReservationSpecificationResponse {
  CapacityReservationPreference?: CapacityReservationPreference;
  CapacityReservationTarget?: CapacityReservationTargetResponse;
}
export interface CpuOptions {
  CoreCount?: number;
  ThreadsPerCore?: number;
  AmdSevSnp?: AmdSevSnpSpecification;
}
export declare const InstanceBootModeValues: {
  readonly legacy_bios: "legacy-bios";
  readonly uefi: "uefi";
};
export type InstanceBootModeValues =
  (typeof InstanceBootModeValues)[keyof typeof InstanceBootModeValues];
export interface ElasticGpuAssociation {
  ElasticGpuId?: string;
  ElasticGpuAssociationId?: string;
  ElasticGpuAssociationState?: string;
  ElasticGpuAssociationTime?: string;
}
export interface ElasticInferenceAcceleratorAssociation {
  ElasticInferenceAcceleratorArn?: string;
  ElasticInferenceAcceleratorAssociationId?: string;
  ElasticInferenceAcceleratorAssociationState?: string;
  ElasticInferenceAcceleratorAssociationTime?: Date;
}
export interface HibernationOptions {
  Configured?: boolean;
}
export declare const InstanceLifecycleType: {
  readonly capacity_block: "capacity-block";
  readonly scheduled: "scheduled";
  readonly spot: "spot";
};
export type InstanceLifecycleType =
  (typeof InstanceLifecycleType)[keyof typeof InstanceLifecycleType];
export interface LicenseConfiguration {
  LicenseConfigurationArn?: string;
}
export declare const InstanceAutoRecoveryState: {
  readonly default: "default";
  readonly disabled: "disabled";
};
export type InstanceAutoRecoveryState =
  (typeof InstanceAutoRecoveryState)[keyof typeof InstanceAutoRecoveryState];
export interface InstanceMaintenanceOptions {
  AutoRecovery?: InstanceAutoRecoveryState;
}
export declare const InstanceMetadataEndpointState: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type InstanceMetadataEndpointState =
  (typeof InstanceMetadataEndpointState)[keyof typeof InstanceMetadataEndpointState];
export declare const InstanceMetadataProtocolState: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type InstanceMetadataProtocolState =
  (typeof InstanceMetadataProtocolState)[keyof typeof InstanceMetadataProtocolState];
export declare const HttpTokensState: {
  readonly optional: "optional";
  readonly required: "required";
};
export type HttpTokensState =
  (typeof HttpTokensState)[keyof typeof HttpTokensState];
export declare const InstanceMetadataTagsState: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type InstanceMetadataTagsState =
  (typeof InstanceMetadataTagsState)[keyof typeof InstanceMetadataTagsState];
export declare const InstanceMetadataOptionsState: {
  readonly applied: "applied";
  readonly pending: "pending";
};
export type InstanceMetadataOptionsState =
  (typeof InstanceMetadataOptionsState)[keyof typeof InstanceMetadataOptionsState];
export interface InstanceMetadataOptionsResponse {
  State?: InstanceMetadataOptionsState;
  HttpTokens?: HttpTokensState;
  HttpPutResponseHopLimit?: number;
  HttpEndpoint?: InstanceMetadataEndpointState;
  HttpProtocolIpv6?: InstanceMetadataProtocolState;
  InstanceMetadataTags?: InstanceMetadataTagsState;
}
export declare const MonitoringState: {
  readonly disabled: "disabled";
  readonly disabling: "disabling";
  readonly enabled: "enabled";
  readonly pending: "pending";
};
export type MonitoringState =
  (typeof MonitoringState)[keyof typeof MonitoringState];
export interface Monitoring {
  State?: MonitoringState;
}
export interface InstanceNetworkInterfaceAssociation {
  CarrierIp?: string;
  CustomerOwnedIp?: string;
  IpOwnerId?: string;
  PublicDnsName?: string;
  PublicIp?: string;
}
export interface InstanceAttachmentEnaSrdUdpSpecification {
  EnaSrdUdpEnabled?: boolean;
}
export interface InstanceAttachmentEnaSrdSpecification {
  EnaSrdEnabled?: boolean;
  EnaSrdUdpSpecification?: InstanceAttachmentEnaSrdUdpSpecification;
}
export interface InstanceNetworkInterfaceAttachment {
  AttachTime?: Date;
  AttachmentId?: string;
  DeleteOnTermination?: boolean;
  DeviceIndex?: number;
  Status?: AttachmentStatus;
  NetworkCardIndex?: number;
  EnaSrdSpecification?: InstanceAttachmentEnaSrdSpecification;
}
export interface ConnectionTrackingSpecificationResponse {
  TcpEstablishedTimeout?: number;
  UdpStreamTimeout?: number;
  UdpTimeout?: number;
}
export interface InstanceIpv4Prefix {
  Ipv4Prefix?: string;
}
export interface InstanceIpv6Prefix {
  Ipv6Prefix?: string;
}
export interface InstancePrivateIpAddress {
  Association?: InstanceNetworkInterfaceAssociation;
  Primary?: boolean;
  PrivateDnsName?: string;
  PrivateIpAddress?: string;
}
export interface InstanceNetworkInterface {
  Association?: InstanceNetworkInterfaceAssociation;
  Attachment?: InstanceNetworkInterfaceAttachment;
  Description?: string;
  Groups?: GroupIdentifier[];
  Ipv6Addresses?: InstanceIpv6Address[];
  MacAddress?: string;
  NetworkInterfaceId?: string;
  OwnerId?: string;
  PrivateDnsName?: string;
  PrivateIpAddress?: string;
  PrivateIpAddresses?: InstancePrivateIpAddress[];
  SourceDestCheck?: boolean;
  Status?: NetworkInterfaceStatus;
  SubnetId?: string;
  VpcId?: string;
  InterfaceType?: string;
  Ipv4Prefixes?: InstanceIpv4Prefix[];
  Ipv6Prefixes?: InstanceIpv6Prefix[];
  ConnectionTrackingConfiguration?: ConnectionTrackingSpecificationResponse;
}
export interface PrivateDnsNameOptionsResponse {
  HostnameType?: HostnameType;
  EnableResourceNameDnsARecord?: boolean;
  EnableResourceNameDnsAAAARecord?: boolean;
}
export declare const InstanceStateName: {
  readonly pending: "pending";
  readonly running: "running";
  readonly shutting_down: "shutting-down";
  readonly stopped: "stopped";
  readonly stopping: "stopping";
  readonly terminated: "terminated";
};
export type InstanceStateName =
  (typeof InstanceStateName)[keyof typeof InstanceStateName];
export interface InstanceState {
  Code?: number;
  Name?: InstanceStateName;
}
export interface Instance {
  AmiLaunchIndex?: number;
  ImageId?: string;
  InstanceId?: string;
  InstanceType?: _InstanceType;
  KernelId?: string;
  KeyName?: string;
  LaunchTime?: Date;
  Monitoring?: Monitoring;
  Placement?: Placement;
  Platform?: PlatformValues;
  PrivateDnsName?: string;
  PrivateIpAddress?: string;
  ProductCodes?: ProductCode[];
  PublicDnsName?: string;
  PublicIpAddress?: string;
  RamdiskId?: string;
  State?: InstanceState;
  StateTransitionReason?: string;
  SubnetId?: string;
  VpcId?: string;
  Architecture?: ArchitectureValues;
  BlockDeviceMappings?: InstanceBlockDeviceMapping[];
  ClientToken?: string;
  EbsOptimized?: boolean;
  EnaSupport?: boolean;
  Hypervisor?: HypervisorType;
  IamInstanceProfile?: IamInstanceProfile;
  InstanceLifecycle?: InstanceLifecycleType;
  ElasticGpuAssociations?: ElasticGpuAssociation[];
  ElasticInferenceAcceleratorAssociations?: ElasticInferenceAcceleratorAssociation[];
  NetworkInterfaces?: InstanceNetworkInterface[];
  OutpostArn?: string;
  RootDeviceName?: string;
  RootDeviceType?: DeviceType;
  SecurityGroups?: GroupIdentifier[];
  SourceDestCheck?: boolean;
  SpotInstanceRequestId?: string;
  SriovNetSupport?: string;
  StateReason?: StateReason;
  Tags?: Tag[];
  VirtualizationType?: VirtualizationType;
  CpuOptions?: CpuOptions;
  CapacityReservationId?: string;
  CapacityReservationSpecification?: CapacityReservationSpecificationResponse;
  HibernationOptions?: HibernationOptions;
  Licenses?: LicenseConfiguration[];
  MetadataOptions?: InstanceMetadataOptionsResponse;
  EnclaveOptions?: EnclaveOptions;
  BootMode?: BootModeValues;
  PlatformDetails?: string;
  UsageOperation?: string;
  UsageOperationUpdateTime?: Date;
  PrivateDnsNameOptions?: PrivateDnsNameOptionsResponse;
  Ipv6Address?: string;
  TpmSupport?: string;
  MaintenanceOptions?: InstanceMaintenanceOptions;
  CurrentInstanceBootMode?: InstanceBootModeValues;
}
export interface Reservation {
  Groups?: GroupIdentifier[];
  Instances?: Instance[];
  OwnerId?: string;
  RequesterId?: string;
  ReservationId?: string;
}
export interface DescribeInstancesResult {
  Reservations?: Reservation[];
  NextToken?: string;
}
export interface DescribeInstanceStatusRequest {
  Filters?: Filter[];
  InstanceIds?: string[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
  IncludeAllInstances?: boolean;
}
export declare const EventCode: {
  readonly instance_reboot: "instance-reboot";
  readonly instance_retirement: "instance-retirement";
  readonly instance_stop: "instance-stop";
  readonly system_maintenance: "system-maintenance";
  readonly system_reboot: "system-reboot";
};
export type EventCode = (typeof EventCode)[keyof typeof EventCode];
export interface InstanceStatusEvent {
  InstanceEventId?: string;
  Code?: EventCode;
  Description?: string;
  NotAfter?: Date;
  NotBefore?: Date;
  NotBeforeDeadline?: Date;
}
export declare const StatusName: {
  readonly reachability: "reachability";
};
export type StatusName = (typeof StatusName)[keyof typeof StatusName];
export declare const StatusType: {
  readonly failed: "failed";
  readonly initializing: "initializing";
  readonly insufficient_data: "insufficient-data";
  readonly passed: "passed";
};
export type StatusType = (typeof StatusType)[keyof typeof StatusType];
export interface InstanceStatusDetails {
  ImpairedSince?: Date;
  Name?: StatusName;
  Status?: StatusType;
}
export declare const SummaryStatus: {
  readonly impaired: "impaired";
  readonly initializing: "initializing";
  readonly insufficient_data: "insufficient-data";
  readonly not_applicable: "not-applicable";
  readonly ok: "ok";
};
export type SummaryStatus = (typeof SummaryStatus)[keyof typeof SummaryStatus];
export interface InstanceStatusSummary {
  Details?: InstanceStatusDetails[];
  Status?: SummaryStatus;
}
export interface InstanceStatus {
  AvailabilityZone?: string;
  OutpostArn?: string;
  Events?: InstanceStatusEvent[];
  InstanceId?: string;
  InstanceState?: InstanceState;
  InstanceStatus?: InstanceStatusSummary;
  SystemStatus?: InstanceStatusSummary;
}
export interface DescribeInstanceStatusResult {
  InstanceStatuses?: InstanceStatus[];
  NextToken?: string;
}
export interface DescribeInstanceTopologyRequest {
  DryRun?: boolean;
  NextToken?: string;
  MaxResults?: number;
  InstanceIds?: string[];
  GroupNames?: string[];
  Filters?: Filter[];
}
export interface InstanceTopology {
  InstanceId?: string;
  InstanceType?: string;
  GroupName?: string;
  NetworkNodes?: string[];
  AvailabilityZone?: string;
  ZoneId?: string;
}
export interface DescribeInstanceTopologyResult {
  Instances?: InstanceTopology[];
  NextToken?: string;
}
export declare const LocationType: {
  readonly availability_zone: "availability-zone";
  readonly availability_zone_id: "availability-zone-id";
  readonly outpost: "outpost";
  readonly region: "region";
};
export type LocationType = (typeof LocationType)[keyof typeof LocationType];
export interface DescribeInstanceTypeOfferingsRequest {
  DryRun?: boolean;
  LocationType?: LocationType;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface InstanceTypeOffering {
  InstanceType?: _InstanceType;
  LocationType?: LocationType;
  Location?: string;
}
export interface DescribeInstanceTypeOfferingsResult {
  InstanceTypeOfferings?: InstanceTypeOffering[];
  NextToken?: string;
}
export interface DescribeInstanceTypesRequest {
  DryRun?: boolean;
  InstanceTypes?: _InstanceType[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface EbsOptimizedInfo {
  BaselineBandwidthInMbps?: number;
  BaselineThroughputInMBps?: number;
  BaselineIops?: number;
  MaximumBandwidthInMbps?: number;
  MaximumThroughputInMBps?: number;
  MaximumIops?: number;
}
export declare const EbsOptimizedSupport: {
  readonly default: "default";
  readonly supported: "supported";
  readonly unsupported: "unsupported";
};
export type EbsOptimizedSupport =
  (typeof EbsOptimizedSupport)[keyof typeof EbsOptimizedSupport];
export declare const EbsEncryptionSupport: {
  readonly supported: "supported";
  readonly unsupported: "unsupported";
};
export type EbsEncryptionSupport =
  (typeof EbsEncryptionSupport)[keyof typeof EbsEncryptionSupport];
export declare const EbsNvmeSupport: {
  readonly REQUIRED: "required";
  readonly SUPPORTED: "supported";
  readonly UNSUPPORTED: "unsupported";
};
export type EbsNvmeSupport =
  (typeof EbsNvmeSupport)[keyof typeof EbsNvmeSupport];
export interface EbsInfo {
  EbsOptimizedSupport?: EbsOptimizedSupport;
  EncryptionSupport?: EbsEncryptionSupport;
  EbsOptimizedInfo?: EbsOptimizedInfo;
  NvmeSupport?: EbsNvmeSupport;
}
export interface FpgaDeviceMemoryInfo {
  SizeInMiB?: number;
}
export interface FpgaDeviceInfo {
  Name?: string;
  Manufacturer?: string;
  Count?: number;
  MemoryInfo?: FpgaDeviceMemoryInfo;
}
export interface FpgaInfo {
  Fpgas?: FpgaDeviceInfo[];
  TotalFpgaMemoryInMiB?: number;
}
export interface GpuDeviceMemoryInfo {
  SizeInMiB?: number;
}
export interface GpuDeviceInfo {
  Name?: string;
  Manufacturer?: string;
  Count?: number;
  MemoryInfo?: GpuDeviceMemoryInfo;
}
export interface GpuInfo {
  Gpus?: GpuDeviceInfo[];
  TotalGpuMemoryInMiB?: number;
}
export declare const InstanceTypeHypervisor: {
  readonly NITRO: "nitro";
  readonly XEN: "xen";
};
export type InstanceTypeHypervisor =
  (typeof InstanceTypeHypervisor)[keyof typeof InstanceTypeHypervisor];
export interface InferenceDeviceMemoryInfo {
  SizeInMiB?: number;
}
export interface InferenceDeviceInfo {
  Count?: number;
  Name?: string;
  Manufacturer?: string;
  MemoryInfo?: InferenceDeviceMemoryInfo;
}
export interface InferenceAcceleratorInfo {
  Accelerators?: InferenceDeviceInfo[];
  TotalInferenceMemoryInMiB?: number;
}
export declare const DiskType: {
  readonly hdd: "hdd";
  readonly ssd: "ssd";
};
export type DiskType = (typeof DiskType)[keyof typeof DiskType];
export interface DiskInfo {
  SizeInGB?: number;
  Count?: number;
  Type?: DiskType;
}
export declare const InstanceStorageEncryptionSupport: {
  readonly required: "required";
  readonly unsupported: "unsupported";
};
export type InstanceStorageEncryptionSupport =
  (typeof InstanceStorageEncryptionSupport)[keyof typeof InstanceStorageEncryptionSupport];
export declare const EphemeralNvmeSupport: {
  readonly REQUIRED: "required";
  readonly SUPPORTED: "supported";
  readonly UNSUPPORTED: "unsupported";
};
export type EphemeralNvmeSupport =
  (typeof EphemeralNvmeSupport)[keyof typeof EphemeralNvmeSupport];
export interface InstanceStorageInfo {
  TotalSizeInGB?: number;
  Disks?: DiskInfo[];
  NvmeSupport?: EphemeralNvmeSupport;
  EncryptionSupport?: InstanceStorageEncryptionSupport;
}
export interface MediaDeviceMemoryInfo {
  SizeInMiB?: number;
}
export interface MediaDeviceInfo {
  Count?: number;
  Name?: string;
  Manufacturer?: string;
  MemoryInfo?: MediaDeviceMemoryInfo;
}
export interface MediaAcceleratorInfo {
  Accelerators?: MediaDeviceInfo[];
  TotalMediaMemoryInMiB?: number;
}
export interface MemoryInfo {
  SizeInMiB?: number;
}
export interface EfaInfo {
  MaximumEfaInterfaces?: number;
}
export declare const EnaSupport: {
  readonly required: "required";
  readonly supported: "supported";
  readonly unsupported: "unsupported";
};
export type EnaSupport = (typeof EnaSupport)[keyof typeof EnaSupport];
export interface NetworkCardInfo {
  NetworkCardIndex?: number;
  NetworkPerformance?: string;
  MaximumNetworkInterfaces?: number;
  BaselineBandwidthInGbps?: number;
  PeakBandwidthInGbps?: number;
}
export interface NetworkInfo {
  NetworkPerformance?: string;
  MaximumNetworkInterfaces?: number;
  MaximumNetworkCards?: number;
  DefaultNetworkCardIndex?: number;
  NetworkCards?: NetworkCardInfo[];
  Ipv4AddressesPerInterface?: number;
  Ipv6AddressesPerInterface?: number;
  Ipv6Supported?: boolean;
  EnaSupport?: EnaSupport;
  EfaSupported?: boolean;
  EfaInfo?: EfaInfo;
  EncryptionInTransitSupported?: boolean;
  EnaSrdSupported?: boolean;
}
export interface NeuronDeviceCoreInfo {
  Count?: number;
  Version?: number;
}
export interface NeuronDeviceMemoryInfo {
  SizeInMiB?: number;
}
export interface NeuronDeviceInfo {
  Count?: number;
  Name?: string;
  CoreInfo?: NeuronDeviceCoreInfo;
  MemoryInfo?: NeuronDeviceMemoryInfo;
}
export interface NeuronInfo {
  NeuronDevices?: NeuronDeviceInfo[];
  TotalNeuronDeviceMemoryInMiB?: number;
}
export declare const NitroEnclavesSupport: {
  readonly SUPPORTED: "supported";
  readonly UNSUPPORTED: "unsupported";
};
export type NitroEnclavesSupport =
  (typeof NitroEnclavesSupport)[keyof typeof NitroEnclavesSupport];
export interface NitroTpmInfo {
  SupportedVersions?: string[];
}
export declare const NitroTpmSupport: {
  readonly SUPPORTED: "supported";
  readonly UNSUPPORTED: "unsupported";
};
export type NitroTpmSupport =
  (typeof NitroTpmSupport)[keyof typeof NitroTpmSupport];
export declare const PlacementGroupStrategy: {
  readonly cluster: "cluster";
  readonly partition: "partition";
  readonly spread: "spread";
};
export type PlacementGroupStrategy =
  (typeof PlacementGroupStrategy)[keyof typeof PlacementGroupStrategy];
export interface PlacementGroupInfo {
  SupportedStrategies?: PlacementGroupStrategy[];
}
export declare const ArchitectureType: {
  readonly arm64: "arm64";
  readonly arm64_mac: "arm64_mac";
  readonly i386: "i386";
  readonly x86_64: "x86_64";
  readonly x86_64_mac: "x86_64_mac";
};
export type ArchitectureType =
  (typeof ArchitectureType)[keyof typeof ArchitectureType];
export declare const SupportedAdditionalProcessorFeature: {
  readonly AMD_SEV_SNP: "amd-sev-snp";
};
export type SupportedAdditionalProcessorFeature =
  (typeof SupportedAdditionalProcessorFeature)[keyof typeof SupportedAdditionalProcessorFeature];
export interface ProcessorInfo {
  SupportedArchitectures?: ArchitectureType[];
  SustainedClockSpeedInGhz?: number;
  SupportedFeatures?: SupportedAdditionalProcessorFeature[];
  Manufacturer?: string;
}
export declare const BootModeType: {
  readonly legacy_bios: "legacy-bios";
  readonly uefi: "uefi";
};
export type BootModeType = (typeof BootModeType)[keyof typeof BootModeType];
export declare const RootDeviceType: {
  readonly ebs: "ebs";
  readonly instance_store: "instance-store";
};
export type RootDeviceType =
  (typeof RootDeviceType)[keyof typeof RootDeviceType];
export declare const UsageClassType: {
  readonly capacity_block: "capacity-block";
  readonly on_demand: "on-demand";
  readonly spot: "spot";
};
export type UsageClassType =
  (typeof UsageClassType)[keyof typeof UsageClassType];
export interface VCpuInfo {
  DefaultVCpus?: number;
  DefaultCores?: number;
  DefaultThreadsPerCore?: number;
  ValidCores?: number[];
  ValidThreadsPerCore?: number[];
}
export interface InstanceTypeInfo {
  InstanceType?: _InstanceType;
  CurrentGeneration?: boolean;
  FreeTierEligible?: boolean;
  SupportedUsageClasses?: UsageClassType[];
  SupportedRootDeviceTypes?: RootDeviceType[];
  SupportedVirtualizationTypes?: VirtualizationType[];
  BareMetal?: boolean;
  Hypervisor?: InstanceTypeHypervisor;
  ProcessorInfo?: ProcessorInfo;
  VCpuInfo?: VCpuInfo;
  MemoryInfo?: MemoryInfo;
  InstanceStorageSupported?: boolean;
  InstanceStorageInfo?: InstanceStorageInfo;
  EbsInfo?: EbsInfo;
  NetworkInfo?: NetworkInfo;
  GpuInfo?: GpuInfo;
  FpgaInfo?: FpgaInfo;
  PlacementGroupInfo?: PlacementGroupInfo;
  InferenceAcceleratorInfo?: InferenceAcceleratorInfo;
  HibernationSupported?: boolean;
  BurstablePerformanceSupported?: boolean;
  DedicatedHostsSupported?: boolean;
  AutoRecoverySupported?: boolean;
  SupportedBootModes?: BootModeType[];
  NitroEnclavesSupport?: NitroEnclavesSupport;
  NitroTpmSupport?: NitroTpmSupport;
  NitroTpmInfo?: NitroTpmInfo;
  MediaAcceleratorInfo?: MediaAcceleratorInfo;
  NeuronInfo?: NeuronInfo;
}
export interface DescribeInstanceTypesResult {
  InstanceTypes?: InstanceTypeInfo[];
  NextToken?: string;
}
export interface DescribeInternetGatewaysRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  InternetGatewayIds?: string[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeInternetGatewaysResult {
  InternetGateways?: InternetGateway[];
  NextToken?: string;
}
export interface DescribeIpamByoasnRequest {
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeIpamByoasnResult {
  Byoasns?: Byoasn[];
  NextToken?: string;
}
export interface DescribeIpamPoolsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  IpamPoolIds?: string[];
}
export interface DescribeIpamPoolsResult {
  NextToken?: string;
  IpamPools?: IpamPool[];
}
export interface DescribeIpamResourceDiscoveriesRequest {
  DryRun?: boolean;
  IpamResourceDiscoveryIds?: string[];
  NextToken?: string;
  MaxResults?: number;
  Filters?: Filter[];
}
export interface DescribeIpamResourceDiscoveriesResult {
  IpamResourceDiscoveries?: IpamResourceDiscovery[];
  NextToken?: string;
}
export interface DescribeIpamResourceDiscoveryAssociationsRequest {
  DryRun?: boolean;
  IpamResourceDiscoveryAssociationIds?: string[];
  NextToken?: string;
  MaxResults?: number;
  Filters?: Filter[];
}
export interface DescribeIpamResourceDiscoveryAssociationsResult {
  IpamResourceDiscoveryAssociations?: IpamResourceDiscoveryAssociation[];
  NextToken?: string;
}
export interface DescribeIpamsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  IpamIds?: string[];
}
export interface DescribeIpamsResult {
  NextToken?: string;
  Ipams?: Ipam[];
}
export interface DescribeIpamScopesRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  IpamScopeIds?: string[];
}
export interface DescribeIpamScopesResult {
  NextToken?: string;
  IpamScopes?: IpamScope[];
}
export interface DescribeIpv6PoolsRequest {
  PoolIds?: string[];
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
  Filters?: Filter[];
}
export interface PoolCidrBlock {
  Cidr?: string;
}
export interface Ipv6Pool {
  PoolId?: string;
  Description?: string;
  PoolCidrBlocks?: PoolCidrBlock[];
  Tags?: Tag[];
}
export interface DescribeIpv6PoolsResult {
  Ipv6Pools?: Ipv6Pool[];
  NextToken?: string;
}
export interface DescribeKeyPairsRequest {
  Filters?: Filter[];
  KeyNames?: string[];
  KeyPairIds?: string[];
  DryRun?: boolean;
  IncludePublicKey?: boolean;
}
export interface KeyPairInfo {
  KeyPairId?: string;
  KeyFingerprint?: string;
  KeyName?: string;
  KeyType?: KeyType;
  Tags?: Tag[];
  PublicKey?: string;
  CreateTime?: Date;
}
export interface DescribeKeyPairsResult {
  KeyPairs?: KeyPairInfo[];
}
export interface DescribeLaunchTemplatesRequest {
  DryRun?: boolean;
  LaunchTemplateIds?: string[];
  LaunchTemplateNames?: string[];
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeLaunchTemplatesResult {
  LaunchTemplates?: LaunchTemplate[];
  NextToken?: string;
}
export interface DescribeLaunchTemplateVersionsRequest {
  DryRun?: boolean;
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  Versions?: string[];
  MinVersion?: string;
  MaxVersion?: string;
  NextToken?: string;
  MaxResults?: number;
  Filters?: Filter[];
  ResolveAlias?: boolean;
}
export interface DescribeLaunchTemplateVersionsResult {
  LaunchTemplateVersions?: LaunchTemplateVersion[];
  NextToken?: string;
}
export interface DescribeLocalGatewayRouteTablesRequest {
  LocalGatewayRouteTableIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeLocalGatewayRouteTablesResult {
  LocalGatewayRouteTables?: LocalGatewayRouteTable[];
  NextToken?: string;
}
export interface DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociations?: LocalGatewayRouteTableVirtualInterfaceGroupAssociation[];
  NextToken?: string;
}
export interface DescribeLocalGatewayRouteTableVpcAssociationsRequest {
  LocalGatewayRouteTableVpcAssociationIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeLocalGatewayRouteTableVpcAssociationsResult {
  LocalGatewayRouteTableVpcAssociations?: LocalGatewayRouteTableVpcAssociation[];
  NextToken?: string;
}
export interface DescribeLocalGatewaysRequest {
  LocalGatewayIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface LocalGateway {
  LocalGatewayId?: string;
  OutpostArn?: string;
  OwnerId?: string;
  State?: string;
  Tags?: Tag[];
}
export interface DescribeLocalGatewaysResult {
  LocalGateways?: LocalGateway[];
  NextToken?: string;
}
export interface DescribeLocalGatewayVirtualInterfaceGroupsRequest {
  LocalGatewayVirtualInterfaceGroupIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface LocalGatewayVirtualInterfaceGroup {
  LocalGatewayVirtualInterfaceGroupId?: string;
  LocalGatewayVirtualInterfaceIds?: string[];
  LocalGatewayId?: string;
  OwnerId?: string;
  Tags?: Tag[];
}
export interface DescribeLocalGatewayVirtualInterfaceGroupsResult {
  LocalGatewayVirtualInterfaceGroups?: LocalGatewayVirtualInterfaceGroup[];
  NextToken?: string;
}
export interface DescribeLocalGatewayVirtualInterfacesRequest {
  LocalGatewayVirtualInterfaceIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface LocalGatewayVirtualInterface {
  LocalGatewayVirtualInterfaceId?: string;
  LocalGatewayId?: string;
  Vlan?: number;
  LocalAddress?: string;
  PeerAddress?: string;
  LocalBgpAsn?: number;
  PeerBgpAsn?: number;
  OwnerId?: string;
  Tags?: Tag[];
}
export interface DescribeLocalGatewayVirtualInterfacesResult {
  LocalGatewayVirtualInterfaces?: LocalGatewayVirtualInterface[];
  NextToken?: string;
}
export interface DescribeLockedSnapshotsRequest {
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  SnapshotIds?: string[];
  DryRun?: boolean;
}
export declare const LockState: {
  readonly compliance: "compliance";
  readonly compliance_cooloff: "compliance-cooloff";
  readonly expired: "expired";
  readonly governance: "governance";
};
export type LockState = (typeof LockState)[keyof typeof LockState];
export interface LockedSnapshotsInfo {
  OwnerId?: string;
  SnapshotId?: string;
  LockState?: LockState;
  LockDuration?: number;
  CoolOffPeriod?: number;
  CoolOffPeriodExpiresOn?: Date;
  LockCreatedOn?: Date;
  LockDurationStartTime?: Date;
  LockExpiresOn?: Date;
}
export interface DescribeLockedSnapshotsResult {
  Snapshots?: LockedSnapshotsInfo[];
  NextToken?: string;
}
export interface DescribeManagedPrefixListsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  PrefixListIds?: string[];
}
export interface DescribeManagedPrefixListsResult {
  NextToken?: string;
  PrefixLists?: ManagedPrefixList[];
}
export interface DescribeMovingAddressesRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
  PublicIps?: string[];
}
export declare const MoveStatus: {
  readonly movingToVpc: "movingToVpc";
  readonly restoringToClassic: "restoringToClassic";
};
export type MoveStatus = (typeof MoveStatus)[keyof typeof MoveStatus];
export interface MovingAddressStatus {
  MoveStatus?: MoveStatus;
  PublicIp?: string;
}
export interface DescribeMovingAddressesResult {
  MovingAddressStatuses?: MovingAddressStatus[];
  NextToken?: string;
}
export interface DescribeNatGatewaysRequest {
  DryRun?: boolean;
  Filter?: Filter[];
  MaxResults?: number;
  NatGatewayIds?: string[];
  NextToken?: string;
}
export interface DescribeNatGatewaysResult {
  NatGateways?: NatGateway[];
  NextToken?: string;
}
export interface DescribeNetworkAclsRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  NetworkAclIds?: string[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeNetworkAclsResult {
  NetworkAcls?: NetworkAcl[];
  NextToken?: string;
}
export interface DescribeNetworkInsightsAccessScopeAnalysesRequest {
  NetworkInsightsAccessScopeAnalysisIds?: string[];
  NetworkInsightsAccessScopeId?: string;
  AnalysisStartTimeBegin?: Date;
  AnalysisStartTimeEnd?: Date;
  Filters?: Filter[];
  MaxResults?: number;
  DryRun?: boolean;
  NextToken?: string;
}
export declare const FindingsFound: {
  readonly false: "false";
  readonly true: "true";
  readonly unknown: "unknown";
};
export type FindingsFound = (typeof FindingsFound)[keyof typeof FindingsFound];
export declare const AnalysisStatus: {
  readonly failed: "failed";
  readonly running: "running";
  readonly succeeded: "succeeded";
};
export type AnalysisStatus =
  (typeof AnalysisStatus)[keyof typeof AnalysisStatus];
export interface NetworkInsightsAccessScopeAnalysis {
  NetworkInsightsAccessScopeAnalysisId?: string;
  NetworkInsightsAccessScopeAnalysisArn?: string;
  NetworkInsightsAccessScopeId?: string;
  Status?: AnalysisStatus;
  StatusMessage?: string;
  WarningMessage?: string;
  StartDate?: Date;
  EndDate?: Date;
  FindingsFound?: FindingsFound;
  AnalyzedEniCount?: number;
  Tags?: Tag[];
}
export interface DescribeNetworkInsightsAccessScopeAnalysesResult {
  NetworkInsightsAccessScopeAnalyses?: NetworkInsightsAccessScopeAnalysis[];
  NextToken?: string;
}
export interface DescribeNetworkInsightsAccessScopesRequest {
  NetworkInsightsAccessScopeIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  DryRun?: boolean;
  NextToken?: string;
}
export interface DescribeNetworkInsightsAccessScopesResult {
  NetworkInsightsAccessScopes?: NetworkInsightsAccessScope[];
  NextToken?: string;
}
export interface DescribeNetworkInsightsAnalysesRequest {
  NetworkInsightsAnalysisIds?: string[];
  NetworkInsightsPathId?: string;
  AnalysisStartTime?: Date;
  AnalysisEndTime?: Date;
  Filters?: Filter[];
  MaxResults?: number;
  DryRun?: boolean;
  NextToken?: string;
}
export interface NetworkInsightsAnalysis {
  NetworkInsightsAnalysisId?: string;
  NetworkInsightsAnalysisArn?: string;
  NetworkInsightsPathId?: string;
  AdditionalAccounts?: string[];
  FilterInArns?: string[];
  StartDate?: Date;
  Status?: AnalysisStatus;
  StatusMessage?: string;
  WarningMessage?: string;
  NetworkPathFound?: boolean;
  ForwardPathComponents?: PathComponent[];
  ReturnPathComponents?: PathComponent[];
  Explanations?: Explanation[];
  AlternatePathHints?: AlternatePathHint[];
  SuggestedAccounts?: string[];
  Tags?: Tag[];
}
export interface DescribeNetworkInsightsAnalysesResult {
  NetworkInsightsAnalyses?: NetworkInsightsAnalysis[];
  NextToken?: string;
}
export interface DescribeNetworkInsightsPathsRequest {
  NetworkInsightsPathIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  DryRun?: boolean;
  NextToken?: string;
}
export interface DescribeNetworkInsightsPathsResult {
  NetworkInsightsPaths?: NetworkInsightsPath[];
  NextToken?: string;
}
export declare const NetworkInterfaceAttribute: {
  readonly attachment: "attachment";
  readonly description: "description";
  readonly groupSet: "groupSet";
  readonly sourceDestCheck: "sourceDestCheck";
};
export type NetworkInterfaceAttribute =
  (typeof NetworkInterfaceAttribute)[keyof typeof NetworkInterfaceAttribute];
export interface DescribeNetworkInterfaceAttributeRequest {
  Attribute?: NetworkInterfaceAttribute;
  DryRun?: boolean;
  NetworkInterfaceId: string | undefined;
}
export interface DescribeNetworkInterfaceAttributeResult {
  Attachment?: NetworkInterfaceAttachment;
  Description?: AttributeValue;
  Groups?: GroupIdentifier[];
  NetworkInterfaceId?: string;
  SourceDestCheck?: AttributeBooleanValue;
}
export interface DescribeNetworkInterfacePermissionsRequest {
  NetworkInterfacePermissionIds?: string[];
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeNetworkInterfacePermissionsResult {
  NetworkInterfacePermissions?: NetworkInterfacePermission[];
  NextToken?: string;
}
export interface DescribeNetworkInterfacesRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  NetworkInterfaceIds?: string[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeNetworkInterfacesResult {
  NetworkInterfaces?: NetworkInterface[];
  NextToken?: string;
}
export interface DescribePlacementGroupsRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  GroupNames?: string[];
  GroupIds?: string[];
}
export interface DescribePlacementGroupsResult {
  PlacementGroups?: PlacementGroup[];
}
export interface DescribePrefixListsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  PrefixListIds?: string[];
}
export interface PrefixList {
  Cidrs?: string[];
  PrefixListId?: string;
  PrefixListName?: string;
}
export interface DescribePrefixListsResult {
  NextToken?: string;
  PrefixLists?: PrefixList[];
}
export interface DescribePrincipalIdFormatRequest {
  DryRun?: boolean;
  Resources?: string[];
  MaxResults?: number;
  NextToken?: string;
}
export interface PrincipalIdFormat {
  Arn?: string;
  Statuses?: IdFormat[];
}
export interface DescribePrincipalIdFormatResult {
  Principals?: PrincipalIdFormat[];
  NextToken?: string;
}
export interface DescribePublicIpv4PoolsRequest {
  PoolIds?: string[];
  NextToken?: string;
  MaxResults?: number;
  Filters?: Filter[];
}
export interface PublicIpv4PoolRange {
  FirstAddress?: string;
  LastAddress?: string;
  AddressCount?: number;
  AvailableAddressCount?: number;
}
export interface PublicIpv4Pool {
  PoolId?: string;
  Description?: string;
  PoolAddressRanges?: PublicIpv4PoolRange[];
  TotalAddressCount?: number;
  TotalAvailableAddressCount?: number;
  NetworkBorderGroup?: string;
  Tags?: Tag[];
}
export interface DescribePublicIpv4PoolsResult {
  PublicIpv4Pools?: PublicIpv4Pool[];
  NextToken?: string;
}
export interface DescribeRegionsRequest {
  Filters?: Filter[];
  RegionNames?: string[];
  DryRun?: boolean;
  AllRegions?: boolean;
}
export interface Region {
  Endpoint?: string;
  RegionName?: string;
  OptInStatus?: string;
}
export interface DescribeRegionsResult {
  Regions?: Region[];
}
export interface DescribeReplaceRootVolumeTasksRequest {
  ReplaceRootVolumeTaskIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeReplaceRootVolumeTasksResult {
  ReplaceRootVolumeTasks?: ReplaceRootVolumeTask[];
  NextToken?: string;
}
export declare const OfferingClassType: {
  readonly CONVERTIBLE: "convertible";
  readonly STANDARD: "standard";
};
export type OfferingClassType =
  (typeof OfferingClassType)[keyof typeof OfferingClassType];
export declare const OfferingTypeValues: {
  readonly All_Upfront: "All Upfront";
  readonly Heavy_Utilization: "Heavy Utilization";
  readonly Light_Utilization: "Light Utilization";
  readonly Medium_Utilization: "Medium Utilization";
  readonly No_Upfront: "No Upfront";
  readonly Partial_Upfront: "Partial Upfront";
};
export type OfferingTypeValues =
  (typeof OfferingTypeValues)[keyof typeof OfferingTypeValues];
export interface DescribeReservedInstancesRequest {
  Filters?: Filter[];
  OfferingClass?: OfferingClassType;
  ReservedInstancesIds?: string[];
  DryRun?: boolean;
  OfferingType?: OfferingTypeValues;
}
export declare const RIProductDescription: {
  readonly Linux_UNIX: "Linux/UNIX";
  readonly Linux_UNIX_Amazon_VPC_: "Linux/UNIX (Amazon VPC)";
  readonly Windows: "Windows";
  readonly Windows_Amazon_VPC_: "Windows (Amazon VPC)";
};
export type RIProductDescription =
  (typeof RIProductDescription)[keyof typeof RIProductDescription];
export declare const RecurringChargeFrequency: {
  readonly Hourly: "Hourly";
};
export type RecurringChargeFrequency =
  (typeof RecurringChargeFrequency)[keyof typeof RecurringChargeFrequency];
export interface RecurringCharge {
  Amount?: number;
  Frequency?: RecurringChargeFrequency;
}
export declare const Scope: {
  readonly AVAILABILITY_ZONE: "Availability Zone";
  readonly REGIONAL: "Region";
};
export type Scope = (typeof Scope)[keyof typeof Scope];
export declare const ReservedInstanceState: {
  readonly active: "active";
  readonly payment_failed: "payment-failed";
  readonly payment_pending: "payment-pending";
  readonly queued: "queued";
  readonly queued_deleted: "queued-deleted";
  readonly retired: "retired";
};
export type ReservedInstanceState =
  (typeof ReservedInstanceState)[keyof typeof ReservedInstanceState];
export interface ReservedInstances {
  AvailabilityZone?: string;
  Duration?: number;
  End?: Date;
  FixedPrice?: number;
  InstanceCount?: number;
  InstanceType?: _InstanceType;
  ProductDescription?: RIProductDescription;
  ReservedInstancesId?: string;
  Start?: Date;
  State?: ReservedInstanceState;
  UsagePrice?: number;
  CurrencyCode?: CurrencyCodeValues;
  InstanceTenancy?: Tenancy;
  OfferingClass?: OfferingClassType;
  OfferingType?: OfferingTypeValues;
  RecurringCharges?: RecurringCharge[];
  Scope?: Scope;
  Tags?: Tag[];
}
export interface DescribeReservedInstancesResult {
  ReservedInstances?: ReservedInstances[];
}
export interface DescribeReservedInstancesListingsRequest {
  Filters?: Filter[];
  ReservedInstancesId?: string;
  ReservedInstancesListingId?: string;
}
export interface DescribeReservedInstancesListingsResult {
  ReservedInstancesListings?: ReservedInstancesListing[];
}
export interface DescribeReservedInstancesModificationsRequest {
  Filters?: Filter[];
  ReservedInstancesModificationIds?: string[];
  NextToken?: string;
}
export interface ReservedInstancesConfiguration {
  AvailabilityZone?: string;
  InstanceCount?: number;
  InstanceType?: _InstanceType;
  Platform?: string;
  Scope?: Scope;
}
export interface ReservedInstancesModificationResult {
  ReservedInstancesId?: string;
  TargetConfiguration?: ReservedInstancesConfiguration;
}
export interface ReservedInstancesId {
  ReservedInstancesId?: string;
}
export interface ReservedInstancesModification {
  ClientToken?: string;
  CreateDate?: Date;
  EffectiveDate?: Date;
  ModificationResults?: ReservedInstancesModificationResult[];
  ReservedInstancesIds?: ReservedInstancesId[];
  ReservedInstancesModificationId?: string;
  Status?: string;
  StatusMessage?: string;
  UpdateDate?: Date;
}
export interface DescribeReservedInstancesModificationsResult {
  NextToken?: string;
  ReservedInstancesModifications?: ReservedInstancesModification[];
}
export interface DescribeReservedInstancesOfferingsRequest {
  AvailabilityZone?: string;
  Filters?: Filter[];
  IncludeMarketplace?: boolean;
  InstanceType?: _InstanceType;
  MaxDuration?: number;
  MaxInstanceCount?: number;
  MinDuration?: number;
  OfferingClass?: OfferingClassType;
  ProductDescription?: RIProductDescription;
  ReservedInstancesOfferingIds?: string[];
  DryRun?: boolean;
  InstanceTenancy?: Tenancy;
  MaxResults?: number;
  NextToken?: string;
  OfferingType?: OfferingTypeValues;
}
export interface PricingDetail {
  Count?: number;
  Price?: number;
}
export interface ReservedInstancesOffering {
  AvailabilityZone?: string;
  Duration?: number;
  FixedPrice?: number;
  InstanceType?: _InstanceType;
  ProductDescription?: RIProductDescription;
  ReservedInstancesOfferingId?: string;
  UsagePrice?: number;
  CurrencyCode?: CurrencyCodeValues;
  InstanceTenancy?: Tenancy;
  Marketplace?: boolean;
  OfferingClass?: OfferingClassType;
  OfferingType?: OfferingTypeValues;
  PricingDetails?: PricingDetail[];
  RecurringCharges?: RecurringCharge[];
  Scope?: Scope;
}
export interface DescribeReservedInstancesOfferingsResult {
  ReservedInstancesOfferings?: ReservedInstancesOffering[];
  NextToken?: string;
}
export interface DescribeRouteTablesRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  RouteTableIds?: string[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeRouteTablesResult {
  RouteTables?: RouteTable[];
  NextToken?: string;
}
export interface SlotDateTimeRangeRequest {
  EarliestTime: Date | undefined;
  LatestTime: Date | undefined;
}
export interface ScheduledInstanceRecurrenceRequest {
  Frequency?: string;
  Interval?: number;
  OccurrenceDays?: number[];
  OccurrenceRelativeToEnd?: boolean;
  OccurrenceUnit?: string;
}
export interface DescribeScheduledInstanceAvailabilityRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  FirstSlotStartTimeRange: SlotDateTimeRangeRequest | undefined;
  MaxResults?: number;
  MaxSlotDurationInHours?: number;
  MinSlotDurationInHours?: number;
  NextToken?: string;
  Recurrence: ScheduledInstanceRecurrenceRequest | undefined;
}
export interface ScheduledInstanceRecurrence {
  Frequency?: string;
  Interval?: number;
  OccurrenceDaySet?: number[];
  OccurrenceRelativeToEnd?: boolean;
  OccurrenceUnit?: string;
}
export interface ScheduledInstanceAvailability {
  AvailabilityZone?: string;
  AvailableInstanceCount?: number;
  FirstSlotStartTime?: Date;
  HourlyPrice?: string;
  InstanceType?: string;
  MaxTermDurationInDays?: number;
  MinTermDurationInDays?: number;
  NetworkPlatform?: string;
  Platform?: string;
  PurchaseToken?: string;
  Recurrence?: ScheduledInstanceRecurrence;
  SlotDurationInHours?: number;
  TotalScheduledInstanceHours?: number;
}
export interface DescribeScheduledInstanceAvailabilityResult {
  NextToken?: string;
  ScheduledInstanceAvailabilitySet?: ScheduledInstanceAvailability[];
}
export interface SlotStartTimeRangeRequest {
  EarliestTime?: Date;
  LatestTime?: Date;
}
export interface DescribeScheduledInstancesRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  ScheduledInstanceIds?: string[];
  SlotStartTimeRange?: SlotStartTimeRangeRequest;
}
export interface ScheduledInstance {
  AvailabilityZone?: string;
  CreateDate?: Date;
  HourlyPrice?: string;
  InstanceCount?: number;
  InstanceType?: string;
  NetworkPlatform?: string;
  NextSlotStartTime?: Date;
  Platform?: string;
  PreviousSlotEndTime?: Date;
  Recurrence?: ScheduledInstanceRecurrence;
  ScheduledInstanceId?: string;
  SlotDurationInHours?: number;
  TermEndDate?: Date;
  TermStartDate?: Date;
  TotalScheduledInstanceHours?: number;
}
export interface DescribeScheduledInstancesResult {
  NextToken?: string;
  ScheduledInstanceSet?: ScheduledInstance[];
}
export interface DescribeSecurityGroupReferencesRequest {
  DryRun?: boolean;
  GroupId: string[] | undefined;
}
export interface SecurityGroupReference {
  GroupId?: string;
  ReferencingVpcId?: string;
  VpcPeeringConnectionId?: string;
  TransitGatewayId?: string;
}
export interface DescribeSecurityGroupReferencesResult {
  SecurityGroupReferenceSet?: SecurityGroupReference[];
}
export interface DescribeSecurityGroupRulesRequest {
  Filters?: Filter[];
  SecurityGroupRuleIds?: string[];
  DryRun?: boolean;
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeSecurityGroupRulesResult {
  SecurityGroupRules?: SecurityGroupRule[];
  NextToken?: string;
}
export interface DescribeSecurityGroupsRequest {
  Filters?: Filter[];
  GroupIds?: string[];
  GroupNames?: string[];
  DryRun?: boolean;
  NextToken?: string;
  MaxResults?: number;
}
export interface SecurityGroup {
  Description?: string;
  GroupName?: string;
  IpPermissions?: IpPermission[];
  OwnerId?: string;
  GroupId?: string;
  IpPermissionsEgress?: IpPermission[];
  Tags?: Tag[];
  VpcId?: string;
}
export interface DescribeSecurityGroupsResult {
  SecurityGroups?: SecurityGroup[];
  NextToken?: string;
}
export declare const SnapshotAttributeName: {
  readonly createVolumePermission: "createVolumePermission";
  readonly productCodes: "productCodes";
};
export type SnapshotAttributeName =
  (typeof SnapshotAttributeName)[keyof typeof SnapshotAttributeName];
export interface DescribeSnapshotAttributeRequest {
  Attribute: SnapshotAttributeName | undefined;
  SnapshotId: string | undefined;
  DryRun?: boolean;
}
export interface CreateVolumePermission {
  Group?: PermissionGroup;
  UserId?: string;
}
export interface DescribeSnapshotAttributeResult {
  CreateVolumePermissions?: CreateVolumePermission[];
  ProductCodes?: ProductCode[];
  SnapshotId?: string;
}
export interface DescribeSnapshotsRequest {
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  OwnerIds?: string[];
  RestorableByUserIds?: string[];
  SnapshotIds?: string[];
  DryRun?: boolean;
}
export interface DescribeSnapshotsResult {
  Snapshots?: Snapshot[];
  NextToken?: string;
}
export interface DescribeSnapshotTierStatusRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  NextToken?: string;
  MaxResults?: number;
}
export declare const TieringOperationStatus: {
  readonly archival_completed: "archival-completed";
  readonly archival_failed: "archival-failed";
  readonly archival_in_progress: "archival-in-progress";
  readonly permanent_restore_completed: "permanent-restore-completed";
  readonly permanent_restore_failed: "permanent-restore-failed";
  readonly permanent_restore_in_progress: "permanent-restore-in-progress";
  readonly temporary_restore_completed: "temporary-restore-completed";
  readonly temporary_restore_failed: "temporary-restore-failed";
  readonly temporary_restore_in_progress: "temporary-restore-in-progress";
};
export type TieringOperationStatus =
  (typeof TieringOperationStatus)[keyof typeof TieringOperationStatus];
export interface SnapshotTierStatus {
  SnapshotId?: string;
  VolumeId?: string;
  Status?: SnapshotState;
  OwnerId?: string;
  Tags?: Tag[];
  StorageTier?: StorageTier;
  LastTieringStartTime?: Date;
  LastTieringProgress?: number;
  LastTieringOperationStatus?: TieringOperationStatus;
  LastTieringOperationStatusDetail?: string;
  ArchivalCompleteTime?: Date;
  RestoreExpiryTime?: Date;
}
export interface DescribeSnapshotTierStatusResult {
  SnapshotTierStatuses?: SnapshotTierStatus[];
  NextToken?: string;
}
export interface DescribeSpotDatafeedSubscriptionRequest {
  DryRun?: boolean;
}
export interface DescribeSpotDatafeedSubscriptionResult {
  SpotDatafeedSubscription?: SpotDatafeedSubscription;
}
export interface DescribeSpotFleetInstancesRequest {
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
  SpotFleetRequestId: string | undefined;
}
export interface DescribeSpotFleetInstancesResponse {
  ActiveInstances?: ActiveInstance[];
  NextToken?: string;
  SpotFleetRequestId?: string;
}
export declare const EventType: {
  readonly BATCH_CHANGE: "fleetRequestChange";
  readonly ERROR: "error";
  readonly INFORMATION: "information";
  readonly INSTANCE_CHANGE: "instanceChange";
};
export type EventType = (typeof EventType)[keyof typeof EventType];
export interface DescribeSpotFleetRequestHistoryRequest {
  DryRun?: boolean;
  EventType?: EventType;
  MaxResults?: number;
  NextToken?: string;
  SpotFleetRequestId: string | undefined;
  StartTime: Date | undefined;
}
export interface HistoryRecord {
  EventInformation?: EventInformation;
  EventType?: EventType;
  Timestamp?: Date;
}
export interface DescribeSpotFleetRequestHistoryResponse {
  HistoryRecords?: HistoryRecord[];
  LastEvaluatedTime?: Date;
  NextToken?: string;
  SpotFleetRequestId?: string;
  StartTime?: Date;
}
export interface DescribeSpotFleetRequestsRequest {
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
  SpotFleetRequestIds?: string[];
}
export declare const ExcessCapacityTerminationPolicy: {
  readonly DEFAULT: "default";
  readonly NO_TERMINATION: "noTermination";
};
export type ExcessCapacityTerminationPolicy =
  (typeof ExcessCapacityTerminationPolicy)[keyof typeof ExcessCapacityTerminationPolicy];
export interface SpotFleetMonitoring {
  Enabled?: boolean;
}
export interface InstanceNetworkInterfaceSpecification {
  AssociatePublicIpAddress?: boolean;
  DeleteOnTermination?: boolean;
  Description?: string;
  DeviceIndex?: number;
  Groups?: string[];
  Ipv6AddressCount?: number;
  Ipv6Addresses?: InstanceIpv6Address[];
  NetworkInterfaceId?: string;
  PrivateIpAddress?: string;
  PrivateIpAddresses?: PrivateIpAddressSpecification[];
  SecondaryPrivateIpAddressCount?: number;
  SubnetId?: string;
  AssociateCarrierIpAddress?: boolean;
  InterfaceType?: string;
  NetworkCardIndex?: number;
  Ipv4Prefixes?: Ipv4PrefixSpecificationRequest[];
  Ipv4PrefixCount?: number;
  Ipv6Prefixes?: Ipv6PrefixSpecificationRequest[];
  Ipv6PrefixCount?: number;
  PrimaryIpv6?: boolean;
  EnaSrdSpecification?: EnaSrdSpecificationRequest;
  ConnectionTrackingSpecification?: ConnectionTrackingSpecificationRequest;
}
export interface SpotPlacement {
  AvailabilityZone?: string;
  GroupName?: string;
  Tenancy?: Tenancy;
}
export interface SpotFleetTagSpecification {
  ResourceType?: ResourceType;
  Tags?: Tag[];
}
export interface SpotFleetLaunchSpecification {
  SecurityGroups?: GroupIdentifier[];
  AddressingType?: string;
  BlockDeviceMappings?: BlockDeviceMapping[];
  EbsOptimized?: boolean;
  IamInstanceProfile?: IamInstanceProfileSpecification;
  ImageId?: string;
  InstanceType?: _InstanceType;
  KernelId?: string;
  KeyName?: string;
  Monitoring?: SpotFleetMonitoring;
  NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
  Placement?: SpotPlacement;
  RamdiskId?: string;
  SpotPrice?: string;
  SubnetId?: string;
  UserData?: string;
  WeightedCapacity?: number;
  TagSpecifications?: SpotFleetTagSpecification[];
  InstanceRequirements?: InstanceRequirements;
}
export interface LaunchTemplateOverrides {
  InstanceType?: _InstanceType;
  SpotPrice?: string;
  SubnetId?: string;
  AvailabilityZone?: string;
  WeightedCapacity?: number;
  Priority?: number;
  InstanceRequirements?: InstanceRequirements;
}
export interface LaunchTemplateConfig {
  LaunchTemplateSpecification?: FleetLaunchTemplateSpecification;
  Overrides?: LaunchTemplateOverrides[];
}
export interface ClassicLoadBalancer {
  Name?: string;
}
export interface ClassicLoadBalancersConfig {
  ClassicLoadBalancers?: ClassicLoadBalancer[];
}
export interface TargetGroup {
  Arn?: string;
}
export interface TargetGroupsConfig {
  TargetGroups?: TargetGroup[];
}
export interface LoadBalancersConfig {
  ClassicLoadBalancersConfig?: ClassicLoadBalancersConfig;
  TargetGroupsConfig?: TargetGroupsConfig;
}
export declare const OnDemandAllocationStrategy: {
  readonly LOWEST_PRICE: "lowestPrice";
  readonly PRIORITIZED: "prioritized";
};
export type OnDemandAllocationStrategy =
  (typeof OnDemandAllocationStrategy)[keyof typeof OnDemandAllocationStrategy];
export declare const ReplacementStrategy: {
  readonly LAUNCH: "launch";
  readonly LAUNCH_BEFORE_TERMINATE: "launch-before-terminate";
};
export type ReplacementStrategy =
  (typeof ReplacementStrategy)[keyof typeof ReplacementStrategy];
export interface SpotCapacityRebalance {
  ReplacementStrategy?: ReplacementStrategy;
  TerminationDelay?: number;
}
export interface SpotMaintenanceStrategies {
  CapacityRebalance?: SpotCapacityRebalance;
}
export interface SpotFleetRequestConfigData {
  AllocationStrategy?: AllocationStrategy;
  OnDemandAllocationStrategy?: OnDemandAllocationStrategy;
  SpotMaintenanceStrategies?: SpotMaintenanceStrategies;
  ClientToken?: string;
  ExcessCapacityTerminationPolicy?: ExcessCapacityTerminationPolicy;
  FulfilledCapacity?: number;
  OnDemandFulfilledCapacity?: number;
  IamFleetRole: string | undefined;
  LaunchSpecifications?: SpotFleetLaunchSpecification[];
  LaunchTemplateConfigs?: LaunchTemplateConfig[];
  SpotPrice?: string;
  TargetCapacity: number | undefined;
  OnDemandTargetCapacity?: number;
  OnDemandMaxTotalPrice?: string;
  SpotMaxTotalPrice?: string;
  TerminateInstancesWithExpiration?: boolean;
  Type?: FleetType;
  ValidFrom?: Date;
  ValidUntil?: Date;
  ReplaceUnhealthyInstances?: boolean;
  InstanceInterruptionBehavior?: InstanceInterruptionBehavior;
  LoadBalancersConfig?: LoadBalancersConfig;
  InstancePoolsToUseCount?: number;
  Context?: string;
  TargetCapacityUnitType?: TargetCapacityUnitType;
  TagSpecifications?: TagSpecification[];
}
export interface SpotFleetRequestConfig {
  ActivityStatus?: ActivityStatus;
  CreateTime?: Date;
  SpotFleetRequestConfig?: SpotFleetRequestConfigData;
  SpotFleetRequestId?: string;
  SpotFleetRequestState?: BatchState;
  Tags?: Tag[];
}
export interface DescribeSpotFleetRequestsResponse {
  NextToken?: string;
  SpotFleetRequestConfigs?: SpotFleetRequestConfig[];
}
export interface DescribeSpotInstanceRequestsRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  SpotInstanceRequestIds?: string[];
  NextToken?: string;
  MaxResults?: number;
}
export interface RunInstancesMonitoringEnabled {
  Enabled: boolean | undefined;
}
export interface LaunchSpecification {
  UserData?: string;
  SecurityGroups?: GroupIdentifier[];
  AddressingType?: string;
  BlockDeviceMappings?: BlockDeviceMapping[];
  EbsOptimized?: boolean;
  IamInstanceProfile?: IamInstanceProfileSpecification;
  ImageId?: string;
  InstanceType?: _InstanceType;
  KernelId?: string;
  KeyName?: string;
  NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
  Placement?: SpotPlacement;
  RamdiskId?: string;
  SubnetId?: string;
  Monitoring?: RunInstancesMonitoringEnabled;
}
export declare const SpotInstanceState: {
  readonly active: "active";
  readonly cancelled: "cancelled";
  readonly closed: "closed";
  readonly disabled: "disabled";
  readonly failed: "failed";
  readonly open: "open";
};
export type SpotInstanceState =
  (typeof SpotInstanceState)[keyof typeof SpotInstanceState];
export interface SpotInstanceStatus {
  Code?: string;
  Message?: string;
  UpdateTime?: Date;
}
export interface SpotInstanceRequest {
  ActualBlockHourlyPrice?: string;
  AvailabilityZoneGroup?: string;
  BlockDurationMinutes?: number;
  CreateTime?: Date;
  Fault?: SpotInstanceStateFault;
  InstanceId?: string;
  LaunchGroup?: string;
  LaunchSpecification?: LaunchSpecification;
  LaunchedAvailabilityZone?: string;
  ProductDescription?: RIProductDescription;
  SpotInstanceRequestId?: string;
  SpotPrice?: string;
  State?: SpotInstanceState;
  Status?: SpotInstanceStatus;
  Tags?: Tag[];
  Type?: SpotInstanceType;
  ValidFrom?: Date;
  ValidUntil?: Date;
  InstanceInterruptionBehavior?: InstanceInterruptionBehavior;
}
export interface DescribeSpotInstanceRequestsResult {
  SpotInstanceRequests?: SpotInstanceRequest[];
  NextToken?: string;
}
export interface DescribeSpotPriceHistoryRequest {
  Filters?: Filter[];
  AvailabilityZone?: string;
  DryRun?: boolean;
  EndTime?: Date;
  InstanceTypes?: _InstanceType[];
  MaxResults?: number;
  NextToken?: string;
  ProductDescriptions?: string[];
  StartTime?: Date;
}
export interface SpotPrice {
  AvailabilityZone?: string;
  InstanceType?: _InstanceType;
  ProductDescription?: RIProductDescription;
  SpotPrice?: string;
  Timestamp?: Date;
}
export interface DescribeSpotPriceHistoryResult {
  NextToken?: string;
  SpotPriceHistory?: SpotPrice[];
}
export interface DescribeStaleSecurityGroupsRequest {
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
  VpcId: string | undefined;
}
export declare const SnapshotTaskDetailFilterSensitiveLog: (
  obj: SnapshotTaskDetail
) => any;
export declare const ImportSnapshotTaskFilterSensitiveLog: (
  obj: ImportSnapshotTask
) => any;
export declare const DescribeImportSnapshotTasksResultFilterSensitiveLog: (
  obj: DescribeImportSnapshotTasksResult
) => any;
export declare const DescribeLaunchTemplateVersionsResultFilterSensitiveLog: (
  obj: DescribeLaunchTemplateVersionsResult
) => any;
export declare const SpotFleetLaunchSpecificationFilterSensitiveLog: (
  obj: SpotFleetLaunchSpecification
) => any;
export declare const SpotFleetRequestConfigDataFilterSensitiveLog: (
  obj: SpotFleetRequestConfigData
) => any;
export declare const SpotFleetRequestConfigFilterSensitiveLog: (
  obj: SpotFleetRequestConfig
) => any;
export declare const DescribeSpotFleetRequestsResponseFilterSensitiveLog: (
  obj: DescribeSpotFleetRequestsResponse
) => any;
export declare const LaunchSpecificationFilterSensitiveLog: (
  obj: LaunchSpecification
) => any;
export declare const SpotInstanceRequestFilterSensitiveLog: (
  obj: SpotInstanceRequest
) => any;
export declare const DescribeSpotInstanceRequestsResultFilterSensitiveLog: (
  obj: DescribeSpotInstanceRequestsResult
) => any;
