import {
  AddressTransfer,
  AllowedPrincipal,
  AsnAssociation,
  AssociationStatus,
  CapacityReservationState,
  CurrencyCodeValues,
  IamInstanceProfileAssociation,
  InstanceEventWindow,
  IpamResourceDiscoveryAssociation,
  NatGatewayAddress,
  ResourceType,
  SubnetIpv6CidrBlockAssociation,
  Tag,
  TagSpecification,
  TransitGatewayAssociation,
  TransitGatewayAssociationState,
  TransitGatewayAttachmentResourceType,
  TransitGatewayAttachmentState,
  TransitGatewayMulticastDomainAssociations,
  TransitGatewayPeeringAttachment,
  TransitGatewayPolicyTableAssociation,
  TransitGatewayVpcAttachment,
  TrunkInterfaceAssociation,
  UserIdGroupPair,
  VerifiedAccessInstance,
  VerifiedAccessTrustProvider,
  VpcCidrBlockAssociation,
  VpcIpv6CidrBlockAssociation,
  VpcPeeringConnection,
} from "./models_0";
import {
  DiskImageFormat,
  InstanceRequirementsRequest,
  Subnet,
  VolumeType,
  Vpc,
} from "./models_1";
import {
  ConnectionNotification,
  DnsEntry,
  DnsNameState,
  IpAddressType,
  PayerResponsibility,
  ServiceConfiguration,
  ServiceConnectivityType,
  ServiceTypeDetail,
  SSEType,
  State,
  TrafficMirrorFilter,
  TrafficMirrorSession,
  TrafficMirrorTarget,
  TransitGateway,
  TransitGatewayConnect,
  TransitGatewayConnectPeer,
  TransitGatewayMulticastDomain,
  TransitGatewayPolicyTable,
  TransitGatewayRouteTable,
  TransitGatewayRouteTableAnnouncement,
  VerifiedAccessEndpoint,
  VerifiedAccessGroup,
  Volume,
  VpcEndpoint,
  VpnConnection,
  VpnGateway,
} from "./models_2";
import {
  ExportTaskS3Location,
  FastLaunchLaunchTemplateSpecificationResponse,
  FastLaunchResourceType,
  FastLaunchSnapshotConfigurationResponse,
  FastLaunchStateCode,
  FastSnapshotRestoreStateCode,
  Filter,
  MetricType,
  PaymentOption,
  PeriodType,
  ProductCode,
  StatisticType,
  VirtualizationType,
} from "./models_3";
import { ArchitectureType, AttributeBooleanValue } from "./models_4";
export interface StaleIpPermission {
  FromPort?: number;
  IpProtocol?: string;
  IpRanges?: string[];
  PrefixListIds?: string[];
  ToPort?: number;
  UserIdGroupPairs?: UserIdGroupPair[];
}
export interface StaleSecurityGroup {
  Description?: string;
  GroupId?: string;
  GroupName?: string;
  StaleIpPermissions?: StaleIpPermission[];
  StaleIpPermissionsEgress?: StaleIpPermission[];
  VpcId?: string;
}
export interface DescribeStaleSecurityGroupsResult {
  NextToken?: string;
  StaleSecurityGroupSet?: StaleSecurityGroup[];
}
export interface DescribeStoreImageTasksRequest {
  ImageIds?: string[];
  DryRun?: boolean;
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
}
export interface StoreImageTaskResult {
  AmiId?: string;
  TaskStartTime?: Date;
  Bucket?: string;
  S3objectKey?: string;
  ProgressPercentage?: number;
  StoreTaskState?: string;
  StoreTaskFailureReason?: string;
}
export interface DescribeStoreImageTasksResult {
  StoreImageTaskResults?: StoreImageTaskResult[];
  NextToken?: string;
}
export interface DescribeSubnetsRequest {
  Filters?: Filter[];
  SubnetIds?: string[];
  DryRun?: boolean;
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeSubnetsResult {
  Subnets?: Subnet[];
  NextToken?: string;
}
export interface DescribeTagsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface TagDescription {
  Key?: string;
  ResourceId?: string;
  ResourceType?: ResourceType;
  Value?: string;
}
export interface DescribeTagsResult {
  NextToken?: string;
  Tags?: TagDescription[];
}
export interface DescribeTrafficMirrorFiltersRequest {
  TrafficMirrorFilterIds?: string[];
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeTrafficMirrorFiltersResult {
  TrafficMirrorFilters?: TrafficMirrorFilter[];
  NextToken?: string;
}
export interface DescribeTrafficMirrorSessionsRequest {
  TrafficMirrorSessionIds?: string[];
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeTrafficMirrorSessionsResult {
  TrafficMirrorSessions?: TrafficMirrorSession[];
  NextToken?: string;
}
export interface DescribeTrafficMirrorTargetsRequest {
  TrafficMirrorTargetIds?: string[];
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeTrafficMirrorTargetsResult {
  TrafficMirrorTargets?: TrafficMirrorTarget[];
  NextToken?: string;
}
export interface DescribeTransitGatewayAttachmentsRequest {
  TransitGatewayAttachmentIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface TransitGatewayAttachmentAssociation {
  TransitGatewayRouteTableId?: string;
  State?: TransitGatewayAssociationState;
}
export interface TransitGatewayAttachment {
  TransitGatewayAttachmentId?: string;
  TransitGatewayId?: string;
  TransitGatewayOwnerId?: string;
  ResourceOwnerId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType;
  ResourceId?: string;
  State?: TransitGatewayAttachmentState;
  Association?: TransitGatewayAttachmentAssociation;
  CreationTime?: Date;
  Tags?: Tag[];
}
export interface DescribeTransitGatewayAttachmentsResult {
  TransitGatewayAttachments?: TransitGatewayAttachment[];
  NextToken?: string;
}
export interface DescribeTransitGatewayConnectPeersRequest {
  TransitGatewayConnectPeerIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayConnectPeersResult {
  TransitGatewayConnectPeers?: TransitGatewayConnectPeer[];
  NextToken?: string;
}
export interface DescribeTransitGatewayConnectsRequest {
  TransitGatewayAttachmentIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayConnectsResult {
  TransitGatewayConnects?: TransitGatewayConnect[];
  NextToken?: string;
}
export interface DescribeTransitGatewayMulticastDomainsRequest {
  TransitGatewayMulticastDomainIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayMulticastDomainsResult {
  TransitGatewayMulticastDomains?: TransitGatewayMulticastDomain[];
  NextToken?: string;
}
export interface DescribeTransitGatewayPeeringAttachmentsRequest {
  TransitGatewayAttachmentIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayPeeringAttachmentsResult {
  TransitGatewayPeeringAttachments?: TransitGatewayPeeringAttachment[];
  NextToken?: string;
}
export interface DescribeTransitGatewayPolicyTablesRequest {
  TransitGatewayPolicyTableIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayPolicyTablesResult {
  TransitGatewayPolicyTables?: TransitGatewayPolicyTable[];
  NextToken?: string;
}
export interface DescribeTransitGatewayRouteTableAnnouncementsRequest {
  TransitGatewayRouteTableAnnouncementIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayRouteTableAnnouncementsResult {
  TransitGatewayRouteTableAnnouncements?: TransitGatewayRouteTableAnnouncement[];
  NextToken?: string;
}
export interface DescribeTransitGatewayRouteTablesRequest {
  TransitGatewayRouteTableIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayRouteTablesResult {
  TransitGatewayRouteTables?: TransitGatewayRouteTable[];
  NextToken?: string;
}
export interface DescribeTransitGatewaysRequest {
  TransitGatewayIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewaysResult {
  TransitGateways?: TransitGateway[];
  NextToken?: string;
}
export interface DescribeTransitGatewayVpcAttachmentsRequest {
  TransitGatewayAttachmentIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface DescribeTransitGatewayVpcAttachmentsResult {
  TransitGatewayVpcAttachments?: TransitGatewayVpcAttachment[];
  NextToken?: string;
}
export interface DescribeTrunkInterfaceAssociationsRequest {
  AssociationIds?: string[];
  DryRun?: boolean;
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeTrunkInterfaceAssociationsResult {
  InterfaceAssociations?: TrunkInterfaceAssociation[];
  NextToken?: string;
}
export interface DescribeVerifiedAccessEndpointsRequest {
  VerifiedAccessEndpointIds?: string[];
  VerifiedAccessInstanceId?: string;
  VerifiedAccessGroupId?: string;
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface DescribeVerifiedAccessEndpointsResult {
  VerifiedAccessEndpoints?: VerifiedAccessEndpoint[];
  NextToken?: string;
}
export interface DescribeVerifiedAccessGroupsRequest {
  VerifiedAccessGroupIds?: string[];
  VerifiedAccessInstanceId?: string;
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface DescribeVerifiedAccessGroupsResult {
  VerifiedAccessGroups?: VerifiedAccessGroup[];
  NextToken?: string;
}
export interface DescribeVerifiedAccessInstanceLoggingConfigurationsRequest {
  VerifiedAccessInstanceIds?: string[];
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export declare const VerifiedAccessLogDeliveryStatusCode: {
  readonly FAILED: "failed";
  readonly SUCCESS: "success";
};
export type VerifiedAccessLogDeliveryStatusCode =
  (typeof VerifiedAccessLogDeliveryStatusCode)[keyof typeof VerifiedAccessLogDeliveryStatusCode];
export interface VerifiedAccessLogDeliveryStatus {
  Code?: VerifiedAccessLogDeliveryStatusCode;
  Message?: string;
}
export interface VerifiedAccessLogCloudWatchLogsDestination {
  Enabled?: boolean;
  DeliveryStatus?: VerifiedAccessLogDeliveryStatus;
  LogGroup?: string;
}
export interface VerifiedAccessLogKinesisDataFirehoseDestination {
  Enabled?: boolean;
  DeliveryStatus?: VerifiedAccessLogDeliveryStatus;
  DeliveryStream?: string;
}
export interface VerifiedAccessLogS3Destination {
  Enabled?: boolean;
  DeliveryStatus?: VerifiedAccessLogDeliveryStatus;
  BucketName?: string;
  Prefix?: string;
  BucketOwner?: string;
}
export interface VerifiedAccessLogs {
  S3?: VerifiedAccessLogS3Destination;
  CloudWatchLogs?: VerifiedAccessLogCloudWatchLogsDestination;
  KinesisDataFirehose?: VerifiedAccessLogKinesisDataFirehoseDestination;
  LogVersion?: string;
  IncludeTrustContext?: boolean;
}
export interface VerifiedAccessInstanceLoggingConfiguration {
  VerifiedAccessInstanceId?: string;
  AccessLogs?: VerifiedAccessLogs;
}
export interface DescribeVerifiedAccessInstanceLoggingConfigurationsResult {
  LoggingConfigurations?: VerifiedAccessInstanceLoggingConfiguration[];
  NextToken?: string;
}
export interface DescribeVerifiedAccessInstancesRequest {
  VerifiedAccessInstanceIds?: string[];
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface DescribeVerifiedAccessInstancesResult {
  VerifiedAccessInstances?: VerifiedAccessInstance[];
  NextToken?: string;
}
export interface DescribeVerifiedAccessTrustProvidersRequest {
  VerifiedAccessTrustProviderIds?: string[];
  MaxResults?: number;
  NextToken?: string;
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface DescribeVerifiedAccessTrustProvidersResult {
  VerifiedAccessTrustProviders?: VerifiedAccessTrustProvider[];
  NextToken?: string;
}
export declare const VolumeAttributeName: {
  readonly autoEnableIO: "autoEnableIO";
  readonly productCodes: "productCodes";
};
export type VolumeAttributeName =
  (typeof VolumeAttributeName)[keyof typeof VolumeAttributeName];
export interface DescribeVolumeAttributeRequest {
  Attribute: VolumeAttributeName | undefined;
  VolumeId: string | undefined;
  DryRun?: boolean;
}
export interface DescribeVolumeAttributeResult {
  AutoEnableIO?: AttributeBooleanValue;
  ProductCodes?: ProductCode[];
  VolumeId?: string;
}
export interface DescribeVolumesRequest {
  Filters?: Filter[];
  VolumeIds?: string[];
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeVolumesResult {
  Volumes?: Volume[];
  NextToken?: string;
}
export interface DescribeVolumesModificationsRequest {
  DryRun?: boolean;
  VolumeIds?: string[];
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
}
export declare const VolumeModificationState: {
  readonly completed: "completed";
  readonly failed: "failed";
  readonly modifying: "modifying";
  readonly optimizing: "optimizing";
};
export type VolumeModificationState =
  (typeof VolumeModificationState)[keyof typeof VolumeModificationState];
export interface VolumeModification {
  VolumeId?: string;
  ModificationState?: VolumeModificationState;
  StatusMessage?: string;
  TargetSize?: number;
  TargetIops?: number;
  TargetVolumeType?: VolumeType;
  TargetThroughput?: number;
  TargetMultiAttachEnabled?: boolean;
  OriginalSize?: number;
  OriginalIops?: number;
  OriginalVolumeType?: VolumeType;
  OriginalThroughput?: number;
  OriginalMultiAttachEnabled?: boolean;
  Progress?: number;
  StartTime?: Date;
  EndTime?: Date;
}
export interface DescribeVolumesModificationsResult {
  VolumesModifications?: VolumeModification[];
  NextToken?: string;
}
export interface DescribeVolumeStatusRequest {
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  VolumeIds?: string[];
  DryRun?: boolean;
}
export interface VolumeStatusAction {
  Code?: string;
  Description?: string;
  EventId?: string;
  EventType?: string;
}
export interface VolumeStatusAttachmentStatus {
  IoPerformance?: string;
  InstanceId?: string;
}
export interface VolumeStatusEvent {
  Description?: string;
  EventId?: string;
  EventType?: string;
  NotAfter?: Date;
  NotBefore?: Date;
  InstanceId?: string;
}
export declare const VolumeStatusName: {
  readonly io_enabled: "io-enabled";
  readonly io_performance: "io-performance";
};
export type VolumeStatusName =
  (typeof VolumeStatusName)[keyof typeof VolumeStatusName];
export interface VolumeStatusDetails {
  Name?: VolumeStatusName;
  Status?: string;
}
export declare const VolumeStatusInfoStatus: {
  readonly impaired: "impaired";
  readonly insufficient_data: "insufficient-data";
  readonly ok: "ok";
};
export type VolumeStatusInfoStatus =
  (typeof VolumeStatusInfoStatus)[keyof typeof VolumeStatusInfoStatus];
export interface VolumeStatusInfo {
  Details?: VolumeStatusDetails[];
  Status?: VolumeStatusInfoStatus;
}
export interface VolumeStatusItem {
  Actions?: VolumeStatusAction[];
  AvailabilityZone?: string;
  OutpostArn?: string;
  Events?: VolumeStatusEvent[];
  VolumeId?: string;
  VolumeStatus?: VolumeStatusInfo;
  AttachmentStatuses?: VolumeStatusAttachmentStatus[];
}
export interface DescribeVolumeStatusResult {
  NextToken?: string;
  VolumeStatuses?: VolumeStatusItem[];
}
export declare const VpcAttributeName: {
  readonly enableDnsHostnames: "enableDnsHostnames";
  readonly enableDnsSupport: "enableDnsSupport";
  readonly enableNetworkAddressUsageMetrics: "enableNetworkAddressUsageMetrics";
};
export type VpcAttributeName =
  (typeof VpcAttributeName)[keyof typeof VpcAttributeName];
export interface DescribeVpcAttributeRequest {
  Attribute: VpcAttributeName | undefined;
  VpcId: string | undefined;
  DryRun?: boolean;
}
export interface DescribeVpcAttributeResult {
  VpcId?: string;
  EnableDnsHostnames?: AttributeBooleanValue;
  EnableDnsSupport?: AttributeBooleanValue;
  EnableNetworkAddressUsageMetrics?: AttributeBooleanValue;
}
export interface DescribeVpcClassicLinkRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  VpcIds?: string[];
}
export interface VpcClassicLink {
  ClassicLinkEnabled?: boolean;
  Tags?: Tag[];
  VpcId?: string;
}
export interface DescribeVpcClassicLinkResult {
  Vpcs?: VpcClassicLink[];
}
export interface DescribeVpcClassicLinkDnsSupportRequest {
  MaxResults?: number;
  NextToken?: string;
  VpcIds?: string[];
}
export interface ClassicLinkDnsSupport {
  ClassicLinkDnsSupported?: boolean;
  VpcId?: string;
}
export interface DescribeVpcClassicLinkDnsSupportResult {
  NextToken?: string;
  Vpcs?: ClassicLinkDnsSupport[];
}
export interface DescribeVpcEndpointConnectionNotificationsRequest {
  DryRun?: boolean;
  ConnectionNotificationId?: string;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeVpcEndpointConnectionNotificationsResult {
  ConnectionNotificationSet?: ConnectionNotification[];
  NextToken?: string;
}
export interface DescribeVpcEndpointConnectionsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface VpcEndpointConnection {
  ServiceId?: string;
  VpcEndpointId?: string;
  VpcEndpointOwner?: string;
  VpcEndpointState?: State;
  CreationTimestamp?: Date;
  DnsEntries?: DnsEntry[];
  NetworkLoadBalancerArns?: string[];
  GatewayLoadBalancerArns?: string[];
  IpAddressType?: IpAddressType;
  VpcEndpointConnectionId?: string;
  Tags?: Tag[];
}
export interface DescribeVpcEndpointConnectionsResult {
  VpcEndpointConnections?: VpcEndpointConnection[];
  NextToken?: string;
}
export interface DescribeVpcEndpointsRequest {
  DryRun?: boolean;
  VpcEndpointIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeVpcEndpointsResult {
  VpcEndpoints?: VpcEndpoint[];
  NextToken?: string;
}
export interface DescribeVpcEndpointServiceConfigurationsRequest {
  DryRun?: boolean;
  ServiceIds?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeVpcEndpointServiceConfigurationsResult {
  ServiceConfigurations?: ServiceConfiguration[];
  NextToken?: string;
}
export interface DescribeVpcEndpointServicePermissionsRequest {
  DryRun?: boolean;
  ServiceId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeVpcEndpointServicePermissionsResult {
  AllowedPrincipals?: AllowedPrincipal[];
  NextToken?: string;
}
export interface DescribeVpcEndpointServicesRequest {
  DryRun?: boolean;
  ServiceNames?: string[];
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface PrivateDnsDetails {
  PrivateDnsName?: string;
}
export interface ServiceDetail {
  ServiceName?: string;
  ServiceId?: string;
  ServiceType?: ServiceTypeDetail[];
  AvailabilityZones?: string[];
  Owner?: string;
  BaseEndpointDnsNames?: string[];
  PrivateDnsName?: string;
  PrivateDnsNames?: PrivateDnsDetails[];
  VpcEndpointPolicySupported?: boolean;
  AcceptanceRequired?: boolean;
  ManagesVpcEndpoints?: boolean;
  PayerResponsibility?: PayerResponsibility;
  Tags?: Tag[];
  PrivateDnsNameVerificationState?: DnsNameState;
  SupportedIpAddressTypes?: ServiceConnectivityType[];
}
export interface DescribeVpcEndpointServicesResult {
  ServiceNames?: string[];
  ServiceDetails?: ServiceDetail[];
  NextToken?: string;
}
export interface DescribeVpcPeeringConnectionsRequest {
  Filters?: Filter[];
  DryRun?: boolean;
  VpcPeeringConnectionIds?: string[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeVpcPeeringConnectionsResult {
  VpcPeeringConnections?: VpcPeeringConnection[];
  NextToken?: string;
}
export interface DescribeVpcsRequest {
  Filters?: Filter[];
  VpcIds?: string[];
  DryRun?: boolean;
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeVpcsResult {
  Vpcs?: Vpc[];
  NextToken?: string;
}
export interface DescribeVpnConnectionsRequest {
  Filters?: Filter[];
  VpnConnectionIds?: string[];
  DryRun?: boolean;
}
export interface DescribeVpnConnectionsResult {
  VpnConnections?: VpnConnection[];
}
export interface DescribeVpnGatewaysRequest {
  Filters?: Filter[];
  VpnGatewayIds?: string[];
  DryRun?: boolean;
}
export interface DescribeVpnGatewaysResult {
  VpnGateways?: VpnGateway[];
}
export interface DetachClassicLinkVpcRequest {
  DryRun?: boolean;
  InstanceId: string | undefined;
  VpcId: string | undefined;
}
export interface DetachClassicLinkVpcResult {
  Return?: boolean;
}
export interface DetachInternetGatewayRequest {
  DryRun?: boolean;
  InternetGatewayId: string | undefined;
  VpcId: string | undefined;
}
export interface DetachNetworkInterfaceRequest {
  AttachmentId: string | undefined;
  DryRun?: boolean;
  Force?: boolean;
}
export interface DetachVerifiedAccessTrustProviderRequest {
  VerifiedAccessInstanceId: string | undefined;
  VerifiedAccessTrustProviderId: string | undefined;
  ClientToken?: string;
  DryRun?: boolean;
}
export interface DetachVerifiedAccessTrustProviderResult {
  VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider;
  VerifiedAccessInstance?: VerifiedAccessInstance;
}
export interface DetachVolumeRequest {
  Device?: string;
  Force?: boolean;
  InstanceId?: string;
  VolumeId: string | undefined;
  DryRun?: boolean;
}
export interface DetachVpnGatewayRequest {
  VpcId: string | undefined;
  VpnGatewayId: string | undefined;
  DryRun?: boolean;
}
export interface DisableAddressTransferRequest {
  AllocationId: string | undefined;
  DryRun?: boolean;
}
export interface DisableAddressTransferResult {
  AddressTransfer?: AddressTransfer;
}
export interface DisableAwsNetworkPerformanceMetricSubscriptionRequest {
  Source?: string;
  Destination?: string;
  Metric?: MetricType;
  Statistic?: StatisticType;
  DryRun?: boolean;
}
export interface DisableAwsNetworkPerformanceMetricSubscriptionResult {
  Output?: boolean;
}
export interface DisableEbsEncryptionByDefaultRequest {
  DryRun?: boolean;
}
export interface DisableEbsEncryptionByDefaultResult {
  EbsEncryptionByDefault?: boolean;
}
export interface DisableFastLaunchRequest {
  ImageId: string | undefined;
  Force?: boolean;
  DryRun?: boolean;
}
export interface DisableFastLaunchResult {
  ImageId?: string;
  ResourceType?: FastLaunchResourceType;
  SnapshotConfiguration?: FastLaunchSnapshotConfigurationResponse;
  LaunchTemplate?: FastLaunchLaunchTemplateSpecificationResponse;
  MaxParallelLaunches?: number;
  OwnerId?: string;
  State?: FastLaunchStateCode;
  StateTransitionReason?: string;
  StateTransitionTime?: Date;
}
export interface DisableFastSnapshotRestoresRequest {
  AvailabilityZones: string[] | undefined;
  SourceSnapshotIds: string[] | undefined;
  DryRun?: boolean;
}
export interface DisableFastSnapshotRestoreSuccessItem {
  SnapshotId?: string;
  AvailabilityZone?: string;
  State?: FastSnapshotRestoreStateCode;
  StateTransitionReason?: string;
  OwnerId?: string;
  OwnerAlias?: string;
  EnablingTime?: Date;
  OptimizingTime?: Date;
  EnabledTime?: Date;
  DisablingTime?: Date;
  DisabledTime?: Date;
}
export interface DisableFastSnapshotRestoreStateError {
  Code?: string;
  Message?: string;
}
export interface DisableFastSnapshotRestoreStateErrorItem {
  AvailabilityZone?: string;
  Error?: DisableFastSnapshotRestoreStateError;
}
export interface DisableFastSnapshotRestoreErrorItem {
  SnapshotId?: string;
  FastSnapshotRestoreStateErrors?: DisableFastSnapshotRestoreStateErrorItem[];
}
export interface DisableFastSnapshotRestoresResult {
  Successful?: DisableFastSnapshotRestoreSuccessItem[];
  Unsuccessful?: DisableFastSnapshotRestoreErrorItem[];
}
export interface DisableImageRequest {
  ImageId: string | undefined;
  DryRun?: boolean;
}
export interface DisableImageResult {
  Return?: boolean;
}
export interface DisableImageBlockPublicAccessRequest {
  DryRun?: boolean;
}
export declare const ImageBlockPublicAccessDisabledState: {
  readonly unblocked: "unblocked";
};
export type ImageBlockPublicAccessDisabledState =
  (typeof ImageBlockPublicAccessDisabledState)[keyof typeof ImageBlockPublicAccessDisabledState];
export interface DisableImageBlockPublicAccessResult {
  ImageBlockPublicAccessState?: ImageBlockPublicAccessDisabledState;
}
export interface DisableImageDeprecationRequest {
  ImageId: string | undefined;
  DryRun?: boolean;
}
export interface DisableImageDeprecationResult {
  Return?: boolean;
}
export interface DisableIpamOrganizationAdminAccountRequest {
  DryRun?: boolean;
  DelegatedAdminAccountId: string | undefined;
}
export interface DisableIpamOrganizationAdminAccountResult {
  Success?: boolean;
}
export interface DisableSerialConsoleAccessRequest {
  DryRun?: boolean;
}
export interface DisableSerialConsoleAccessResult {
  SerialConsoleAccessEnabled?: boolean;
}
export interface DisableSnapshotBlockPublicAccessRequest {
  DryRun?: boolean;
}
export declare const SnapshotBlockPublicAccessState: {
  readonly block_all_sharing: "block-all-sharing";
  readonly block_new_sharing: "block-new-sharing";
  readonly unblocked: "unblocked";
};
export type SnapshotBlockPublicAccessState =
  (typeof SnapshotBlockPublicAccessState)[keyof typeof SnapshotBlockPublicAccessState];
export interface DisableSnapshotBlockPublicAccessResult {
  State?: SnapshotBlockPublicAccessState;
}
export interface DisableTransitGatewayRouteTablePropagationRequest {
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId?: string;
  DryRun?: boolean;
  TransitGatewayRouteTableAnnouncementId?: string;
}
export declare const TransitGatewayPropagationState: {
  readonly disabled: "disabled";
  readonly disabling: "disabling";
  readonly enabled: "enabled";
  readonly enabling: "enabling";
};
export type TransitGatewayPropagationState =
  (typeof TransitGatewayPropagationState)[keyof typeof TransitGatewayPropagationState];
export interface TransitGatewayPropagation {
  TransitGatewayAttachmentId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType;
  TransitGatewayRouteTableId?: string;
  State?: TransitGatewayPropagationState;
  TransitGatewayRouteTableAnnouncementId?: string;
}
export interface DisableTransitGatewayRouteTablePropagationResult {
  Propagation?: TransitGatewayPropagation;
}
export interface DisableVgwRoutePropagationRequest {
  GatewayId: string | undefined;
  RouteTableId: string | undefined;
  DryRun?: boolean;
}
export interface DisableVpcClassicLinkRequest {
  DryRun?: boolean;
  VpcId: string | undefined;
}
export interface DisableVpcClassicLinkResult {
  Return?: boolean;
}
export interface DisableVpcClassicLinkDnsSupportRequest {
  VpcId?: string;
}
export interface DisableVpcClassicLinkDnsSupportResult {
  Return?: boolean;
}
export interface DisassociateAddressRequest {
  AssociationId?: string;
  PublicIp?: string;
  DryRun?: boolean;
}
export interface DisassociateClientVpnTargetNetworkRequest {
  ClientVpnEndpointId: string | undefined;
  AssociationId: string | undefined;
  DryRun?: boolean;
}
export interface DisassociateClientVpnTargetNetworkResult {
  AssociationId?: string;
  Status?: AssociationStatus;
}
export interface DisassociateEnclaveCertificateIamRoleRequest {
  CertificateArn: string | undefined;
  RoleArn: string | undefined;
  DryRun?: boolean;
}
export interface DisassociateEnclaveCertificateIamRoleResult {
  Return?: boolean;
}
export interface DisassociateIamInstanceProfileRequest {
  AssociationId: string | undefined;
}
export interface DisassociateIamInstanceProfileResult {
  IamInstanceProfileAssociation?: IamInstanceProfileAssociation;
}
export interface InstanceEventWindowDisassociationRequest {
  InstanceIds?: string[];
  InstanceTags?: Tag[];
  DedicatedHostIds?: string[];
}
export interface DisassociateInstanceEventWindowRequest {
  DryRun?: boolean;
  InstanceEventWindowId: string | undefined;
  AssociationTarget: InstanceEventWindowDisassociationRequest | undefined;
}
export interface DisassociateInstanceEventWindowResult {
  InstanceEventWindow?: InstanceEventWindow;
}
export interface DisassociateIpamByoasnRequest {
  DryRun?: boolean;
  Asn: string | undefined;
  Cidr: string | undefined;
}
export interface DisassociateIpamByoasnResult {
  AsnAssociation?: AsnAssociation;
}
export interface DisassociateIpamResourceDiscoveryRequest {
  DryRun?: boolean;
  IpamResourceDiscoveryAssociationId: string | undefined;
}
export interface DisassociateIpamResourceDiscoveryResult {
  IpamResourceDiscoveryAssociation?: IpamResourceDiscoveryAssociation;
}
export interface DisassociateNatGatewayAddressRequest {
  NatGatewayId: string | undefined;
  AssociationIds: string[] | undefined;
  MaxDrainDurationSeconds?: number;
  DryRun?: boolean;
}
export interface DisassociateNatGatewayAddressResult {
  NatGatewayId?: string;
  NatGatewayAddresses?: NatGatewayAddress[];
}
export interface DisassociateRouteTableRequest {
  AssociationId: string | undefined;
  DryRun?: boolean;
}
export interface DisassociateSubnetCidrBlockRequest {
  AssociationId: string | undefined;
}
export interface DisassociateSubnetCidrBlockResult {
  Ipv6CidrBlockAssociation?: SubnetIpv6CidrBlockAssociation;
  SubnetId?: string;
}
export interface DisassociateTransitGatewayMulticastDomainRequest {
  TransitGatewayMulticastDomainId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  SubnetIds: string[] | undefined;
  DryRun?: boolean;
}
export interface DisassociateTransitGatewayMulticastDomainResult {
  Associations?: TransitGatewayMulticastDomainAssociations;
}
export interface DisassociateTransitGatewayPolicyTableRequest {
  TransitGatewayPolicyTableId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface DisassociateTransitGatewayPolicyTableResult {
  Association?: TransitGatewayPolicyTableAssociation;
}
export interface DisassociateTransitGatewayRouteTableRequest {
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface DisassociateTransitGatewayRouteTableResult {
  Association?: TransitGatewayAssociation;
}
export interface DisassociateTrunkInterfaceRequest {
  AssociationId: string | undefined;
  ClientToken?: string;
  DryRun?: boolean;
}
export interface DisassociateTrunkInterfaceResult {
  Return?: boolean;
  ClientToken?: string;
}
export interface DisassociateVpcCidrBlockRequest {
  AssociationId: string | undefined;
}
export interface DisassociateVpcCidrBlockResult {
  Ipv6CidrBlockAssociation?: VpcIpv6CidrBlockAssociation;
  CidrBlockAssociation?: VpcCidrBlockAssociation;
  VpcId?: string;
}
export interface EnableAddressTransferRequest {
  AllocationId: string | undefined;
  TransferAccountId: string | undefined;
  DryRun?: boolean;
}
export interface EnableAddressTransferResult {
  AddressTransfer?: AddressTransfer;
}
export interface EnableAwsNetworkPerformanceMetricSubscriptionRequest {
  Source?: string;
  Destination?: string;
  Metric?: MetricType;
  Statistic?: StatisticType;
  DryRun?: boolean;
}
export interface EnableAwsNetworkPerformanceMetricSubscriptionResult {
  Output?: boolean;
}
export interface EnableEbsEncryptionByDefaultRequest {
  DryRun?: boolean;
}
export interface EnableEbsEncryptionByDefaultResult {
  EbsEncryptionByDefault?: boolean;
}
export interface FastLaunchLaunchTemplateSpecificationRequest {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  Version: string | undefined;
}
export interface FastLaunchSnapshotConfigurationRequest {
  TargetResourceCount?: number;
}
export interface EnableFastLaunchRequest {
  ImageId: string | undefined;
  ResourceType?: string;
  SnapshotConfiguration?: FastLaunchSnapshotConfigurationRequest;
  LaunchTemplate?: FastLaunchLaunchTemplateSpecificationRequest;
  MaxParallelLaunches?: number;
  DryRun?: boolean;
}
export interface EnableFastLaunchResult {
  ImageId?: string;
  ResourceType?: FastLaunchResourceType;
  SnapshotConfiguration?: FastLaunchSnapshotConfigurationResponse;
  LaunchTemplate?: FastLaunchLaunchTemplateSpecificationResponse;
  MaxParallelLaunches?: number;
  OwnerId?: string;
  State?: FastLaunchStateCode;
  StateTransitionReason?: string;
  StateTransitionTime?: Date;
}
export interface EnableFastSnapshotRestoresRequest {
  AvailabilityZones: string[] | undefined;
  SourceSnapshotIds: string[] | undefined;
  DryRun?: boolean;
}
export interface EnableFastSnapshotRestoreSuccessItem {
  SnapshotId?: string;
  AvailabilityZone?: string;
  State?: FastSnapshotRestoreStateCode;
  StateTransitionReason?: string;
  OwnerId?: string;
  OwnerAlias?: string;
  EnablingTime?: Date;
  OptimizingTime?: Date;
  EnabledTime?: Date;
  DisablingTime?: Date;
  DisabledTime?: Date;
}
export interface EnableFastSnapshotRestoreStateError {
  Code?: string;
  Message?: string;
}
export interface EnableFastSnapshotRestoreStateErrorItem {
  AvailabilityZone?: string;
  Error?: EnableFastSnapshotRestoreStateError;
}
export interface EnableFastSnapshotRestoreErrorItem {
  SnapshotId?: string;
  FastSnapshotRestoreStateErrors?: EnableFastSnapshotRestoreStateErrorItem[];
}
export interface EnableFastSnapshotRestoresResult {
  Successful?: EnableFastSnapshotRestoreSuccessItem[];
  Unsuccessful?: EnableFastSnapshotRestoreErrorItem[];
}
export interface EnableImageRequest {
  ImageId: string | undefined;
  DryRun?: boolean;
}
export interface EnableImageResult {
  Return?: boolean;
}
export declare const ImageBlockPublicAccessEnabledState: {
  readonly block_new_sharing: "block-new-sharing";
};
export type ImageBlockPublicAccessEnabledState =
  (typeof ImageBlockPublicAccessEnabledState)[keyof typeof ImageBlockPublicAccessEnabledState];
export interface EnableImageBlockPublicAccessRequest {
  ImageBlockPublicAccessState: ImageBlockPublicAccessEnabledState | undefined;
  DryRun?: boolean;
}
export interface EnableImageBlockPublicAccessResult {
  ImageBlockPublicAccessState?: ImageBlockPublicAccessEnabledState;
}
export interface EnableImageDeprecationRequest {
  ImageId: string | undefined;
  DeprecateAt: Date | undefined;
  DryRun?: boolean;
}
export interface EnableImageDeprecationResult {
  Return?: boolean;
}
export interface EnableIpamOrganizationAdminAccountRequest {
  DryRun?: boolean;
  DelegatedAdminAccountId: string | undefined;
}
export interface EnableIpamOrganizationAdminAccountResult {
  Success?: boolean;
}
export interface EnableReachabilityAnalyzerOrganizationSharingRequest {
  DryRun?: boolean;
}
export interface EnableReachabilityAnalyzerOrganizationSharingResult {
  ReturnValue?: boolean;
}
export interface EnableSerialConsoleAccessRequest {
  DryRun?: boolean;
}
export interface EnableSerialConsoleAccessResult {
  SerialConsoleAccessEnabled?: boolean;
}
export interface EnableSnapshotBlockPublicAccessRequest {
  State: SnapshotBlockPublicAccessState | undefined;
  DryRun?: boolean;
}
export interface EnableSnapshotBlockPublicAccessResult {
  State?: SnapshotBlockPublicAccessState;
}
export interface EnableTransitGatewayRouteTablePropagationRequest {
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId?: string;
  DryRun?: boolean;
  TransitGatewayRouteTableAnnouncementId?: string;
}
export interface EnableTransitGatewayRouteTablePropagationResult {
  Propagation?: TransitGatewayPropagation;
}
export interface EnableVgwRoutePropagationRequest {
  GatewayId: string | undefined;
  RouteTableId: string | undefined;
  DryRun?: boolean;
}
export interface EnableVolumeIORequest {
  DryRun?: boolean;
  VolumeId: string | undefined;
}
export interface EnableVpcClassicLinkRequest {
  DryRun?: boolean;
  VpcId: string | undefined;
}
export interface EnableVpcClassicLinkResult {
  Return?: boolean;
}
export interface EnableVpcClassicLinkDnsSupportRequest {
  VpcId?: string;
}
export interface EnableVpcClassicLinkDnsSupportResult {
  Return?: boolean;
}
export interface ExportClientVpnClientCertificateRevocationListRequest {
  ClientVpnEndpointId: string | undefined;
  DryRun?: boolean;
}
export declare const ClientCertificateRevocationListStatusCode: {
  readonly active: "active";
  readonly pending: "pending";
};
export type ClientCertificateRevocationListStatusCode =
  (typeof ClientCertificateRevocationListStatusCode)[keyof typeof ClientCertificateRevocationListStatusCode];
export interface ClientCertificateRevocationListStatus {
  Code?: ClientCertificateRevocationListStatusCode;
  Message?: string;
}
export interface ExportClientVpnClientCertificateRevocationListResult {
  CertificateRevocationList?: string;
  Status?: ClientCertificateRevocationListStatus;
}
export interface ExportClientVpnClientConfigurationRequest {
  ClientVpnEndpointId: string | undefined;
  DryRun?: boolean;
}
export interface ExportClientVpnClientConfigurationResult {
  ClientConfiguration?: string;
}
export interface ExportTaskS3LocationRequest {
  S3Bucket: string | undefined;
  S3Prefix?: string;
}
export interface ExportImageRequest {
  ClientToken?: string;
  Description?: string;
  DiskImageFormat: DiskImageFormat | undefined;
  DryRun?: boolean;
  ImageId: string | undefined;
  S3ExportLocation: ExportTaskS3LocationRequest | undefined;
  RoleName?: string;
  TagSpecifications?: TagSpecification[];
}
export interface ExportImageResult {
  Description?: string;
  DiskImageFormat?: DiskImageFormat;
  ExportImageTaskId?: string;
  ImageId?: string;
  RoleName?: string;
  Progress?: string;
  S3ExportLocation?: ExportTaskS3Location;
  Status?: string;
  StatusMessage?: string;
  Tags?: Tag[];
}
export interface ExportTransitGatewayRoutesRequest {
  TransitGatewayRouteTableId: string | undefined;
  Filters?: Filter[];
  S3Bucket: string | undefined;
  DryRun?: boolean;
}
export interface ExportTransitGatewayRoutesResult {
  S3Location?: string;
}
export interface GetAssociatedEnclaveCertificateIamRolesRequest {
  CertificateArn: string | undefined;
  DryRun?: boolean;
}
export interface AssociatedRole {
  AssociatedRoleArn?: string;
  CertificateS3BucketName?: string;
  CertificateS3ObjectKey?: string;
  EncryptionKmsKeyId?: string;
}
export interface GetAssociatedEnclaveCertificateIamRolesResult {
  AssociatedRoles?: AssociatedRole[];
}
export interface GetAssociatedIpv6PoolCidrsRequest {
  PoolId: string | undefined;
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
}
export interface Ipv6CidrAssociation {
  Ipv6Cidr?: string;
  AssociatedResource?: string;
}
export interface GetAssociatedIpv6PoolCidrsResult {
  Ipv6CidrAssociations?: Ipv6CidrAssociation[];
  NextToken?: string;
}
export interface DataQuery {
  Id?: string;
  Source?: string;
  Destination?: string;
  Metric?: MetricType;
  Statistic?: StatisticType;
  Period?: PeriodType;
}
export interface GetAwsNetworkPerformanceDataRequest {
  DataQueries?: DataQuery[];
  StartTime?: Date;
  EndTime?: Date;
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface MetricPoint {
  StartDate?: Date;
  EndDate?: Date;
  Value?: number;
  Status?: string;
}
export interface DataResponse {
  Id?: string;
  Source?: string;
  Destination?: string;
  Metric?: MetricType;
  Statistic?: StatisticType;
  Period?: PeriodType;
  MetricPoints?: MetricPoint[];
}
export interface GetAwsNetworkPerformanceDataResult {
  DataResponses?: DataResponse[];
  NextToken?: string;
}
export interface GetCapacityReservationUsageRequest {
  CapacityReservationId: string | undefined;
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
}
export interface InstanceUsage {
  AccountId?: string;
  UsedInstanceCount?: number;
}
export interface GetCapacityReservationUsageResult {
  NextToken?: string;
  CapacityReservationId?: string;
  InstanceType?: string;
  TotalInstanceCount?: number;
  AvailableInstanceCount?: number;
  State?: CapacityReservationState;
  InstanceUsages?: InstanceUsage[];
}
export interface GetCoipPoolUsageRequest {
  PoolId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface CoipAddressUsage {
  AllocationId?: string;
  AwsAccountId?: string;
  AwsService?: string;
  CoIp?: string;
}
export interface GetCoipPoolUsageResult {
  CoipPoolId?: string;
  CoipAddressUsages?: CoipAddressUsage[];
  LocalGatewayRouteTableId?: string;
  NextToken?: string;
}
export interface GetConsoleOutputRequest {
  InstanceId: string | undefined;
  DryRun?: boolean;
  Latest?: boolean;
}
export interface GetConsoleOutputResult {
  InstanceId?: string;
  Output?: string;
  Timestamp?: Date;
}
export interface GetConsoleScreenshotRequest {
  DryRun?: boolean;
  InstanceId: string | undefined;
  WakeUp?: boolean;
}
export interface GetConsoleScreenshotResult {
  ImageData?: string;
  InstanceId?: string;
}
export declare const UnlimitedSupportedInstanceFamily: {
  readonly t2: "t2";
  readonly t3: "t3";
  readonly t3a: "t3a";
  readonly t4g: "t4g";
};
export type UnlimitedSupportedInstanceFamily =
  (typeof UnlimitedSupportedInstanceFamily)[keyof typeof UnlimitedSupportedInstanceFamily];
export interface GetDefaultCreditSpecificationRequest {
  DryRun?: boolean;
  InstanceFamily: UnlimitedSupportedInstanceFamily | undefined;
}
export interface InstanceFamilyCreditSpecification {
  InstanceFamily?: UnlimitedSupportedInstanceFamily;
  CpuCredits?: string;
}
export interface GetDefaultCreditSpecificationResult {
  InstanceFamilyCreditSpecification?: InstanceFamilyCreditSpecification;
}
export interface GetEbsDefaultKmsKeyIdRequest {
  DryRun?: boolean;
}
export interface GetEbsDefaultKmsKeyIdResult {
  KmsKeyId?: string;
}
export interface GetEbsEncryptionByDefaultRequest {
  DryRun?: boolean;
}
export interface GetEbsEncryptionByDefaultResult {
  EbsEncryptionByDefault?: boolean;
  SseType?: SSEType;
}
export declare const PartitionLoadFrequency: {
  readonly DAILY: "daily";
  readonly MONTHLY: "monthly";
  readonly NONE: "none";
  readonly WEEKLY: "weekly";
};
export type PartitionLoadFrequency =
  (typeof PartitionLoadFrequency)[keyof typeof PartitionLoadFrequency];
export interface AthenaIntegration {
  IntegrationResultS3DestinationArn: string | undefined;
  PartitionLoadFrequency: PartitionLoadFrequency | undefined;
  PartitionStartDate?: Date;
  PartitionEndDate?: Date;
}
export interface IntegrateServices {
  AthenaIntegrations?: AthenaIntegration[];
}
export interface GetFlowLogsIntegrationTemplateRequest {
  DryRun?: boolean;
  FlowLogId: string | undefined;
  ConfigDeliveryS3DestinationArn: string | undefined;
  IntegrateServices: IntegrateServices | undefined;
}
export interface GetFlowLogsIntegrationTemplateResult {
  Result?: string;
}
export interface GetGroupsForCapacityReservationRequest {
  CapacityReservationId: string | undefined;
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
}
export interface CapacityReservationGroup {
  GroupArn?: string;
  OwnerId?: string;
}
export interface GetGroupsForCapacityReservationResult {
  NextToken?: string;
  CapacityReservationGroups?: CapacityReservationGroup[];
}
export interface GetHostReservationPurchasePreviewRequest {
  HostIdSet: string[] | undefined;
  OfferingId: string | undefined;
}
export interface Purchase {
  CurrencyCode?: CurrencyCodeValues;
  Duration?: number;
  HostIdSet?: string[];
  HostReservationId?: string;
  HourlyPrice?: string;
  InstanceFamily?: string;
  PaymentOption?: PaymentOption;
  UpfrontPrice?: string;
}
export interface GetHostReservationPurchasePreviewResult {
  CurrencyCode?: CurrencyCodeValues;
  Purchase?: Purchase[];
  TotalHourlyPrice?: string;
  TotalUpfrontPrice?: string;
}
export interface GetImageBlockPublicAccessStateRequest {
  DryRun?: boolean;
}
export interface GetImageBlockPublicAccessStateResult {
  ImageBlockPublicAccessState?: string;
}
export interface GetInstanceTypesFromInstanceRequirementsRequest {
  DryRun?: boolean;
  ArchitectureTypes: ArchitectureType[] | undefined;
  VirtualizationTypes: VirtualizationType[] | undefined;
  InstanceRequirements: InstanceRequirementsRequest | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface InstanceTypeInfoFromInstanceRequirements {
  InstanceType?: string;
}
export interface GetInstanceTypesFromInstanceRequirementsResult {
  InstanceTypes?: InstanceTypeInfoFromInstanceRequirements[];
  NextToken?: string;
}
export interface GetInstanceUefiDataRequest {
  InstanceId: string | undefined;
  DryRun?: boolean;
}
export interface GetInstanceUefiDataResult {
  InstanceId?: string;
  UefiData?: string;
}
export interface GetIpamAddressHistoryRequest {
  DryRun?: boolean;
  Cidr: string | undefined;
  IpamScopeId: string | undefined;
  VpcId?: string;
  StartTime?: Date;
  EndTime?: Date;
  MaxResults?: number;
  NextToken?: string;
}
export declare const IpamComplianceStatus: {
  readonly compliant: "compliant";
  readonly ignored: "ignored";
  readonly noncompliant: "noncompliant";
  readonly unmanaged: "unmanaged";
};
export type IpamComplianceStatus =
  (typeof IpamComplianceStatus)[keyof typeof IpamComplianceStatus];
export declare const IpamOverlapStatus: {
  readonly ignored: "ignored";
  readonly nonoverlapping: "nonoverlapping";
  readonly overlapping: "overlapping";
};
export type IpamOverlapStatus =
  (typeof IpamOverlapStatus)[keyof typeof IpamOverlapStatus];
export declare const IpamAddressHistoryResourceType: {
  readonly eip: "eip";
  readonly instance: "instance";
  readonly network_interface: "network-interface";
  readonly subnet: "subnet";
  readonly vpc: "vpc";
};
export type IpamAddressHistoryResourceType =
  (typeof IpamAddressHistoryResourceType)[keyof typeof IpamAddressHistoryResourceType];
export interface IpamAddressHistoryRecord {
  ResourceOwnerId?: string;
  ResourceRegion?: string;
  ResourceType?: IpamAddressHistoryResourceType;
  ResourceId?: string;
  ResourceCidr?: string;
  ResourceName?: string;
  ResourceComplianceStatus?: IpamComplianceStatus;
  ResourceOverlapStatus?: IpamOverlapStatus;
  VpcId?: string;
  SampledStartTime?: Date;
  SampledEndTime?: Date;
}
export interface GetIpamAddressHistoryResult {
  HistoryRecords?: IpamAddressHistoryRecord[];
  NextToken?: string;
}
export interface GetIpamDiscoveredAccountsRequest {
  DryRun?: boolean;
  IpamResourceDiscoveryId: string | undefined;
  DiscoveryRegion: string | undefined;
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
}
export declare const IpamDiscoveryFailureCode: {
  readonly assume_role_failure: "assume-role-failure";
  readonly throttling_failure: "throttling-failure";
  readonly unauthorized_failure: "unauthorized-failure";
};
export type IpamDiscoveryFailureCode =
  (typeof IpamDiscoveryFailureCode)[keyof typeof IpamDiscoveryFailureCode];
export interface IpamDiscoveryFailureReason {
  Code?: IpamDiscoveryFailureCode;
  Message?: string;
}
export interface IpamDiscoveredAccount {
  AccountId?: string;
  DiscoveryRegion?: string;
  FailureReason?: IpamDiscoveryFailureReason;
  LastAttemptedDiscoveryTime?: Date;
  LastSuccessfulDiscoveryTime?: Date;
}
export interface GetIpamDiscoveredAccountsResult {
  IpamDiscoveredAccounts?: IpamDiscoveredAccount[];
  NextToken?: string;
}
export interface GetIpamDiscoveredPublicAddressesRequest {
  DryRun?: boolean;
  IpamResourceDiscoveryId: string | undefined;
  AddressRegion: string | undefined;
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
}
export declare const IpamPublicAddressType: {
  readonly AMAZON_OWNED_EIP: "amazon-owned-eip";
  readonly BYOIP: "byoip";
  readonly EC2_PUBLIC_IP: "ec2-public-ip";
  readonly SERVICE_MANAGED_BYOIP: "service-managed-byoip";
  readonly SERVICE_MANAGED_IP: "service-managed-ip";
};
export type IpamPublicAddressType =
  (typeof IpamPublicAddressType)[keyof typeof IpamPublicAddressType];
export declare const IpamPublicAddressAssociationStatus: {
  readonly ASSOCIATED: "associated";
  readonly DISASSOCIATED: "disassociated";
};
export type IpamPublicAddressAssociationStatus =
  (typeof IpamPublicAddressAssociationStatus)[keyof typeof IpamPublicAddressAssociationStatus];
export interface IpamPublicAddressSecurityGroup {
  GroupName?: string;
  GroupId?: string;
}
export declare const IpamPublicAddressAwsService: {
  readonly AGA: "global-accelerator";
  readonly DMS: "database-migration-service";
  readonly EC2_LB: "load-balancer";
  readonly ECS: "elastic-container-service";
  readonly NAT_GATEWAY: "nat-gateway";
  readonly OTHER: "other";
  readonly RDS: "relational-database-service";
  readonly REDSHIFT: "redshift";
  readonly S2S_VPN: "site-to-site-vpn";
};
export type IpamPublicAddressAwsService =
  (typeof IpamPublicAddressAwsService)[keyof typeof IpamPublicAddressAwsService];
export interface IpamPublicAddressTag {
  Key?: string;
  Value?: string;
}
export interface IpamPublicAddressTags {
  EipTags?: IpamPublicAddressTag[];
}
export interface IpamDiscoveredPublicAddress {
  IpamResourceDiscoveryId?: string;
  AddressRegion?: string;
  Address?: string;
  AddressOwnerId?: string;
  AddressAllocationId?: string;
  AssociationStatus?: IpamPublicAddressAssociationStatus;
  AddressType?: IpamPublicAddressType;
  Service?: IpamPublicAddressAwsService;
  ServiceResource?: string;
  VpcId?: string;
  SubnetId?: string;
  PublicIpv4PoolId?: string;
  NetworkInterfaceId?: string;
  NetworkInterfaceDescription?: string;
  InstanceId?: string;
  Tags?: IpamPublicAddressTags;
  NetworkBorderGroup?: string;
  SecurityGroups?: IpamPublicAddressSecurityGroup[];
  SampleTime?: Date;
}
export interface GetIpamDiscoveredPublicAddressesResult {
  IpamDiscoveredPublicAddresses?: IpamDiscoveredPublicAddress[];
  OldestSampleTime?: Date;
  NextToken?: string;
}
export declare const DescribeVerifiedAccessTrustProvidersResultFilterSensitiveLog: (
  obj: DescribeVerifiedAccessTrustProvidersResult
) => any;
export declare const DescribeVpnConnectionsResultFilterSensitiveLog: (
  obj: DescribeVpnConnectionsResult
) => any;
export declare const DetachVerifiedAccessTrustProviderResultFilterSensitiveLog: (
  obj: DetachVerifiedAccessTrustProviderResult
) => any;
