import {
  _InstanceType,
  AccessScopeAnalysisFinding,
  AddedPrincipal,
  AddIpamOperatingRegion,
  AddPrefixListEntry,
  AddressAttribute,
  Affinity,
  ApplianceModeSupportValue,
  AutoPlacement,
  ByoipCidr,
  CapacityReservation,
  CapacityReservationInstancePlatform,
  CurrencyCodeValues,
  DnsSupportValue,
  EnaSrdSpecification,
  EndDateType,
  HostMaintenance,
  HostRecovery,
  InstanceEventWindow,
  IpamPoolAllocation,
  Ipv6SupportValue,
  SecurityGroupReferencingSupportValue,
  SubnetAssociation,
  Tag,
  TagSpecification,
  TargetConfigurationRequest,
  TransitGatewayAssociationState,
  TransitGatewayAttachmentResourceType,
  TransitGatewayPolicyTableAssociation,
  TransitGatewayVpcAttachment,
  UnsuccessfulItem,
  VerifiedAccessInstance,
  VerifiedAccessSseSpecificationResponse,
  VerifiedAccessTrustProvider,
} from "./models_0";
import {
  AttributeValue,
  BlockDeviceMapping,
  CapacityReservationPreference,
  CapacityReservationTarget,
  ClientConnectOptions,
  ClientLoginBannerOptions,
  ConnectionLogOptions,
  ConnectionTrackingSpecificationRequest,
  DiskImageFormat,
  FleetExcessCapacityTerminationPolicy,
  FleetLaunchTemplateConfigRequest,
  HostnameType,
  InstanceEventWindowTimeRangeRequest,
  InstanceRequirementsRequest,
  Ipam,
  IpamPool,
  IpamResourceDiscovery,
  IpamResourceTag,
  IpamScope,
  IpamTier,
  LaunchTemplate,
  LocalGatewayRoute,
  ManagedPrefixList,
  NetworkInsightsAccessScopeContent,
  Placement,
  PlatformValues,
  RequestIpamResourceTag,
  ResponseLaunchTemplateData,
  SelfServicePortal,
  ShutdownBehavior,
  TargetCapacitySpecificationRequest,
  TargetCapacityUnitType,
  VolumeType,
} from "./models_1";
import {
  AutoAcceptSharedAttachmentsValue,
  DefaultRouteTableAssociationValue,
  DefaultRouteTablePropagationValue,
  DnsOptionsSpecification,
  IKEVersionsRequestListValue,
  IpAddressType,
  PayerResponsibility,
  Phase1DHGroupNumbersRequestListValue,
  Phase1EncryptionAlgorithmsRequestListValue,
  Phase1IntegrityAlgorithmsRequestListValue,
  Phase2DHGroupNumbersRequestListValue,
  Phase2EncryptionAlgorithmsRequestListValue,
  Phase2IntegrityAlgorithmsRequestListValue,
  SubnetCidrReservation,
  SubnetConfiguration,
  TrafficDirection,
  TrafficMirrorFilter,
  TrafficMirrorFilterRule,
  TrafficMirrorNetworkService,
  TrafficMirrorPortRangeRequest,
  TrafficMirrorRuleAction,
  TrafficMirrorSession,
  TransitGateway,
  TransitGatewayPrefixListReference,
  VerifiedAccessEndpoint,
  VerifiedAccessEndpointProtocol,
  VerifiedAccessGroup,
  VerifiedAccessSseSpecificationRequest,
  VpnConnection,
  VpnEcmpSupportValue,
  VpnTunnelLogOptionsSpecification,
} from "./models_2";
import {
  ArchitectureValues,
  BootModeValues,
  Byoasn,
  ConversionTask,
  Filter,
  FpgaImageAttribute,
  FpgaImageAttributeName,
  ImdsSupportValues,
  ImportImageLicenseConfigurationResponse,
  IpamPoolCidr,
  LaunchPermission,
  PermissionGroup,
  SnapshotDetail,
  TpmSupportValues,
  VirtualizationType,
} from "./models_3";
import {
  AnalysisStatus,
  ArchitectureType,
  AttributeBooleanValue,
  CreateVolumePermission,
  ExcessCapacityTerminationPolicy,
  HttpTokensState,
  InstanceAttributeName,
  InstanceAutoRecoveryState,
  InstanceMetadataEndpointState,
  InstanceMetadataOptionsResponse,
  InstanceMetadataProtocolState,
  InstanceMetadataTagsState,
  InstanceStatusEvent,
  LaunchTemplateConfig,
  LockState,
  Monitoring,
  PublicIpv4PoolRange,
  ReservedInstancesConfiguration,
  ScheduledInstance,
  SnapshotAttributeName,
  SnapshotTaskDetail,
} from "./models_4";
import {
  InstanceFamilyCreditSpecification,
  IpamComplianceStatus,
  IpamOverlapStatus,
  Purchase,
  SnapshotBlockPublicAccessState,
  TransitGatewayPropagationState,
  UnlimitedSupportedInstanceFamily,
  VerifiedAccessInstanceLoggingConfiguration,
  VolumeModification,
} from "./models_5";
export interface GetIpamDiscoveredResourceCidrsRequest {
  DryRun?: boolean;
  IpamResourceDiscoveryId: string | undefined;
  ResourceRegion: string | undefined;
  Filters?: Filter[];
  NextToken?: string;
  MaxResults?: number;
}
export declare const IpamResourceType: {
  readonly eip: "eip";
  readonly eni: "eni";
  readonly ipv6_pool: "ipv6-pool";
  readonly public_ipv4_pool: "public-ipv4-pool";
  readonly subnet: "subnet";
  readonly vpc: "vpc";
};
export type IpamResourceType =
  (typeof IpamResourceType)[keyof typeof IpamResourceType];
export interface IpamDiscoveredResourceCidr {
  IpamResourceDiscoveryId?: string;
  ResourceRegion?: string;
  ResourceId?: string;
  ResourceOwnerId?: string;
  ResourceCidr?: string;
  ResourceType?: IpamResourceType;
  ResourceTags?: IpamResourceTag[];
  IpUsage?: number;
  VpcId?: string;
  SampleTime?: Date;
}
export interface GetIpamDiscoveredResourceCidrsResult {
  IpamDiscoveredResourceCidrs?: IpamDiscoveredResourceCidr[];
  NextToken?: string;
}
export interface GetIpamPoolAllocationsRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  IpamPoolAllocationId?: string;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface GetIpamPoolAllocationsResult {
  IpamPoolAllocations?: IpamPoolAllocation[];
  NextToken?: string;
}
export interface GetIpamPoolCidrsRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface GetIpamPoolCidrsResult {
  IpamPoolCidrs?: IpamPoolCidr[];
  NextToken?: string;
}
export interface GetIpamResourceCidrsRequest {
  DryRun?: boolean;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  IpamScopeId: string | undefined;
  IpamPoolId?: string;
  ResourceId?: string;
  ResourceType?: IpamResourceType;
  ResourceTag?: RequestIpamResourceTag;
  ResourceOwner?: string;
}
export declare const IpamManagementState: {
  readonly ignored: "ignored";
  readonly managed: "managed";
  readonly unmanaged: "unmanaged";
};
export type IpamManagementState =
  (typeof IpamManagementState)[keyof typeof IpamManagementState];
export interface IpamResourceCidr {
  IpamId?: string;
  IpamScopeId?: string;
  IpamPoolId?: string;
  ResourceRegion?: string;
  ResourceOwnerId?: string;
  ResourceId?: string;
  ResourceName?: string;
  ResourceCidr?: string;
  ResourceType?: IpamResourceType;
  ResourceTags?: IpamResourceTag[];
  IpUsage?: number;
  ComplianceStatus?: IpamComplianceStatus;
  ManagementState?: IpamManagementState;
  OverlapStatus?: IpamOverlapStatus;
  VpcId?: string;
}
export interface GetIpamResourceCidrsResult {
  NextToken?: string;
  IpamResourceCidrs?: IpamResourceCidr[];
}
export interface GetLaunchTemplateDataRequest {
  DryRun?: boolean;
  InstanceId: string | undefined;
}
export interface GetLaunchTemplateDataResult {
  LaunchTemplateData?: ResponseLaunchTemplateData;
}
export interface GetManagedPrefixListAssociationsRequest {
  DryRun?: boolean;
  PrefixListId: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface PrefixListAssociation {
  ResourceId?: string;
  ResourceOwner?: string;
}
export interface GetManagedPrefixListAssociationsResult {
  PrefixListAssociations?: PrefixListAssociation[];
  NextToken?: string;
}
export interface GetManagedPrefixListEntriesRequest {
  DryRun?: boolean;
  PrefixListId: string | undefined;
  TargetVersion?: number;
  MaxResults?: number;
  NextToken?: string;
}
export interface PrefixListEntry {
  Cidr?: string;
  Description?: string;
}
export interface GetManagedPrefixListEntriesResult {
  Entries?: PrefixListEntry[];
  NextToken?: string;
}
export interface GetNetworkInsightsAccessScopeAnalysisFindingsRequest {
  NetworkInsightsAccessScopeAnalysisId: string | undefined;
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface GetNetworkInsightsAccessScopeAnalysisFindingsResult {
  NetworkInsightsAccessScopeAnalysisId?: string;
  AnalysisStatus?: AnalysisStatus;
  AnalysisFindings?: AccessScopeAnalysisFinding[];
  NextToken?: string;
}
export interface GetNetworkInsightsAccessScopeContentRequest {
  NetworkInsightsAccessScopeId: string | undefined;
  DryRun?: boolean;
}
export interface GetNetworkInsightsAccessScopeContentResult {
  NetworkInsightsAccessScopeContent?: NetworkInsightsAccessScopeContent;
}
export interface GetPasswordDataRequest {
  InstanceId: string | undefined;
  DryRun?: boolean;
}
export interface GetPasswordDataResult {
  InstanceId?: string;
  PasswordData?: string;
  Timestamp?: Date;
}
export interface GetReservedInstancesExchangeQuoteRequest {
  DryRun?: boolean;
  ReservedInstanceIds: string[] | undefined;
  TargetConfigurations?: TargetConfigurationRequest[];
}
export interface ReservationValue {
  HourlyPrice?: string;
  RemainingTotalValue?: string;
  RemainingUpfrontValue?: string;
}
export interface ReservedInstanceReservationValue {
  ReservationValue?: ReservationValue;
  ReservedInstanceId?: string;
}
export interface TargetConfiguration {
  InstanceCount?: number;
  OfferingId?: string;
}
export interface TargetReservationValue {
  ReservationValue?: ReservationValue;
  TargetConfiguration?: TargetConfiguration;
}
export interface GetReservedInstancesExchangeQuoteResult {
  CurrencyCode?: string;
  IsValidExchange?: boolean;
  OutputReservedInstancesWillExpireAt?: Date;
  PaymentDue?: string;
  ReservedInstanceValueRollup?: ReservationValue;
  ReservedInstanceValueSet?: ReservedInstanceReservationValue[];
  TargetConfigurationValueRollup?: ReservationValue;
  TargetConfigurationValueSet?: TargetReservationValue[];
  ValidationFailureReason?: string;
}
export interface GetSecurityGroupsForVpcRequest {
  VpcId: string | undefined;
  NextToken?: string;
  MaxResults?: number;
  Filters?: Filter[];
  DryRun?: boolean;
}
export interface SecurityGroupForVpc {
  Description?: string;
  GroupName?: string;
  OwnerId?: string;
  GroupId?: string;
  Tags?: Tag[];
  PrimaryVpcId?: string;
}
export interface GetSecurityGroupsForVpcResult {
  NextToken?: string;
  SecurityGroupForVpcs?: SecurityGroupForVpc[];
}
export interface GetSerialConsoleAccessStatusRequest {
  DryRun?: boolean;
}
export interface GetSerialConsoleAccessStatusResult {
  SerialConsoleAccessEnabled?: boolean;
}
export interface GetSnapshotBlockPublicAccessStateRequest {
  DryRun?: boolean;
}
export interface GetSnapshotBlockPublicAccessStateResult {
  State?: SnapshotBlockPublicAccessState;
}
export interface InstanceRequirementsWithMetadataRequest {
  ArchitectureTypes?: ArchitectureType[];
  VirtualizationTypes?: VirtualizationType[];
  InstanceRequirements?: InstanceRequirementsRequest;
}
export interface GetSpotPlacementScoresRequest {
  InstanceTypes?: string[];
  TargetCapacity: number | undefined;
  TargetCapacityUnitType?: TargetCapacityUnitType;
  SingleAvailabilityZone?: boolean;
  RegionNames?: string[];
  InstanceRequirementsWithMetadata?: InstanceRequirementsWithMetadataRequest;
  DryRun?: boolean;
  MaxResults?: number;
  NextToken?: string;
}
export interface SpotPlacementScore {
  Region?: string;
  AvailabilityZoneId?: string;
  Score?: number;
}
export interface GetSpotPlacementScoresResult {
  SpotPlacementScores?: SpotPlacementScore[];
  NextToken?: string;
}
export interface GetSubnetCidrReservationsRequest {
  Filters?: Filter[];
  SubnetId: string | undefined;
  DryRun?: boolean;
  NextToken?: string;
  MaxResults?: number;
}
export interface GetSubnetCidrReservationsResult {
  SubnetIpv4CidrReservations?: SubnetCidrReservation[];
  SubnetIpv6CidrReservations?: SubnetCidrReservation[];
  NextToken?: string;
}
export interface GetTransitGatewayAttachmentPropagationsRequest {
  TransitGatewayAttachmentId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface TransitGatewayAttachmentPropagation {
  TransitGatewayRouteTableId?: string;
  State?: TransitGatewayPropagationState;
}
export interface GetTransitGatewayAttachmentPropagationsResult {
  TransitGatewayAttachmentPropagations?: TransitGatewayAttachmentPropagation[];
  NextToken?: string;
}
export interface GetTransitGatewayMulticastDomainAssociationsRequest {
  TransitGatewayMulticastDomainId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface TransitGatewayMulticastDomainAssociation {
  TransitGatewayAttachmentId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType;
  ResourceOwnerId?: string;
  Subnet?: SubnetAssociation;
}
export interface GetTransitGatewayMulticastDomainAssociationsResult {
  MulticastDomainAssociations?: TransitGatewayMulticastDomainAssociation[];
  NextToken?: string;
}
export interface GetTransitGatewayPolicyTableAssociationsRequest {
  TransitGatewayPolicyTableId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface GetTransitGatewayPolicyTableAssociationsResult {
  Associations?: TransitGatewayPolicyTableAssociation[];
  NextToken?: string;
}
export interface GetTransitGatewayPolicyTableEntriesRequest {
  TransitGatewayPolicyTableId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface TransitGatewayPolicyRuleMetaData {
  MetaDataKey?: string;
  MetaDataValue?: string;
}
export interface TransitGatewayPolicyRule {
  SourceCidrBlock?: string;
  SourcePortRange?: string;
  DestinationCidrBlock?: string;
  DestinationPortRange?: string;
  Protocol?: string;
  MetaData?: TransitGatewayPolicyRuleMetaData;
}
export interface TransitGatewayPolicyTableEntry {
  PolicyRuleNumber?: string;
  PolicyRule?: TransitGatewayPolicyRule;
  TargetRouteTableId?: string;
}
export interface GetTransitGatewayPolicyTableEntriesResult {
  TransitGatewayPolicyTableEntries?: TransitGatewayPolicyTableEntry[];
}
export interface GetTransitGatewayPrefixListReferencesRequest {
  TransitGatewayRouteTableId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface GetTransitGatewayPrefixListReferencesResult {
  TransitGatewayPrefixListReferences?: TransitGatewayPrefixListReference[];
  NextToken?: string;
}
export interface GetTransitGatewayRouteTableAssociationsRequest {
  TransitGatewayRouteTableId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface TransitGatewayRouteTableAssociation {
  TransitGatewayAttachmentId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType;
  State?: TransitGatewayAssociationState;
}
export interface GetTransitGatewayRouteTableAssociationsResult {
  Associations?: TransitGatewayRouteTableAssociation[];
  NextToken?: string;
}
export interface GetTransitGatewayRouteTablePropagationsRequest {
  TransitGatewayRouteTableId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface TransitGatewayRouteTablePropagation {
  TransitGatewayAttachmentId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType;
  State?: TransitGatewayPropagationState;
  TransitGatewayRouteTableAnnouncementId?: string;
}
export interface GetTransitGatewayRouteTablePropagationsResult {
  TransitGatewayRouteTablePropagations?: TransitGatewayRouteTablePropagation[];
  NextToken?: string;
}
export interface GetVerifiedAccessEndpointPolicyRequest {
  VerifiedAccessEndpointId: string | undefined;
  DryRun?: boolean;
}
export interface GetVerifiedAccessEndpointPolicyResult {
  PolicyEnabled?: boolean;
  PolicyDocument?: string;
}
export interface GetVerifiedAccessGroupPolicyRequest {
  VerifiedAccessGroupId: string | undefined;
  DryRun?: boolean;
}
export interface GetVerifiedAccessGroupPolicyResult {
  PolicyEnabled?: boolean;
  PolicyDocument?: string;
}
export interface GetVpnConnectionDeviceSampleConfigurationRequest {
  VpnConnectionId: string | undefined;
  VpnConnectionDeviceTypeId: string | undefined;
  InternetKeyExchangeVersion?: string;
  DryRun?: boolean;
}
export interface GetVpnConnectionDeviceSampleConfigurationResult {
  VpnConnectionDeviceSampleConfiguration?: string;
}
export interface GetVpnConnectionDeviceTypesRequest {
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface VpnConnectionDeviceType {
  VpnConnectionDeviceTypeId?: string;
  Vendor?: string;
  Platform?: string;
  Software?: string;
}
export interface GetVpnConnectionDeviceTypesResult {
  VpnConnectionDeviceTypes?: VpnConnectionDeviceType[];
  NextToken?: string;
}
export interface GetVpnTunnelReplacementStatusRequest {
  VpnConnectionId: string | undefined;
  VpnTunnelOutsideIpAddress: string | undefined;
  DryRun?: boolean;
}
export interface MaintenanceDetails {
  PendingMaintenance?: string;
  MaintenanceAutoAppliedAfter?: Date;
  LastMaintenanceApplied?: Date;
}
export interface GetVpnTunnelReplacementStatusResult {
  VpnConnectionId?: string;
  TransitGatewayId?: string;
  CustomerGatewayId?: string;
  VpnGatewayId?: string;
  VpnTunnelOutsideIpAddress?: string;
  MaintenanceDetails?: MaintenanceDetails;
}
export interface ImportClientVpnClientCertificateRevocationListRequest {
  ClientVpnEndpointId: string | undefined;
  CertificateRevocationList: string | undefined;
  DryRun?: boolean;
}
export interface ImportClientVpnClientCertificateRevocationListResult {
  Return?: boolean;
}
export interface ClientData {
  Comment?: string;
  UploadEnd?: Date;
  UploadSize?: number;
  UploadStart?: Date;
}
export interface UserBucket {
  S3Bucket?: string;
  S3Key?: string;
}
export interface ImageDiskContainer {
  Description?: string;
  DeviceName?: string;
  Format?: string;
  SnapshotId?: string;
  Url?: string;
  UserBucket?: UserBucket;
}
export interface ImportImageLicenseConfigurationRequest {
  LicenseConfigurationArn?: string;
}
export interface ImportImageRequest {
  Architecture?: string;
  ClientData?: ClientData;
  ClientToken?: string;
  Description?: string;
  DiskContainers?: ImageDiskContainer[];
  DryRun?: boolean;
  Encrypted?: boolean;
  Hypervisor?: string;
  KmsKeyId?: string;
  LicenseType?: string;
  Platform?: string;
  RoleName?: string;
  LicenseSpecifications?: ImportImageLicenseConfigurationRequest[];
  TagSpecifications?: TagSpecification[];
  UsageOperation?: string;
  BootMode?: BootModeValues;
}
export interface ImportImageResult {
  Architecture?: string;
  Description?: string;
  Encrypted?: boolean;
  Hypervisor?: string;
  ImageId?: string;
  ImportTaskId?: string;
  KmsKeyId?: string;
  LicenseType?: string;
  Platform?: string;
  Progress?: string;
  SnapshotDetails?: SnapshotDetail[];
  Status?: string;
  StatusMessage?: string;
  LicenseSpecifications?: ImportImageLicenseConfigurationResponse[];
  Tags?: Tag[];
  UsageOperation?: string;
}
export interface DiskImageDetail {
  Bytes: number | undefined;
  Format: DiskImageFormat | undefined;
  ImportManifestUrl: string | undefined;
}
export interface VolumeDetail {
  Size: number | undefined;
}
export interface DiskImage {
  Description?: string;
  Image?: DiskImageDetail;
  Volume?: VolumeDetail;
}
export interface UserData {
  Data?: string;
}
export interface ImportInstanceLaunchSpecification {
  AdditionalInfo?: string;
  Architecture?: ArchitectureValues;
  GroupIds?: string[];
  GroupNames?: string[];
  InstanceInitiatedShutdownBehavior?: ShutdownBehavior;
  InstanceType?: _InstanceType;
  Monitoring?: boolean;
  Placement?: Placement;
  PrivateIpAddress?: string;
  SubnetId?: string;
  UserData?: UserData;
}
export interface ImportInstanceRequest {
  Description?: string;
  DiskImages?: DiskImage[];
  DryRun?: boolean;
  LaunchSpecification?: ImportInstanceLaunchSpecification;
  Platform: PlatformValues | undefined;
}
export interface ImportInstanceResult {
  ConversionTask?: ConversionTask;
}
export interface ImportKeyPairRequest {
  DryRun?: boolean;
  KeyName: string | undefined;
  PublicKeyMaterial: Uint8Array | undefined;
  TagSpecifications?: TagSpecification[];
}
export interface ImportKeyPairResult {
  KeyFingerprint?: string;
  KeyName?: string;
  KeyPairId?: string;
  Tags?: Tag[];
}
export interface SnapshotDiskContainer {
  Description?: string;
  Format?: string;
  Url?: string;
  UserBucket?: UserBucket;
}
export interface ImportSnapshotRequest {
  ClientData?: ClientData;
  ClientToken?: string;
  Description?: string;
  DiskContainer?: SnapshotDiskContainer;
  DryRun?: boolean;
  Encrypted?: boolean;
  KmsKeyId?: string;
  RoleName?: string;
  TagSpecifications?: TagSpecification[];
}
export interface ImportSnapshotResult {
  Description?: string;
  ImportTaskId?: string;
  SnapshotTaskDetail?: SnapshotTaskDetail;
  Tags?: Tag[];
}
export interface ImportVolumeRequest {
  AvailabilityZone: string | undefined;
  Description?: string;
  DryRun?: boolean;
  Image: DiskImageDetail | undefined;
  Volume: VolumeDetail | undefined;
}
export interface ImportVolumeResult {
  ConversionTask?: ConversionTask;
}
export interface ListImagesInRecycleBinRequest {
  ImageIds?: string[];
  NextToken?: string;
  MaxResults?: number;
  DryRun?: boolean;
}
export interface ImageRecycleBinInfo {
  ImageId?: string;
  Name?: string;
  Description?: string;
  RecycleBinEnterTime?: Date;
  RecycleBinExitTime?: Date;
}
export interface ListImagesInRecycleBinResult {
  Images?: ImageRecycleBinInfo[];
  NextToken?: string;
}
export interface ListSnapshotsInRecycleBinRequest {
  MaxResults?: number;
  NextToken?: string;
  SnapshotIds?: string[];
  DryRun?: boolean;
}
export interface SnapshotRecycleBinInfo {
  SnapshotId?: string;
  RecycleBinEnterTime?: Date;
  RecycleBinExitTime?: Date;
  Description?: string;
  VolumeId?: string;
}
export interface ListSnapshotsInRecycleBinResult {
  Snapshots?: SnapshotRecycleBinInfo[];
  NextToken?: string;
}
export declare const LockMode: {
  readonly compliance: "compliance";
  readonly governance: "governance";
};
export type LockMode = (typeof LockMode)[keyof typeof LockMode];
export interface LockSnapshotRequest {
  SnapshotId: string | undefined;
  DryRun?: boolean;
  LockMode: LockMode | undefined;
  CoolOffPeriod?: number;
  LockDuration?: number;
  ExpirationDate?: Date;
}
export interface LockSnapshotResult {
  SnapshotId?: string;
  LockState?: LockState;
  LockDuration?: number;
  CoolOffPeriod?: number;
  CoolOffPeriodExpiresOn?: Date;
  LockCreatedOn?: Date;
  LockExpiresOn?: Date;
  LockDurationStartTime?: Date;
}
export interface ModifyAddressAttributeRequest {
  AllocationId: string | undefined;
  DomainName?: string;
  DryRun?: boolean;
}
export interface ModifyAddressAttributeResult {
  Address?: AddressAttribute;
}
export declare const ModifyAvailabilityZoneOptInStatus: {
  readonly not_opted_in: "not-opted-in";
  readonly opted_in: "opted-in";
};
export type ModifyAvailabilityZoneOptInStatus =
  (typeof ModifyAvailabilityZoneOptInStatus)[keyof typeof ModifyAvailabilityZoneOptInStatus];
export interface ModifyAvailabilityZoneGroupRequest {
  GroupName: string | undefined;
  OptInStatus: ModifyAvailabilityZoneOptInStatus | undefined;
  DryRun?: boolean;
}
export interface ModifyAvailabilityZoneGroupResult {
  Return?: boolean;
}
export interface ModifyCapacityReservationRequest {
  CapacityReservationId: string | undefined;
  InstanceCount?: number;
  EndDate?: Date;
  EndDateType?: EndDateType;
  Accept?: boolean;
  DryRun?: boolean;
  AdditionalInfo?: string;
}
export interface ModifyCapacityReservationResult {
  Return?: boolean;
}
export interface ModifyCapacityReservationFleetRequest {
  CapacityReservationFleetId: string | undefined;
  TotalTargetCapacity?: number;
  EndDate?: Date;
  DryRun?: boolean;
  RemoveEndDate?: boolean;
}
export interface ModifyCapacityReservationFleetResult {
  Return?: boolean;
}
export interface DnsServersOptionsModifyStructure {
  CustomDnsServers?: string[];
  Enabled?: boolean;
}
export interface ModifyClientVpnEndpointRequest {
  ClientVpnEndpointId: string | undefined;
  ServerCertificateArn?: string;
  ConnectionLogOptions?: ConnectionLogOptions;
  DnsServers?: DnsServersOptionsModifyStructure;
  VpnPort?: number;
  Description?: string;
  SplitTunnel?: boolean;
  DryRun?: boolean;
  SecurityGroupIds?: string[];
  VpcId?: string;
  SelfServicePortal?: SelfServicePortal;
  ClientConnectOptions?: ClientConnectOptions;
  SessionTimeoutHours?: number;
  ClientLoginBannerOptions?: ClientLoginBannerOptions;
}
export interface ModifyClientVpnEndpointResult {
  Return?: boolean;
}
export interface ModifyDefaultCreditSpecificationRequest {
  DryRun?: boolean;
  InstanceFamily: UnlimitedSupportedInstanceFamily | undefined;
  CpuCredits: string | undefined;
}
export interface ModifyDefaultCreditSpecificationResult {
  InstanceFamilyCreditSpecification?: InstanceFamilyCreditSpecification;
}
export interface ModifyEbsDefaultKmsKeyIdRequest {
  KmsKeyId: string | undefined;
  DryRun?: boolean;
}
export interface ModifyEbsDefaultKmsKeyIdResult {
  KmsKeyId?: string;
}
export interface ModifyFleetRequest {
  DryRun?: boolean;
  ExcessCapacityTerminationPolicy?: FleetExcessCapacityTerminationPolicy;
  LaunchTemplateConfigs?: FleetLaunchTemplateConfigRequest[];
  FleetId: string | undefined;
  TargetCapacitySpecification?: TargetCapacitySpecificationRequest;
  Context?: string;
}
export interface ModifyFleetResult {
  Return?: boolean;
}
export interface LoadPermissionRequest {
  Group?: PermissionGroup;
  UserId?: string;
}
export interface LoadPermissionModifications {
  Add?: LoadPermissionRequest[];
  Remove?: LoadPermissionRequest[];
}
export declare const OperationType: {
  readonly add: "add";
  readonly remove: "remove";
};
export type OperationType = (typeof OperationType)[keyof typeof OperationType];
export interface ModifyFpgaImageAttributeRequest {
  DryRun?: boolean;
  FpgaImageId: string | undefined;
  Attribute?: FpgaImageAttributeName;
  OperationType?: OperationType;
  UserIds?: string[];
  UserGroups?: string[];
  ProductCodes?: string[];
  LoadPermission?: LoadPermissionModifications;
  Description?: string;
  Name?: string;
}
export interface ModifyFpgaImageAttributeResult {
  FpgaImageAttribute?: FpgaImageAttribute;
}
export interface ModifyHostsRequest {
  AutoPlacement?: AutoPlacement;
  HostIds: string[] | undefined;
  HostRecovery?: HostRecovery;
  InstanceType?: string;
  InstanceFamily?: string;
  HostMaintenance?: HostMaintenance;
}
export interface ModifyHostsResult {
  Successful?: string[];
  Unsuccessful?: UnsuccessfulItem[];
}
export interface ModifyIdentityIdFormatRequest {
  PrincipalArn: string | undefined;
  Resource: string | undefined;
  UseLongIds: boolean | undefined;
}
export interface ModifyIdFormatRequest {
  Resource: string | undefined;
  UseLongIds: boolean | undefined;
}
export interface LaunchPermissionModifications {
  Add?: LaunchPermission[];
  Remove?: LaunchPermission[];
}
export interface ModifyImageAttributeRequest {
  Attribute?: string;
  Description?: AttributeValue;
  ImageId: string | undefined;
  LaunchPermission?: LaunchPermissionModifications;
  OperationType?: OperationType;
  ProductCodes?: string[];
  UserGroups?: string[];
  UserIds?: string[];
  Value?: string;
  DryRun?: boolean;
  OrganizationArns?: string[];
  OrganizationalUnitArns?: string[];
  ImdsSupport?: AttributeValue;
}
export interface EbsInstanceBlockDeviceSpecification {
  DeleteOnTermination?: boolean;
  VolumeId?: string;
}
export interface InstanceBlockDeviceMappingSpecification {
  DeviceName?: string;
  Ebs?: EbsInstanceBlockDeviceSpecification;
  NoDevice?: string;
  VirtualName?: string;
}
export interface BlobAttributeValue {
  Value?: Uint8Array;
}
export interface ModifyInstanceAttributeRequest {
  SourceDestCheck?: AttributeBooleanValue;
  Attribute?: InstanceAttributeName;
  BlockDeviceMappings?: InstanceBlockDeviceMappingSpecification[];
  DisableApiTermination?: AttributeBooleanValue;
  DryRun?: boolean;
  EbsOptimized?: AttributeBooleanValue;
  EnaSupport?: AttributeBooleanValue;
  Groups?: string[];
  InstanceId: string | undefined;
  InstanceInitiatedShutdownBehavior?: AttributeValue;
  InstanceType?: AttributeValue;
  Kernel?: AttributeValue;
  Ramdisk?: AttributeValue;
  SriovNetSupport?: AttributeValue;
  UserData?: BlobAttributeValue;
  Value?: string;
  DisableApiStop?: AttributeBooleanValue;
}
export interface CapacityReservationSpecification {
  CapacityReservationPreference?: CapacityReservationPreference;
  CapacityReservationTarget?: CapacityReservationTarget;
}
export interface ModifyInstanceCapacityReservationAttributesRequest {
  InstanceId: string | undefined;
  CapacityReservationSpecification:
    | CapacityReservationSpecification
    | undefined;
  DryRun?: boolean;
}
export interface ModifyInstanceCapacityReservationAttributesResult {
  Return?: boolean;
}
export interface InstanceCreditSpecificationRequest {
  InstanceId: string | undefined;
  CpuCredits?: string;
}
export interface ModifyInstanceCreditSpecificationRequest {
  DryRun?: boolean;
  ClientToken?: string;
  InstanceCreditSpecifications:
    | InstanceCreditSpecificationRequest[]
    | undefined;
}
export interface SuccessfulInstanceCreditSpecificationItem {
  InstanceId?: string;
}
export declare const UnsuccessfulInstanceCreditSpecificationErrorCode: {
  readonly INCORRECT_INSTANCE_STATE: "IncorrectInstanceState";
  readonly INSTANCE_CREDIT_SPECIFICATION_NOT_SUPPORTED: "InstanceCreditSpecification.NotSupported";
  readonly INSTANCE_NOT_FOUND: "InvalidInstanceID.NotFound";
  readonly INVALID_INSTANCE_ID: "InvalidInstanceID.Malformed";
};
export type UnsuccessfulInstanceCreditSpecificationErrorCode =
  (typeof UnsuccessfulInstanceCreditSpecificationErrorCode)[keyof typeof UnsuccessfulInstanceCreditSpecificationErrorCode];
export interface UnsuccessfulInstanceCreditSpecificationItemError {
  Code?: UnsuccessfulInstanceCreditSpecificationErrorCode;
  Message?: string;
}
export interface UnsuccessfulInstanceCreditSpecificationItem {
  InstanceId?: string;
  Error?: UnsuccessfulInstanceCreditSpecificationItemError;
}
export interface ModifyInstanceCreditSpecificationResult {
  SuccessfulInstanceCreditSpecifications?: SuccessfulInstanceCreditSpecificationItem[];
  UnsuccessfulInstanceCreditSpecifications?: UnsuccessfulInstanceCreditSpecificationItem[];
}
export interface ModifyInstanceEventStartTimeRequest {
  DryRun?: boolean;
  InstanceId: string | undefined;
  InstanceEventId: string | undefined;
  NotBefore: Date | undefined;
}
export interface ModifyInstanceEventStartTimeResult {
  Event?: InstanceStatusEvent;
}
export interface ModifyInstanceEventWindowRequest {
  DryRun?: boolean;
  Name?: string;
  InstanceEventWindowId: string | undefined;
  TimeRanges?: InstanceEventWindowTimeRangeRequest[];
  CronExpression?: string;
}
export interface ModifyInstanceEventWindowResult {
  InstanceEventWindow?: InstanceEventWindow;
}
export interface ModifyInstanceMaintenanceOptionsRequest {
  InstanceId: string | undefined;
  AutoRecovery?: InstanceAutoRecoveryState;
  DryRun?: boolean;
}
export interface ModifyInstanceMaintenanceOptionsResult {
  InstanceId?: string;
  AutoRecovery?: InstanceAutoRecoveryState;
}
export interface ModifyInstanceMetadataOptionsRequest {
  InstanceId: string | undefined;
  HttpTokens?: HttpTokensState;
  HttpPutResponseHopLimit?: number;
  HttpEndpoint?: InstanceMetadataEndpointState;
  DryRun?: boolean;
  HttpProtocolIpv6?: InstanceMetadataProtocolState;
  InstanceMetadataTags?: InstanceMetadataTagsState;
}
export interface ModifyInstanceMetadataOptionsResult {
  InstanceId?: string;
  InstanceMetadataOptions?: InstanceMetadataOptionsResponse;
}
export declare const HostTenancy: {
  readonly dedicated: "dedicated";
  readonly host: "host";
};
export type HostTenancy = (typeof HostTenancy)[keyof typeof HostTenancy];
export interface ModifyInstancePlacementRequest {
  Affinity?: Affinity;
  GroupName?: string;
  HostId?: string;
  InstanceId: string | undefined;
  Tenancy?: HostTenancy;
  PartitionNumber?: number;
  HostResourceGroupArn?: string;
  GroupId?: string;
}
export interface ModifyInstancePlacementResult {
  Return?: boolean;
}
export interface RemoveIpamOperatingRegion {
  RegionName?: string;
}
export interface ModifyIpamRequest {
  DryRun?: boolean;
  IpamId: string | undefined;
  Description?: string;
  AddOperatingRegions?: AddIpamOperatingRegion[];
  RemoveOperatingRegions?: RemoveIpamOperatingRegion[];
  Tier?: IpamTier;
}
export interface ModifyIpamResult {
  Ipam?: Ipam;
}
export interface ModifyIpamPoolRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  Description?: string;
  AutoImport?: boolean;
  AllocationMinNetmaskLength?: number;
  AllocationMaxNetmaskLength?: number;
  AllocationDefaultNetmaskLength?: number;
  ClearAllocationDefaultNetmaskLength?: boolean;
  AddAllocationResourceTags?: RequestIpamResourceTag[];
  RemoveAllocationResourceTags?: RequestIpamResourceTag[];
}
export interface ModifyIpamPoolResult {
  IpamPool?: IpamPool;
}
export interface ModifyIpamResourceCidrRequest {
  DryRun?: boolean;
  ResourceId: string | undefined;
  ResourceCidr: string | undefined;
  ResourceRegion: string | undefined;
  CurrentIpamScopeId: string | undefined;
  DestinationIpamScopeId?: string;
  Monitored: boolean | undefined;
}
export interface ModifyIpamResourceCidrResult {
  IpamResourceCidr?: IpamResourceCidr;
}
export interface ModifyIpamResourceDiscoveryRequest {
  DryRun?: boolean;
  IpamResourceDiscoveryId: string | undefined;
  Description?: string;
  AddOperatingRegions?: AddIpamOperatingRegion[];
  RemoveOperatingRegions?: RemoveIpamOperatingRegion[];
}
export interface ModifyIpamResourceDiscoveryResult {
  IpamResourceDiscovery?: IpamResourceDiscovery;
}
export interface ModifyIpamScopeRequest {
  DryRun?: boolean;
  IpamScopeId: string | undefined;
  Description?: string;
}
export interface ModifyIpamScopeResult {
  IpamScope?: IpamScope;
}
export interface ModifyLaunchTemplateRequest {
  DryRun?: boolean;
  ClientToken?: string;
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  DefaultVersion?: string;
}
export interface ModifyLaunchTemplateResult {
  LaunchTemplate?: LaunchTemplate;
}
export interface ModifyLocalGatewayRouteRequest {
  DestinationCidrBlock?: string;
  LocalGatewayRouteTableId: string | undefined;
  LocalGatewayVirtualInterfaceGroupId?: string;
  NetworkInterfaceId?: string;
  DryRun?: boolean;
  DestinationPrefixListId?: string;
}
export interface ModifyLocalGatewayRouteResult {
  Route?: LocalGatewayRoute;
}
export interface RemovePrefixListEntry {
  Cidr: string | undefined;
}
export interface ModifyManagedPrefixListRequest {
  DryRun?: boolean;
  PrefixListId: string | undefined;
  CurrentVersion?: number;
  PrefixListName?: string;
  AddEntries?: AddPrefixListEntry[];
  RemoveEntries?: RemovePrefixListEntry[];
  MaxEntries?: number;
}
export interface ModifyManagedPrefixListResult {
  PrefixList?: ManagedPrefixList;
}
export interface NetworkInterfaceAttachmentChanges {
  AttachmentId?: string;
  DeleteOnTermination?: boolean;
}
export interface ModifyNetworkInterfaceAttributeRequest {
  Attachment?: NetworkInterfaceAttachmentChanges;
  Description?: AttributeValue;
  DryRun?: boolean;
  Groups?: string[];
  NetworkInterfaceId: string | undefined;
  SourceDestCheck?: AttributeBooleanValue;
  EnaSrdSpecification?: EnaSrdSpecification;
  EnablePrimaryIpv6?: boolean;
  ConnectionTrackingSpecification?: ConnectionTrackingSpecificationRequest;
}
export interface ModifyPrivateDnsNameOptionsRequest {
  DryRun?: boolean;
  InstanceId: string | undefined;
  PrivateDnsHostnameType?: HostnameType;
  EnableResourceNameDnsARecord?: boolean;
  EnableResourceNameDnsAAAARecord?: boolean;
}
export interface ModifyPrivateDnsNameOptionsResult {
  Return?: boolean;
}
export interface ModifyReservedInstancesRequest {
  ReservedInstancesIds: string[] | undefined;
  ClientToken?: string;
  TargetConfigurations: ReservedInstancesConfiguration[] | undefined;
}
export interface ModifyReservedInstancesResult {
  ReservedInstancesModificationId?: string;
}
export interface SecurityGroupRuleRequest {
  IpProtocol?: string;
  FromPort?: number;
  ToPort?: number;
  CidrIpv4?: string;
  CidrIpv6?: string;
  PrefixListId?: string;
  ReferencedGroupId?: string;
  Description?: string;
}
export interface SecurityGroupRuleUpdate {
  SecurityGroupRuleId: string | undefined;
  SecurityGroupRule?: SecurityGroupRuleRequest;
}
export interface ModifySecurityGroupRulesRequest {
  GroupId: string | undefined;
  SecurityGroupRules: SecurityGroupRuleUpdate[] | undefined;
  DryRun?: boolean;
}
export interface ModifySecurityGroupRulesResult {
  Return?: boolean;
}
export interface CreateVolumePermissionModifications {
  Add?: CreateVolumePermission[];
  Remove?: CreateVolumePermission[];
}
export interface ModifySnapshotAttributeRequest {
  Attribute?: SnapshotAttributeName;
  CreateVolumePermission?: CreateVolumePermissionModifications;
  GroupNames?: string[];
  OperationType?: OperationType;
  SnapshotId: string | undefined;
  UserIds?: string[];
  DryRun?: boolean;
}
export declare const TargetStorageTier: {
  readonly archive: "archive";
};
export type TargetStorageTier =
  (typeof TargetStorageTier)[keyof typeof TargetStorageTier];
export interface ModifySnapshotTierRequest {
  SnapshotId: string | undefined;
  StorageTier?: TargetStorageTier;
  DryRun?: boolean;
}
export interface ModifySnapshotTierResult {
  SnapshotId?: string;
  TieringStartTime?: Date;
}
export interface ModifySpotFleetRequestRequest {
  ExcessCapacityTerminationPolicy?: ExcessCapacityTerminationPolicy;
  LaunchTemplateConfigs?: LaunchTemplateConfig[];
  SpotFleetRequestId: string | undefined;
  TargetCapacity?: number;
  OnDemandTargetCapacity?: number;
  Context?: string;
}
export interface ModifySpotFleetRequestResponse {
  Return?: boolean;
}
export interface ModifySubnetAttributeRequest {
  AssignIpv6AddressOnCreation?: AttributeBooleanValue;
  MapPublicIpOnLaunch?: AttributeBooleanValue;
  SubnetId: string | undefined;
  MapCustomerOwnedIpOnLaunch?: AttributeBooleanValue;
  CustomerOwnedIpv4Pool?: string;
  EnableDns64?: AttributeBooleanValue;
  PrivateDnsHostnameTypeOnLaunch?: HostnameType;
  EnableResourceNameDnsARecordOnLaunch?: AttributeBooleanValue;
  EnableResourceNameDnsAAAARecordOnLaunch?: AttributeBooleanValue;
  EnableLniAtDeviceIndex?: number;
  DisableLniAtDeviceIndex?: AttributeBooleanValue;
}
export interface ModifyTrafficMirrorFilterNetworkServicesRequest {
  TrafficMirrorFilterId: string | undefined;
  AddNetworkServices?: TrafficMirrorNetworkService[];
  RemoveNetworkServices?: TrafficMirrorNetworkService[];
  DryRun?: boolean;
}
export interface ModifyTrafficMirrorFilterNetworkServicesResult {
  TrafficMirrorFilter?: TrafficMirrorFilter;
}
export declare const TrafficMirrorFilterRuleField: {
  readonly description: "description";
  readonly destination_port_range: "destination-port-range";
  readonly protocol: "protocol";
  readonly source_port_range: "source-port-range";
};
export type TrafficMirrorFilterRuleField =
  (typeof TrafficMirrorFilterRuleField)[keyof typeof TrafficMirrorFilterRuleField];
export interface ModifyTrafficMirrorFilterRuleRequest {
  TrafficMirrorFilterRuleId: string | undefined;
  TrafficDirection?: TrafficDirection;
  RuleNumber?: number;
  RuleAction?: TrafficMirrorRuleAction;
  DestinationPortRange?: TrafficMirrorPortRangeRequest;
  SourcePortRange?: TrafficMirrorPortRangeRequest;
  Protocol?: number;
  DestinationCidrBlock?: string;
  SourceCidrBlock?: string;
  Description?: string;
  RemoveFields?: TrafficMirrorFilterRuleField[];
  DryRun?: boolean;
}
export interface ModifyTrafficMirrorFilterRuleResult {
  TrafficMirrorFilterRule?: TrafficMirrorFilterRule;
}
export declare const TrafficMirrorSessionField: {
  readonly description: "description";
  readonly packet_length: "packet-length";
  readonly virtual_network_id: "virtual-network-id";
};
export type TrafficMirrorSessionField =
  (typeof TrafficMirrorSessionField)[keyof typeof TrafficMirrorSessionField];
export interface ModifyTrafficMirrorSessionRequest {
  TrafficMirrorSessionId: string | undefined;
  TrafficMirrorTargetId?: string;
  TrafficMirrorFilterId?: string;
  PacketLength?: number;
  SessionNumber?: number;
  VirtualNetworkId?: number;
  Description?: string;
  RemoveFields?: TrafficMirrorSessionField[];
  DryRun?: boolean;
}
export interface ModifyTrafficMirrorSessionResult {
  TrafficMirrorSession?: TrafficMirrorSession;
}
export interface ModifyTransitGatewayOptions {
  AddTransitGatewayCidrBlocks?: string[];
  RemoveTransitGatewayCidrBlocks?: string[];
  VpnEcmpSupport?: VpnEcmpSupportValue;
  DnsSupport?: DnsSupportValue;
  SecurityGroupReferencingSupport?: SecurityGroupReferencingSupportValue;
  AutoAcceptSharedAttachments?: AutoAcceptSharedAttachmentsValue;
  DefaultRouteTableAssociation?: DefaultRouteTableAssociationValue;
  AssociationDefaultRouteTableId?: string;
  DefaultRouteTablePropagation?: DefaultRouteTablePropagationValue;
  PropagationDefaultRouteTableId?: string;
  AmazonSideAsn?: number;
}
export interface ModifyTransitGatewayRequest {
  TransitGatewayId: string | undefined;
  Description?: string;
  Options?: ModifyTransitGatewayOptions;
  DryRun?: boolean;
}
export interface ModifyTransitGatewayResult {
  TransitGateway?: TransitGateway;
}
export interface ModifyTransitGatewayPrefixListReferenceRequest {
  TransitGatewayRouteTableId: string | undefined;
  PrefixListId: string | undefined;
  TransitGatewayAttachmentId?: string;
  Blackhole?: boolean;
  DryRun?: boolean;
}
export interface ModifyTransitGatewayPrefixListReferenceResult {
  TransitGatewayPrefixListReference?: TransitGatewayPrefixListReference;
}
export interface ModifyTransitGatewayVpcAttachmentRequestOptions {
  DnsSupport?: DnsSupportValue;
  SecurityGroupReferencingSupport?: SecurityGroupReferencingSupportValue;
  Ipv6Support?: Ipv6SupportValue;
  ApplianceModeSupport?: ApplianceModeSupportValue;
}
export interface ModifyTransitGatewayVpcAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  AddSubnetIds?: string[];
  RemoveSubnetIds?: string[];
  Options?: ModifyTransitGatewayVpcAttachmentRequestOptions;
  DryRun?: boolean;
}
export interface ModifyTransitGatewayVpcAttachmentResult {
  TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export interface ModifyVerifiedAccessEndpointLoadBalancerOptions {
  SubnetIds?: string[];
  Protocol?: VerifiedAccessEndpointProtocol;
  Port?: number;
}
export interface ModifyVerifiedAccessEndpointEniOptions {
  Protocol?: VerifiedAccessEndpointProtocol;
  Port?: number;
}
export interface ModifyVerifiedAccessEndpointRequest {
  VerifiedAccessEndpointId: string | undefined;
  VerifiedAccessGroupId?: string;
  LoadBalancerOptions?: ModifyVerifiedAccessEndpointLoadBalancerOptions;
  NetworkInterfaceOptions?: ModifyVerifiedAccessEndpointEniOptions;
  Description?: string;
  ClientToken?: string;
  DryRun?: boolean;
}
export interface ModifyVerifiedAccessEndpointResult {
  VerifiedAccessEndpoint?: VerifiedAccessEndpoint;
}
export interface ModifyVerifiedAccessEndpointPolicyRequest {
  VerifiedAccessEndpointId: string | undefined;
  PolicyEnabled?: boolean;
  PolicyDocument?: string;
  ClientToken?: string;
  DryRun?: boolean;
  SseSpecification?: VerifiedAccessSseSpecificationRequest;
}
export interface ModifyVerifiedAccessEndpointPolicyResult {
  PolicyEnabled?: boolean;
  PolicyDocument?: string;
  SseSpecification?: VerifiedAccessSseSpecificationResponse;
}
export interface ModifyVerifiedAccessGroupRequest {
  VerifiedAccessGroupId: string | undefined;
  VerifiedAccessInstanceId?: string;
  Description?: string;
  ClientToken?: string;
  DryRun?: boolean;
}
export interface ModifyVerifiedAccessGroupResult {
  VerifiedAccessGroup?: VerifiedAccessGroup;
}
export interface ModifyVerifiedAccessGroupPolicyRequest {
  VerifiedAccessGroupId: string | undefined;
  PolicyEnabled?: boolean;
  PolicyDocument?: string;
  ClientToken?: string;
  DryRun?: boolean;
  SseSpecification?: VerifiedAccessSseSpecificationRequest;
}
export interface ModifyVerifiedAccessGroupPolicyResult {
  PolicyEnabled?: boolean;
  PolicyDocument?: string;
  SseSpecification?: VerifiedAccessSseSpecificationResponse;
}
export interface ModifyVerifiedAccessInstanceRequest {
  VerifiedAccessInstanceId: string | undefined;
  Description?: string;
  DryRun?: boolean;
  ClientToken?: string;
}
export interface ModifyVerifiedAccessInstanceResult {
  VerifiedAccessInstance?: VerifiedAccessInstance;
}
export interface VerifiedAccessLogCloudWatchLogsDestinationOptions {
  Enabled: boolean | undefined;
  LogGroup?: string;
}
export interface VerifiedAccessLogKinesisDataFirehoseDestinationOptions {
  Enabled: boolean | undefined;
  DeliveryStream?: string;
}
export interface VerifiedAccessLogS3DestinationOptions {
  Enabled: boolean | undefined;
  BucketName?: string;
  Prefix?: string;
  BucketOwner?: string;
}
export interface VerifiedAccessLogOptions {
  S3?: VerifiedAccessLogS3DestinationOptions;
  CloudWatchLogs?: VerifiedAccessLogCloudWatchLogsDestinationOptions;
  KinesisDataFirehose?: VerifiedAccessLogKinesisDataFirehoseDestinationOptions;
  LogVersion?: string;
  IncludeTrustContext?: boolean;
}
export interface ModifyVerifiedAccessInstanceLoggingConfigurationRequest {
  VerifiedAccessInstanceId: string | undefined;
  AccessLogs: VerifiedAccessLogOptions | undefined;
  DryRun?: boolean;
  ClientToken?: string;
}
export interface ModifyVerifiedAccessInstanceLoggingConfigurationResult {
  LoggingConfiguration?: VerifiedAccessInstanceLoggingConfiguration;
}
export interface ModifyVerifiedAccessTrustProviderDeviceOptions {
  PublicSigningKeyUrl?: string;
}
export interface ModifyVerifiedAccessTrustProviderOidcOptions {
  Issuer?: string;
  AuthorizationEndpoint?: string;
  TokenEndpoint?: string;
  UserInfoEndpoint?: string;
  ClientId?: string;
  ClientSecret?: string;
  Scope?: string;
}
export interface ModifyVerifiedAccessTrustProviderRequest {
  VerifiedAccessTrustProviderId: string | undefined;
  OidcOptions?: ModifyVerifiedAccessTrustProviderOidcOptions;
  DeviceOptions?: ModifyVerifiedAccessTrustProviderDeviceOptions;
  Description?: string;
  DryRun?: boolean;
  ClientToken?: string;
  SseSpecification?: VerifiedAccessSseSpecificationRequest;
}
export interface ModifyVerifiedAccessTrustProviderResult {
  VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider;
}
export interface ModifyVolumeRequest {
  DryRun?: boolean;
  VolumeId: string | undefined;
  Size?: number;
  VolumeType?: VolumeType;
  Iops?: number;
  Throughput?: number;
  MultiAttachEnabled?: boolean;
}
export interface ModifyVolumeResult {
  VolumeModification?: VolumeModification;
}
export interface ModifyVolumeAttributeRequest {
  AutoEnableIO?: AttributeBooleanValue;
  VolumeId: string | undefined;
  DryRun?: boolean;
}
export interface ModifyVpcAttributeRequest {
  EnableDnsHostnames?: AttributeBooleanValue;
  EnableDnsSupport?: AttributeBooleanValue;
  VpcId: string | undefined;
  EnableNetworkAddressUsageMetrics?: AttributeBooleanValue;
}
export interface ModifyVpcEndpointRequest {
  DryRun?: boolean;
  VpcEndpointId: string | undefined;
  ResetPolicy?: boolean;
  PolicyDocument?: string;
  AddRouteTableIds?: string[];
  RemoveRouteTableIds?: string[];
  AddSubnetIds?: string[];
  RemoveSubnetIds?: string[];
  AddSecurityGroupIds?: string[];
  RemoveSecurityGroupIds?: string[];
  IpAddressType?: IpAddressType;
  DnsOptions?: DnsOptionsSpecification;
  PrivateDnsEnabled?: boolean;
  SubnetConfigurations?: SubnetConfiguration[];
}
export interface ModifyVpcEndpointResult {
  Return?: boolean;
}
export interface ModifyVpcEndpointConnectionNotificationRequest {
  DryRun?: boolean;
  ConnectionNotificationId: string | undefined;
  ConnectionNotificationArn?: string;
  ConnectionEvents?: string[];
}
export interface ModifyVpcEndpointConnectionNotificationResult {
  ReturnValue?: boolean;
}
export interface ModifyVpcEndpointServiceConfigurationRequest {
  DryRun?: boolean;
  ServiceId: string | undefined;
  PrivateDnsName?: string;
  RemovePrivateDnsName?: boolean;
  AcceptanceRequired?: boolean;
  AddNetworkLoadBalancerArns?: string[];
  RemoveNetworkLoadBalancerArns?: string[];
  AddGatewayLoadBalancerArns?: string[];
  RemoveGatewayLoadBalancerArns?: string[];
  AddSupportedIpAddressTypes?: string[];
  RemoveSupportedIpAddressTypes?: string[];
}
export interface ModifyVpcEndpointServiceConfigurationResult {
  Return?: boolean;
}
export interface ModifyVpcEndpointServicePayerResponsibilityRequest {
  DryRun?: boolean;
  ServiceId: string | undefined;
  PayerResponsibility: PayerResponsibility | undefined;
}
export interface ModifyVpcEndpointServicePayerResponsibilityResult {
  ReturnValue?: boolean;
}
export interface ModifyVpcEndpointServicePermissionsRequest {
  DryRun?: boolean;
  ServiceId: string | undefined;
  AddAllowedPrincipals?: string[];
  RemoveAllowedPrincipals?: string[];
}
export interface ModifyVpcEndpointServicePermissionsResult {
  AddedPrincipals?: AddedPrincipal[];
  ReturnValue?: boolean;
}
export interface PeeringConnectionOptionsRequest {
  AllowDnsResolutionFromRemoteVpc?: boolean;
  AllowEgressFromLocalClassicLinkToRemoteVpc?: boolean;
  AllowEgressFromLocalVpcToRemoteClassicLink?: boolean;
}
export interface ModifyVpcPeeringConnectionOptionsRequest {
  AccepterPeeringConnectionOptions?: PeeringConnectionOptionsRequest;
  DryRun?: boolean;
  RequesterPeeringConnectionOptions?: PeeringConnectionOptionsRequest;
  VpcPeeringConnectionId: string | undefined;
}
export interface PeeringConnectionOptions {
  AllowDnsResolutionFromRemoteVpc?: boolean;
  AllowEgressFromLocalClassicLinkToRemoteVpc?: boolean;
  AllowEgressFromLocalVpcToRemoteClassicLink?: boolean;
}
export interface ModifyVpcPeeringConnectionOptionsResult {
  AccepterPeeringConnectionOptions?: PeeringConnectionOptions;
  RequesterPeeringConnectionOptions?: PeeringConnectionOptions;
}
export declare const VpcTenancy: {
  readonly default: "default";
};
export type VpcTenancy = (typeof VpcTenancy)[keyof typeof VpcTenancy];
export interface ModifyVpcTenancyRequest {
  VpcId: string | undefined;
  InstanceTenancy: VpcTenancy | undefined;
  DryRun?: boolean;
}
export interface ModifyVpcTenancyResult {
  ReturnValue?: boolean;
}
export interface ModifyVpnConnectionRequest {
  VpnConnectionId: string | undefined;
  TransitGatewayId?: string;
  CustomerGatewayId?: string;
  VpnGatewayId?: string;
  DryRun?: boolean;
}
export interface ModifyVpnConnectionResult {
  VpnConnection?: VpnConnection;
}
export interface ModifyVpnConnectionOptionsRequest {
  VpnConnectionId: string | undefined;
  LocalIpv4NetworkCidr?: string;
  RemoteIpv4NetworkCidr?: string;
  LocalIpv6NetworkCidr?: string;
  RemoteIpv6NetworkCidr?: string;
  DryRun?: boolean;
}
export interface ModifyVpnConnectionOptionsResult {
  VpnConnection?: VpnConnection;
}
export interface ModifyVpnTunnelCertificateRequest {
  VpnConnectionId: string | undefined;
  VpnTunnelOutsideIpAddress: string | undefined;
  DryRun?: boolean;
}
export interface ModifyVpnTunnelCertificateResult {
  VpnConnection?: VpnConnection;
}
export interface ModifyVpnTunnelOptionsSpecification {
  TunnelInsideCidr?: string;
  TunnelInsideIpv6Cidr?: string;
  PreSharedKey?: string;
  Phase1LifetimeSeconds?: number;
  Phase2LifetimeSeconds?: number;
  RekeyMarginTimeSeconds?: number;
  RekeyFuzzPercentage?: number;
  ReplayWindowSize?: number;
  DPDTimeoutSeconds?: number;
  DPDTimeoutAction?: string;
  Phase1EncryptionAlgorithms?: Phase1EncryptionAlgorithmsRequestListValue[];
  Phase2EncryptionAlgorithms?: Phase2EncryptionAlgorithmsRequestListValue[];
  Phase1IntegrityAlgorithms?: Phase1IntegrityAlgorithmsRequestListValue[];
  Phase2IntegrityAlgorithms?: Phase2IntegrityAlgorithmsRequestListValue[];
  Phase1DHGroupNumbers?: Phase1DHGroupNumbersRequestListValue[];
  Phase2DHGroupNumbers?: Phase2DHGroupNumbersRequestListValue[];
  IKEVersions?: IKEVersionsRequestListValue[];
  StartupAction?: string;
  LogOptions?: VpnTunnelLogOptionsSpecification;
  EnableTunnelLifecycleControl?: boolean;
}
export interface ModifyVpnTunnelOptionsRequest {
  VpnConnectionId: string | undefined;
  VpnTunnelOutsideIpAddress: string | undefined;
  TunnelOptions: ModifyVpnTunnelOptionsSpecification | undefined;
  DryRun?: boolean;
  SkipTunnelReplacement?: boolean;
}
export interface ModifyVpnTunnelOptionsResult {
  VpnConnection?: VpnConnection;
}
export interface MonitorInstancesRequest {
  InstanceIds: string[] | undefined;
  DryRun?: boolean;
}
export interface InstanceMonitoring {
  InstanceId?: string;
  Monitoring?: Monitoring;
}
export interface MonitorInstancesResult {
  InstanceMonitorings?: InstanceMonitoring[];
}
export interface MoveAddressToVpcRequest {
  DryRun?: boolean;
  PublicIp: string | undefined;
}
export declare const Status: {
  readonly inClassic: "InClassic";
  readonly inVpc: "InVpc";
  readonly moveInProgress: "MoveInProgress";
};
export type Status = (typeof Status)[keyof typeof Status];
export interface MoveAddressToVpcResult {
  AllocationId?: string;
  Status?: Status;
}
export interface MoveByoipCidrToIpamRequest {
  DryRun?: boolean;
  Cidr: string | undefined;
  IpamPoolId: string | undefined;
  IpamPoolOwner: string | undefined;
}
export interface MoveByoipCidrToIpamResult {
  ByoipCidr?: ByoipCidr;
}
export interface CidrAuthorizationContext {
  Message: string | undefined;
  Signature: string | undefined;
}
export interface ProvisionByoipCidrRequest {
  Cidr: string | undefined;
  CidrAuthorizationContext?: CidrAuthorizationContext;
  PubliclyAdvertisable?: boolean;
  Description?: string;
  DryRun?: boolean;
  PoolTagSpecifications?: TagSpecification[];
  MultiRegion?: boolean;
  NetworkBorderGroup?: string;
}
export interface ProvisionByoipCidrResult {
  ByoipCidr?: ByoipCidr;
}
export interface AsnAuthorizationContext {
  Message: string | undefined;
  Signature: string | undefined;
}
export interface ProvisionIpamByoasnRequest {
  DryRun?: boolean;
  IpamId: string | undefined;
  Asn: string | undefined;
  AsnAuthorizationContext: AsnAuthorizationContext | undefined;
}
export interface ProvisionIpamByoasnResult {
  Byoasn?: Byoasn;
}
export interface IpamCidrAuthorizationContext {
  Message?: string;
  Signature?: string;
}
export interface ProvisionIpamPoolCidrRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  Cidr?: string;
  CidrAuthorizationContext?: IpamCidrAuthorizationContext;
  NetmaskLength?: number;
  ClientToken?: string;
}
export interface ProvisionIpamPoolCidrResult {
  IpamPoolCidr?: IpamPoolCidr;
}
export interface ProvisionPublicIpv4PoolCidrRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  PoolId: string | undefined;
  NetmaskLength: number | undefined;
}
export interface ProvisionPublicIpv4PoolCidrResult {
  PoolId?: string;
  PoolAddressRange?: PublicIpv4PoolRange;
}
export interface PurchaseCapacityBlockRequest {
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
  CapacityBlockOfferingId: string | undefined;
  InstancePlatform: CapacityReservationInstancePlatform | undefined;
}
export interface PurchaseCapacityBlockResult {
  CapacityReservation?: CapacityReservation;
}
export interface PurchaseHostReservationRequest {
  ClientToken?: string;
  CurrencyCode?: CurrencyCodeValues;
  HostIdSet: string[] | undefined;
  LimitPrice?: string;
  OfferingId: string | undefined;
  TagSpecifications?: TagSpecification[];
}
export interface PurchaseHostReservationResult {
  ClientToken?: string;
  CurrencyCode?: CurrencyCodeValues;
  Purchase?: Purchase[];
  TotalHourlyPrice?: string;
  TotalUpfrontPrice?: string;
}
export interface ReservedInstanceLimitPrice {
  Amount?: number;
  CurrencyCode?: CurrencyCodeValues;
}
export interface PurchaseReservedInstancesOfferingRequest {
  InstanceCount: number | undefined;
  ReservedInstancesOfferingId: string | undefined;
  DryRun?: boolean;
  LimitPrice?: ReservedInstanceLimitPrice;
  PurchaseTime?: Date;
}
export interface PurchaseReservedInstancesOfferingResult {
  ReservedInstancesId?: string;
}
export interface PurchaseRequest {
  InstanceCount: number | undefined;
  PurchaseToken: string | undefined;
}
export interface PurchaseScheduledInstancesRequest {
  ClientToken?: string;
  DryRun?: boolean;
  PurchaseRequests: PurchaseRequest[] | undefined;
}
export interface PurchaseScheduledInstancesResult {
  ScheduledInstanceSet?: ScheduledInstance[];
}
export interface RebootInstancesRequest {
  InstanceIds: string[] | undefined;
  DryRun?: boolean;
}
export interface RegisterImageRequest {
  ImageLocation?: string;
  Architecture?: ArchitectureValues;
  BlockDeviceMappings?: BlockDeviceMapping[];
  Description?: string;
  DryRun?: boolean;
  EnaSupport?: boolean;
  KernelId?: string;
  Name: string | undefined;
  BillingProducts?: string[];
  RamdiskId?: string;
  RootDeviceName?: string;
  SriovNetSupport?: string;
  VirtualizationType?: string;
  BootMode?: BootModeValues;
  TpmSupport?: TpmSupportValues;
  UefiData?: string;
  ImdsSupport?: ImdsSupportValues;
  TagSpecifications?: TagSpecification[];
}
export interface RegisterImageResult {
  ImageId?: string;
}
export interface RegisterInstanceTagAttributeRequest {
  IncludeAllTagsOfInstance?: boolean;
  InstanceTagKeys?: string[];
}
export declare const GetLaunchTemplateDataResultFilterSensitiveLog: (
  obj: GetLaunchTemplateDataResult
) => any;
export declare const GetPasswordDataResultFilterSensitiveLog: (
  obj: GetPasswordDataResult
) => any;
export declare const GetVpnConnectionDeviceSampleConfigurationResultFilterSensitiveLog: (
  obj: GetVpnConnectionDeviceSampleConfigurationResult
) => any;
export declare const ImageDiskContainerFilterSensitiveLog: (
  obj: ImageDiskContainer
) => any;
export declare const ImportImageRequestFilterSensitiveLog: (
  obj: ImportImageRequest
) => any;
export declare const ImportImageResultFilterSensitiveLog: (
  obj: ImportImageResult
) => any;
export declare const DiskImageDetailFilterSensitiveLog: (
  obj: DiskImageDetail
) => any;
export declare const DiskImageFilterSensitiveLog: (obj: DiskImage) => any;
export declare const UserDataFilterSensitiveLog: (obj: UserData) => any;
export declare const ImportInstanceLaunchSpecificationFilterSensitiveLog: (
  obj: ImportInstanceLaunchSpecification
) => any;
export declare const ImportInstanceRequestFilterSensitiveLog: (
  obj: ImportInstanceRequest
) => any;
export declare const ImportInstanceResultFilterSensitiveLog: (
  obj: ImportInstanceResult
) => any;
export declare const SnapshotDiskContainerFilterSensitiveLog: (
  obj: SnapshotDiskContainer
) => any;
export declare const ImportSnapshotRequestFilterSensitiveLog: (
  obj: ImportSnapshotRequest
) => any;
export declare const ImportSnapshotResultFilterSensitiveLog: (
  obj: ImportSnapshotResult
) => any;
export declare const ImportVolumeRequestFilterSensitiveLog: (
  obj: ImportVolumeRequest
) => any;
export declare const ImportVolumeResultFilterSensitiveLog: (
  obj: ImportVolumeResult
) => any;
export declare const ModifyVerifiedAccessTrustProviderOidcOptionsFilterSensitiveLog: (
  obj: ModifyVerifiedAccessTrustProviderOidcOptions
) => any;
export declare const ModifyVerifiedAccessTrustProviderRequestFilterSensitiveLog: (
  obj: ModifyVerifiedAccessTrustProviderRequest
) => any;
export declare const ModifyVerifiedAccessTrustProviderResultFilterSensitiveLog: (
  obj: ModifyVerifiedAccessTrustProviderResult
) => any;
export declare const ModifyVpnConnectionResultFilterSensitiveLog: (
  obj: ModifyVpnConnectionResult
) => any;
export declare const ModifyVpnConnectionOptionsResultFilterSensitiveLog: (
  obj: ModifyVpnConnectionOptionsResult
) => any;
export declare const ModifyVpnTunnelCertificateResultFilterSensitiveLog: (
  obj: ModifyVpnTunnelCertificateResult
) => any;
export declare const ModifyVpnTunnelOptionsSpecificationFilterSensitiveLog: (
  obj: ModifyVpnTunnelOptionsSpecification
) => any;
export declare const ModifyVpnTunnelOptionsRequestFilterSensitiveLog: (
  obj: ModifyVpnTunnelOptionsRequest
) => any;
export declare const ModifyVpnTunnelOptionsResultFilterSensitiveLog: (
  obj: ModifyVpnTunnelOptionsResult
) => any;
