import {
  _InstanceType,
  AddressAttribute,
  AddressAttributeName,
  ByoipCidr,
  ClientVpnAuthorizationRuleStatus,
  IamInstanceProfileAssociation,
  IamInstanceProfileSpecification,
  IpPermission,
  NatGatewayAddress,
  PortRange,
  RouteTableAssociationState,
  TagSpecification,
  TransitGatewayAttachmentResourceType,
  TransitGatewayMulticastDomainAssociations,
  TransitGatewayPeeringAttachment,
  TransitGatewayVpcAttachment,
  UnsuccessfulItem,
} from "./models_0";
import {
  AmdSevSnpSpecification,
  BlockDeviceMapping,
  CreditSpecificationRequest,
  ElasticGpuSpecification,
  HostnameType,
  IcmpTypeCode,
  InstanceInterruptionBehavior,
  InstanceIpv6Address,
  LocalGatewayRoute,
  ManagedPrefixList,
  MarketType,
  Placement,
  RuleAction,
  ShutdownBehavior,
  SpotInstanceType,
} from "./models_1";
import { SnapshotState, SSEType, TransitGatewayRoute } from "./models_2";
import {
  ClientVpnConnectionStatus,
  Filter,
  InstanceTagNotificationAttribute,
} from "./models_3";
import {
  HttpTokensState,
  InstanceAttributeName,
  InstanceAutoRecoveryState,
  InstanceMetadataEndpointState,
  InstanceMetadataProtocolState,
  InstanceMetadataTagsState,
  InstanceNetworkInterfaceSpecification,
  InstanceState,
  NetworkInsightsAccessScopeAnalysis,
  NetworkInsightsAnalysis,
  RunInstancesMonitoringEnabled,
  SnapshotAttributeName,
  SpotFleetRequestConfigData,
  SpotInstanceRequest,
  SpotPlacement,
} from "./models_4";
import {
  CapacityReservationSpecification,
  InstanceMonitoring,
  RegisterInstanceTagAttributeRequest,
  Status,
} from "./models_6";
export interface RegisterInstanceEventNotificationAttributesRequest {
  DryRun?: boolean;
  InstanceTagAttribute: RegisterInstanceTagAttributeRequest | undefined;
}
export interface RegisterInstanceEventNotificationAttributesResult {
  InstanceTagAttribute?: InstanceTagNotificationAttribute;
}
export interface RegisterTransitGatewayMulticastGroupMembersRequest {
  TransitGatewayMulticastDomainId: string | undefined;
  GroupIpAddress?: string;
  NetworkInterfaceIds: string[] | undefined;
  DryRun?: boolean;
}
export interface TransitGatewayMulticastRegisteredGroupMembers {
  TransitGatewayMulticastDomainId?: string;
  RegisteredNetworkInterfaceIds?: string[];
  GroupIpAddress?: string;
}
export interface RegisterTransitGatewayMulticastGroupMembersResult {
  RegisteredMulticastGroupMembers?: TransitGatewayMulticastRegisteredGroupMembers;
}
export interface RegisterTransitGatewayMulticastGroupSourcesRequest {
  TransitGatewayMulticastDomainId: string | undefined;
  GroupIpAddress?: string;
  NetworkInterfaceIds: string[] | undefined;
  DryRun?: boolean;
}
export interface TransitGatewayMulticastRegisteredGroupSources {
  TransitGatewayMulticastDomainId?: string;
  RegisteredNetworkInterfaceIds?: string[];
  GroupIpAddress?: string;
}
export interface RegisterTransitGatewayMulticastGroupSourcesResult {
  RegisteredMulticastGroupSources?: TransitGatewayMulticastRegisteredGroupSources;
}
export interface RejectTransitGatewayMulticastDomainAssociationsRequest {
  TransitGatewayMulticastDomainId?: string;
  TransitGatewayAttachmentId?: string;
  SubnetIds?: string[];
  DryRun?: boolean;
}
export interface RejectTransitGatewayMulticastDomainAssociationsResult {
  Associations?: TransitGatewayMulticastDomainAssociations;
}
export interface RejectTransitGatewayPeeringAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface RejectTransitGatewayPeeringAttachmentResult {
  TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
export interface RejectTransitGatewayVpcAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean;
}
export interface RejectTransitGatewayVpcAttachmentResult {
  TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export interface RejectVpcEndpointConnectionsRequest {
  DryRun?: boolean;
  ServiceId: string | undefined;
  VpcEndpointIds: string[] | undefined;
}
export interface RejectVpcEndpointConnectionsResult {
  Unsuccessful?: UnsuccessfulItem[];
}
export interface RejectVpcPeeringConnectionRequest {
  DryRun?: boolean;
  VpcPeeringConnectionId: string | undefined;
}
export interface RejectVpcPeeringConnectionResult {
  Return?: boolean;
}
export interface ReleaseAddressRequest {
  AllocationId?: string;
  PublicIp?: string;
  NetworkBorderGroup?: string;
  DryRun?: boolean;
}
export interface ReleaseHostsRequest {
  HostIds: string[] | undefined;
}
export interface ReleaseHostsResult {
  Successful?: string[];
  Unsuccessful?: UnsuccessfulItem[];
}
export interface ReleaseIpamPoolAllocationRequest {
  DryRun?: boolean;
  IpamPoolId: string | undefined;
  Cidr: string | undefined;
  IpamPoolAllocationId: string | undefined;
}
export interface ReleaseIpamPoolAllocationResult {
  Success?: boolean;
}
export interface ReplaceIamInstanceProfileAssociationRequest {
  IamInstanceProfile: IamInstanceProfileSpecification | undefined;
  AssociationId: string | undefined;
}
export interface ReplaceIamInstanceProfileAssociationResult {
  IamInstanceProfileAssociation?: IamInstanceProfileAssociation;
}
export interface ReplaceNetworkAclAssociationRequest {
  AssociationId: string | undefined;
  DryRun?: boolean;
  NetworkAclId: string | undefined;
}
export interface ReplaceNetworkAclAssociationResult {
  NewAssociationId?: string;
}
export interface ReplaceNetworkAclEntryRequest {
  CidrBlock?: string;
  DryRun?: boolean;
  Egress: boolean | undefined;
  IcmpTypeCode?: IcmpTypeCode;
  Ipv6CidrBlock?: string;
  NetworkAclId: string | undefined;
  PortRange?: PortRange;
  Protocol: string | undefined;
  RuleAction: RuleAction | undefined;
  RuleNumber: number | undefined;
}
export interface ReplaceRouteRequest {
  DestinationCidrBlock?: string;
  DestinationIpv6CidrBlock?: string;
  DestinationPrefixListId?: string;
  DryRun?: boolean;
  VpcEndpointId?: string;
  EgressOnlyInternetGatewayId?: string;
  GatewayId?: string;
  InstanceId?: string;
  LocalTarget?: boolean;
  NatGatewayId?: string;
  TransitGatewayId?: string;
  LocalGatewayId?: string;
  CarrierGatewayId?: string;
  NetworkInterfaceId?: string;
  RouteTableId: string | undefined;
  VpcPeeringConnectionId?: string;
  CoreNetworkArn?: string;
}
export interface ReplaceRouteTableAssociationRequest {
  AssociationId: string | undefined;
  DryRun?: boolean;
  RouteTableId: string | undefined;
}
export interface ReplaceRouteTableAssociationResult {
  NewAssociationId?: string;
  AssociationState?: RouteTableAssociationState;
}
export interface ReplaceTransitGatewayRouteRequest {
  DestinationCidrBlock: string | undefined;
  TransitGatewayRouteTableId: string | undefined;
  TransitGatewayAttachmentId?: string;
  Blackhole?: boolean;
  DryRun?: boolean;
}
export interface ReplaceTransitGatewayRouteResult {
  Route?: TransitGatewayRoute;
}
export interface ReplaceVpnTunnelRequest {
  VpnConnectionId: string | undefined;
  VpnTunnelOutsideIpAddress: string | undefined;
  ApplyPendingMaintenance?: boolean;
  DryRun?: boolean;
}
export interface ReplaceVpnTunnelResult {
  Return?: boolean;
}
export declare const ReportInstanceReasonCodes: {
  readonly instance_stuck_in_state: "instance-stuck-in-state";
  readonly not_accepting_credentials: "not-accepting-credentials";
  readonly other: "other";
  readonly password_not_available: "password-not-available";
  readonly performance_ebs_volume: "performance-ebs-volume";
  readonly performance_instance_store: "performance-instance-store";
  readonly performance_network: "performance-network";
  readonly performance_other: "performance-other";
  readonly unresponsive: "unresponsive";
};
export type ReportInstanceReasonCodes =
  (typeof ReportInstanceReasonCodes)[keyof typeof ReportInstanceReasonCodes];
export declare const ReportStatusType: {
  readonly impaired: "impaired";
  readonly ok: "ok";
};
export type ReportStatusType =
  (typeof ReportStatusType)[keyof typeof ReportStatusType];
export interface ReportInstanceStatusRequest {
  Description?: string;
  DryRun?: boolean;
  EndTime?: Date;
  Instances: string[] | undefined;
  ReasonCodes: ReportInstanceReasonCodes[] | undefined;
  StartTime?: Date;
  Status: ReportStatusType | undefined;
}
export interface RequestSpotFleetRequest {
  DryRun?: boolean;
  SpotFleetRequestConfig: SpotFleetRequestConfigData | undefined;
}
export interface RequestSpotFleetResponse {
  SpotFleetRequestId?: string;
}
export interface RequestSpotLaunchSpecification {
  SecurityGroupIds?: string[];
  SecurityGroups?: string[];
  AddressingType?: string;
  BlockDeviceMappings?: BlockDeviceMapping[];
  EbsOptimized?: boolean;
  IamInstanceProfile?: IamInstanceProfileSpecification;
  ImageId?: string;
  InstanceType?: _InstanceType;
  KernelId?: string;
  KeyName?: string;
  Monitoring?: RunInstancesMonitoringEnabled;
  NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
  Placement?: SpotPlacement;
  RamdiskId?: string;
  SubnetId?: string;
  UserData?: string;
}
export interface RequestSpotInstancesRequest {
  AvailabilityZoneGroup?: string;
  BlockDurationMinutes?: number;
  ClientToken?: string;
  DryRun?: boolean;
  InstanceCount?: number;
  LaunchGroup?: string;
  LaunchSpecification?: RequestSpotLaunchSpecification;
  SpotPrice?: string;
  Type?: SpotInstanceType;
  ValidFrom?: Date;
  ValidUntil?: Date;
  TagSpecifications?: TagSpecification[];
  InstanceInterruptionBehavior?: InstanceInterruptionBehavior;
}
export interface RequestSpotInstancesResult {
  SpotInstanceRequests?: SpotInstanceRequest[];
}
export interface ResetAddressAttributeRequest {
  AllocationId: string | undefined;
  Attribute: AddressAttributeName | undefined;
  DryRun?: boolean;
}
export interface ResetAddressAttributeResult {
  Address?: AddressAttribute;
}
export interface ResetEbsDefaultKmsKeyIdRequest {
  DryRun?: boolean;
}
export interface ResetEbsDefaultKmsKeyIdResult {
  KmsKeyId?: string;
}
export declare const ResetFpgaImageAttributeName: {
  readonly loadPermission: "loadPermission";
};
export type ResetFpgaImageAttributeName =
  (typeof ResetFpgaImageAttributeName)[keyof typeof ResetFpgaImageAttributeName];
export interface ResetFpgaImageAttributeRequest {
  DryRun?: boolean;
  FpgaImageId: string | undefined;
  Attribute?: ResetFpgaImageAttributeName;
}
export interface ResetFpgaImageAttributeResult {
  Return?: boolean;
}
export declare const ResetImageAttributeName: {
  readonly launchPermission: "launchPermission";
};
export type ResetImageAttributeName =
  (typeof ResetImageAttributeName)[keyof typeof ResetImageAttributeName];
export interface ResetImageAttributeRequest {
  Attribute: ResetImageAttributeName | undefined;
  ImageId: string | undefined;
  DryRun?: boolean;
}
export interface ResetInstanceAttributeRequest {
  Attribute: InstanceAttributeName | undefined;
  DryRun?: boolean;
  InstanceId: string | undefined;
}
export interface ResetNetworkInterfaceAttributeRequest {
  DryRun?: boolean;
  NetworkInterfaceId: string | undefined;
  SourceDestCheck?: string;
}
export interface ResetSnapshotAttributeRequest {
  Attribute: SnapshotAttributeName | undefined;
  SnapshotId: string | undefined;
  DryRun?: boolean;
}
export interface RestoreAddressToClassicRequest {
  DryRun?: boolean;
  PublicIp: string | undefined;
}
export interface RestoreAddressToClassicResult {
  PublicIp?: string;
  Status?: Status;
}
export interface RestoreImageFromRecycleBinRequest {
  ImageId: string | undefined;
  DryRun?: boolean;
}
export interface RestoreImageFromRecycleBinResult {
  Return?: boolean;
}
export interface RestoreManagedPrefixListVersionRequest {
  DryRun?: boolean;
  PrefixListId: string | undefined;
  PreviousVersion: number | undefined;
  CurrentVersion: number | undefined;
}
export interface RestoreManagedPrefixListVersionResult {
  PrefixList?: ManagedPrefixList;
}
export interface RestoreSnapshotFromRecycleBinRequest {
  SnapshotId: string | undefined;
  DryRun?: boolean;
}
export interface RestoreSnapshotFromRecycleBinResult {
  SnapshotId?: string;
  OutpostArn?: string;
  Description?: string;
  Encrypted?: boolean;
  OwnerId?: string;
  Progress?: string;
  StartTime?: Date;
  State?: SnapshotState;
  VolumeId?: string;
  VolumeSize?: number;
  SseType?: SSEType;
}
export interface RestoreSnapshotTierRequest {
  SnapshotId: string | undefined;
  TemporaryRestoreDays?: number;
  PermanentRestore?: boolean;
  DryRun?: boolean;
}
export interface RestoreSnapshotTierResult {
  SnapshotId?: string;
  RestoreStartTime?: Date;
  RestoreDuration?: number;
  IsPermanentRestore?: boolean;
}
export interface RevokeClientVpnIngressRequest {
  ClientVpnEndpointId: string | undefined;
  TargetNetworkCidr: string | undefined;
  AccessGroupId?: string;
  RevokeAllGroups?: boolean;
  DryRun?: boolean;
}
export interface RevokeClientVpnIngressResult {
  Status?: ClientVpnAuthorizationRuleStatus;
}
export interface RevokeSecurityGroupEgressRequest {
  DryRun?: boolean;
  GroupId: string | undefined;
  IpPermissions?: IpPermission[];
  SecurityGroupRuleIds?: string[];
  CidrIp?: string;
  FromPort?: number;
  IpProtocol?: string;
  ToPort?: number;
  SourceSecurityGroupName?: string;
  SourceSecurityGroupOwnerId?: string;
}
export interface RevokeSecurityGroupEgressResult {
  Return?: boolean;
  UnknownIpPermissions?: IpPermission[];
}
export interface RevokeSecurityGroupIngressRequest {
  CidrIp?: string;
  FromPort?: number;
  GroupId?: string;
  GroupName?: string;
  IpPermissions?: IpPermission[];
  IpProtocol?: string;
  SourceSecurityGroupName?: string;
  SourceSecurityGroupOwnerId?: string;
  ToPort?: number;
  DryRun?: boolean;
  SecurityGroupRuleIds?: string[];
}
export interface RevokeSecurityGroupIngressResult {
  Return?: boolean;
  UnknownIpPermissions?: IpPermission[];
}
export interface CpuOptionsRequest {
  CoreCount?: number;
  ThreadsPerCore?: number;
  AmdSevSnp?: AmdSevSnpSpecification;
}
export interface ElasticInferenceAccelerator {
  Type: string | undefined;
  Count?: number;
}
export interface EnclaveOptionsRequest {
  Enabled?: boolean;
}
export interface HibernationOptionsRequest {
  Configured?: boolean;
}
export interface SpotMarketOptions {
  MaxPrice?: string;
  SpotInstanceType?: SpotInstanceType;
  BlockDurationMinutes?: number;
  ValidUntil?: Date;
  InstanceInterruptionBehavior?: InstanceInterruptionBehavior;
}
export interface InstanceMarketOptionsRequest {
  MarketType?: MarketType;
  SpotOptions?: SpotMarketOptions;
}
export interface LaunchTemplateSpecification {
  LaunchTemplateId?: string;
  LaunchTemplateName?: string;
  Version?: string;
}
export interface LicenseConfigurationRequest {
  LicenseConfigurationArn?: string;
}
export interface InstanceMaintenanceOptionsRequest {
  AutoRecovery?: InstanceAutoRecoveryState;
}
export interface InstanceMetadataOptionsRequest {
  HttpTokens?: HttpTokensState;
  HttpPutResponseHopLimit?: number;
  HttpEndpoint?: InstanceMetadataEndpointState;
  HttpProtocolIpv6?: InstanceMetadataProtocolState;
  InstanceMetadataTags?: InstanceMetadataTagsState;
}
export interface PrivateDnsNameOptionsRequest {
  HostnameType?: HostnameType;
  EnableResourceNameDnsARecord?: boolean;
  EnableResourceNameDnsAAAARecord?: boolean;
}
export interface RunInstancesRequest {
  BlockDeviceMappings?: BlockDeviceMapping[];
  ImageId?: string;
  InstanceType?: _InstanceType;
  Ipv6AddressCount?: number;
  Ipv6Addresses?: InstanceIpv6Address[];
  KernelId?: string;
  KeyName?: string;
  MaxCount: number | undefined;
  MinCount: number | undefined;
  Monitoring?: RunInstancesMonitoringEnabled;
  Placement?: Placement;
  RamdiskId?: string;
  SecurityGroupIds?: string[];
  SecurityGroups?: string[];
  SubnetId?: string;
  UserData?: string;
  AdditionalInfo?: string;
  ClientToken?: string;
  DisableApiTermination?: boolean;
  DryRun?: boolean;
  EbsOptimized?: boolean;
  IamInstanceProfile?: IamInstanceProfileSpecification;
  InstanceInitiatedShutdownBehavior?: ShutdownBehavior;
  NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
  PrivateIpAddress?: string;
  ElasticGpuSpecification?: ElasticGpuSpecification[];
  ElasticInferenceAccelerators?: ElasticInferenceAccelerator[];
  TagSpecifications?: TagSpecification[];
  LaunchTemplate?: LaunchTemplateSpecification;
  InstanceMarketOptions?: InstanceMarketOptionsRequest;
  CreditSpecification?: CreditSpecificationRequest;
  CpuOptions?: CpuOptionsRequest;
  CapacityReservationSpecification?: CapacityReservationSpecification;
  HibernationOptions?: HibernationOptionsRequest;
  LicenseSpecifications?: LicenseConfigurationRequest[];
  MetadataOptions?: InstanceMetadataOptionsRequest;
  EnclaveOptions?: EnclaveOptionsRequest;
  PrivateDnsNameOptions?: PrivateDnsNameOptionsRequest;
  MaintenanceOptions?: InstanceMaintenanceOptionsRequest;
  DisableApiStop?: boolean;
  EnablePrimaryIpv6?: boolean;
}
export interface ScheduledInstancesEbs {
  DeleteOnTermination?: boolean;
  Encrypted?: boolean;
  Iops?: number;
  SnapshotId?: string;
  VolumeSize?: number;
  VolumeType?: string;
}
export interface ScheduledInstancesBlockDeviceMapping {
  DeviceName?: string;
  Ebs?: ScheduledInstancesEbs;
  NoDevice?: string;
  VirtualName?: string;
}
export interface ScheduledInstancesIamInstanceProfile {
  Arn?: string;
  Name?: string;
}
export interface ScheduledInstancesMonitoring {
  Enabled?: boolean;
}
export interface ScheduledInstancesIpv6Address {
  Ipv6Address?: string;
}
export interface ScheduledInstancesPrivateIpAddressConfig {
  Primary?: boolean;
  PrivateIpAddress?: string;
}
export interface ScheduledInstancesNetworkInterface {
  AssociatePublicIpAddress?: boolean;
  DeleteOnTermination?: boolean;
  Description?: string;
  DeviceIndex?: number;
  Groups?: string[];
  Ipv6AddressCount?: number;
  Ipv6Addresses?: ScheduledInstancesIpv6Address[];
  NetworkInterfaceId?: string;
  PrivateIpAddress?: string;
  PrivateIpAddressConfigs?: ScheduledInstancesPrivateIpAddressConfig[];
  SecondaryPrivateIpAddressCount?: number;
  SubnetId?: string;
}
export interface ScheduledInstancesPlacement {
  AvailabilityZone?: string;
  GroupName?: string;
}
export interface ScheduledInstancesLaunchSpecification {
  BlockDeviceMappings?: ScheduledInstancesBlockDeviceMapping[];
  EbsOptimized?: boolean;
  IamInstanceProfile?: ScheduledInstancesIamInstanceProfile;
  ImageId: string | undefined;
  InstanceType?: string;
  KernelId?: string;
  KeyName?: string;
  Monitoring?: ScheduledInstancesMonitoring;
  NetworkInterfaces?: ScheduledInstancesNetworkInterface[];
  Placement?: ScheduledInstancesPlacement;
  RamdiskId?: string;
  SecurityGroupIds?: string[];
  SubnetId?: string;
  UserData?: string;
}
export interface RunScheduledInstancesRequest {
  ClientToken?: string;
  DryRun?: boolean;
  InstanceCount?: number;
  LaunchSpecification: ScheduledInstancesLaunchSpecification | undefined;
  ScheduledInstanceId: string | undefined;
}
export interface RunScheduledInstancesResult {
  InstanceIdSet?: string[];
}
export interface SearchLocalGatewayRoutesRequest {
  LocalGatewayRouteTableId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export interface SearchLocalGatewayRoutesResult {
  Routes?: LocalGatewayRoute[];
  NextToken?: string;
}
export interface SearchTransitGatewayMulticastGroupsRequest {
  TransitGatewayMulticastDomainId: string | undefined;
  Filters?: Filter[];
  MaxResults?: number;
  NextToken?: string;
  DryRun?: boolean;
}
export declare const MembershipType: {
  readonly igmp: "igmp";
  readonly static: "static";
};
export type MembershipType =
  (typeof MembershipType)[keyof typeof MembershipType];
export interface TransitGatewayMulticastGroup {
  GroupIpAddress?: string;
  TransitGatewayAttachmentId?: string;
  SubnetId?: string;
  ResourceId?: string;
  ResourceType?: TransitGatewayAttachmentResourceType;
  ResourceOwnerId?: string;
  NetworkInterfaceId?: string;
  GroupMember?: boolean;
  GroupSource?: boolean;
  MemberType?: MembershipType;
  SourceType?: MembershipType;
}
export interface SearchTransitGatewayMulticastGroupsResult {
  MulticastGroups?: TransitGatewayMulticastGroup[];
  NextToken?: string;
}
export interface SearchTransitGatewayRoutesRequest {
  TransitGatewayRouteTableId: string | undefined;
  Filters: Filter[] | undefined;
  MaxResults?: number;
  DryRun?: boolean;
}
export interface SearchTransitGatewayRoutesResult {
  Routes?: TransitGatewayRoute[];
  AdditionalRoutesAvailable?: boolean;
}
export interface SendDiagnosticInterruptRequest {
  InstanceId: string | undefined;
  DryRun?: boolean;
}
export interface StartInstancesRequest {
  InstanceIds: string[] | undefined;
  AdditionalInfo?: string;
  DryRun?: boolean;
}
export interface InstanceStateChange {
  CurrentState?: InstanceState;
  InstanceId?: string;
  PreviousState?: InstanceState;
}
export interface StartInstancesResult {
  StartingInstances?: InstanceStateChange[];
}
export interface StartNetworkInsightsAccessScopeAnalysisRequest {
  NetworkInsightsAccessScopeId: string | undefined;
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
}
export interface StartNetworkInsightsAccessScopeAnalysisResult {
  NetworkInsightsAccessScopeAnalysis?: NetworkInsightsAccessScopeAnalysis;
}
export interface StartNetworkInsightsAnalysisRequest {
  NetworkInsightsPathId: string | undefined;
  AdditionalAccounts?: string[];
  FilterInArns?: string[];
  DryRun?: boolean;
  TagSpecifications?: TagSpecification[];
  ClientToken?: string;
}
export interface StartNetworkInsightsAnalysisResult {
  NetworkInsightsAnalysis?: NetworkInsightsAnalysis;
}
export interface StartVpcEndpointServicePrivateDnsVerificationRequest {
  DryRun?: boolean;
  ServiceId: string | undefined;
}
export interface StartVpcEndpointServicePrivateDnsVerificationResult {
  ReturnValue?: boolean;
}
export interface StopInstancesRequest {
  InstanceIds: string[] | undefined;
  Hibernate?: boolean;
  DryRun?: boolean;
  Force?: boolean;
}
export interface StopInstancesResult {
  StoppingInstances?: InstanceStateChange[];
}
export interface TerminateClientVpnConnectionsRequest {
  ClientVpnEndpointId: string | undefined;
  ConnectionId?: string;
  Username?: string;
  DryRun?: boolean;
}
export interface TerminateConnectionStatus {
  ConnectionId?: string;
  PreviousStatus?: ClientVpnConnectionStatus;
  CurrentStatus?: ClientVpnConnectionStatus;
}
export interface TerminateClientVpnConnectionsResult {
  ClientVpnEndpointId?: string;
  Username?: string;
  ConnectionStatuses?: TerminateConnectionStatus[];
}
export interface TerminateInstancesRequest {
  InstanceIds: string[] | undefined;
  DryRun?: boolean;
}
export interface TerminateInstancesResult {
  TerminatingInstances?: InstanceStateChange[];
}
export interface UnassignIpv6AddressesRequest {
  Ipv6Addresses?: string[];
  Ipv6Prefixes?: string[];
  NetworkInterfaceId: string | undefined;
}
export interface UnassignIpv6AddressesResult {
  NetworkInterfaceId?: string;
  UnassignedIpv6Addresses?: string[];
  UnassignedIpv6Prefixes?: string[];
}
export interface UnassignPrivateIpAddressesRequest {
  NetworkInterfaceId: string | undefined;
  PrivateIpAddresses?: string[];
  Ipv4Prefixes?: string[];
}
export interface UnassignPrivateNatGatewayAddressRequest {
  NatGatewayId: string | undefined;
  PrivateIpAddresses: string[] | undefined;
  MaxDrainDurationSeconds?: number;
  DryRun?: boolean;
}
export interface UnassignPrivateNatGatewayAddressResult {
  NatGatewayId?: string;
  NatGatewayAddresses?: NatGatewayAddress[];
}
export interface UnlockSnapshotRequest {
  SnapshotId: string | undefined;
  DryRun?: boolean;
}
export interface UnlockSnapshotResult {
  SnapshotId?: string;
}
export interface UnmonitorInstancesRequest {
  InstanceIds: string[] | undefined;
  DryRun?: boolean;
}
export interface UnmonitorInstancesResult {
  InstanceMonitorings?: InstanceMonitoring[];
}
export interface SecurityGroupRuleDescription {
  SecurityGroupRuleId?: string;
  Description?: string;
}
export interface UpdateSecurityGroupRuleDescriptionsEgressRequest {
  DryRun?: boolean;
  GroupId?: string;
  GroupName?: string;
  IpPermissions?: IpPermission[];
  SecurityGroupRuleDescriptions?: SecurityGroupRuleDescription[];
}
export interface UpdateSecurityGroupRuleDescriptionsEgressResult {
  Return?: boolean;
}
export interface UpdateSecurityGroupRuleDescriptionsIngressRequest {
  DryRun?: boolean;
  GroupId?: string;
  GroupName?: string;
  IpPermissions?: IpPermission[];
  SecurityGroupRuleDescriptions?: SecurityGroupRuleDescription[];
}
export interface UpdateSecurityGroupRuleDescriptionsIngressResult {
  Return?: boolean;
}
export interface WithdrawByoipCidrRequest {
  Cidr: string | undefined;
  DryRun?: boolean;
}
export interface WithdrawByoipCidrResult {
  ByoipCidr?: ByoipCidr;
}
export declare const RequestSpotFleetRequestFilterSensitiveLog: (
  obj: RequestSpotFleetRequest
) => any;
export declare const RequestSpotLaunchSpecificationFilterSensitiveLog: (
  obj: RequestSpotLaunchSpecification
) => any;
export declare const RequestSpotInstancesRequestFilterSensitiveLog: (
  obj: RequestSpotInstancesRequest
) => any;
export declare const RequestSpotInstancesResultFilterSensitiveLog: (
  obj: RequestSpotInstancesResult
) => any;
export declare const RunInstancesRequestFilterSensitiveLog: (
  obj: RunInstancesRequest
) => any;
export declare const ScheduledInstancesLaunchSpecificationFilterSensitiveLog: (
  obj: ScheduledInstancesLaunchSpecification
) => any;
export declare const RunScheduledInstancesRequestFilterSensitiveLog: (
  obj: RunScheduledInstancesRequest
) => any;
