"""This file contains prompts for CriticAndRefineConvert operations."""

### CRITIQUE PROMPT AND CRITERIA ###
BASE_CRITIQUE_PROMPT = """You are a helpful assistant tasked with critiquing the output of a model based on a given prompt.
Below is the original user prompt used to generate the output:

ORIGINAL PROMPT:
<<original-prompt-placeholder>>

Here is the output generated by the model:

OUTPUT:
{original_output}

Your task is to critique the output based on the following:
{critique_criteria}

{finish_instruction}
"""

# BASE_CRITIQUE_PROMPT = """You are a helpful assistant tasked with critiquing the output of a model based on a given prompt.
# Below is the original user prompt used to generate the output:

# ORIGINAL PROMPT:
# {user_prompt}

# Here is the output generated by the model:

# OUTPUT:
# {original_output}

# Your task is to critique the output based on the following:
# {critique_criteria}

# {finish_instruction}
# """

# COT_BOOL_CRITIQUE_CRITERIA = """1. Does the output adhere to the required TRUE or FALSE format?
# 2. Is the reasoning provided logically sound and well-supported by the context?
# 3. Are there any errors in applying the filter condition to the given context?
# """

# COT_BOOL_IMAGE_CRITIQUE_CRITERIA = """1. Does the output adhere to the required TRUE or FALSE format?
# 2. Is the reasoning provided logically sound and well-supported by the image(s) and/or text?
# 3. Are there any errors in applying the filter condition to the given context?
# """

COT_QA_CRITIQUE_CRITERIA = """1. Does the JSON object adhere to the required format? Highlight any structural issues.
2. Are the values of the output fields accurate based on the provided context? If any fields are incorrect or missing, provide specific examples.
3. Are there any logical errors in reasoning used to derive the output? Provide detailed feedback on potential mistakes.
"""

COT_QA_IMAGE_CRITIQUE_CRITERIA = """1. Does the JSON object adhere to the required format?
2. Are the values of the output fields accurate based on the provided image(s) and/or text?
3. Are there any logical errors in the model's reasoning when extracting information from images and text?
"""

# COT_BO0L_CRITIQUE_FINISH_INSTRUCTION = """Finish your critique with actionable recommendations for improving the model's reasoning and answer format."""
COT_QA_CRITIQUE_FINISH_INSTRUCTION = """Finish your critique with actionable recommendations for improving the JSON object."""


### REFINEMENT PROMPT AND CRITERIA ###
BASE_REFINEMENT_PROMPT = """You are a helpful assistant tasked with refining the output of a model based on a critique.
Below is the original user prompt used to generate the output:

ORIGINAL PROMPT:
<<original-prompt-placeholder>>

Here is the original output generated by the model:

OUTPUT:
{original_output}

Here is the critique of the output:

CRITIQUE:
{critique_output}

Your task is to refine the original output to address the critique. Ensure that:
{refinement_criteria}

{finish_instruction}
"""

# BASE_REFINEMENT_PROMPT = """You are a helpful assistant tasked with refining the output of a model based on a critique.
# Below is the original user prompt used to generate the output:

# ORIGINAL PROMPT:
# {user_prompt}

# Here is the output generated by the model:

# OUTPUT:
# {original_output}

# Here is the critique of the output:

# CRITIQUE:
# {critique_output}

# Your task is to refine the original output to address the critique. Ensure that:
# {refinement_criteria}

# {finish_instruction}
# """

# COT_BOOL_REFINEMENT_CRITERIA = """1. The answer adheres to the required TRUE or FALSE format.
# 2. The reasoning is logically sound and supported by the given context.
# 3. The filter condition is correctly applied.
# """

# COT_BOOL_IMAGE_REFINEMENT_CRITERIA = """1. The answer adheres to the required TRUE or FALSE format.
# 2. The reasoning correctly considers the image(s) and/or text provided in the context.
# 3. The filter condition is properly applied.
# """

COT_QA_REFINEMENT_CRITERIA = """1. The answer adheres to the required JSON format specified in the original prompt.
2. Correctly derives all values for the output fields based on the provided context.
3. Resolves any logical errors identified in the critique.
"""

COT_QA_IMAGE_REFINEMENT_CRITERIA = """1. The answer adheres to the required JSON format specified in the original prompt.
2. Correctly derives all values for the output fields based on the provided image(s) and/or text.
3. Resolves any logical errors identified in the critique.
"""

# COT_BO0L_REFINEMENT_FINISH_INSTRUCTION = """Return the improved answer."""
COT_QA_REFINEMENT_FINISH_INSTRUCTION = """Return the refined JSON object as your final answer."""


### PROMPTS FOR MOA + CRITIC; WHICH ARE BEING DEFERRED FOR NOW ###
# COT_MOA_AGG_BASE_SYSTEM_PROMPT_CRITIQUE = """You are a helpful assistant tasked with reviewing the output of a model based on a given prompt.
# Below is the original user prompt used to generate the output:

# USER PROMPT:
# {user_prompt}

# Here is the synthesized JSON object generated by the model:

# OUTPUT:
# {original_output}

# Your task is to critique the output based on the following:
# 1. Does the JSON object adhere to the required format?
# 2. Does the synthesis appropriately combine responses from multiple models, resolving conflicts where necessary?
# 3. Are there any biases, inaccuracies, or missing information in the final output?

# Finish your critique with actionable recommendations for improving the synthesized response.
# """

# COT_MOA_AGG_BASE_SYSTEM_PROMPT_REFINEMENT = """You are a helpful assistant tasked with refining the output of a model based on a critique.
# Below is the original user prompt used to generate the output:

# USER PROMPT:
# {user_prompt}

# Here is the original synthesized JSON object generated by the model:

# ORIGINAL OUTPUT:
# {original_output}

# Here is the critique of the output:

# CRITIQUE:
# {critique_output}

# Your task is to refine the synthesized JSON object based on the critique. Ensure that:
# 1. The JSON object adheres to the required format.
# 2. The synthesis properly reconciles different model responses, making informed decisions on conflicts.
# 3. The final output is accurate, unbiased, and complete.

# Return the improved JSON object.
# """

# COT_MOA_PROPOSER_BASE_SYSTEM_PROMPT_CRITIQUE = """You are a helpful assistant tasked with reviewing the output of a model based on a given prompt.
# Below is the original user prompt used to generate the output:

# USER PROMPT:
# {user_prompt}

# Here is the response generated by the model:

# OUTPUT:
# {original_output}

# Your task is to critique the output based on the following:
# 1. Is the response well-structured and does it clearly explain each output field?
# 2. Are all claims supported by the provided context? Identify any instances of hallucination or missing evidence.
# 3. Does the response cite specific parts of the context when making claims?

# Finish your critique with actionable recommendations for improving the response.
# """

# COT_MOA_PROPOSER_BASE_SYSTEM_PROMPT_REFINEMENT = """You are a helpful assistant tasked with refining the output of a model based on a critique.
# Below is the original user prompt used to generate the output:

# USER PROMPT:
# {user_prompt}

# Here is the original response generated by the model:

# ORIGINAL OUTPUT:
# {original_output}

# Here is the critique of the output:

# CRITIQUE:
# {critique_output}

# Your task is to refine the response based on the critique. Ensure that:
# 1. The response is well-structured and clearly explains each output field.
# 2. All claims are directly supported by the provided context.
# 3. The response explicitly cites relevant parts of the context.

# Return the improved response.
# """
