# Define variables by aggregation method
sum_vars = [
    "tp",
    "total_precipitation",
    "cp",
    "convective_precipitation",
    "lsp",
    "large_scale_precipitation",
    "sf",
    "snowfall",
    "csf",
    "convective_snowfall",
    "lsf",
    "large_scale_snowfall",
    "ssr",
    "surface_net_solar_radiation",
    "str",
    "surface_net_thermal_radiation",
    "tsr",
    "top_net_solar_radiation",
    "ttr",
    "top_net_thermal_radiation",
    "ssrd",
    "surface_solar_radiation_downward",
    "strd",
    "surface_thermal_radiation_downward",
    "tisr",
    "toa_incident_solar_radiation",
    "slhf",
    "surface_latent_heat_flux",
    "sshf",
    "surface_sensible_heat_flux",
    "ewss",
    "eastward_turbulent_surface_stress",
    "nsss",
    "northward_turbulent_surface_stress",
    "ro",
    "runoff",
    "sro",
    "surface_runoff",
    "ssro",
    "sub_surface_runoff",
    "e",
    "evaporation",
    "pev",
    "potential_evaporation",
    "es",
    "snow_evaporation",
    "smlt",
    "snowmelt",
    "bld",
    "boundary_layer_dissipation",
    "gwd",
    "gravity_wave_dissipation",
    "cdir",
    "clear_sky_direct_solar_radiation",
    "uvb",
    "downward_uv_radiation",
    "lgws",
    "eastward_gravity_wave_surface_stress",
    "lspf",
    "large_scale_precipitation_fraction",
    "mgws",
    "meridional_gravity_wave_surface_stress",
    "ssrc",
    "surface_net_solar_radiation_clear_sky",
    "strc",
    "surface_net_thermal_radiation_clear_sky",
    "ssrdc",
    "surface_solar_radiation_downward_clear_sky",
    "strdc",
    "surface_thermal_radiation_downward_clear_sky",
    "tsrc",
    "top_net_solar_radiation_clear_sky",
    "ttrc",
    "top_net_thermal_radiation_clear_sky",
    "fdir",
    "total_sky_direct_solar_radiation",
    "vimd",
    "vertically_integrated_moisture_divergence",
]

# Variables that should use max aggregation
max_vars = [
    "mx2t",
    "maximum_2m_temperature",
    "mxtpr",
    "maximum_total_precipitation_rate",
    "fg10",
    "10m_wind_gust",
    "hmax",
    "maximum_individual_wave_height",
]

# Variables that should use min aggregation
min_vars = [
    "mn2t",
    "minimum_2m_temperature",
    "mntpr",
    "minimum_total_precipitation_rate",
]

# Rate variables that should be averaged when temporally aggregating
rate_vars = [
    "avg_tprate",
    "average_total_precipitation_rate",
    "avg_cpr",
    "average_convective_precipitation_rate",
    "avg_lsprate",
    "average_large_scale_precipitation_rate",
    "avg_sfrate",
    "average_snowfall_rate",
    "crr",
    "convective_rain_rate",
    "lsrr",
    "large_scale_rain_rate",
    "csfr",
    "convective_snowfall_rate",
    "lssfr",
    "large_scale_snowfall_rate",
    "avg_ibld",
    "average_boundary_layer_dissipation",
    "avg_iegwss",
    "average_eastward_gravity_wave_surface_stress",
    "avg_iews",
    "average_eastward_turbulent_surface_stress",
    "avg_ie",
    "average_evaporation_rate",
    "avg_igwd",
    "average_gravity_wave_dissipation",
    "avg_ilspf",
    "average_large_scale_precipitation_fraction",
    "avg_ingwss",
    "average_northward_gravity_wave_surface_stress",
    "avg_inss",
    "average_northward_turbulent_surface_stress",
    "avg_pevr",
    "average_potential_evaporation_rate",
    "avg_rorwe",
    "average_runoff_rate",
    "avg_esrwe",
    "average_snow_evaporation_rate",
    "avg_tsrwe",
    "average_snowfall_rate",
    "avg_smr",
    "average_snowmelt_rate",
    "avg_ssurfror",
    "average_sub_surface_runoff_rate",
    "avg_sdirswrf",
    "average_surface_direct_shortwave_radiation_flux",
    "avg_sdirswrfcs",
    "average_surface_direct_shortwave_radiation_flux_clear_sky",
    "avg_sdlwrf",
    "average_surface_downward_long_wave_radiation_flux",
    "avg_sdlwrfcs",
    "average_surface_downward_long_wave_radiation_flux_clear_sky",
    "avg_sdswrf",
    "average_surface_downward_shortwave_radiation_flux",
    "avg_sdswrfcs",
    "average_surface_downward_shortwave_radiation_flux_clear_sky",
    "avg_sduvrf",
    "average_surface_downward_uv_radiation_flux",
    "avg_slhtf",
    "average_surface_latent_heat_flux",
    "avg_snlwrf",
    "average_surface_net_long_wave_radiation_flux",
    "avg_snlwrfcs",
    "average_surface_net_long_wave_radiation_flux_clear_sky",
    "avg_snswrf",
    "average_surface_net_shortwave_radiation_flux",
    "avg_snswrfcs",
    "average_surface_net_shortwave_radiation_flux_clear_sky",
    "avg_surfror",
    "average_surface_runoff_rate",
    "avg_ishf",
    "average_surface_sensible_heat_flux",
    "avg_tdswrf",
    "average_top_downward_shortwave_radiation_flux",
    "avg_tnlwrf",
    "average_top_net_long_wave_radiation_flux",
    "avg_tnlwrfcs",
    "average_top_net_long_wave_radiation_flux_clear_sky",
    "avg_tnswrf",
    "average_top_net_shortwave_radiation_flux",
    "avg_tnswrfcs",
    "average_top_net_shortwave_radiation_flux_clear_sky",
    "avg_vimdf",
    "average_vertically_integrated_moisture_divergence",
]

# Non-data columns that should be excluded from aggregation
exclude_cols = {
    "latitude",
    "longitude",
    "date",
    "time",
    "hour",
    "expver",
    "number",
    "valid_time",
}
